/************************************************************************************

	AstroMenace (Hardcore 3D space shooter with spaceship upgrade possibilities)
	Copyright © 2006-2013 Michael Kurinnoy, Viewizard


	AstroMenace is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	AstroMenace is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with AstroMenace. If not, see <http://www.gnu.org/licenses/>.


	Web Site: http://www.viewizard.com/
	Project: http://sourceforge.net/projects/openastromenace/
	E-mail: viewizard@viewizard.com

*************************************************************************************/


// This is "Fake" Mersenne Twister random number generator C++ class MTRand
// AstroMenace game don't really need random number generator, so, we use 10000 pre-generated random numbers.
// You can download source code of Mersenne Twister random number generator C++ class MTRand from:
// http://sourceforge.net/p/openastromenace/code/218/tree/AstroMenaceSource/Core/Math/MersenneTwister.h
// and replace this MersenneTwister.h file.
// Please note, Mersenne Twister random number generator released under BSD license.



#ifndef MERSENNETWISTER_H
#define MERSENNETWISTER_H


#include <time.h>

const unsigned int vwRandQuantity = 10000;
static const float vwRand[vwRandQuantity] = {
0.265470f, 0.614714f, 0.909581f, 0.127959f, 0.731053f, 0.058393f, 0.936853f, 0.933848f, 0.262249f, 0.205447f,
0.375524f, 0.205734f, 0.946350f, 0.170073f, 0.516885f, 0.294306f, 0.555635f, 0.439837f, 0.747495f, 0.343839f,
0.449151f, 0.526366f, 0.820151f, 0.357012f, 0.751077f, 0.393814f, 0.976011f, 0.362202f, 0.270321f, 0.895989f,
0.002061f, 0.949662f, 0.730297f, 0.897320f, 0.526736f, 0.226212f, 0.295717f, 0.845289f, 0.626904f, 0.904211f,
0.532939f, 0.363768f, 0.685970f, 0.359009f, 0.311109f, 0.020737f, 0.916662f, 0.342340f, 0.946320f, 0.007541f,
0.872914f, 0.738820f, 0.670299f, 0.947558f, 0.674401f, 0.820033f, 0.128077f, 0.305891f, 0.545926f, 0.083781f,
0.684644f, 0.101590f, 0.268980f, 0.095398f, 0.095257f, 0.424102f, 0.422504f, 0.900738f, 0.207496f, 0.659989f,
0.798254f, 0.404067f, 0.586506f, 0.045581f, 0.295577f, 0.464027f, 0.927112f, 0.251556f, 0.551686f, 0.617653f,
0.500481f, 0.556098f, 0.752460f, 0.698560f, 0.647141f, 0.644020f, 0.777587f, 0.301534f, 0.581026f, 0.423705f,
0.778457f, 0.070817f, 0.544809f, 0.619763f, 0.676754f, 0.127058f, 0.835924f, 0.715144f, 0.041383f, 0.821382f,
0.008130f, 0.453704f, 0.518933f, 0.679199f, 0.974325f, 0.761260f, 0.509027f, 0.021165f, 0.451643f, 0.097186f,
0.067021f, 0.489838f, 0.296557f, 0.884918f, 0.745985f, 0.195202f, 0.622984f, 0.089223f, 0.362550f, 0.933718f,
0.260968f, 0.597343f, 0.111922f, 0.961819f, 0.703685f, 0.305410f, 0.110588f, 0.502257f, 0.836446f, 0.709235f,
0.340629f, 0.984960f, 0.635911f, 0.566472f, 0.887550f, 0.875744f, 0.460668f, 0.201912f, 0.654746f, 0.296874f,
0.715537f, 0.530074f, 0.144274f, 0.595232f, 0.133151f, 0.719539f, 0.581668f, 0.886942f, 0.898477f, 0.027581f,
0.018269f, 0.418575f, 0.777782f, 0.874545f, 0.545937f, 0.483905f, 0.351048f, 0.964892f, 0.067282f, 0.979362f,
0.265408f, 0.550108f, 0.134130f, 0.265091f, 0.608062f, 0.274227f, 0.681871f, 0.045780f, 0.148575f, 0.074305f,
0.246528f, 0.783550f, 0.067713f, 0.190398f, 0.642063f, 0.874918f, 0.427280f, 0.754857f, 0.221930f, 0.515805f,
0.292483f, 0.348980f, 0.412472f, 0.606063f, 0.848046f, 0.434683f, 0.850047f, 0.989062f, 0.369482f, 0.045718f,
0.871171f, 0.965331f, 0.796410f, 0.101604f, 0.073492f, 0.847421f, 0.736530f, 0.915936f, 0.927637f, 0.429220f,
0.052649f, 0.487214f, 0.976983f, 0.405525f, 0.914350f, 0.558723f, 0.211129f, 0.378492f, 0.750426f, 0.233127f,
0.080673f, 0.793245f, 0.289101f, 0.684709f, 0.356148f, 0.530423f, 0.557595f, 0.445039f, 0.945571f, 0.270892f,
0.830812f, 0.128967f, 0.104416f, 0.343961f, 0.809472f, 0.689115f, 0.746466f, 0.424654f, 0.461779f, 0.350284f,
0.057936f, 0.829154f, 0.309609f, 0.584351f, 0.666417f, 0.897719f, 0.693496f, 0.744797f, 0.634787f, 0.400752f,
0.918003f, 0.722359f, 0.629946f, 0.623023f, 0.033082f, 0.704812f, 0.932402f, 0.581968f, 0.024696f, 0.404577f,
0.493092f, 0.495590f, 0.298956f, 0.821469f, 0.145307f, 0.674068f, 0.212704f, 0.385646f, 0.992568f, 0.227284f,
0.553615f, 0.914312f, 0.588519f, 0.800745f, 0.680015f, 0.368833f, 0.066714f, 0.409927f, 0.248245f, 0.097775f,
0.207768f, 0.954416f, 0.656422f, 0.607742f, 0.630093f, 0.842926f, 0.803539f, 0.773825f, 0.263798f, 0.360521f,
0.335252f, 0.162979f, 0.587123f, 0.834323f, 0.226105f, 0.911169f, 0.853390f, 0.675434f, 0.007844f, 0.853160f,
0.356853f, 0.808662f, 0.151230f, 0.469997f, 0.910633f, 0.324216f, 0.966481f, 0.274479f, 0.622698f, 0.937529f,
0.683532f, 0.928693f, 0.105838f, 0.594397f, 0.431208f, 0.421757f, 0.306591f, 0.660635f, 0.414597f, 0.402811f,
0.998868f, 0.563671f, 0.081262f, 0.621887f, 0.353709f, 0.957866f, 0.766662f, 0.646529f, 0.363341f, 0.407633f,
0.738288f, 0.788332f, 0.437628f, 0.740367f, 0.309053f, 0.464721f, 0.117035f, 0.640816f, 0.548366f, 0.134082f,
0.914017f, 0.175570f, 0.767127f, 0.503739f, 0.262580f, 0.655633f, 0.645754f, 0.967783f, 0.249282f, 0.147367f,
0.475740f, 0.291165f, 0.059603f, 0.732727f, 0.184881f, 0.391479f, 0.856335f, 0.741810f, 0.601748f, 0.097155f,
0.004528f, 0.024337f, 0.933705f, 0.176154f, 0.668202f, 0.030082f, 0.241034f, 0.491790f, 0.934658f, 0.885188f,
0.057982f, 0.116904f, 0.832119f, 0.416978f, 0.051068f, 0.639687f, 0.544129f, 0.346768f, 0.008420f, 0.698584f,
0.107464f, 0.085773f, 0.118613f, 0.433309f, 0.350029f, 0.278690f, 0.916686f, 0.715326f, 0.241545f, 0.716577f,
0.684806f, 0.780774f, 0.244643f, 0.551508f, 0.833313f, 0.026052f, 0.094578f, 0.158151f, 0.213272f, 0.916240f,
0.901201f, 0.672840f, 0.256099f, 0.086577f, 0.486461f, 0.487898f, 0.272020f, 0.182682f, 0.112739f, 0.259876f,
0.617986f, 0.763483f, 0.912741f, 0.836861f, 0.850726f, 0.798920f, 0.709715f, 0.152749f, 0.603418f, 0.874917f,
0.288059f, 0.684473f, 0.671837f, 0.198095f, 0.248386f, 0.218385f, 0.895429f, 0.500489f, 0.076436f, 0.032140f,
0.986651f, 0.801655f, 0.910566f, 0.051503f, 0.166394f, 0.523691f, 0.385740f, 0.989986f, 0.599681f, 0.939819f,
0.187351f, 0.702084f, 0.647057f, 0.531043f, 0.033758f, 0.866377f, 0.854283f, 0.439938f, 0.019675f, 0.151261f,
0.891179f, 0.914643f, 0.425245f, 0.100470f, 0.537519f, 0.252322f, 0.521373f, 0.795394f, 0.218237f, 0.540543f,
0.239645f, 0.922635f, 0.622422f, 0.596410f, 0.765991f, 0.667257f, 0.922596f, 0.633890f, 0.009083f, 0.337908f,
0.850332f, 0.887014f, 0.221635f, 0.178326f, 0.982456f, 0.505550f, 0.530202f, 0.614074f, 0.709182f, 0.581889f,
0.331846f, 0.769468f, 0.788560f, 0.892771f, 0.790258f, 0.847252f, 0.533247f, 0.857607f, 0.653454f, 0.548030f,
0.657306f, 0.170395f, 0.509886f, 0.117873f, 0.239816f, 0.959627f, 0.627370f, 0.777256f, 0.276906f, 0.006714f,
0.642780f, 0.432230f, 0.272047f, 0.257203f, 0.280163f, 0.327585f, 0.259746f, 0.286764f, 0.759797f, 0.317310f,
0.157905f, 0.638084f, 0.087574f, 0.243429f, 0.947357f, 0.522730f, 0.416506f, 0.015306f, 0.836868f, 0.555486f,
0.397520f, 0.200078f, 0.360220f, 0.683371f, 0.944933f, 0.091007f, 0.431872f, 0.542694f, 0.569643f, 0.343148f,
0.652202f, 0.196899f, 0.373744f, 0.117615f, 0.886836f, 0.320828f, 0.643705f, 0.801178f, 0.590181f, 0.696677f,
0.007644f, 0.044393f, 0.090499f, 0.400818f, 0.605063f, 0.989849f, 0.006689f, 0.339396f, 0.218168f, 0.339621f,
0.309541f, 0.048198f, 0.927388f, 0.171774f, 0.467594f, 0.277991f, 0.040316f, 0.801386f, 0.447674f, 0.520086f,
0.738246f, 0.709288f, 0.840469f, 0.862632f, 0.319962f, 0.973941f, 0.119271f, 0.055999f, 0.778743f, 0.690038f,
0.488531f, 0.255403f, 0.534343f, 0.936439f, 0.120571f, 0.707109f, 0.451248f, 0.495218f, 0.878878f, 0.809161f,
0.103268f, 0.446111f, 0.789528f, 0.334031f, 0.850568f, 0.713053f, 0.843573f, 0.531592f, 0.612238f, 0.671409f,
0.394159f, 0.941429f, 0.767167f, 0.093644f, 0.028612f, 0.903121f, 0.182855f, 0.216125f, 0.340410f, 0.315936f,
0.161381f, 0.227142f, 0.636741f, 0.200773f, 0.721752f, 0.042417f, 0.063375f, 0.547390f, 0.320528f, 0.242886f,
0.938317f, 0.244247f, 0.849273f, 0.977752f, 0.977224f, 0.575560f, 0.818371f, 0.427060f, 0.804069f, 0.567052f,
0.030186f, 0.061601f, 0.282448f, 0.880628f, 0.824504f, 0.613618f, 0.035070f, 0.278982f, 0.386090f, 0.584209f,
0.339677f, 0.272532f, 0.219167f, 0.289713f, 0.540430f, 0.066004f, 0.542755f, 0.095882f, 0.888094f, 0.855479f,
0.642555f, 0.453657f, 0.621941f, 0.349890f, 0.429625f, 0.463776f, 0.623730f, 0.629167f, 0.891862f, 0.760764f,
0.632685f, 0.266434f, 0.073819f, 0.887862f, 0.417971f, 0.562088f, 0.267060f, 0.612729f, 0.481204f, 0.812701f,
0.986081f, 0.813959f, 0.258945f, 0.694961f, 0.276356f, 0.126573f, 0.476963f, 0.046499f, 0.421064f, 0.825617f,
0.814476f, 0.647465f, 0.974683f, 0.836246f, 0.388091f, 0.844721f, 0.360204f, 0.706213f, 0.234827f, 0.527526f,
0.087775f, 0.377936f, 0.291156f, 0.296599f, 0.304129f, 0.421334f, 0.767538f, 0.032195f, 0.674887f, 0.883615f,
0.438279f, 0.624711f, 0.218003f, 0.793680f, 0.368776f, 0.254837f, 0.528329f, 0.561305f, 0.852656f, 0.267231f,
0.206581f, 0.243680f, 0.997841f, 0.856143f, 0.184968f, 0.063668f, 0.209508f, 0.396554f, 0.768784f, 0.277381f,
0.363523f, 0.441506f, 0.100285f, 0.819223f, 0.621287f, 0.882610f, 0.878083f, 0.896450f, 0.468142f, 0.172387f,
0.925587f, 0.906834f, 0.079327f, 0.959103f, 0.987745f, 0.519625f, 0.044160f, 0.942372f, 0.599345f, 0.358660f,
0.429146f, 0.264493f, 0.585472f, 0.056739f, 0.291630f, 0.553746f, 0.427468f, 0.640840f, 0.989883f, 0.890574f,
0.976432f, 0.464880f, 0.113176f, 0.586571f, 0.026355f, 0.511652f, 0.328626f, 0.471003f, 0.308850f, 0.260379f,
0.147069f, 0.705695f, 0.881198f, 0.562240f, 0.709072f, 0.305379f, 0.099361f, 0.801865f, 0.552199f, 0.566311f,
0.379168f, 0.131210f, 0.164692f, 0.261435f, 0.307048f, 0.734007f, 0.185599f, 0.518413f, 0.514676f, 0.234983f,
0.192202f, 0.939112f, 0.536444f, 0.474069f, 0.104046f, 0.439368f, 0.771125f, 0.763719f, 0.341124f, 0.773943f,
0.377525f, 0.258063f, 0.914489f, 0.971321f, 0.881970f, 0.623190f, 0.052959f, 0.769898f, 0.122854f, 0.954434f,
0.593438f, 0.748784f, 0.510447f, 0.230406f, 0.142674f, 0.557733f, 0.921799f, 0.760311f, 0.743202f, 0.343514f,
0.804531f, 0.509997f, 0.635038f, 0.549286f, 0.752890f, 0.829721f, 0.395944f, 0.175454f, 0.184349f, 0.340319f,
0.640064f, 0.998955f, 0.399403f, 0.666113f, 0.121847f, 0.002322f, 0.803489f, 0.698724f, 0.133475f, 0.388846f,
0.393258f, 0.838934f, 0.178710f, 0.797854f, 0.325961f, 0.494169f, 0.789556f, 0.325352f, 0.801281f, 0.715100f,
0.858712f, 0.529227f, 0.800578f, 0.234003f, 0.104458f, 0.898840f, 0.465869f, 0.224739f, 0.047984f, 0.700804f,
0.511401f, 0.499983f, 0.590484f, 0.118507f, 0.091954f, 0.185490f, 0.076474f, 0.209149f, 0.978609f, 0.341857f,
0.204079f, 0.423080f, 0.991539f, 0.829875f, 0.640462f, 0.395681f, 0.718009f, 0.685766f, 0.398783f, 0.956152f,
0.966297f, 0.353903f, 0.539076f, 0.947754f, 0.670423f, 0.133562f, 0.794965f, 0.168333f, 0.001055f, 0.839111f,
0.365590f, 0.172073f, 0.553624f, 0.257472f, 0.910359f, 0.037925f, 0.391656f, 0.721828f, 0.144709f, 0.136955f,
0.653145f, 0.095657f, 0.937105f, 0.299301f, 0.107674f, 0.721250f, 0.008045f, 0.011219f, 0.467118f, 0.534880f,
0.359659f, 0.208433f, 0.426028f, 0.881877f, 0.719297f, 0.311875f, 0.929684f, 0.886318f, 0.270546f, 0.786798f,
0.645909f, 0.183734f, 0.919421f, 0.290784f, 0.314158f, 0.531180f, 0.124782f, 0.377914f, 0.422360f, 0.302429f,
0.463628f, 0.330972f, 0.290498f, 0.541384f, 0.049142f, 0.330039f, 0.278132f, 0.605763f, 0.435837f, 0.278075f,
0.894253f, 0.586039f, 0.515718f, 0.804063f, 0.405140f, 0.242296f, 0.177228f, 0.092407f, 0.481826f, 0.929850f,
0.484034f, 0.497515f, 0.598300f, 0.508728f, 0.907563f, 0.602098f, 0.747844f, 0.530112f, 0.598772f, 0.413545f,
0.698003f, 0.220134f, 0.417598f, 0.295247f, 0.158185f, 0.601174f, 0.768869f, 0.842501f, 0.686718f, 0.377473f,
0.320639f, 0.621852f, 0.980062f, 0.723097f, 0.941613f, 0.975693f, 0.410860f, 0.980900f, 0.920617f, 0.827034f,
0.704506f, 0.233902f, 0.176567f, 0.382177f, 0.572714f, 0.536277f, 0.337447f, 0.847287f, 0.461955f, 0.254670f,
0.479035f, 0.389323f, 0.580473f, 0.892598f, 0.111326f, 0.255035f, 0.664059f, 0.161642f, 0.738507f, 0.335294f,
0.554433f, 0.942872f, 0.152001f, 0.678371f, 0.226121f, 0.409681f, 0.576344f, 0.341351f, 0.916984f, 0.576171f,
0.710175f, 0.028659f, 0.145954f, 0.281088f, 0.822503f, 0.295118f, 0.386674f, 0.219259f, 0.830261f, 0.868467f,
0.262352f, 0.866268f, 0.368585f, 0.340213f, 0.967062f, 0.865722f, 0.677966f, 0.337082f, 0.952001f, 0.320902f,
0.176668f, 0.166162f, 0.320055f, 0.856896f, 0.605103f, 0.389981f, 0.651943f, 0.624501f, 0.328098f, 0.857836f,
0.324169f, 0.616340f, 0.607638f, 0.492222f, 0.826115f, 0.539272f, 0.432010f, 0.572519f, 0.784646f, 0.462243f,
0.857663f, 0.826665f, 0.268820f, 0.056624f, 0.934427f, 0.558723f, 0.664144f, 0.930722f, 0.482839f, 0.110138f,
0.356809f, 0.760758f, 0.439762f, 0.732237f, 0.588526f, 0.456340f, 0.703681f, 0.856450f, 0.155040f, 0.730114f,
0.241422f, 0.124461f, 0.318154f, 0.006823f, 0.187686f, 0.723372f, 0.167707f, 0.849005f, 0.981253f, 0.616512f,
0.294987f, 0.921283f, 0.376149f, 0.583518f, 0.131215f, 0.757026f, 0.541398f, 0.803773f, 0.811945f, 0.356265f,
0.150537f, 0.296712f, 0.893102f, 0.982649f, 0.994044f, 0.722697f, 0.086592f, 0.711745f, 0.743767f, 0.218070f,
0.866367f, 0.708599f, 0.769863f, 0.525142f, 0.796700f, 0.394595f, 0.055026f, 0.965639f, 0.107526f, 0.645841f,
0.950496f, 0.801438f, 0.851137f, 0.289179f, 0.704685f, 0.727614f, 0.417128f, 0.455525f, 0.497363f, 0.585462f,
0.813047f, 0.269126f, 0.996879f, 0.996347f, 0.294934f, 0.663862f, 0.193590f, 0.335642f, 0.727038f, 0.218366f,
0.357500f, 0.817274f, 0.830627f, 0.767703f, 0.031488f, 0.821543f, 0.197447f, 0.091857f, 0.599952f, 0.964655f,
0.831529f, 0.659687f, 0.881084f, 0.518814f, 0.382220f, 0.400404f, 0.258946f, 0.372508f, 0.199761f, 0.143497f,
0.331882f, 0.671244f, 0.915167f, 0.028124f, 0.060075f, 0.359615f, 0.279169f, 0.015810f, 0.075520f, 0.499857f,
0.875508f, 0.992345f, 0.143993f, 0.761345f, 0.999146f, 0.237921f, 0.810126f, 0.920304f, 0.615038f, 0.629229f,
0.994914f, 0.738344f, 0.601080f, 0.060141f, 0.835519f, 0.081760f, 0.448685f, 0.671223f, 0.077765f, 0.350515f,
0.942376f, 0.443193f, 0.664181f, 0.297518f, 0.463259f, 0.816594f, 0.400992f, 0.027467f, 0.511098f, 0.114479f,
0.764723f, 0.824028f, 0.326177f, 0.968700f, 0.283103f, 0.406470f, 0.313902f, 0.085681f, 0.385103f, 0.791925f,
0.794390f, 0.833534f, 0.824791f, 0.351588f, 0.352262f, 0.416233f, 0.031695f, 0.928519f, 0.549902f, 0.264315f,
0.715945f, 0.757184f, 0.717332f, 0.504443f, 0.319925f, 0.472471f, 0.887409f, 0.329607f, 0.164339f, 0.564678f,
0.107738f, 0.289398f, 0.112293f, 0.034454f, 0.155344f, 0.733926f, 0.324898f, 0.661449f, 0.714904f, 0.474319f,
0.448686f, 0.589990f, 0.276497f, 0.780540f, 0.537048f, 0.487560f, 0.526435f, 0.655268f, 0.195204f, 0.364338f,
0.158369f, 0.364631f, 0.806315f, 0.222963f, 0.605925f, 0.005937f, 0.683037f, 0.131256f, 0.396509f, 0.465690f,
0.565343f, 0.931168f, 0.395383f, 0.573073f, 0.823951f, 0.175711f, 0.720146f, 0.446036f, 0.780640f, 0.983641f,
0.295420f, 0.342895f, 0.952376f, 0.856041f, 0.085882f, 0.101116f, 0.757518f, 0.546706f, 0.160167f, 0.998425f,
0.369076f, 0.510717f, 0.436815f, 0.548707f, 0.579966f, 0.283778f, 0.547414f, 0.746534f, 0.857410f, 0.741775f,
0.588962f, 0.537781f, 0.586868f, 0.095163f, 0.911336f, 0.473743f, 0.117081f, 0.345542f, 0.161653f, 0.461916f,
0.069523f, 0.361485f, 0.441527f, 0.011588f, 0.383712f, 0.514314f, 0.296968f, 0.829938f, 0.775643f, 0.372167f,
0.077047f, 0.875838f, 0.404888f, 0.576593f, 0.130571f, 0.668741f, 0.824767f, 0.890837f, 0.449036f, 0.453364f,
0.441539f, 0.125104f, 0.121710f, 0.123534f, 0.323512f, 0.729041f, 0.481296f, 0.912380f, 0.854557f, 0.894082f,
0.333323f, 0.364229f, 0.415946f, 0.790938f, 0.025883f, 0.140624f, 0.554094f, 0.852882f, 0.070389f, 0.316206f,
0.427371f, 0.833767f, 0.607289f, 0.748318f, 0.941849f, 0.878024f, 0.012310f, 0.066753f, 0.758110f, 0.310157f,
0.000333f, 0.520010f, 0.960900f, 0.626294f, 0.295132f, 0.142310f, 0.714101f, 0.876750f, 0.820764f, 0.585000f,
0.571950f, 0.778507f, 0.404628f, 0.607411f, 0.468535f, 0.440172f, 0.549961f, 0.398486f, 0.340390f, 0.376661f,
0.548028f, 0.921808f, 0.987954f, 0.235552f, 0.368053f, 0.138358f, 0.728343f, 0.276460f, 0.571211f, 0.262398f,
0.480684f, 0.925435f, 0.753570f, 0.194078f, 0.545534f, 0.534794f, 0.327223f, 0.936035f, 0.266697f, 0.339075f,
0.531931f, 0.268936f, 0.001209f, 0.166070f, 0.377590f, 0.539732f, 0.382402f, 0.032259f, 0.815001f, 0.807891f,
0.904449f, 0.792144f, 0.221499f, 0.271094f, 0.455600f, 0.321538f, 0.107242f, 0.785011f, 0.245198f, 0.944517f,
0.414764f, 0.100868f, 0.565993f, 0.622612f, 0.563454f, 0.140961f, 0.725722f, 0.092862f, 0.551386f, 0.894376f,
0.707438f, 0.002078f, 0.806628f, 0.022332f, 0.225914f, 0.178033f, 0.627611f, 0.753632f, 0.844287f, 0.084468f,
0.723127f, 0.196544f, 0.434777f, 0.438728f, 0.994494f, 0.873890f, 0.759161f, 0.635686f, 0.693447f, 0.695637f,
0.078924f, 0.739488f, 0.849759f, 0.343389f, 0.038189f, 0.482223f, 0.567029f, 0.469400f, 0.279521f, 0.921553f,
0.770511f, 0.434797f, 0.204528f, 0.959789f, 0.711143f, 0.977919f, 0.886401f, 0.376626f, 0.951718f, 0.268381f,
0.822740f, 0.603154f, 0.322771f, 0.760188f, 0.227450f, 0.515731f, 0.461949f, 0.648828f, 0.546204f, 0.218935f,
0.698432f, 0.416702f, 0.001216f, 0.311863f, 0.730946f, 0.322174f, 0.036790f, 0.465836f, 0.608650f, 0.069815f,
0.892493f, 0.757245f, 0.329490f, 0.574680f, 0.455372f, 0.767302f, 0.256536f, 0.680120f, 0.598428f, 0.624039f,
0.079647f, 0.106347f, 0.836051f, 0.004273f, 0.427557f, 0.720531f, 0.897984f, 0.622544f, 0.869695f, 0.648014f,
0.434454f, 0.286973f, 0.476789f, 0.598661f, 0.546773f, 0.919597f, 0.595781f, 0.187000f, 0.389571f, 0.271416f,
0.104303f, 0.222984f, 0.747170f, 0.344613f, 0.289482f, 0.538007f, 0.438819f, 0.886873f, 0.650635f, 0.430858f,
0.546797f, 0.244076f, 0.925377f, 0.966722f, 0.492345f, 0.630313f, 0.874022f, 0.905702f, 0.975756f, 0.057330f,
0.025918f, 0.738246f, 0.932430f, 0.703067f, 0.538683f, 0.917490f, 0.640354f, 0.429182f, 0.925156f, 0.830884f,
0.168402f, 0.185081f, 0.356585f, 0.298056f, 0.570455f, 0.850292f, 0.320525f, 0.275231f, 0.368763f, 0.243449f,
0.125362f, 0.616892f, 0.917922f, 0.564895f, 0.706964f, 0.467499f, 0.478258f, 0.128935f, 0.048378f, 0.763494f,
0.699105f, 0.857472f, 0.126916f, 0.729096f, 0.204583f, 0.726045f, 0.334836f, 0.059802f, 0.374799f, 0.403071f,
0.034323f, 0.894047f, 0.895447f, 0.871965f, 0.182855f, 0.128357f, 0.936546f, 0.050014f, 0.163630f, 0.928632f,
0.410044f, 0.991808f, 0.394819f, 0.668728f, 0.763688f, 0.263604f, 0.317756f, 0.210347f, 0.973823f, 0.151550f,
0.205469f, 0.036195f, 0.869569f, 0.055260f, 0.055630f, 0.759770f, 0.705963f, 0.850858f, 0.740903f, 0.524877f,
0.823832f, 0.222405f, 0.512448f, 0.660957f, 0.259580f, 0.506510f, 0.931396f, 0.588315f, 0.892587f, 0.639098f,
0.445958f, 0.901817f, 0.861582f, 0.824442f, 0.398297f, 0.365343f, 0.131465f, 0.579775f, 0.721396f, 0.059322f,
0.643350f, 0.905610f, 0.345071f, 0.956403f, 0.992698f, 0.868540f, 0.718342f, 0.144220f, 0.009070f, 0.398131f,
0.240174f, 0.168058f, 0.728395f, 0.742523f, 0.503517f, 0.655269f, 0.920159f, 0.339319f, 0.949579f, 0.602078f,
0.124345f, 0.329313f, 0.170446f, 0.338802f, 0.530792f, 0.479832f, 0.557219f, 0.883721f, 0.369256f, 0.821240f,
0.117989f, 0.705492f, 0.190868f, 0.439808f, 0.637442f, 0.377653f, 0.070060f, 0.765990f, 0.739518f, 0.380992f,
0.929796f, 0.932455f, 0.462053f, 0.821648f, 0.501258f, 0.607454f, 0.574680f, 0.733424f, 0.055427f, 0.550525f,
0.659997f, 0.719012f, 0.418045f, 0.403728f, 0.017005f, 0.695365f, 0.792104f, 0.948595f, 0.052588f, 0.027014f,
0.462882f, 0.028268f, 0.931419f, 0.420449f, 0.081645f, 0.784981f, 0.355788f, 0.027566f, 0.565758f, 0.544481f,
0.602938f, 0.024529f, 0.261592f, 0.458143f, 0.413818f, 0.290997f, 0.324823f, 0.617544f, 0.626833f, 0.045566f,
0.783306f, 0.837538f, 0.485761f, 0.221398f, 0.178777f, 0.979249f, 0.133026f, 0.970526f, 0.645786f, 0.267282f,
0.980057f, 0.188309f, 0.753902f, 0.865504f, 0.913783f, 0.134904f, 0.853355f, 0.182540f, 0.461749f, 0.088385f,
0.027966f, 0.019677f, 0.650709f, 0.785452f, 0.283218f, 0.096781f, 0.795050f, 0.764773f, 0.642213f, 0.016959f,
0.697469f, 0.955664f, 0.985568f, 0.456087f, 0.815722f, 0.561166f, 0.480473f, 0.007111f, 0.207466f, 0.082893f,
0.193223f, 0.487364f, 0.064752f, 0.923718f, 0.250024f, 0.974327f, 0.564827f, 0.266934f, 0.016234f, 0.333166f,
0.717186f, 0.495499f, 0.748679f, 0.356422f, 0.092111f, 0.383093f, 0.681633f, 0.338685f, 0.418082f, 0.535659f,
0.121297f, 0.026307f, 0.971282f, 0.344933f, 0.796693f, 0.477077f, 0.344866f, 0.761259f, 0.898472f, 0.461121f,
0.143531f, 0.389492f, 0.381590f, 0.155768f, 0.977483f, 0.627678f, 0.377147f, 0.519878f, 0.957816f, 0.442147f,
0.290311f, 0.393714f, 0.090653f, 0.221671f, 0.656083f, 0.586044f, 0.435206f, 0.829841f, 0.026037f, 0.664399f,
0.503410f, 0.970148f, 0.018499f, 0.928779f, 0.907954f, 0.984428f, 0.920062f, 0.016358f, 0.547876f, 0.863368f,
0.214260f, 0.283317f, 0.651599f, 0.474622f, 0.000803f, 0.821286f, 0.252480f, 0.643161f, 0.384251f, 0.184497f,
0.420019f, 0.295130f, 0.597015f, 0.088521f, 0.405796f, 0.317768f, 0.093206f, 0.218306f, 0.204859f, 0.634761f,
0.925308f, 0.041093f, 0.928484f, 0.014311f, 0.747902f, 0.061850f, 0.391398f, 0.750440f, 0.439299f, 0.259079f,
0.160778f, 0.671294f, 0.675864f, 0.713062f, 0.195053f, 0.082477f, 0.740238f, 0.789254f, 0.810668f, 0.500313f,
0.290854f, 0.292758f, 0.064659f, 0.253514f, 0.211675f, 0.229810f, 0.476256f, 0.315275f, 0.864699f, 0.613615f,
0.660425f, 0.699872f, 0.738329f, 0.573179f, 0.618311f, 0.018003f, 0.182572f, 0.533311f, 0.721147f, 0.747584f,
0.620392f, 0.041223f, 0.547943f, 0.214088f, 0.619353f, 0.170597f, 0.124087f, 0.107366f, 0.275298f, 0.642997f,
0.032942f, 0.826631f, 0.293424f, 0.704818f, 0.045007f, 0.340388f, 0.917552f, 0.440098f, 0.255691f, 0.716081f,
0.557258f, 0.052034f, 0.984890f, 0.573119f, 0.815041f, 0.548262f, 0.623986f, 0.727417f, 0.562646f, 0.669178f,
0.773499f, 0.156811f, 0.935324f, 0.242596f, 0.838323f, 0.862364f, 0.694658f, 0.470467f, 0.724281f, 0.940754f,
0.083054f, 0.030674f, 0.574457f, 0.952594f, 0.778630f, 0.883252f, 0.194765f, 0.581982f, 0.239979f, 0.837051f,
0.506410f, 0.991135f, 0.399465f, 0.764416f, 0.139815f, 0.349625f, 0.862317f, 0.510434f, 0.462067f, 0.268716f,
0.752697f, 0.376547f, 0.127584f, 0.191551f, 0.170094f, 0.460375f, 0.470456f, 0.565936f, 0.973476f, 0.203798f,
0.732234f, 0.558986f, 0.769244f, 0.698513f, 0.305138f, 0.065699f, 0.582648f, 0.874516f, 0.607120f, 0.550958f,
0.528818f, 0.505723f, 0.748246f, 0.695086f, 0.224206f, 0.490047f, 0.152990f, 0.074880f, 0.614428f, 0.583686f,
0.883563f, 0.750186f, 0.941723f, 0.302373f, 0.957004f, 0.903324f, 0.468773f, 0.855333f, 0.713983f, 0.992844f,
0.974266f, 0.136548f, 0.847291f, 0.702075f, 0.165615f, 0.077436f, 0.620065f, 0.070802f, 0.511525f, 0.305501f,
0.012207f, 0.846990f, 0.372416f, 0.842051f, 0.779372f, 0.344617f, 0.431006f, 0.556468f, 0.104292f, 0.309685f,
0.113339f, 0.261217f, 0.409645f, 0.513790f, 0.841933f, 0.183042f, 0.524496f, 0.073837f, 0.781478f, 0.781473f,
0.085997f, 0.059633f, 0.125850f, 0.846648f, 0.675415f, 0.915953f, 0.490214f, 0.315051f, 0.164033f, 0.966988f,
0.159281f, 0.639957f, 0.568804f, 0.808220f, 0.827498f, 0.773348f, 0.466144f, 0.927277f, 0.319614f, 0.282176f,
0.761212f, 0.782563f, 0.607259f, 0.143301f, 0.713049f, 0.409654f, 0.944060f, 0.620007f, 0.577564f, 0.864069f,
0.835429f, 0.594435f, 0.801721f, 0.930355f, 0.920981f, 0.790872f, 0.487613f, 0.544016f, 0.487737f, 0.323516f,
0.582635f, 0.601747f, 0.316235f, 0.852990f, 0.286068f, 0.697074f, 0.050539f, 0.232919f, 0.506135f, 0.579005f,
0.732162f, 0.652897f, 0.625178f, 0.255029f, 0.362909f, 0.862169f, 0.189368f, 0.377960f, 0.421260f, 0.789275f,
0.359475f, 0.282783f, 0.796906f, 0.688352f, 0.960195f, 0.350145f, 0.812059f, 0.092381f, 0.732697f, 0.634691f,
0.161464f, 0.988953f, 0.321344f, 0.486973f, 0.044893f, 0.977464f, 0.051230f, 0.777712f, 0.999547f, 0.775506f,
0.992189f, 0.694885f, 0.631056f, 0.483445f, 0.160587f, 0.252396f, 0.937463f, 0.300308f, 0.399108f, 0.444091f,
0.450816f, 0.692036f, 0.644192f, 0.196698f, 0.075097f, 0.973258f, 0.527319f, 0.054297f, 0.209351f, 0.751963f,
0.333975f, 0.190370f, 0.591124f, 0.471928f, 0.280565f, 0.962386f, 0.436296f, 0.483058f, 0.475693f, 0.792908f,
0.008206f, 0.435796f, 0.733947f, 0.878224f, 0.227047f, 0.972090f, 0.411805f, 0.673507f, 0.301081f, 0.133171f,
0.671367f, 0.581267f, 0.601220f, 0.740810f, 0.499117f, 0.718554f, 0.387401f, 0.821347f, 0.146944f, 0.239276f,
0.266405f, 0.186863f, 0.196970f, 0.029025f, 0.549433f, 0.721928f, 0.813531f, 0.495037f, 0.975395f, 0.836916f,
0.536001f, 0.418763f, 0.904626f, 0.323565f, 0.711536f, 0.862593f, 0.503703f, 0.333829f, 0.004449f, 0.864439f,
0.196767f, 0.317632f, 0.969296f, 0.523438f, 0.450704f, 0.509306f, 0.965615f, 0.000788f, 0.953396f, 0.243949f,
0.011037f, 0.682428f, 0.427079f, 0.429604f, 0.676561f, 0.052306f, 0.825056f, 0.943132f, 0.432423f, 0.062584f,
0.404490f, 0.158802f, 0.626241f, 0.759788f, 0.830098f, 0.655542f, 0.243350f, 0.245268f, 0.104402f, 0.659677f,
0.006835f, 0.489028f, 0.415928f, 0.908886f, 0.701253f, 0.270601f, 0.369006f, 0.732060f, 0.514337f, 0.184259f,
0.405653f, 0.056909f, 0.073308f, 0.968374f, 0.979731f, 0.923171f, 0.227395f, 0.104492f, 0.896880f, 0.872255f,
0.045913f, 0.677864f, 0.868833f, 0.482146f, 0.944407f, 0.258104f, 0.812356f, 0.506046f, 0.806501f, 0.023414f,
0.021208f, 0.587138f, 0.543502f, 0.769533f, 0.915391f, 0.068152f, 0.684976f, 0.943745f, 0.225736f, 0.975273f,
0.269464f, 0.456029f, 0.897503f, 0.366441f, 0.248169f, 0.600055f, 0.272657f, 0.519112f, 0.246202f, 0.583302f,
0.411440f, 0.783685f, 0.744888f, 0.932567f, 0.803474f, 0.853890f, 0.850380f, 0.327391f, 0.939748f, 0.568712f,
0.729044f, 0.465424f, 0.400086f, 0.777369f, 0.643925f, 0.186011f, 0.381584f, 0.835311f, 0.008848f, 0.814418f,
0.136650f, 0.127729f, 0.761948f, 0.611174f, 0.820877f, 0.966512f, 0.111177f, 0.829709f, 0.875940f, 0.736763f,
0.567178f, 0.762621f, 0.282595f, 0.661548f, 0.778427f, 0.333428f, 0.823963f, 0.748024f, 0.422709f, 0.255475f,
0.073602f, 0.364295f, 0.596731f, 0.067544f, 0.306501f, 0.036783f, 0.112489f, 0.597572f, 0.208797f, 0.095742f,
0.633602f, 0.843440f, 0.045167f, 0.509811f, 0.101250f, 0.386030f, 0.085466f, 0.838482f, 0.839070f, 0.793710f,
0.504556f, 0.211774f, 0.107180f, 0.050993f, 0.130589f, 0.042323f, 0.392820f, 0.110007f, 0.583624f, 0.922561f,
0.137996f, 0.107676f, 0.863622f, 0.756653f, 0.095102f, 0.534551f, 0.652930f, 0.125589f, 0.643523f, 0.718982f,
0.937215f, 0.326950f, 0.035828f, 0.654027f, 0.160054f, 0.657733f, 0.838677f, 0.426840f, 0.984560f, 0.687798f,
0.793011f, 0.347858f, 0.344477f, 0.947961f, 0.354555f, 0.208858f, 0.328609f, 0.734268f, 0.632846f, 0.014385f,
0.178365f, 0.764452f, 0.197837f, 0.675410f, 0.134478f, 0.798243f, 0.986005f, 0.639840f, 0.327628f, 0.992596f,
0.347585f, 0.598648f, 0.505915f, 0.815903f, 0.107178f, 0.164535f, 0.450155f, 0.350079f, 0.497111f, 0.753501f,
0.230621f, 0.188603f, 0.274520f, 0.244169f, 0.553103f, 0.495244f, 0.349672f, 0.043886f, 0.949236f, 0.969718f,
0.679675f, 0.981587f, 0.394820f, 0.988095f, 0.990312f, 0.685815f, 0.539959f, 0.824768f, 0.008615f, 0.339296f,
0.874149f, 0.179008f, 0.043958f, 0.526750f, 0.583708f, 0.158234f, 0.615391f, 0.709371f, 0.902374f, 0.656766f,
0.773599f, 0.521925f, 0.276248f, 0.347264f, 0.139369f, 0.266686f, 0.649995f, 0.703236f, 0.836040f, 0.187563f,
0.764641f, 0.283312f, 0.266038f, 0.015793f, 0.898685f, 0.559204f, 0.939093f, 0.857561f, 0.438205f, 0.349647f,
0.427525f, 0.037179f, 0.144751f, 0.336773f, 0.495069f, 0.469578f, 0.432695f, 0.982818f, 0.719094f, 0.749922f,
0.111855f, 0.426853f, 0.351090f, 0.698461f, 0.242565f, 0.992239f, 0.523755f, 0.666470f, 0.713947f, 0.436893f,
0.585440f, 0.219568f, 0.520603f, 0.024840f, 0.564865f, 0.357707f, 0.947312f, 0.567053f, 0.127582f, 0.447081f,
0.196242f, 0.876952f, 0.326022f, 0.443337f, 0.712213f, 0.862858f, 0.429781f, 0.455235f, 0.376158f, 0.999812f,
0.697287f, 0.697348f, 0.303792f, 0.751003f, 0.265565f, 0.454079f, 0.725767f, 0.082280f, 0.393862f, 0.178178f,
0.187954f, 0.519128f, 0.288533f, 0.280164f, 0.156600f, 0.544528f, 0.197628f, 0.950901f, 0.310694f, 0.129332f,
0.478427f, 0.271866f, 0.193991f, 0.135910f, 0.042764f, 0.162268f, 0.388180f, 0.197180f, 0.347317f, 0.121795f,
0.060296f, 0.675062f, 0.497691f, 0.514050f, 0.813881f, 0.263763f, 0.661211f, 0.004921f, 0.222658f, 0.287415f,
0.588116f, 0.330888f, 0.292280f, 0.411944f, 0.412464f, 0.812101f, 0.995960f, 0.297474f, 0.769935f, 0.226414f,
0.856528f, 0.778022f, 0.546789f, 0.786110f, 0.711206f, 0.192494f, 0.183900f, 0.946040f, 0.992021f, 0.049954f,
0.929107f, 0.467478f, 0.845315f, 0.277916f, 0.147697f, 0.203304f, 0.551923f, 0.344220f, 0.694800f, 0.378288f,
0.758709f, 0.841362f, 0.298899f, 0.477447f, 0.453300f, 0.283965f, 0.170475f, 0.138266f, 0.548575f, 0.939439f,
0.736036f, 0.838233f, 0.473235f, 0.749018f, 0.547791f, 0.157093f, 0.402912f, 0.619737f, 0.032946f, 0.563694f,
0.618096f, 0.483006f, 0.033913f, 0.057023f, 0.321484f, 0.562757f, 0.153022f, 0.023687f, 0.839353f, 0.990790f,
0.810851f, 0.961708f, 0.410964f, 0.141966f, 0.764774f, 0.936064f, 0.222086f, 0.416035f, 0.446048f, 0.886509f,
0.648053f, 0.657488f, 0.148774f, 0.322801f, 0.168936f, 0.220467f, 0.582510f, 0.732352f, 0.317389f, 0.334901f,
0.999176f, 0.856130f, 0.763512f, 0.790486f, 0.798539f, 0.365624f, 0.802467f, 0.728953f, 0.897460f, 0.585977f,
0.007398f, 0.821466f, 0.087117f, 0.665508f, 0.443338f, 0.186587f, 0.864119f, 0.571867f, 0.424001f, 0.357551f,
0.575298f, 0.134711f, 0.255084f, 0.185921f, 0.637682f, 0.370628f, 0.004043f, 0.768137f, 0.598585f, 0.766605f,
0.262808f, 0.194114f, 0.205610f, 0.127615f, 0.665817f, 0.543912f, 0.770127f, 0.790763f, 0.218400f, 0.260212f,
0.204159f, 0.999408f, 0.878506f, 0.353090f, 0.685748f, 0.057829f, 0.609485f, 0.164909f, 0.727616f, 0.247270f,
0.147313f, 0.102962f, 0.194075f, 0.545093f, 0.615476f, 0.588907f, 0.690512f, 0.166417f, 0.936725f, 0.606667f,
0.900634f, 0.768789f, 0.017175f, 0.820655f, 0.651595f, 0.009805f, 0.413645f, 0.910356f, 0.938926f, 0.607346f,
0.658210f, 0.450781f, 0.722203f, 0.503686f, 0.174504f, 0.939111f, 0.851099f, 0.900482f, 0.751086f, 0.671006f,
0.630564f, 0.150314f, 0.981390f, 0.884897f, 0.353599f, 0.064040f, 0.883996f, 0.843413f, 0.947517f, 0.111538f,
0.339298f, 0.066922f, 0.737068f, 0.529278f, 0.490278f, 0.849645f, 0.836146f, 0.403283f, 0.891455f, 0.154686f,
0.887044f, 0.163488f, 0.810958f, 0.416158f, 0.697157f, 0.599282f, 0.507390f, 0.939649f, 0.084474f, 0.415764f,
0.090947f, 0.194450f, 0.326687f, 0.021941f, 0.205370f, 0.529985f, 0.860365f, 0.514029f, 0.440255f, 0.551121f,
0.647844f, 0.058717f, 0.770198f, 0.217277f, 0.070031f, 0.841850f, 0.954095f, 0.237511f, 0.329493f, 0.964837f,
0.936171f, 0.488157f, 0.994710f, 0.879573f, 0.019188f, 0.510131f, 0.202649f, 0.771281f, 0.783370f, 0.918298f,
0.882857f, 0.832258f, 0.457202f, 0.376654f, 0.370832f, 0.601366f, 0.519254f, 0.360991f, 0.893962f, 0.088239f,
0.524206f, 0.730666f, 0.312515f, 0.637971f, 0.038953f, 0.939781f, 0.422761f, 0.575260f, 0.960456f, 0.209238f,
0.635570f, 0.638772f, 0.266986f, 0.754708f, 0.542137f, 0.645207f, 0.058025f, 0.951998f, 0.370108f, 0.166581f,
0.956294f, 0.467918f, 0.183771f, 0.219640f, 0.575119f, 0.501999f, 0.235864f, 0.805097f, 0.464200f, 0.784322f,
0.894327f, 0.314144f, 0.501980f, 0.145903f, 0.684412f, 0.060604f, 0.363259f, 0.383767f, 0.385950f, 0.686826f,
0.859993f, 0.953757f, 0.729185f, 0.291726f, 0.001856f, 0.480652f, 0.537351f, 0.125452f, 0.241750f, 0.636847f,
0.203358f, 0.918660f, 0.953071f, 0.050766f, 0.289544f, 0.145388f, 0.632257f, 0.771351f, 0.674946f, 0.162150f,
0.968663f, 0.119378f, 0.797206f, 0.062659f, 0.754584f, 0.100064f, 0.630341f, 0.422486f, 0.857864f, 0.785604f,
0.995850f, 0.037784f, 0.355261f, 0.591087f, 0.768797f, 0.266558f, 0.618465f, 0.337073f, 0.220349f, 0.590312f,
0.954031f, 0.054227f, 0.407115f, 0.873070f, 0.989918f, 0.800417f, 0.994365f, 0.976400f, 0.358800f, 0.365226f,
0.392506f, 0.949356f, 0.185551f, 0.206267f, 0.801869f, 0.709314f, 0.708889f, 0.968145f, 0.928734f, 0.434207f,
0.169353f, 0.523812f, 0.497261f, 0.189228f, 0.505879f, 0.336348f, 0.631564f, 0.072920f, 0.378560f, 0.868755f,
0.217531f, 0.988282f, 0.206436f, 0.698489f, 0.460299f, 0.145822f, 0.221317f, 0.337542f, 0.162237f, 0.586352f,
0.497556f, 0.409083f, 0.433237f, 0.997622f, 0.417131f, 0.231909f, 0.172132f, 0.898180f, 0.141996f, 0.458332f,
0.901108f, 0.619036f, 0.820891f, 0.327518f, 0.507413f, 0.470193f, 0.085989f, 0.710470f, 0.259213f, 0.750476f,
0.943494f, 0.148246f, 0.889471f, 0.076539f, 0.714305f, 0.434618f, 0.341851f, 0.371062f, 0.746015f, 0.528731f,
0.182149f, 0.551664f, 0.603713f, 0.189455f, 0.334196f, 0.834639f, 0.694904f, 0.331870f, 0.273995f, 0.152629f,
0.747349f, 0.487205f, 0.799040f, 0.432864f, 0.985641f, 0.526990f, 0.532330f, 0.214092f, 0.685566f, 0.536196f,
0.880135f, 0.405860f, 0.754270f, 0.297314f, 0.090120f, 0.928033f, 0.744043f, 0.826332f, 0.102328f, 0.641837f,
0.878394f, 0.456985f, 0.037737f, 0.645658f, 0.674019f, 0.627125f, 0.789257f, 0.640200f, 0.496575f, 0.825639f,
0.629694f, 0.847027f, 0.420510f, 0.838776f, 0.916575f, 0.797195f, 0.863054f, 0.693466f, 0.814342f, 0.737631f,
0.990210f, 0.304901f, 0.298057f, 0.984032f, 0.630129f, 0.494534f, 0.287837f, 0.255145f, 0.285337f, 0.025775f,
0.587836f, 0.545484f, 0.149813f, 0.944079f, 0.302281f, 0.074771f, 0.903037f, 0.793820f, 0.674714f, 0.154748f,
0.173029f, 0.470395f, 0.960929f, 0.305178f, 0.994134f, 0.198548f, 0.125383f, 0.575377f, 0.515902f, 0.984859f,
0.937703f, 0.820110f, 0.335867f, 0.935845f, 0.266897f, 0.169796f, 0.430095f, 0.172233f, 0.294550f, 0.103121f,
0.538316f, 0.469164f, 0.900059f, 0.692236f, 0.938880f, 0.275450f, 0.029244f, 0.181916f, 0.017830f, 0.950992f,
0.139727f, 0.570182f, 0.057088f, 0.831284f, 0.384962f, 0.248903f, 0.120501f, 0.125895f, 0.745448f, 0.101067f,
0.925651f, 0.881303f, 0.929430f, 0.014675f, 0.524990f, 0.581336f, 0.424363f, 0.098110f, 0.664249f, 0.801071f,
0.573931f, 0.333309f, 0.708898f, 0.921662f, 0.771729f, 0.595843f, 0.402547f, 0.682826f, 0.993746f, 0.684023f,
0.022581f, 0.924913f, 0.135772f, 0.080476f, 0.313827f, 0.830069f, 0.316802f, 0.091323f, 0.686316f, 0.958219f,
0.459971f, 0.115023f, 0.131294f, 0.974189f, 0.746977f, 0.636307f, 0.200833f, 0.692168f, 0.938924f, 0.235673f,
0.460351f, 0.198197f, 0.162781f, 0.468229f, 0.151076f, 0.763625f, 0.398914f, 0.539953f, 0.039884f, 0.999836f,
0.901695f, 0.759271f, 0.735424f, 0.696311f, 0.279736f, 0.082778f, 0.227746f, 0.937222f, 0.082667f, 0.317984f,
0.662627f, 0.816379f, 0.388687f, 0.296472f, 0.799979f, 0.226026f, 0.567107f, 0.568622f, 0.347372f, 0.557034f,
0.957470f, 0.111737f, 0.917235f, 0.247377f, 0.646146f, 0.761834f, 0.329233f, 0.322130f, 0.320869f, 0.123199f,
0.000958f, 0.116116f, 0.283773f, 0.895913f, 0.678509f, 0.489559f, 0.969885f, 0.030217f, 0.215032f, 0.063151f,
0.070194f, 0.704188f, 0.471287f, 0.031601f, 0.039418f, 0.312095f, 0.379207f, 0.699621f, 0.549914f, 0.807886f,
0.544085f, 0.317429f, 0.698977f, 0.502170f, 0.573698f, 0.599131f, 0.581880f, 0.283726f, 0.577593f, 0.853285f,
0.297818f, 0.202632f, 0.584703f, 0.294400f, 0.656610f, 0.481298f, 0.599971f, 0.386407f, 0.927996f, 0.094741f,
0.211169f, 0.059080f, 0.770847f, 0.656158f, 0.664488f, 0.507807f, 0.385923f, 0.464852f, 0.978597f, 0.300063f,
0.621758f, 0.686597f, 0.395141f, 0.441312f, 0.313348f, 0.670681f, 0.086722f, 0.353937f, 0.212140f, 0.930740f,
0.929555f, 0.208865f, 0.310895f, 0.541522f, 0.781721f, 0.464659f, 0.925179f, 0.299895f, 0.756272f, 0.039042f,
0.739654f, 0.445762f, 0.284512f, 0.520961f, 0.161975f, 0.993363f, 0.267186f, 0.069319f, 0.083348f, 0.465734f,
0.382658f, 0.848164f, 0.989714f, 0.760216f, 0.733022f, 0.981932f, 0.576884f, 0.232950f, 0.708894f, 0.409152f,
0.262993f, 0.127694f, 0.974246f, 0.305577f, 0.893326f, 0.397386f, 0.287337f, 0.300307f, 0.587178f, 0.633947f,
0.198426f, 0.240428f, 0.112748f, 0.081799f, 0.126721f, 0.969319f, 0.404453f, 0.041831f, 0.183262f, 0.729687f,
0.253428f, 0.484780f, 0.066545f, 0.835347f, 0.257813f, 0.745155f, 0.989729f, 0.518681f, 0.051271f, 0.119334f,
0.967718f, 0.034645f, 0.857877f, 0.674918f, 0.396161f, 0.325227f, 0.913294f, 0.773958f, 0.372484f, 0.103659f,
0.019969f, 0.316648f, 0.702612f, 0.701030f, 0.756647f, 0.409362f, 0.609676f, 0.649067f, 0.859387f, 0.621652f,
0.365241f, 0.325876f, 0.962164f, 0.014999f, 0.374562f, 0.642132f, 0.256077f, 0.808785f, 0.316388f, 0.559048f,
0.240744f, 0.098613f, 0.379292f, 0.817468f, 0.286680f, 0.396681f, 0.005870f, 0.732154f, 0.953788f, 0.062848f,
0.577840f, 0.500081f, 0.505033f, 0.166291f, 0.547017f, 0.640371f, 0.087117f, 0.004705f, 0.778346f, 0.758358f,
0.813141f, 0.972896f, 0.545489f, 0.785714f, 0.759256f, 0.462223f, 0.581563f, 0.107727f, 0.779912f, 0.982236f,
0.021350f, 0.960859f, 0.085273f, 0.742996f, 0.083738f, 0.478692f, 0.408150f, 0.940878f, 0.727666f, 0.760714f,
0.624940f, 0.697070f, 0.720710f, 0.190776f, 0.876869f, 0.902639f, 0.883410f, 0.475320f, 0.785138f, 0.845221f,
0.968379f, 0.775791f, 0.073531f, 0.331626f, 0.576248f, 0.587253f, 0.476821f, 0.575959f, 0.780740f, 0.743246f,
0.151709f, 0.296450f, 0.693883f, 0.260920f, 0.959023f, 0.447042f, 0.749735f, 0.579838f, 0.115520f, 0.046160f,
0.853728f, 0.969842f, 0.022720f, 0.654728f, 0.111966f, 0.095234f, 0.679352f, 0.122603f, 0.731987f, 0.642166f,
0.283482f, 0.492639f, 0.390141f, 0.580410f, 0.535172f, 0.560847f, 0.524772f, 0.128877f, 0.344432f, 0.326867f,
0.041469f, 0.486925f, 0.140046f, 0.099446f, 0.922696f, 0.379485f, 0.805714f, 0.183456f, 0.526195f, 0.956650f,
0.176182f, 0.393291f, 0.699355f, 0.235747f, 0.768966f, 0.998549f, 0.921908f, 0.311647f, 0.396299f, 0.368968f,
0.821265f, 0.860800f, 0.570451f, 0.602123f, 0.223466f, 0.981481f, 0.552495f, 0.054762f, 0.312677f, 0.126458f,
0.445050f, 0.014873f, 0.131055f, 0.671132f, 0.146912f, 0.120115f, 0.685536f, 0.949623f, 0.382239f, 0.938844f,
0.571405f, 0.484778f, 0.730456f, 0.699975f, 0.418373f, 0.622203f, 0.866077f, 0.016438f, 0.660147f, 0.621273f,
0.942406f, 0.900365f, 0.877473f, 0.037546f, 0.984221f, 0.075658f, 0.577471f, 0.426871f, 0.139439f, 0.594750f,
0.430336f, 0.668463f, 0.047025f, 0.406602f, 0.486183f, 0.880522f, 0.547585f, 0.586664f, 0.780382f, 0.857924f,
0.460286f, 0.215706f, 0.956096f, 0.955358f, 0.969177f, 0.469634f, 0.058351f, 0.577993f, 0.363474f, 0.662645f,
0.337630f, 0.814167f, 0.335460f, 0.937256f, 0.655906f, 0.372364f, 0.670508f, 0.473866f, 0.728871f, 0.405024f,
0.521668f, 0.034343f, 0.553180f, 0.299613f, 0.087000f, 0.316323f, 0.169591f, 0.451184f, 0.892444f, 0.717624f,
0.141119f, 0.838059f, 0.348296f, 0.541296f, 0.160900f, 0.236351f, 0.558441f, 0.062567f, 0.561414f, 0.162869f,
0.850789f, 0.068548f, 0.298634f, 0.893554f, 0.742965f, 0.480616f, 0.232415f, 0.912451f, 0.003060f, 0.144784f,
0.932601f, 0.521543f, 0.836873f, 0.555068f, 0.132578f, 0.232913f, 0.849722f, 0.988393f, 0.388101f, 0.813167f,
0.894536f, 0.598629f, 0.612392f, 0.547082f, 0.869605f, 0.135453f, 0.542047f, 0.063270f, 0.477550f, 0.233242f,
0.130037f, 0.272114f, 0.525283f, 0.860358f, 0.276458f, 0.813717f, 0.249353f, 0.309521f, 0.846288f, 0.946376f,
0.201026f, 0.382469f, 0.981892f, 0.034489f, 0.234059f, 0.825620f, 0.960072f, 0.033631f, 0.012192f, 0.055935f,
0.278828f, 0.998928f, 0.434912f, 0.213908f, 0.567900f, 0.410022f, 0.818617f, 0.962776f, 0.395102f, 0.534455f,
0.043477f, 0.905638f, 0.237729f, 0.078530f, 0.378928f, 0.166372f, 0.972361f, 0.268270f, 0.426325f, 0.940787f,
0.380587f, 0.978337f, 0.392109f, 0.093343f, 0.730442f, 0.525803f, 0.888735f, 0.270221f, 0.114128f, 0.326863f,
0.150331f, 0.700942f, 0.575384f, 0.032105f, 0.113156f, 0.061733f, 0.411152f, 0.195890f, 0.239025f, 0.009875f,
0.546500f, 0.470186f, 0.297199f, 0.809943f, 0.869159f, 0.249504f, 0.555143f, 0.769956f, 0.900625f, 0.683539f,
0.503626f, 0.383027f, 0.807058f, 0.944145f, 0.477493f, 0.815891f, 0.031746f, 0.271315f, 0.333105f, 0.836797f,
0.893868f, 0.170954f, 0.786518f, 0.365771f, 0.647465f, 0.988164f, 0.796139f, 0.169694f, 0.683352f, 0.305875f,
0.754347f, 0.594805f, 0.599304f, 0.024498f, 0.286494f, 0.378928f, 0.282519f, 0.039354f, 0.891099f, 0.843755f,
0.478249f, 0.034041f, 0.358125f, 0.121964f, 0.767710f, 0.791656f, 0.903910f, 0.474842f, 0.402087f, 0.398048f,
0.758605f, 0.991471f, 0.127418f, 0.318648f, 0.404358f, 0.401855f, 0.033115f, 0.232631f, 0.462461f, 0.582907f,
0.899022f, 0.795180f, 0.972027f, 0.123151f, 0.595186f, 0.272613f, 0.002222f, 0.418013f, 0.761607f, 0.508137f,
0.990010f, 0.746204f, 0.861635f, 0.667476f, 0.153706f, 0.441156f, 0.926655f, 0.383729f, 0.657711f, 0.280409f,
0.898535f, 0.177092f, 0.274702f, 0.261668f, 0.857139f, 0.019299f, 0.709892f, 0.541545f, 0.011562f, 0.449727f,
0.463350f, 0.030653f, 0.870084f, 0.005909f, 0.763973f, 0.487759f, 0.919348f, 0.802455f, 0.977156f, 0.470651f,
0.552681f, 0.787448f, 0.459545f, 0.722446f, 0.947942f, 0.075033f, 0.575372f, 0.468121f, 0.902133f, 0.314957f,
0.625916f, 0.373920f, 0.650228f, 0.052020f, 0.093850f, 0.801263f, 0.779208f, 0.690485f, 0.059444f, 0.839072f,
0.595246f, 0.998577f, 0.505809f, 0.861852f, 0.375992f, 0.963981f, 0.514266f, 0.729818f, 0.882402f, 0.406809f,
0.084176f, 0.840218f, 0.583934f, 0.290957f, 0.356926f, 0.687767f, 0.624992f, 0.572258f, 0.561903f, 0.073954f,
0.407702f, 0.592849f, 0.936199f, 0.988687f, 0.929862f, 0.234918f, 0.027785f, 0.472390f, 0.236392f, 0.438252f,
0.513100f, 0.007403f, 0.503572f, 0.913724f, 0.597993f, 0.447361f, 0.808467f, 0.981673f, 0.943995f, 0.466425f,
0.689870f, 0.443488f, 0.883399f, 0.161669f, 0.005501f, 0.525650f, 0.496111f, 0.680729f, 0.555881f, 0.153654f,
0.208863f, 0.779788f, 0.542428f, 0.597142f, 0.188423f, 0.576925f, 0.316581f, 0.891954f, 0.745649f, 0.620432f,
0.822313f, 0.065770f, 0.248082f, 0.542307f, 0.680828f, 0.427561f, 0.993100f, 0.305956f, 0.191261f, 0.833111f,
0.131669f, 0.317557f, 0.276226f, 0.534185f, 0.421734f, 0.281613f, 0.735256f, 0.328374f, 0.645099f, 0.740362f,
0.698799f, 0.310320f, 0.625144f, 0.246691f, 0.906201f, 0.723582f, 0.855280f, 0.251825f, 0.036328f, 0.248154f,
0.502206f, 0.346837f, 0.132284f, 0.321476f, 0.929140f, 0.237628f, 0.628479f, 0.236676f, 0.169151f, 0.049595f,
0.735343f, 0.745007f, 0.005929f, 0.189497f, 0.724322f, 0.758071f, 0.954296f, 0.190816f, 0.264496f, 0.387973f,
0.704522f, 0.107572f, 0.026354f, 0.249967f, 0.694381f, 0.906065f, 0.166029f, 0.024751f, 0.211769f, 0.661983f,
0.694938f, 0.861342f, 0.721641f, 0.230758f, 0.050077f, 0.427744f, 0.668315f, 0.583951f, 0.984560f, 0.606295f,
0.646679f, 0.544863f, 0.993127f, 0.422584f, 0.910810f, 0.777607f, 0.825844f, 0.388537f, 0.273587f, 0.151000f,
0.664048f, 0.518954f, 0.663690f, 0.195957f, 0.285267f, 0.503751f, 0.957743f, 0.842955f, 0.797559f, 0.089026f,
0.732754f, 0.890874f, 0.640357f, 0.079078f, 0.345720f, 0.379233f, 0.684665f, 0.443830f, 0.700581f, 0.893759f,
0.402079f, 0.546649f, 0.301843f, 0.443814f, 0.960594f, 0.289508f, 0.213988f, 0.103371f, 0.570116f, 0.435486f,
0.396157f, 0.639990f, 0.444578f, 0.475646f, 0.983352f, 0.338863f, 0.699896f, 0.838956f, 0.044142f, 0.862214f,
0.490700f, 0.974024f, 0.539276f, 0.160004f, 0.539699f, 0.477917f, 0.080502f, 0.032732f, 0.162705f, 0.896900f,
0.101523f, 0.950805f, 0.217622f, 0.589895f, 0.186193f, 0.398702f, 0.111103f, 0.801734f, 0.485735f, 0.654369f,
0.701978f, 0.589847f, 0.115202f, 0.983765f, 0.996571f, 0.385590f, 0.325892f, 0.974258f, 0.357414f, 0.140424f,
0.585736f, 0.494132f, 0.446753f, 0.575069f, 0.109535f, 0.038425f, 0.117528f, 0.052717f, 0.633460f, 0.129693f,
0.618045f, 0.214310f, 0.940989f, 0.872454f, 0.138703f, 0.281181f, 0.111585f, 0.139915f, 0.176476f, 0.051057f,
0.832221f, 0.005028f, 0.912299f, 0.277104f, 0.023805f, 0.293822f, 0.817480f, 0.708967f, 0.556753f, 0.662229f,
0.063888f, 0.062677f, 0.645570f, 0.234048f, 0.777886f, 0.302830f, 0.172960f, 0.010684f, 0.704438f, 0.390871f,
0.190078f, 0.325714f, 0.577098f, 0.542296f, 0.316731f, 0.716380f, 0.946300f, 0.767794f, 0.606941f, 0.115241f,
0.372818f, 0.156179f, 0.713379f, 0.197125f, 0.418047f, 0.125989f, 0.292397f, 0.400570f, 0.388539f, 0.069560f,
0.812657f, 0.803484f, 0.794661f, 0.735912f, 0.150621f, 0.212652f, 0.268068f, 0.166911f, 0.619245f, 0.156968f,
0.204186f, 0.342315f, 0.007902f, 0.058035f, 0.017188f, 0.602431f, 0.675542f, 0.186366f, 0.404351f, 0.957804f,
0.677758f, 0.228501f, 0.981034f, 0.408745f, 0.519968f, 0.707889f, 0.066218f, 0.713650f, 0.737782f, 0.369333f,
0.342483f, 0.083314f, 0.192134f, 0.989398f, 0.112831f, 0.764355f, 0.332604f, 0.503925f, 0.061990f, 0.479777f,
0.765819f, 0.725429f, 0.718129f, 0.887488f, 0.857615f, 0.902349f, 0.348635f, 0.053514f, 0.255119f, 0.017310f,
0.974981f, 0.786581f, 0.669536f, 0.132794f, 0.049965f, 0.844715f, 0.890124f, 0.322612f, 0.340322f, 0.549302f,
0.178460f, 0.537885f, 0.762550f, 0.610228f, 0.316696f, 0.353172f, 0.537725f, 0.633317f, 0.456738f, 0.482512f,
0.823925f, 0.065825f, 0.989551f, 0.264754f, 0.560583f, 0.400924f, 0.163031f, 0.049197f, 0.178684f, 0.283178f,
0.833759f, 0.039314f, 0.526169f, 0.204559f, 0.559479f, 0.384489f, 0.376444f, 0.255387f, 0.547153f, 0.368650f,
0.389971f, 0.931381f, 0.014758f, 0.968337f, 0.368711f, 0.841343f, 0.832646f, 0.916258f, 0.969847f, 0.575081f,
0.443477f, 0.192059f, 0.393633f, 0.367349f, 0.586056f, 0.831235f, 0.420379f, 0.084621f, 0.462141f, 0.140371f,
0.105560f, 0.007744f, 0.190099f, 0.598783f, 0.649102f, 0.074114f, 0.626241f, 0.552663f, 0.330549f, 0.370301f,
0.724903f, 0.127479f, 0.357899f, 0.670292f, 0.319782f, 0.753832f, 0.260097f, 0.987609f, 0.350213f, 0.597084f,
0.567241f, 0.525434f, 0.213943f, 0.537652f, 0.160850f, 0.795323f, 0.013507f, 0.026888f, 0.531868f, 0.952659f,
0.431543f, 0.534818f, 0.033252f, 0.278748f, 0.432975f, 0.440480f, 0.304066f, 0.668553f, 0.317849f, 0.494855f,
0.952069f, 0.366887f, 0.352673f, 0.176095f, 0.912449f, 0.932301f, 0.620847f, 0.939532f, 0.627110f, 0.101374f,
0.019314f, 0.026848f, 0.915367f, 0.793601f, 0.536109f, 0.766200f, 0.983994f, 0.434110f, 0.035839f, 0.221628f,
0.933453f, 0.403033f, 0.761746f, 0.168062f, 0.614589f, 0.782736f, 0.864131f, 0.121987f, 0.632007f, 0.741376f,
0.038652f, 0.258303f, 0.474292f, 0.837422f, 0.466517f, 0.031277f, 0.993490f, 0.023970f, 0.735849f, 0.880129f,
0.481180f, 0.075128f, 0.137961f, 0.702926f, 0.535319f, 0.123721f, 0.241534f, 0.161146f, 0.281919f, 0.098083f,
0.959864f, 0.417957f, 0.483515f, 0.481949f, 0.549952f, 0.908416f, 0.877617f, 0.445956f, 0.098757f, 0.296106f,
0.748267f, 0.780324f, 0.339739f, 0.357201f, 0.841306f, 0.001597f, 0.543044f, 0.034044f, 0.867380f, 0.720100f,
0.407832f, 0.804069f, 0.818409f, 0.122057f, 0.428167f, 0.708220f, 0.248243f, 0.540239f, 0.432086f, 0.106317f,
0.254700f, 0.012650f, 0.380604f, 0.154073f, 0.116260f, 0.950605f, 0.940390f, 0.612054f, 0.044506f, 0.246924f,
0.129732f, 0.652298f, 0.077565f, 0.070702f, 0.938458f, 0.726630f, 0.599413f, 0.734880f, 0.976262f, 0.245080f,
0.105460f, 0.132221f, 0.371071f, 0.214551f, 0.186723f, 0.529188f, 0.953636f, 0.864638f, 0.574423f, 0.394358f,
0.842650f, 0.508976f, 0.398180f, 0.262438f, 0.353686f, 0.928056f, 0.036784f, 0.208365f, 0.173145f, 0.461114f,
0.463360f, 0.504154f, 0.299955f, 0.320826f, 0.281972f, 0.042900f, 0.835037f, 0.925237f, 0.583677f, 0.404605f,
0.696770f, 0.062784f, 0.843149f, 0.247065f, 0.019134f, 0.364103f, 0.355752f, 0.545201f, 0.362729f, 0.846187f,
0.749763f, 0.286649f, 0.072415f, 0.655760f, 0.302231f, 0.209555f, 0.321812f, 0.968019f, 0.772826f, 0.018451f,
0.257399f, 0.540527f, 0.444083f, 0.312637f, 0.389173f, 0.951387f, 0.535372f, 0.446935f, 0.620055f, 0.813566f,
0.684840f, 0.842986f, 0.619608f, 0.236950f, 0.014753f, 0.009438f, 0.272040f, 0.074443f, 0.858343f, 0.146079f,
0.032759f, 0.254731f, 0.040824f, 0.108553f, 0.671863f, 0.506099f, 0.136244f, 0.388207f, 0.952040f, 0.032772f,
0.359537f, 0.244760f, 0.631630f, 0.634720f, 0.619671f, 0.008286f, 0.368883f, 0.818924f, 0.188085f, 0.562041f,
0.104698f, 0.950537f, 0.899915f, 0.491988f, 0.866387f, 0.045692f, 0.194325f, 0.977086f, 0.506206f, 0.450160f,
0.478434f, 0.930650f, 0.426730f, 0.848184f, 0.037774f, 0.681886f, 0.985285f, 0.758458f, 0.223289f, 0.518323f,
0.016640f, 0.851469f, 0.419549f, 0.806534f, 0.899848f, 0.306299f, 0.171326f, 0.216497f, 0.803684f, 0.667974f,
0.925713f, 0.921840f, 0.490611f, 0.146071f, 0.733536f, 0.234555f, 0.320498f, 0.616284f, 0.140807f, 0.483870f,
0.511105f, 0.287845f, 0.288679f, 0.031593f, 0.120686f, 0.815899f, 0.521317f, 0.143200f, 0.762007f, 0.269712f,
0.820900f, 0.410358f, 0.267518f, 0.813077f, 0.049543f, 0.579731f, 0.174699f, 0.579100f, 0.198804f, 0.666984f,
0.739047f, 0.983441f, 0.838478f, 0.020936f, 0.477937f, 0.289272f, 0.277285f, 0.911481f, 0.294650f, 0.816431f,
0.703924f, 0.608577f, 0.685188f, 0.620375f, 0.284589f, 0.523094f, 0.199020f, 0.881161f, 0.924850f, 0.273278f,
0.010727f, 0.234265f, 0.496399f, 0.151157f, 0.742478f, 0.952813f, 0.235226f, 0.483654f, 0.207393f, 0.442791f,
0.539599f, 0.348835f, 0.883911f, 0.901890f, 0.435881f, 0.186987f, 0.205418f, 0.868900f, 0.314134f, 0.319886f,
0.074946f, 0.946844f, 0.270767f, 0.962385f, 0.357861f, 0.205062f, 0.180145f, 0.739660f, 0.788586f, 0.617177f,
0.697092f, 0.639436f, 0.158736f, 0.795070f, 0.298950f, 0.327876f, 0.011846f, 0.851609f, 0.739723f, 0.393707f,
0.633559f, 0.702379f, 0.266767f, 0.098433f, 0.205048f, 0.757918f, 0.431109f, 0.887992f, 0.596331f, 0.416129f,
0.352460f, 0.578028f, 0.779303f, 0.592058f, 0.393258f, 0.819222f, 0.869020f, 0.543826f, 0.326133f, 0.976687f,
0.957858f, 0.540446f, 0.060735f, 0.532443f, 0.789059f, 0.952882f, 0.600131f, 0.906696f, 0.510526f, 0.392610f,
0.106030f, 0.830379f, 0.122368f, 0.849985f, 0.337923f, 0.790161f, 0.600905f, 0.915584f, 0.216414f, 0.060849f,
0.042873f, 0.574170f, 0.631522f, 0.059174f, 0.218738f, 0.442347f, 0.396861f, 0.698789f, 0.832624f, 0.681913f,
0.795233f, 0.884340f, 0.986386f, 0.102326f, 0.908923f, 0.080397f, 0.413893f, 0.763165f, 0.096384f, 0.636581f,
0.935920f, 0.618841f, 0.055395f, 0.010619f, 0.277275f, 0.508987f, 0.249908f, 0.003712f, 0.481014f, 0.651060f,
0.391161f, 0.788106f, 0.557732f, 0.382939f, 0.399357f, 0.173287f, 0.725427f, 0.984504f, 0.426132f, 0.576950f,
0.429113f, 0.365499f, 0.732629f, 0.332548f, 0.303371f, 0.798049f, 0.481213f, 0.351836f, 0.713382f, 0.418085f,
0.052517f, 0.530328f, 0.177752f, 0.011436f, 0.728336f, 0.839002f, 0.964952f, 0.920968f, 0.301479f, 0.805931f,
0.429060f, 0.072121f, 0.900521f, 0.889339f, 0.565757f, 0.044677f, 0.157879f, 0.397395f, 0.878262f, 0.600167f,
0.331052f, 0.015061f, 0.716786f, 0.864665f, 0.734016f, 0.776424f, 0.195433f, 0.169796f, 0.303361f, 0.839999f,
0.712385f, 0.829367f, 0.306874f, 0.410468f, 0.337255f, 0.438516f, 0.688575f, 0.373383f, 0.567838f, 0.512722f,
0.743835f, 0.148780f, 0.794075f, 0.711643f, 0.207629f, 0.765361f, 0.625398f, 0.767629f, 0.422645f, 0.215639f,
0.364543f, 0.651118f, 0.845472f, 0.761803f, 0.266697f, 0.623154f, 0.835784f, 0.981575f, 0.809148f, 0.815505f,
0.938673f, 0.056669f, 0.830491f, 0.015922f, 0.789133f, 0.161737f, 0.444714f, 0.700994f, 0.442404f, 0.113205f,
0.863449f, 0.898383f, 0.694091f, 0.148627f, 0.806452f, 0.295009f, 0.382753f, 0.599728f, 0.736479f, 0.883547f,
0.298400f, 0.485089f, 0.309627f, 0.227191f, 0.646389f, 0.271179f, 0.219907f, 0.406446f, 0.320866f, 0.731713f,
0.327662f, 0.819966f, 0.711619f, 0.458910f, 0.884780f, 0.628001f, 0.575548f, 0.594567f, 0.432881f, 0.927470f,
0.945487f, 0.106147f, 0.410248f, 0.004798f, 0.487017f, 0.168859f, 0.768989f, 0.696421f, 0.343003f, 0.818804f,
0.610405f, 0.795637f, 0.869286f, 0.469053f, 0.931275f, 0.086848f, 0.753057f, 0.950017f, 0.887416f, 0.918497f,
0.239417f, 0.455908f, 0.452284f, 0.108339f, 0.897700f, 0.711506f, 0.985196f, 0.205179f, 0.039514f, 0.447864f,
0.295197f, 0.218009f, 0.629094f, 0.179648f, 0.553785f, 0.466964f, 0.149783f, 0.915540f, 0.601481f, 0.727465f,
0.409541f, 0.390038f, 0.856307f, 0.877786f, 0.805053f, 0.585143f, 0.063807f, 0.998872f, 0.197760f, 0.211582f,
0.318230f, 0.960291f, 0.907892f, 0.505576f, 0.889433f, 0.223786f, 0.361017f, 0.826659f, 0.441609f, 0.109883f,
0.426332f, 0.678180f, 0.038961f, 0.468447f, 0.338902f, 0.539021f, 0.134706f, 0.784214f, 0.925365f, 0.081893f,
0.721967f, 0.796634f, 0.114200f, 0.849378f, 0.603656f, 0.029240f, 0.877047f, 0.888490f, 0.019257f, 0.179914f,
0.507307f, 0.860388f, 0.603878f, 0.262164f, 0.291662f, 0.303008f, 0.080503f, 0.365214f, 0.185868f, 0.690863f,
0.838656f, 0.613607f, 0.909790f, 0.696594f, 0.160675f, 0.722940f, 0.426526f, 0.477106f, 0.199454f, 0.736185f,
0.426119f, 0.955866f, 0.857226f, 0.474984f, 0.265056f, 0.841304f, 0.598675f, 0.882919f, 0.030993f, 0.970632f,
0.190924f, 0.168065f, 0.448812f, 0.505895f, 0.600392f, 0.351088f, 0.924764f, 0.433244f, 0.106820f, 0.234107f,
0.766937f, 0.088860f, 0.540228f, 0.942639f, 0.331918f, 0.799168f, 0.347702f, 0.479086f, 0.333668f, 0.357218f,
0.636138f, 0.051389f, 0.313866f, 0.749486f, 0.067568f, 0.185187f, 0.116481f, 0.079027f, 0.434147f, 0.864954f,
0.266012f, 0.399849f, 0.588456f, 0.488469f, 0.943602f, 0.923315f, 0.004184f, 0.208213f, 0.950168f, 0.740971f,
0.111473f, 0.174375f, 0.476040f, 0.524790f, 0.813531f, 0.642986f, 0.981088f, 0.661420f, 0.342911f, 0.046320f,
0.790619f, 0.006081f, 0.208228f, 0.680410f, 0.669833f, 0.365217f, 0.177873f, 0.725114f, 0.778850f, 0.374510f,
0.676264f, 0.163248f, 0.773496f, 0.617034f, 0.681753f, 0.754604f, 0.511468f, 0.835372f, 0.871581f, 0.704572f,
0.370273f, 0.264727f, 0.059805f, 0.892677f, 0.994587f, 0.237952f, 0.736254f, 0.556306f, 0.663940f, 0.101628f,
0.780468f, 0.921302f, 0.553991f, 0.435881f, 0.093312f, 0.213290f, 0.285950f, 0.450047f, 0.187119f, 0.622449f,
0.439040f, 0.827497f, 0.175493f, 0.414726f, 0.688921f, 0.619222f, 0.119429f, 0.142677f, 0.251579f, 0.683206f,
0.349338f, 0.104736f, 0.809097f, 0.525897f, 0.487201f, 0.358220f, 0.830520f, 0.577120f, 0.387445f, 0.208834f,
0.772651f, 0.323676f, 0.477704f, 0.623545f, 0.844339f, 0.363245f, 0.576061f, 0.661903f, 0.273937f, 0.341338f,
0.407466f, 0.139041f, 0.789645f, 0.017729f, 0.328321f, 0.160690f, 0.912851f, 0.290526f, 0.103830f, 0.878124f,
0.383734f, 0.647318f, 0.669830f, 0.135797f, 0.235106f, 0.564984f, 0.063072f, 0.755745f, 0.671146f, 0.635182f,
0.529439f, 0.624804f, 0.619590f, 0.727563f, 0.706059f, 0.723530f, 0.869686f, 0.539985f, 0.944081f, 0.073770f,
0.396826f, 0.478380f, 0.789523f, 0.714770f, 0.193024f, 0.350483f, 0.627295f, 0.384987f, 0.002547f, 0.250201f,
0.151938f, 0.393473f, 0.978592f, 0.564150f, 0.868906f, 0.062856f, 0.841789f, 0.495468f, 0.637381f, 0.088537f,
0.667576f, 0.985521f, 0.657022f, 0.055447f, 0.554059f, 0.480426f, 0.168934f, 0.181540f, 0.917418f, 0.242681f,
0.330324f, 0.240554f, 0.682908f, 0.269648f, 0.165741f, 0.338101f, 0.803878f, 0.294856f, 0.101828f, 0.104246f,
0.805647f, 0.391745f, 0.660848f, 0.247394f, 0.873713f, 0.631454f, 0.285901f, 0.496672f, 0.963878f, 0.403068f,
0.392619f, 0.499766f, 0.760310f, 0.094740f, 0.301816f, 0.929958f, 0.811814f, 0.399496f, 0.564528f, 0.974613f,
0.147164f, 0.901275f, 0.425311f, 0.079715f, 0.479819f, 0.817144f, 0.130823f, 0.114709f, 0.790077f, 0.676673f,
0.409874f, 0.897093f, 0.290661f, 0.722317f, 0.052360f, 0.697402f, 0.591755f, 0.022513f, 0.463721f, 0.016251f,
0.473408f, 0.060511f, 0.779991f, 0.919554f, 0.512433f, 0.228385f, 0.040794f, 0.808927f, 0.752028f, 0.039493f,
0.611526f, 0.938816f, 0.403406f, 0.611274f, 0.318181f, 0.651361f, 0.838251f, 0.640836f, 0.206583f, 0.204054f,
0.152887f, 0.283564f, 0.270333f, 0.861050f, 0.126389f, 0.976418f, 0.075136f, 0.045106f, 0.217459f, 0.479873f,
0.624144f, 0.118353f, 0.588617f, 0.379493f, 0.028780f, 0.818036f, 0.757394f, 0.502590f, 0.327929f, 0.391819f,
0.294520f, 0.297652f, 0.932658f, 0.099362f, 0.712131f, 0.631189f, 0.817832f, 0.340430f, 0.163421f, 0.496067f,
0.443793f, 0.423953f, 0.401901f, 0.865007f, 0.650123f, 0.838222f, 0.698443f, 0.428501f, 0.953257f, 0.923767f,
0.587928f, 0.541319f, 0.327576f, 0.266528f, 0.834924f, 0.761115f, 0.016105f, 0.443486f, 0.571573f, 0.142671f,
0.078250f, 0.094005f, 0.282414f, 0.756868f, 0.101438f, 0.263868f, 0.791235f, 0.293974f, 0.388307f, 0.413217f,
0.917388f, 0.155007f, 0.267477f, 0.028297f, 0.577707f, 0.512088f, 0.634578f, 0.547603f, 0.164973f, 0.675777f,
0.452373f, 0.122258f, 0.934511f, 0.154028f, 0.308731f, 0.111314f, 0.822383f, 0.269968f, 0.044540f, 0.989937f,
0.937356f, 0.617452f, 0.121700f, 0.617505f, 0.574567f, 0.250749f, 0.339841f, 0.069203f, 0.828972f, 0.060119f,
0.818821f, 0.096899f, 0.537702f, 0.927857f, 0.114469f, 0.759645f, 0.377100f, 0.325080f, 0.856692f, 0.119866f,
0.254054f, 0.595020f, 0.851381f, 0.755909f, 0.854514f, 0.630922f, 0.522573f, 0.630028f, 0.529326f, 0.290366f,
0.270667f, 0.502234f, 0.325450f, 0.038134f, 0.217771f, 0.125962f, 0.105524f, 0.009191f, 0.701498f, 0.358397f,
0.090037f, 0.778788f, 0.418527f, 0.738322f, 0.830532f, 0.526749f, 0.974845f, 0.808065f, 0.013169f, 0.633148f,
0.779516f, 0.875833f, 0.707280f, 0.562436f, 0.406543f, 0.108663f, 0.601704f, 0.110260f, 0.121599f, 0.886975f,
0.391729f, 0.775981f, 0.306263f, 0.490086f, 0.971780f, 0.754692f, 0.404377f, 0.996819f, 0.848787f, 0.225880f,
0.029620f, 0.883024f, 0.509813f, 0.673884f, 0.782126f, 0.000371f, 0.263337f, 0.394308f, 0.795420f, 0.054031f,
0.556003f, 0.611092f, 0.579956f, 0.573617f, 0.913766f, 0.194118f, 0.727184f, 0.289053f, 0.565804f, 0.176094f,
0.179368f, 0.424117f, 0.272572f, 0.067961f, 0.433671f, 0.483744f, 0.954193f, 0.785550f, 0.771084f, 0.966891f,
0.145325f, 0.639703f, 0.006569f, 0.974239f, 0.692137f, 0.955431f, 0.381184f, 0.470102f, 0.034999f, 0.645596f,
0.179925f, 0.578023f, 0.261826f, 0.670011f, 0.201006f, 0.353617f, 0.847023f, 0.007413f, 0.393593f, 0.841773f,
0.432795f, 0.137807f, 0.002455f, 0.104521f, 0.716400f, 0.131038f, 0.247923f, 0.298672f, 0.118800f, 0.265645f,
0.288366f, 0.447179f, 0.140431f, 0.708849f, 0.159428f, 0.646014f, 0.795681f, 0.608064f, 0.691313f, 0.048658f,
0.580951f, 0.564203f, 0.093214f, 0.921231f, 0.974757f, 0.459409f, 0.031472f, 0.908845f, 0.420137f, 0.912383f,
0.926316f, 0.879447f, 0.156093f, 0.869595f, 0.769211f, 0.189934f, 0.766785f, 0.515486f, 0.158641f, 0.396790f,
0.620885f, 0.517857f, 0.779559f, 0.856540f, 0.416523f, 0.947388f, 0.412205f, 0.798489f, 0.801703f, 0.305391f,
0.986940f, 0.035509f, 0.719429f, 0.034238f, 0.278553f, 0.840184f, 0.214169f, 0.054065f, 0.830966f, 0.202586f,
0.465296f, 0.068976f, 0.182417f, 0.242352f, 0.902201f, 0.250269f, 0.420721f, 0.653952f, 0.697841f, 0.868392f,
0.733211f, 0.234523f, 0.175558f, 0.423041f, 0.055870f, 0.135571f, 0.361868f, 0.853094f, 0.997188f, 0.621431f,
0.827328f, 0.411471f, 0.653994f, 0.063764f, 0.641240f, 0.095044f, 0.049367f, 0.670188f, 0.892037f, 0.444490f,
0.426266f, 0.460389f, 0.044302f, 0.730896f, 0.359852f, 0.621616f, 0.598989f, 0.677894f, 0.856132f, 0.656093f,
0.019082f, 0.371048f, 0.757503f, 0.818856f, 0.250711f, 0.229325f, 0.517359f, 0.650567f, 0.529200f, 0.465914f,
0.846682f, 0.696496f, 0.862995f, 0.221726f, 0.318356f, 0.988312f, 0.549903f, 0.755365f, 0.761021f, 0.321066f,
0.632137f, 0.826523f, 0.399731f, 0.631078f, 0.481981f, 0.108957f, 0.935480f, 0.138064f, 0.247518f, 0.482330f,
0.629564f, 0.282531f, 0.449850f, 0.739415f, 0.656989f, 0.010582f, 0.836195f, 0.356062f, 0.684358f, 0.569838f,
0.884463f, 0.279700f, 0.491903f, 0.485421f, 0.065827f, 0.541144f, 0.433920f, 0.380814f, 0.744862f, 0.027009f,
0.471026f, 0.607273f, 0.977598f, 0.344152f, 0.910807f, 0.205151f, 0.558731f, 0.780891f, 0.701772f, 0.997146f,
0.020330f, 0.403405f, 0.979461f, 0.241345f, 0.096608f, 0.915247f, 0.908324f, 0.271694f, 0.009698f, 0.531896f,
0.519721f, 0.346107f, 0.261284f, 0.832042f, 0.132801f, 0.533033f, 0.897910f, 0.092998f, 0.471649f, 0.404040f,
0.456318f, 0.283207f, 0.429665f, 0.226444f, 0.579847f, 0.957511f, 0.746210f, 0.605943f, 0.675456f, 0.777231f,
0.291798f, 0.405722f, 0.910105f, 0.754520f, 0.304438f, 0.135946f, 0.572188f, 0.749995f, 0.266781f, 0.634413f,
0.871521f, 0.570595f, 0.858535f, 0.032461f, 0.545841f, 0.688895f, 0.104076f, 0.716815f, 0.669155f, 0.153600f,
0.812739f, 0.661021f, 0.275497f, 0.818721f, 0.221241f, 0.335644f, 0.257255f, 0.429661f, 0.538766f, 0.211379f,
0.002455f, 0.661932f, 0.510933f, 0.471981f, 0.944992f, 0.727721f, 0.561962f, 0.813270f, 0.249512f, 0.180805f,
0.844289f, 0.851872f, 0.789990f, 0.563421f, 0.569918f, 0.936913f, 0.133690f, 0.341520f, 0.916595f, 0.104621f,
0.433434f, 0.127407f, 0.791049f, 0.347339f, 0.129342f, 0.231994f, 0.499094f, 0.347104f, 0.150166f, 0.974819f,
0.046463f, 0.000589f, 0.810319f, 0.124581f, 0.885304f, 0.284888f, 0.900014f, 0.284766f, 0.480016f, 0.086955f,
0.596967f, 0.168727f, 0.948079f, 0.335689f, 0.643182f, 0.625451f, 0.333987f, 0.821935f, 0.246888f, 0.760526f,
0.233690f, 0.473205f, 0.873906f, 0.709672f, 0.822512f, 0.856091f, 0.572910f, 0.023577f, 0.334096f, 0.028781f,
0.036125f, 0.736517f, 0.928506f, 0.760595f, 0.687393f, 0.763850f, 0.852336f, 0.699046f, 0.726038f, 0.527356f,
0.557788f, 0.024921f, 0.472296f, 0.903973f, 0.555569f, 0.469253f, 0.616753f, 0.953553f, 0.753431f, 0.142492f,
0.846352f, 0.566198f, 0.220281f, 0.721214f, 0.235007f, 0.172421f, 0.916818f, 0.552232f, 0.282115f, 0.933504f,
0.379688f, 0.882163f, 0.019065f, 0.148522f, 0.295253f, 0.868323f, 0.190626f, 0.408742f, 0.666477f, 0.222117f,
0.712796f, 0.911782f, 0.022996f, 0.292321f, 0.154467f, 0.864480f, 0.390873f, 0.429514f, 0.219826f, 0.101199f,
0.416923f, 0.295712f, 0.074481f, 0.448804f, 0.716440f, 0.514218f, 0.084866f, 0.049241f, 0.388873f, 0.925484f,
0.315536f, 0.192888f, 0.552969f, 0.409037f, 0.668053f, 0.157401f, 0.963950f, 0.834726f, 0.154146f, 0.458515f,
0.467480f, 0.522292f, 0.517184f, 0.118311f, 0.187338f, 0.468861f, 0.582050f, 0.804942f, 0.171938f, 0.007502f,
0.454971f, 0.915329f, 0.286647f, 0.558693f, 0.711814f, 0.626435f, 0.410783f, 0.430138f, 0.147133f, 0.455124f,
0.784398f, 0.569781f, 0.327035f, 0.604310f, 0.606031f, 0.562921f, 0.572204f, 0.118154f, 0.682393f, 0.298818f,
0.768051f, 0.806527f, 0.692546f, 0.380544f, 0.262441f, 0.371862f, 0.852032f, 0.306346f, 0.387092f, 0.622975f,
0.881680f, 0.411826f, 0.944446f, 0.146342f, 0.759212f, 0.393576f, 0.058663f, 0.987183f, 0.468358f, 0.213759f,
0.293946f, 0.490735f, 0.207110f, 0.302380f, 0.346862f, 0.529554f, 0.885531f, 0.861806f, 0.504326f, 0.870000f,
0.408895f, 0.930124f, 0.181852f, 0.589900f, 0.864316f, 0.864311f, 0.153297f, 0.697255f, 0.111348f, 0.595341f,
0.734935f, 0.449257f, 0.870167f, 0.933179f, 0.514936f, 0.507486f, 0.408193f, 0.908251f, 0.100098f, 0.597961f,
0.879571f, 0.433426f, 0.750294f, 0.724037f, 0.124885f, 0.469355f, 0.418992f, 0.833063f, 0.598020f, 0.203004f,
0.805586f, 0.577740f, 0.807591f, 0.237977f, 0.754675f, 0.895477f, 0.513435f, 0.145868f, 0.853924f, 0.987019f,
0.271709f, 0.796232f, 0.456903f, 0.161574f, 0.631880f, 0.653519f, 0.592433f, 0.501600f, 0.997645f, 0.853651f,
0.105593f, 0.363414f, 0.263314f, 0.972821f, 0.941831f, 0.889863f, 0.102655f, 0.068198f, 0.262138f, 0.343927f,
0.830009f, 0.572290f, 0.106264f, 0.660075f, 0.019037f, 0.761785f, 0.721786f, 0.658777f, 0.158810f, 0.012222f,
0.391043f, 0.674678f, 0.262397f, 0.854693f, 0.133282f, 0.865523f, 0.562334f, 0.876250f, 0.006743f, 0.326575f,
0.935908f, 0.029163f, 0.864510f, 0.206471f, 0.237307f, 0.213979f, 0.775999f, 0.991192f, 0.650793f, 0.963486f,
0.996479f, 0.523788f, 0.437885f, 0.082193f, 0.888966f, 0.427449f, 0.019888f, 0.060771f, 0.038055f, 0.555317f,
0.127116f, 0.065644f, 0.949085f, 0.668069f, 0.719918f, 0.370249f, 0.841676f, 0.167515f, 0.127333f, 0.754838f,
0.879579f, 0.951533f, 0.955204f, 0.989524f, 0.189059f, 0.665966f, 0.143770f, 0.845306f, 0.363440f, 0.935612f,
0.542623f, 0.302962f, 0.244319f, 0.779102f, 0.958786f, 0.884964f, 0.466509f, 0.244144f, 0.869767f, 0.998900f,
0.510268f, 0.833742f, 0.117535f, 0.041633f, 0.436896f, 0.043311f, 0.615024f, 0.435140f, 0.195664f, 0.714196f,
0.148768f, 0.851583f, 0.623333f, 0.021441f, 0.807057f, 0.977097f, 0.063878f, 0.595517f, 0.998035f, 0.256397f,
0.779065f, 0.999942f, 0.636462f, 0.923756f, 0.755913f, 0.706520f, 0.459180f, 0.854133f, 0.393866f, 0.717977f,
0.159149f, 0.396978f, 0.456182f, 0.105784f, 0.321968f, 0.870208f, 0.404366f, 0.555920f, 0.196519f, 0.025863f,
0.427676f, 0.729612f, 0.915078f, 0.098396f, 0.427346f, 0.718787f, 0.743546f, 0.710737f, 0.083477f, 0.962364f,
0.807907f, 0.663325f, 0.680387f, 0.877748f, 0.581066f, 0.855070f, 0.226495f, 0.477737f, 0.184936f, 0.990079f,
0.405861f, 0.148379f, 0.001156f, 0.139568f, 0.625273f, 0.948824f, 0.077580f, 0.762824f, 0.576742f, 0.590356f,
0.601329f, 0.437384f, 0.064890f, 0.198413f, 0.620822f, 0.808539f, 0.242850f, 0.511611f, 0.170355f, 0.498487f,
0.584338f, 0.574080f, 0.648012f, 0.060069f, 0.087149f, 0.175112f, 0.223658f, 0.638450f, 0.147936f, 0.733434f,
0.098119f, 0.746444f, 0.367900f, 0.959660f, 0.651564f, 0.149451f, 0.606327f, 0.588182f, 0.897402f, 0.845820f,
0.137510f, 0.537928f, 0.060214f, 0.696331f, 0.115674f, 0.160696f, 0.091713f, 0.358390f, 0.615339f, 0.786471f,
0.611410f, 0.099246f, 0.894485f, 0.826513f, 0.170956f, 0.073540f, 0.974214f, 0.568556f, 0.388599f, 0.115225f,
0.749609f, 0.429175f, 0.511300f, 0.408817f, 0.514032f, 0.880279f, 0.920189f, 0.279522f, 0.144023f, 0.190710f,
0.862257f, 0.790020f, 0.474595f, 0.891731f, 0.189060f, 0.819594f, 0.670656f, 0.694978f, 0.254305f, 0.389874f,
0.131818f, 0.086517f, 0.040965f, 0.684685f, 0.375522f, 0.959273f, 0.470442f, 0.485916f, 0.187237f, 0.903384f,
0.204833f, 0.139109f, 0.908748f, 0.294729f, 0.715498f, 0.269864f, 0.546055f, 0.534351f, 0.593830f, 0.471154f,
0.884374f, 0.863610f, 0.663783f, 0.014206f, 0.526436f, 0.269488f, 0.063417f, 0.322380f, 0.055787f, 0.945306f,
0.859553f, 0.153456f, 0.222952f, 0.756236f, 0.866668f, 0.735574f, 0.681356f, 0.106188f, 0.592110f, 0.378646f,
0.921652f, 0.999541f, 0.255658f, 0.692000f, 0.669800f, 0.793276f, 0.860556f, 0.079465f, 0.203402f, 0.524597f,
0.587491f, 0.276402f, 0.592893f, 0.818444f, 0.521420f, 0.918226f, 0.417367f, 0.731807f, 0.685580f, 0.309452f,
0.109550f, 0.112099f, 0.275395f, 0.908953f, 0.490644f, 0.277047f, 0.985676f, 0.520791f, 0.175756f, 0.059959f,
0.086192f, 0.480190f, 0.687833f, 0.430696f, 0.584540f, 0.906331f, 0.785898f, 0.938426f, 0.257805f, 0.373076f,
0.305545f, 0.910901f, 0.344405f, 0.601083f, 0.417151f, 0.327262f, 0.370889f, 0.373876f, 0.134342f, 0.522327f,
0.795687f, 0.848335f, 0.584675f, 0.060391f, 0.991986f, 0.658081f, 0.652433f, 0.423150f, 0.335216f, 0.041428f,
0.139712f, 0.952906f, 0.510320f, 0.180597f, 0.235575f, 0.949609f, 0.390780f, 0.567731f, 0.041333f, 0.723262f,
0.355654f, 0.154384f, 0.632881f, 0.589037f, 0.068873f, 0.275292f, 0.040330f, 0.714731f, 0.352385f, 0.887643f,
0.847144f, 0.343670f, 0.798821f, 0.333276f, 0.010456f, 0.287022f, 0.358878f, 0.516573f, 0.607732f, 0.494597f,
0.145712f, 0.082536f, 0.144781f, 0.699682f, 0.777158f, 0.927635f, 0.354852f, 0.917660f, 0.344970f, 0.873441f,
0.474278f, 0.666653f, 0.459164f, 0.434504f, 0.401515f, 0.805330f, 0.982504f, 0.303721f, 0.537129f, 0.284579f,
0.331115f, 0.535263f, 0.506871f, 0.336713f, 0.305582f, 0.913674f, 0.843272f, 0.666593f, 0.422066f, 0.867613f,
0.063579f, 0.263836f, 0.453274f, 0.782279f, 0.980571f, 0.492795f, 0.891317f, 0.366792f, 0.102997f, 0.972256f,
0.065091f, 0.706230f, 0.444802f, 0.017130f, 0.914276f, 0.258651f, 0.707473f, 0.618596f, 0.781044f, 0.486059f,
0.558475f, 0.353760f, 0.730071f, 0.478388f, 0.319197f, 0.142477f, 0.548964f, 0.370557f, 0.934121f, 0.144263f,
0.801248f, 0.538915f, 0.206068f, 0.946748f, 0.566407f, 0.903068f, 0.619315f, 0.093371f, 0.539120f, 0.465229f,
0.737624f, 0.160098f, 0.742896f, 0.338746f, 0.101658f, 0.039986f, 0.573797f, 0.530830f, 0.668519f, 0.299141f,
0.204747f, 0.544902f, 0.071030f, 0.973469f, 0.961453f, 0.637617f, 0.748494f, 0.373714f, 0.294161f, 0.504882f,
0.590358f, 0.545001f, 0.695988f, 0.321602f, 0.315328f, 0.162671f, 0.091245f, 0.280879f, 0.805257f, 0.941643f,
0.770574f, 0.545741f, 0.150852f, 0.572830f, 0.640060f, 0.969469f, 0.544605f, 0.276611f, 0.034849f, 0.424275f,
0.231193f, 0.216322f, 0.113652f, 0.986977f, 0.006252f, 0.597801f, 0.252707f, 0.642424f, 0.322868f, 0.756834f,
0.333698f, 0.840732f, 0.636966f, 0.820921f, 0.943962f, 0.517421f, 0.933003f, 0.125759f, 0.155267f, 0.188311f,
0.684619f, 0.739131f, 0.230183f, 0.140895f, 0.683814f, 0.418164f, 0.173880f, 0.674285f, 0.502847f, 0.519832f,
0.839840f, 0.666987f, 0.798760f, 0.051988f, 0.839581f, 0.328877f, 0.283170f, 0.257304f, 0.285938f, 0.896896f,
0.900198f, 0.967717f, 0.128998f, 0.431085f, 0.485530f, 0.168244f, 0.769279f, 0.606386f, 0.094635f, 0.432659f,
0.095296f, 0.020160f, 0.016273f, 0.771546f, 0.935245f, 0.924238f, 0.379407f, 0.708799f, 0.890455f, 0.084031f,
0.419932f, 0.981042f, 0.036817f, 0.251336f, 0.009253f, 0.615349f, 0.801382f, 0.867564f, 0.613757f, 0.004221f,
0.936790f, 0.026520f, 0.754187f, 0.761036f, 0.095306f, 0.944066f, 0.239791f, 0.707141f, 0.729967f, 0.270562f,
0.916490f, 0.521622f, 0.018945f, 0.562512f, 0.627398f, 0.749321f, 0.965258f, 0.072442f, 0.456435f, 0.814817f,
0.837585f, 0.585168f, 0.780178f, 0.351918f, 0.564401f, 0.780032f, 0.004387f, 0.900832f, 0.283479f, 0.354881f,
0.147538f, 0.008399f, 0.862508f, 0.719033f, 0.384591f, 0.530769f, 0.481980f, 0.532210f, 0.568038f, 0.014708f,
0.444918f, 0.774358f, 0.653342f, 0.289262f, 0.276392f, 0.317674f, 0.936694f, 0.523800f, 0.228023f, 0.238957f,
0.801224f, 0.425174f, 0.794035f, 0.177141f, 0.422003f, 0.315952f, 0.876467f, 0.122777f, 0.513231f, 0.004842f,
0.509653f, 0.257916f, 0.659487f, 0.723439f, 0.443725f, 0.915512f, 0.862202f, 0.403605f, 0.306876f, 0.641865f,
0.431786f, 0.864553f, 0.589009f, 0.515185f, 0.378503f, 0.843205f, 0.488932f, 0.016828f, 0.303192f, 0.088420f,
0.419402f, 0.240657f, 0.768248f, 0.584132f, 0.150931f, 0.280878f, 0.937832f, 0.225936f, 0.421577f, 0.567127f,
0.256095f, 0.190364f, 0.997507f, 0.418327f, 0.581014f, 0.929314f, 0.075610f, 0.562595f, 0.054037f, 0.355826f,
0.507407f, 0.518312f, 0.405592f, 0.606753f, 0.712262f, 0.443146f, 0.237865f, 0.835043f, 0.278520f, 0.363873f,
0.332375f, 0.634990f, 0.370154f, 0.581712f, 0.353407f, 0.502452f, 0.302684f, 0.749298f, 0.062031f, 0.303904f,
0.732001f, 0.011410f, 0.219522f, 0.919893f, 0.128536f, 0.172432f, 0.911372f, 0.034403f, 0.723614f, 0.408550f,
0.445899f, 0.435477f, 0.215280f, 0.405244f, 0.054495f, 0.783912f, 0.992886f, 0.129990f, 0.098508f, 0.695718f,
0.715415f, 0.059016f, 0.247174f, 0.070909f, 0.192716f, 0.831661f, 0.977020f, 0.808207f, 0.754550f, 0.552036f,
0.415547f, 0.965668f, 0.559419f, 0.068940f, 0.576726f, 0.355469f, 0.926874f, 0.161466f, 0.321485f, 0.923349f,
0.963699f, 0.150964f, 0.919049f, 0.841084f, 0.034592f, 0.379027f, 0.462720f, 0.613200f, 0.381101f, 0.364962f,
0.164940f, 0.703398f, 0.769867f, 0.170139f, 0.334225f, 0.943885f, 0.339429f, 0.967533f, 0.371123f, 0.862292f,
0.231534f, 0.769525f, 0.694391f, 0.831677f, 0.820982f, 0.399601f, 0.087335f, 0.691399f, 0.739906f, 0.272469f,
0.017141f, 0.811113f, 0.817193f, 0.645661f, 0.812604f, 0.941762f, 0.358550f, 0.172222f, 0.086826f, 0.454902f,
0.442871f, 0.643608f, 0.175195f, 0.724290f, 0.221423f, 0.704027f, 0.108296f, 0.797460f, 0.169706f, 0.049444f,
0.331687f, 0.455989f, 0.184076f, 0.340262f, 0.479645f, 0.761051f, 0.452525f, 0.956795f, 0.230884f, 0.058813f,
0.456879f, 0.552018f, 0.460122f, 0.897443f, 0.275479f, 0.602279f, 0.967408f, 0.537544f, 0.542229f, 0.804629f,
0.129388f, 0.507195f, 0.695767f, 0.634225f, 0.345001f, 0.105349f, 0.189777f, 0.796890f, 0.708225f, 0.884567f,
0.475111f, 0.963748f, 0.653431f, 0.106548f, 0.330663f, 0.832264f, 0.882624f, 0.741984f, 0.209957f, 0.069897f,
0.810694f, 0.802959f, 0.190443f, 0.050891f, 0.319540f, 0.088573f, 0.238806f, 0.075530f, 0.058857f, 0.690404f,
0.122633f, 0.478455f, 0.603660f, 0.092695f, 0.990482f, 0.333792f, 0.404898f, 0.103928f, 0.447634f, 0.546993f,
0.378279f, 0.522574f, 0.788539f, 0.810044f, 0.624091f, 0.001494f, 0.391061f, 0.674837f, 0.455895f, 0.472878f,
0.591242f, 0.699847f, 0.900700f, 0.659761f, 0.729312f, 0.692967f, 0.658828f, 0.989976f, 0.403619f, 0.132665f,
0.165766f, 0.332136f, 0.641392f, 0.483217f, 0.448643f, 0.735197f, 0.024069f, 0.250345f, 0.134509f, 0.890065f,
0.329492f, 0.237202f, 0.460476f, 0.313015f, 0.506513f, 0.795825f, 0.573196f, 0.628767f, 0.453270f, 0.648210f,
0.389678f, 0.444656f, 0.631161f, 0.692365f, 0.733767f, 0.132282f, 0.252474f, 0.209655f, 0.761413f, 0.074284f,
0.108241f, 0.700758f, 0.797205f, 0.590980f, 0.246806f, 0.530980f, 0.553499f, 0.778145f, 0.076801f, 0.353966f,
0.703877f, 0.163802f, 0.753713f, 0.802056f, 0.440706f, 0.018783f, 0.370513f, 0.649606f, 0.279261f, 0.049643f,
0.467504f, 0.023572f, 0.679311f, 0.688626f, 0.046442f, 0.960413f, 0.366046f, 0.474050f, 0.052736f, 0.424357f,
0.188624f, 0.861247f, 0.900269f, 0.105182f, 0.359200f, 0.444678f, 0.583578f, 0.739708f, 0.269139f, 0.968214f,
0.347971f, 0.781727f, 0.393834f, 0.861303f, 0.949796f, 0.806109f, 0.680522f, 0.127579f, 0.708977f, 0.046327f,
0.850606f, 0.723309f, 0.673441f, 0.248911f, 0.417743f, 0.163034f, 0.729480f, 0.198440f, 0.538510f, 0.367162f,
0.096045f, 0.063970f, 0.885894f, 0.725181f, 0.576272f, 0.003870f, 0.755848f, 0.267385f, 0.199828f, 0.368897f,
0.304060f, 0.252806f, 0.152875f, 0.607533f, 0.471291f, 0.735958f, 0.419351f, 0.869127f, 0.323699f, 0.969692f,
0.087565f, 0.219422f, 0.737259f, 0.960615f, 0.714384f, 0.897616f, 0.615669f, 0.943838f, 0.627942f, 0.166592f,
0.119100f, 0.531171f, 0.815231f, 0.160741f, 0.963008f, 0.922490f, 0.528417f, 0.567956f, 0.878363f, 0.041792f,
0.269142f, 0.940940f, 0.082333f, 0.627416f, 0.775189f, 0.204018f, 0.619973f, 0.920185f, 0.910285f, 0.528401f,
0.643417f, 0.095052f, 0.067700f, 0.531801f, 0.798116f, 0.169662f, 0.243709f, 0.688631f, 0.673253f, 0.373620f,
0.939514f, 0.919252f, 0.358728f, 0.965045f, 0.657642f, 0.567199f, 0.713176f, 0.979892f, 0.875632f, 0.673023f,
0.148420f, 0.223298f, 0.998949f, 0.792420f, 0.129569f, 0.292666f, 0.301791f, 0.137100f, 0.495179f, 0.119452f,
0.981125f, 0.288289f, 0.518247f, 0.956943f, 0.845747f, 0.951004f, 0.305835f, 0.780750f, 0.343542f, 0.148107f,
0.300686f, 0.163475f, 0.800488f, 0.090358f, 0.642755f, 0.953960f, 0.910834f, 0.570277f, 0.347857f, 0.919427f,
0.922226f, 0.850491f, 0.916783f, 0.651077f, 0.643387f, 0.713371f, 0.713708f, 0.796776f, 0.717698f, 0.687331f,
0.043035f, 0.843666f, 0.941261f, 0.102456f, 0.652209f, 0.321705f, 0.802797f, 0.628155f, 0.420204f, 0.702067f,
0.747883f, 0.043379f, 0.071049f, 0.934228f, 0.541722f, 0.140530f, 0.940320f, 0.221130f, 0.067223f, 0.618575f,
0.229684f, 0.291734f, 0.863777f, 0.090199f, 0.998972f, 0.400103f, 0.569449f, 0.327558f, 0.604967f, 0.800622f,
0.738436f, 0.175687f, 0.514928f, 0.257574f, 0.045202f, 0.581282f, 0.092215f, 0.884037f, 0.264195f, 0.620373f,
0.066222f, 0.654844f, 0.111724f, 0.056614f, 0.784645f, 0.659929f, 0.448918f, 0.395837f, 0.165165f, 0.226891f,
0.047746f, 0.664923f, 0.123590f, 0.515515f, 0.934314f, 0.761680f, 0.850362f, 0.178615f, 0.773076f, 0.767154f,
0.491220f, 0.257113f, 0.184013f, 0.244185f, 0.177631f, 0.999935f, 0.501809f, 0.030820f, 0.637761f, 0.962134f,
0.836065f, 0.433296f, 0.052368f, 0.784236f, 0.795426f, 0.013643f, 0.079298f, 0.846414f, 0.737241f, 0.398731f,
0.787977f, 0.703821f, 0.489620f, 0.027438f, 0.730304f, 0.646909f, 0.402648f, 0.142372f, 0.068553f, 0.343245f,
0.346127f, 0.110548f, 0.003418f, 0.264541f, 0.602122f, 0.483737f, 0.627600f, 0.451553f, 0.867067f, 0.999006f,
0.008321f, 0.960092f, 0.299099f, 0.506592f, 0.020342f, 0.282278f, 0.535179f, 0.561728f, 0.662314f, 0.459724f,
0.582976f, 0.147621f, 0.424455f, 0.803647f, 0.679197f, 0.880394f, 0.982620f, 0.075916f, 0.191966f, 0.864464f,
0.095679f, 0.800944f, 0.486638f, 0.608461f, 0.028556f, 0.214846f, 0.688192f, 0.436875f, 0.416415f, 0.380008f,
0.792303f, 0.976736f, 0.218256f, 0.441464f, 0.525203f, 0.042276f, 0.331306f, 0.595792f, 0.016696f, 0.994098f,
0.559884f, 0.290590f, 0.287794f, 0.618022f, 0.500697f, 0.383159f, 0.596021f, 0.614729f, 0.451438f, 0.436104f,
0.134690f, 0.514966f, 0.345897f, 0.686823f, 0.481989f, 0.906180f, 0.336489f, 0.158351f, 0.132747f, 0.369095f,
0.939360f, 0.745131f, 0.859587f, 0.014873f, 0.239535f, 0.021254f, 0.042283f, 0.522197f, 0.057059f, 0.498062f,
0.861591f, 0.762988f, 0.775337f, 0.271403f, 0.733778f, 0.469885f, 0.141473f, 0.626530f, 0.426070f, 0.266509f,
0.149388f, 0.916044f, 0.110357f, 0.768626f, 0.631309f, 0.788949f, 0.890482f, 0.576231f, 0.650053f, 0.044199f,
0.946792f, 0.002932f, 0.128608f, 0.301441f, 0.859511f, 0.203438f, 0.016743f, 0.297743f, 0.959496f, 0.616932f,
0.681855f, 0.245587f, 0.497736f, 0.551918f, 0.926013f, 0.492920f, 0.045739f, 0.840607f, 0.182091f, 0.426838f,
0.238466f, 0.368889f, 0.668095f, 0.576928f, 0.348844f, 0.031556f, 0.317058f, 0.367420f, 0.477273f, 0.833972f,
0.104310f, 0.097530f, 0.881425f, 0.329873f, 0.021019f, 0.718011f, 0.092230f, 0.006141f, 0.521711f, 0.359323f,
0.427311f, 0.008084f, 0.330510f, 0.743361f, 0.900678f, 0.178089f, 0.190476f, 0.099500f, 0.419956f, 0.335274f,
0.792024f, 0.876738f, 0.582627f, 0.191993f, 0.980273f, 0.656525f, 0.814476f, 0.674587f, 0.465019f, 0.631440f,
0.166927f, 0.731525f, 0.805359f, 0.071327f, 0.157949f, 0.968348f, 0.484171f, 0.086534f, 0.522367f, 0.909328f,
0.291713f, 0.723555f, 0.699870f, 0.848957f, 0.478494f, 0.650771f, 0.771470f, 0.381565f, 0.549427f, 0.489528f,
0.296815f, 0.487261f, 0.980407f, 0.179204f, 0.219197f, 0.570235f, 0.348630f, 0.846204f, 0.483899f, 0.538458f,
0.207819f, 0.665886f, 0.207695f, 0.885176f, 0.146803f, 0.430932f, 0.766406f, 0.974282f, 0.482332f, 0.188277f,
0.238909f, 0.060864f, 0.490858f, 0.749460f, 0.318172f, 0.965978f, 0.544438f, 0.557510f, 0.816125f, 0.599438f,
0.134713f, 0.039644f, 0.134913f, 0.236968f, 0.007855f, 0.944299f, 0.768004f, 0.039412f, 0.598217f, 0.718881f,
0.077110f, 0.102475f, 0.095404f, 0.160037f, 0.859387f, 0.057349f, 0.699771f, 0.067863f, 0.756578f, 0.865807f,
0.271136f, 0.572678f, 0.670710f, 0.159719f, 0.060575f, 0.011256f, 0.198639f, 0.477229f, 0.887112f, 0.719475f,
0.683962f, 0.442289f, 0.716465f, 0.030419f, 0.463961f, 0.358245f, 0.644224f, 0.838155f, 0.343757f, 0.474994f,
0.637861f, 0.325352f, 0.156381f, 0.467517f, 0.040577f, 0.504014f, 0.649722f, 0.429572f, 0.675838f, 0.776757f,
0.119601f, 0.552582f, 0.660295f, 0.068359f, 0.657604f, 0.989559f, 0.238076f, 0.714862f, 0.883829f, 0.169387f,
0.662442f, 0.082075f, 0.805007f, 0.313310f, 0.631202f, 0.858373f, 0.659742f, 0.291514f, 0.008486f, 0.847851f,
0.580395f, 0.861246f, 0.309866f, 0.701015f, 0.325799f, 0.982635f, 0.887644f, 0.157025f, 0.633924f, 0.273539f,
0.855790f, 0.601053f, 0.608231f, 0.039308f, 0.433793f, 0.510125f, 0.096895f, 0.190766f, 0.359687f, 0.090315f,
0.437992f, 0.608992f, 0.201320f, 0.375278f, 0.126633f, 0.579932f, 0.329916f, 0.557993f, 0.383354f, 0.127173f,
0.864207f, 0.355208f, 0.672624f, 0.969913f, 0.858586f, 0.003540f, 0.408416f, 0.646657f, 0.217317f, 0.725380f,
0.060686f, 0.101175f, 0.572276f, 0.824519f, 0.899829f, 0.868834f, 0.489204f, 0.241111f, 0.549807f, 0.890047f,
0.144277f, 0.181382f, 0.273969f, 0.363122f, 0.937677f, 0.002828f, 0.289604f, 0.344667f, 0.718758f, 0.688585f,
0.497778f, 0.598408f, 0.670827f, 0.543710f, 0.380206f, 0.750264f, 0.039259f, 0.348054f, 0.995153f, 0.511832f,
0.468324f, 0.254875f, 0.895574f, 0.470862f, 0.384283f, 0.747215f, 0.631342f, 0.752071f, 0.060259f, 0.922796f,
0.536001f, 0.898715f, 0.477379f, 0.183173f, 0.678007f, 0.510260f, 0.305148f, 0.820096f, 0.594068f, 0.069801f,
0.574268f, 0.944426f, 0.781714f, 0.911319f, 0.747449f, 0.667088f, 0.366990f, 0.715319f, 0.949923f, 0.204861f,
0.037672f, 0.401386f, 0.380624f, 0.551186f, 0.456419f, 0.721474f, 0.042094f, 0.059474f, 0.454911f, 0.708693f,
0.001627f, 0.136809f, 0.743813f, 0.385856f, 0.724767f, 0.097208f, 0.098022f, 0.500224f, 0.304496f, 0.175509f,
0.670864f, 0.093120f, 0.543803f, 0.514879f, 0.925587f, 0.088403f, 0.067566f, 0.655920f, 0.824237f, 0.724917f,
0.779473f, 0.259890f, 0.937257f, 0.554398f, 0.390890f, 0.018132f, 0.080392f, 0.194165f, 0.232438f, 0.537970f,
0.242814f, 0.534568f, 0.597185f, 0.786019f, 0.892238f, 0.420946f, 0.174214f, 0.598941f, 0.990257f, 0.944154f,
0.242698f, 0.404114f, 0.549193f, 0.539707f, 0.823972f, 0.737498f, 0.020270f, 0.224959f, 0.734439f, 0.869671f,
0.308181f, 0.451037f, 0.887934f, 0.876828f, 0.200661f, 0.759503f, 0.860318f, 0.924727f, 0.743438f, 0.102110f,
0.198284f, 0.705115f, 0.101220f, 0.263768f, 0.303158f, 0.706970f, 0.958135f, 0.903464f, 0.205429f, 0.081922f,
0.139530f, 0.297654f, 0.669954f, 0.423261f, 0.849520f, 0.588271f, 0.437530f, 0.216058f, 0.973121f, 0.409761f,
0.868293f, 0.230551f, 0.135019f, 0.847114f, 0.621252f, 0.124195f, 0.011556f, 0.555427f, 0.244444f, 0.204266f,
0.472284f, 0.681074f, 0.300730f, 0.789735f, 0.342010f, 0.554631f, 0.309102f, 0.659871f, 0.354152f, 0.976278f,
0.258015f, 0.090594f, 0.113118f, 0.337709f, 0.924737f, 0.639065f, 0.629008f, 0.109057f, 0.557999f, 0.849841f,
0.708700f, 0.495304f, 0.180904f, 0.158138f, 0.132968f, 0.317205f, 0.489310f, 0.690110f, 0.273450f, 0.421139f,
0.036378f, 0.569219f, 0.592174f, 0.066159f, 0.311327f, 0.175870f, 0.182268f, 0.305959f, 0.123858f, 0.434583f,
0.411243f, 0.872349f, 0.362109f, 0.886928f, 0.923549f, 0.717823f, 0.126270f, 0.763486f, 0.272302f, 0.174398f,
0.002911f, 0.516690f, 0.317346f, 0.633279f, 0.804501f, 0.736709f, 0.285650f, 0.047970f, 0.363773f, 0.588091f,
0.441290f, 0.647388f, 0.876002f, 0.679893f, 0.502996f, 0.611204f, 0.679407f, 0.287576f, 0.020148f, 0.796030f,
0.177768f, 0.955040f, 0.507061f, 0.072478f, 0.320861f, 0.569302f, 0.533766f, 0.268686f, 0.684020f, 0.878733f,
0.373926f, 0.523000f, 0.120955f, 0.623260f, 0.150440f, 0.650913f, 0.036034f, 0.521816f, 0.829479f, 0.034340f,
0.182681f, 0.203300f, 0.002863f, 0.426344f, 0.814766f, 0.201470f, 0.714709f, 0.341163f, 0.464021f, 0.318074f,
0.037388f, 0.350474f, 0.671021f, 0.427455f, 0.483349f, 0.213352f, 0.956132f, 0.223175f, 0.667103f, 0.728962f,
0.622328f, 0.248905f, 0.203625f, 0.903958f, 0.856599f, 0.053983f, 0.637915f, 0.690977f, 0.347384f, 0.638061f,
0.942013f, 0.281632f, 0.081446f, 0.719522f, 0.616876f, 0.661236f, 0.122890f, 0.891210f, 0.767577f, 0.735717f,
0.745328f, 0.507566f, 0.406820f, 0.122659f, 0.075582f, 0.772956f, 0.474904f, 0.018335f, 0.988726f, 0.718766f,
0.515608f, 0.823498f, 0.988728f, 0.380030f, 0.076498f, 0.322956f, 0.510816f, 0.930318f, 0.667397f, 0.913604f,
0.636078f, 0.624768f, 0.344299f, 0.577257f, 0.214413f, 0.458799f, 0.977726f, 0.523655f, 0.522848f, 0.352366f,
0.977277f, 0.576836f, 0.682677f, 0.653812f, 0.714824f, 0.883779f, 0.594718f, 0.713720f, 0.363813f, 0.176563f,
0.384884f, 0.649588f, 0.619834f, 0.616146f, 0.628569f, 0.610198f, 0.574882f, 0.791079f, 0.536651f, 0.713412f,
0.656475f, 0.017640f, 0.356289f, 0.232694f, 0.632304f, 0.009745f, 0.420612f, 0.974729f, 0.147191f, 0.620729f,
0.476191f, 0.068136f, 0.518288f, 0.972013f, 0.233654f, 0.891758f, 0.177160f, 0.517812f, 0.904571f, 0.542007f,
0.620670f, 0.712573f, 0.126354f, 0.999602f, 0.824569f, 0.496225f, 0.401495f, 0.504185f, 0.111824f, 0.263377f,
0.557174f, 0.974130f, 0.296403f, 0.390349f, 0.389167f, 0.779231f, 0.713750f, 0.027501f, 0.362556f, 0.203905f,
0.150266f, 0.900331f, 0.163970f, 0.200352f, 0.376988f, 0.069061f, 0.117929f, 0.746427f, 0.162577f, 0.221614f,
0.554407f, 0.555455f, 0.813986f, 0.121671f, 0.793475f, 0.982108f, 0.409675f, 0.463470f, 0.720701f, 0.384545f,
0.811073f, 0.538454f, 0.593826f, 0.745011f, 0.146491f, 0.821314f, 0.030380f, 0.837662f, 0.788042f, 0.218906f,
0.251663f, 0.322766f, 0.966965f, 0.726477f, 0.138991f, 0.589185f, 0.949955f, 0.923878f, 0.976004f, 0.992832f,
0.676104f, 0.568061f, 0.259183f, 0.325856f, 0.665427f, 0.841372f, 0.107596f, 0.424876f, 0.328059f, 0.988983f,
0.622951f, 0.759100f, 0.568320f, 0.365507f, 0.567865f, 0.671970f, 0.225066f, 0.849913f, 0.160301f, 0.103951f,
0.036863f, 0.727285f, 0.817896f, 0.522158f, 0.069378f, 0.544561f, 0.711999f, 0.931160f, 0.538466f, 0.095579f,
0.370931f, 0.936682f, 0.285194f, 0.065143f, 0.367809f, 0.153255f, 0.150107f, 0.680630f, 0.969314f, 0.704050f,
0.052118f, 0.110127f, 0.894807f, 0.553139f, 0.734328f, 0.871331f, 0.803290f, 0.322398f, 0.198059f, 0.721614f,
0.849098f, 0.879345f, 0.521987f, 0.688087f, 0.633012f, 0.226708f, 0.008063f, 0.314337f, 0.871864f, 0.277358f,
0.166672f, 0.795660f, 0.533041f, 0.372788f, 0.341319f, 0.610335f, 0.887490f, 0.501713f, 0.014019f, 0.466280f,
0.076775f, 0.076831f, 0.000189f, 0.177160f, 0.534578f, 0.097257f, 0.698562f, 0.071413f, 0.120116f, 0.074231f,
0.839464f, 0.192156f, 0.597758f, 0.591464f, 0.600865f, 0.774186f, 0.355580f, 0.235786f, 0.799407f, 0.502765f,
0.503588f, 0.178626f, 0.018889f, 0.381733f, 0.849854f, 0.215827f, 0.139217f, 0.100164f, 0.906970f, 0.656079f,
0.483071f, 0.529724f, 0.594414f, 0.777148f, 0.328344f, 0.190639f, 0.376099f, 0.891726f, 0.544294f, 0.219937f,
0.746341f, 0.542704f, 0.186955f, 0.670791f, 0.484959f, 0.640036f, 0.618426f, 0.290502f, 0.946852f, 0.676356f,
0.038531f, 0.404151f, 0.356867f, 0.430294f, 0.727392f, 0.958459f, 0.696116f, 0.689507f, 0.776100f, 0.066808f,
0.648680f, 0.317018f, 0.712284f, 0.298753f, 0.006370f, 0.836466f, 0.875421f, 0.640891f, 0.784699f, 0.099181f,
0.485085f, 0.981227f, 0.254401f, 0.282056f, 0.879907f, 0.021329f, 0.077112f, 0.330389f, 0.150381f, 0.900614f,
0.966742f, 0.423120f, 0.002072f, 0.065754f, 0.723194f, 0.026141f, 0.036780f, 0.643946f, 0.722622f, 0.248590f,
0.402928f, 0.402468f, 0.235426f, 0.746723f, 0.897883f, 0.278808f, 0.028477f, 0.294069f, 0.882760f, 0.744804f,
0.953333f, 0.510302f, 0.259283f, 0.328796f, 0.049279f, 0.231284f, 0.650390f, 0.576273f, 0.128683f, 0.410786f,
0.299761f, 0.377933f, 0.336422f, 0.420473f, 0.273881f, 0.151557f, 0.803422f, 0.203458f, 0.421009f, 0.261190f,
0.687450f, 0.319382f, 0.960328f, 0.456158f, 0.251099f, 0.803673f, 0.336747f, 0.911249f, 0.985705f, 0.627107f,
0.168122f, 0.861400f, 0.377679f, 0.339930f, 0.350767f, 0.836944f, 0.937310f, 0.686286f, 0.599779f, 0.205124f,
0.538658f, 0.842453f, 0.144380f, 0.175637f, 0.608407f, 0.638760f, 0.933368f, 0.575851f, 0.553227f, 0.659949f,
0.517209f, 0.578407f, 0.442003f, 0.971876f, 0.913149f, 0.390724f, 0.259105f, 0.059754f, 0.505807f, 0.257723f,
0.697041f, 0.284551f, 0.646010f, 0.947431f, 0.809977f, 0.742915f, 0.017567f, 0.080449f, 0.278815f, 0.549472f,
0.997956f, 0.901051f, 0.312188f, 0.201805f, 0.757585f, 0.197487f, 0.819650f, 0.797755f, 0.226545f, 0.503113f,
0.502030f, 0.390471f, 0.407398f, 0.585957f, 0.540651f, 0.673382f, 0.492787f, 0.333179f, 0.476562f, 0.322000f,
0.757999f, 0.206759f, 0.150906f, 0.872969f, 0.309576f, 0.177404f, 0.428792f, 0.724875f, 0.709889f, 0.635337f,
0.844884f, 0.893419f, 0.105885f, 0.631575f, 0.056065f, 0.848255f, 0.095773f, 0.143915f, 0.587803f, 0.289437f,
0.038001f, 0.504451f, 0.690334f, 0.627179f, 0.851266f, 0.060257f, 0.081512f, 0.904174f, 0.117630f, 0.589179f,
0.240555f, 0.767469f, 0.478755f, 0.039189f, 0.275816f, 0.673627f, 0.363836f, 0.284478f, 0.967213f, 0.617168f,
0.488796f, 0.958021f, 0.225543f, 0.763576f, 0.974593f, 0.514669f, 0.688662f, 0.903021f, 0.487202f, 0.247090f,
0.675176f, 0.203290f, 0.979096f, 0.787239f, 0.930354f, 0.050118f, 0.011981f, 0.724074f, 0.065617f, 0.226620f,
0.828019f, 0.629775f, 0.288852f, 0.364248f, 0.156331f, 0.339651f, 0.550873f, 0.628113f, 0.288935f, 0.612467f,
0.554436f, 0.016717f, 0.221570f, 0.937428f, 0.976441f, 0.168302f, 0.818410f, 0.393251f, 0.469256f, 0.543141f,
0.296034f, 0.920820f, 0.374915f, 0.632253f, 0.397701f, 0.248799f, 0.044546f, 0.996287f, 0.786946f, 0.911519f,
0.440353f, 0.194726f, 0.593729f, 0.859430f, 0.191638f, 0.006591f, 0.994442f, 0.215040f, 0.550370f, 0.865301f,
0.519717f, 0.879148f, 0.103775f, 0.940386f, 0.761603f, 0.359347f, 0.750162f, 0.149392f, 0.567875f, 0.275148f,
0.548576f, 0.874601f, 0.116595f, 0.926311f, 0.242084f, 0.910231f, 0.862926f, 0.712226f, 0.325846f, 0.177345f,
0.497854f, 0.251464f, 0.281514f, 0.441974f, 0.511468f, 0.211689f, 0.727208f, 0.214996f, 0.653458f, 0.504796f,
0.937991f, 0.050032f, 0.081036f, 0.747114f, 0.011704f, 0.273347f, 0.713194f, 0.337129f, 0.759229f, 0.379161f,
0.676910f, 0.042841f, 0.792726f, 0.177094f, 0.656482f, 0.998965f, 0.906546f, 0.987593f, 0.313864f, 0.328198f,
0.850857f, 0.169151f, 0.424862f, 0.495754f, 0.855949f, 0.715937f, 0.850838f, 0.467912f, 0.712290f, 0.709076f,
0.364919f, 0.973077f, 0.349509f, 0.414185f, 0.042446f, 0.123739f, 0.113286f, 0.052779f, 0.674967f, 0.972563f,
0.289104f, 0.064283f, 0.733988f, 0.074271f, 0.782368f, 0.775442f, 0.342827f, 0.028030f, 0.356429f, 0.463048f,
0.915652f, 0.218372f, 0.985815f, 0.948551f, 0.413524f, 0.878172f, 0.878374f, 0.703545f, 0.218647f, 0.303232f,
0.567284f, 0.360992f, 0.966365f, 0.350511f, 0.151471f, 0.493557f, 0.019466f, 0.137577f, 0.650433f, 0.083153f,
0.555411f, 0.598546f, 0.947484f, 0.188601f, 0.055746f, 0.883494f, 0.928931f, 0.909715f, 0.659728f, 0.444094f,
0.509564f, 0.396131f, 0.671552f, 0.351141f, 0.733915f, 0.871801f, 0.522901f, 0.684380f, 0.964762f, 0.136331f,
0.010142f, 0.285057f, 0.537869f, 0.242010f, 0.799887f, 0.221026f, 0.803922f, 0.889053f, 0.952628f, 0.674464f,
0.766252f, 0.352790f, 0.302482f, 0.190685f, 0.148342f, 0.282918f, 0.227669f, 0.584731f, 0.419165f, 0.222762f,
0.609184f, 0.065743f, 0.801537f, 0.262962f, 0.791319f, 0.221204f, 0.426725f, 0.103500f, 0.025403f, 0.529237f,
0.590132f, 0.761838f, 0.593639f, 0.267419f, 0.244318f, 0.494700f, 0.757880f, 0.296722f, 0.970691f, 0.667327f,
0.131306f, 0.047382f, 0.589296f, 0.208963f, 0.690735f, 0.879250f, 0.114727f, 0.952039f, 0.333861f, 0.872084f,
0.528489f, 0.040185f, 0.466187f, 0.146675f, 0.893371f, 0.096871f, 0.041525f, 0.003432f, 0.411808f, 0.746781f,
0.783298f, 0.689221f, 0.009285f, 0.368955f, 0.233067f, 0.609890f, 0.133560f, 0.104270f, 0.013570f, 0.175324f,
0.316137f, 0.069820f, 0.196740f, 0.974257f, 0.325487f, 0.873478f, 0.030626f, 0.571761f, 0.060881f, 0.129582f,
0.422346f, 0.008788f, 0.942117f, 0.172039f, 0.116246f, 0.365006f, 0.303281f, 0.229488f, 0.613024f, 0.141174f,
0.867867f, 0.769481f, 0.392171f, 0.096148f, 0.518478f, 0.832993f, 0.460232f, 0.040509f, 0.599105f, 0.028215f,
0.732237f, 0.627592f, 0.878641f, 0.683656f, 0.371900f, 0.620122f, 0.164102f, 0.484658f, 0.000595f, 0.556596f,
0.302696f, 0.682471f, 0.102505f, 0.646989f, 0.166315f, 0.681470f, 0.117713f, 0.832949f, 0.472540f, 0.465723f,
0.931063f, 0.025354f, 0.269733f, 0.624328f, 0.147178f, 0.872816f, 0.201110f, 0.900762f, 0.703342f, 0.127715f,
0.970352f, 0.293831f, 0.474993f, 0.837786f, 0.001948f, 0.721523f, 0.315138f, 0.737721f, 0.150542f, 0.102654f,
0.161693f, 0.478936f, 0.058643f, 0.225614f, 0.647910f, 0.907397f, 0.775827f, 0.531587f, 0.847716f, 0.255990f,
0.156154f, 0.296256f, 0.508650f, 0.986339f, 0.661807f, 0.459514f, 0.148903f, 0.744742f, 0.898575f, 0.505409f,
0.957513f, 0.757565f, 0.708799f, 0.948627f, 0.846609f, 0.620854f, 0.004482f, 0.381423f, 0.571295f, 0.644910f,
0.795891f, 0.321818f, 0.788608f, 0.257478f, 0.501590f, 0.039095f, 0.924094f, 0.900703f, 0.198622f, 0.218706f,
0.500344f, 0.177277f, 0.121165f, 0.246175f, 0.155024f, 0.133650f, 0.009353f, 0.069306f, 0.269330f, 0.902963f,
0.347746f, 0.576100f, 0.882815f, 0.201299f, 0.585661f, 0.349895f, 0.819946f, 0.301618f, 0.712467f, 0.118469f,
0.931086f, 0.543446f, 0.632623f, 0.716482f, 0.150192f, 0.143393f, 0.517715f, 0.225207f, 0.053806f, 0.602321f,
0.546219f, 0.462867f, 0.420796f, 0.883199f, 0.634234f, 0.013263f, 0.538350f, 0.156153f, 0.701885f, 0.382302f,
0.346639f, 0.907273f, 0.071328f, 0.031376f, 0.707314f, 0.063126f, 0.584103f, 0.076394f, 0.325852f, 0.822864f,
0.281779f, 0.104171f, 0.135493f, 0.502683f, 0.132069f, 0.008793f, 0.705564f, 0.126138f, 0.928483f, 0.089390f,
0.030173f, 0.565790f, 0.372231f, 0.816465f, 0.528609f, 0.974369f, 0.103514f, 0.436904f, 0.262784f, 0.620429f,
0.953420f, 0.468596f, 0.953683f, 0.926613f, 0.455200f, 0.885391f, 0.655704f, 0.024417f, 0.367131f, 0.179052f,
0.310217f, 0.292159f, 0.466651f, 0.708162f, 0.183781f, 0.388301f, 0.789323f, 0.943071f, 0.458713f, 0.750198f,
0.412016f, 0.193087f, 0.403971f, 0.779488f, 0.627748f, 0.685222f, 0.913642f, 0.591785f, 0.580048f, 0.575124f,
0.718310f, 0.543882f, 0.010563f, 0.589462f, 0.319332f, 0.880428f, 0.770757f, 0.107638f, 0.183061f, 0.635759f,
0.797724f, 0.493759f, 0.162287f, 0.627496f, 0.634975f, 0.985342f, 0.107541f, 0.614995f, 0.979650f, 0.378861f,
0.019179f, 0.807456f, 0.627807f, 0.078474f, 0.634709f, 0.291911f, 0.381957f, 0.535015f, 0.904383f, 0.474208f,
0.954261f, 0.093772f, 0.348043f, 0.701175f, 0.975075f, 0.102384f, 0.262783f, 0.529182f, 0.135970f, 0.192415f,
0.274048f, 0.460268f, 0.690988f, 0.536266f, 0.738401f, 0.470827f, 0.618529f, 0.803360f, 0.937178f, 0.141379f,
0.309276f, 0.260873f, 0.300045f, 0.797457f, 0.310275f, 0.561609f, 0.981703f, 0.393817f, 0.449868f, 0.833879f,
0.562377f, 0.931220f, 0.625770f, 0.099080f, 0.211935f, 0.830082f, 0.409945f, 0.353179f, 0.839504f, 0.600679f,
0.800132f, 0.758073f, 0.182264f, 0.789514f, 0.555546f, 0.714555f, 0.758590f, 0.661134f, 0.577694f, 0.655531f,
0.627559f, 0.242637f, 0.652415f, 0.497763f, 0.349817f, 0.773479f, 0.866458f, 0.165623f, 0.040932f, 0.291168f,
0.737250f, 0.792266f, 0.498181f, 0.688871f, 0.774055f, 0.770068f, 0.788209f, 0.309331f, 0.680969f, 0.601805f,
0.650256f, 0.684295f, 0.774505f, 0.878147f, 0.111792f, 0.931973f, 0.522307f, 0.702336f, 0.019034f, 0.072022f,
0.699481f, 0.824932f, 0.493757f, 0.725507f, 0.523713f, 0.195440f, 0.572991f, 0.806046f, 0.342785f, 0.581702f,
0.620541f, 0.308414f, 0.541691f, 0.682756f, 0.860643f, 0.678971f, 0.581883f, 0.426913f, 0.584518f, 0.773589f,
0.483625f, 0.787696f, 0.110719f, 0.790772f, 0.645045f, 0.698185f, 0.482374f, 0.862226f, 0.457822f, 0.420058f,
0.131870f, 0.949610f, 0.177746f, 0.129301f, 0.265434f, 0.790311f, 0.097889f, 0.262884f, 0.106803f, 0.751123f,
0.485733f, 0.843563f, 0.941586f, 0.382101f, 0.495606f, 0.723217f, 0.220213f, 0.511861f, 0.307454f, 0.987575f,
0.960037f, 0.382773f, 0.124114f, 0.709079f, 0.713090f, 0.455637f, 0.463603f, 0.419078f, 0.003857f, 0.114800f,
0.069004f, 0.106647f, 0.146513f, 0.119474f, 0.677178f, 0.491244f, 0.178874f, 0.335254f, 0.474776f, 0.820424f,
0.262063f, 0.361730f, 0.732985f, 0.259407f, 0.262117f, 0.679526f, 0.741222f, 0.712479f, 0.058904f, 0.510971f,
0.772676f, 0.682764f, 0.693823f, 0.424115f, 0.166148f, 0.467720f, 0.108529f, 0.157984f, 0.645176f, 0.803921f,
0.112637f, 0.965296f, 0.006193f, 0.527502f, 0.074404f, 0.710167f, 0.096536f, 0.084356f, 0.942051f, 0.330721f,
0.902400f, 0.686457f, 0.149886f, 0.693158f, 0.068904f, 0.329102f, 0.592199f, 0.875143f, 0.674583f, 0.415584f,
0.897519f, 0.307327f, 0.511057f, 0.177824f, 0.880797f, 0.782598f, 0.847473f, 0.788773f, 0.285869f, 0.465639f,
0.922956f, 0.565938f, 0.619771f, 0.978487f, 0.916203f, 0.398448f, 0.275486f, 0.815981f, 0.860965f, 0.135691f,
0.119549f, 0.693766f, 0.249296f, 0.671981f, 0.098881f, 0.744759f, 0.108796f, 0.376013f, 0.892183f, 0.540614f,
0.552982f, 0.250974f, 0.154257f, 0.087728f, 0.877994f, 0.152525f, 0.421211f, 0.799508f, 0.798882f, 0.048648f,
0.088708f, 0.119367f, 0.618459f, 0.676095f, 0.427482f, 0.613125f, 0.636577f, 0.988655f, 0.995269f, 0.776942f,
0.518079f, 0.951114f, 0.488870f, 0.353721f, 0.690149f, 0.378827f, 0.415845f, 0.220865f, 0.746019f, 0.969115f,
0.455866f, 0.901696f, 0.412365f, 0.820822f, 0.056446f, 0.192074f, 0.761215f, 0.380355f, 0.963835f, 0.376892f,
0.430381f, 0.162827f, 0.819285f, 0.856025f, 0.512781f, 0.057844f, 0.549950f, 0.264412f, 0.588957f, 0.844024f,
0.709834f, 0.820610f, 0.787956f, 0.098154f, 0.044692f, 0.781028f, 0.086614f, 0.056769f, 0.516482f, 0.043933f,
0.127298f, 0.599785f, 0.930012f, 0.909673f, 0.869662f, 0.698834f, 0.052713f, 0.772689f, 0.100166f, 0.812466f,
0.954366f, 0.876754f, 0.556541f, 0.810825f, 0.780790f, 0.610661f, 0.811131f, 0.205538f, 0.286050f, 0.815723f,
0.529425f, 0.289316f, 0.708369f, 0.888609f, 0.273159f, 0.443298f, 0.791602f, 0.742576f, 0.302770f, 0.755621f,
0.310531f, 0.866184f, 0.024884f, 0.630007f, 0.097496f, 0.001817f, 0.200794f, 0.085543f, 0.259388f, 0.175268f,
0.850464f, 0.509953f, 0.732922f, 0.057092f, 0.431653f, 0.889317f, 0.597080f, 0.893960f, 0.173888f, 0.494684f,
0.591970f, 0.406796f, 0.038819f, 0.264702f, 0.831081f, 0.399550f, 0.274116f, 0.195811f, 0.326570f, 0.020326f,
0.987084f, 0.141740f, 0.248955f, 0.044517f, 0.780094f, 0.281792f, 0.609188f, 0.676189f, 0.781907f, 0.728188f,
0.679327f, 0.246366f, 0.009331f, 0.796160f, 0.207101f, 0.781073f, 0.760659f, 0.994827f, 0.744557f, 0.486967f,
0.811172f, 0.123337f, 0.671755f, 0.222520f, 0.641347f, 0.630018f, 0.964821f, 0.624990f, 0.853168f, 0.915357f,
0.711737f, 0.973485f, 0.024457f, 0.022141f, 0.135210f, 0.203250f, 0.950076f, 0.797158f, 0.290422f, 0.370193f,
0.679522f, 0.631406f, 0.712651f, 0.001382f, 0.521127f, 0.069614f, 0.502176f, 0.764782f, 0.176405f, 0.008181f,
0.048018f, 0.265589f, 0.869258f, 0.152493f, 0.023553f, 0.295010f, 0.140308f, 0.047384f, 0.215740f, 0.700557f,
0.378311f, 0.944671f, 0.732455f, 0.027048f, 0.375878f, 0.336740f, 0.667204f, 0.617206f, 0.179205f, 0.486349f,
0.695213f, 0.667354f, 0.641104f, 0.613048f, 0.124945f, 0.266529f, 0.941834f, 0.683609f, 0.362301f, 0.099949f,
0.790522f, 0.797979f, 0.416673f, 0.658065f, 0.490797f, 0.581817f, 0.330505f, 0.979450f, 0.890884f, 0.307034f,
0.325465f, 0.504591f, 0.597206f, 0.935142f, 0.696276f, 0.734851f, 0.546884f, 0.472904f, 0.734825f, 0.358909f,
0.432374f, 0.560829f, 0.873172f, 0.899412f, 0.040389f, 0.576992f, 0.703012f, 0.498766f, 0.739720f, 0.985494f,
0.085905f, 0.549570f, 0.371733f, 0.983652f, 0.703407f, 0.994092f, 0.620833f, 0.135313f, 0.075822f, 0.745586f,
0.006331f, 0.957397f, 0.223094f, 0.435669f, 0.163831f, 0.910898f, 0.698439f, 0.087798f, 0.648773f, 0.442768f,
0.969126f, 0.913967f, 0.675123f, 0.192738f, 0.048202f, 0.902035f, 0.153566f, 0.069009f, 0.183809f, 0.639158f,
0.407574f, 0.099144f, 0.503766f, 0.715370f, 0.960095f, 0.488407f, 0.590209f, 0.521755f, 0.953280f, 0.464959f,
0.325807f, 0.129602f, 0.127404f, 0.072958f, 0.010204f, 0.020685f, 0.822141f, 0.421303f, 0.669508f, 0.199860f,
0.196793f, 0.110950f, 0.903019f, 0.539724f, 0.929240f, 0.751350f, 0.389271f, 0.942085f, 0.218816f, 0.752260f,
0.545626f, 0.697850f, 0.915485f, 0.754205f, 0.614257f, 0.270236f, 0.328717f, 0.187755f, 0.796305f, 0.426747f,
0.140995f, 0.143214f, 0.559701f, 0.512606f, 0.806352f, 0.680080f, 0.116544f, 0.172304f, 0.649046f, 0.641489f,
0.618713f, 0.323315f, 0.312256f, 0.176321f, 0.574667f, 0.339595f, 0.042065f, 0.707318f, 0.758700f, 0.041941f,
0.864702f, 0.030331f, 0.914447f, 0.116398f, 0.401071f, 0.042938f, 0.988826f, 0.965536f, 0.299595f, 0.309149f,
0.964296f, 0.972451f, 0.750872f, 0.632948f, 0.388387f, 0.176032f, 0.685281f, 0.664411f, 0.654519f, 0.828040f,
0.051523f, 0.093621f, 0.382039f, 0.910436f, 0.367947f, 0.545822f, 0.791412f, 0.909387f, 0.702659f, 0.287221f,
0.346481f, 0.331417f, 0.155371f, 0.807522f, 0.635173f, 0.267776f, 0.896204f, 0.260797f, 0.012668f, 0.755984f,
0.776694f, 0.557253f, 0.549366f, 0.217223f, 0.210006f, 0.067272f, 0.444872f, 0.374998f, 0.554208f, 0.074449f,
0.021002f, 0.420537f, 0.896528f, 0.732898f, 0.912397f, 0.535758f, 0.259743f, 0.879269f, 0.613190f, 0.023790f,
0.160534f, 0.114811f, 0.313245f, 0.744392f, 0.086594f, 0.242915f, 0.670394f, 0.790195f, 0.914675f, 0.632976f,
0.860277f, 0.705162f, 0.808059f, 0.767356f, 0.225743f, 0.419900f, 0.907039f, 0.464279f, 0.065476f, 0.566460f,
0.693596f, 0.142782f, 0.147058f, 0.994841f, 0.124029f, 0.926141f, 0.052695f, 0.692419f, 0.239220f, 0.378558f,
0.545807f, 0.208104f, 0.868372f, 0.870417f, 0.869652f, 0.539152f, 0.673928f, 0.724995f, 0.875036f, 0.052900f,
0.937031f, 0.152193f, 0.980956f, 0.896082f, 0.111896f, 0.651681f, 0.170361f, 0.229633f, 0.700905f, 0.018475f,
0.792966f, 0.385222f, 0.067157f, 0.555933f, 0.033450f, 0.261013f, 0.273993f, 0.674254f, 0.113565f, 0.855838f,
0.066507f, 0.009368f, 0.200335f, 0.188693f, 0.620959f, 0.728795f, 0.852512f, 0.057667f, 0.438278f, 0.569942f,
0.036120f, 0.118289f, 0.613461f, 0.088375f, 0.961931f, 0.540526f, 0.791579f, 0.688769f, 0.782740f, 0.811624f,
0.146945f, 0.366981f, 0.109940f, 0.427676f, 0.073489f, 0.887145f, 0.191680f, 0.059040f, 0.604309f, 0.913788f,
0.620732f, 0.750450f, 0.477140f, 0.926215f, 0.584046f, 0.510718f, 0.770674f, 0.792447f, 0.941538f, 0.486252f,
0.758997f, 0.223627f, 0.306000f, 0.414401f, 0.765704f, 0.228234f, 0.611104f, 0.661728f, 0.374051f, 0.740088f,
0.096918f, 0.893774f, 0.410927f, 0.197113f, 0.628017f, 0.972871f, 0.179810f, 0.923817f, 0.385150f, 0.886080f,
0.939839f, 0.450258f, 0.902235f, 0.742350f, 0.004102f, 0.326844f, 0.982709f, 0.702732f, 0.623899f, 0.404498f,
0.997967f, 0.097205f, 0.728639f, 0.149259f, 0.504703f, 0.187966f, 0.199410f, 0.231511f, 0.768594f, 0.846792f,
0.366606f, 0.076857f, 0.498204f, 0.681377f, 0.564801f, 0.040246f, 0.458743f, 0.540776f, 0.136526f, 0.151905f,
0.003258f, 0.187363f, 0.948283f, 0.488963f, 0.359050f, 0.894106f, 0.365050f, 0.670252f, 0.461856f, 0.906914f,
0.674672f, 0.217359f, 0.838904f, 0.394746f, 0.010532f, 0.790717f, 0.228448f, 0.729172f, 0.141070f, 0.516940f,
0.324984f, 0.355240f, 0.135284f, 0.561681f, 0.390292f, 0.967222f, 0.561167f, 0.265384f, 0.255177f, 0.374321f,
0.803920f, 0.967687f, 0.976582f, 0.355455f, 0.482721f, 0.316871f, 0.563695f, 0.181544f, 0.365241f, 0.754842f,
0.281028f, 0.472847f, 0.334427f, 0.067421f, 0.135615f, 0.125070f, 0.020736f, 0.942058f, 0.441839f, 0.436868f,
0.512067f, 0.425458f, 0.312076f, 0.595008f, 0.142527f, 0.703411f, 0.175867f, 0.780191f, 0.987748f, 0.991715f,
0.616583f, 0.135505f, 0.544504f, 0.576216f, 0.320729f, 0.085539f, 0.952815f, 0.470904f, 0.855865f, 0.809118f,
0.063929f, 0.692982f, 0.828066f, 0.120824f, 0.154240f, 0.252513f, 0.411476f, 0.579771f, 0.785225f, 0.656334f,
0.545696f, 0.999049f, 0.910596f, 0.340377f, 0.059944f, 0.218749f, 0.233733f, 0.616273f, 0.413894f, 0.816053f,
0.186406f, 0.031317f, 0.672307f, 0.575904f, 0.363256f, 0.622231f, 0.750033f, 0.896588f, 0.428493f, 0.142661f,
0.077296f, 0.183320f, 0.325728f, 0.103699f, 0.460222f, 0.127489f, 0.678220f, 0.459192f, 0.087369f, 0.595572f,
0.445326f, 0.591872f, 0.496522f, 0.295314f, 0.643441f, 0.439003f, 0.284776f, 0.322041f, 0.589233f, 0.616596f,
0.489981f, 0.025623f, 0.602910f, 0.955413f, 0.704041f, 0.698830f, 0.437939f, 0.933625f, 0.283805f, 0.484770f,
0.320085f, 0.409100f, 0.699515f, 0.239577f, 0.970474f, 0.037194f, 0.911737f, 0.525388f, 0.136800f, 0.014283f,
0.761097f, 0.301566f, 0.894674f, 0.769877f, 0.881078f, 0.926342f, 0.190156f, 0.725909f, 0.714685f, 0.875194f,
0.231801f, 0.343335f, 0.244181f, 0.471608f, 0.242977f, 0.523551f, 0.790685f, 0.478336f, 0.892156f, 0.337134f,
0.052589f, 0.257701f, 0.453230f, 0.896953f, 0.750042f, 0.265571f, 0.192126f, 0.140895f, 0.082434f, 0.987979f,
0.949766f, 0.197972f, 0.054003f, 0.956247f, 0.123212f, 0.676353f, 0.513366f, 0.286601f, 0.275754f, 0.811467f,
0.068565f, 0.933025f, 0.391943f, 0.677189f, 0.639937f, 0.775126f, 0.510639f, 0.630895f, 0.956229f, 0.209010f,
0.804232f, 0.802067f, 0.407543f, 0.393011f, 0.475687f, 0.945234f, 0.797870f, 0.859768f, 0.816294f, 0.342655f,
0.371831f, 0.545838f, 0.164334f, 0.187652f, 0.388964f, 0.123359f, 0.103772f, 0.462159f, 0.034826f, 0.770320f,
0.598005f, 0.786656f, 0.817906f, 0.816839f, 0.328990f, 0.712029f, 0.636955f, 0.895874f, 0.433086f, 0.987209f,
0.149382f, 0.404325f, 0.100461f, 0.779363f, 0.522609f, 0.460378f, 0.498969f, 0.943156f, 0.736569f, 0.877702f,
0.560165f, 0.576098f, 0.973956f, 0.057965f, 0.688725f, 0.650910f, 0.067597f, 0.507172f, 0.518728f, 0.529272f,
0.524153f, 0.035771f, 0.497589f, 0.829756f, 0.570236f, 0.029604f, 0.808581f, 0.355395f, 0.932457f, 0.228914f,
0.155297f, 0.258835f, 0.023776f, 0.751405f, 0.288268f, 0.986458f, 0.769837f, 0.649118f, 0.731640f, 0.815254f,
0.196081f, 0.447302f, 0.585690f, 0.096789f, 0.412401f, 0.923167f, 0.256220f, 0.873416f, 0.885591f, 0.812777f,
0.993979f, 0.057826f, 0.010371f, 0.758343f, 0.604893f, 0.688147f, 0.849414f, 0.948252f, 0.625617f, 0.548802f,
0.310423f, 0.266653f, 0.105913f, 0.720120f, 0.258644f, 0.926310f, 0.956076f, 0.372824f, 0.892436f, 0.278037f,
0.407515f, 0.547340f, 0.687312f, 0.048918f, 0.185964f, 0.763560f, 0.843371f, 0.110383f, 0.882371f, 0.535442f,
0.557581f, 0.386457f, 0.740171f, 0.660182f, 0.008745f, 0.551130f, 0.126496f, 0.391728f, 0.879017f, 0.868286f,
0.739874f, 0.425407f, 0.124801f, 0.021955f, 0.414564f, 0.830985f, 0.187746f, 0.641406f, 0.081078f, 0.158464f,
0.517144f, 0.430643f, 0.417475f, 0.162212f, 0.049512f, 0.424235f, 0.595323f, 0.471489f, 0.546011f, 0.317842f,
0.781461f, 0.287300f, 0.446463f, 0.932962f, 0.617164f, 0.603333f, 0.128022f, 0.713616f, 0.923455f, 0.171646f,
0.279426f, 0.305753f, 0.958299f, 0.030991f, 0.868461f, 0.819300f, 0.998197f, 0.286025f, 0.583019f, 0.971529f,
0.352788f, 0.748697f, 0.604946f, 0.951398f, 0.329688f, 0.520236f, 0.585882f, 0.327645f, 0.115683f, 0.815205f,
0.687707f, 0.850844f, 0.424855f, 0.144886f, 0.439794f, 0.862446f, 0.057945f, 0.338275f, 0.352305f, 0.048373f,
0.325192f, 0.059470f, 0.593113f, 0.049668f, 0.325742f, 0.381962f, 0.447725f, 0.216225f, 0.337708f, 0.474752f,
0.064338f, 0.656071f, 0.077462f, 0.279782f, 0.262247f, 0.947299f, 0.833615f, 0.167288f, 0.750022f, 0.631560f,
0.571339f, 0.008769f, 0.598589f, 0.951228f, 0.363788f, 0.990835f, 0.053824f, 0.880160f, 0.726686f, 0.408966f,
0.192842f, 0.762834f, 0.343999f, 0.744267f, 0.708936f, 0.516107f, 0.994455f, 0.996728f, 0.231891f, 0.253720f,
0.174053f, 0.741411f, 0.039290f, 0.646172f, 0.914157f, 0.655392f, 0.708550f, 0.406210f, 0.755139f, 0.741268f,
0.674685f, 0.507327f, 0.059461f, 0.076720f, 0.693059f, 0.533561f, 0.750274f, 0.489463f, 0.309559f, 0.502492f,
0.733317f, 0.799899f, 0.799289f, 0.308664f, 0.127601f, 0.400824f, 0.133418f, 0.998789f, 0.110641f, 0.252538f,
0.309143f, 0.355271f, 0.076639f, 0.408426f, 0.835160f, 0.850158f, 0.904292f, 0.632698f, 0.237243f, 0.475884f,
0.788365f, 0.489354f, 0.500847f, 0.352165f, 0.232697f, 0.076366f, 0.560274f, 0.780945f, 0.515189f, 0.993054f,
0.900681f, 0.436755f, 0.708993f, 0.319139f, 0.333579f, 0.354910f, 0.903636f, 0.128994f, 0.933769f, 0.437048f,
0.599003f, 0.559924f, 0.711712f, 0.270895f, 0.780451f, 0.267065f, 0.199934f, 0.602317f, 0.404565f, 0.951776f,
0.989573f, 0.066928f, 0.097743f, 0.026564f, 0.793780f, 0.074321f, 0.818256f, 0.123018f, 0.713308f, 0.110845f,
0.731088f, 0.503623f, 0.823878f, 0.673999f, 0.320862f, 0.616945f, 0.049669f, 0.186467f, 0.391600f, 0.815898f,
0.681659f, 0.310992f, 0.185548f, 0.398534f, 0.732349f, 0.696868f, 0.450594f, 0.433720f, 0.428501f, 0.875375f,
0.947020f, 0.179649f, 0.166265f, 0.216211f, 0.207910f, 0.703813f, 0.577541f, 0.091511f, 0.555681f, 0.946850f,
0.063198f, 0.105042f, 0.084304f, 0.454832f, 0.163990f, 0.301757f, 0.080931f, 0.961615f, 0.138691f, 0.320373f,
0.266960f, 0.196810f, 0.638870f, 0.796549f, 0.090484f, 0.571067f, 0.715042f, 0.276469f, 0.274339f, 0.754664f,
0.491054f, 0.701874f, 0.429967f, 0.726602f, 0.097579f, 0.986126f, 0.108933f, 0.096722f, 0.718022f, 0.158191f,
0.550061f, 0.899944f, 0.191943f, 0.256298f, 0.837554f, 0.944298f, 0.195208f, 0.940706f, 0.856252f, 0.344945f,
0.405893f, 0.405921f, 0.676841f, 0.058584f, 0.995274f, 0.849477f, 0.930353f, 0.188310f, 0.293171f, 0.787351f,
0.575136f, 0.818425f, 0.063742f, 0.517978f, 0.097689f, 0.054686f, 0.879719f, 0.955876f, 0.382023f, 0.494632f,
0.583324f, 0.892755f, 0.794933f, 0.695014f, 0.840726f, 0.994601f, 0.037777f, 0.513200f, 0.704338f, 0.963981f,
0.342117f, 0.657060f, 0.244131f, 0.056272f, 0.693827f, 0.974105f, 0.871596f, 0.032868f, 0.871927f, 0.794975f,
0.894003f, 0.212865f, 0.958125f, 0.659943f, 0.149230f, 0.752313f, 0.073837f, 0.170946f, 0.091300f, 0.382204f,
0.211755f, 0.397597f, 0.904835f, 0.217394f, 0.637802f, 0.569637f, 0.931841f, 0.419016f, 0.766027f, 0.573278f,
0.673973f, 0.651535f, 0.760804f, 0.305864f, 0.112232f, 0.491245f, 0.706936f, 0.171938f, 0.666207f, 0.619895f,
0.571731f, 0.626918f, 0.548595f, 0.848822f, 0.673208f, 0.363224f, 0.685727f, 0.447300f, 0.428015f, 0.931889f,
0.521040f, 0.999726f, 0.100592f, 0.382437f, 0.607880f, 0.298647f, 0.993624f, 0.958296f, 0.091021f, 0.132246f,
0.281410f, 0.740756f, 0.504123f, 0.382358f, 0.645144f, 0.566105f, 0.266244f, 0.139985f, 0.722109f, 0.824665f,
0.702478f, 0.919359f, 0.483018f, 0.403991f, 0.549368f, 0.353624f, 0.213521f, 0.108706f, 0.676280f, 0.758809f,
0.048591f, 0.468378f, 0.948786f, 0.779330f, 0.991516f, 0.918421f, 0.084373f, 0.180372f, 0.868665f, 0.886395f,
0.979397f, 0.676307f, 0.376377f, 0.098933f, 0.878607f, 0.204674f, 0.620335f, 0.724089f, 0.897437f, 0.721683f,
0.921427f, 0.158442f, 0.025143f, 0.391561f, 0.619461f, 0.134977f, 0.782533f, 0.674563f, 0.362850f, 0.806084f,
0.699532f, 0.098873f, 0.088920f, 0.822989f, 0.663508f, 0.717560f, 0.302839f, 0.278036f, 0.841048f, 0.438606f,
0.156336f, 0.424839f, 0.528252f, 0.533076f, 0.815102f, 0.752566f, 0.734322f, 0.057198f, 0.887572f, 0.957728f,
0.403393f, 0.900303f, 0.722425f, 0.488811f, 0.470512f, 0.406905f, 0.546840f, 0.087137f, 0.730352f, 0.261653f,
0.579349f, 0.332682f, 0.265896f, 0.534743f, 0.867292f, 0.386873f, 0.403393f, 0.193171f, 0.405388f, 0.786162f,
0.546548f, 0.812753f, 0.935349f, 0.080385f, 0.049845f, 0.201996f, 0.010203f, 0.783126f, 0.069606f, 0.563833f,
0.418726f, 0.693483f, 0.883883f, 0.761605f, 0.041705f, 0.231451f, 0.958317f, 0.703306f, 0.158904f, 0.609795f,
0.018707f, 0.844983f, 0.617176f, 0.120723f, 0.007773f, 0.768524f, 0.953917f, 0.738020f, 0.261985f, 0.039120f,
0.441239f, 0.930374f, 0.746958f, 0.252039f, 0.957132f, 0.690149f, 0.701476f, 0.432751f, 0.447969f, 0.293009f,
0.888535f, 0.787829f, 0.147831f, 0.215754f, 0.610906f, 0.438379f, 0.570668f, 0.090696f, 0.773611f, 0.395111f,
0.809876f, 0.839539f, 0.044666f, 0.322737f, 0.985728f, 0.506644f, 0.916176f, 0.500188f, 0.626733f, 0.034488f,
0.863872f, 0.282427f, 0.919265f, 0.915593f, 0.925689f, 0.629350f, 0.231858f, 0.744431f, 0.387338f, 0.488431f,
0.541110f, 0.992659f, 0.660795f, 0.252715f, 0.128620f, 0.945174f, 0.273725f, 0.284712f, 0.307403f, 0.942165f,
0.216739f, 0.650056f, 0.170847f, 0.097100f, 0.594597f, 0.820189f, 0.468139f, 0.364768f, 0.874361f, 0.135794f,
0.467735f, 0.138386f, 0.102198f, 0.335628f, 0.844400f, 0.050999f, 0.901380f, 0.533651f, 0.148896f, 0.495478f,
0.951364f, 0.900035f, 0.244453f, 0.942373f, 0.453760f, 0.864207f, 0.753700f, 0.055285f, 0.121246f, 0.023886f,
0.857348f, 0.916190f, 0.341202f, 0.267832f, 0.592018f, 0.725157f, 0.873361f, 0.899318f, 0.090003f, 0.685373f,
0.628260f, 0.402394f, 0.165173f, 0.088262f, 0.623073f, 0.508835f, 0.171645f, 0.115798f, 0.864766f, 0.811924f,
0.266571f, 0.353876f, 0.908199f, 0.978756f, 0.129968f, 0.559076f, 0.484093f, 0.506754f, 0.517827f, 0.409641f,
0.143500f, 0.463812f, 0.507419f, 0.361672f, 0.014461f, 0.160298f, 0.532517f, 0.714803f, 0.752624f, 0.003552f,
0.387711f, 0.226057f, 0.182750f, 0.370968f, 0.247544f, 0.017360f, 0.472923f, 0.837063f, 0.110091f, 0.097339f,
0.567620f, 0.706439f, 0.582877f, 0.678660f, 0.397922f, 0.662479f, 0.198962f, 0.879592f, 0.134618f, 0.408941f,
0.841123f, 0.120967f, 0.971722f, 0.225655f, 0.734054f, 0.939736f, 0.856264f, 0.572730f, 0.211391f, 0.435724f,
0.919324f, 0.980818f, 0.336735f, 0.195491f, 0.603247f, 0.986741f, 0.903225f, 0.324610f, 0.021219f, 0.323439f,
0.729239f, 0.217121f, 0.534733f, 0.982002f, 0.875433f, 0.846451f, 0.415894f, 0.877106f, 0.525596f, 0.863796f,
0.952031f, 0.939083f, 0.664816f, 0.280465f, 0.075343f, 0.058709f, 0.466941f, 0.724676f, 0.188171f, 0.248273f,
0.545032f, 0.866838f, 0.177735f, 0.039469f, 0.578589f, 0.973201f, 0.250789f, 0.162612f, 0.947248f, 0.406204f,
0.626607f, 0.527402f, 0.443641f, 0.003793f, 0.478663f, 0.519502f, 0.996750f, 0.938095f, 0.509874f, 0.456980f,
0.434301f, 0.908419f, 0.258361f, 0.244126f, 0.195118f, 0.999422f, 0.131402f, 0.998806f, 0.011947f, 0.584296f,
0.868068f, 0.942245f, 0.056152f, 0.803183f, 0.915458f, 0.283261f, 0.620921f, 0.720641f, 0.584467f, 0.167569f,
0.100468f, 0.120899f, 0.792011f, 0.438146f, 0.424040f, 0.284301f, 0.081850f, 0.518048f, 0.411182f, 0.379979f,
0.154029f, 0.960775f, 0.046733f, 0.044437f, 0.826417f, 0.266266f, 0.623392f, 0.257971f, 0.511535f, 0.887549f,
0.892361f, 0.589707f, 0.290352f, 0.670845f, 0.989082f, 0.624632f, 0.518734f, 0.462283f, 0.779274f, 0.362734f,
0.626747f, 0.224902f, 0.703862f, 0.433933f, 0.135986f, 0.753848f, 0.162297f, 0.063467f, 0.839307f, 0.742688f,
0.523279f, 0.263078f, 0.634897f, 0.101533f, 0.988856f, 0.856402f, 0.646335f, 0.451823f, 0.770086f, 0.251592f,
0.526454f, 0.445061f, 0.674898f, 0.488320f, 0.043517f, 0.021114f, 0.111054f, 0.013724f, 0.772856f, 0.304855f,
0.646510f, 0.372914f, 0.747271f, 0.677155f, 0.311921f, 0.504645f, 0.787545f, 0.256494f, 0.173816f, 0.224071f,
0.847064f, 0.820608f, 0.943324f, 0.209493f, 0.791903f, 0.913511f, 0.794753f, 0.822794f, 0.598637f, 0.322224f,
0.714356f, 0.069673f, 0.530864f, 0.935428f, 0.055382f, 0.289914f, 0.308902f, 0.370767f, 0.317570f, 0.642280f,
0.623372f, 0.950501f, 0.371875f, 0.114218f, 0.136580f, 0.326540f, 0.620995f, 0.829135f, 0.842053f, 0.529703f,
0.661071f, 0.531626f, 0.203811f, 0.680709f, 0.760946f, 0.607172f, 0.505913f, 0.627664f, 0.536590f, 0.690904f,
0.970214f, 0.538502f, 0.626396f, 0.774777f, 0.372957f, 0.599100f, 0.021593f, 0.062771f, 0.615652f, 0.883401f};






class MTRand
{
public:

	MTRand(){CurrentTablePosition = (unsigned int)(time(NULL) + clock()) % (vwRandQuantity-1);};
	// 0.0f - 1.0f
	float rand()
	{
		CurrentTablePosition++;
		if (CurrentTablePosition > vwRandQuantity-1) CurrentTablePosition = 0;
		return vwRand[CurrentTablePosition];
	};
	// 0.0f - Max
	float rand(float Max){return rand()*Max;};
	// 0 - Max
	unsigned int randInt(unsigned int Max){return floor(rand()*(Max+1));};

protected:

	unsigned int CurrentTablePosition;
};






#endif  // MERSENNETWISTER_H
