/* RavenTriggerApplet.c generated by valac 0.32.1, the Vala compiler
 * generated from RavenTriggerApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libpeas/peas.h>
#include <plugin.h>
#include <gtk/gtk.h>


#define TYPE_RAVEN_TRIGGER_PROXY (raven_trigger_proxy_get_type ())
#define RAVEN_TRIGGER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAVEN_TRIGGER_PROXY, RavenTriggerProxy))
#define IS_RAVEN_TRIGGER_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAVEN_TRIGGER_PROXY))
#define RAVEN_TRIGGER_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RAVEN_TRIGGER_PROXY, RavenTriggerProxyIface))

typedef struct _RavenTriggerProxy RavenTriggerProxy;
typedef struct _RavenTriggerProxyIface RavenTriggerProxyIface;

#define TYPE_RAVEN_TRIGGER_PROXY_PROXY (raven_trigger_proxy_proxy_get_type ())
typedef GDBusProxy RavenTriggerProxyProxy;
typedef GDBusProxyClass RavenTriggerProxyProxyClass;

#define TYPE_RAVEN_TRIGGER_PLUGIN (raven_trigger_plugin_get_type ())
#define RAVEN_TRIGGER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAVEN_TRIGGER_PLUGIN, RavenTriggerPlugin))
#define RAVEN_TRIGGER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAVEN_TRIGGER_PLUGIN, RavenTriggerPluginClass))
#define IS_RAVEN_TRIGGER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAVEN_TRIGGER_PLUGIN))
#define IS_RAVEN_TRIGGER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAVEN_TRIGGER_PLUGIN))
#define RAVEN_TRIGGER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAVEN_TRIGGER_PLUGIN, RavenTriggerPluginClass))

typedef struct _RavenTriggerPlugin RavenTriggerPlugin;
typedef struct _RavenTriggerPluginClass RavenTriggerPluginClass;
typedef struct _RavenTriggerPluginPrivate RavenTriggerPluginPrivate;

#define TYPE_RAVEN_TRIGGER_APPLET (raven_trigger_applet_get_type ())
#define RAVEN_TRIGGER_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAVEN_TRIGGER_APPLET, RavenTriggerApplet))
#define RAVEN_TRIGGER_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAVEN_TRIGGER_APPLET, RavenTriggerAppletClass))
#define IS_RAVEN_TRIGGER_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAVEN_TRIGGER_APPLET))
#define IS_RAVEN_TRIGGER_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAVEN_TRIGGER_APPLET))
#define RAVEN_TRIGGER_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAVEN_TRIGGER_APPLET, RavenTriggerAppletClass))

typedef struct _RavenTriggerApplet RavenTriggerApplet;
typedef struct _RavenTriggerAppletClass RavenTriggerAppletClass;
typedef struct _RavenTriggerAppletPrivate RavenTriggerAppletPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _RavenTriggerProxyIface {
	GTypeInterface parent_iface;
	void (*ToggleAppletView) (RavenTriggerProxy* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ToggleAppletView_finish) (RavenTriggerProxy* self, GAsyncResult* _res_, GError** error);
	gboolean (*GetExpanded) (RavenTriggerProxy* self, GError** error);
};

struct _RavenTriggerPlugin {
	PeasExtensionBase parent_instance;
	RavenTriggerPluginPrivate * priv;
};

struct _RavenTriggerPluginClass {
	PeasExtensionBaseClass parent_class;
};

struct _RavenTriggerApplet {
	BudgieApplet parent_instance;
	RavenTriggerAppletPrivate * priv;
	GtkButton* widget;
	GtkImage* img_expanded;
	GtkImage* img_hidden;
	GtkStack* img_stack;
};

struct _RavenTriggerAppletClass {
	BudgieAppletClass parent_class;
};

struct _RavenTriggerAppletPrivate {
	RavenTriggerProxy* raven_proxy;
	gboolean raven_expanded;
};

struct _Block1Data {
	int _ref_count_;
	RavenTriggerApplet* self;
	gboolean e;
};


static GType raven_trigger_proxy_type_id = 0;
static gpointer raven_trigger_plugin_parent_class = NULL;
static BudgiePluginIface* raven_trigger_plugin_budgie_plugin_parent_iface = NULL;
static GType raven_trigger_plugin_type_id = 0;
static gpointer raven_trigger_applet_parent_class = NULL;
static GType raven_trigger_applet_type_id = 0;

#define RAVEN_DBUS_NAME "com.solus_project.budgie.Raven"
#define RAVEN_DBUS_OBJECT_PATH "/com/solus_project/budgie/Raven"
GType raven_trigger_proxy_proxy_get_type (void) G_GNUC_CONST;
void raven_trigger_proxy_proxy_register_dynamic_type (GTypeModule* module);
guint raven_trigger_proxy_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType raven_trigger_proxy_get_type (void) G_GNUC_CONST;
GType raven_trigger_proxy_register_type (GTypeModule * module);
void raven_trigger_proxy_ToggleAppletView (RavenTriggerProxy* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void raven_trigger_proxy_ToggleAppletView_finish (RavenTriggerProxy* self, GAsyncResult* _res_, GError** error);
gboolean raven_trigger_proxy_GetExpanded (RavenTriggerProxy* self, GError** error);
static void raven_trigger_proxy_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_raven_trigger_proxy_expansion_changed (RavenTriggerProxy* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void raven_trigger_proxy_proxy_ToggleAppletView_async (RavenTriggerProxy* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void raven_trigger_proxy_proxy_ToggleAppletView_finish (RavenTriggerProxy* self, GAsyncResult* _res_, GError** error);
static gboolean raven_trigger_proxy_proxy_GetExpanded (RavenTriggerProxy* self, GError** error);
static void raven_trigger_proxy_proxy_raven_trigger_proxy_interface_init (RavenTriggerProxyIface* iface);
static void _dbus_raven_trigger_proxy_ToggleAppletView (RavenTriggerProxy* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_raven_trigger_proxy_ToggleAppletView_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_raven_trigger_proxy_GetExpanded (RavenTriggerProxy* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void raven_trigger_proxy_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* raven_trigger_proxy_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean raven_trigger_proxy_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_raven_trigger_proxy_expansion_changed (GObject* _sender, gboolean expanded, gpointer* _data);
static void _raven_trigger_proxy_unregister_object (gpointer user_data);
GType raven_trigger_plugin_get_type (void) G_GNUC_CONST;
GType raven_trigger_plugin_register_type (GTypeModule * module);
enum  {
	RAVEN_TRIGGER_PLUGIN_DUMMY_PROPERTY
};
static BudgieApplet* raven_trigger_plugin_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid);
RavenTriggerApplet* raven_trigger_applet_new (void);
RavenTriggerApplet* raven_trigger_applet_construct (GType object_type);
GType raven_trigger_applet_get_type (void) G_GNUC_CONST;
GType raven_trigger_applet_register_type (GTypeModule * module);
RavenTriggerPlugin* raven_trigger_plugin_new (void);
RavenTriggerPlugin* raven_trigger_plugin_construct (GType object_type);
#define RAVEN_TRIGGER_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RAVEN_TRIGGER_APPLET, RavenTriggerAppletPrivate))
enum  {
	RAVEN_TRIGGER_APPLET_DUMMY_PROPERTY
};
static void raven_trigger_applet_on_button_clicked (RavenTriggerApplet* self);
static void _raven_trigger_applet_on_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void raven_trigger_applet_get_raven (RavenTriggerApplet* self);
static gboolean raven_trigger_applet_toggle_raven (RavenTriggerApplet* self);
static gboolean _raven_trigger_applet_toggle_raven_gsource_func (gpointer self);
static void raven_trigger_applet_on_raven_get (RavenTriggerApplet* self, GObject* o, GAsyncResult* res);
static void _raven_trigger_applet_on_raven_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void raven_trigger_applet_on_prop_changed (RavenTriggerApplet* self, gboolean expanded);
static void ___lambda4_ (RavenTriggerApplet* self, gboolean e);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block1Data* _data1_);
static gboolean ___lambda5__gsource_func (gpointer self);
static void ____lambda4__raven_trigger_proxy_expansion_changed (RavenTriggerProxy* _sender, gboolean expanded, gpointer self);
static void raven_trigger_applet_finalize (GObject* obj);
void peas_register_types (GTypeModule* module);

static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_ToggleAppletView_in[] = {NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_ToggleAppletView_out[] = {NULL};
static const GDBusMethodInfo _raven_trigger_proxy_dbus_method_info_ToggleAppletView = {-1, "ToggleAppletView", (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_ToggleAppletView_in), (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_ToggleAppletView_out)};
static const GDBusArgInfo _raven_trigger_proxy_dbus_arg_info_GetExpanded_result = {-1, "result", "b"};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_GetExpanded_in[] = {NULL};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_GetExpanded_out[] = {&_raven_trigger_proxy_dbus_arg_info_GetExpanded_result, NULL};
static const GDBusMethodInfo _raven_trigger_proxy_dbus_method_info_GetExpanded = {-1, "GetExpanded", (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_GetExpanded_in), (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_GetExpanded_out)};
static const GDBusMethodInfo * const _raven_trigger_proxy_dbus_method_info[] = {&_raven_trigger_proxy_dbus_method_info_ToggleAppletView, &_raven_trigger_proxy_dbus_method_info_GetExpanded, NULL};
static const GDBusArgInfo _raven_trigger_proxy_dbus_arg_info_expansion_changed_expanded = {-1, "expanded", "b"};
static const GDBusArgInfo * const _raven_trigger_proxy_dbus_arg_info_expansion_changed[] = {&_raven_trigger_proxy_dbus_arg_info_expansion_changed_expanded, NULL};
static const GDBusSignalInfo _raven_trigger_proxy_dbus_signal_info_expansion_changed = {-1, "ExpansionChanged", (GDBusArgInfo **) (&_raven_trigger_proxy_dbus_arg_info_expansion_changed)};
static const GDBusSignalInfo * const _raven_trigger_proxy_dbus_signal_info[] = {&_raven_trigger_proxy_dbus_signal_info_expansion_changed, NULL};
static const GDBusPropertyInfo * const _raven_trigger_proxy_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _raven_trigger_proxy_dbus_interface_info = {-1, "com.solus_project.budgie.Raven", (GDBusMethodInfo **) (&_raven_trigger_proxy_dbus_method_info), (GDBusSignalInfo **) (&_raven_trigger_proxy_dbus_signal_info), (GDBusPropertyInfo **) (&_raven_trigger_proxy_dbus_property_info)};
static const GDBusInterfaceVTable _raven_trigger_proxy_dbus_interface_vtable = {raven_trigger_proxy_dbus_interface_method_call, raven_trigger_proxy_dbus_interface_get_property, raven_trigger_proxy_dbus_interface_set_property};

void raven_trigger_proxy_ToggleAppletView (RavenTriggerProxy* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RAVEN_TRIGGER_PROXY_GET_INTERFACE (self)->ToggleAppletView (self, _callback_, _user_data_);
}


void raven_trigger_proxy_ToggleAppletView_finish (RavenTriggerProxy* self, GAsyncResult* _res_, GError** error) {
	RAVEN_TRIGGER_PROXY_GET_INTERFACE (self)->ToggleAppletView_finish (self, _res_, error);
}


gboolean raven_trigger_proxy_GetExpanded (RavenTriggerProxy* self, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RAVEN_TRIGGER_PROXY_GET_INTERFACE (self)->GetExpanded (self, error);
}


static void raven_trigger_proxy_base_init (RavenTriggerProxyIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("expansion_changed", TYPE_RAVEN_TRIGGER_PROXY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	}
}


GType raven_trigger_proxy_get_type (void) {
	return raven_trigger_proxy_type_id;
}


GType raven_trigger_proxy_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RavenTriggerProxyIface), (GBaseInitFunc) raven_trigger_proxy_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	raven_trigger_proxy_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "RavenTriggerProxy", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (raven_trigger_proxy_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (raven_trigger_proxy_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) raven_trigger_proxy_proxy_get_type);
	g_type_set_qdata (raven_trigger_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.solus_project.budgie.Raven");
	g_type_set_qdata (raven_trigger_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_raven_trigger_proxy_dbus_interface_info));
	g_type_set_qdata (raven_trigger_proxy_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) raven_trigger_proxy_register_object);
	return raven_trigger_proxy_type_id;
}


G_DEFINE_DYNAMIC_TYPE_EXTENDED (RavenTriggerProxyProxy, raven_trigger_proxy_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_RAVEN_TRIGGER_PROXY, raven_trigger_proxy_proxy_raven_trigger_proxy_interface_init) )
static void raven_trigger_proxy_proxy_class_init (RavenTriggerProxyProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = raven_trigger_proxy_proxy_g_signal;
}


static void _dbus_handle_raven_trigger_proxy_expansion_changed (RavenTriggerProxy* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gboolean expanded = FALSE;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	expanded = g_variant_get_boolean (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "expansion-changed", expanded);
}


static void raven_trigger_proxy_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "ExpansionChanged") == 0) {
		_dbus_handle_raven_trigger_proxy_expansion_changed ((RavenTriggerProxy*) proxy, parameters);
	}
}


static void raven_trigger_proxy_proxy_class_finalize (RavenTriggerProxyProxyClass* klass) {
}


void raven_trigger_proxy_proxy_register_dynamic_type (GTypeModule* module) {
	raven_trigger_proxy_proxy_register_type (module);
}


static void raven_trigger_proxy_proxy_init (RavenTriggerProxyProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void raven_trigger_proxy_proxy_ToggleAppletView_async (RavenTriggerProxy* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.solus_project.budgie.Raven", "ToggleAppletView");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void raven_trigger_proxy_proxy_ToggleAppletView_finish (RavenTriggerProxy* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gboolean raven_trigger_proxy_proxy_GetExpanded (RavenTriggerProxy* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _result;
	GVariant* _tmp1_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.solus_project.budgie.Raven", "GetExpanded");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp1_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp1_);
	g_variant_unref (_tmp1_);
	g_object_unref (_reply_message);
	return _result;
}


static void raven_trigger_proxy_proxy_raven_trigger_proxy_interface_init (RavenTriggerProxyIface* iface) {
	iface->ToggleAppletView = raven_trigger_proxy_proxy_ToggleAppletView_async;
	iface->ToggleAppletView_finish = raven_trigger_proxy_proxy_ToggleAppletView_finish;
	iface->GetExpanded = raven_trigger_proxy_proxy_GetExpanded;
}


static void _dbus_raven_trigger_proxy_ToggleAppletView (RavenTriggerProxy* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	raven_trigger_proxy_ToggleAppletView (self, (GAsyncReadyCallback) _dbus_raven_trigger_proxy_ToggleAppletView_ready, invocation);
}


static void _dbus_raven_trigger_proxy_ToggleAppletView_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	raven_trigger_proxy_ToggleAppletView_finish ((RavenTriggerProxy*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_raven_trigger_proxy_GetExpanded (RavenTriggerProxy* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = raven_trigger_proxy_GetExpanded (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void raven_trigger_proxy_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ToggleAppletView") == 0) {
		_dbus_raven_trigger_proxy_ToggleAppletView (object, parameters, invocation);
	} else if (strcmp (method_name, "GetExpanded") == 0) {
		_dbus_raven_trigger_proxy_GetExpanded (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* raven_trigger_proxy_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean raven_trigger_proxy_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_raven_trigger_proxy_expansion_changed (GObject* _sender, gboolean expanded, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (expanded));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.budgie.Raven", "ExpansionChanged", _arguments, NULL);
}


guint raven_trigger_proxy_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_raven_trigger_proxy_dbus_interface_info), &_raven_trigger_proxy_dbus_interface_vtable, data, _raven_trigger_proxy_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "expansion-changed", (GCallback) _dbus_raven_trigger_proxy_expansion_changed, data);
	return result;
}


static void _raven_trigger_proxy_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_trigger_proxy_expansion_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static BudgieApplet* raven_trigger_plugin_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid) {
	RavenTriggerPlugin * self;
	BudgieApplet* result = NULL;
	RavenTriggerApplet* _tmp0_ = NULL;
	self = (RavenTriggerPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = raven_trigger_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}


RavenTriggerPlugin* raven_trigger_plugin_construct (GType object_type) {
	RavenTriggerPlugin * self = NULL;
	self = (RavenTriggerPlugin*) g_object_new (object_type, NULL);
	return self;
}


RavenTriggerPlugin* raven_trigger_plugin_new (void) {
	return raven_trigger_plugin_construct (TYPE_RAVEN_TRIGGER_PLUGIN);
}


static void raven_trigger_plugin_class_init (RavenTriggerPluginClass * klass) {
	raven_trigger_plugin_parent_class = g_type_class_peek_parent (klass);
}


static void raven_trigger_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface) {
	raven_trigger_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*)(BudgiePlugin*, const gchar*)) raven_trigger_plugin_real_get_panel_widget;
}


static void raven_trigger_plugin_instance_init (RavenTriggerPlugin * self) {
}


GType raven_trigger_plugin_get_type (void) {
	return raven_trigger_plugin_type_id;
}


GType raven_trigger_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RavenTriggerPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raven_trigger_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RavenTriggerPlugin), 0, (GInstanceInitFunc) raven_trigger_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) raven_trigger_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	raven_trigger_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "RavenTriggerPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, raven_trigger_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return raven_trigger_plugin_type_id;
}


static void _raven_trigger_applet_on_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	raven_trigger_applet_on_button_clicked ((RavenTriggerApplet*) self);
}


RavenTriggerApplet* raven_trigger_applet_construct (GType object_type) {
	RavenTriggerApplet * self = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkStack* _tmp8_ = NULL;
	GtkStack* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
	GtkImage* _tmp12_ = NULL;
	GtkStack* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkStack* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	self = (RavenTriggerApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->widget);
	self->widget = _tmp0_;
	_tmp1_ = self->widget;
	g_signal_connect_object (_tmp1_, "clicked", (GCallback) _raven_trigger_applet_on_button_clicked_gtk_button_clicked, self, G_CONNECT_AFTER);
	_tmp2_ = self->widget;
	gtk_button_set_relief (_tmp2_, GTK_RELIEF_NONE);
	_tmp3_ = self->widget;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->widget;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "raven-trigger");
	_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name ("pane-show-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->img_hidden);
	self->img_hidden = _tmp6_;
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("pane-hide-symbolic", GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->img_expanded);
	self->img_expanded = _tmp7_;
	_tmp8_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->img_stack);
	self->img_stack = _tmp8_;
	_tmp9_ = self->img_stack;
	_tmp10_ = self->img_hidden;
	gtk_stack_add_named (_tmp9_, (GtkWidget*) _tmp10_, "hidden");
	_tmp11_ = self->img_stack;
	_tmp12_ = self->img_expanded;
	gtk_stack_add_named (_tmp11_, (GtkWidget*) _tmp12_, "expanded");
	_tmp13_ = self->img_stack;
	gtk_stack_set_transition_type (_tmp13_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
	_tmp14_ = self->widget;
	_tmp15_ = self->img_stack;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	gtk_widget_show_all ((GtkWidget*) self);
	raven_trigger_applet_get_raven (self);
	return self;
}


RavenTriggerApplet* raven_trigger_applet_new (void) {
	return raven_trigger_applet_construct (TYPE_RAVEN_TRIGGER_APPLET);
}


/**
     * Schedule toggle_raven on the idle loop
     */
static gboolean _raven_trigger_applet_toggle_raven_gsource_func (gpointer self) {
	gboolean result;
	result = raven_trigger_applet_toggle_raven ((RavenTriggerApplet*) self);
	return result;
}


static void raven_trigger_applet_on_button_clicked (RavenTriggerApplet* self) {
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _raven_trigger_applet_toggle_raven_gsource_func, g_object_ref (self), g_object_unref);
}


/**
     * Toggle the Raven Applet View, we'll update view state on callback
     */
static gboolean raven_trigger_applet_toggle_raven (RavenTriggerApplet* self) {
	gboolean result = FALSE;
	RavenTriggerProxy* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	{
		RavenTriggerProxy* _tmp1_ = NULL;
		_tmp1_ = self->priv->raven_proxy;
		raven_trigger_proxy_ToggleAppletView (_tmp1_, NULL, NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_message ("RavenTriggerApplet.vala:83: Error in dbus: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


/**
     * Asynchronously fetch a Raven proxy
     */
static void _raven_trigger_applet_on_raven_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	raven_trigger_applet_on_raven_get ((RavenTriggerApplet*) self, source_object, res);
	g_object_unref (self);
}


static void raven_trigger_applet_get_raven (RavenTriggerApplet* self) {
	RavenTriggerProxy* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		g_async_initable_new_async (TYPE_RAVEN_TRIGGER_PROXY_PROXY, 0, NULL, _raven_trigger_applet_on_raven_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", RAVEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RAVEN_DBUS_OBJECT_PATH, "g-interface-name", "com.solus_project.budgie.Raven", "g-interface-info", g_type_get_qdata (TYPE_RAVEN_TRIGGER_PROXY, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	}
}


/**
     * Handle Raven expansion state changing
     */
static void raven_trigger_applet_on_prop_changed (RavenTriggerApplet* self, gboolean expanded) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = expanded;
	self->priv->raven_expanded = _tmp0_;
	_tmp1_ = self->priv->raven_expanded;
	if (_tmp1_) {
		GtkStack* _tmp2_ = NULL;
		_tmp2_ = self->img_stack;
		gtk_stack_set_visible_child_name (_tmp2_, "expanded");
	} else {
		GtkStack* _tmp3_ = NULL;
		_tmp3_ = self->img_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "hidden");
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		RavenTriggerApplet* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda5_ (Block1Data* _data1_) {
	RavenTriggerApplet* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = _data1_->self;
	_tmp0_ = _data1_->e;
	raven_trigger_applet_on_prop_changed (self, _tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ (self);
	return result;
}


static void ___lambda4_ (RavenTriggerApplet* self, gboolean e) {
	Block1Data* _data1_;
	gboolean _tmp0_ = FALSE;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = e;
	_data1_->e = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void ____lambda4__raven_trigger_proxy_expansion_changed (RavenTriggerProxy* _sender, gboolean expanded, gpointer self) {
	___lambda4_ ((RavenTriggerApplet*) self, expanded);
}


static void raven_trigger_applet_on_raven_get (RavenTriggerApplet* self, GObject* o, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RavenTriggerProxy* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		RavenTriggerProxy* _tmp2_ = NULL;
		RavenTriggerProxy* _tmp3_ = NULL;
		RavenTriggerProxy* _tmp4_ = NULL;
		RavenTriggerProxy* _tmp5_ = NULL;
		_tmp1_ = res;
		_tmp2_ = g_async_result_get_source_object (_tmp1_);
		_tmp3_ = g_async_initable_new_finish (_tmp2_, _tmp1_, &_inner_error_);
		g_object_unref (_tmp2_);
		_tmp0_ = (RavenTriggerProxy*) _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->raven_proxy);
		self->priv->raven_proxy = _tmp4_;
		_tmp5_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp5_, "expansion-changed", (GCallback) ____lambda4__raven_trigger_proxy_expansion_changed, self, G_CONNECT_AFTER);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("RavenTriggerApplet.vala:124: Failed to gain Raven proxy: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void raven_trigger_applet_class_init (RavenTriggerAppletClass * klass) {
	raven_trigger_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RavenTriggerAppletPrivate));
	G_OBJECT_CLASS (klass)->finalize = raven_trigger_applet_finalize;
}


static void raven_trigger_applet_instance_init (RavenTriggerApplet * self) {
	self->priv = RAVEN_TRIGGER_APPLET_GET_PRIVATE (self);
	self->priv->raven_proxy = NULL;
	self->priv->raven_expanded = FALSE;
}


static void raven_trigger_applet_finalize (GObject* obj) {
	RavenTriggerApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAVEN_TRIGGER_APPLET, RavenTriggerApplet);
	_g_object_unref0 (self->widget);
	_g_object_unref0 (self->img_expanded);
	_g_object_unref0 (self->img_hidden);
	_g_object_unref0 (self->img_stack);
	_g_object_unref0 (self->priv->raven_proxy);
	G_OBJECT_CLASS (raven_trigger_applet_parent_class)->finalize (obj);
}


GType raven_trigger_applet_get_type (void) {
	return raven_trigger_applet_type_id;
}


GType raven_trigger_applet_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RavenTriggerAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raven_trigger_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RavenTriggerApplet), 0, (GInstanceInitFunc) raven_trigger_applet_instance_init, NULL };
	raven_trigger_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "RavenTriggerApplet", &g_define_type_info, 0);
	return raven_trigger_applet_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* objmodule = NULL;
	GTypeModule* _tmp0_ = NULL;
	PeasObjectModule* _tmp1_ = NULL;
	g_return_if_fail (module != NULL);
	raven_trigger_plugin_register_type (module);
	raven_trigger_applet_register_type (module);
	raven_trigger_proxy_register_type (module);
	raven_trigger_proxy_proxy_register_dynamic_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_RAVEN_TRIGGER_PLUGIN);
	_g_object_unref0 (objmodule);
}



