/* manager.c generated by valac 0.32.1, the Vala compiler
 * generated from manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <BudgieToplevel.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <budgie-config.h>
#include <BudgieSession.h>
#include <libpeas/peas.h>
#include <BudgieRaven.h>
#include <theme-manager.h>
#include <gtk/gtk.h>
#include <plugin.h>
#include <stdio.h>
#include <girepository.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define BUDGIE_TYPE_SCREEN (budgie_screen_get_type ())
#define BUDGIE_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREEN, BudgieScreen))
#define BUDGIE_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREEN, BudgieScreenClass))
#define BUDGIE_IS_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREEN))
#define BUDGIE_IS_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREEN))
#define BUDGIE_SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREEN, BudgieScreenClass))

typedef struct _BudgieScreen BudgieScreen;
typedef struct _BudgieScreenClass BudgieScreenClass;
typedef struct _BudgieScreenPrivate BudgieScreenPrivate;

#define BUDGIE_TYPE_PANEL_MANAGER_IFACE (budgie_panel_manager_iface_get_type ())
#define BUDGIE_PANEL_MANAGER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIface))
#define BUDGIE_PANEL_MANAGER_IFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIfaceClass))
#define BUDGIE_IS_PANEL_MANAGER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_MANAGER_IFACE))
#define BUDGIE_IS_PANEL_MANAGER_IFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_MANAGER_IFACE))
#define BUDGIE_PANEL_MANAGER_IFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIfaceClass))

typedef struct _BudgiePanelManagerIface BudgiePanelManagerIface;
typedef struct _BudgiePanelManagerIfaceClass BudgiePanelManagerIfaceClass;
typedef struct _BudgiePanelManagerIfacePrivate BudgiePanelManagerIfacePrivate;

#define BUDGIE_TYPE_PANEL_MANAGER (budgie_panel_manager_get_type ())
#define BUDGIE_PANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManager))
#define BUDGIE_PANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerClass))
#define BUDGIE_IS_PANEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_MANAGER))
#define BUDGIE_IS_PANEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_MANAGER))
#define BUDGIE_PANEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerClass))

typedef struct _BudgiePanelManager BudgiePanelManager;
typedef struct _BudgiePanelManagerClass BudgiePanelManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BudgieParamSpecPanelManagerIface BudgieParamSpecPanelManagerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BudgiePanelManagerPrivate BudgiePanelManagerPrivate;

#define BUDGIE_TYPE_PANEL (budgie_panel_get_type ())
#define BUDGIE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL, BudgiePanel))
#define BUDGIE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL, BudgiePanelClass))
#define BUDGIE_IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL))
#define BUDGIE_IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL))
#define BUDGIE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL, BudgiePanelClass))

typedef struct _BudgiePanel BudgiePanel;
typedef struct _BudgiePanelClass BudgiePanelClass;
#define _budgie_panel_manager_iface_unref0(var) ((var == NULL) ? NULL : (var = (budgie_panel_manager_iface_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgiePanelManagerRegisterWithSessionData BudgiePanelManagerRegisterWithSessionData;
#define __g_list_free___vala_PeasPluginInfo_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free___vala_PeasPluginInfo_free0_ (var), NULL)))
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))

#define UUID_TYPE_UUID_FLAGS (uuid_uuid_flags_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _BudgieScreen {
	GObject parent_instance;
	BudgieScreenPrivate * priv;
	BudgiePanelPosition slots;
	GdkRectangle area;
};

struct _BudgieScreenClass {
	GObjectClass parent_class;
};

struct _BudgiePanelManagerIface {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgiePanelManagerIfacePrivate * priv;
};

struct _BudgiePanelManagerIfaceClass {
	GTypeClass parent_class;
	void (*finalize) (BudgiePanelManagerIface *self);
};

struct _BudgiePanelManagerIfacePrivate {
	BudgiePanelManager* manager;
};

struct _BudgieParamSpecPanelManagerIface {
	GParamSpec parent_instance;
};

struct _BudgiePanelManager {
	BudgieDesktopManager parent_instance;
	BudgiePanelManagerPrivate * priv;
};

struct _BudgiePanelManagerClass {
	BudgieDesktopManagerClass parent_class;
};

struct _BudgiePanelManagerPrivate {
	BudgiePanelManagerIface* iface;
	gboolean setup;
	gboolean reset;
	LibSessionSessionClient* sclient;
	GHashTable* screens;
	GHashTable* panels;
	gint primary_monitor;
	GSettings* settings;
	PeasEngine* engine;
	PeasExtensionSet* extensions;
	GHashTable* plugins;
	BudgieRaven* raven;
	BudgieThemeManager* theme_manager;
	gboolean migrate_load_requirements_met;
};

struct _BudgiePanelManagerRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgiePanelManager* self;
	gboolean result;
	LibSessionSessionClient* _tmp0_;
	GError* e;
	LibSessionSessionClient* _tmp1_;
	LibSessionSessionClient* _tmp2_;
	LibSessionSessionClient* _tmp3_;
	GError * _inner_error_;
};

typedef enum  {
	UUID_UUID_FLAGS_LOWER_CASE = 1 << 0,
	UUID_UUID_FLAGS_UPPER_CASE = 1 << 1,
	UUID_UUID_FLAGS_DEFAULT_CASE = 1 << 2,
	UUID_UUID_FLAGS_RANDOM_TYPE = 1 << 3,
	UUID_UUID_FLAGS_DEFAULT_TYPE = 1 << 4,
	UUID_UUID_FLAGS_TIME_TYPE = 1 << 5,
	UUID_UUID_FLAGS_TIME_SAFE_TYPE = 1 << 6
} LibUUIDUUIDFlags;


static gpointer budgie_screen_parent_class = NULL;
static gpointer budgie_panel_manager_iface_parent_class = NULL;
static gpointer budgie_panel_manager_parent_class = NULL;

#define BUDGIE_DBUS_NAME "com.solus_project.budgie.Panel"
#define BUDGIE_DBUS_OBJECT_PATH "/com/solus_project/budgie/Panel"
GType budgie_screen_get_type (void) G_GNUC_CONST;
enum  {
	BUDGIE_SCREEN_DUMMY_PROPERTY
};
BudgieScreen* budgie_screen_new (void);
BudgieScreen* budgie_screen_construct (GType object_type);
static void budgie_screen_finalize (GObject* obj);
#define BUDGIE_MAX_SLOTS ((guint) 2)
#define BUDGIE_ROOT_SCHEMA "com.solus-project.budgie-panel"
#define BUDGIE_TOPLEVEL_SCHEMA "com.solus-project.budgie-panel.panel"
#define BUDGIE_TOPLEVEL_PREFIX "/com/solus-project/budgie-panel/panels"
#define BUDGIE_APPLET_SCHEMA "com.solus-project.budgie-panel.applet"
#define BUDGIE_APPLET_PREFIX "/com/solus-project/budgie-panel/applets"
#define BUDGIE_ROOT_KEY_PANELS "panels"
#define BUDGIE_PANEL_KEY_POSITION "location"
#define BUDGIE_PANEL_KEY_APPLETS "applets"
#define BUDGIE_PANEL_KEY_DARK_THEME "dark-theme"
#define BUDGIE_PANEL_KEY_SIZE "size"
#define BUDGIE_PANEL_KEY_SHADOW "enable-shadow"
#define BUDGIE_PANEL_KEY_REGIONS "theme-regions"
#define BUDGIE_PANEL_KEY_MIGRATION "migration-level"
#define BUDGIE_BUDGIE_MIGRATION_LEVEL 1
gpointer budgie_panel_manager_iface_ref (gpointer instance);
void budgie_panel_manager_iface_unref (gpointer instance);
GParamSpec* budgie_param_spec_panel_manager_iface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void budgie_value_set_panel_manager_iface (GValue* value, gpointer v_object);
void budgie_value_take_panel_manager_iface (GValue* value, gpointer v_object);
gpointer budgie_value_get_panel_manager_iface (const GValue* value);
GType budgie_panel_manager_iface_get_type (void) G_GNUC_CONST;
guint budgie_panel_manager_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType budgie_panel_manager_get_type (void) G_GNUC_CONST;
#define BUDGIE_PANEL_MANAGER_IFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIfacePrivate))
enum  {
	BUDGIE_PANEL_MANAGER_IFACE_DUMMY_PROPERTY
};
BudgiePanelManagerIface* budgie_panel_manager_iface_new (BudgiePanelManager* manager);
BudgiePanelManagerIface* budgie_panel_manager_iface_construct (GType object_type, BudgiePanelManager* manager);
gchar* budgie_panel_manager_iface_get_version (BudgiePanelManagerIface* self);
void budgie_panel_manager_iface_ActivateAction (BudgiePanelManagerIface* self, gint action);
void budgie_panel_manager_activate_action (BudgiePanelManager* self, gint action);
static void budgie_panel_manager_iface_finalize (BudgiePanelManagerIface* obj);
static void _dbus_budgie_panel_manager_iface_get_version (BudgiePanelManagerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_panel_manager_iface_ActivateAction (BudgiePanelManagerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_panel_manager_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_panel_manager_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_panel_manager_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _budgie_panel_manager_iface_unregister_object (gpointer user_data);
GType budgie_panel_get_type (void) G_GNUC_CONST;
#define BUDGIE_PANEL_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManagerPrivate))
enum  {
	BUDGIE_PANEL_MANAGER_DUMMY_PROPERTY
};
gboolean budgie_panel_activate_action (BudgiePanel* self, gint remote_action);
static void budgie_panel_manager_end_session (BudgiePanelManager* self, gboolean quit);
static void budgie_panel_manager_register_with_session_data_free (gpointer _data);
static void budgie_panel_manager_register_with_session (BudgiePanelManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean budgie_panel_manager_register_with_session_finish (BudgiePanelManager* self, GAsyncResult* _res_);
static gboolean budgie_panel_manager_register_with_session_co (BudgiePanelManagerRegisterWithSessionData* _data_);
static void budgie_panel_manager_register_with_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda11_ (BudgiePanelManager* self);
static void ___lambda11__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self);
static void __lambda12_ (BudgiePanelManager* self);
static void ___lambda12__lib_session_session_client_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self);
static void __lambda13_ (BudgiePanelManager* self);
static void ___lambda13__lib_session_session_client_stop (LibSessionSessionClient* _sender, gpointer self);
BudgiePanelManager* budgie_panel_manager_new (gboolean reset);
BudgiePanelManager* budgie_panel_manager_construct (GType object_type, gboolean reset);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static void __vala_PeasPluginInfo_free0_ (gpointer var);
BudgieAppletInfo* budgie_panel_manager_get_applet (BudgiePanelManager* self, const gchar* key);
static gchar* budgie_panel_manager_create_panel_path (BudgiePanelManager* self, const gchar* uuid);
static gchar* budgie_panel_manager_create_applet_path (BudgiePanelManager* self, const gchar* uuid);
void budgie_panel_manager_on_monitors_changed (BudgiePanelManager* self);
void budgie_panel_update_geometry (BudgiePanel* self, GdkRectangle* screen, BudgiePanelPosition position, gint size);
static void budgie_panel_manager_on_bus_acquired (BudgiePanelManager* self, GDBusConnection* conn);
void budgie_panel_manager_on_name_acquired (BudgiePanelManager* self, GDBusConnection* conn, const gchar* name);
static void budgie_panel_manager_do_setup (BudgiePanelManager* self);
static void budgie_panel_manager_do_reset (BudgiePanelManager* self);
static void _budgie_panel_manager_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self);
static void _budgie_panel_manager_on_monitors_changed_gdk_screen_size_changed (GdkScreen* _sender, gpointer self);
static void budgie_panel_manager_setup_plugins (BudgiePanelManager* self);
static gboolean budgie_panel_manager_load_panels (BudgiePanelManager* self);
static void budgie_panel_manager_create_default (BudgiePanelManager* self);
static void budgie_panel_manager_perform_migration (BudgiePanelManager* self, gint current_migration_level);
static void __lambda15_ (BudgiePanelManager* self, GObject* o, GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void budgie_panel_perform_migration (BudgiePanel* self, gint current_migration_level);
static void budgie_panel_manager_on_extension_added (BudgiePanelManager* self, PeasPluginInfo* info, GObject* p);
static void _budgie_panel_manager_on_extension_added_peas_extension_set_extension_added (PeasExtensionSet* _sender, PeasPluginInfo* info, GObject* exten, gpointer self);
static void __lambda14_ (BudgiePanelManager* self, PeasPluginInfo* i);
static void ___lambda14__peas_engine_load_plugin (PeasEngine* _sender, PeasPluginInfo* info, gpointer self);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
gboolean budgie_panel_manager_is_extension_loaded (BudgiePanelManager* self, const gchar* name);
static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle);
gboolean budgie_panel_manager_is_extension_valid (BudgiePanelManager* self, const gchar* name);
static PeasPluginInfo* budgie_panel_manager_get_plugin_info (BudgiePanelManager* self, const gchar* name);
static GList* budgie_panel_manager_real_get_panel_plugins (BudgieDesktopManager* base);
static void _g_list_free___vala_PeasPluginInfo_free0_ (GList* self);
void budgie_panel_manager_modprobe (BudgiePanelManager* self, const gchar* name);
BudgieAppletInfo* budgie_panel_manager_load_applet_instance (BudgiePanelManager* self, const gchar* uuid, gchar** name, GSettings* psettings);
BudgieAppletInfo* budgie_panel_manager_create_new_applet (BudgiePanelManager* self, const gchar* name, const gchar* uuid);
BudgiePanelPosition budgie_panel_manager_get_first_position (BudgiePanelManager* self, gint monitor);
static guint budgie_panel_manager_real_slots_available (BudgieDesktopManager* base);
static guint budgie_panel_manager_real_slots_used (BudgieDesktopManager* base);
static void budgie_panel_manager_load_panel (BudgiePanelManager* self, const gchar* uuid, gboolean configure);
BudgiePanel* budgie_panel_new (BudgiePanelManager* manager, const gchar* uuid, GSettings* settings);
BudgiePanel* budgie_panel_construct (GType object_type, BudgiePanelManager* manager, const gchar* uuid, GSettings* settings);
static void budgie_panel_manager_show_panel (BudgiePanelManager* self, const gchar* uuid, BudgiePanelPosition position);
static gchar* budgie_panel_manager_pos_text (BudgiePanelPosition pos);
static void budgie_panel_manager_real_set_size (BudgieDesktopManager* base, const gchar* uuid, gint size);
static void budgie_panel_manager_update_screen (BudgiePanelManager* self);
static void budgie_panel_manager_real_set_placement (BudgieDesktopManager* base, const gchar* uuid, BudgiePanelPosition position);
static void budgie_panel_manager_real_create_new_panel (BudgieDesktopManager* base);
static void budgie_panel_manager_create_panel (BudgiePanelManager* self, const gchar* name, GKeyFile* new_defaults);
static void budgie_panel_manager_real_delete_panel (BudgieDesktopManager* base, const gchar* uuid);
static void budgie_panel_manager_set_panels (BudgiePanelManager* self);
void budgie_panel_destroy_children (BudgiePanel* self);
GType uuid_uuid_flags_get_type (void) G_GNUC_CONST;
gchar* uuid_new (LibUUIDUUIDFlags flags);
void budgie_panel_create_default_layout (BudgiePanel* self, const gchar* name, GKeyFile* config);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void budgie_panel_manager_on_name_lost (BudgiePanelManager* self, GDBusConnection* conn, const gchar* name);
void budgie_panel_manager_serve (BudgiePanelManager* self, gboolean replace);
static void _budgie_panel_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _budgie_panel_manager_on_name_acquired_gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void _budgie_panel_manager_on_name_lost_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static GList* budgie_panel_manager_real_get_panels (BudgieDesktopManager* base);
static void _g_list_free__g_object_unref0_ (GList* self);
static void budgie_panel_manager_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* BUDGIE_MIGRATION_1_APPLETS[2] = {"User Indicator", "Raven Trigger"};
static const GDBusArgInfo _budgie_panel_manager_iface_dbus_arg_info_get_version_result = {-1, "result", "s"};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_get_version_in[] = {NULL};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_get_version_out[] = {&_budgie_panel_manager_iface_dbus_arg_info_get_version_result, NULL};
static const GDBusMethodInfo _budgie_panel_manager_iface_dbus_method_info_get_version = {-1, "GetVersion", (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_get_version_in), (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_get_version_out)};
static const GDBusArgInfo _budgie_panel_manager_iface_dbus_arg_info_ActivateAction_action = {-1, "action", "i"};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_ActivateAction_in[] = {&_budgie_panel_manager_iface_dbus_arg_info_ActivateAction_action, NULL};
static const GDBusArgInfo * const _budgie_panel_manager_iface_dbus_arg_info_ActivateAction_out[] = {NULL};
static const GDBusMethodInfo _budgie_panel_manager_iface_dbus_method_info_ActivateAction = {-1, "ActivateAction", (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_ActivateAction_in), (GDBusArgInfo **) (&_budgie_panel_manager_iface_dbus_arg_info_ActivateAction_out)};
static const GDBusMethodInfo * const _budgie_panel_manager_iface_dbus_method_info[] = {&_budgie_panel_manager_iface_dbus_method_info_get_version, &_budgie_panel_manager_iface_dbus_method_info_ActivateAction, NULL};
static const GDBusSignalInfo * const _budgie_panel_manager_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_panel_manager_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_panel_manager_iface_dbus_interface_info = {-1, "com.solus_project.budgie.Panel", (GDBusMethodInfo **) (&_budgie_panel_manager_iface_dbus_method_info), (GDBusSignalInfo **) (&_budgie_panel_manager_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_panel_manager_iface_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_panel_manager_iface_dbus_interface_vtable = {budgie_panel_manager_iface_dbus_interface_method_call, budgie_panel_manager_iface_dbus_interface_get_property, budgie_panel_manager_iface_dbus_interface_set_property};

BudgieScreen* budgie_screen_construct (GType object_type) {
	BudgieScreen * self = NULL;
	self = (BudgieScreen*) g_object_new (object_type, NULL);
	return self;
}


BudgieScreen* budgie_screen_new (void) {
	return budgie_screen_construct (BUDGIE_TYPE_SCREEN);
}


static void budgie_screen_class_init (BudgieScreenClass * klass) {
	budgie_screen_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_screen_finalize;
}


static void budgie_screen_instance_init (BudgieScreen * self) {
}


static void budgie_screen_finalize (GObject* obj) {
	BudgieScreen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SCREEN, BudgieScreen);
	G_OBJECT_CLASS (budgie_screen_parent_class)->finalize (obj);
}


/**
 * Available slots
 */
GType budgie_screen_get_type (void) {
	static volatile gsize budgie_screen_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_screen_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieScreenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_screen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieScreen), 0, (GInstanceInitFunc) budgie_screen_instance_init, NULL };
		GType budgie_screen_type_id;
		budgie_screen_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieScreen", &g_define_type_info, 0);
		g_once_init_leave (&budgie_screen_type_id__volatile, budgie_screen_type_id);
	}
	return budgie_screen_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BudgiePanelManagerIface* budgie_panel_manager_iface_construct (GType object_type, BudgiePanelManager* manager) {
	BudgiePanelManagerIface* self = NULL;
	BudgiePanelManager* _tmp0_ = NULL;
	BudgiePanelManager* _tmp1_ = NULL;
	self = (BudgiePanelManagerIface*) g_type_create_instance (object_type);
	_tmp0_ = manager;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp1_;
	return self;
}


BudgiePanelManagerIface* budgie_panel_manager_iface_new (BudgiePanelManager* manager) {
	return budgie_panel_manager_iface_construct (BUDGIE_TYPE_PANEL_MANAGER_IFACE, manager);
}


gchar* budgie_panel_manager_iface_get_version (BudgiePanelManagerIface* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (BUDGIE_VERSION);
	result = _tmp0_;
	return result;
}


void budgie_panel_manager_iface_ActivateAction (BudgiePanelManagerIface* self, gint action) {
	BudgiePanelManager* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = action;
	budgie_panel_manager_activate_action (_tmp0_, _tmp1_);
}


static void budgie_value_panel_manager_iface_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void budgie_value_panel_manager_iface_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		budgie_panel_manager_iface_unref (value->data[0].v_pointer);
	}
}


static void budgie_value_panel_manager_iface_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_panel_manager_iface_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer budgie_value_panel_manager_iface_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* budgie_value_panel_manager_iface_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BudgiePanelManagerIface* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_panel_manager_iface_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* budgie_value_panel_manager_iface_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BudgiePanelManagerIface** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_panel_manager_iface_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* budgie_param_spec_panel_manager_iface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BudgieParamSpecPanelManagerIface* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_PANEL_MANAGER_IFACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer budgie_value_get_panel_manager_iface (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_MANAGER_IFACE), NULL);
	return value->data[0].v_pointer;
}


void budgie_value_set_panel_manager_iface (GValue* value, gpointer v_object) {
	BudgiePanelManagerIface* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_MANAGER_IFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_PANEL_MANAGER_IFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_panel_manager_iface_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_panel_manager_iface_unref (old);
	}
}


void budgie_value_take_panel_manager_iface (GValue* value, gpointer v_object) {
	BudgiePanelManagerIface* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_MANAGER_IFACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_PANEL_MANAGER_IFACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_panel_manager_iface_unref (old);
	}
}


static void budgie_panel_manager_iface_class_init (BudgiePanelManagerIfaceClass * klass) {
	budgie_panel_manager_iface_parent_class = g_type_class_peek_parent (klass);
	((BudgiePanelManagerIfaceClass *) klass)->finalize = budgie_panel_manager_iface_finalize;
	g_type_class_add_private (klass, sizeof (BudgiePanelManagerIfacePrivate));
}


static void budgie_panel_manager_iface_instance_init (BudgiePanelManagerIface * self) {
	self->priv = BUDGIE_PANEL_MANAGER_IFACE_GET_PRIVATE (self);
	self->priv->manager = NULL;
	self->ref_count = 1;
}


static void budgie_panel_manager_iface_finalize (BudgiePanelManagerIface* obj) {
	BudgiePanelManagerIface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL_MANAGER_IFACE, BudgiePanelManagerIface);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->manager);
}


GType budgie_panel_manager_iface_get_type (void) {
	static volatile gsize budgie_panel_manager_iface_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_panel_manager_iface_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { budgie_value_panel_manager_iface_init, budgie_value_panel_manager_iface_free_value, budgie_value_panel_manager_iface_copy_value, budgie_value_panel_manager_iface_peek_pointer, "p", budgie_value_panel_manager_iface_collect_value, "p", budgie_value_panel_manager_iface_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelManagerIfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_manager_iface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePanelManagerIface), 0, (GInstanceInitFunc) budgie_panel_manager_iface_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType budgie_panel_manager_iface_type_id;
		budgie_panel_manager_iface_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgiePanelManagerIface", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_type_set_qdata (budgie_panel_manager_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_panel_manager_iface_register_object);
		g_once_init_leave (&budgie_panel_manager_iface_type_id__volatile, budgie_panel_manager_iface_type_id);
	}
	return budgie_panel_manager_iface_type_id__volatile;
}


gpointer budgie_panel_manager_iface_ref (gpointer instance) {
	BudgiePanelManagerIface* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void budgie_panel_manager_iface_unref (gpointer instance) {
	BudgiePanelManagerIface* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_PANEL_MANAGER_IFACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _dbus_budgie_panel_manager_iface_get_version (BudgiePanelManagerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_panel_manager_iface_get_version (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_panel_manager_iface_ActivateAction (BudgiePanelManagerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint action = 0;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_get_int32 (_tmp0_);
	g_variant_unref (_tmp0_);
	budgie_panel_manager_iface_ActivateAction (self, action);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_panel_manager_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetVersion") == 0) {
		_dbus_budgie_panel_manager_iface_get_version (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateAction") == 0) {
		_dbus_budgie_panel_manager_iface_ActivateAction (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_panel_manager_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_panel_manager_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint budgie_panel_manager_iface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = budgie_panel_manager_iface_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_panel_manager_iface_dbus_interface_info), &_budgie_panel_manager_iface_dbus_interface_vtable, data, _budgie_panel_manager_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _budgie_panel_manager_iface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	budgie_panel_manager_iface_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void budgie_panel_manager_activate_action (BudgiePanelManager* self, gint action) {
	const gchar* uuid = NULL;
	BudgiePanel* panel = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	uuid = NULL;
	panel = NULL;
	_tmp0_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		BudgiePanel* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		uuid = _tmp1_;
		panel = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = panel;
		_tmp5_ = action;
		_tmp6_ = budgie_panel_activate_action (_tmp4_, _tmp5_);
		if (_tmp6_) {
			break;
		}
	}
}


static void budgie_panel_manager_end_session (BudgiePanelManager* self, gboolean quit) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = quit;
	if (_tmp0_) {
		gtk_main_quit ();
		return;
	}
	{
		LibSessionSessionClient* _tmp1_ = NULL;
		_tmp1_ = self->priv->sclient;
		lib_session_session_client_EndSessionResponse (_tmp1_, TRUE, "", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("manager.vala:172: Unable to respond to session manager! %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void budgie_panel_manager_register_with_session_data_free (gpointer _data) {
	BudgiePanelManagerRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgiePanelManagerRegisterWithSessionData, _data_);
}


static void budgie_panel_manager_register_with_session (BudgiePanelManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgiePanelManagerRegisterWithSessionData* _data_;
	BudgiePanelManager* _tmp0_ = NULL;
	_data_ = g_slice_new0 (BudgiePanelManagerRegisterWithSessionData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_panel_manager_register_with_session);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_panel_manager_register_with_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_panel_manager_register_with_session_co (_data_);
}


static gboolean budgie_panel_manager_register_with_session_finish (BudgiePanelManager* self, GAsyncResult* _res_) {
	gboolean result;
	BudgiePanelManagerRegisterWithSessionData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void budgie_panel_manager_register_with_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BudgiePanelManagerRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_panel_manager_register_with_session_co (_data_);
}


static void __lambda11_ (BudgiePanelManager* self) {
	budgie_panel_manager_end_session (self, FALSE);
}


static void ___lambda11__lib_session_session_client_query_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self) {
	__lambda11_ ((BudgiePanelManager*) self);
}


static void __lambda12_ (BudgiePanelManager* self) {
	budgie_panel_manager_end_session (self, FALSE);
}


static void ___lambda12__lib_session_session_client_end_session (LibSessionSessionClient* _sender, guint flags, gpointer self) {
	__lambda12_ ((BudgiePanelManager*) self);
}


static void __lambda13_ (BudgiePanelManager* self) {
	budgie_panel_manager_end_session (self, TRUE);
}


static void ___lambda13__lib_session_session_client_stop (LibSessionSessionClient* _sender, gpointer self) {
	__lambda13_ ((BudgiePanelManager*) self);
}


static gboolean budgie_panel_manager_register_with_session_co (BudgiePanelManagerRegisterWithSessionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		lib_session_register_with_session ("budgie-panel", budgie_panel_manager_register_with_session_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = lib_session_register_with_session_finish (_data_->_res_);
		_g_object_unref0 (_data_->self->priv->sclient);
		_data_->self->priv->sclient = _data_->_tmp0_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp1_, "query-end-session", (GCallback) ___lambda11__lib_session_session_client_query_end_session, _data_->self, 0);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp2_, "end-session", (GCallback) ___lambda12__lib_session_session_client_end_session, _data_->self, 0);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->sclient;
	g_signal_connect_object (_data_->_tmp3_, "stop", (GCallback) ___lambda13__lib_session_session_client_stop, _data_->self, 0);
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_PeasPluginInfo_free (PeasPluginInfo* self) {
	g_boxed_free (peas_plugin_info_get_type (), self);
}


static void __vala_PeasPluginInfo_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL));
}


BudgiePanelManager* budgie_panel_manager_construct (GType object_type, gboolean reset) {
	BudgiePanelManager * self = NULL;
	gboolean _tmp0_ = FALSE;
	GHashFunc _tmp1_ = NULL;
	GEqualFunc _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashFunc _tmp4_ = NULL;
	GEqualFunc _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	GHashFunc _tmp7_ = NULL;
	GEqualFunc _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	self = (BudgiePanelManager*) g_object_new (object_type, NULL);
	_tmp0_ = reset;
	self->priv->reset = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->screens);
	self->priv->screens = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->panels);
	self->priv->panels = _tmp6_;
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, __vala_PeasPluginInfo_free0_);
	_g_hash_table_unref0 (self->priv->plugins);
	self->priv->plugins = _tmp9_;
	return self;
}


BudgiePanelManager* budgie_panel_manager_new (gboolean reset) {
	return budgie_panel_manager_construct (BUDGIE_TYPE_PANEL_MANAGER, reset);
}


BudgieAppletInfo* budgie_panel_manager_get_applet (BudgiePanelManager* self, const gchar* key) {
	BudgieAppletInfo* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	result = NULL;
	return result;
}


static gchar* budgie_panel_manager_create_panel_path (BudgiePanelManager* self, const gchar* uuid) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = uuid;
	_tmp1_ = g_strdup_printf ("%s/{%s}/", BUDGIE_TOPLEVEL_PREFIX, _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* budgie_panel_manager_create_applet_path (BudgiePanelManager* self, const gchar* uuid) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = uuid;
	_tmp1_ = g_strdup_printf ("%s/{%s}/", BUDGIE_APPLET_PREFIX, _tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * Discover all possible monitors, and move things accordingly.
     * In future we'll support per-monitor panels, but for now everything
     * must be in one of the edges on the primary monitor
     */
void budgie_panel_manager_on_monitors_changed (BudgiePanelManager* self) {
	GdkScreen* scr = NULL;
	GdkScreen* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	gint mon = 0;
	GdkScreen* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GHashTableIter iter = {0};
	const gchar* uuid = NULL;
	BudgiePanel* panel = NULL;
	BudgieScreen* primary = NULL;
	BudgiePanel* top = NULL;
	BudgiePanel* bottom = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gconstpointer _tmp23_ = NULL;
	GHashTable* _tmp24_ = NULL;
	gint _tmp48_ = 0;
	BudgieRaven* _tmp49_ = NULL;
	BudgieScreen* _tmp50_ = NULL;
	GdkRectangle _tmp51_ = {0};
	BudgiePanel* _tmp52_ = NULL;
	BudgiePanel* _tmp53_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	scr = _tmp1_;
	_tmp2_ = scr;
	_tmp3_ = gdk_screen_get_primary_monitor (_tmp2_);
	mon = _tmp3_;
	top = NULL;
	bottom = NULL;
	_tmp4_ = self->priv->screens;
	g_hash_table_remove_all (_tmp4_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				GdkScreen* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				GdkRectangle usable_area = {0};
				GdkScreen* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				GdkRectangle _tmp12_ = {0};
				BudgieScreen* screen = NULL;
				BudgieScreen* _tmp13_ = NULL;
				BudgieScreen* _tmp14_ = NULL;
				GdkRectangle _tmp15_ = {0};
				BudgieScreen* _tmp16_ = NULL;
				GHashTable* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				BudgieScreen* _tmp19_ = NULL;
				BudgieScreen* _tmp20_ = NULL;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = scr;
				_tmp9_ = gdk_screen_get_n_monitors (_tmp8_);
				if (!(_tmp7_ < _tmp9_)) {
					break;
				}
				_tmp10_ = scr;
				_tmp11_ = i;
				gdk_screen_get_monitor_geometry (_tmp10_, _tmp11_, &_tmp12_);
				usable_area = _tmp12_;
				_tmp13_ = budgie_screen_new ();
				screen = _tmp13_;
				_tmp14_ = screen;
				_tmp15_ = usable_area;
				_tmp14_->area = _tmp15_;
				_tmp16_ = screen;
				_tmp16_->slots = BUDGIE_PANEL_POSITION_NONE;
				_tmp17_ = self->priv->screens;
				_tmp18_ = i;
				_tmp19_ = screen;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				g_hash_table_insert (_tmp17_, (gpointer) ((gintptr) _tmp18_), _tmp20_);
				_g_object_unref0 (screen);
			}
		}
	}
	_tmp21_ = self->priv->screens;
	_tmp22_ = mon;
	_tmp23_ = g_hash_table_lookup (_tmp21_, (gpointer) ((gintptr) _tmp22_));
	primary = (BudgieScreen*) _tmp23_;
	_tmp24_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp24_);
	while (TRUE) {
		gconstpointer _tmp25_ = NULL;
		gconstpointer _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		BudgiePanel* _tmp28_ = NULL;
		BudgieScreen* _tmp29_ = NULL;
		GdkRectangle _tmp30_ = {0};
		BudgiePanel* _tmp31_ = NULL;
		BudgiePanelPosition _tmp32_ = 0;
		BudgiePanelPosition _tmp33_ = 0;
		BudgiePanel* _tmp34_ = NULL;
		BudgiePanelPosition _tmp35_ = 0;
		BudgiePanelPosition _tmp36_ = 0;
		BudgieScreen* _tmp42_ = NULL;
		BudgieScreen* _tmp43_ = NULL;
		BudgiePanelPosition _tmp44_ = 0;
		BudgiePanel* _tmp45_ = NULL;
		BudgiePanelPosition _tmp46_ = 0;
		BudgiePanelPosition _tmp47_ = 0;
		_tmp27_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp25_), (gpointer*) (&_tmp26_));
		uuid = _tmp25_;
		panel = _tmp26_;
		if (!_tmp27_) {
			break;
		}
		_tmp28_ = panel;
		_tmp29_ = primary;
		_tmp30_ = _tmp29_->area;
		_tmp31_ = panel;
		_tmp32_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp31_);
		_tmp33_ = _tmp32_;
		budgie_panel_update_geometry (_tmp28_, &_tmp30_, _tmp33_, 0);
		_tmp34_ = panel;
		_tmp35_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp34_);
		_tmp36_ = _tmp35_;
		if (_tmp36_ == BUDGIE_PANEL_POSITION_TOP) {
			BudgiePanel* _tmp37_ = NULL;
			_tmp37_ = panel;
			top = _tmp37_;
		} else {
			BudgiePanel* _tmp38_ = NULL;
			BudgiePanelPosition _tmp39_ = 0;
			BudgiePanelPosition _tmp40_ = 0;
			_tmp38_ = panel;
			_tmp39_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp38_);
			_tmp40_ = _tmp39_;
			if (_tmp40_ == BUDGIE_PANEL_POSITION_BOTTOM) {
				BudgiePanel* _tmp41_ = NULL;
				_tmp41_ = panel;
				bottom = _tmp41_;
			}
		}
		_tmp42_ = primary;
		_tmp43_ = primary;
		_tmp44_ = _tmp43_->slots;
		_tmp45_ = panel;
		_tmp46_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp43_->slots = _tmp44_ | _tmp47_;
	}
	_tmp48_ = mon;
	self->priv->primary_monitor = _tmp48_;
	_tmp49_ = self->priv->raven;
	_tmp50_ = primary;
	_tmp51_ = _tmp50_->area;
	_tmp52_ = top;
	_tmp53_ = bottom;
	budgie_raven_update_geometry (_tmp49_, &_tmp51_, (BudgieToplevel*) _tmp52_, (BudgieToplevel*) _tmp53_);
	_g_object_unref0 (scr);
}


static void budgie_panel_manager_on_bus_acquired (BudgiePanelManager* self, GDBusConnection* conn) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		BudgiePanelManagerIface* _tmp0_ = NULL;
		GDBusConnection* _tmp1_ = NULL;
		BudgiePanelManagerIface* _tmp2_ = NULL;
		_tmp0_ = budgie_panel_manager_iface_new (self);
		_budgie_panel_manager_iface_unref0 (self->priv->iface);
		self->priv->iface = _tmp0_;
		_tmp1_ = conn;
		_tmp2_ = self->priv->iface;
		budgie_panel_manager_iface_register_object (_tmp2_, _tmp1_, BUDGIE_DBUS_OBJECT_PATH, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e->message;
		fprintf (_tmp3_, "Error registering PanelManager: %s\n", _tmp4_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void budgie_panel_manager_on_name_acquired (BudgiePanelManager* self, GDBusConnection* conn, const gchar* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	self->priv->setup = TRUE;
	budgie_panel_manager_do_setup (self);
}


/**
     * Reset the entire panel configuration
     */
static void budgie_panel_manager_do_reset (BudgiePanelManager* self) {
	GSettings* s = NULL;
	GSettings* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_message ("manager.vala:294: Reseting budgie-panel configuration to defaults");
	_tmp0_ = g_settings_new (BUDGIE_ROOT_SCHEMA);
	s = _tmp0_;
	g_settings_reset (s, NULL);
	g_settings_sync ();
	_g_object_unref0 (s);
}


/**
     * Initial setup, once we've owned the dbus name
     * i.e. no risk of dying
     */
static void _budgie_panel_manager_on_monitors_changed_gdk_screen_monitors_changed (GdkScreen* _sender, gpointer self) {
	budgie_panel_manager_on_monitors_changed ((BudgiePanelManager*) self);
}


static void _budgie_panel_manager_on_monitors_changed_gdk_screen_size_changed (GdkScreen* _sender, gpointer self) {
	budgie_panel_manager_on_monitors_changed ((BudgiePanelManager*) self);
}


static void __lambda15_ (BudgiePanelManager* self, GObject* o, GAsyncResult* res) {
	gboolean success = FALSE;
	GAsyncResult* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (res != NULL);
	_tmp0_ = res;
	_tmp1_ = budgie_panel_manager_register_with_session_finish (self, _tmp0_);
	success = _tmp1_;
	_tmp2_ = success;
	if (!_tmp2_) {
		g_message ("manager.vala:340: Failed to register with Session manager");
	}
}


static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda15_ ((BudgiePanelManager*) self, source_object, res);
	g_object_unref (self);
}


static void budgie_panel_manager_do_setup (BudgiePanelManager* self) {
	gboolean _tmp0_ = FALSE;
	GdkScreen* scr = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GdkScreen* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GdkScreen* _tmp5_ = NULL;
	GdkScreen* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	BudgieThemeManager* _tmp8_ = NULL;
	BudgieRaven* _tmp9_ = NULL;
	BudgieRaven* _tmp10_ = NULL;
	gint current_migration_level = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	GSettings* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reset;
	if (_tmp0_) {
		budgie_panel_manager_do_reset (self);
	}
	_tmp1_ = gdk_screen_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	scr = _tmp2_;
	_tmp3_ = scr;
	_tmp4_ = gdk_screen_get_primary_monitor (_tmp3_);
	self->priv->primary_monitor = _tmp4_;
	_tmp5_ = scr;
	g_signal_connect_object (_tmp5_, "monitors-changed", (GCallback) _budgie_panel_manager_on_monitors_changed_gdk_screen_monitors_changed, self, 0);
	_tmp6_ = scr;
	g_signal_connect_object (_tmp6_, "size-changed", (GCallback) _budgie_panel_manager_on_monitors_changed_gdk_screen_size_changed, self, 0);
	_tmp7_ = g_settings_new (BUDGIE_ROOT_SCHEMA);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp7_;
	_tmp8_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp8_;
	_tmp9_ = budgie_raven_new ((BudgieDesktopManager*) self);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->raven);
	self->priv->raven = _tmp9_;
	budgie_panel_manager_on_monitors_changed (self);
	_tmp10_ = self->priv->raven;
	budgie_raven_setup_dbus (_tmp10_);
	budgie_panel_manager_setup_plugins (self);
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_int (_tmp11_, BUDGIE_PANEL_KEY_MIGRATION);
	current_migration_level = _tmp12_;
	_tmp13_ = budgie_panel_manager_load_panels (self);
	if (!_tmp13_) {
		g_message ("manager.vala:327: Creating default panel layout");
		budgie_panel_manager_create_default (self);
	} else {
		gint _tmp14_ = 0;
		_tmp14_ = current_migration_level;
		budgie_panel_manager_perform_migration (self, _tmp14_);
	}
	_tmp15_ = self->priv->settings;
	g_settings_set_int (_tmp15_, BUDGIE_PANEL_KEY_MIGRATION, BUDGIE_BUDGIE_MIGRATION_LEVEL);
	budgie_panel_manager_register_with_session (self, ___lambda15__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (scr);
}


/**
     * Attempts to perform the relevant migration operations by
     * finding a migratable panel and calling its migratory function
     */
static void budgie_panel_manager_perform_migration (BudgiePanelManager* self, gint current_migration_level) {
	BudgieToplevel* top = NULL;
	BudgieToplevel* last = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gchar* key = NULL;
	BudgiePanel* val = NULL;
	BudgieScreen* area = NULL;
	GHashTable* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gconstpointer _tmp4_ = NULL;
	BudgieScreen* _tmp5_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp6_ = NULL;
	BudgieToplevel* _tmp19_ = NULL;
	BudgieToplevel* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	g_return_if_fail (self != NULL);
	top = NULL;
	last = NULL;
	_tmp0_ = current_migration_level;
	if (_tmp0_ >= BUDGIE_BUDGIE_MIGRATION_LEVEL) {
		_g_object_unref0 (last);
		_g_object_unref0 (top);
		return;
	}
	_tmp1_ = self->priv->migrate_load_requirements_met;
	if (_tmp1_) {
		g_message ("manager.vala:361: Budgie Migration skipped due to user meeting migrati" \
"on requirements");
		_g_object_unref0 (last);
		_g_object_unref0 (top);
		return;
	}
	g_message ("manager.vala:365: Budgie Migration initiated");
	key = NULL;
	val = NULL;
	_tmp2_ = self->priv->screens;
	_tmp3_ = self->priv->primary_monitor;
	_tmp4_ = g_hash_table_lookup (_tmp2_, (gpointer) ((gintptr) _tmp3_));
	_tmp5_ = _g_object_ref0 ((BudgieScreen*) _tmp4_);
	area = _tmp5_;
	_tmp6_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp6_);
	while (TRUE) {
		gconstpointer _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gchar* _tmp10_ = NULL;
		BudgiePanel* _tmp11_ = NULL;
		BudgiePanel* _tmp12_ = NULL;
		BudgiePanelPosition _tmp13_ = 0;
		BudgiePanelPosition _tmp14_ = 0;
		BudgiePanel* _tmp17_ = NULL;
		BudgieToplevel* _tmp18_ = NULL;
		_tmp9_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp7_), (gpointer*) (&_tmp8_));
		_g_free0 (key);
		_tmp10_ = g_strdup (_tmp7_);
		key = _tmp10_;
		_g_object_unref0 (val);
		_tmp11_ = _g_object_ref0 (_tmp8_);
		val = _tmp11_;
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = val;
		_tmp13_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == BUDGIE_PANEL_POSITION_TOP) {
			BudgiePanel* _tmp15_ = NULL;
			BudgieToplevel* _tmp16_ = NULL;
			_tmp15_ = val;
			_tmp16_ = _g_object_ref0 ((BudgieToplevel*) _tmp15_);
			_g_object_unref0 (top);
			top = _tmp16_;
		}
		_tmp17_ = val;
		_tmp18_ = _g_object_ref0 ((BudgieToplevel*) _tmp17_);
		_g_object_unref0 (last);
		last = _tmp18_;
	}
	_tmp19_ = top;
	if (_tmp19_ != NULL) {
		BudgieToplevel* _tmp20_ = NULL;
		BudgieToplevel* _tmp21_ = NULL;
		_tmp20_ = top;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_g_object_unref0 (last);
		last = _tmp21_;
	}
	_tmp22_ = last;
	_tmp23_ = current_migration_level;
	budgie_panel_perform_migration (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, BUDGIE_TYPE_PANEL) ? ((BudgiePanel*) _tmp22_) : NULL, _tmp23_);
	_g_object_unref0 (area);
	_g_object_unref0 (val);
	_g_free0 (key);
	_g_object_unref0 (last);
	_g_object_unref0 (top);
}


/**
     * Initialise the plugin engine, paths, loaders, etc.
     */
static void _budgie_panel_manager_on_extension_added_peas_extension_set_extension_added (PeasExtensionSet* _sender, PeasPluginInfo* info, GObject* exten, gpointer self) {
	budgie_panel_manager_on_extension_added ((BudgiePanelManager*) self, info, exten);
}


static void __lambda14_ (BudgiePanelManager* self, PeasPluginInfo* i) {
	PeasExtension* e = NULL;
	PeasExtensionSet* _tmp0_ = NULL;
	PeasPluginInfo* _tmp1_ = NULL;
	PeasExtension* _tmp2_ = NULL;
	PeasExtension* _tmp3_ = NULL;
	PeasExtension* _tmp4_ = NULL;
	PeasPluginInfo* _tmp7_ = NULL;
	PeasExtension* _tmp8_ = NULL;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->extensions;
	_tmp1_ = i;
	_tmp2_ = peas_extension_set_get_extension (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	e = _tmp3_;
	_tmp4_ = e;
	if (_tmp4_ == NULL) {
		PeasPluginInfo* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = i;
		_tmp6_ = peas_plugin_info_get_name (_tmp5_);
		g_critical ("manager.vala:429: Failed to find extension for: %s", _tmp6_);
		_g_object_unref0 (e);
		return;
	}
	_tmp7_ = i;
	_tmp8_ = e;
	budgie_panel_manager_on_extension_added (self, _tmp7_, (GObject*) _tmp8_);
	_g_object_unref0 (e);
}


static void ___lambda14__peas_engine_load_plugin (PeasEngine* _sender, PeasPluginInfo* info, gpointer self) {
	__lambda14_ ((BudgiePanelManager*) self, info);
}


static void budgie_panel_manager_setup_plugins (BudgiePanelManager* self) {
	PeasEngine* _tmp0_ = NULL;
	PeasEngine* _tmp1_ = NULL;
	PeasEngine* _tmp2_ = NULL;
	gchar* dir = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	PeasEngine* _tmp12_ = NULL;
	gchar* user_mod = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* hdata = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	PeasEngine* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* hmod = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	PeasEngine* _tmp30_ = NULL;
	PeasEngine* _tmp31_ = NULL;
	PeasExtensionSet* _tmp32_ = NULL;
	PeasExtensionSet* _tmp33_ = NULL;
	PeasEngine* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = peas_engine_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp1_;
	_tmp2_ = self->priv->engine;
	peas_engine_enable_loader (_tmp2_, "python3");
	{
		GIRepository* repo = NULL;
		GIRepository* _tmp3_ = NULL;
		GIRepository* _tmp4_ = NULL;
		GIRepository* _tmp5_ = NULL;
		GIRepository* _tmp6_ = NULL;
		GIRepository* _tmp7_ = NULL;
		_tmp3_ = g_irepository_get_default ();
		_tmp4_ = _g_object_ref0 (_tmp3_);
		repo = _tmp4_;
		_tmp5_ = repo;
		g_irepository_require (_tmp5_, "Peas", "1.0", 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch4_g_error;
		}
		_tmp6_ = repo;
		g_irepository_require (_tmp6_, "PeasGtk", "1.0", 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch4_g_error;
		}
		_tmp7_ = repo;
		g_irepository_require (_tmp7_, "Budgie", "1.0", 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch4_g_error;
		}
		_g_object_unref0 (repo);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_message ("manager.vala:402: Error loading typelibs: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp10_ = g_get_user_data_dir ();
	_tmp11_ = g_strdup (_tmp10_);
	dir = _tmp11_;
	_tmp12_ = self->priv->engine;
	peas_engine_add_search_path (_tmp12_, BUDGIE_MODULE_DIRECTORY, BUDGIE_MODULE_DATA_DIRECTORY);
	_tmp13_ = dir;
	_tmp14_ = g_build_path (G_DIR_SEPARATOR_S, _tmp13_, "budgie-desktop", "plugins", NULL);
	user_mod = _tmp14_;
	_tmp15_ = dir;
	_tmp16_ = g_build_path (G_DIR_SEPARATOR_S, _tmp15_, "budgie-desktop", "data", NULL);
	hdata = _tmp16_;
	_tmp17_ = self->priv->engine;
	_tmp18_ = user_mod;
	_tmp19_ = hdata;
	peas_engine_add_search_path (_tmp17_, _tmp18_, _tmp19_);
	_tmp20_ = dir;
	_tmp21_ = g_build_path (G_DIR_SEPARATOR_S, _tmp20_, "budgie-desktop", "modules", NULL);
	hmod = _tmp21_;
	_tmp22_ = hmod;
	_tmp23_ = g_file_test (_tmp22_, G_FILE_TEST_EXISTS);
	if (_tmp23_) {
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		PeasEngine* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		_tmp24_ = hmod;
		_tmp25_ = user_mod;
		g_warning ("manager.vala:417: Using legacy path %s, please migrate to %s", _tmp24_, _tmp25_);
		_tmp26_ = hmod;
		g_message ("manager.vala:418: Legacy %s path will not be supported in next major v" \
"ersion", _tmp26_);
		_tmp27_ = self->priv->engine;
		_tmp28_ = hmod;
		_tmp29_ = hdata;
		peas_engine_add_search_path (_tmp27_, _tmp28_, _tmp29_);
	}
	_tmp30_ = self->priv->engine;
	peas_engine_rescan_plugins (_tmp30_);
	_tmp31_ = self->priv->engine;
	_tmp32_ = peas_extension_set_new (_tmp31_, budgie_plugin_get_type (), NULL);
	_g_object_unref0 (self->priv->extensions);
	self->priv->extensions = _tmp32_;
	_tmp33_ = self->priv->extensions;
	g_signal_connect_object (_tmp33_, "extension-added", (GCallback) _budgie_panel_manager_on_extension_added_peas_extension_set_extension_added, self, 0);
	_tmp34_ = self->priv->engine;
	g_signal_connect_object (_tmp34_, "load-plugin", (GCallback) ___lambda14__peas_engine_load_plugin, self, G_CONNECT_AFTER);
	_g_free0 (hmod);
	_g_free0 (hdata);
	_g_free0 (user_mod);
	_g_free0 (dir);
}


/**
     * Handle extension loading
     */
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self) {
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}


static gpointer __vala_PeasPluginInfo_copy0 (gpointer self) {
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}


static void budgie_panel_manager_on_extension_added (BudgiePanelManager* self, PeasPluginInfo* info, GObject* p) {
	GHashTable* _tmp0_ = NULL;
	PeasPluginInfo* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GHashTable* _tmp4_ = NULL;
	PeasPluginInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	PeasPluginInfo* _tmp8_ = NULL;
	PeasPluginInfo* _tmp9_ = NULL;
	PeasPluginInfo* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->plugins;
	_tmp1_ = info;
	_tmp2_ = peas_plugin_info_get_name (_tmp1_);
	_tmp3_ = g_hash_table_contains (_tmp0_, _tmp2_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->plugins;
	_tmp5_ = info;
	_tmp6_ = peas_plugin_info_get_name (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = info;
	_tmp9_ = __vala_PeasPluginInfo_copy0 (_tmp8_);
	g_hash_table_insert (_tmp4_, _tmp7_, _tmp9_);
	_tmp10_ = info;
	_tmp11_ = peas_plugin_info_get_name (_tmp10_);
	g_signal_emit_by_name (self, "extension-loaded", _tmp11_);
}


static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


gboolean budgie_panel_manager_is_extension_loaded (BudgiePanelManager* self, const gchar* name) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	if (_vala_string_array_contains (BUDGIE_MIGRATION_1_APPLETS, G_N_ELEMENTS (BUDGIE_MIGRATION_1_APPLETS), _tmp0_)) {
		self->priv->migrate_load_requirements_met = TRUE;
	}
	_tmp1_ = self->priv->plugins;
	_tmp2_ = name;
	_tmp3_ = g_hash_table_contains (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


/**
     * Determine if the extension is known to be valid
     */
gboolean budgie_panel_manager_is_extension_valid (BudgiePanelManager* self, const gchar* name) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	PeasPluginInfo* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	if (_vala_string_array_contains (BUDGIE_MIGRATION_1_APPLETS, G_N_ELEMENTS (BUDGIE_MIGRATION_1_APPLETS), _tmp0_)) {
		self->priv->migrate_load_requirements_met = TRUE;
	}
	_tmp1_ = name;
	_tmp2_ = budgie_panel_manager_get_plugin_info (self, _tmp1_);
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void _g_list_free___vala_PeasPluginInfo_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) __vala_PeasPluginInfo_free0_, NULL);
	g_list_free (self);
}


static GList* budgie_panel_manager_real_get_panel_plugins (BudgieDesktopManager* base) {
	BudgiePanelManager * self;
	GList* result = NULL;
	GList* ret = NULL;
	PeasEngine* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	self = (BudgiePanelManager*) base;
	ret = NULL;
	_tmp0_ = self->priv->engine;
	_tmp1_ = peas_engine_get_plugin_list (_tmp0_);
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp1_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			PeasPluginInfo* info = NULL;
			info = (PeasPluginInfo*) info_it->data;
			{
				PeasPluginInfo* _tmp2_ = NULL;
				PeasPluginInfo* _tmp3_ = NULL;
				_tmp2_ = info;
				_tmp3_ = __vala_PeasPluginInfo_copy0 (_tmp2_);
				ret = g_list_append (ret, _tmp3_);
			}
		}
	}
	result = ret;
	return result;
}


/**
     * PeasEngine.get_plugin_info == completely broken
     */
static PeasPluginInfo* budgie_panel_manager_get_plugin_info (BudgiePanelManager* self, const gchar* name) {
	PeasPluginInfo* result = NULL;
	PeasEngine* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = peas_engine_get_plugin_list (_tmp0_);
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp1_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			PeasPluginInfo* info = NULL;
			info = (PeasPluginInfo*) info_it->data;
			{
				PeasPluginInfo* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				_tmp2_ = info;
				_tmp3_ = peas_plugin_info_get_name (_tmp2_);
				_tmp4_ = name;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					PeasPluginInfo* _tmp5_ = NULL;
					_tmp5_ = info;
					result = _tmp5_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


void budgie_panel_manager_modprobe (BudgiePanelManager* self, const gchar* name) {
	PeasPluginInfo* i = NULL;
	const gchar* _tmp0_ = NULL;
	PeasPluginInfo* _tmp1_ = NULL;
	PeasPluginInfo* _tmp2_ = NULL;
	PeasPluginInfo* _tmp3_ = NULL;
	PeasEngine* _tmp5_ = NULL;
	PeasPluginInfo* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = budgie_panel_manager_get_plugin_info (self, _tmp0_);
	_tmp2_ = __vala_PeasPluginInfo_copy0 (_tmp1_);
	i = _tmp2_;
	_tmp3_ = i;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = name;
		g_warning ("manager.vala:501: budgie_panel_modprobe called for non existent module" \
": %s", _tmp4_);
		__vala_PeasPluginInfo_free0 (i);
		return;
	}
	_tmp5_ = self->priv->engine;
	_tmp6_ = i;
	peas_engine_load_plugin (_tmp5_, _tmp6_);
	__vala_PeasPluginInfo_free0 (i);
}


/**
     * Attempt to load plugin, will set the plugin-name on failure
     */
BudgieAppletInfo* budgie_panel_manager_load_applet_instance (BudgiePanelManager* self, const gchar* uuid, gchar** name, GSettings* psettings) {
	gchar* _vala_name = NULL;
	BudgieAppletInfo* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GSettings* settings = NULL;
	GSettings* _tmp2_ = NULL;
	gchar* pname = NULL;
	GSettings* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	PeasPluginInfo* pinfo = NULL;
	GHashTable* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gconstpointer _tmp11_ = NULL;
	PeasPluginInfo* _tmp12_ = NULL;
	PeasPluginInfo* _tmp13_ = NULL;
	PeasExtension* extension = NULL;
	PeasExtensionSet* _tmp24_ = NULL;
	PeasPluginInfo* _tmp25_ = NULL;
	PeasExtension* _tmp26_ = NULL;
	PeasExtension* _tmp27_ = NULL;
	PeasExtension* _tmp28_ = NULL;
	BudgieApplet* applet = NULL;
	PeasExtension* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	BudgieApplet* _tmp33_ = NULL;
	BudgieAppletInfo* info = NULL;
	PeasPluginInfo* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	BudgieApplet* _tmp36_ = NULL;
	GSettings* _tmp37_ = NULL;
	BudgieAppletInfo* _tmp38_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = uuid;
	_tmp1_ = budgie_panel_manager_create_applet_path (self, _tmp0_);
	path = _tmp1_;
	settings = NULL;
	_tmp2_ = psettings;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		GSettings* _tmp4_ = NULL;
		_tmp3_ = path;
		_tmp4_ = g_settings_new_with_path (BUDGIE_APPLET_SCHEMA, _tmp3_);
		_g_object_unref0 (settings);
		settings = _tmp4_;
	} else {
		GSettings* _tmp5_ = NULL;
		GSettings* _tmp6_ = NULL;
		_tmp5_ = psettings;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (settings);
		settings = _tmp6_;
	}
	_tmp7_ = settings;
	_tmp8_ = g_settings_get_string (_tmp7_, BUDGIE_APPLET_KEY_NAME);
	pname = _tmp8_;
	_tmp9_ = self->priv->plugins;
	_tmp10_ = pname;
	_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
	_tmp12_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) _tmp11_);
	pinfo = _tmp12_;
	_tmp13_ = pinfo;
	if (_tmp13_ == NULL) {
		const gchar* _tmp14_ = NULL;
		PeasPluginInfo* _tmp15_ = NULL;
		PeasPluginInfo* _tmp16_ = NULL;
		PeasPluginInfo* _tmp17_ = NULL;
		PeasEngine* _tmp20_ = NULL;
		PeasPluginInfo* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp14_ = pname;
		_tmp15_ = budgie_panel_manager_get_plugin_info (self, _tmp14_);
		_tmp16_ = __vala_PeasPluginInfo_copy0 (_tmp15_);
		__vala_PeasPluginInfo_free0 (pinfo);
		pinfo = _tmp16_;
		_tmp17_ = pinfo;
		if (_tmp17_ == NULL) {
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			_tmp18_ = pname;
			_tmp19_ = uuid;
			g_warning ("manager.vala:526: Trying to load invalid plugin: %s %s", _tmp18_, _tmp19_);
			_g_free0 (_vala_name);
			_vala_name = NULL;
			result = NULL;
			__vala_PeasPluginInfo_free0 (pinfo);
			_g_free0 (pname);
			_g_object_unref0 (settings);
			_g_free0 (path);
			if (name) {
				*name = _vala_name;
			} else {
				_g_free0 (_vala_name);
			}
			return result;
		}
		_tmp20_ = self->priv->engine;
		_tmp21_ = pinfo;
		peas_engine_load_plugin (_tmp20_, _tmp21_);
		_tmp22_ = pname;
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (_vala_name);
		_vala_name = _tmp23_;
		result = NULL;
		__vala_PeasPluginInfo_free0 (pinfo);
		_g_free0 (pname);
		_g_object_unref0 (settings);
		_g_free0 (path);
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	}
	_tmp24_ = self->priv->extensions;
	_tmp25_ = pinfo;
	_tmp26_ = peas_extension_set_get_extension (_tmp24_, _tmp25_);
	_tmp27_ = _g_object_ref0 (_tmp26_);
	extension = _tmp27_;
	_tmp28_ = extension;
	if (_tmp28_ == NULL) {
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		_tmp29_ = pname;
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (_vala_name);
		_vala_name = _tmp30_;
		result = NULL;
		_g_object_unref0 (extension);
		__vala_PeasPluginInfo_free0 (pinfo);
		_g_free0 (pname);
		_g_object_unref0 (settings);
		_g_free0 (path);
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	}
	_g_free0 (_vala_name);
	_vala_name = NULL;
	_tmp31_ = extension;
	_tmp32_ = uuid;
	_tmp33_ = budgie_plugin_get_panel_widget (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, budgie_plugin_get_type ()) ? ((BudgiePlugin*) _tmp31_) : NULL, _tmp32_);
	applet = _tmp33_;
	_tmp34_ = pinfo;
	_tmp35_ = uuid;
	_tmp36_ = applet;
	_tmp37_ = settings;
	_tmp38_ = budgie_applet_info_new (_tmp34_, _tmp35_, _tmp36_, _tmp37_);
	info = _tmp38_;
	result = info;
	_g_object_unref0 (applet);
	_g_object_unref0 (extension);
	__vala_PeasPluginInfo_free0 (pinfo);
	_g_free0 (pname);
	_g_object_unref0 (settings);
	_g_free0 (path);
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	return result;
}


/**
     * Attempt to create a fresh applet instance
     */
BudgieAppletInfo* budgie_panel_manager_create_new_applet (BudgiePanelManager* self, const gchar* name, const gchar* uuid) {
	BudgieAppletInfo* result = NULL;
	gchar* unused = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* path = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GSettings* settings = NULL;
	const gchar* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	BudgieAppletInfo* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	unused = NULL;
	_tmp0_ = self->priv->plugins;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = NULL;
		_g_free0 (unused);
		return result;
	}
	_tmp3_ = uuid;
	_tmp4_ = budgie_panel_manager_create_applet_path (self, _tmp3_);
	path = _tmp4_;
	_tmp5_ = path;
	_tmp6_ = g_settings_new_with_path (BUDGIE_APPLET_SCHEMA, _tmp5_);
	settings = _tmp6_;
	_tmp7_ = settings;
	_tmp8_ = name;
	g_settings_set_string (_tmp7_, BUDGIE_APPLET_KEY_NAME, _tmp8_);
	_tmp9_ = uuid;
	_tmp10_ = settings;
	_tmp12_ = budgie_panel_manager_load_applet_instance (self, _tmp9_, &_tmp11_, _tmp10_);
	_g_free0 (unused);
	unused = _tmp11_;
	result = _tmp12_;
	_g_object_unref0 (settings);
	_g_free0 (path);
	_g_free0 (unused);
	return result;
}


/**
     * Find the next available position on the given monitor
     */
BudgiePanelPosition budgie_panel_manager_get_first_position (BudgiePanelManager* self, gint monitor) {
	BudgiePanelPosition result = 0;
	GHashTable* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	BudgieScreen* screen = NULL;
	GHashTable* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	BudgieScreen* _tmp7_ = NULL;
	BudgieScreen* _tmp8_ = NULL;
	BudgiePanelPosition _tmp9_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->screens;
	_tmp1_ = monitor;
	_tmp2_ = g_hash_table_contains (_tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (!_tmp2_) {
		gint _tmp3_ = 0;
		_tmp3_ = monitor;
		g_error ("manager.vala:567: No screen for monitor: %d - This should never happen" \
"!", _tmp3_);
		result = BUDGIE_PANEL_POSITION_NONE;
		return result;
	}
	_tmp4_ = self->priv->screens;
	_tmp5_ = monitor;
	_tmp6_ = g_hash_table_lookup (_tmp4_, (gpointer) ((gintptr) _tmp5_));
	_tmp7_ = _g_object_ref0 ((BudgieScreen*) _tmp6_);
	screen = _tmp7_;
	_tmp8_ = screen;
	_tmp9_ = _tmp8_->slots;
	if ((_tmp9_ & BUDGIE_PANEL_POSITION_TOP) == 0) {
		result = BUDGIE_PANEL_POSITION_TOP;
		_g_object_unref0 (screen);
		return result;
	} else {
		BudgieScreen* _tmp10_ = NULL;
		BudgiePanelPosition _tmp11_ = 0;
		_tmp10_ = screen;
		_tmp11_ = _tmp10_->slots;
		if ((_tmp11_ & BUDGIE_PANEL_POSITION_BOTTOM) == 0) {
			result = BUDGIE_PANEL_POSITION_BOTTOM;
			_g_object_unref0 (screen);
			return result;
		} else {
			BudgieScreen* _tmp12_ = NULL;
			BudgiePanelPosition _tmp13_ = 0;
			_tmp12_ = screen;
			_tmp13_ = _tmp12_->slots;
			if ((_tmp13_ & BUDGIE_PANEL_POSITION_LEFT) == 0) {
				result = BUDGIE_PANEL_POSITION_LEFT;
				_g_object_unref0 (screen);
				return result;
			} else {
				BudgieScreen* _tmp14_ = NULL;
				BudgiePanelPosition _tmp15_ = 0;
				_tmp14_ = screen;
				_tmp15_ = _tmp14_->slots;
				if ((_tmp15_ & BUDGIE_PANEL_POSITION_RIGHT) == 0) {
					result = BUDGIE_PANEL_POSITION_RIGHT;
					_g_object_unref0 (screen);
					return result;
				} else {
					result = BUDGIE_PANEL_POSITION_NONE;
					_g_object_unref0 (screen);
					return result;
				}
			}
		}
	}
	_g_object_unref0 (screen);
}


/**
     * Determine how many slots are available
     */
static guint budgie_panel_manager_real_slots_available (BudgieDesktopManager* base) {
	BudgiePanelManager * self;
	guint result = 0U;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = (BudgiePanelManager*) base;
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_size (_tmp0_);
	result = BUDGIE_MAX_SLOTS - _tmp1_;
	return result;
}


/**
     * Determine how many slots have been used
     */
static guint budgie_panel_manager_real_slots_used (BudgieDesktopManager* base) {
	BudgiePanelManager * self;
	guint result = 0U;
	GHashTable* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = (BudgiePanelManager*) base;
	_tmp0_ = self->priv->panels;
	_tmp1_ = g_hash_table_size (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
     * Load a panel by the given UUID, and optionally configure it
     */
static void budgie_panel_manager_load_panel (BudgiePanelManager* self, const gchar* uuid, gboolean configure) {
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* path = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	BudgiePanelPosition position = 0;
	gint size = 0;
	GSettings* settings = NULL;
	const gchar* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	BudgiePanel* panel = NULL;
	const gchar* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	BudgiePanel* _tmp9_ = NULL;
	GHashTable* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	BudgiePanel* _tmp13_ = NULL;
	BudgiePanel* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GSettings* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GSettings* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	BudgiePanel* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	const gchar* _tmp22_ = NULL;
	BudgiePanelPosition _tmp23_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = uuid;
	_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = uuid;
	_tmp4_ = budgie_panel_manager_create_panel_path (self, _tmp3_);
	path = _tmp4_;
	_tmp5_ = path;
	_tmp6_ = g_settings_new_with_path (BUDGIE_TOPLEVEL_SCHEMA, _tmp5_);
	settings = _tmp6_;
	_tmp7_ = uuid;
	_tmp8_ = settings;
	_tmp9_ = budgie_panel_new (self, _tmp7_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	panel = _tmp9_;
	_tmp10_ = self->priv->panels;
	_tmp11_ = uuid;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = panel;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	g_hash_table_insert (_tmp10_, _tmp12_, _tmp14_);
	_tmp15_ = configure;
	if (!_tmp15_) {
		_g_object_unref0 (panel);
		_g_object_unref0 (settings);
		_g_free0 (path);
		return;
	}
	_tmp16_ = settings;
	_tmp17_ = g_settings_get_enum (_tmp16_, BUDGIE_PANEL_KEY_POSITION);
	position = (BudgiePanelPosition) _tmp17_;
	_tmp18_ = settings;
	_tmp19_ = g_settings_get_int (_tmp18_, BUDGIE_PANEL_KEY_SIZE);
	size = _tmp19_;
	_tmp20_ = panel;
	_tmp21_ = size;
	budgie_toplevel_set_intended_size ((BudgieToplevel*) _tmp20_, (gint) _tmp21_);
	_tmp22_ = uuid;
	_tmp23_ = position;
	budgie_panel_manager_show_panel (self, _tmp22_, _tmp23_);
	_g_object_unref0 (panel);
	_g_object_unref0 (settings);
	_g_free0 (path);
}


static gchar* budgie_panel_manager_pos_text (BudgiePanelPosition pos) {
	gchar* result = NULL;
	BudgiePanelPosition _tmp0_ = 0;
	_tmp0_ = pos;
	switch (_tmp0_) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("top");
			result = _tmp1_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("bottom");
			result = _tmp2_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("left");
			result = _tmp3_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("right");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("none");
			result = _tmp5_;
			return result;
		}
	}
}


static void budgie_panel_manager_show_panel (BudgiePanelManager* self, const gchar* uuid, BudgiePanelPosition position) {
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	BudgiePanel* _tmp3_ = NULL;
	BudgieScreen* scr = NULL;
	BudgiePanel* _tmp4_ = NULL;
	GHashTable* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gconstpointer _tmp8_ = NULL;
	BudgieScreen* _tmp9_ = NULL;
	BudgieScreen* _tmp10_ = NULL;
	BudgiePanelPosition _tmp11_ = 0;
	BudgiePanelPosition _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	BudgiePanelPosition _tmp14_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = uuid;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 ((BudgiePanel*) _tmp2_);
	panel = _tmp3_;
	_tmp4_ = panel;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = uuid;
		g_warning ("manager.vala:649: Asked to show non-existent panel: %s", _tmp5_);
		_g_object_unref0 (panel);
		return;
	}
	_tmp6_ = self->priv->screens;
	_tmp7_ = self->priv->primary_monitor;
	_tmp8_ = g_hash_table_lookup (_tmp6_, (gpointer) ((gintptr) _tmp7_));
	scr = (BudgieScreen*) _tmp8_;
	_tmp9_ = scr;
	_tmp10_ = scr;
	_tmp11_ = _tmp10_->slots;
	_tmp12_ = position;
	_tmp10_->slots = _tmp11_ | _tmp12_;
	_tmp13_ = uuid;
	_tmp14_ = position;
	budgie_desktop_manager_set_placement ((BudgieDesktopManager*) self, _tmp13_, _tmp14_);
	_g_object_unref0 (panel);
}


/**
     * Set size of the given panel
     */
static void budgie_panel_manager_real_set_size (BudgieDesktopManager* base, const gchar* uuid, gint size) {
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	BudgiePanel* _tmp3_ = NULL;
	BudgiePanel* _tmp4_ = NULL;
	BudgiePanel* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = uuid;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 ((BudgiePanel*) _tmp2_);
	panel = _tmp3_;
	_tmp4_ = panel;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = uuid;
		g_warning ("manager.vala:666: Asked to resize non-existent panel: %s", _tmp5_);
		_g_object_unref0 (panel);
		return;
	}
	_tmp6_ = panel;
	_tmp7_ = size;
	budgie_toplevel_set_intended_size ((BudgieToplevel*) _tmp6_, _tmp7_);
	budgie_panel_manager_update_screen (self);
	_g_object_unref0 (panel);
}


/**
     * Enforce panel placement
     */
static void budgie_panel_manager_real_set_placement (BudgieDesktopManager* base, const gchar* uuid, BudgiePanelPosition position) {
	BudgiePanelManager * self;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	BudgiePanel* _tmp3_ = NULL;
	gchar* key = NULL;
	BudgiePanel* val = NULL;
	BudgiePanel* conflict = NULL;
	BudgiePanel* _tmp4_ = NULL;
	BudgieScreen* area = NULL;
	GHashTable* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gconstpointer _tmp8_ = NULL;
	BudgieScreen* _tmp9_ = NULL;
	BudgiePanelPosition old = 0;
	BudgiePanel* _tmp10_ = NULL;
	BudgiePanelPosition _tmp11_ = 0;
	BudgiePanelPosition _tmp12_ = 0;
	BudgiePanelPosition _tmp13_ = 0;
	BudgiePanelPosition _tmp14_ = 0;
	GHashTableIter iter = {0};
	GHashTable* _tmp16_ = NULL;
	BudgiePanel* _tmp28_ = NULL;
	BudgiePanel* _tmp29_ = NULL;
	BudgiePanel* _tmp54_ = NULL;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->panels;
	_tmp1_ = uuid;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 ((BudgiePanel*) _tmp2_);
	panel = _tmp3_;
	key = NULL;
	val = NULL;
	conflict = NULL;
	_tmp4_ = panel;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = uuid;
		g_warning ("manager.vala:685: Trying to move non-existent panel: %s", _tmp5_);
		_g_object_unref0 (conflict);
		_g_object_unref0 (val);
		_g_free0 (key);
		_g_object_unref0 (panel);
		return;
	}
	_tmp6_ = self->priv->screens;
	_tmp7_ = self->priv->primary_monitor;
	_tmp8_ = g_hash_table_lookup (_tmp6_, (gpointer) ((gintptr) _tmp7_));
	_tmp9_ = _g_object_ref0 ((BudgieScreen*) _tmp8_);
	area = _tmp9_;
	_tmp10_ = panel;
	_tmp11_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp10_);
	_tmp12_ = _tmp11_;
	old = _tmp12_;
	_tmp13_ = old;
	_tmp14_ = position;
	if (_tmp13_ == _tmp14_) {
		const gchar* _tmp15_ = NULL;
		_tmp15_ = uuid;
		g_warning ("manager.vala:693: Attempting to move panel to the same position it's a" \
"lready in: %s", _tmp15_);
		_g_object_unref0 (area);
		_g_object_unref0 (conflict);
		_g_object_unref0 (val);
		_g_free0 (key);
		_g_object_unref0 (panel);
		return;
	}
	_tmp16_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp16_);
	while (TRUE) {
		gconstpointer _tmp17_ = NULL;
		gconstpointer _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gchar* _tmp20_ = NULL;
		BudgiePanel* _tmp21_ = NULL;
		BudgiePanel* _tmp22_ = NULL;
		BudgiePanelPosition _tmp23_ = 0;
		BudgiePanelPosition _tmp24_ = 0;
		BudgiePanelPosition _tmp25_ = 0;
		_tmp19_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp17_), (gpointer*) (&_tmp18_));
		_g_free0 (key);
		_tmp20_ = g_strdup (_tmp17_);
		key = _tmp20_;
		_g_object_unref0 (val);
		_tmp21_ = _g_object_ref0 (_tmp18_);
		val = _tmp21_;
		if (!_tmp19_) {
			break;
		}
		_tmp22_ = val;
		_tmp23_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = position;
		if (_tmp24_ == _tmp25_) {
			BudgiePanel* _tmp26_ = NULL;
			BudgiePanel* _tmp27_ = NULL;
			_tmp26_ = val;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (conflict);
			conflict = _tmp27_;
			break;
		}
	}
	_tmp28_ = panel;
	gtk_widget_hide ((GtkWidget*) _tmp28_);
	_tmp29_ = conflict;
	if (_tmp29_ != NULL) {
		BudgiePanel* _tmp30_ = NULL;
		BudgiePanel* _tmp31_ = NULL;
		BudgieScreen* _tmp32_ = NULL;
		GdkRectangle _tmp33_ = {0};
		BudgiePanelPosition _tmp34_ = 0;
		BudgiePanel* _tmp35_ = NULL;
		BudgiePanel* _tmp36_ = NULL;
		BudgiePanel* _tmp37_ = NULL;
		BudgieScreen* _tmp38_ = NULL;
		GdkRectangle _tmp39_ = {0};
		BudgiePanelPosition _tmp40_ = 0;
		BudgiePanel* _tmp41_ = NULL;
		_tmp30_ = conflict;
		gtk_widget_hide ((GtkWidget*) _tmp30_);
		_tmp31_ = conflict;
		_tmp32_ = area;
		_tmp33_ = _tmp32_->area;
		_tmp34_ = old;
		budgie_panel_update_geometry (_tmp31_, &_tmp33_, _tmp34_, 0);
		_tmp35_ = conflict;
		gtk_widget_show ((GtkWidget*) _tmp35_);
		_tmp36_ = panel;
		gtk_widget_hide ((GtkWidget*) _tmp36_);
		_tmp37_ = panel;
		_tmp38_ = area;
		_tmp39_ = _tmp38_->area;
		_tmp40_ = position;
		budgie_panel_update_geometry (_tmp37_, &_tmp39_, _tmp40_, 0);
		_tmp41_ = panel;
		gtk_widget_show ((GtkWidget*) _tmp41_);
	} else {
		BudgieScreen* _tmp42_ = NULL;
		BudgieScreen* _tmp43_ = NULL;
		BudgiePanelPosition _tmp44_ = 0;
		BudgiePanelPosition _tmp45_ = 0;
		BudgieScreen* _tmp46_ = NULL;
		BudgieScreen* _tmp47_ = NULL;
		BudgiePanelPosition _tmp48_ = 0;
		BudgiePanelPosition _tmp49_ = 0;
		BudgiePanel* _tmp50_ = NULL;
		BudgieScreen* _tmp51_ = NULL;
		GdkRectangle _tmp52_ = {0};
		BudgiePanelPosition _tmp53_ = 0;
		_tmp42_ = area;
		_tmp43_ = area;
		_tmp44_ = _tmp43_->slots;
		_tmp45_ = old;
		_tmp43_->slots = _tmp44_ ^ _tmp45_;
		_tmp46_ = area;
		_tmp47_ = area;
		_tmp48_ = _tmp47_->slots;
		_tmp49_ = position;
		_tmp47_->slots = _tmp48_ | _tmp49_;
		_tmp50_ = panel;
		_tmp51_ = area;
		_tmp52_ = _tmp51_->area;
		_tmp53_ = position;
		budgie_panel_update_geometry (_tmp50_, &_tmp52_, _tmp53_, 0);
	}
	budgie_panel_manager_update_screen (self);
	_tmp54_ = panel;
	gtk_widget_show ((GtkWidget*) _tmp54_);
	_g_object_unref0 (area);
	_g_object_unref0 (conflict);
	_g_object_unref0 (val);
	_g_free0 (key);
	_g_object_unref0 (panel);
}


/**
     * Force update geometry for all panels
     */
static void budgie_panel_manager_update_screen (BudgiePanelManager* self) {
	BudgieToplevel* top = NULL;
	BudgieToplevel* bottom = NULL;
	gchar* key = NULL;
	BudgiePanel* val = NULL;
	BudgieScreen* area = NULL;
	GHashTable* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gconstpointer _tmp2_ = NULL;
	BudgieScreen* _tmp3_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp4_ = NULL;
	BudgieRaven* _tmp29_ = NULL;
	BudgieScreen* _tmp30_ = NULL;
	GdkRectangle _tmp31_ = {0};
	BudgieToplevel* _tmp32_ = NULL;
	BudgieToplevel* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	top = NULL;
	bottom = NULL;
	key = NULL;
	val = NULL;
	_tmp0_ = self->priv->screens;
	_tmp1_ = self->priv->primary_monitor;
	_tmp2_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) _tmp1_));
	_tmp3_ = _g_object_ref0 ((BudgieScreen*) _tmp2_);
	area = _tmp3_;
	_tmp4_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp4_);
	while (TRUE) {
		gconstpointer _tmp5_ = NULL;
		gconstpointer _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gchar* _tmp8_ = NULL;
		BudgiePanel* _tmp9_ = NULL;
		BudgiePanel* _tmp10_ = NULL;
		BudgiePanelPosition _tmp11_ = 0;
		BudgiePanelPosition _tmp12_ = 0;
		BudgiePanel* _tmp20_ = NULL;
		BudgieScreen* _tmp21_ = NULL;
		GdkRectangle _tmp22_ = {0};
		BudgiePanel* _tmp23_ = NULL;
		BudgiePanelPosition _tmp24_ = 0;
		BudgiePanelPosition _tmp25_ = 0;
		BudgiePanel* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		_tmp7_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp5_), (gpointer*) (&_tmp6_));
		_g_free0 (key);
		_tmp8_ = g_strdup (_tmp5_);
		key = _tmp8_;
		_g_object_unref0 (val);
		_tmp9_ = _g_object_ref0 (_tmp6_);
		val = _tmp9_;
		if (!_tmp7_) {
			break;
		}
		_tmp10_ = val;
		_tmp11_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == BUDGIE_PANEL_POSITION_TOP) {
			BudgiePanel* _tmp13_ = NULL;
			BudgieToplevel* _tmp14_ = NULL;
			_tmp13_ = val;
			_tmp14_ = _g_object_ref0 ((BudgieToplevel*) _tmp13_);
			_g_object_unref0 (top);
			top = _tmp14_;
		} else {
			BudgiePanel* _tmp15_ = NULL;
			BudgiePanelPosition _tmp16_ = 0;
			BudgiePanelPosition _tmp17_ = 0;
			_tmp15_ = val;
			_tmp16_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == BUDGIE_PANEL_POSITION_BOTTOM) {
				BudgiePanel* _tmp18_ = NULL;
				BudgieToplevel* _tmp19_ = NULL;
				_tmp18_ = val;
				_tmp19_ = _g_object_ref0 ((BudgieToplevel*) _tmp18_);
				_g_object_unref0 (bottom);
				bottom = _tmp19_;
			}
		}
		_tmp20_ = val;
		_tmp21_ = area;
		_tmp22_ = _tmp21_->area;
		_tmp23_ = val;
		_tmp24_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = val;
		_tmp27_ = budgie_toplevel_get_intended_size ((BudgieToplevel*) _tmp26_);
		_tmp28_ = _tmp27_;
		budgie_panel_update_geometry (_tmp20_, &_tmp22_, _tmp25_, _tmp28_);
	}
	_tmp29_ = self->priv->raven;
	_tmp30_ = area;
	_tmp31_ = _tmp30_->area;
	_tmp32_ = top;
	_tmp33_ = bottom;
	budgie_raven_update_geometry (_tmp29_, &_tmp31_, _tmp32_, _tmp33_);
	g_signal_emit_by_name ((BudgieDesktopManager*) self, "panels-changed");
	_g_object_unref0 (area);
	_g_object_unref0 (val);
	_g_free0 (key);
	_g_object_unref0 (bottom);
	_g_object_unref0 (top);
}


/**
     * Load all known panels
     */
static gboolean budgie_panel_manager_load_panels (BudgiePanelManager* self) {
	gboolean result = FALSE;
	gchar** panels = NULL;
	GSettings* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint panels_length1 = 0;
	gint _panels_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, BUDGIE_ROOT_KEY_PANELS);
	panels = _tmp2_;
	panels_length1 = _vala_array_length (_tmp1_);
	_panels_size_ = panels_length1;
	_tmp3_ = panels;
	_tmp3__length1 = panels_length1;
	if (_tmp3__length1 == 0) {
		result = FALSE;
		panels = (_vala_array_free (panels, panels_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp4_ = panels;
	_tmp4__length1 = panels_length1;
	{
		gchar** uuid_collection = NULL;
		gint uuid_collection_length1 = 0;
		gint _uuid_collection_size_ = 0;
		gint uuid_it = 0;
		uuid_collection = _tmp4_;
		uuid_collection_length1 = _tmp4__length1;
		for (uuid_it = 0; uuid_it < _tmp4__length1; uuid_it = uuid_it + 1) {
			gchar* _tmp5_ = NULL;
			gchar* uuid = NULL;
			_tmp5_ = g_strdup (uuid_collection[uuid_it]);
			uuid = _tmp5_;
			{
				const gchar* _tmp6_ = NULL;
				_tmp6_ = uuid;
				budgie_panel_manager_load_panel (self, _tmp6_, TRUE);
				_g_free0 (uuid);
			}
		}
	}
	budgie_panel_manager_update_screen (self);
	result = TRUE;
	panels = (_vala_array_free (panels, panels_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void budgie_panel_manager_real_create_new_panel (BudgieDesktopManager* base) {
	BudgiePanelManager * self;
	self = (BudgiePanelManager*) base;
	budgie_panel_manager_create_panel (self, NULL, NULL);
}


static void budgie_panel_manager_real_delete_panel (BudgieDesktopManager* base, const gchar* uuid) {
	BudgiePanelManager * self;
	guint _tmp0_ = 0U;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	BudgiePanel* _tmp4_ = NULL;
	BudgieScreen* area = NULL;
	GHashTable* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gconstpointer _tmp8_ = NULL;
	BudgieScreen* _tmp9_ = NULL;
	BudgieScreen* _tmp10_ = NULL;
	BudgieScreen* _tmp11_ = NULL;
	BudgiePanelPosition _tmp12_ = 0;
	BudgiePanel* _tmp13_ = NULL;
	BudgiePanelPosition _tmp14_ = 0;
	BudgiePanelPosition _tmp15_ = 0;
	gchar* spath = NULL;
	BudgiePanel* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GHashTable* _tmp20_ = NULL;
	BudgiePanel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	BudgiePanel* _tmp24_ = NULL;
	BudgiePanel* _tmp25_ = NULL;
	GSettings* psettings = NULL;
	const gchar* _tmp26_ = NULL;
	GSettings* _tmp27_ = NULL;
	GSettings* _tmp28_ = NULL;
	self = (BudgiePanelManager*) base;
	g_return_if_fail (uuid != NULL);
	_tmp0_ = budgie_desktop_manager_slots_used ((BudgieDesktopManager*) self);
	if (_tmp0_ <= ((guint) 1)) {
		g_warning ("manager.vala:779: Asked to delete final panel");
		return;
	}
	_tmp1_ = self->priv->panels;
	_tmp2_ = uuid;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	panel = (BudgiePanel*) _tmp3_;
	_tmp4_ = panel;
	if (_tmp4_ == NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = uuid;
		g_warning ("manager.vala:785: Asked to delete non-existent panel: %s", _tmp5_);
		return;
	}
	_tmp6_ = self->priv->screens;
	_tmp7_ = self->priv->primary_monitor;
	_tmp8_ = g_hash_table_lookup (_tmp6_, (gpointer) ((gintptr) _tmp7_));
	_tmp9_ = _g_object_ref0 ((BudgieScreen*) _tmp8_);
	area = _tmp9_;
	_tmp10_ = area;
	_tmp11_ = area;
	_tmp12_ = _tmp11_->slots;
	_tmp13_ = panel;
	_tmp14_ = budgie_toplevel_get_position ((BudgieToplevel*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp11_->slots = _tmp12_ ^ _tmp15_;
	_tmp16_ = panel;
	_tmp17_ = budgie_toplevel_get_uuid ((BudgieToplevel*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = budgie_panel_manager_create_panel_path (self, _tmp18_);
	spath = _tmp19_;
	_tmp20_ = self->priv->panels;
	_tmp21_ = panel;
	_tmp22_ = budgie_toplevel_get_uuid ((BudgieToplevel*) _tmp21_);
	_tmp23_ = _tmp22_;
	g_hash_table_steal (_tmp20_, _tmp23_);
	budgie_panel_manager_set_panels (self);
	budgie_panel_manager_update_screen (self);
	_tmp24_ = panel;
	budgie_panel_destroy_children (_tmp24_);
	_tmp25_ = panel;
	gtk_widget_destroy ((GtkWidget*) _tmp25_);
	_tmp26_ = spath;
	_tmp27_ = g_settings_new_with_path (BUDGIE_TOPLEVEL_SCHEMA, _tmp26_);
	psettings = _tmp27_;
	_tmp28_ = psettings;
	g_settings_reset (_tmp28_, NULL);
	_g_object_unref0 (psettings);
	_g_free0 (spath);
	_g_object_unref0 (area);
}


static void budgie_panel_manager_create_panel (BudgiePanelManager* self, const gchar* name, GKeyFile* new_defaults) {
	BudgiePanelPosition position = 0;
	gint size = 0;
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gchar* uuid = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	BudgiePanelPosition _tmp35_ = 0;
	gboolean _tmp36_ = FALSE;
	GKeyFile* _tmp37_ = NULL;
	gint _tmp39_ = 0;
	BudgiePanel* panel = NULL;
	GHashTable* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gconstpointer _tmp44_ = NULL;
	BudgiePanel* _tmp45_ = NULL;
	BudgiePanel* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	GKeyFile* _tmp48_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	position = BUDGIE_PANEL_POSITION_NONE;
	size = -1;
	_tmp0_ = budgie_desktop_manager_slots_available ((BudgieDesktopManager*) self);
	if (_tmp0_ < ((guint) 1)) {
		g_warning ("manager.vala:809: Asked to create panel with no slots available");
		return;
	}
	_tmp2_ = name;
	if (_tmp2_ != NULL) {
		GKeyFile* _tmp3_ = NULL;
		_tmp3_ = new_defaults;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			gboolean _tmp4_ = FALSE;
			GKeyFile* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp19_ = FALSE;
			GKeyFile* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp5_ = new_defaults;
			_tmp6_ = name;
			_tmp7_ = g_key_file_has_key (_tmp5_, _tmp6_, "Position", &_inner_error_);
			_tmp4_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch5_g_error;
			}
			if (_tmp4_) {
				gchar* _tmp8_ = NULL;
				GKeyFile* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				GQuark _tmp18_ = 0U;
				static GQuark _tmp17_label0 = 0;
				_tmp9_ = new_defaults;
				_tmp10_ = name;
				_tmp11_ = g_key_file_get_string (_tmp9_, _tmp10_, "Position", &_inner_error_);
				_tmp8_ = _tmp11_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch5_g_error;
				}
				_tmp12_ = _tmp8_;
				_tmp8_ = NULL;
				_tmp13_ = _tmp12_;
				_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				_tmp16_ = _tmp15_;
				_tmp18_ = (NULL == _tmp16_) ? 0 : g_quark_from_string (_tmp16_);
				g_free (_tmp16_);
				if (_tmp18_ == ((0 != _tmp17_label0) ? _tmp17_label0 : (_tmp17_label0 = g_quark_from_static_string ("top")))) {
					switch (0) {
						default:
						{
							position = BUDGIE_PANEL_POSITION_TOP;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							position = BUDGIE_PANEL_POSITION_BOTTOM;
							break;
						}
					}
				}
				_g_free0 (_tmp8_);
			}
			_tmp20_ = new_defaults;
			_tmp21_ = name;
			_tmp22_ = g_key_file_has_key (_tmp20_, _tmp21_, "Size", &_inner_error_);
			_tmp19_ = _tmp22_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch5_g_error;
			}
			if (_tmp19_) {
				gint _tmp23_ = 0;
				GKeyFile* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				_tmp24_ = new_defaults;
				_tmp25_ = name;
				_tmp26_ = g_key_file_get_integer (_tmp24_, _tmp25_, "Size", &_inner_error_);
				_tmp23_ = _tmp26_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch5_g_error;
				}
				size = _tmp23_;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			GError* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			g_warning ("manager.vala:830: create_panel(): %s", _tmp28_);
			_g_error_free0 (e);
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		gint _tmp29_ = 0;
		BudgiePanelPosition _tmp30_ = 0;
		BudgiePanelPosition _tmp31_ = 0;
		_tmp29_ = self->priv->primary_monitor;
		_tmp30_ = budgie_panel_manager_get_first_position (self, _tmp29_);
		position = _tmp30_;
		_tmp31_ = position;
		if (_tmp31_ == BUDGIE_PANEL_POSITION_NONE) {
			g_critical ("manager.vala:835: No slots available, this should not happen");
			return;
		}
	}
	_tmp32_ = uuid_new (UUID_UUID_FLAGS_LOWER_CASE | UUID_UUID_FLAGS_TIME_SAFE_TYPE);
	uuid = _tmp32_;
	_tmp33_ = uuid;
	budgie_panel_manager_load_panel (self, _tmp33_, FALSE);
	budgie_panel_manager_set_panels (self);
	_tmp34_ = uuid;
	_tmp35_ = position;
	budgie_panel_manager_show_panel (self, _tmp34_, _tmp35_);
	_tmp37_ = new_defaults;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		const gchar* _tmp38_ = NULL;
		_tmp38_ = name;
		_tmp36_ = _tmp38_ == NULL;
	}
	if (_tmp36_) {
		_g_free0 (uuid);
		return;
	}
	_tmp39_ = size;
	if (_tmp39_ > 0) {
		const gchar* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		_tmp40_ = uuid;
		_tmp41_ = size;
		budgie_desktop_manager_set_size ((BudgieDesktopManager*) self, _tmp40_, _tmp41_);
	}
	_tmp42_ = self->priv->panels;
	_tmp43_ = uuid;
	_tmp44_ = g_hash_table_lookup (_tmp42_, _tmp43_);
	_tmp45_ = _g_object_ref0 ((BudgiePanel*) _tmp44_);
	panel = _tmp45_;
	_tmp46_ = panel;
	_tmp47_ = name;
	_tmp48_ = new_defaults;
	budgie_panel_create_default_layout (_tmp46_, _tmp47_, _tmp48_);
	_g_object_unref0 (panel);
	_g_free0 (uuid);
}


/**
     * Update our known panels
     */
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void budgie_panel_manager_set_panels (BudgiePanelManager* self) {
	BudgiePanel* panel = NULL;
	const gchar* key = NULL;
	gchar** keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	GSettings* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_if_fail (self != NULL);
	keys = NULL;
	keys_length1 = 0;
	_keys_size_ = keys_length1;
	_tmp0_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		panel = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = keys;
		_tmp4__length1 = keys_length1;
		_tmp5_ = key;
		_tmp6_ = g_strdup (_tmp5_);
		_vala_array_add1 (&keys, &keys_length1, &_keys_size_, _tmp6_);
	}
	_tmp7_ = self->priv->settings;
	_tmp8_ = keys;
	_tmp8__length1 = keys_length1;
	g_settings_set_strv (_tmp7_, BUDGIE_ROOT_KEY_PANELS, _tmp8_);
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * Create new default panel layout
     */
static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void budgie_panel_manager_create_default (BudgiePanelManager* self) {
	GFile* f = NULL;
	GKeyFile* config_file = NULL;
	GKeyFile* _tmp0_ = NULL;
	GString* builder = NULL;
	GString* _tmp1_ = NULL;
	gchar* line = NULL;
	BudgiePanelPosition pos = 0;
	gchar** system_configs = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint system_configs_length1 = 0;
	gint _system_configs_size_ = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	f = NULL;
	_tmp0_ = g_key_file_new ();
	config_file = _tmp0_;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	line = NULL;
	_tmp2_ = string_to_string (BUDGIE_CONFDIR);
	_tmp3_ = g_strconcat ("file://", _tmp2_, "/budgie-desktop/panel.ini", NULL);
	_tmp4_ = string_to_string (BUDGIE_DATADIR);
	_tmp5_ = g_strconcat ("file://", _tmp4_, "/budgie-desktop/panel.ini", NULL);
	_tmp6_ = g_strdup ("resource:///com/solus-project/budgie/panel/panel.ini");
	_tmp7_ = g_new0 (gchar*, 3 + 1);
	_tmp7_[0] = _tmp3_;
	_tmp7_[1] = _tmp5_;
	_tmp7_[2] = _tmp6_;
	system_configs = _tmp7_;
	system_configs_length1 = 3;
	_system_configs_size_ = system_configs_length1;
	_tmp8_ = system_configs;
	_tmp8__length1 = system_configs_length1;
	{
		gchar** filepath_collection = NULL;
		gint filepath_collection_length1 = 0;
		gint _filepath_collection_size_ = 0;
		gint filepath_it = 0;
		filepath_collection = _tmp8_;
		filepath_collection_length1 = _tmp8__length1;
		for (filepath_it = 0; filepath_it < _tmp8__length1; filepath_it = filepath_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* filepath = NULL;
			_tmp9_ = g_strdup (filepath_collection[filepath_it]);
			filepath = _tmp9_;
			{
				{
					const gchar* _tmp10_ = NULL;
					GFile* _tmp11_ = NULL;
					GFile* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					GFileInputStream* _tmp14_ = NULL;
					GFile* _tmp15_ = NULL;
					GFileInputStream* _tmp16_ = NULL;
					GDataInputStream* dis = NULL;
					GDataInputStream* _tmp17_ = NULL;
					GKeyFile* _tmp25_ = NULL;
					GString* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					GString* _tmp28_ = NULL;
					gssize _tmp29_ = 0L;
					_tmp10_ = filepath;
					_tmp11_ = g_file_new_for_uri (_tmp10_);
					_g_object_unref0 (f);
					f = _tmp11_;
					_tmp12_ = f;
					_tmp13_ = g_file_query_exists (_tmp12_, NULL);
					if (!_tmp13_) {
						_g_free0 (filepath);
						continue;
					}
					_tmp15_ = f;
					_tmp16_ = g_file_read (_tmp15_, NULL, &_inner_error_);
					_tmp14_ = _tmp16_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch6_g_error;
					}
					_tmp17_ = g_data_input_stream_new ((GInputStream*) _tmp14_);
					dis = _tmp17_;
					while (TRUE) {
						gchar* _tmp18_ = NULL;
						GDataInputStream* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
						GString* _tmp23_ = NULL;
						const gchar* _tmp24_ = NULL;
						_tmp19_ = dis;
						_tmp20_ = g_data_input_stream_read_line (_tmp19_, NULL, NULL, &_inner_error_);
						_tmp18_ = _tmp20_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_object_unref0 (dis);
							_g_object_unref0 (_tmp14_);
							goto __catch6_g_error;
						}
						_tmp21_ = _tmp18_;
						_tmp18_ = NULL;
						_g_free0 (line);
						line = _tmp21_;
						_tmp22_ = line;
						if (!(_tmp22_ != NULL)) {
							_g_free0 (_tmp18_);
							break;
						}
						_tmp23_ = builder;
						_tmp24_ = line;
						g_string_append_printf (_tmp23_, "%s\n", _tmp24_);
						_g_free0 (_tmp18_);
					}
					_tmp25_ = config_file;
					_tmp26_ = builder;
					_tmp27_ = _tmp26_->str;
					_tmp28_ = builder;
					_tmp29_ = _tmp28_->len;
					g_key_file_load_from_data (_tmp25_, _tmp27_, (gsize) _tmp29_, G_KEY_FILE_NONE, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (dis);
						_g_object_unref0 (_tmp14_);
						goto __catch6_g_error;
					}
					_g_object_unref0 (dis);
					_g_object_unref0 (_tmp14_);
					_g_free0 (filepath);
					break;
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					GError* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp30_ = e;
					_tmp31_ = _tmp30_->message;
					g_warning ("manager.vala:912: Failed to load default config: %s", _tmp31_);
					_g_error_free0 (e);
				}
				__finally6:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_free0 (filepath);
					system_configs = (_vala_array_free (system_configs, system_configs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					_g_string_free0 (builder);
					_g_key_file_unref0 (config_file);
					_g_object_unref0 (f);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (filepath);
			}
		}
	}
	{
		gboolean _tmp32_ = FALSE;
		GKeyFile* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		gchar** panels = NULL;
		GKeyFile* _tmp35_ = NULL;
		gsize _tmp36_;
		gchar** _tmp37_ = NULL;
		gint panels_length1 = 0;
		gint _panels_size_ = 0;
		gchar** _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		_tmp33_ = config_file;
		_tmp34_ = g_key_file_has_key (_tmp33_, "Panels", "Panels", &_inner_error_);
		_tmp32_ = _tmp34_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		if (!_tmp32_) {
			g_critical ("manager.vala:918: Config is missing required Panels section");
		}
		_tmp35_ = config_file;
		_tmp37_ = g_key_file_get_string_list (_tmp35_, "Panels", "Panels", &_tmp36_, &_inner_error_);
		panels = _tmp37_;
		panels_length1 = _tmp36_;
		_panels_size_ = panels_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp38_ = panels;
		_tmp38__length1 = panels_length1;
		{
			gchar** panel_collection = NULL;
			gint panel_collection_length1 = 0;
			gint _panel_collection_size_ = 0;
			gint panel_it = 0;
			panel_collection = _tmp38_;
			panel_collection_length1 = _tmp38__length1;
			for (panel_it = 0; panel_it < _tmp38__length1; panel_it = panel_it + 1) {
				gchar* _tmp39_ = NULL;
				gchar* panel = NULL;
				_tmp39_ = g_strdup (panel_collection[panel_it]);
				panel = _tmp39_;
				{
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					GKeyFile* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					gboolean _tmp44_ = FALSE;
					const gchar* _tmp46_ = NULL;
					GKeyFile* _tmp47_ = NULL;
					_tmp40_ = panel;
					_tmp41_ = string_strip (_tmp40_);
					_g_free0 (panel);
					panel = _tmp41_;
					pos = BUDGIE_PANEL_POSITION_TOP;
					_tmp42_ = config_file;
					_tmp43_ = panel;
					_tmp44_ = g_key_file_has_group (_tmp42_, _tmp43_);
					if (!_tmp44_) {
						const gchar* _tmp45_ = NULL;
						_tmp45_ = panel;
						g_warning ("manager.vala:928: Missing Panel config: %s", _tmp45_);
						_g_free0 (panel);
						continue;
					}
					_tmp46_ = panel;
					_tmp47_ = config_file;
					budgie_panel_manager_create_panel (self, _tmp46_, _tmp47_);
					_g_free0 (panel);
				}
			}
		}
		panels = (_vala_array_free (panels, panels_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("manager.vala:934: Error configuring panels!");
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		system_configs = (_vala_array_free (system_configs, system_configs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
		_g_string_free0 (builder);
		_g_key_file_unref0 (config_file);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	system_configs = (_vala_array_free (system_configs, system_configs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (line);
	_g_string_free0 (builder);
	_g_key_file_unref0 (config_file);
	_g_object_unref0 (f);
}


static void budgie_panel_manager_on_name_lost (BudgiePanelManager* self, GDBusConnection* conn, const gchar* name) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->setup;
	if (_tmp0_) {
		g_message ("manager.vala:942: Replaced existing budgie-panel");
	} else {
		g_message ("manager.vala:944: Another panel is already running. Use --replace to r" \
"eplace it");
	}
	gtk_main_quit ();
}


static void _budgie_panel_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_panel_manager_on_bus_acquired ((BudgiePanelManager*) self, connection);
}


static void _budgie_panel_manager_on_name_acquired_gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_panel_manager_on_name_acquired ((BudgiePanelManager*) self, connection, name);
}


static void _budgie_panel_manager_on_name_lost_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_panel_manager_on_name_lost ((BudgiePanelManager*) self, connection, name);
}


void budgie_panel_manager_serve (BudgiePanelManager* self, gboolean replace) {
	GBusNameOwnerFlags flags = 0;
	gboolean _tmp0_ = FALSE;
	GBusNameOwnerFlags _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	_tmp0_ = replace;
	if (_tmp0_) {
		GBusNameOwnerFlags _tmp1_ = 0;
		_tmp1_ = flags;
		flags = _tmp1_ | G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	_tmp2_ = flags;
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_DBUS_NAME, _tmp2_, (GClosure*) ((_budgie_panel_manager_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_panel_manager_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((_budgie_panel_manager_on_name_acquired_gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_panel_manager_on_name_acquired_gbus_name_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((_budgie_panel_manager_on_name_lost_gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_panel_manager_on_name_lost_gbus_name_lost_callback, g_object_ref (self), g_object_unref)));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GList* budgie_panel_manager_real_get_panels (BudgieDesktopManager* base) {
	BudgiePanelManager * self;
	GList* result = NULL;
	GList* list = NULL;
	const gchar* key = NULL;
	BudgiePanel* panel = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp0_ = NULL;
	self = (BudgiePanelManager*) base;
	list = NULL;
	_tmp0_ = self->priv->panels;
	g_hash_table_iter_init (&iter, _tmp0_);
	while (TRUE) {
		gconstpointer _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		BudgiePanel* _tmp4_ = NULL;
		BudgieToplevel* _tmp5_ = NULL;
		_tmp3_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp1_), (gpointer*) (&_tmp2_));
		key = _tmp1_;
		panel = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = panel;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel));
		list = g_list_append (list, _tmp5_);
	}
	result = list;
	return result;
}


static void budgie_panel_manager_class_init (BudgiePanelManagerClass * klass) {
	budgie_panel_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgiePanelManagerPrivate));
	((BudgieDesktopManagerClass *) klass)->get_panel_plugins = budgie_panel_manager_real_get_panel_plugins;
	((BudgieDesktopManagerClass *) klass)->slots_available = budgie_panel_manager_real_slots_available;
	((BudgieDesktopManagerClass *) klass)->slots_used = budgie_panel_manager_real_slots_used;
	((BudgieDesktopManagerClass *) klass)->set_size = budgie_panel_manager_real_set_size;
	((BudgieDesktopManagerClass *) klass)->set_placement = budgie_panel_manager_real_set_placement;
	((BudgieDesktopManagerClass *) klass)->create_new_panel = budgie_panel_manager_real_create_new_panel;
	((BudgieDesktopManagerClass *) klass)->delete_panel = budgie_panel_manager_real_delete_panel;
	((BudgieDesktopManagerClass *) klass)->get_panels = budgie_panel_manager_real_get_panels;
	G_OBJECT_CLASS (klass)->finalize = budgie_panel_manager_finalize;
	/**
	     * Indicate that a plugin that was being waited for, is now available
	     */
	g_signal_new ("extension_loaded", BUDGIE_TYPE_PANEL_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void budgie_panel_manager_instance_init (BudgiePanelManager * self) {
	self->priv = BUDGIE_PANEL_MANAGER_GET_PRIVATE (self);
	self->priv->setup = FALSE;
	self->priv->reset = FALSE;
	self->priv->primary_monitor = 0;
	self->priv->raven = NULL;
	self->priv->migrate_load_requirements_met = FALSE;
}


static void budgie_panel_manager_finalize (GObject* obj) {
	BudgiePanelManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL_MANAGER, BudgiePanelManager);
	_budgie_panel_manager_iface_unref0 (self->priv->iface);
	_g_object_unref0 (self->priv->sclient);
	_g_hash_table_unref0 (self->priv->screens);
	_g_hash_table_unref0 (self->priv->panels);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->extensions);
	_g_hash_table_unref0 (self->priv->plugins);
	_g_object_unref0 (self->priv->raven);
	_g_object_unref0 (self->priv->theme_manager);
	G_OBJECT_CLASS (budgie_panel_manager_parent_class)->finalize (obj);
}


GType budgie_panel_manager_get_type (void) {
	static volatile gsize budgie_panel_manager_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_panel_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePanelManager), 0, (GInstanceInitFunc) budgie_panel_manager_instance_init, NULL };
		GType budgie_panel_manager_type_id;
		budgie_panel_manager_type_id = g_type_register_static (BUDGIE_TYPE_DESKTOP_MANAGER, "BudgiePanelManager", &g_define_type_info, 0);
		g_once_init_leave (&budgie_panel_manager_type_id__volatile, budgie_panel_manager_type_id);
	}
	return budgie_panel_manager_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



