/* ibus.c generated by valac 0.32.1, the Vala compiler
 * generated from ibus.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2016 Ikey Doherty <ikey@solus-project.com>
 * Copyright (C) GNOME Shell Developers (Heavy inspiration, logic theft)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define BUDGIE_TYPE_IBUS_MANAGER (budgie_ibus_manager_get_type ())
#define BUDGIE_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager))
#define BUDGIE_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerClass))
#define BUDGIE_IS_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_IBUS_MANAGER))
#define BUDGIE_IS_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_IBUS_MANAGER))
#define BUDGIE_IBUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerClass))

typedef struct _BudgieIBusManager BudgieIBusManager;
typedef struct _BudgieIBusManagerClass BudgieIBusManagerClass;
typedef struct _BudgieIBusManagerPrivate BudgieIBusManagerPrivate;

#define BUDGIE_TYPE_KEYBOARD_MANAGER (budgie_keyboard_manager_get_type ())
#define BUDGIE_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager))
#define BUDGIE_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))
#define BUDGIE_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))

typedef struct _BudgieKeyboardManager BudgieKeyboardManager;
typedef struct _BudgieKeyboardManagerClass BudgieKeyboardManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _BudgieIBusManager {
	GObject parent_instance;
	BudgieIBusManagerPrivate * priv;
};

struct _BudgieIBusManagerClass {
	GObjectClass parent_class;
};

struct _BudgieIBusManagerPrivate {
	IBusBus* bus;
	gboolean ibus_available;
	GHashTable* engines;
	BudgieKeyboardManager* _kbm;
	gboolean did_ibus_init;
};


static gpointer budgie_ibus_manager_parent_class = NULL;

GType budgie_ibus_manager_get_type (void) G_GNUC_CONST;
GType budgie_keyboard_manager_get_type (void) G_GNUC_CONST;
#define BUDGIE_IBUS_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerPrivate))
enum  {
	BUDGIE_IBUS_MANAGER_DUMMY_PROPERTY,
	BUDGIE_IBUS_MANAGER_KBM
};
#define BUDGIE_IBUS_MANAGER_ENGINE_SET_TIMEOUT 4000
BudgieIBusManager* budgie_ibus_manager_new (BudgieKeyboardManager* kbm);
BudgieIBusManager* budgie_ibus_manager_construct (GType object_type, BudgieKeyboardManager* kbm);
void budgie_ibus_manager_do_init (BudgieIBusManager* self);
static void _g_free0_ (gpointer var);
static void budgie_ibus_manager_ibus_connected (BudgieIBusManager* self);
static void _budgie_ibus_manager_ibus_connected_ibus_bus_connected (IBusBus* _sender, gpointer self);
static void budgie_ibus_manager_ibus_disconnected (BudgieIBusManager* self);
static void _budgie_ibus_manager_ibus_disconnected_ibus_bus_disconnected (IBusBus* _sender, gpointer self);
static void budgie_ibus_manager_startup_ibus (BudgieIBusManager* self);
static void budgie_ibus_manager_reset_ibus (BudgieIBusManager* self);
static void budgie_ibus_manager_on_engines_get (BudgieIBusManager* self, GObject* o, GAsyncResult* res);
static void _budgie_ibus_manager_on_engines_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
IBusEngineDesc* budgie_ibus_manager_get_engine (BudgieIBusManager* self, const gchar* name);
void budgie_ibus_manager_set_engine (BudgieIBusManager* self, const gchar* name);
BudgieKeyboardManager* budgie_ibus_manager_get_kbm (BudgieIBusManager* self);
void budgie_keyboard_manager_release_keyboard (BudgieKeyboardManager* self);
static void __lambda8_ (BudgieIBusManager* self);
static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void budgie_ibus_manager_set_kbm (BudgieIBusManager* self, BudgieKeyboardManager* value);
static void budgie_ibus_manager_finalize (GObject* obj);
static void _vala_budgie_ibus_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_ibus_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Construct a new IBusManager which will begin setting up the
     * ibus daemon, as well as registering events to connect to it
     * and monitor it.
     */
BudgieIBusManager* budgie_ibus_manager_construct (GType object_type, BudgieKeyboardManager* kbm) {
	BudgieIBusManager * self = NULL;
	BudgieKeyboardManager* _tmp0_ = NULL;
	_tmp0_ = kbm;
	self = (BudgieIBusManager*) g_object_new (object_type, "kbm", _tmp0_, NULL);
	return self;
}


BudgieIBusManager* budgie_ibus_manager_new (BudgieKeyboardManager* kbm) {
	return budgie_ibus_manager_construct (BUDGIE_TYPE_IBUS_MANAGER, kbm);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _budgie_ibus_manager_ibus_connected_ibus_bus_connected (IBusBus* _sender, gpointer self) {
	budgie_ibus_manager_ibus_connected ((BudgieIBusManager*) self);
}


static void _budgie_ibus_manager_ibus_disconnected_ibus_bus_disconnected (IBusBus* _sender, gpointer self) {
	budgie_ibus_manager_ibus_disconnected ((BudgieIBusManager*) self);
}


void budgie_ibus_manager_do_init (BudgieIBusManager* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	IBusBus* _tmp6_ = NULL;
	IBusBus* _tmp7_ = NULL;
	IBusBus* _tmp8_ = NULL;
	IBusBus* _tmp9_ = NULL;
	IBusBus* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_find_program_in_path ("ibus-daemon");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		g_message ("ibus.vala:51: ibus-daemon unsupported on this system");
		self->priv->ibus_available = FALSE;
		g_signal_emit_by_name (self, "ready");
		return;
	}
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->engines);
	self->priv->engines = _tmp5_;
	_tmp6_ = ibus_bus_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->bus);
	self->priv->bus = _tmp6_;
	_tmp7_ = self->priv->bus;
	g_signal_connect_object (_tmp7_, "connected", (GCallback) _budgie_ibus_manager_ibus_connected_ibus_bus_connected, self, 0);
	_tmp8_ = self->priv->bus;
	g_signal_connect_object (_tmp8_, "disconnected", (GCallback) _budgie_ibus_manager_ibus_disconnected_ibus_bus_disconnected, self, 0);
	_tmp9_ = self->priv->bus;
	ibus_bus_set_watch_dbus_signal (_tmp9_, TRUE);
	_tmp10_ = self->priv->bus;
	_tmp11_ = ibus_bus_is_connected (_tmp10_);
	if (_tmp11_) {
		budgie_ibus_manager_ibus_connected (self);
	} else {
		budgie_ibus_manager_startup_ibus (self);
	}
}


/**
     * Launch the daemon as a child process so that it dies when we die
     */
static void budgie_ibus_manager_startup_ibus (BudgieIBusManager* self) {
	gchar** cmdline = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint cmdline_length1 = 0;
	gint _cmdline_size_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("ibus-daemon");
	_tmp1_ = g_strdup ("--xim");
	_tmp2_ = g_strdup ("--panel");
	_tmp3_ = g_strdup ("disable");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	cmdline = _tmp4_;
	cmdline_length1 = 4;
	_cmdline_size_ = cmdline_length1;
	{
		GSubprocess* _tmp5_ = NULL;
		GSubprocess* _tmp6_ = NULL;
		_tmp5_ = g_subprocess_newv (cmdline, G_SUBPROCESS_FLAGS_NONE, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_message ("ibus.vala:85: Failed to launch ibus: %s", _tmp8_);
		self->priv->ibus_available = FALSE;
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		cmdline = (_vala_array_free (cmdline, cmdline_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	cmdline = (_vala_array_free (cmdline, cmdline_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * Something on ibus changed so we'll reset our state
     */
static void budgie_ibus_manager_reset_ibus (BudgieIBusManager* self) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->engines);
	self->priv->engines = _tmp2_;
}


static void budgie_ibus_manager_on_engines_get (BudgieIBusManager* self, GObject* o, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* engines = NULL;
		IBusBus* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		_tmp0_ = self->priv->bus;
		_tmp1_ = res;
		_tmp2_ = ibus_bus_list_engines_async_finish (_tmp0_, _tmp1_, &_inner_error_);
		engines = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		budgie_ibus_manager_reset_ibus (self);
		_tmp3_ = engines;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp3_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* engine = NULL;
				engine = (IBusEngineDesc*) engine_it->data;
				{
					GHashTable* _tmp4_ = NULL;
					IBusEngineDesc* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					gchar* _tmp7_ = NULL;
					IBusEngineDesc* _tmp8_ = NULL;
					_tmp4_ = self->priv->engines;
					_tmp5_ = engine;
					_tmp6_ = ibus_engine_desc_get_name (_tmp5_);
					_tmp7_ = g_strdup (_tmp6_);
					_tmp8_ = engine;
					g_hash_table_insert (_tmp4_, _tmp7_, _tmp8_);
				}
			}
		}
		_g_list_free0 (engines);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_message ("ibus.vala:108: Failed to get engines: %s", _tmp10_);
		budgie_ibus_manager_reset_ibus (self);
		_g_error_free0 (e);
		return;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_signal_emit_by_name (self, "ready");
}


/**
     * We gained connection to the ibus daemon
     */
static void _budgie_ibus_manager_on_engines_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	budgie_ibus_manager_on_engines_get ((BudgieIBusManager*) self, source_object, res);
	g_object_unref (self);
}


static void budgie_ibus_manager_ibus_connected (BudgieIBusManager* self) {
	gboolean _tmp0_ = FALSE;
	IBusBus* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->did_ibus_init;
	if (!_tmp0_) {
		ibus_init ();
		self->priv->did_ibus_init = TRUE;
	}
	_tmp1_ = self->priv->bus;
	ibus_bus_list_engines_async (_tmp1_, -1, NULL, _budgie_ibus_manager_on_engines_get_gasync_ready_callback, g_object_ref (self));
}


/**
     * Lost connection to ibus
     */
static void budgie_ibus_manager_ibus_disconnected (BudgieIBusManager* self) {
	g_return_if_fail (self != NULL);
	budgie_ibus_manager_reset_ibus (self);
}


/**
     * Attempt to grab the ibus engine for the given name if it
     * exists, or returns null
     */
IBusEngineDesc* budgie_ibus_manager_get_engine (BudgieIBusManager* self, const gchar* name) {
	IBusEngineDesc* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->engines;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	result = (IBusEngineDesc*) _tmp2_;
	return result;
}


/**
     * Set the ibus engine to the specified engine name
     */
static void __lambda8_ (BudgieIBusManager* self) {
	BudgieKeyboardManager* _tmp0_ = NULL;
	_tmp0_ = self->priv->_kbm;
	budgie_keyboard_manager_release_keyboard (_tmp0_);
}


static void ___lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda8_ ((BudgieIBusManager*) self);
	g_object_unref (self);
}


void budgie_ibus_manager_set_engine (BudgieIBusManager* self, const gchar* name) {
	gboolean _tmp0_ = FALSE;
	IBusBus* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->ibus_available;
	if (!_tmp0_) {
		BudgieKeyboardManager* _tmp1_ = NULL;
		_tmp1_ = self->priv->_kbm;
		budgie_keyboard_manager_release_keyboard (_tmp1_);
		return;
	}
	_tmp2_ = self->priv->bus;
	_tmp3_ = name;
	ibus_bus_set_global_engine_async (_tmp2_, _tmp3_, BUDGIE_IBUS_MANAGER_ENGINE_SET_TIMEOUT, NULL, ___lambda8__gasync_ready_callback, g_object_ref (self));
}


BudgieKeyboardManager* budgie_ibus_manager_get_kbm (BudgieIBusManager* self) {
	BudgieKeyboardManager* result;
	BudgieKeyboardManager* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_kbm;
	result = _tmp0_;
	return result;
}


void budgie_ibus_manager_set_kbm (BudgieIBusManager* self, BudgieKeyboardManager* value) {
	BudgieKeyboardManager* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_kbm = _tmp0_;
	g_object_notify ((GObject *) self, "kbm");
}


static void budgie_ibus_manager_class_init (BudgieIBusManagerClass * klass) {
	budgie_ibus_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieIBusManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_ibus_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_ibus_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_ibus_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_IBUS_MANAGER_KBM, g_param_spec_object ("kbm", "kbm", "kbm", BUDGIE_TYPE_KEYBOARD_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * Ensure that owning process knows we're up and running
	     */
	g_signal_new ("ready", BUDGIE_TYPE_IBUS_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void budgie_ibus_manager_instance_init (BudgieIBusManager * self) {
	self->priv = BUDGIE_IBUS_MANAGER_GET_PRIVATE (self);
	self->priv->bus = NULL;
	self->priv->ibus_available = TRUE;
	self->priv->engines = NULL;
	self->priv->did_ibus_init = FALSE;
}


static void budgie_ibus_manager_finalize (GObject* obj) {
	BudgieIBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager);
	_g_object_unref0 (self->priv->bus);
	_g_hash_table_unref0 (self->priv->engines);
	G_OBJECT_CLASS (budgie_ibus_manager_parent_class)->finalize (obj);
}


/**
 * IBusManager is responsible for interfacing with the ibus daemon
 * under Budgie Desktop, enabling extra input sources to be used
 * when using the ibus XIM daemon
 */
GType budgie_ibus_manager_get_type (void) {
	static volatile gsize budgie_ibus_manager_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_ibus_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieIBusManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_ibus_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieIBusManager), 0, (GInstanceInitFunc) budgie_ibus_manager_instance_init, NULL };
		GType budgie_ibus_manager_type_id;
		budgie_ibus_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieIBusManager", &g_define_type_info, 0);
		g_once_init_leave (&budgie_ibus_manager_type_id__volatile, budgie_ibus_manager_type_id);
	}
	return budgie_ibus_manager_type_id__volatile;
}


static void _vala_budgie_ibus_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieIBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager);
	switch (property_id) {
		case BUDGIE_IBUS_MANAGER_KBM:
		g_value_set_object (value, budgie_ibus_manager_get_kbm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_ibus_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieIBusManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager);
	switch (property_id) {
		case BUDGIE_IBUS_MANAGER_KBM:
		budgie_ibus_manager_set_kbm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



