/* UserIndicatorWindow.c generated by valac 0.32.1, the Vala compiler
 * generated from UserIndicatorWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2015-2016 Solus Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_USER_INDICATOR_WINDOW (user_indicator_window_get_type ())
#define USER_INDICATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INDICATOR_WINDOW, UserIndicatorWindow))
#define USER_INDICATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INDICATOR_WINDOW, UserIndicatorWindowClass))
#define IS_USER_INDICATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INDICATOR_WINDOW))
#define IS_USER_INDICATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INDICATOR_WINDOW))
#define USER_INDICATOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INDICATOR_WINDOW, UserIndicatorWindowClass))

typedef struct _UserIndicatorWindow UserIndicatorWindow;
typedef struct _UserIndicatorWindowClass UserIndicatorWindowClass;
typedef struct _UserIndicatorWindowPrivate UserIndicatorWindowPrivate;

#define TYPE_SCREEN_SAVER (screen_saver_get_type ())
#define SCREEN_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCREEN_SAVER, ScreenSaver))
#define IS_SCREEN_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCREEN_SAVER))
#define SCREEN_SAVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SCREEN_SAVER, ScreenSaverIface))

typedef struct _ScreenSaver ScreenSaver;
typedef struct _ScreenSaverIface ScreenSaverIface;

#define TYPE_SCREEN_SAVER_PROXY (screen_saver_proxy_get_type ())

#define TYPE_SESSION_MANAGER (session_manager_get_type ())
#define SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_MANAGER, SessionManager))
#define IS_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_MANAGER))
#define SESSION_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_SESSION_MANAGER, SessionManagerIface))

typedef struct _SessionManager SessionManager;
typedef struct _SessionManagerIface SessionManagerIface;

#define TYPE_SESSION_MANAGER_PROXY (session_manager_proxy_get_type ())

#define TYPE_LOGIND_INTERFACE (logind_interface_get_type ())
#define LOGIND_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGIND_INTERFACE, LogindInterface))
#define IS_LOGIND_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGIND_INTERFACE))
#define LOGIND_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LOGIND_INTERFACE, LogindInterfaceIface))

typedef struct _LogindInterface LogindInterface;
typedef struct _LogindInterfaceIface LogindInterfaceIface;

#define TYPE_LOGIND_INTERFACE_PROXY (logind_interface_proxy_get_type ())

#define TYPE_ACCOUNTS_INTERFACE (accounts_interface_get_type ())
#define ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterface))
#define IS_ACCOUNTS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNTS_INTERFACE))
#define ACCOUNTS_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNTS_INTERFACE, AccountsInterfaceIface))

typedef struct _AccountsInterface AccountsInterface;
typedef struct _AccountsInterfaceIface AccountsInterfaceIface;

#define TYPE_ACCOUNTS_INTERFACE_PROXY (accounts_interface_proxy_get_type ())

#define TYPE_ACCOUNT_USER_INTERFACE (account_user_interface_get_type ())
#define ACCOUNT_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_USER_INTERFACE, AccountUserInterface))
#define IS_ACCOUNT_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_USER_INTERFACE))
#define ACCOUNT_USER_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNT_USER_INTERFACE, AccountUserInterfaceIface))

typedef struct _AccountUserInterface AccountUserInterface;
typedef struct _AccountUserInterfaceIface AccountUserInterfaceIface;

#define TYPE_ACCOUNT_USER_INTERFACE_PROXY (account_user_interface_proxy_get_type ())

#define TYPE_PROPERTIES_INTERFACE (properties_interface_get_type ())
#define PROPERTIES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES_INTERFACE, PropertiesInterface))
#define IS_PROPERTIES_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES_INTERFACE))
#define PROPERTIES_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROPERTIES_INTERFACE, PropertiesInterfaceIface))

typedef struct _PropertiesInterface PropertiesInterface;
typedef struct _PropertiesInterfaceIface PropertiesInterfaceIface;

#define TYPE_PROPERTIES_INTERFACE_PROXY (properties_interface_proxy_get_type ())

#define TYPE_INDICATOR_ITEM (indicator_item_get_type ())
#define INDICATOR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR_ITEM, IndicatorItem))
#define INDICATOR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR_ITEM, IndicatorItemClass))
#define IS_INDICATOR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR_ITEM))
#define IS_INDICATOR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR_ITEM))
#define INDICATOR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR_ITEM, IndicatorItemClass))

typedef struct _IndicatorItem IndicatorItem;
typedef struct _IndicatorItemClass IndicatorItemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UserIndicatorWindowSetupDbusData UserIndicatorWindowSetupDbusData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _IndicatorItemPrivate IndicatorItemPrivate;

struct _UserIndicatorWindow {
	GtkPopover parent_instance;
	UserIndicatorWindowPrivate * priv;
	GtkBox* menu;
	GtkRevealer* user_section;
};

struct _UserIndicatorWindowClass {
	GtkPopoverClass parent_class;
};

struct _ScreenSaverIface {
	GTypeInterface parent_iface;
	void (*lock) (ScreenSaver* self, GError** error);
};

struct _SessionManagerIface {
	GTypeInterface parent_iface;
	void (*Logout) (SessionManager* self, guint mode, GError** error);
	void (*Reboot) (SessionManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Reboot_finish) (SessionManager* self, GAsyncResult* _res_, GError** error);
	void (*Shutdown) (SessionManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Shutdown_finish) (SessionManager* self, GAsyncResult* _res_, GError** error);
};

struct _LogindInterfaceIface {
	GTypeInterface parent_iface;
	void (*suspend) (LogindInterface* self, gboolean interactive, GError** error);
	void (*hibernate) (LogindInterface* self, gboolean interactive, GError** error);
};

struct _AccountsInterfaceIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (AccountsInterface* self, const gchar* username, GError** error);
};

struct _AccountUserInterfaceIface {
	GTypeInterface parent_iface;
};

struct _PropertiesInterfaceIface {
	GTypeInterface parent_iface;
	GVariant* (*get) (PropertiesInterface* self, const gchar* interface, const gchar* property, GError** error);
};

struct _UserIndicatorWindowPrivate {
	ScreenSaver* saver;
	SessionManager* session;
	LogindInterface* logind_interface;
	AccountsInterface* user_manager;
	AccountUserInterface* current_user;
	gchar* current_username;
	PropertiesInterface* current_user_props;
	IndicatorItem* user_item;
};

struct _UserIndicatorWindowSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UserIndicatorWindow* self;
	gchar* path;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	AccountsInterface* _tmp2_;
	AccountsInterface* _tmp3_;
	AccountsInterface* _tmp4_;
	gchar* uid;
	AccountsInterface* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	PropertiesInterface* _tmp8_;
	const gchar* _tmp9_;
	PropertiesInterface* _tmp10_;
	PropertiesInterface* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	AccountUserInterface* _tmp14_;
	const gchar* _tmp15_;
	AccountUserInterface* _tmp16_;
	AccountUserInterface* _tmp17_;
	AccountUserInterface* _tmp18_;
	GError* _vala1_e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _vala2_e;
	GError* _tmp21_;
	const gchar* _tmp22_;
	LogindInterface* _tmp23_;
	LogindInterface* _tmp24_;
	LogindInterface* _tmp25_;
	GError* _vala3_e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	ScreenSaver* _tmp28_;
	ScreenSaver* _tmp29_;
	ScreenSaver* _tmp30_;
	GError* _vala4_e;
	GError* _tmp31_;
	const gchar* _tmp32_;
	SessionManager* _tmp33_;
	SessionManager* _tmp34_;
	SessionManager* _tmp35_;
	GError* _vala5_e;
	GError* _tmp36_;
	const gchar* _tmp37_;
	GError * _inner_error_;
};

struct _IndicatorItem {
	GtkButton parent_instance;
	IndicatorItemPrivate * priv;
};

struct _IndicatorItemClass {
	GtkButtonClass parent_class;
};

struct _IndicatorItemPrivate {
	GtkBox* menu_item;
	GtkImage* arrow;
	GtkImage* button_image;
	GtkLabel* button_label;
	gchar* _image_source;
	gchar* _label_text;
};


static gpointer user_indicator_window_parent_class = NULL;
static GType user_indicator_window_type_id = 0;
static gpointer indicator_item_parent_class = NULL;
static GType indicator_item_type_id = 0;

#define ACCOUNTSSERVICE_ACC "org.freedesktop.Accounts"
#define ACCOUNTSSERVICE_USER "org.freedesktop.Accounts.User"
#define LOGIND_LOGIN "org.freedesktop.login1"
#define G_SESSION "org.gnome.SessionManager"
#define UNABLE_CONTACT "Unable to contact "
GType user_indicator_window_get_type (void) G_GNUC_CONST;
GType user_indicator_window_register_type (GTypeModule * module);
GType screen_saver_proxy_get_type (void) G_GNUC_CONST;
void screen_saver_proxy_register_dynamic_type (GTypeModule* module);
guint screen_saver_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType screen_saver_get_type (void) G_GNUC_CONST;
GType screen_saver_register_type (GTypeModule * module);
GType session_manager_proxy_get_type (void) G_GNUC_CONST;
void session_manager_proxy_register_dynamic_type (GTypeModule* module);
guint session_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType session_manager_get_type (void) G_GNUC_CONST;
GType session_manager_register_type (GTypeModule * module);
GType logind_interface_proxy_get_type (void) G_GNUC_CONST;
void logind_interface_proxy_register_dynamic_type (GTypeModule* module);
guint logind_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType logind_interface_get_type (void) G_GNUC_CONST;
GType logind_interface_register_type (GTypeModule * module);
GType accounts_interface_proxy_get_type (void) G_GNUC_CONST;
void accounts_interface_proxy_register_dynamic_type (GTypeModule* module);
guint accounts_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType accounts_interface_get_type (void) G_GNUC_CONST;
GType accounts_interface_register_type (GTypeModule * module);
GType account_user_interface_get_type (void) G_GNUC_CONST;
GType account_user_interface_register_type (GTypeModule * module);
GType account_user_interface_proxy_get_type (void) G_GNUC_CONST;
void account_user_interface_proxy_register_dynamic_type (GTypeModule* module);
guint account_user_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType properties_interface_proxy_get_type (void) G_GNUC_CONST;
void properties_interface_proxy_register_dynamic_type (GTypeModule* module);
guint properties_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType properties_interface_get_type (void) G_GNUC_CONST;
GType properties_interface_register_type (GTypeModule * module);
GType indicator_item_get_type (void) G_GNUC_CONST;
GType indicator_item_register_type (GTypeModule * module);
#define USER_INDICATOR_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_INDICATOR_WINDOW, UserIndicatorWindowPrivate))
enum  {
	USER_INDICATOR_WINDOW_DUMMY_PROPERTY
};
static void user_indicator_window_setup_dbus_data_free (gpointer _data);
static void user_indicator_window_setup_dbus (UserIndicatorWindow* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void user_indicator_window_setup_dbus_finish (UserIndicatorWindow* self, GAsyncResult* _res_);
static gboolean user_indicator_window_setup_dbus_co (UserIndicatorWindowSetupDbusData* _data_);
static void user_indicator_window_setup_dbus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* accounts_interface_find_user_by_name (AccountsInterface* self, const gchar* username, GError** error);
static void user_indicator_window_update_userinfo (UserIndicatorWindow* self);
static void _user_indicator_window_update_userinfo_account_user_interface_changed (AccountUserInterface* _sender, gpointer self);
UserIndicatorWindow* user_indicator_window_new (GtkWidget* window_parent);
UserIndicatorWindow* user_indicator_window_construct (GType object_type, GtkWidget* window_parent);
#define USER_SYMBOLIC_ICON "system-shutdown-symbolic"
IndicatorItem* indicator_item_new (const gchar* label_string, const gchar* image_source, gboolean* add_arrow);
IndicatorItem* indicator_item_construct (GType object_type, const gchar* label_string, const gchar* image_source, gboolean* add_arrow);
static GtkRevealer* user_indicator_window_create_usersection (UserIndicatorWindow* self);
static gboolean __lambda6_ (UserIndicatorWindow* self, GdkEventButton* e);
void user_indicator_window_toggle_usersection (UserIndicatorWindow* self);
static gboolean ___lambda6__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda7_ (UserIndicatorWindow* self, GdkEventButton* e);
static void user_indicator_window_lock_screen (UserIndicatorWindow* self);
static gboolean ___lambda7__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda9_ (UserIndicatorWindow* self, GdkEventButton* e);
static void user_indicator_window_suspend (UserIndicatorWindow* self);
static gboolean ___lambda9__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda11_ (UserIndicatorWindow* self, GdkEventButton* e);
static void user_indicator_window_reboot (UserIndicatorWindow* self);
static gboolean ___lambda11__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda13_ (UserIndicatorWindow* self, GdkEventButton* e);
static void user_indicator_window_hibernate (UserIndicatorWindow* self);
static gboolean ___lambda13__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda15_ (UserIndicatorWindow* self, GdkEventButton* e);
static void user_indicator_window_shutdown (UserIndicatorWindow* self);
static gboolean ___lambda15__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void user_indicator_window_hide_usersection (UserIndicatorWindow* self);
static void _user_indicator_window_hide_usersection_gtk_popover_closed (GtkPopover* _sender, gpointer self);
static gboolean __lambda4_ (UserIndicatorWindow* self, GdkEventButton* e);
static void user_indicator_window_logout (UserIndicatorWindow* self);
static gboolean ___lambda4__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void user_indicator_window_show_usersection (UserIndicatorWindow* self);
void indicator_item_set_arrow (IndicatorItem* self, const gchar* direction);
static gchar* user_indicator_window_get_user_image (UserIndicatorWindow* self);
static gchar* user_indicator_window_get_user_name (UserIndicatorWindow* self);
void indicator_item_set_image (IndicatorItem* self, const gchar* source);
void indicator_item_set_label (IndicatorItem* self, const gchar* text);
GVariant* properties_interface_get (PropertiesInterface* self, const gchar* interface, const gchar* property, GError** error);
static gboolean __lambda5_ (UserIndicatorWindow* self);
void session_manager_Logout (SessionManager* self, guint mode, GError** error);
static gboolean ___lambda5__gsource_func (gpointer self);
static gboolean __lambda14_ (UserIndicatorWindow* self);
void logind_interface_hibernate (LogindInterface* self, gboolean interactive, GError** error);
static gboolean ___lambda14__gsource_func (gpointer self);
static gboolean __lambda12_ (UserIndicatorWindow* self);
void session_manager_Reboot (SessionManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void session_manager_Reboot_finish (SessionManager* self, GAsyncResult* _res_, GError** error);
static gboolean ___lambda12__gsource_func (gpointer self);
static gboolean __lambda16_ (UserIndicatorWindow* self);
void session_manager_Shutdown (SessionManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void session_manager_Shutdown_finish (SessionManager* self, GAsyncResult* _res_, GError** error);
static gboolean ___lambda16__gsource_func (gpointer self);
static gboolean __lambda10_ (UserIndicatorWindow* self);
void logind_interface_suspend (LogindInterface* self, gboolean interactive, GError** error);
static gboolean ___lambda10__gsource_func (gpointer self);
static gboolean __lambda8_ (UserIndicatorWindow* self);
void screen_saver_lock (ScreenSaver* self, GError** error);
static gboolean ___lambda8__gsource_func (gpointer self);
static void user_indicator_window_finalize (GObject* obj);
#define INDICATOR_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INDICATOR_ITEM, IndicatorItemPrivate))
enum  {
	INDICATOR_ITEM_DUMMY_PROPERTY,
	INDICATOR_ITEM_IMAGE_SOURCE,
	INDICATOR_ITEM_LABEL_TEXT
};
const gchar* indicator_item_get_image_source (IndicatorItem* self);
void indicator_item_set_image_source (IndicatorItem* self, const gchar* value);
const gchar* indicator_item_get_label_text (IndicatorItem* self);
void indicator_item_set_label_text (IndicatorItem* self, const gchar* value);
static void indicator_item_finalize (GObject* obj);
static void _vala_indicator_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_indicator_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void user_indicator_window_setup_dbus_data_free (gpointer _data) {
	UserIndicatorWindowSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UserIndicatorWindowSetupDbusData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void user_indicator_window_setup_dbus (UserIndicatorWindow* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserIndicatorWindowSetupDbusData* _data_;
	UserIndicatorWindow* _tmp0_ = NULL;
	_data_ = g_slice_new0 (UserIndicatorWindowSetupDbusData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, user_indicator_window_setup_dbus);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, user_indicator_window_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	user_indicator_window_setup_dbus_co (_data_);
}


static void user_indicator_window_setup_dbus_finish (UserIndicatorWindow* self, GAsyncResult* _res_) {
	UserIndicatorWindowSetupDbusData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void user_indicator_window_setup_dbus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UserIndicatorWindowSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_indicator_window_setup_dbus_co (_data_);
}


static void _user_indicator_window_update_userinfo_account_user_interface_changed (AccountUserInterface* _sender, gpointer self) {
	user_indicator_window_update_userinfo ((UserIndicatorWindow*) self);
}


static gboolean user_indicator_window_setup_dbus_co (UserIndicatorWindowSetupDbusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_getenv ("XDG_SEAT_PATH");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_data_->path = _data_->_tmp1_;
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_ACCOUNTS_INTERFACE_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", "g-interface-info", g_type_get_qdata (TYPE_ACCOUNTS_INTERFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = (AccountsInterface*) _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_g_object_unref0 (_data_->self->priv->user_manager);
		_data_->self->priv->user_manager = _data_->_tmp4_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->user_manager;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->current_username;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = accounts_interface_find_user_by_name (_data_->_tmp5_, _data_->_tmp6_, &_data_->_inner_error_);
		_data_->uid = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->_tmp2_);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->uid;
			_data_->_state_ = 2;
			g_async_initable_new_async (TYPE_PROPERTIES_INTERFACE_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp9_, "g-interface-name", "org.freedesktop.DBus.Properties", "g-interface-info", g_type_get_qdata (TYPE_PROPERTIES_INTERFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
			return FALSE;
			_state_2:
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp8_ = (PropertiesInterface*) _data_->_tmp10_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->_tmp8_;
			_data_->_tmp8_ = NULL;
			_g_object_unref0 (_data_->self->priv->current_user_props);
			_data_->self->priv->current_user_props = _data_->_tmp11_;
			user_indicator_window_update_userinfo (_data_->self);
			_g_object_unref0 (_data_->_tmp8_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->e;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			g_warning (UNABLE_CONTACT "Account User Service: %s", _data_->_tmp13_);
			_g_error_free0 (_data_->e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->uid);
			_g_object_unref0 (_data_->_tmp2_);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->uid;
			_data_->_state_ = 3;
			g_async_initable_new_async (TYPE_ACCOUNT_USER_INTERFACE_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp15_, "g-interface-name", "org.freedesktop.Accounts.User", "g-interface-info", g_type_get_qdata (TYPE_ACCOUNT_USER_INTERFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
			return FALSE;
			_state_3:
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp14_ = (AccountUserInterface*) _data_->_tmp16_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->_tmp14_;
			_data_->_tmp14_ = NULL;
			_g_object_unref0 (_data_->self->priv->current_user);
			_data_->self->priv->current_user = _data_->_tmp17_;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->self->priv->current_user;
			g_signal_connect_object (_data_->_tmp18_, "changed", (GCallback) _user_indicator_window_update_userinfo_account_user_interface_changed, _data_->self, 0);
			_g_object_unref0 (_data_->_tmp14_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->_vala1_e;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			g_warning (UNABLE_CONTACT "Account User Service: %s", _data_->_tmp20_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->uid);
			_g_object_unref0 (_data_->_tmp2_);
			goto __catch0_g_error;
		}
		_g_free0 (_data_->uid);
		_g_object_unref0 (_data_->_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_vala2_e;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning (UNABLE_CONTACT "Accounts Service: %s", _data_->_tmp22_);
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_state_ = 4;
		g_async_initable_new_async (TYPE_LOGIND_INTERFACE_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", LOGIND_LOGIN, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/login1", "g-interface-name", "org.freedesktop.login1.Manager", "g-interface-info", g_type_get_qdata (TYPE_LOGIND_INTERFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_4:
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp23_ = (LogindInterface*) _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp23_;
		_data_->_tmp23_ = NULL;
		_g_object_unref0 (_data_->self->priv->logind_interface);
		_data_->self->priv->logind_interface = _data_->_tmp25_;
		_g_object_unref0 (_data_->_tmp23_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->_vala3_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_vala3_e;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_warning (UNABLE_CONTACT "logind: %s", _data_->_tmp27_);
		_g_error_free0 (_data_->_vala3_e);
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_state_ = 5;
		g_async_initable_new_async (TYPE_SCREEN_SAVER_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.ScreenSaver", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/ScreenSaver", "g-interface-name", "org.gnome.ScreenSaver", "g-interface-info", g_type_get_qdata (TYPE_SCREEN_SAVER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_5:
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp28_ = (ScreenSaver*) _data_->_tmp29_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_tmp28_;
		_data_->_tmp28_ = NULL;
		_g_object_unref0 (_data_->self->priv->saver);
		_data_->self->priv->saver = _data_->_tmp30_;
		_g_object_unref0 (_data_->_tmp28_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->_vala4_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->_vala4_e;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->_tmp31_->message;
		g_warning (UNABLE_CONTACT "gnome-screensaver: %s", _data_->_tmp32_);
		_g_error_free0 (_data_->_vala4_e);
		_g_free0 (_data_->path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally4:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_state_ = 6;
		g_async_initable_new_async (TYPE_SESSION_MANAGER_PROXY, 0, NULL, user_indicator_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", G_SESSION, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager", "g-interface-name", "org.gnome.SessionManager", "g-interface-info", g_type_get_qdata (TYPE_SESSION_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_6:
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp33_ = (SessionManager*) _data_->_tmp34_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->_tmp33_;
		_data_->_tmp33_ = NULL;
		_g_object_unref0 (_data_->self->priv->session);
		_data_->self->priv->session = _data_->_tmp35_;
		_g_object_unref0 (_data_->_tmp33_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->_vala5_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_vala5_e;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _data_->_tmp36_->message;
		g_warning (UNABLE_CONTACT "GNOME Session: %s", _data_->_tmp37_);
		_g_error_free0 (_data_->_vala5_e);
	}
	__finally5:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_g_free0 (_data_->path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean __lambda6_ (UserIndicatorWindow* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_toggle_usersection (self);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda6__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda6_ ((UserIndicatorWindow*) self, event);
	return result;
}


static gboolean __lambda7_ (UserIndicatorWindow* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_lock_screen (self);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda7__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda7_ ((UserIndicatorWindow*) self, event);
	return result;
}


static gboolean __lambda9_ (UserIndicatorWindow* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_suspend (self);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda9__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda9_ ((UserIndicatorWindow*) self, event);
	return result;
}


static gboolean __lambda11_ (UserIndicatorWindow* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_reboot (self);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda11__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda11_ ((UserIndicatorWindow*) self, event);
	return result;
}


static gboolean __lambda13_ (UserIndicatorWindow* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_hibernate (self);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda13__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda13_ ((UserIndicatorWindow*) self, event);
	return result;
}


static gboolean __lambda15_ (UserIndicatorWindow* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_shutdown (self);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda15__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda15_ ((UserIndicatorWindow*) self, event);
	return result;
}


static void _user_indicator_window_hide_usersection_gtk_popover_closed (GtkPopover* _sender, gpointer self) {
	user_indicator_window_hide_usersection ((UserIndicatorWindow*) self);
}


UserIndicatorWindow* user_indicator_window_construct (GType object_type, GtkWidget* window_parent) {
	UserIndicatorWindow * self = NULL;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkListBox* items = NULL;
	GtkListBox* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	IndicatorItem* _tmp9_ = NULL;
	GtkRevealer* _tmp10_ = NULL;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp11_ = NULL;
	IndicatorItem* lock_menu = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	IndicatorItem* _tmp14_ = NULL;
	IndicatorItem* suspend_menu = NULL;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	IndicatorItem* _tmp17_ = NULL;
	IndicatorItem* hibernate_menu = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	IndicatorItem* _tmp20_ = NULL;
	IndicatorItem* reboot_menu = NULL;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	IndicatorItem* _tmp23_ = NULL;
	IndicatorItem* shutdown_menu = NULL;
	const gchar* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	IndicatorItem* _tmp26_ = NULL;
	IndicatorItem* _tmp27_ = NULL;
	GtkRevealer* _tmp28_ = NULL;
	GtkBox* _tmp29_ = NULL;
	GtkBox* _tmp30_ = NULL;
	IndicatorItem* _tmp31_ = NULL;
	_tmp0_ = window_parent;
	self = (UserIndicatorWindow*) g_object_new (object_type, "relative-to", _tmp0_, NULL);
	_tmp1_ = g_get_user_name ();
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->current_username);
	self->priv->current_username = _tmp2_;
	user_indicator_window_setup_dbus (self, NULL, NULL);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->menu);
	self->menu = _tmp3_;
	_tmp4_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp4_);
	items = _tmp4_;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp5_, "user-menu");
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) items);
	gtk_style_context_add_class (_tmp6_, "content-box");
	gtk_list_box_set_selection_mode (items, GTK_SELECTION_NONE);
	_tmp7_ = _ ("User");
	_tmp8_ = TRUE;
	_tmp9_ = indicator_item_new (_tmp7_, USER_SYMBOLIC_ICON, &_tmp8_);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->user_item);
	self->priv->user_item = _tmp9_;
	_tmp10_ = user_indicator_window_create_usersection (self);
	_g_object_unref0 (self->user_section);
	self->user_section = _tmp10_;
	_tmp11_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp11_);
	separator = _tmp11_;
	_tmp12_ = _ ("Lock");
	_tmp13_ = FALSE;
	_tmp14_ = indicator_item_new (_tmp12_, "system-lock-screen-symbolic", &_tmp13_);
	g_object_ref_sink (_tmp14_);
	lock_menu = _tmp14_;
	_tmp15_ = _ ("Suspend");
	_tmp16_ = FALSE;
	_tmp17_ = indicator_item_new (_tmp15_, "media-playback-pause-symbolic", &_tmp16_);
	g_object_ref_sink (_tmp17_);
	suspend_menu = _tmp17_;
	_tmp18_ = _ ("Hibernate");
	_tmp19_ = FALSE;
	_tmp20_ = indicator_item_new (_tmp18_, "system-suspend-hibernate", &_tmp19_);
	g_object_ref_sink (_tmp20_);
	hibernate_menu = _tmp20_;
	_tmp21_ = _ ("Restart");
	_tmp22_ = FALSE;
	_tmp23_ = indicator_item_new (_tmp21_, "media-playlist-repeat-symbolic", &_tmp22_);
	g_object_ref_sink (_tmp23_);
	reboot_menu = _tmp23_;
	_tmp24_ = _ ("Shutdown");
	_tmp25_ = FALSE;
	_tmp26_ = indicator_item_new (_tmp24_, "system-shutdown-symbolic", &_tmp25_);
	g_object_ref_sink (_tmp26_);
	shutdown_menu = _tmp26_;
	_tmp27_ = self->priv->user_item;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp27_);
	_tmp28_ = self->user_section;
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) _tmp28_);
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) separator);
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) lock_menu);
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) suspend_menu);
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) hibernate_menu);
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) reboot_menu);
	gtk_container_add ((GtkContainer*) items, (GtkWidget*) shutdown_menu);
	_tmp29_ = self->menu;
	gtk_box_pack_start (_tmp29_, (GtkWidget*) items, FALSE, FALSE, (guint) 0);
	_tmp30_ = self->menu;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp30_);
	gtk_widget_set_size_request ((GtkWidget*) self, 250, 0);
	_tmp31_ = self->priv->user_item;
	g_signal_connect_object ((GtkWidget*) _tmp31_, "button-release-event", (GCallback) ___lambda6__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) lock_menu, "button-release-event", (GCallback) ___lambda7__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) suspend_menu, "button-release-event", (GCallback) ___lambda9__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) reboot_menu, "button-release-event", (GCallback) ___lambda11__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) hibernate_menu, "button-release-event", (GCallback) ___lambda13__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) shutdown_menu, "button-release-event", (GCallback) ___lambda15__gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkPopover*) self, "closed", (GCallback) _user_indicator_window_hide_usersection_gtk_popover_closed, self, 0);
	_g_object_unref0 (shutdown_menu);
	_g_object_unref0 (reboot_menu);
	_g_object_unref0 (hibernate_menu);
	_g_object_unref0 (suspend_menu);
	_g_object_unref0 (lock_menu);
	_g_object_unref0 (separator);
	_g_object_unref0 (items);
	return self;
}


UserIndicatorWindow* user_indicator_window_new (GtkWidget* window_parent) {
	return user_indicator_window_construct (TYPE_USER_INDICATOR_WINDOW, window_parent);
}


static gboolean __lambda4_ (UserIndicatorWindow* self, GdkEventButton* e) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	user_indicator_window_logout (self);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda4__gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda4_ ((UserIndicatorWindow*) self, event);
	return result;
}


static GtkRevealer* user_indicator_window_create_usersection (UserIndicatorWindow* self) {
	GtkRevealer* result = NULL;
	GtkRevealer* user_section = NULL;
	GtkRevealer* _tmp0_ = NULL;
	GtkBox* user_section_box = NULL;
	GtkBox* _tmp1_ = NULL;
	IndicatorItem* logout_menu = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	IndicatorItem* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp0_);
	user_section = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	user_section_box = _tmp1_;
	_tmp2_ = _ ("Logout");
	_tmp3_ = FALSE;
	_tmp4_ = indicator_item_new (_tmp2_, "application-exit-symbolic", &_tmp3_);
	g_object_ref_sink (_tmp4_);
	logout_menu = _tmp4_;
	gtk_box_pack_start (user_section_box, (GtkWidget*) logout_menu, FALSE, FALSE, (guint) 0);
	gtk_container_add ((GtkContainer*) user_section, (GtkWidget*) user_section_box);
	g_signal_connect_object ((GtkWidget*) logout_menu, "button-release-event", (GCallback) ___lambda4__gtk_widget_button_release_event, self, 0);
	result = user_section;
	_g_object_unref0 (logout_menu);
	_g_object_unref0 (user_section_box);
	return result;
}


void user_indicator_window_toggle_usersection (UserIndicatorWindow* self) {
	GtkRevealer* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->user_section;
	if (_tmp0_ != NULL) {
		GtkRevealer* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->user_section;
		_tmp2_ = gtk_revealer_get_child_revealed (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!_tmp3_) {
			user_indicator_window_show_usersection (self);
		} else {
			user_indicator_window_hide_usersection (self);
		}
	}
}


static void user_indicator_window_show_usersection (UserIndicatorWindow* self) {
	GtkRevealer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->user_section;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GtkRevealer* _tmp3_ = NULL;
		GtkRevealer* _tmp4_ = NULL;
		IndicatorItem* _tmp5_ = NULL;
		_tmp3_ = self->user_section;
		gtk_revealer_set_transition_type (_tmp3_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
		_tmp4_ = self->user_section;
		gtk_revealer_set_reveal_child (_tmp4_, TRUE);
		_tmp5_ = self->priv->user_item;
		indicator_item_set_arrow (_tmp5_, "up");
	}
}


static void user_indicator_window_hide_usersection (UserIndicatorWindow* self) {
	GtkRevealer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->user_section;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkRevealer* _tmp3_ = NULL;
		GtkRevealer* _tmp4_ = NULL;
		IndicatorItem* _tmp5_ = NULL;
		_tmp3_ = self->user_section;
		gtk_revealer_set_transition_type (_tmp3_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
		_tmp4_ = self->user_section;
		gtk_revealer_set_reveal_child (_tmp4_, FALSE);
		_tmp5_ = self->priv->user_item;
		indicator_item_set_arrow (_tmp5_, "down");
	}
}


static void user_indicator_window_update_userinfo (UserIndicatorWindow* self) {
	gchar* user_image = NULL;
	gchar* _tmp0_ = NULL;
	gchar* user_name = NULL;
	gchar* _tmp1_ = NULL;
	IndicatorItem* _tmp2_ = NULL;
	IndicatorItem* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = user_indicator_window_get_user_image (self);
	user_image = _tmp0_;
	_tmp1_ = user_indicator_window_get_user_name (self);
	user_name = _tmp1_;
	_tmp2_ = self->priv->user_item;
	indicator_item_set_image (_tmp2_, user_image);
	_tmp3_ = self->priv->user_item;
	indicator_item_set_label (_tmp3_, user_name);
	_g_free0 (user_name);
	_g_free0 (user_image);
}


static gchar* user_indicator_window_get_user_image (UserIndicatorWindow* self) {
	gchar* result = NULL;
	gchar* image = NULL;
	gchar* _tmp0_ = NULL;
	PropertiesInterface* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (USER_SYMBOLIC_ICON);
	image = _tmp0_;
	_tmp1_ = self->priv->current_user_props;
	if (_tmp1_ != NULL) {
		{
			GVariant* _tmp2_ = NULL;
			PropertiesInterface* _tmp3_ = NULL;
			GVariant* _tmp4_ = NULL;
			gchar* icon_file = NULL;
			GVariant* _tmp5_ = NULL;
			GVariant* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp3_ = self->priv->current_user_props;
			_tmp4_ = properties_interface_get (_tmp3_, ACCOUNTSSERVICE_USER, "IconFile", &_inner_error_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch6_g_error;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_tmp6_ = _tmp5_;
			_tmp7_ = g_variant_get_string (_tmp6_, NULL);
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_variant_unref0 (_tmp6_);
			icon_file = _tmp9_;
			_tmp11_ = icon_file;
			if (g_strcmp0 (_tmp11_, "") != 0) {
				const gchar* _tmp12_ = NULL;
				_tmp12_ = icon_file;
				_tmp10_ = _tmp12_;
			} else {
				const gchar* _tmp13_ = NULL;
				_tmp13_ = image;
				_tmp10_ = _tmp13_;
			}
			_tmp14_ = g_strdup (_tmp10_);
			_g_free0 (image);
			image = _tmp14_;
			_g_free0 (icon_file);
			_g_variant_unref0 (_tmp2_);
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("UserIndicatorWindow.vala:239: Failed to fetch IconFile: %s", _tmp16_);
			_g_error_free0 (e);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = image;
	return result;
}


static gchar* user_indicator_window_get_user_name (UserIndicatorWindow* self) {
	gchar* result = NULL;
	gchar* user_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	PropertiesInterface* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_username;
	_tmp1_ = g_strdup (_tmp0_);
	user_name = _tmp1_;
	_tmp2_ = self->priv->current_user_props;
	if (_tmp2_ != NULL) {
		{
			GVariant* _tmp3_ = NULL;
			PropertiesInterface* _tmp4_ = NULL;
			GVariant* _tmp5_ = NULL;
			gchar* real_name = NULL;
			GVariant* _tmp6_ = NULL;
			GVariant* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp4_ = self->priv->current_user_props;
			_tmp5_ = properties_interface_get (_tmp4_, ACCOUNTSSERVICE_USER, "RealName", &_inner_error_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch7_g_error;
			}
			_tmp6_ = _tmp3_;
			_tmp3_ = NULL;
			_tmp7_ = _tmp6_;
			_tmp8_ = g_variant_get_string (_tmp7_, NULL);
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = _tmp9_;
			_g_variant_unref0 (_tmp7_);
			real_name = _tmp10_;
			_tmp12_ = real_name;
			if (g_strcmp0 (_tmp12_, "") != 0) {
				const gchar* _tmp13_ = NULL;
				_tmp13_ = real_name;
				_tmp11_ = _tmp13_;
			} else {
				const gchar* _tmp14_ = NULL;
				_tmp14_ = user_name;
				_tmp11_ = _tmp14_;
			}
			_tmp15_ = g_strdup (_tmp11_);
			_g_free0 (user_name);
			user_name = _tmp15_;
			_g_free0 (real_name);
			_g_variant_unref0 (_tmp3_);
		}
		goto __finally7;
		__catch7_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_warning ("UserIndicatorWindow.vala:255: Failed to fetch RealName: %s", _tmp17_);
			_g_error_free0 (e);
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (user_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = user_name;
	return result;
}


static gboolean __lambda5_ (UserIndicatorWindow* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		SessionManager* _tmp0_ = NULL;
		_tmp0_ = self->priv->session;
		session_manager_Logout (_tmp0_, (guint) 0, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserIndicatorWindow.vala:272: Failed to logout: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((UserIndicatorWindow*) self);
	return result;
}


static void user_indicator_window_logout (UserIndicatorWindow* self) {
	SessionManager* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean __lambda14_ (UserIndicatorWindow* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		LogindInterface* _tmp0_ = NULL;
		user_indicator_window_lock_screen (self);
		_tmp0_ = self->priv->logind_interface;
		logind_interface_hibernate (_tmp0_, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserIndicatorWindow.vala:289: Cannot hibernate: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda14__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda14_ ((UserIndicatorWindow*) self);
	return result;
}


static void user_indicator_window_hibernate (UserIndicatorWindow* self) {
	LogindInterface* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->logind_interface;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda14__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean __lambda12_ (UserIndicatorWindow* self) {
	gboolean result = FALSE;
	SessionManager* _tmp0_ = NULL;
	_tmp0_ = self->priv->session;
	session_manager_Reboot (_tmp0_, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda12_ ((UserIndicatorWindow*) self);
	return result;
}


static void user_indicator_window_reboot (UserIndicatorWindow* self) {
	SessionManager* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean __lambda16_ (UserIndicatorWindow* self) {
	gboolean result = FALSE;
	SessionManager* _tmp0_ = NULL;
	_tmp0_ = self->priv->session;
	session_manager_Shutdown (_tmp0_, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda16_ ((UserIndicatorWindow*) self);
	return result;
}


static void user_indicator_window_shutdown (UserIndicatorWindow* self) {
	SessionManager* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda16__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean __lambda10_ (UserIndicatorWindow* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		LogindInterface* _tmp0_ = NULL;
		user_indicator_window_lock_screen (self);
		_tmp0_ = self->priv->logind_interface;
		logind_interface_suspend (_tmp0_, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserIndicatorWindow.vala:330: Cannot suspend: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda10_ ((UserIndicatorWindow*) self);
	return result;
}


static void user_indicator_window_suspend (UserIndicatorWindow* self) {
	LogindInterface* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->logind_interface;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean __lambda8_ (UserIndicatorWindow* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		ScreenSaver* _tmp0_ = NULL;
		_tmp0_ = self->priv->saver;
		screen_saver_lock (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("UserIndicatorWindow.vala:342: Cannot lock screen: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ ((UserIndicatorWindow*) self);
	return result;
}


static void user_indicator_window_lock_screen (UserIndicatorWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
}


static void user_indicator_window_class_init (UserIndicatorWindowClass * klass) {
	user_indicator_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserIndicatorWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = user_indicator_window_finalize;
}


static void user_indicator_window_instance_init (UserIndicatorWindow * self) {
	self->priv = USER_INDICATOR_WINDOW_GET_PRIVATE (self);
	self->menu = NULL;
	self->user_section = NULL;
	self->priv->saver = NULL;
	self->priv->session = NULL;
	self->priv->logind_interface = NULL;
	self->priv->user_manager = NULL;
	self->priv->current_user = NULL;
	self->priv->current_username = NULL;
	self->priv->current_user_props = NULL;
	self->priv->user_item = NULL;
}


static void user_indicator_window_finalize (GObject* obj) {
	UserIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_INDICATOR_WINDOW, UserIndicatorWindow);
	_g_object_unref0 (self->menu);
	_g_object_unref0 (self->user_section);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->logind_interface);
	_g_object_unref0 (self->priv->user_manager);
	_g_object_unref0 (self->priv->current_user);
	_g_free0 (self->priv->current_username);
	_g_object_unref0 (self->priv->current_user_props);
	_g_object_unref0 (self->priv->user_item);
	G_OBJECT_CLASS (user_indicator_window_parent_class)->finalize (obj);
}


GType user_indicator_window_get_type (void) {
	return user_indicator_window_type_id;
}


GType user_indicator_window_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (UserIndicatorWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_indicator_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserIndicatorWindow), 0, (GInstanceInitFunc) user_indicator_window_instance_init, NULL };
	user_indicator_window_type_id = g_type_module_register_type (module, gtk_popover_get_type (), "UserIndicatorWindow", &g_define_type_info, 0);
	return user_indicator_window_type_id;
}


IndicatorItem* indicator_item_construct (GType object_type, const gchar* label_string, const gchar* image_source, gboolean* add_arrow) {
	IndicatorItem * self = NULL;
	GtkBox* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	gboolean* _tmp7_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkStyleContext* _tmp13_ = NULL;
	GtkStyleContext* _tmp14_ = NULL;
	g_return_val_if_fail (label_string != NULL, NULL);
	g_return_val_if_fail (image_source != NULL, NULL);
	self = (IndicatorItem*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->menu_item);
	self->priv->menu_item = _tmp0_;
	_tmp1_ = image_source;
	indicator_item_set_image (self, _tmp1_);
	_tmp2_ = label_string;
	indicator_item_set_label (self, _tmp2_);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_tmp3_ = self->priv->menu_item;
	_tmp4_ = self->priv->button_image;
	gtk_box_pack_start (_tmp3_, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	_tmp5_ = self->priv->menu_item;
	_tmp6_ = self->priv->button_label;
	gtk_box_pack_start (_tmp5_, (GtkWidget*) _tmp6_, FALSE, FALSE, (guint) 0);
	_tmp7_ = add_arrow;
	if (*_tmp7_) {
		GtkImage* _tmp8_ = NULL;
		GtkBox* _tmp9_ = NULL;
		GtkImage* _tmp10_ = NULL;
		_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp8_);
		_g_object_unref0 (self->priv->arrow);
		self->priv->arrow = _tmp8_;
		_tmp9_ = self->priv->menu_item;
		_tmp10_ = self->priv->arrow;
		gtk_box_pack_end (_tmp9_, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	}
	_tmp11_ = self->priv->menu_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp12_, "indicator-item");
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp13_, "flat");
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp14_, "menuitem");
	return self;
}


IndicatorItem* indicator_item_new (const gchar* label_string, const gchar* image_source, gboolean* add_arrow) {
	return indicator_item_construct (TYPE_INDICATOR_ITEM, label_string, image_source, add_arrow);
}


void indicator_item_set_arrow (IndicatorItem* self, const gchar* direction) {
	GtkImage* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (direction != NULL);
	_tmp0_ = self->priv->arrow;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->arrow;
	_tmp2_ = direction;
	_tmp3_ = g_strconcat ("pan-", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "-symbolic", NULL);
	_tmp6_ = _tmp5_;
	gtk_image_set_from_icon_name (_tmp1_, _tmp6_, GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
}


void indicator_item_set_image (IndicatorItem* self, const gchar* source) {
	GdkPixbuf* pixbuf = NULL;
	gboolean has_slash_prefix = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean is_user_image = FALSE;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GtkImage* _tmp11_ = NULL;
	gboolean _tmp13_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	pixbuf = NULL;
	_tmp0_ = source;
	_tmp1_ = g_str_has_prefix (_tmp0_, "/");
	has_slash_prefix = _tmp1_;
	_tmp3_ = has_slash_prefix;
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = source;
		_tmp5_ = g_str_has_suffix (_tmp4_, ".face");
		_tmp2_ = !_tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	is_user_image = _tmp2_;
	_tmp8_ = has_slash_prefix;
	if (_tmp8_) {
		gboolean _tmp9_ = FALSE;
		_tmp9_ = is_user_image;
		_tmp7_ = !_tmp9_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = USER_SYMBOLIC_ICON;
	} else {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = source;
		_tmp6_ = _tmp10_;
	}
	source = _tmp6_;
	_tmp11_ = self->priv->button_image;
	if (_tmp11_ == NULL) {
		GtkImage* _tmp12_ = NULL;
		_tmp12_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (self->priv->button_image);
		self->priv->button_image = _tmp12_;
	}
	_tmp13_ = is_user_image;
	if (_tmp13_) {
		{
			GdkPixbuf* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			GdkPixbuf* _tmp16_ = NULL;
			GdkPixbuf* _tmp17_ = NULL;
			GtkImage* _tmp18_ = NULL;
			GdkPixbuf* _tmp19_ = NULL;
			_tmp15_ = source;
			_tmp16_ = gdk_pixbuf_new_from_file_at_size (_tmp15_, 24, 24, &_inner_error_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch12_g_error;
			}
			_tmp17_ = _tmp14_;
			_tmp14_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp17_;
			_tmp18_ = self->priv->button_image;
			_tmp19_ = pixbuf;
			gtk_image_set_from_pixbuf (_tmp18_, _tmp19_);
			_g_object_unref0 (_tmp14_);
		}
		goto __finally12;
		__catch12_g_error:
		{
			GError* e = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			g_message ("UserIndicatorWindow.vala:419: File does not exist: %s", _tmp21_);
			_g_error_free0 (e);
		}
		__finally12:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		GtkImage* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		_tmp22_ = self->priv->button_image;
		_tmp23_ = source;
		gtk_image_set_from_icon_name (_tmp22_, _tmp23_, GTK_ICON_SIZE_SMALL_TOOLBAR);
	}
	_g_object_unref0 (pixbuf);
}


void indicator_item_set_label (IndicatorItem* self, const gchar* text) {
	GtkLabel* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->button_label;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		GtkLabel* _tmp2_ = NULL;
		GtkLabel* _tmp3_ = NULL;
		_tmp1_ = text;
		_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->button_label);
		self->priv->button_label = _tmp2_;
		_tmp3_ = self->priv->button_label;
		gtk_label_set_use_markup (_tmp3_, TRUE);
	} else {
		GtkLabel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->button_label;
		_tmp5_ = text;
		gtk_label_set_label (_tmp4_, _tmp5_);
	}
}


const gchar* indicator_item_get_image_source (IndicatorItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image_source;
	result = _tmp0_;
	return result;
}


void indicator_item_set_image_source (IndicatorItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = indicator_item_get_image_source (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_image_source);
	self->priv->_image_source = _tmp2_;
	_tmp3_ = indicator_item_get_image_source (self);
	_tmp4_ = _tmp3_;
	indicator_item_set_image (self, _tmp4_);
	g_object_notify ((GObject *) self, "image-source");
}


const gchar* indicator_item_get_label_text (IndicatorItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_text;
	result = _tmp0_;
	return result;
}


void indicator_item_set_label_text (IndicatorItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = indicator_item_get_label_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_label_text);
	self->priv->_label_text = _tmp2_;
	_tmp3_ = indicator_item_get_label_text (self);
	_tmp4_ = _tmp3_;
	indicator_item_set_label (self, _tmp4_);
	g_object_notify ((GObject *) self, "label-text");
}


static void indicator_item_class_init (IndicatorItemClass * klass) {
	indicator_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IndicatorItemPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_indicator_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_indicator_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = indicator_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ITEM_IMAGE_SOURCE, g_param_spec_string ("image-source", "image-source", "image-source", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ITEM_LABEL_TEXT, g_param_spec_string ("label-text", "label-text", "label-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void indicator_item_instance_init (IndicatorItem * self) {
	self->priv = INDICATOR_ITEM_GET_PRIVATE (self);
	self->priv->menu_item = NULL;
	self->priv->arrow = NULL;
	self->priv->button_image = NULL;
	self->priv->button_label = NULL;
	self->priv->_image_source = NULL;
	self->priv->_label_text = NULL;
}


static void indicator_item_finalize (GObject* obj) {
	IndicatorItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INDICATOR_ITEM, IndicatorItem);
	_g_object_unref0 (self->priv->menu_item);
	_g_object_unref0 (self->priv->arrow);
	_g_object_unref0 (self->priv->button_image);
	_g_object_unref0 (self->priv->button_label);
	_g_free0 (self->priv->_image_source);
	_g_free0 (self->priv->_label_text);
	G_OBJECT_CLASS (indicator_item_parent_class)->finalize (obj);
}


GType indicator_item_get_type (void) {
	return indicator_item_type_id;
}


GType indicator_item_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (IndicatorItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indicator_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IndicatorItem), 0, (GInstanceInitFunc) indicator_item_instance_init, NULL };
	indicator_item_type_id = g_type_module_register_type (module, gtk_button_get_type (), "IndicatorItem", &g_define_type_info, 0);
	return indicator_item_type_id;
}


static void _vala_indicator_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IndicatorItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INDICATOR_ITEM, IndicatorItem);
	switch (property_id) {
		case INDICATOR_ITEM_IMAGE_SOURCE:
		g_value_set_string (value, indicator_item_get_image_source (self));
		break;
		case INDICATOR_ITEM_LABEL_TEXT:
		g_value_set_string (value, indicator_item_get_label_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_indicator_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IndicatorItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INDICATOR_ITEM, IndicatorItem);
	switch (property_id) {
		case INDICATOR_ITEM_IMAGE_SOURCE:
		indicator_item_set_image_source (self, g_value_get_string (value));
		break;
		case INDICATOR_ITEM_LABEL_TEXT:
		indicator_item_set_label_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



