# Функции для работы с географическими координатами

## greatCircleDistance

Вычисляет расстояние между двумя точками на поверхности Земли по [формуле большого круга](https://en.wikipedia.org/wiki/Great-circle_distance).

```
greatCircleDistance(lon1Deg, lat1Deg, lon2Deg, lat2Deg)
```

**Входные параметры**

- `lon1Deg` — долгота первой точки в градусах. Диапазон — `[-180°, 180°]`.
- `lat1Deg` — широта первой точки в градусах. Диапазон — `[-90°, 90°]`.
- `lon2Deg` — долгота второй точки в градусах. Диапазон — `[-180°, 180°]`.
- `lat2Deg` — широта второй точки в градусах. Диапазон — `[-90°, 90°]`.

Положительные значения соответствуют северной широте и восточной долготе, отрицательные — южной широте и западной долготе.

**Возвращаемое значение**

Расстояние между двумя точками на поверхности Земли в метрах.

Генерирует исключение, когда значения входных параметров выходят за границы диапазонов.

**Пример**

``` sql
SELECT greatCircleDistance(55.755831, 37.617673, -55.755831, -37.617673)
```

```
┌─greatCircleDistance(55.755831, 37.617673, -55.755831, -37.617673)─┐
│                                                14132374.194975413 │
└───────────────────────────────────────────────────────────────────┘
```

## pointInEllipses

Проверяет, принадлежит ли точка хотя бы одному из эллипсов.

```
pointInEllipses(x, y, x₀, y₀, a₀, b₀,...,xₙ, yₙ, aₙ, bₙ)
```

**Входные параметры**

- `x, y` — координаты точки на плоскости.
- `xᵢ, yᵢ` — координаты центра `i`-го эллипса.
- `aᵢ, bᵢ` — полуоси `i`-го эллипса в метрах.

Входных параметров должно быть `2+4⋅n`, где `n` — количество эллипсов.

**Возвращаемые значения**

`1`, если точка внутри хотя бы одного из эллипсов, `0`, если нет.


**Пример**

``` sql
SELECT pointInEllipses(55.755831, 37.617673, 55.755831, 37.617673, 1.0, 2.0)
```

```
┌─pointInEllipses(55.755831, 37.617673, 55.755831, 37.617673, 1., 2.)─┐
│                                                                   1 │
└─────────────────────────────────────────────────────────────────────┘
```

## pointInPolygon

Проверяет, принадлежит ли точка многоугольнику на плоскости.

```
pointInPolygon((x, y), [(a, b), (c, d) ...], ...)
```

**Входные значения**

- `(x, y)` — координаты точки на плоскости. Тип данных — [Tuple](../../data_types/tuple.md- `[(a, b), (c, d) ...]` — вершины многоугольника. Тип данных — [Array](../../data_types/array.md). Каждая вершина представлена парой координат `(a, b)`. Вершины следует указывать в порядке обхода по или против часовой стрелки. Минимальное количество вершин — 3. Многоугольник должен быть константным.
- `[(a, b), (c, d) ...]` — вершины многоугольника. Тип данных — [Array](../../data_types/array.md). Каждая вершина представлена парой координат `(a, b)`. Вершины следует указывать в порядке обхода по или против часовой стрелки. Минимальное количество вершин — 3. Многоугольник должен быть константным.
- функция поддерживает также многоугольники с дырками (вырезанными кусками). Для этого случая, добавьте многоугольники, описывающие вырезанные куски, дополнительными аргументами функции. Функция не поддерживает неодносвязные многоугольники.

**Возвращаемые значения**

`1`, если точка внутри многоугольника, `0`, если нет.
Если точка находится на границе многоугольника, функция может возвращать как 0, так и 1.


**Пример**

``` sql
SELECT pointInPolygon((3., 3.), [(6, 0), (8, 4), (5, 8), (0, 2)]) AS res
```
```
┌─res─┐
│   1 │
└─────┘
```

[Оригинальная статья](https://clickhouse.yandex/docs/ru/query_language/functions/geo/) <!--hide-->
