/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import java.io.IOException;
import java.util.Vector;

public class BLCFile
extends AlignFile {
    Vector titles;
    int iterationSkips = 0;
    int iterationCount = 0;

    public BLCFile() {
    }

    public BLCFile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public BLCFile(FileParse source) throws IOException {
        super(source);
    }

    public void initData() {
        super.initData();
        this.titles = new Vector();
    }

    public void parse() throws IOException {
        StringBuffer headerLines = new StringBuffer();
        int numHeaderLines = 0;
        StringBuffer[] seqstrings = null;
        if (this.suffix != null) {
            try {
                this.iterationSkips = Integer.parseInt(this.suffix);
            }
            catch (NumberFormatException e) {
                this.iterationSkips = 0;
            }
        }
        String line = null;
        do {
            int i;
            boolean idsFound = false;
            boolean newids = false;
            while ((line = this.nextLine()) != null) {
                if (line.indexOf("*") > -1) {
                    idsFound = true;
                    break;
                }
                int abracket = line.indexOf(">");
                if (abracket > -1) {
                    if (this.iterationCount > 0 && !newids) {
                        newids = true;
                        this.seqs.removeAllElements();
                    }
                    line = line.substring(abracket + 1);
                    Sequence seq = this.parseId(line);
                    this.seqs.addElement(seq);
                } else {
                    headerLines.append(line);
                    headerLines.append("\n");
                    ++numHeaderLines;
                }
                if (!idsFound) continue;
            }
            if (line == null) break;
            int starCol = line.indexOf("*");
            seqstrings = new StringBuffer[this.seqs.size()];
            for (i = 0; i < this.seqs.size(); ++i) {
                if (seqstrings[i] != null) continue;
                seqstrings[i] = new StringBuffer();
            }
            try {
                line = this.nextLine();
                while (line != null && line.indexOf("*") == -1) {
                    for (i = 0; i < this.seqs.size(); ++i) {
                        if (line.length() <= i + starCol) continue;
                        seqstrings[i].append(line.charAt(i + starCol));
                    }
                    line = this.nextLine();
                }
            }
            catch (IOException e) {
                if (this.iterationCount == 0) {
                    throw e;
                }
                this.iterationSkips = 0;
            }
            ++this.iterationCount;
        } while (--this.iterationSkips != -1);
        for (int i = 0; i < this.seqs.size(); ++i) {
            Sequence newSeq = (Sequence)this.seqs.elementAt(i);
            newSeq.setSequence(seqstrings[i].toString());
        }
        if (this.seqs.size() > 0) {
            if (headerLines.length() > 1 + numHeaderLines) {
                this.setAlignmentProperty("Comments", headerLines.toString());
            }
            this.setAlignmentProperty("iteration", "" + this.iterationCount);
        }
    }

    public String print() {
        return this.print(this.getSeqsAsArray());
    }

    public String print(SequenceI[] s) {
        int i;
        StringBuffer out = new StringBuffer();
        int max = -1;
        for (i = 0; i < s.length && s[i] != null; ++i) {
            out.append(">" + this.printId(s[i]));
            if (s[i].getDescription() != null) {
                out.append(" " + s[i].getDescription());
            }
            out.append("\n");
            if (s[i].getSequence().length <= max) continue;
            max = s[i].getSequence().length;
        }
        out.append("* iteration 1\n");
        for (int j = 0; j < max; ++j) {
            for (i = 0; i < s.length && s[i] != null; ++i) {
                if (s[i].getSequence().length > j) {
                    out.append(s[i].getSequenceAsString(j, j + 1));
                    continue;
                }
                out.append("-");
            }
            out.append("\n");
        }
        out.append("*\n");
        return out.toString();
    }
}

