/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import loci.formats.CoreMetadata;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataStore;
import loci.formats.ReaderWrapper;

public class DimensionSwapper
extends ReaderWrapper {
    public DimensionSwapper() {
    }

    public DimensionSwapper(IFormatReader r) {
        super(r);
    }

    public int getSizeX() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeX[this.getSeries()];
    }

    public int getSizeY() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeY[this.getSeries()];
    }

    public int getSizeZ() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeZ[this.getSeries()];
    }

    public int getSizeC() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeC[this.getSeries()];
    }

    public int getSizeT() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().sizeT[this.getSeries()];
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        return this.getCoreMetadata().currentOrder[this.getSeries()];
    }

    public void swapDimensions(String order) {
        FormatTools.assertId(this.getCurrentFile(), true, 2);
        if (order == null) {
            throw new IllegalArgumentException("order is null");
        }
        String oldOrder = this.getDimensionOrder();
        if (order.equals(oldOrder)) {
            return;
        }
        if (order.length() != 5) {
            throw new IllegalArgumentException("order is unexpected length (" + order.length() + ")");
        }
        int newX = order.indexOf("X");
        int newY = order.indexOf("Y");
        int newZ = order.indexOf("Z");
        int newC = order.indexOf("C");
        int newT = order.indexOf("T");
        if (newX < 0) {
            throw new IllegalArgumentException("X does not appear");
        }
        if (newY < 0) {
            throw new IllegalArgumentException("Y does not appear");
        }
        if (newZ < 0) {
            throw new IllegalArgumentException("Z does not appear");
        }
        if (newC < 0) {
            throw new IllegalArgumentException("C does not appear");
        }
        if (newT < 0) {
            throw new IllegalArgumentException("T does not appear");
        }
        if (newX > 1) {
            throw new IllegalArgumentException("X in unexpected position (" + newX + ")");
        }
        if (newY > 1) {
            throw new IllegalArgumentException("Y in unexpected position (" + newY + ")");
        }
        int[] dims = new int[5];
        int oldX = oldOrder.indexOf("X");
        int oldY = oldOrder.indexOf("Y");
        int oldZ = oldOrder.indexOf("Z");
        int oldC = oldOrder.indexOf("C");
        int oldT = oldOrder.indexOf("T");
        dims[oldX] = this.getSizeX();
        dims[oldY] = this.getSizeY();
        dims[oldZ] = this.getSizeZ();
        dims[oldC] = this.getSizeC();
        dims[oldT] = this.getSizeT();
        int series = this.getSeries();
        CoreMetadata core = this.getCoreMetadata();
        core.sizeX[series] = dims[newX];
        core.sizeY[series] = dims[newY];
        core.sizeZ[series] = dims[newZ];
        core.sizeC[series] = dims[newC];
        core.sizeT[series] = dims[newT];
        core.currentOrder[series] = order;
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(dims[newX]), new Integer(dims[newY]), new Integer(dims[newZ]), new Integer(dims[newC]), new Integer(dims[newT]), null, null, order, new Integer(series), null);
    }
}

