/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class MRCReader
extends FormatReader {
    private int bpp = 0;
    private int extHeaderSize = 0;
    private boolean isFloat = false;

    public MRCReader() {
        super("Medical Research Council (MRC)", "mrc");
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.in.seek(1024 + no * this.core.sizeX[0] * this.core.sizeY[0] * this.bpp);
        this.in.read(buf);
        return buf;
    }

    public void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("MRCReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Reading header");
        this.in.seek(213L);
        this.core.littleEndian[0] = this.in.read() == 68;
        this.in.seek(0L);
        this.in.order(this.core.littleEndian[0]);
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        this.core.sizeZ[0] = this.in.readInt();
        this.core.sizeC[0] = 1;
        int mode = this.in.readInt();
        switch (mode) {
            case 0: {
                this.bpp = 1;
                this.core.pixelType[0] = 1;
                break;
            }
            case 1: 
            case 6: {
                this.bpp = 2;
                this.core.pixelType[0] = 3;
                break;
            }
            case 2: {
                this.bpp = 4;
                this.isFloat = true;
                this.core.pixelType[0] = 6;
                break;
            }
            case 3: {
                this.bpp = 4;
                this.core.pixelType[0] = 5;
                break;
            }
            case 4: {
                this.bpp = 8;
                this.isFloat = true;
                this.core.pixelType[0] = 7;
                break;
            }
            case 16: {
                this.bpp = 2;
                this.core.sizeC[0] = 3;
                this.core.pixelType[0] = 3;
            }
        }
        int mx = this.in.readInt();
        int my = this.in.readInt();
        int mz = this.in.readInt();
        float xlen = this.in.readFloat();
        float ylen = this.in.readFloat();
        float zlen = this.in.readFloat();
        this.addMeta("Pixel size (X)", "" + xlen / (float)mx);
        this.addMeta("Pixel size (Y)", "" + ylen / (float)my);
        this.addMeta("Pixel size (Z)", "" + zlen / (float)mz);
        this.addMeta("Alpha angle", "" + this.in.readFloat());
        this.addMeta("Beta angle", "" + this.in.readFloat());
        this.addMeta("Gamma angle", "" + this.in.readFloat());
        this.in.skipBytes(12);
        this.addMeta("Minimum pixel value", "" + this.in.readFloat());
        this.addMeta("Maximum pixel value", "" + this.in.readFloat());
        this.addMeta("Mean pixel value", "" + this.in.readFloat());
        this.in.skipBytes(4);
        this.extHeaderSize = this.in.readInt();
        this.in.skipBytes(64);
        short idtype = this.in.readShort();
        String[] types = new String[]{"mono", "tilt", "tilts", "lina", "lins"};
        String type = idtype >= 0 && idtype < types.length ? types[idtype] : "unknown";
        this.addMeta("Series type", type);
        this.addMeta("Lens", "" + this.in.readShort());
        this.addMeta("ND1", "" + this.in.readShort());
        this.addMeta("ND2", "" + this.in.readShort());
        this.addMeta("VD1", "" + this.in.readShort());
        this.addMeta("VD2", "" + this.in.readShort());
        float[] angles = new float[6];
        for (int i = 0; i < angles.length; ++i) {
            angles[i] = this.in.readFloat();
            this.addMeta("Angle " + (i + 1), "" + angles[i]);
        }
        this.in.skipBytes(24);
        int nUsefulLabels = this.in.readInt();
        this.addMeta("Number of useful labels", "" + nUsefulLabels);
        for (int i = 0; i < 10; ++i) {
            this.addMeta("Label " + (i + 1), this.in.readString(80));
        }
        this.in.skipBytes(this.extHeaderSize);
        this.status("Populating metadata");
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYZTC";
        this.core.imageCount[0] = this.core.sizeZ[0];
        this.core.rgb[0] = false;
        this.core.interleaved[0] = true;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        Float x = new Float(xlen / (float)mx);
        Float y = new Float(ylen / (float)my);
        Float z = new Float(zlen / (float)mz);
        if (x.floatValue() == Float.POSITIVE_INFINITY) {
            x = new Float(1.0);
        }
        if (y.floatValue() == Float.POSITIVE_INFINITY) {
            y = new Float(1.0);
        }
        if (z.floatValue() == Float.POSITIVE_INFINITY) {
            z = new Float(1.0);
        }
        store.setDimensions(x, y, z, null, null, null);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

