/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribNumbers;
import ucar.grib.GribPDSVariablesIF;
import ucar.grib.grib1.GribPDSLevel;

public final class Grib1PDSVariables
implements GribPDSVariablesIF {
    private static Logger log = LoggerFactory.getLogger(Grib1PDSVariables.class);
    private final byte[] input;
    private final int length;

    public Grib1PDSVariables(byte[] input) throws IOException {
        this.input = input;
        this.length = GribNumbers.int3(this.getInt(0), this.getInt(1), this.getInt(2));
    }

    public byte[] getPDSBytes() {
        return this.input;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getSection() {
        return 1;
    }

    public final int getTableVersion() {
        return this.getInt(3);
    }

    public final int getCenter() {
        return this.getInt(4);
    }

    public final int getTypeGenProcess() {
        return this.getInt(5);
    }

    public final int getGrid_Id() {
        return this.getInt(6);
    }

    public final boolean gdsExists() {
        return (this.getInt(7) & 0x80) == 128;
    }

    public final boolean bmsExists() {
        return (this.getInt(7) & 0x40) == 64;
    }

    public final int getParameterCategory() {
        return -1;
    }

    public final int getParameterNumber() {
        return this.getInt(8);
    }

    public final int getTypeFirstFixedSurface() {
        return this.getInt(9);
    }

    public final float getValueFirstFixedSurface() {
        GribPDSLevel level = new GribPDSLevel(this.getInt(9), this.getInt(10), this.getInt(11));
        return level.getValue1();
    }

    public final int getTypeSecondFixedSurface() {
        return 255;
    }

    public final float getValueSecondFixedSurface() {
        GribPDSLevel level = new GribPDSLevel(this.getInt(9), this.getInt(10), this.getInt(11));
        return level.getValue2();
    }

    public final Date getBaseTime() {
        int century = this.getInt(24) - 1;
        if (century == -1) {
            century = 20;
        }
        int year = this.getInt(12);
        int month = this.getInt(13);
        int day = this.getInt(14);
        int hour = this.getInt(15);
        int minute = this.getInt(16);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.set(16, 0);
        calendar.set(century * 100 + year, month - 1, day, hour, minute, 0);
        return calendar.getTime();
    }

    public final long getRefTime() {
        int century = this.getInt(24) - 1;
        if (century == -1) {
            century = 20;
        }
        int year = this.getInt(12);
        int month = this.getInt(13);
        int day = this.getInt(14);
        int hour = this.getInt(15);
        int minute = this.getInt(16);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.set(16, 0);
        calendar.set(century * 100 + year, month - 1, day, hour, minute, 0);
        return calendar.getTimeInMillis();
    }

    public final int getTimeRangeUnit() {
        return this.getInt(17);
    }

    public final int getP1() {
        if (this.getTimeRange() == 10) {
            return GribNumbers.int2(this.getInt(18), this.getInt(19));
        }
        return this.getInt(18);
    }

    public final int getP2() {
        if (this.getTimeRange() == 10) {
            return 0;
        }
        return this.getInt(19);
    }

    public final int getTimeRange() {
        return this.getInt(20);
    }

    public final int getProductDefinition() {
        return this.getTimeRange();
    }

    public final int getForecastTime() {
        switch (this.getTimeRange()) {
            case 0: {
                return this.getP1();
            }
            case 1: {
                return 0;
            }
            case 2: {
                return this.getP2();
            }
            case 3: {
                return this.getP2();
            }
            case 4: {
                return this.getP2();
            }
            case 5: {
                return this.getP2();
            }
            case 6: {
                return -this.getP2();
            }
            case 7: {
                return this.getP2();
            }
            case 10: {
                return this.getP1();
            }
            case 51: {
                return this.getP2();
            }
            case 113: {
                return this.getP1();
            }
        }
        log.error("PDS: Time Range Indicator " + this.getTimeRange() + " is not yet supported");
        return -9999;
    }

    public int[] getForecastTimeInterval() {
        int[] interval = new int[]{this.getP1(), this.getP2()};
        return interval;
    }

    public final String getTimeRangeString() {
        switch (this.getTimeRange()) {
            case 0: {
                return "product valid at RT + P1";
            }
            case 1: {
                return "product valid for RT, P1=0";
            }
            case 2: {
                return "product valid from (RT + P1) to (RT + P2)";
            }
            case 3: {
                return "product is an average between (RT + P1) to (RT + P2)";
            }
            case 4: {
                return "product is an accumulation between (RT + P1) to (RT + P2)";
            }
            case 5: {
                return "product is the difference (RT + P2) - (RT + P1)";
            }
            case 6: {
                return "product is an average from (RT - P1) to (RT - P2)";
            }
            case 7: {
                return "product is an average from (RT - P1) to (RT + P2)";
            }
            case 10: {
                return "product valid at RT + P1";
            }
            case 51: {
                return "mean value from RT to (RT + P2)";
            }
            case 113: {
                return "Average of N forecasts, forecast period of P1, reference intervals of P2";
            }
        }
        log.error("PDS: Time Range Indicator " + this.getTimeRange() + " is not yet supported");
        return "";
    }

    public final int getAvgInclude() {
        return GribNumbers.int2(this.getInt(21), this.getInt(22));
    }

    public final int getAvgMissing() {
        return this.getInt(23);
    }

    public final int getSubCenter() {
        return this.getInt(25);
    }

    public final int getDecimalScale() {
        return GribNumbers.int2(this.getInt(26), this.getInt(27));
    }

    public final boolean isEnsemble() {
        return this.length > 39 && this.getInt(40) != 0;
    }

    public final int getExtension() {
        if (this.length > 39) {
            return this.getInt(40);
        }
        return -9999;
    }

    public final int getType() {
        switch (this.getCenter()) {
            case 7: 
            case 8: 
            case 9: {
                if (this.length > 40) {
                    return this.getInt(41);
                }
                return -9999;
            }
            case 98: {
                if (this.length > 41) {
                    return this.getInt(42);
                }
                return -9999;
            }
        }
        return -9999;
    }

    public final int getEcmwfClass() {
        switch (this.getCenter()) {
            case 98: {
                if (this.length > 40) {
                    return this.getInt(41);
                }
                return -9999;
            }
        }
        return -9999;
    }

    public final int getID() {
        switch (this.getCenter()) {
            case 7: 
            case 8: 
            case 9: {
                if (this.length > 41) {
                    return this.getInt(42);
                }
                return -9999;
            }
        }
        return -9999;
    }

    public final int getStream() {
        return GribNumbers.int2(this.getInt(43), this.getInt(44));
    }

    public final int getProductID() {
        if (this.length > 42) {
            return this.getInt(43);
        }
        return -9999;
    }

    public final int getSpatialorProbability() {
        if (this.length > 43) {
            return this.getInt(44);
        }
        return -9999;
    }

    public final int getProbabilityProduct() {
        if (this.length > 44 && (this.getParameterNumber() == 191 || this.getParameterNumber() == 192)) {
            return this.getInt(45);
        }
        return -9999;
    }

    public final int getProbabilityType() {
        if (this.length > 45 && (this.getParameterNumber() == 191 || this.getParameterNumber() == 192)) {
            return this.getInt(46);
        }
        return -9999;
    }

    public final int getOctet50() {
        return this.getInt(49);
    }

    public final int getEnsembleNumber() {
        switch (this.getCenter()) {
            case 98: {
                if (this.getExtension() != 30) break;
                if (this.length > 48) {
                    return this.getInt(49);
                }
                return -9999;
            }
        }
        return -9999;
    }

    public final int getOctet51() {
        return this.getInt(50);
    }

    public final int getOctet52() {
        return this.getInt(51);
    }

    public final float getValueLowerLimit() {
        if (this.length > 49 && (this.getParameterNumber() == 191 || this.getParameterNumber() == 192)) {
            return GribNumbers.float4(this.getInt(47), this.getInt(48), this.getInt(49), this.getInt(50));
        }
        return -9999.0f;
    }

    public final float getValueUpperLimit() {
        if (this.length > 53 && (this.getParameterNumber() == 191 || this.getParameterNumber() == 192)) {
            return GribNumbers.float4(this.getInt(51), this.getInt(52), this.getInt(53), this.getInt(54));
        }
        return -9999.0f;
    }

    public final int getNumberForecasts() {
        switch (this.getCenter()) {
            case 7: 
            case 8: 
            case 9: {
                if (this.length > 59 && (this.getType() == 4 || this.getType() == 5)) {
                    return this.getInt(60);
                }
                return -9999;
            }
            case 98: {
                if (this.getExtension() != 30) break;
                if (this.length > 49) {
                    return this.getInt(50);
                }
                return -9999;
            }
        }
        return -9999;
    }

    public final int getSizeClusters() {
        if (this.length > 60 && (this.getType() == 4 || this.getType() == 5)) {
            return this.getInt(61);
        }
        return -9999;
    }

    public final int getNumberClusters() {
        if (this.length > 61 && (this.getType() == 4 || this.getType() == 5)) {
            return this.getInt(62);
        }
        return -9999;
    }

    public final int getMethod() {
        if (this.length > 62 && (this.getType() == 4 || this.getType() == 5)) {
            return this.getInt(63);
        }
        return -9999;
    }

    public final float getNorthLatitude() {
        if (this.length > 65 && (this.getType() == 4 || this.getType() == 5)) {
            return GribNumbers.int3(this.getInt(64), this.getInt(65), this.getInt(66)) / 1000;
        }
        return -9999.0f;
    }

    public final float getSouthLatitude() {
        if (this.length > 68 && (this.getType() == 4 || this.getType() == 5)) {
            return GribNumbers.int3(this.getInt(67), this.getInt(68), this.getInt(69)) / 1000;
        }
        return -9999.0f;
    }

    public final float getEastLongitude() {
        if (this.length > 71 && (this.getType() == 4 || this.getType() == 5)) {
            return GribNumbers.int3(this.getInt(70), this.getInt(71), this.getInt(72)) / 1000;
        }
        return -9999.0f;
    }

    public final float getWestLongitude() {
        if (this.length > 74 && (this.getType() == 4 || this.getType() == 5)) {
            return GribNumbers.int3(this.getInt(73), this.getInt(74), this.getInt(75)) / 1000;
        }
        return -9999.0f;
    }

    public final int[] getMembership() {
        if (this.length > 84 && this.getType() == 4) {
            int[] member = new int[10];
            int idx = 76;
            for (int i = 0; i < 10; ++i) {
                member[i] = this.getInt(idx++);
            }
            return member;
        }
        return null;
    }

    public final int getCoordinates() {
        return -9999;
    }

    public final int getChemicalType() {
        return -9999;
    }

    public final int getBackGenProcess() {
        return -9999;
    }

    public final int getObservationProcess() {
        return -9999;
    }

    public final int getNB() {
        return -9999;
    }

    public final int getAnalysisGenProcess() {
        return -9999;
    }

    public final int getHoursAfter() {
        return 0;
    }

    public final int getMinutesAfter() {
        return 0;
    }

    public final int getForecastProbability() {
        return this.getProbabilityType();
    }

    public final int getForecastPercentile() {
        return -9999;
    }

    public final int getPerturbation() {
        return -9999;
    }

    public final int getInt(int index) {
        return this.input[index] & 0xFF;
    }
}

