	SUBROUTINE SYS_LS( cmnd_text, sysout_ptr, nlines, status )

*  This software was developed by the Thermal Modeling and Analysis
*  Project(TMAP) of the National Oceanographic and Atmospheric
*  Administration's (NOAA) Pacific Marine Environmental Lab(PMEL),
*  hereafter referred to as NOAA/PMEL/TMAP.
*
*  Access and use of this software shall impose the following
*  obligations and understandings on the user. The user is granted the
*  right, without any fee or cost, to use, copy, modify, alter, enhance
*  and distribute this software, and any derivative works thereof, and
*  its supporting documentation for any purpose whatsoever, provided
*  that this entire notice appears in all copies of the software,
*  derivative works and supporting documentation.  Further, the user
*  agrees to credit NOAA/PMEL/TMAP in any publications that result from
*  the use of this software or in any product that includes this
*  software. The names TMAP, NOAA and/or PMEL, however, may not be used
*  in any advertising or publicity to endorse or promote any products
*  or commercial entity unless specific written permission is obtained
*  from NOAA/PMEL/TMAP. The user also understands that NOAA/PMEL/TMAP
*  is not obligated to provide the user with any support, consulting,
*  training or assistance of any kind with regard to the use, operation
*  and performance of this software nor to provide the user with any
*  updates, revisions, new versions or "bug fixes".
*
*  THIS SOFTWARE IS PROVIDED BY NOAA/PMEL/TMAP "AS IS" AND ANY EXPRESS
*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
*  ARE DISCLAIMED. IN NO EVENT SHALL NOAA/PMEL/TMAP BE LIABLE FOR ANY SPECIAL,
*  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
*  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
*  CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
*  CONNECTION WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE. 


* Execute an "ls -1" shell command and return the resulting strings

* programmer - steve hankin
* NOAA/PMEL, Seattle, WA - Tropical Modeling and Analysis Program

* V695+:  5/15 *sh*  - based upon store_sys_strings.F

        IMPLICIT NONE
	include	'tmap_dims.parm'
	include	'xrisc.cmn'

* calling argument declarations:
	INTEGER	nlines, status
	REAL*8	 sysout_ptr
	CHARACTER*(*) cmnd_text, ls_out

* internal variable declarations:
	INTEGER	istat

	CALL WARN('Unix ls NEEDS SECURITY CHECKS')

* create the ls command as a null-terminated C string
	CALL TM_FTOC_STRNG ('ls -1 '//cmnd_text,
     .			    risc_buff, size_rbuff )

* execute the shell command
	CALL GET_SYS_CMND(sysout_ptr, nlines, risc_buff, istat)
	IF (istat .NE. 0) THEN
	   CALL ERRMSG(ferr_insuff_memory, status,
     .			'dynamic memory for string', *5000)
	ELSE
	   status = ferr_ok
	ENDIF


* transfer the strings into this mr (and free the pointer)
XXX	CALL XFER_C_PTRS(sysout_ptr,0,0,mr_c_pointer(mr),1,pos-1,nlines)
	

* success
	status = ferr_ok

 5000	RETURN
	END	
