/* warp.c generated by valac 0.40.8, the Vala compiler
 * generated from warp.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/


#include <glib.h>
#include <glib-object.h>
#include <gee.h>


#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
typedef struct _WarpPrivate WarpPrivate;
enum  {
	WARP_0_PROPERTY,
	WARP_NUM_PROPERTIES
};
static GParamSpec* warp_properties[WARP_NUM_PROPERTIES];

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
typedef struct _WarpManagerPrivate WarpManagerPrivate;
enum  {
	WARP_MANAGER_0_PROPERTY,
	WARP_MANAGER_NUM_PROPERTIES
};
static GParamSpec* warp_manager_properties[WARP_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	WARP_MANAGER_WARP_ADDED_SIGNAL,
	WARP_MANAGER_NUM_SIGNALS
};
static guint warp_manager_signals[WARP_MANAGER_NUM_SIGNALS] = {0};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};

struct _WarpManager {
	GObject parent_instance;
	WarpManagerPrivate * priv;
	GeeLinkedList* warps;
};

struct _WarpManagerClass {
	GObjectClass parent_class;
};


static gpointer warp_parent_class = NULL;
static gpointer warp_manager_parent_class = NULL;

GType warp_get_type (void) G_GNUC_CONST;
Warp* warp_new (gint x,
                gint y,
                gint wx,
                gint wy);
Warp* warp_construct (GType object_type,
                      gint x,
                      gint y,
                      gint wx,
                      gint wy);
static void warp_finalize (GObject * obj);
GType warp_manager_get_type (void) G_GNUC_CONST;
#define WARP_MANAGER_MAX_WARPS 200
WarpManager* warp_manager_new (void);
WarpManager* warp_manager_construct (GType object_type);
void warp_manager_add_warp (WarpManager* self,
                            gint* board,
                            int board_length1,
                            int board_length2,
                            gint x,
                            gint y,
                            gint wx,
                            gint wy);
#define NIBBLES_GAME_WARPCHAR 'W'
Warp* warp_manager_get_warp (WarpManager* self,
                             gint x,
                             gint y);
static void warp_manager_finalize (GObject * obj);


Warp*
warp_construct (GType object_type,
                gint x,
                gint y,
                gint wx,
                gint wy)
{
	Warp * self = NULL;
	self = (Warp*) g_object_new (object_type, NULL);
	self->x = x;
	self->y = y;
	self->wx = wx;
	self->wy = wy;
	return self;
}


Warp*
warp_new (gint x,
          gint y,
          gint wx,
          gint wy)
{
	return warp_construct (TYPE_WARP, x, y, wx, wy);
}


static void
warp_class_init (WarpClass * klass)
{
	warp_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = warp_finalize;
}


static void
warp_instance_init (Warp * self)
{
}


static void
warp_finalize (GObject * obj)
{
	Warp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WARP, Warp);
	G_OBJECT_CLASS (warp_parent_class)->finalize (obj);
}


GType
warp_get_type (void)
{
	static volatile gsize warp_type_id__volatile = 0;
	if (g_once_init_enter (&warp_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WarpClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Warp), 0, (GInstanceInitFunc) warp_instance_init, NULL };
		GType warp_type_id;
		warp_type_id = g_type_register_static (G_TYPE_OBJECT, "Warp", &g_define_type_info, 0);
		g_once_init_leave (&warp_type_id__volatile, warp_type_id);
	}
	return warp_type_id__volatile;
}


WarpManager*
warp_manager_construct (GType object_type)
{
	WarpManager * self = NULL;
	GeeLinkedList* _tmp0_;
	self = (WarpManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_WARP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->warps);
	self->warps = _tmp0_;
	return self;
}


WarpManager*
warp_manager_new (void)
{
	return warp_manager_construct (TYPE_WARP_MANAGER);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
warp_manager_add_warp (WarpManager* self,
                       gint* board,
                       int board_length1,
                       int board_length2,
                       gint x,
                       gint y,
                       gint wx,
                       gint wy)
{
	gboolean add = FALSE;
	g_return_if_fail (self != NULL);
	add = TRUE;
	if (x < 0) {
		GeeLinkedList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		GeeLinkedList* _tmp18_;
		Warp* _tmp19_;
		Warp* _tmp20_;
		{
			GeeLinkedList* _warp_list = NULL;
			GeeLinkedList* _tmp0_;
			GeeLinkedList* _tmp1_;
			gint _warp_size = 0;
			GeeLinkedList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _warp_index = 0;
			_tmp0_ = self->warps;
			_tmp1_ = _g_object_ref0 (_tmp0_);
			_warp_list = _tmp1_;
			_tmp2_ = _warp_list;
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_warp_size = _tmp4_;
			_warp_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				Warp* warp = NULL;
				GeeLinkedList* _tmp8_;
				gint _tmp9_;
				gpointer _tmp10_;
				Warp* _tmp11_;
				gint _tmp12_;
				_tmp5_ = _warp_index;
				_warp_index = _tmp5_ + 1;
				_tmp6_ = _warp_index;
				_tmp7_ = _warp_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _warp_list;
				_tmp9_ = _warp_index;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
				warp = (Warp*) _tmp10_;
				_tmp11_ = warp;
				_tmp12_ = _tmp11_->wx;
				if (_tmp12_ == x) {
					Warp* _tmp13_;
					Warp* _tmp14_;
					_tmp13_ = warp;
					_tmp13_->wx = wx;
					_tmp14_ = warp;
					_tmp14_->wy = wy;
					_g_object_unref0 (warp);
					_g_object_unref0 (_warp_list);
					return;
				}
				_g_object_unref0 (warp);
			}
			_g_object_unref0 (_warp_list);
		}
		_tmp15_ = self->warps;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == WARP_MANAGER_MAX_WARPS) {
			return;
		}
		_tmp18_ = self->warps;
		_tmp19_ = warp_new (x, y, wx, wy);
		_tmp20_ = _tmp19_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp20_);
		_g_object_unref0 (_tmp20_);
	} else {
		gboolean _tmp37_;
		gint _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		{
			GeeLinkedList* _warp_list = NULL;
			GeeLinkedList* _tmp21_;
			GeeLinkedList* _tmp22_;
			gint _warp_size = 0;
			GeeLinkedList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _warp_index = 0;
			_tmp21_ = self->warps;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			_warp_list = _tmp22_;
			_tmp23_ = _warp_list;
			_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_warp_size = _tmp25_;
			_warp_index = -1;
			while (TRUE) {
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				Warp* warp = NULL;
				GeeLinkedList* _tmp29_;
				gint _tmp30_;
				gpointer _tmp31_;
				Warp* _tmp32_;
				gint _tmp33_;
				_tmp26_ = _warp_index;
				_warp_index = _tmp26_ + 1;
				_tmp27_ = _warp_index;
				_tmp28_ = _warp_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _warp_list;
				_tmp30_ = _warp_index;
				_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
				warp = (Warp*) _tmp31_;
				_tmp32_ = warp;
				_tmp33_ = _tmp32_->x;
				if (_tmp33_ == wx) {
					Warp* _tmp34_;
					Warp* _tmp35_;
					Warp* _tmp36_;
					_tmp34_ = warp;
					_tmp34_->x = x;
					_tmp35_ = warp;
					_tmp35_->y = y;
					add = FALSE;
					_tmp36_ = warp;
					g_signal_emit (self, warp_manager_signals[WARP_MANAGER_WARP_ADDED_SIGNAL], 0, _tmp36_);
				}
				_g_object_unref0 (warp);
			}
			_g_object_unref0 (_warp_list);
		}
		_tmp37_ = add;
		if (_tmp37_) {
			GeeLinkedList* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			Warp* warp = NULL;
			Warp* _tmp41_;
			GeeLinkedList* _tmp42_;
			Warp* _tmp43_;
			Warp* _tmp44_;
			_tmp38_ = self->warps;
			_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
			_tmp40_ = _tmp39_;
			if (_tmp40_ == WARP_MANAGER_MAX_WARPS) {
				return;
			}
			_tmp41_ = warp_new (x, y, wx, wy);
			warp = _tmp41_;
			_tmp42_ = self->warps;
			_tmp43_ = warp;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp43_);
			_tmp44_ = warp;
			g_signal_emit (self, warp_manager_signals[WARP_MANAGER_WARP_ADDED_SIGNAL], 0, _tmp44_);
			_g_object_unref0 (warp);
		}
		board[(x * board_length2) + y] = (gint) NIBBLES_GAME_WARPCHAR;
		_tmp45_ = board[(x * board_length2) + y];
		board[((x + 1) * board_length2) + y] = (gint) NIBBLES_GAME_WARPCHAR;
		_tmp46_ = board[((x + 1) * board_length2) + y];
		board[(x * board_length2) + (y + 1)] = (gint) NIBBLES_GAME_WARPCHAR;
		_tmp47_ = board[(x * board_length2) + (y + 1)];
		board[((x + 1) * board_length2) + (y + 1)] = (gint) NIBBLES_GAME_WARPCHAR;
		_tmp48_ = board[((x + 1) * board_length2) + (y + 1)];
	}
}


Warp*
warp_manager_get_warp (WarpManager* self,
                       gint x,
                       gint y)
{
	Warp* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _warp_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _warp_index = 0;
		_tmp0_ = self->warps;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_warp_list = _tmp1_;
		_tmp2_ = _warp_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_warp_size = _tmp4_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Warp* warp = NULL;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			Warp* _tmp15_;
			gint _tmp16_;
			_tmp5_ = _warp_index;
			_warp_index = _tmp5_ + 1;
			_tmp6_ = _warp_index;
			_tmp7_ = _warp_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _warp_list;
			_tmp9_ = _warp_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			warp = (Warp*) _tmp10_;
			_tmp15_ = warp;
			_tmp16_ = _tmp15_->x;
			if (x == _tmp16_) {
				Warp* _tmp17_;
				gint _tmp18_;
				_tmp17_ = warp;
				_tmp18_ = _tmp17_->y;
				_tmp14_ = y == _tmp18_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp19_ = FALSE;
				Warp* _tmp20_;
				gint _tmp21_;
				_tmp20_ = warp;
				_tmp21_ = _tmp20_->x;
				if (x == (_tmp21_ + 1)) {
					Warp* _tmp22_;
					gint _tmp23_;
					_tmp22_ = warp;
					_tmp23_ = _tmp22_->y;
					_tmp19_ = y == _tmp23_;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp13_ = _tmp19_;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				gboolean _tmp24_ = FALSE;
				Warp* _tmp25_;
				gint _tmp26_;
				_tmp25_ = warp;
				_tmp26_ = _tmp25_->x;
				if (x == _tmp26_) {
					Warp* _tmp27_;
					gint _tmp28_;
					_tmp27_ = warp;
					_tmp28_ = _tmp27_->y;
					_tmp24_ = y == (_tmp28_ + 1);
				} else {
					_tmp24_ = FALSE;
				}
				_tmp12_ = _tmp24_;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				gboolean _tmp29_ = FALSE;
				Warp* _tmp30_;
				gint _tmp31_;
				_tmp30_ = warp;
				_tmp31_ = _tmp30_->x;
				if (x == (_tmp31_ + 1)) {
					Warp* _tmp32_;
					gint _tmp33_;
					_tmp32_ = warp;
					_tmp33_ = _tmp32_->y;
					_tmp29_ = y == (_tmp33_ + 1);
				} else {
					_tmp29_ = FALSE;
				}
				_tmp11_ = _tmp29_;
			}
			if (_tmp11_) {
				result = warp;
				_g_object_unref0 (_warp_list);
				return result;
			}
			_g_object_unref0 (warp);
		}
		_g_object_unref0 (_warp_list);
	}
	result = NULL;
	return result;
}


static void
warp_manager_class_init (WarpManagerClass * klass)
{
	warp_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = warp_manager_finalize;
	warp_manager_signals[WARP_MANAGER_WARP_ADDED_SIGNAL] = g_signal_new ("warp-added", TYPE_WARP_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_WARP);
}


static void
warp_manager_instance_init (WarpManager * self)
{
}


static void
warp_manager_finalize (GObject * obj)
{
	WarpManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WARP_MANAGER, WarpManager);
	_g_object_unref0 (self->warps);
	G_OBJECT_CLASS (warp_manager_parent_class)->finalize (obj);
}


GType
warp_manager_get_type (void)
{
	static volatile gsize warp_manager_type_id__volatile = 0;
	if (g_once_init_enter (&warp_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WarpManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpManager), 0, (GInstanceInitFunc) warp_manager_instance_init, NULL };
		GType warp_manager_type_id;
		warp_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "WarpManager", &g_define_type_info, 0);
		g_once_init_leave (&warp_manager_type_id__volatile, warp_manager_type_id);
	}
	return warp_manager_type_id__volatile;
}



