// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/campaign_budget.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A campaign budget.
type CampaignBudget struct {
	// The resource name of the campaign budget.
	// Campaign budget resource names have the form:
	//
	// `customers/{customer_id}/campaignBudgets/{budget_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the campaign budget.
	//
	// A campaign budget is created using the CampaignBudgetService create
	// operation and is assigned a budget ID. A budget ID can be shared across
	// different campaigns; the system will then allocate the campaign budget
	// among different campaigns to get optimum results.
	Id *wrappers.Int64Value `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the campaign budget.
	//
	// When creating a campaign budget through CampaignBudgetService, every
	// explicitly shared campaign budget must have a non-null, non-empty name.
	// Campaign budgets that are not explicitly shared derive their name from the
	// attached campaign's name.
	//
	// The length of this string must be between 1 and 255, inclusive,
	// in UTF-8 bytes, (trimmed).
	Name *wrappers.StringValue `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// The amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	AmountMicros *wrappers.Int64Value `protobuf:"bytes,5,opt,name=amount_micros,json=amountMicros,proto3" json:"amount_micros,omitempty"`
	// The lifetime amount of the budget, in the local currency for the account.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	TotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,10,opt,name=total_amount_micros,json=totalAmountMicros,proto3" json:"total_amount_micros,omitempty"`
	// The status of this campaign budget. This field is read-only.
	Status enums.BudgetStatusEnum_BudgetStatus `protobuf:"varint,6,opt,name=status,proto3,enum=google.ads.googleads.v0.enums.BudgetStatusEnum_BudgetStatus" json:"status,omitempty"`
	// The delivery method that determines the rate at which the campaign budget
	// is spent.
	//
	// Defaults to STANDARD if unspecified in a create operation.
	DeliveryMethod enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod `protobuf:"varint,7,opt,name=delivery_method,json=deliveryMethod,proto3,enum=google.ads.googleads.v0.enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod" json:"delivery_method,omitempty"`
	// Whether the budget is explicitly shared. This field is set to false by
	// default.
	//
	// If true, the budget was created with the purpose of sharing
	// across one or more campaigns.
	//
	// If false, the budget was created with the intention of only being used
	// with a single campaign. The budget's name and status will stay in sync
	// with the campaign's name and status. Attempting to share the budget with a
	// second campaign will result in an error.
	//
	// A non-shared budget can become an explicitly shared. The same operation
	// must
	// also assign the budget a name.
	//
	// A shared campaign budget can never become non-shared.
	ExplicitlyShared *wrappers.BoolValue `protobuf:"bytes,8,opt,name=explicitly_shared,json=explicitlyShared,proto3" json:"explicitly_shared,omitempty"`
	// The number of campaigns actively using the budget.
	//
	// This field is read-only.
	ReferenceCount       *wrappers.Int64Value `protobuf:"bytes,9,opt,name=reference_count,json=referenceCount,proto3" json:"reference_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CampaignBudget) Reset()         { *m = CampaignBudget{} }
func (m *CampaignBudget) String() string { return proto.CompactTextString(m) }
func (*CampaignBudget) ProtoMessage()    {}
func (*CampaignBudget) Descriptor() ([]byte, []int) {
	return fileDescriptor_campaign_budget_866e5dbe05012bda, []int{0}
}
func (m *CampaignBudget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignBudget.Unmarshal(m, b)
}
func (m *CampaignBudget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignBudget.Marshal(b, m, deterministic)
}
func (dst *CampaignBudget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignBudget.Merge(dst, src)
}
func (m *CampaignBudget) XXX_Size() int {
	return xxx_messageInfo_CampaignBudget.Size(m)
}
func (m *CampaignBudget) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignBudget.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignBudget proto.InternalMessageInfo

func (m *CampaignBudget) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *CampaignBudget) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *CampaignBudget) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *CampaignBudget) GetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.AmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetTotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TotalAmountMicros
	}
	return nil
}

func (m *CampaignBudget) GetStatus() enums.BudgetStatusEnum_BudgetStatus {
	if m != nil {
		return m.Status
	}
	return enums.BudgetStatusEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetDeliveryMethod() enums.BudgetDeliveryMethodEnum_BudgetDeliveryMethod {
	if m != nil {
		return m.DeliveryMethod
	}
	return enums.BudgetDeliveryMethodEnum_UNSPECIFIED
}

func (m *CampaignBudget) GetExplicitlyShared() *wrappers.BoolValue {
	if m != nil {
		return m.ExplicitlyShared
	}
	return nil
}

func (m *CampaignBudget) GetReferenceCount() *wrappers.Int64Value {
	if m != nil {
		return m.ReferenceCount
	}
	return nil
}

func init() {
	proto.RegisterType((*CampaignBudget)(nil), "google.ads.googleads.v0.resources.CampaignBudget")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/campaign_budget.proto", fileDescriptor_campaign_budget_866e5dbe05012bda)
}

var fileDescriptor_campaign_budget_866e5dbe05012bda = []byte{
	// 498 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x93, 0xdf, 0x6e, 0xd3, 0x30,
	0x14, 0xc6, 0x95, 0xae, 0x14, 0x66, 0xb6, 0x8e, 0x65, 0x37, 0x51, 0x41, 0xa8, 0x03, 0x21, 0x55,
	0x42, 0x72, 0xca, 0x40, 0x20, 0x01, 0x17, 0xa4, 0x1b, 0xaa, 0xf8, 0x33, 0x34, 0xa5, 0xa8, 0x17,
	0xa8, 0x52, 0xe4, 0xc6, 0x67, 0x59, 0xa4, 0xc4, 0x8e, 0xfc, 0xa7, 0xb0, 0xd7, 0xe1, 0x92, 0x47,
	0xe1, 0x09, 0x78, 0x1b, 0x50, 0xec, 0x24, 0x2c, 0x4c, 0xa3, 0xbb, 0x3b, 0xb1, 0xbf, 0xdf, 0x77,
	0xec, 0xcf, 0x39, 0xe8, 0x45, 0xc2, 0x79, 0x92, 0x81, 0x4f, 0xa8, 0xf4, 0x6d, 0x59, 0x56, 0xab,
	0xb1, 0x2f, 0x40, 0x72, 0x2d, 0x62, 0x90, 0x7e, 0x4c, 0xf2, 0x82, 0xa4, 0x09, 0x8b, 0x96, 0x9a,
	0x26, 0xa0, 0x70, 0x21, 0xb8, 0xe2, 0xee, 0xbe, 0x55, 0x63, 0x42, 0x25, 0x6e, 0x40, 0xbc, 0x1a,
	0xe3, 0x06, 0x1c, 0xbc, 0xbc, 0xca, 0x1b, 0x98, 0xce, 0xa5, 0x6f, 0xed, 0x22, 0x0a, 0x59, 0xba,
	0x02, 0x71, 0x1e, 0xe5, 0xa0, 0xce, 0x38, 0xb5, 0xf6, 0x83, 0x27, 0xd7, 0x62, 0xa5, 0x22, 0x4a,
	0xcb, 0x0a, 0xb9, 0x5f, 0x21, 0xe6, 0x6b, 0xa9, 0x4f, 0xfd, 0xaf, 0x82, 0x14, 0x05, 0x88, 0x6a,
	0xff, 0xc1, 0xef, 0x2e, 0xea, 0x1f, 0x56, 0x77, 0x99, 0x18, 0xde, 0x7d, 0x88, 0xb6, 0xeb, 0xe3,
	0x46, 0x8c, 0xe4, 0xe0, 0x39, 0x43, 0x67, 0xb4, 0x19, 0x6e, 0xd5, 0x8b, 0x9f, 0x48, 0x0e, 0xee,
	0x63, 0xd4, 0x49, 0xa9, 0xb7, 0x31, 0x74, 0x46, 0xb7, 0x0f, 0xee, 0x56, 0x77, 0xc5, 0x75, 0x13,
	0xfc, 0x8e, 0xa9, 0xe7, 0xcf, 0xe6, 0x24, 0xd3, 0x10, 0x76, 0x52, 0xea, 0x8e, 0x51, 0xd7, 0x18,
	0x75, 0x8d, 0xfc, 0xde, 0x25, 0xf9, 0x4c, 0x89, 0x94, 0x25, 0x56, 0x6f, 0x94, 0xee, 0x1b, 0xb4,
	0x4d, 0x72, 0xae, 0x99, 0x8a, 0xf2, 0x34, 0x16, 0x5c, 0x7a, 0x37, 0xd6, 0x77, 0xda, 0xb2, 0xc4,
	0xb1, 0x01, 0xdc, 0x0f, 0x68, 0x4f, 0x71, 0x45, 0xb2, 0xa8, 0xed, 0x83, 0xd6, 0xfb, 0xec, 0x1a,
	0x2e, 0xb8, 0x68, 0xf6, 0x19, 0xf5, 0x6c, 0xaa, 0x5e, 0x6f, 0xe8, 0x8c, 0xfa, 0x07, 0xaf, 0xf1,
	0x55, 0x0f, 0x6d, 0x5e, 0x02, 0xdb, 0x24, 0x67, 0x06, 0x79, 0xcb, 0x74, 0xde, 0x5a, 0x08, 0x2b,
	0x2f, 0x57, 0xa3, 0x9d, 0x7f, 0xde, 0xd9, 0xbb, 0x69, 0xec, 0x3f, 0x5e, 0xcb, 0xfe, 0xa8, 0x62,
	0x8f, 0x0d, 0x7a, 0xa1, 0x4d, 0x7b, 0x23, 0xec, 0xd3, 0xd6, 0xb7, 0x3b, 0x45, 0xbb, 0xf0, 0xad,
	0xc8, 0xd2, 0x38, 0x55, 0xd9, 0x79, 0x24, 0xcf, 0x88, 0x00, 0xea, 0xdd, 0x32, 0xb9, 0x0c, 0x2e,
	0xe5, 0x32, 0xe1, 0x3c, 0xb3, 0xb1, 0xdc, 0xf9, 0x0b, 0xcd, 0x0c, 0xe3, 0x1e, 0xa1, 0x1d, 0x01,
	0xa7, 0x20, 0x80, 0xc5, 0x10, 0xc5, 0x65, 0x5c, 0xde, 0xe6, 0xfa, 0x78, 0xfb, 0x0d, 0x73, 0x58,
	0x22, 0x93, 0x5f, 0x0e, 0x7a, 0x14, 0xf3, 0x1c, 0xaf, 0x1d, 0x9d, 0xc9, 0x5e, 0xfb, 0x47, 0x3d,
	0x29, 0xcd, 0x4f, 0x9c, 0x2f, 0xef, 0x2b, 0x32, 0xe1, 0x19, 0x61, 0x09, 0xe6, 0x22, 0xf1, 0x13,
	0x60, 0xa6, 0x75, 0x3d, 0x25, 0x45, 0x2a, 0xff, 0x33, 0xcc, 0xaf, 0x9a, 0xea, 0x7b, 0x67, 0x63,
	0x1a, 0x04, 0x3f, 0x3a, 0xfb, 0x53, 0x6b, 0x19, 0x50, 0x89, 0x6d, 0x59, 0x56, 0xf3, 0x31, 0x0e,
	0x6b, 0xe5, 0xcf, 0x5a, 0xb3, 0x08, 0xa8, 0x5c, 0x34, 0x9a, 0xc5, 0x7c, 0xbc, 0x68, 0x34, 0xcb,
	0x9e, 0x39, 0xc4, 0xd3, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x06, 0x9f, 0x5d, 0x80, 0x50, 0x04,
	0x00, 0x00,
}
