// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_DISCOVERER_H
#define _GSTREAMERMM_DISCOVERER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2011-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gstreamermm/clock.h>
#include <gst/pbutils/pbutils.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstDiscoverer = struct _GstDiscoverer;
using GstDiscovererClass = struct _GstDiscovererClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class Discoverer_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

class DiscovererInfo;
class Element;

/** Discoverer - Utility for discovering information on URIs.
 * The Discoverer is a utility object which allows to get as much information
 * as possible from one or many URIs.
 *
 * It provides two APIs, allowing usage in blocking or non-blocking mode.
 *
 * The blocking mode just requires calling discover_uri() with the URI one
 * wishes to discover.
 *
 * The non-blocking mode requires a running Glib::MainLoop iterating a
 * Glib::MainContext, where one connects to the various signals, appends the
 * URIs to be processed (through discover_uri_async()) and then
 * asks for the discovery to begin (through start()).
 * By default this will use the GLib default main context unless you have
 * set a custom context using Glib::MainContext::push_thread_default().
 *
 * All the information is returned in a DiscovererInfo structure.
 *
 * Last reviewed on 2016-05-18 (1.8.0)
 */

class Discoverer : public Glib::Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Discoverer;
  using CppClassType = Discoverer_Class;
  using BaseObjectType = GstDiscoverer;
  using BaseClassType = GstDiscovererClass;

  // noncopyable
  Discoverer(const Discoverer&) = delete;
  Discoverer& operator=(const Discoverer&) = delete;

private:  friend class Discoverer_Class;
  static CppClassType discoverer_class_;

protected:
  explicit Discoverer(const Glib::ConstructParams& construct_params);
  explicit Discoverer(GstDiscoverer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Discoverer(Discoverer&& src) noexcept;
  Discoverer& operator=(Discoverer&& src) noexcept;

  ~Discoverer() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstDiscoverer*       gobj()       { return reinterpret_cast<GstDiscoverer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstDiscoverer* gobj() const { return reinterpret_cast<GstDiscoverer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstDiscoverer* gobj_copy();

private:


protected:
  explicit Discoverer(ClockTime timeout);

public:
  
  /** Creates a new Gst::Discoverer with the provided timeout.
   * 
   * @param timeout Timeout per file, in nanoseconds. Allowed are values between
   * one second (Gst::SECOND) and one hour (3600 * Gst::SECOND).
   * @param err A pointer to a Error. can be <tt>nullptr</tt>.
   * @return The new Gst::Discoverer.
   * If an error occurred when creating the discoverer, @a err will be set
   * accordingly and <tt>nullptr</tt> will be returned. If @a err is set, the caller must
   * free it when no longer needed using Glib::error_free().
   */

  
  static Glib::RefPtr<Discoverer> create(ClockTime timeout);


  /** Allow asynchronous discovering of URIs to take place.
   * A MainLoop must be available for Gst::Discoverer to properly work in
   * asynchronous mode.
   */
  void start();
  
  /** Stop the discovery of any pending URIs and clears the list of
   * pending URIS (if any).
   */
  void stop();
  
  /** Synchronously discovers the given @a uri.
   * 
   * @param uri The URI to run on.
   * @param  If an error occurred, this field will be filled in.
   * @return The result of the scanning. Can be <tt>nullptr</tt> if an
   * error occurred.
   */
  Glib::RefPtr<Gst::DiscovererInfo> discover_uri(const Glib::ustring& uri);
  
  /** Appends the given @a uri to the list of URIs to discoverer. The actual
   * discovery of the @a uri will only take place if start() has
   * been called.
   * 
   * @param uri The URI to add.
   * @return <tt>true</tt> if the @a uri was successfully appended to the list of pending
   * uris, else <tt>false</tt>.
   */
  bool discover_uri_async(const Glib::ustring& uri);

  /** Timeout.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint64 > property_timeout() ;

/** Timeout.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint64 > property_timeout() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%discovered(const Glib::RefPtr<Gst::DiscovererInfo>& info, const Glib::Error& error)</tt>
   *
   * Will be emitted in async mode when all information on a URI could be
   * discovered, or an error occurred.
   * 
   * When an error occurs, @a info might still contain some partial information,
   * depending on the circumstances of the error.
   * 
   * @param info The results Gst::DiscovererInfo.
   */

  Glib::SignalProxy< void,const Glib::RefPtr<Gst::DiscovererInfo>&,const Glib::Error& > signal_discovered();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%finished()</tt>
   *
   * Will be emitted in async mode when all pending URIs have been processed.
   */

  Glib::SignalProxy< void > signal_finished();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%starting()</tt>
   *
   * Will be emitted when the discover starts analyzing the pending URIs
   */

  Glib::SignalProxy< void > signal_starting();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%source_setup(const Glib::RefPtr<Gst::Element>& source)</tt>
   *
   * This signal is emitted after the source element has been created for, so
   * the URI being discovered, so it can be configured by setting additional
   * properties (e.g.\ set a proxy server for an http source, or set the device
   * and read speed for an audio cd source).
   * 
   * This signal is usually emitted from the context of a GStreamer streaming
   * thread.
   * 
   * @param source Source element.
   */

  Glib::SignalProxy< void,const Glib::RefPtr<Gst::Element>& > signal_source_setup();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_discovered().
  virtual void on_discovered(const Glib::RefPtr<Gst::DiscovererInfo>& info, const Glib::Error& error);
  /// This is a default handler for the signal signal_finished().
  virtual void on_finished();
  /// This is a default handler for the signal signal_starting().
  virtual void on_starting();
  /// This is a default handler for the signal signal_source_setup().
  virtual void on_source_setup(const Glib::RefPtr<Gst::Element>& source);


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Discoverer
   */
  Glib::RefPtr<Gst::Discoverer> wrap(GstDiscoverer* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_DISCOVERER_H */

