/*
 *  Copyright (C) 2012 Felix Geyer <debfx@fobos.de>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 or (at your option)
 *  version 3 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KEEPASSX_AUTOTYPETESTINTERFACE_H
#define KEEPASSX_AUTOTYPETESTINTERFACE_H

#include "autotype/AutoTypeAction.h"

class AutoTypeTestInterface
{
public:
    virtual ~AutoTypeTestInterface()
    {
    }
    virtual void triggerGlobalAutoType() = 0;
    virtual void setActiveWindowTitle(const QString& title) = 0;

    virtual QString actionChars() = 0;
    virtual int actionCount() = 0;
    virtual void clearActions() = 0;

    virtual QString keyToString(Qt::Key key) = 0;
};

Q_DECLARE_INTERFACE(AutoTypeTestInterface, "org.keepassx.AutoTypeTestInterface/1")

#endif // KEEPASSX_AUTOTYPETESTINTERFACE_H
