/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spline;

import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class BSplineGenerator
extends GeometryGenerator {
    private static final int DEFAULT_FACETS = 16;
    private static final int DEFAULT_DEGREE = 3;
    private static int[] FACTORIALS = new int[]{1, 1, 2, 6, 24, 120, 720};
    private int facetCount;
    private float[] controlPointCoordinates;
    protected float[] controlPointWeights;
    private int numControlPoints;
    private float[] knots;
    private int numKnots;
    private int degree;
    private float[] curveCoordinates;
    private int numCurveValues;
    private boolean curveChanged;
    protected boolean useControlPointWeights;

    public BSplineGenerator() {
        this(3, 16);
    }

    public BSplineGenerator(int n) {
        this(n, 16);
    }

    public BSplineGenerator(int n, int n2) {
        if (n2 < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Degree is < 2");
        }
        this.degree = n;
        this.curveChanged = true;
        this.facetCount = n2;
        this.numControlPoints = 0;
        this.numKnots = this.degree;
        this.numCurveValues = 0;
        this.controlPointCoordinates = new float[9];
        this.controlPointWeights = new float[3];
        this.knots = new float[this.numKnots];
        this.curveCoordinates = new float[(n2 + 1) * 3];
        this.useControlPointWeights = false;
    }

    public void enableControlPointWeights(boolean bl) {
        this.useControlPointWeights = bl;
    }

    public boolean hasControlPointWeights() {
        return this.useControlPointWeights;
    }

    public void setFacetCount(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        if (this.facetCount != n) {
            this.curveChanged = true;
        }
        this.facetCount = n;
    }

    public void setWeights(float[] fArray) {
        this.setWeights(fArray, fArray.length);
    }

    public void setWeights(double[] dArray) {
        this.setWeights(dArray, dArray.length);
    }

    public void setWeights(float[] fArray, int n) {
        if (this.controlPointWeights == null || this.controlPointWeights.length < n) {
            this.controlPointWeights = new float[n];
        }
        System.arraycopy(fArray, 0, this.controlPointWeights, 0, n);
        this.curveChanged = true;
        this.useControlPointWeights = true;
    }

    public void setWeights(double[] dArray, int n) {
        if (this.controlPointWeights == null || this.controlPointWeights.length < n) {
            this.controlPointWeights = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            this.controlPointWeights[i] = (float)dArray[i];
        }
        this.curveChanged = true;
        this.useControlPointWeights = true;
    }

    public void setControlPoints(float[] fArray) {
        this.setControlPoints(fArray, fArray.length / 3);
    }

    public void setControlPoints(double[] dArray) {
        this.setControlPoints(dArray, dArray.length / 3);
    }

    public void setControlPoints(float[] fArray, float[] fArray2) {
        this.setControlPoints(fArray, fArray.length / 3, fArray2);
    }

    public void setControlPoints(double[] dArray, double[] dArray2) {
        this.setControlPoints(dArray, dArray.length / 3, dArray2);
    }

    public void setControlPoints(float[] fArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of valid points < 1");
        }
        if (n * 3 > this.controlPointCoordinates.length) {
            this.controlPointCoordinates = new float[n * 3];
        }
        System.arraycopy(fArray, 0, this.controlPointCoordinates, 0, n * 3);
        this.numControlPoints = n;
        if (this.controlPointWeights == null || n > this.controlPointWeights.length) {
            float[] fArray2 = new float[fArray.length];
            if (this.controlPointWeights.length != 0) {
                int n2 = n < this.controlPointWeights.length ? n : this.controlPointWeights.length;
                System.arraycopy(this.controlPointWeights, 0, fArray2, 0, n2);
            }
            this.controlPointWeights = fArray2;
        }
        this.curveChanged = true;
    }

    public void setControlPoints(double[] dArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of valid points < 1");
        }
        if (n * 3 > this.controlPointCoordinates.length) {
            this.controlPointCoordinates = new float[n * 3];
        }
        for (int i = 0; i < n * 3; ++i) {
            this.controlPointCoordinates[i] = (float)dArray[i];
            this.controlPointCoordinates[++i] = (float)dArray[i];
            this.controlPointCoordinates[++i] = (float)dArray[i];
        }
        this.numControlPoints = n;
        if (this.controlPointWeights == null || n > this.controlPointWeights.length) {
            float[] fArray = new float[n];
            if (this.controlPointWeights.length != 0) {
                int n2 = n < this.controlPointWeights.length ? n : this.controlPointWeights.length;
                System.arraycopy(this.controlPointWeights, 0, fArray, 0, n2);
            }
            this.controlPointWeights = fArray;
        }
        this.curveChanged = true;
    }

    public void setControlPoints(float[] fArray, int n, float[] fArray2) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of valid points < 1");
        }
        if (n * 3 > this.controlPointCoordinates.length) {
            this.controlPointCoordinates = new float[n * 3];
        }
        System.arraycopy(fArray, 0, this.controlPointCoordinates, 0, n * 3);
        this.numControlPoints = n;
        if (this.controlPointWeights == null || this.controlPointWeights.length < n) {
            this.controlPointWeights = new float[n];
        }
        System.arraycopy(fArray2, 0, this.controlPointWeights, 0, n);
        this.curveChanged = true;
        this.useControlPointWeights = true;
    }

    public void setControlPoints(double[] dArray, int n, double[] dArray2) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Number of valid points < 1");
        }
        if (n * 3 > this.controlPointCoordinates.length) {
            this.controlPointCoordinates = new float[n * 3];
        }
        for (n2 = 0; n2 < n * 3; ++n2) {
            this.controlPointCoordinates[n2] = (float)dArray[n2];
            this.controlPointCoordinates[++n2] = (float)dArray[n2];
            this.controlPointCoordinates[++n2] = (float)dArray[n2];
        }
        this.numControlPoints = n;
        if (this.controlPointWeights == null || this.controlPointWeights.length < n) {
            this.controlPointWeights = new float[n];
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.controlPointWeights[n2] = (float)dArray2[n2];
        }
        this.curveChanged = true;
        this.useControlPointWeights = true;
    }

    public void setKnots(int n, float[] fArray) {
        if (n < 2) {
            throw new IllegalArgumentException("Degree is < 2");
        }
        if (fArray.length < this.numControlPoints + n + 1) {
            throw new IllegalArgumentException("knts.length < n + k + 1");
        }
        this.degree = n;
        if (fArray.length > this.knots.length) {
            this.knots = new float[fArray.length];
        }
        System.arraycopy(fArray, 0, this.knots, 0, fArray.length);
        this.numKnots = this.knots.length;
        this.curveChanged = true;
    }

    public void setKnots(int n, double[] dArray) {
        if (n < 2) {
            throw new IllegalArgumentException("Degree is < 2");
        }
        if (dArray.length < this.numControlPoints + n + 1) {
            throw new IllegalArgumentException("knts.length < n + k + 1");
        }
        this.degree = n;
        if (dArray.length > this.knots.length) {
            this.knots = new float[dArray.length];
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.knots[i] = (float)dArray[i];
        }
        this.numKnots = this.knots.length;
        this.curveChanged = true;
    }

    public int getDegree() {
        return this.degree;
    }

    public void generateSmoothKnots(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Degree is < 2");
        }
        if (n != this.degree) {
            this.degree = n;
            this.curveChanged = true;
        }
        this.generateSmoothKnots();
    }

    public void generateSmoothKnots() {
        this.numKnots = this.numControlPoints + this.degree + 1;
        if (this.knots.length < this.numKnots) {
            this.knots = new float[this.numKnots];
        }
        for (int i = 0; i < this.numKnots; ++i) {
            if (i <= this.degree) {
                this.knots[i] = 0.0f;
                continue;
            }
            if (i < this.numControlPoints) {
                this.knots[i] = i - this.degree + 1;
                continue;
            }
            if (i < this.numControlPoints) continue;
            this.knots[i] = this.numControlPoints - this.degree + 1;
        }
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 9: {
                n = (this.facetCount + 1) * 2;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n = this.facetCount + 1;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 9: {
                this.unindexedLines(geometryData);
                break;
            }
            case 10: {
                this.lineStrips(geometryData);
                break;
            }
            case 11: {
                this.indexedLines(geometryData);
                break;
            }
            case 12: {
                this.indexedLineStrips(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedLines(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
    }

    private void indexedLines(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        int n = (this.facetCount + 1) * 2;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Index values", geometryData.coordinates.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3++] = n2++;
            nArray[n3++] = n2;
        }
    }

    private void lineStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[1];
        } else if (geometryData.stripCounts.length < 1) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, 1);
        }
        geometryData.numStrips = 1;
        geometryData.stripCounts[0] = this.facetCount + 1;
    }

    private void indexedLineStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        int n = (this.facetCount + 1) * 2;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Index values", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3++] = n2++;
            nArray[n3++] = n2;
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[1];
        } else if (geometryData.stripCounts.length < 1) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, 1);
        }
        geometryData.numStrips = 1;
        geometryData.stripCounts[0] = this.facetCount + 1;
    }

    private void generateUnindexedLineCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateCurve();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.facetCount; ++i) {
            fArray[n2] = this.curveCoordinates[n3];
            fArray[++n2] = this.curveCoordinates[n3 + 1];
            fArray[++n2] = this.curveCoordinates[n3 + 2];
            fArray[++n2] = this.curveCoordinates[n3 + 3];
            fArray[++n2] = this.curveCoordinates[n3 + 4];
            fArray[++n2] = this.curveCoordinates[n3 + 5];
            ++n2;
            n3 += 3;
        }
    }

    private void generateIndexedLineCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateCurve();
        System.arraycopy(this.curveCoordinates, 0, fArray, 0, this.numCurveValues);
    }

    private void generateUnindexedLineNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
    }

    private void generateIndexedLineNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
    }

    private void generateLineTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateLineTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private final void regenerateCurve() {
        if (!this.curveChanged) {
            return;
        }
        this.curveChanged = false;
        this.numCurveValues = (this.facetCount + 1) * 3;
        if (this.curveCoordinates == null || this.numCurveValues > this.curveCoordinates.length) {
            this.curveCoordinates = new float[this.numCurveValues];
        }
        double d = 0.0;
        double d2 = (double)this.knots[this.numKnots - 1] / (double)(this.facetCount + 1);
        int n = 0;
        if (this.useControlPointWeights) {
            for (int i = 0; i <= this.facetCount; ++i) {
                this.calcSingleRationalPoint(d, n);
                d += d2;
                n += 3;
            }
        } else {
            for (int i = 0; i <= this.facetCount; ++i) {
                this.calcSingleNonRationalPoint(d, n);
                d += d2;
                n += 3;
            }
        }
    }

    private void calcSingleNonRationalPoint(double d, int n) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = this.degree + 1;
        for (int i = 0; i < this.numControlPoints; ++i) {
            double d5 = this.splineBlend(i, n2, d);
            d2 += (double)this.controlPointCoordinates[i * 3] * d5;
            d3 += (double)this.controlPointCoordinates[i * 3 + 1] * d5;
            d4 += (double)this.controlPointCoordinates[i * 3 + 2] * d5;
        }
        this.curveCoordinates[n] = (float)d2;
        this.curveCoordinates[n + 1] = (float)d3;
        this.curveCoordinates[n + 2] = (float)d4;
    }

    private void calcSingleRationalPoint(double d, int n) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = this.degree + 1;
        for (int i = 0; i < this.numControlPoints; ++i) {
            double d7 = this.splineBlend(i, n2, d);
            d5 = this.controlPointWeights[i];
            d2 += (double)this.controlPointCoordinates[i * 3] * d7 * d5;
            d3 += (double)this.controlPointCoordinates[i * 3 + 1] * d7 * d5;
            d4 += (double)this.controlPointCoordinates[i * 3 + 2] * d7 * d5;
            d6 += d7 * d5;
        }
        if (d6 != 0.0) {
            this.curveCoordinates[n] = (float)(d2 / d6);
            this.curveCoordinates[n + 1] = (float)(d3 / d6);
            this.curveCoordinates[n + 2] = (float)(d4 / d6);
        } else {
            this.curveCoordinates[n] = (float)d2;
            this.curveCoordinates[n + 1] = (float)d3;
            this.curveCoordinates[n + 2] = (float)d4;
        }
    }

    private double splineBlend(int n, int n2, double d) {
        double d2;
        float[] fArray = this.knots;
        if (n2 == 1) {
            d2 = (double)fArray[n] <= d && d < (double)fArray[n + 1] ? 1.0 : 0.0;
        } else {
            double d3 = this.splineBlend(n, n2 - 1, d);
            double d4 = this.splineBlend(n + 1, n2 - 1, d);
            double d5 = fArray[n + n2 - 1] - fArray[n];
            double d6 = fArray[n + n2] - fArray[n + 1];
            double d7 = d3 != 0.0 ? (d - (double)fArray[n]) / d5 * d3 : 0.0;
            double d8 = d4 != 0.0 ? ((double)fArray[n + n2] - d) / d6 * d4 : 0.0;
            d2 = d7 + d8;
        }
        return d2;
    }
}

