/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.MetadataStore;
import loci.formats.TiffRational;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class GelReader
extends BaseTiffReader {
    private static final int MD_FILETAG = 33445;
    private static final int MD_SCALE_PIXEL = 33446;
    private static final int MD_LAB_NAME = 33448;
    private static final int MD_SAMPLE_INFO = 33449;
    private static final int MD_PREP_DATE = 33450;
    private static final int MD_PREP_TIME = 33451;
    private static final int MD_FILE_UNITS = 33452;

    public GelReader() {
        super("Molecular Dynamics GEL TIFF", new String[]{"gel"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.core.imageCount[0] = this.core.imageCount[0] - 1;
        try {
            long fmt = TiffTools.getIFDLongValue(this.ifds[1], 33445, true, 128L);
            this.addMeta("Data format", fmt == 2L ? "square root" : "linear");
        }
        catch (FormatException exc) {
            this.trace(exc);
        }
        TiffRational scale = (TiffRational)TiffTools.getIFDValue(this.ifds[1], 33446);
        this.addMeta("Scale factor", scale == null ? new TiffRational(1L, 1L) : scale);
        String lab = (String)TiffTools.getIFDValue(this.ifds[1], 33448);
        this.addMeta("Lab name", lab == null ? "unknown" : lab);
        String info = (String)TiffTools.getIFDValue(this.ifds[1], 33449);
        this.addMeta("Sample info", info == null ? "unknown" : info);
        String prepDate = (String)TiffTools.getIFDValue(this.ifds[1], 33450);
        this.addMeta("Date prepared", prepDate == null ? "unknown" : prepDate);
        String prepTime = (String)TiffTools.getIFDValue(this.ifds[1], 33451);
        this.addMeta("Time prepared", prepTime == null ? "unknown" : prepTime);
        String units = (String)TiffTools.getIFDValue(this.ifds[1], 33452);
        this.addMeta("File units", units == null ? "unknown" : units);
        this.core.sizeT[this.series] = this.core.imageCount[this.series];
        MetadataStore store = this.getMetadataStore();
        store.setDimensions(new Float(scale.floatValue()), new Float(scale.floatValue()), null, null, null, null);
    }
}

