/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.MJPBCodec;
import loci.formats.codec.QTRLECodec;
import loci.formats.codec.RPZACodec;
import loci.formats.in.LegacyQTReader;

public class QTReader
extends FormatReader {
    private static final String[] CONTAINER_TYPES = new String[]{"moov", "trak", "udta", "tref", "imap", "mdia", "minf", "stbl", "edts", "mdra", "rmra", "imag", "vnrp", "dinf"};
    private int pixelOffset;
    private int pixelBytes;
    private int bitsPerPixel;
    private int rawSize;
    private Vector offsets;
    private byte[] prevPixels;
    private int prevPlane;
    private boolean canUsePrevious;
    private String codec;
    private String altCodec;
    private int altPlanes;
    private LegacyQTReader legacy;
    private boolean useLegacy;
    private int scale;
    private Vector chunkSizes;
    private boolean interlaced;
    private boolean spork;
    private boolean flip;

    public QTReader() {
        super("QuickTime", "mov");
    }

    public void setLegacy(boolean legacy) {
        this.useLegacy = legacy;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 1);
        super.setMetadataStore(store);
        if (this.useLegacy) {
            this.legacy.setMetadataStore(store);
        }
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        int size;
        boolean doLegacy;
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        String code = this.codec;
        if (no >= this.getImageCount() - this.altPlanes) {
            code = this.altCodec;
        }
        if (!((doLegacy = this.useLegacy) || code.equals("raw ") || code.equals("rle ") || code.equals("jpeg") || code.equals("mjpb") || code.equals("rpza"))) {
            if (debug) {
                this.debug("Unsupported codec (" + code + "); using QTJava reader");
            }
            doLegacy = true;
        }
        if (doLegacy) {
            if (this.legacy == null) {
                this.legacy = this.createLegacyReader();
            }
            this.legacy.setId(this.currentId);
            return this.legacy.openBytes(no);
        }
        int offset = (Integer)this.offsets.get(no);
        int nextOffset = this.pixelBytes;
        this.scale = (Integer)this.offsets.get(0);
        offset -= this.scale;
        if (no < this.offsets.size() - 1) {
            nextOffset = (Integer)this.offsets.get(no + 1);
            nextOffset -= this.scale;
        }
        if (nextOffset - offset < 0) {
            int temp = offset;
            offset = nextOffset;
            nextOffset = temp;
        }
        byte[] pixs = new byte[nextOffset - offset];
        this.in.seek(this.pixelOffset + offset);
        this.in.read(pixs);
        this.canUsePrevious = this.prevPixels != null && this.prevPlane == no - 1 && !code.equals(this.altCodec);
        buf = this.uncompress(pixs, code);
        if (code.equals("rpza")) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(255 - buf[i]);
            }
            this.prevPlane = no;
            return buf;
        }
        if (this.canUsePrevious && this.prevPixels.length < buf.length) {
            byte[] temp = buf;
            buf = new byte[this.prevPixels.length];
            System.arraycopy(temp, 0, buf, 0, buf.length);
        }
        this.prevPixels = buf;
        this.prevPlane = no;
        int pad = this.core.sizeX[0] % 4;
        pad = (4 - pad) % 4;
        if (this.codec.equals("mjpb")) {
            pad = 0;
        }
        if ((size = this.core.sizeX[0] * this.core.sizeY[0]) * (this.bitsPerPixel / 8) == this.prevPixels.length) {
            pad = 0;
        }
        if (pad > 0) {
            buf = new byte[this.prevPixels.length - this.core.sizeY[0] * pad];
            for (int row = 0; row < this.core.sizeY[0]; ++row) {
                System.arraycopy(this.prevPixels, row * (this.core.sizeX[0] + pad), buf, row * this.core.sizeX[0], this.core.sizeX[0]);
            }
        }
        if (!(this.bitsPerPixel != 40 && this.bitsPerPixel != 8 || code.equals("mjpb"))) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(255 - buf[i]);
            }
            return buf;
        }
        if (this.bitsPerPixel == 32) {
            byte[][] data = new byte[3][buf.length / 4];
            for (int i = 0; i < data[0].length; ++i) {
                data[0][i] = buf[4 * i + 1];
                data[1][i] = buf[4 * i + 2];
                data[2][i] = buf[4 * i + 3];
            }
            byte[] rtn = new byte[data.length * data[0].length];
            for (int i = 0; i < data.length; ++i) {
                System.arraycopy(data[i], 0, rtn, i * data[0].length, data[i].length);
            }
            return rtn;
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        boolean doLegacy;
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        String code = this.codec;
        if (no >= this.getImageCount() - this.altPlanes) {
            code = this.altCodec;
        }
        if (!((doLegacy = this.useLegacy) || code.equals("raw ") || code.equals("rle ") || code.equals("jpeg") || code.equals("mjpb") || code.equals("rpza"))) {
            if (debug) {
                this.debug("Unsupported codec (" + code + "); using QTJava reader");
            }
            doLegacy = true;
        }
        if (doLegacy) {
            if (this.legacy == null) {
                this.legacy = this.createLegacyReader();
            }
            this.legacy.setId(this.currentId);
            return this.legacy.openImage(no);
        }
        int bpp = this.bitsPerPixel / 8;
        if (bpp == 3 || bpp == 4 || bpp == 5) {
            bpp = 1;
        }
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], false, bpp, this.core.littleEndian[0]);
    }

    public void close() throws IOException {
        super.close();
        this.prevPixels = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("QTReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.spork = true;
        this.offsets = new Vector();
        this.chunkSizes = new Vector();
        this.status("Parsing tags");
        Exception exc = null;
        try {
            this.parse(0, 0L, this.in.length());
        }
        catch (FormatException e) {
            exc = e;
        }
        catch (IOException e) {
            exc = e;
        }
        if (exc != null) {
            if (debug) {
                this.trace(exc);
            }
            this.useLegacy = true;
            this.legacy = this.createLegacyReader();
            this.legacy.setId(id, true);
            this.core = this.legacy.getCoreMetadata();
            return;
        }
        this.core.imageCount[0] = this.offsets.size();
        if (this.chunkSizes.size() < this.core.imageCount[0] && this.chunkSizes.size() > 0) {
            this.core.imageCount[0] = this.chunkSizes.size();
        }
        this.status("Populating metadata");
        int bytesPerPixel = this.bitsPerPixel / 8;
        switch (bytesPerPixel %= 4) {
            case 0: 
            case 1: 
            case 3: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 2: {
                this.core.pixelType[0] = 3;
            }
        }
        this.core.rgb[0] = this.bitsPerPixel < 40;
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = this.core.rgb[0] ? 3 : 1;
        this.core.sizeT[0] = this.core.imageCount[0];
        this.core.currentOrder[0] = "XYCZT";
        this.core.littleEndian[0] = false;
        this.core.interleaved[0] = false;
        this.core.metadataComplete[0] = true;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
        if (this.spork) {
            String base = null;
            base = id.indexOf(".") != -1 ? id.substring(0, id.lastIndexOf(".")) : id;
            Location f = new Location(base + ".qtr");
            if (f.exists()) {
                this.in = new RandomAccessStream(f.getAbsolutePath());
                this.stripHeader();
                this.parse(0, 0L, this.in.length());
                this.core.imageCount[0] = this.offsets.size();
                return;
            }
            f = new Location(base.substring(0, base.lastIndexOf(File.separator) + 1) + "._" + base.substring(base.lastIndexOf(File.separator) + 1));
            if (f.exists()) {
                this.in = new RandomAccessStream(f.getAbsolutePath());
                this.stripHeader();
                this.parse(0, 0L, this.in.length());
                this.core.imageCount[0] = this.offsets.size();
                return;
            }
            f = new Location(base + "/rsrc");
            if (f.exists()) {
                this.in = new RandomAccessStream(f.getAbsolutePath());
                this.stripHeader();
                this.parse(0, 0L, this.in.length());
                this.core.imageCount[0] = this.offsets.size();
                return;
            }
            throw new FormatException("QuickTime resource fork not found.  To avoid this issue, please flatten your QuickTime movies before importing with Bio-Formats.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(int depth, long offset, long length) throws FormatException, IOException {
        while (offset < length) {
            this.in.seek(offset);
            long atomSize = this.in.readInt();
            if (atomSize < 0L) {
                atomSize += 0x100000000L;
            }
            String atomType = this.in.readString(4);
            if (atomSize == 1L) {
                atomSize = this.in.readLong();
            }
            if (atomSize < 0L) {
                LogTools.println("QTReader: invalid atom size: " + atomSize);
            }
            if (debug) {
                this.debug("Seeking to " + offset + "; atomType=" + atomType + "; atomSize=" + atomSize);
            }
            byte[] data = new byte[]{};
            if (this.isContainer(atomType)) {
                this.parse(depth++, this.in.getFilePointer(), offset + atomSize);
            } else {
                int i;
                int i2;
                if (atomSize == 0L) {
                    atomSize = this.in.length();
                }
                int oldpos = (int)this.in.getFilePointer();
                if (atomType.equals("mdat")) {
                    this.pixelOffset = (int)this.in.getFilePointer();
                    this.pixelBytes = (int)atomSize;
                    if ((long)this.pixelBytes > this.in.length() - (long)this.pixelOffset) {
                        this.pixelBytes = (int)(this.in.length() - (long)this.pixelOffset);
                    }
                } else if (atomType.equals("tkhd")) {
                    this.in.skipBytes(38);
                    int[][] matrix = new int[3][3];
                    for (i2 = 0; i2 < matrix.length; ++i2) {
                        for (int j = 0; j < matrix[0].length; ++j) {
                            matrix[i2][j] = this.in.readInt();
                        }
                    }
                    boolean bl = this.flip = matrix[0][0] == 0 && matrix[1][0] != 0;
                    if (this.core.sizeX[0] == 0) {
                        this.core.sizeX[0] = this.in.readInt();
                    }
                    if (this.core.sizeY[0] == 0) {
                        this.core.sizeY[0] = this.in.readInt();
                    }
                } else if (atomType.equals("cmov")) {
                    this.in.skipBytes(8);
                    byte[] b = new byte[4];
                    this.in.read(b);
                    if (!"zlib".equals(new String(b))) throw new FormatException("Compressed header not supported.");
                    atomSize = this.in.readInt();
                    this.in.skipBytes(4);
                    int uncompressedSize = this.in.readInt();
                    b = new byte[(int)(atomSize - 12L)];
                    this.in.read(b);
                    Inflater inf = new Inflater();
                    inf.setInput(b, 0, b.length);
                    byte[] output = new byte[uncompressedSize];
                    try {
                        inf.inflate(output);
                    }
                    catch (DataFormatException exc) {
                        if (!debug) throw new FormatException("Compressed header not supported.");
                        this.trace(exc);
                        throw new FormatException("Compressed header not supported.");
                    }
                    inf.end();
                    RandomAccessStream oldIn = this.in;
                    this.in = new RandomAccessStream(output);
                    this.parse(0, 0L, output.length);
                    this.in.close();
                    this.in = oldIn;
                } else if (atomType.equals("stco")) {
                    if (this.offsets.size() > 0) return;
                    this.spork = false;
                    this.in.readInt();
                    int numPlanes = this.in.readInt();
                    if (numPlanes != this.core.imageCount[0]) {
                        this.in.seek(this.in.getFilePointer() - 4L);
                        int off = this.in.readInt();
                        this.offsets.add(new Integer(off));
                        for (i = 1; i < this.core.imageCount[0]; ++i) {
                            if (this.chunkSizes.size() > 0 && i < this.chunkSizes.size()) {
                                this.rawSize = (Integer)this.chunkSizes.get(i);
                            } else {
                                i = this.core.imageCount[0];
                            }
                            this.offsets.add(new Integer(off += this.rawSize));
                        }
                    } else {
                        for (i2 = 0; i2 < numPlanes; ++i2) {
                            this.offsets.add(new Integer(this.in.readInt()));
                        }
                    }
                } else if (atomType.equals("stsd")) {
                    this.in.readInt();
                    int numEntries = this.in.readInt();
                    this.in.readInt();
                    for (i2 = 0; i2 < numEntries; ++i2) {
                        if (i2 == 0) {
                            this.codec = this.in.readString(4);
                            if (!(this.codec.equals("raw ") || this.codec.equals("rle ") || this.codec.equals("rpza") || this.codec.equals("mjpb") || this.codec.equals("jpeg"))) {
                                throw new FormatException("Unsupported codec: " + this.codec);
                            }
                            this.in.skipBytes(16);
                            if (this.in.readShort() != 0) continue;
                            this.in.skipBytes(56);
                            this.bitsPerPixel = this.in.readShort();
                            if (this.codec.equals("rpza")) {
                                this.bitsPerPixel = 8;
                            }
                            this.in.readShort();
                            this.in.readDouble();
                            int fieldsPerPlane = this.in.read();
                            this.interlaced = fieldsPerPlane == 2;
                            this.addMeta("Codec", this.codec);
                            this.addMeta("Bits per pixel", new Integer(this.bitsPerPixel));
                            this.in.readDouble();
                            this.in.read();
                            continue;
                        }
                        this.altCodec = this.in.readString(4);
                        this.addMeta("Second codec", this.altCodec);
                    }
                } else if (atomType.equals("stsz")) {
                    this.in.readInt();
                    this.rawSize = this.in.readInt();
                    this.core.imageCount[0] = this.in.readInt();
                    if (this.rawSize == 0) {
                        this.in.seek(this.in.getFilePointer() - 4L);
                        for (int b = 0; b < this.core.imageCount[0]; ++b) {
                            this.chunkSizes.add(new Integer(this.in.readInt()));
                        }
                    }
                } else if (atomType.equals("stsc")) {
                    this.in.readInt();
                    int numChunks = this.in.readInt();
                    if (this.altCodec != null) {
                        int prevChunk = 0;
                        for (i = 0; i < numChunks; ++i) {
                            int chunk = this.in.readInt();
                            int planesPerChunk = this.in.readInt();
                            int id = this.in.readInt();
                            if (id == 2) {
                                this.altPlanes += planesPerChunk * (chunk - prevChunk);
                            }
                            prevChunk = chunk;
                        }
                    }
                } else if (atomType.equals("stts")) {
                    this.in.readDouble();
                    this.in.readInt();
                    int fps = this.in.readInt();
                    this.addMeta("Frames per second", new Integer(fps));
                }
                if ((long)oldpos + atomSize >= this.in.length()) return;
                this.in.seek((long)oldpos + atomSize);
            }
            offset = atomSize == 0L ? this.in.length() : (offset += atomSize);
            if (atomType.equals("udta")) {
                offset += 4L;
            }
            if (!debug) continue;
            this.print(depth, atomSize, atomType, data);
        }
    }

    private boolean isContainer(String type) {
        for (int i = 0; i < CONTAINER_TYPES.length; ++i) {
            if (!type.equals(CONTAINER_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    private void print(int depth, long size, String type, byte[] data) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(" ");
        }
        sb.append(type + " : [" + size + "]");
        this.debug(sb.toString());
    }

    private byte[] uncompress(byte[] pixs, String code) throws FormatException, IOException {
        if (code.equals("raw ")) {
            return pixs;
        }
        if (code.equals("rle ")) {
            Object[] options = new Object[]{new int[]{this.core.sizeX[0], this.core.sizeY[0], this.bitsPerPixel < 40 ? this.bitsPerPixel / 8 : (this.bitsPerPixel - 32) / 8}, this.canUsePrevious ? this.prevPixels : null};
            return new QTRLECodec().decompress(pixs, (Object)options);
        }
        if (code.equals("rpza")) {
            int[] options = new int[]{this.core.sizeX[0], this.core.sizeY[0]};
            return new RPZACodec().decompress(pixs, (Object)options);
        }
        if (code.equals("mjpb")) {
            int[] options = new int[]{this.core.sizeX[0], this.core.sizeY[0], this.bitsPerPixel, this.interlaced ? 1 : 0};
            return new MJPBCodec().decompress(pixs, (Object)options);
        }
        if (code.equals("jpeg")) {
            return new JPEGCodec().decompress(pixs);
        }
        throw new FormatException("Unsupported codec : " + code);
    }

    private void stripHeader() throws IOException {
        String test = null;
        boolean found = false;
        while (!found && this.in.getFilePointer() < this.in.length() - 4L) {
            test = this.in.readString(4);
            if (test.equals("moov")) {
                found = true;
                this.in.seek(this.in.getFilePointer() - 8L);
                continue;
            }
            this.in.seek(this.in.getFilePointer() - 3L);
        }
    }

    private LegacyQTReader createLegacyReader() {
        return new LegacyQTReader();
    }
}

