/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.MetadataRetrieve;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.out.TiffWriter;

public class OMETiffWriter
extends TiffWriter {
    public OMETiffWriter() {
        super("OME-TIFF", new String[]{"ome.tif", "ome.tiff"});
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        if (this.currentId != null) {
            MetadataRetrieve retrieve = this.getMetadataRetrieve();
            String xml = MetadataTools.getOMEXML(retrieve);
            int pix = xml.indexOf("<Pixels ");
            int end = xml.indexOf("/>", pix);
            xml = xml.substring(0, end) + "><TiffData/></Pixels>" + xml.substring(end + 2);
            try {
                TiffTools.overwriteComment(this.currentId, xml);
            }
            catch (FormatException exc) {
                IOException io = new IOException("Unable to append OME-XML comment");
                io.initCause(exc);
                throw io;
            }
        }
        super.close();
    }
}

