/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import ucar.multiarray.MultiArray;
import ucar.multiarray.StringCharAdapter;
import ucar.netcdf.Variable;
import visad.Scalar;
import visad.ScalarType;
import visad.Text;
import visad.TextType;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.InvalidContextException;
import visad.data.netcdf.in.VirtualScalar;

public class VirtualText
extends VirtualScalar {
    StringCharAdapter stringVar = null;

    public VirtualText(ScalarType type, Variable var) {
        super(type, var);
        this.stringVar = new StringCharAdapter((MultiArray)var, ' ');
    }

    protected Scalar getScalar(Context context) throws VisADException, InvalidContextException, IOException {
        String[] values = this.getStrings(context);
        if (values.length != 1) {
            System.out.println(this.getScalarType());
            throw new InvalidContextException(context);
        }
        return new Text((TextType)this.getScalarType(), values[0].trim());
    }

    private String[] getStrings(Context context) throws IOException, VisADException {
        int[] lengths = this.stringVar.getLengths();
        int rank = lengths.length;
        int[] ioOrigin = new int[rank];
        int[] ioShape = new int[rank];
        int[] ioContext = context.getContext();
        System.arraycopy(ioContext, 0, ioOrigin, 0, ioContext.length);
        for (int i = 0; i < ioContext.length; ++i) {
            ioShape[i] = 1;
        }
        int total = 1;
        for (int i = ioContext.length; i < rank; ++i) {
            ioOrigin[i] = 0;
            ioShape[i] = lengths[i];
            total *= lengths[i];
        }
        String[] values = new String[total];
        return (String[])this.stringVar.toArray((Object)values, ioOrigin, ioShape);
    }

    public Object clone() {
        return new VirtualText((TextType)this.getScalarType(), this.getVariable());
    }
}

