/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryDoubleArray
implements BinaryObject {
    private static final boolean fasterButUglier = true;

    public static final int computeBytes(double[] array) {
        return array == null ? 0 : 4 + array.length * 8;
    }

    public static final double[] read(BinaryReader reader) throws IOException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad double array length " + len + ")");
        }
        double[] array = new double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = file.readDouble();
        }
        return array;
    }

    public static final void write(BinaryWriter writer, double[] array, Object token) throws IOException {
        DataOutput file = writer.getOutput();
        byte[] buf = new byte[BinaryDoubleArray.computeBytes(array)];
        int bufIdx = 0;
        int l = array.length;
        for (int b = 3; b >= 0; --b) {
            buf[bufIdx + b] = (byte)(l & 0xFF);
            l >>= 8;
        }
        bufIdx += 4;
        for (int i = 0; i < array.length; ++i) {
            long x = Double.doubleToLongBits(array[i]);
            for (int b = 7; b >= 0; --b) {
                buf[bufIdx + b] = (byte)(x & 0xFFL);
                x >>= 8;
            }
            bufIdx += 8;
        }
        if (bufIdx < buf.length) {
            System.err.println("BinaryDoubleArray: Missing " + (buf.length - bufIdx) + " bytes");
        }
        file.write(buf);
    }
}

