% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integerutil.R
\name{get_length}
\alias{get_length}
\title{Get C length of a vector}
\usage{
get_length(x)
}
\arguments{
\item{x}{a vector}
}
\value{
integer scalar
}
\description{
Gets C length of a vector ignoring any length-methods dispatched by classes
}
\details{
Queries the vector length using C-macro \code{LENGTH}, this can be substantially faster than \code{length(unclass(x))}
}
\examples{
length(bit(12))
get_length(bit(12))
}
