% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_matching.R
\name{request-matching}
\alias{request-matching}
\title{vcr request matching}
\description{
There are a number of options, some of which are on by default, some of
which can be used together, and some alone.
}
\section{matching on method}{

Use the \strong{method} request matcher to match requests on the HTTP method
(i.e. GET, POST, PUT, DELETE, etc). You will generally want to use
this matcher. The \strong{method} matcher is used (along with the \strong{uri} matcher)
by default if you do not specify how requests should match.
}

\section{matching on uri}{

Use the \strong{uri} request matcher to match requests on the request URI. The
\strong{uri} matcher is used (along with the \strong{method} matcher) by default
if you do not specify how requests should match.
}

\section{matching on host}{

Use the \strong{host} request matcher to match requests on the request host.
You can use this (alone, or in combination with \strong{path}) as an
alternative to \strong{uri} so that non-deterministic portions of the URI
are not considered as part of the request matching.
}

\section{matching on path}{

Use the \strong{path} request matcher to match requests on the path portion
of the request URI. You can use this (alone, or in combination with \strong{host})
as an alternative to \strong{uri} so that non-deterministic portions of the URI
}

\section{matching on query string}{

Use the \strong{query} request matcher to match requests on the query string
portion of the request URI. You can use this (alone, or in combination with
others) as an alternative to \strong{uri} so that non-deterministic portions of
the URI are not considered as part of the request matching.
}

\section{matching on body}{

Use the \strong{body} request matcher to match requests on the request body.
}

\section{matching on headers}{

Use the \strong{headers} request matcher to match requests on the request headers.
}

