//  SuperTux
//  Copyright (C) 2016 Hume2 <teratux.mail@gmail.com>
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef HEADER_SUPERTUX_EDITOR_MARKER_OBJECT_HPP
#define HEADER_SUPERTUX_EDITOR_MARKER_OBJECT_HPP

#include "supertux/moving_object.hpp"

class DrawingContext;

class MarkerObject : public MovingObject
{
public:
  MarkerObject(const Vector& pos);
  MarkerObject();

  virtual void update(float dt_sec) override {}
  virtual void draw(DrawingContext& context) override;

  virtual HitResponse collision(GameObject& other, const CollisionHit& hit) override { return FORCE_MOVE; }

  virtual Vector get_point_vector() const = 0;
  virtual Vector get_offset() const = 0;

  virtual bool is_saveable() const override { return false; }

private:
  MarkerObject(const MarkerObject&) = delete;
  MarkerObject& operator=(const MarkerObject&) = delete;
};

#endif

/* EOF */
