/*
 * Copyright 2013 Google Inc.

 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef SkPdfMapper_DEFINED
#define SkPdfMapper_DEFINED

#include "SkPdfHeaders_autogen.h"
#include "SkPdfNativeDoc.h"
#include "SkPdfNativeObject.h"
class SkPdfMapper {
public:
  SkPdfMapper() {}

  SkPdfNativeObjectType mapDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapXObjectDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFontDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapTrueTypeFontDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapStreamCommonDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapLzwdecodeAndFlatedecodeFiltersDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCcittfaxdecodeFilterDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapJbig2DecodeFilterDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapDctdecodeFilterDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFileTrailerDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapEncryptionCommonDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapStandardSecurityHandlerDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCatalogDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPageTreeNodeDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPageObjectDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapNameDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapResourceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapNameTreeNodeDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapNumberTreeNodeDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFunctionCommonDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType0FunctionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType2FunctionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType3FunctionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFileSpecificationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapEmbeddedFileStreamDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapEmbeddedFileParameterDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMacOsFileInformationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapGraphicsStateDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCalgrayColorSpaceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCalrgbColorSpaceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapLabColorSpaceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapIccProfileStreamDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapDeviceNColorSpaceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType1PatternDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType2PatternDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapShadingDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType1ShadingDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType2ShadingDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType3ShadingDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType4ShadingDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType5ShadingDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType6ShadingDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapImageDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapAlternateImageDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType1FormDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapGroupAttributesDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapReferenceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPSXobjectDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType1FontDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType3FontDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapEncodingDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCIDSystemInfoDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCIDFontDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCMapDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType0FontDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFontDescriptorDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCIDFontDescriptorDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapEmbeddedFontStreamDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType1HalftoneDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType6HalftoneDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType10HalftoneDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType16HalftoneDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapType5HalftoneDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSoftMaskDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSoftMaskImageDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapTransparencyGroupDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapViewerPreferencesDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapOutlineDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapOutlineItemDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPageLabelDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapThreadDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapBeadDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapTransitionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapBorderStyleDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapAppearanceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapTextAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapALinkAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFreeTextAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapLineAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSquareOrCircleAnnotation(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMarkupAnnotationsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapRubberStampAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapInkAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPopUpAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFileAttachmentAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSoundAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMovieAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapWidgetAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapAnnotationActionsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPageObjectActionsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFormFieldActionsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapDocumentCatalogActionsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapGoToActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapRemoteGoToActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapLaunchActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapWindowsLaunchActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapThreadActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapURIActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapURIDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSoundActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMovieActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapHideActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapNamedActionsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapInteractiveFormDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFieldDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapVariableTextFieldDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapAppearanceCharacteristicsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapCheckboxFieldDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapRadioButtonFieldDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapTextFieldDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapChoiceFieldDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSignatureDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSubmitFormActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapResetFormActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapImportDataActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapJavascriptActionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFDFTrailerDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFDFCatalogDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFDFDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapEncryptedEmbeddedFileStreamDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapJavascriptDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFDFFieldDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapIconFitDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFDFPageDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFDFTemplateDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFDFNamedPageReferenceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapFDFFileAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSoundObjectDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMovieDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMovieActivationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapDocumentInformationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMetadataStreamDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapComponentsWithMetadataDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPagePieceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapApplicationDataDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapStructureTreeRootDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapStructureElementDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMarkedContentReferenceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapObjectReferenceDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapStructureElementAccessDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapAttributeObjectDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMarkInformationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapArtifactsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapStandardStructureDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapBlockLevelStructureElementsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapInlineLevelStructureElementsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapListAttributeDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapTableAttributesDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapWebCaptureInformationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapWebCaptureDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapWebCapturePageSetDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapWebCaptureImageSetDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSourceInformationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapURLAliasDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapWebCaptureCommandDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapWebCaptureCommandSettingsDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapBoxColorInformationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapBoxStyleDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPrinterMarkAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPrinterMarkFormDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapSeparationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapPDF_XOutputIntentDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapTrapNetworkAnnotationDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapTrapNetworkAppearanceStreamDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapOpiVersionDictionary(const SkPdfNativeObject* in) const;
  SkPdfNativeObjectType mapMultiMasterFontDictionary(const SkPdfNativeObject* in) const;
  bool isDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfDictionary** data) const ;
  bool SkPdfDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfDictionary** data) const ;
  bool isXObjectDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfXObjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfXObjectDictionary** data) const ;
  bool SkPdfXObjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfXObjectDictionary** data) const ;
  bool isFontDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFontDictionary** data) const ;
  bool SkPdfFontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFontDictionary** data) const ;
  bool isTrueTypeFontDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfTrueTypeFontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfTrueTypeFontDictionary** data) const ;
  bool SkPdfTrueTypeFontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfTrueTypeFontDictionary** data) const ;
  bool isStreamCommonDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfStreamCommonDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfStreamCommonDictionary** data) const ;
  bool SkPdfStreamCommonDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfStreamCommonDictionary** data) const ;
  bool isLzwdecodeAndFlatedecodeFiltersDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfLzwdecodeAndFlatedecodeFiltersDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfLzwdecodeAndFlatedecodeFiltersDictionary** data) const ;
  bool SkPdfLzwdecodeAndFlatedecodeFiltersDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfLzwdecodeAndFlatedecodeFiltersDictionary** data) const ;
  bool isCcittfaxdecodeFilterDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCcittfaxdecodeFilterDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCcittfaxdecodeFilterDictionary** data) const ;
  bool SkPdfCcittfaxdecodeFilterDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCcittfaxdecodeFilterDictionary** data) const ;
  bool isJbig2DecodeFilterDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfJbig2DecodeFilterDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfJbig2DecodeFilterDictionary** data) const ;
  bool SkPdfJbig2DecodeFilterDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfJbig2DecodeFilterDictionary** data) const ;
  bool isDctdecodeFilterDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfDctdecodeFilterDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfDctdecodeFilterDictionary** data) const ;
  bool SkPdfDctdecodeFilterDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfDctdecodeFilterDictionary** data) const ;
  bool isFileTrailerDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFileTrailerDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFileTrailerDictionary** data) const ;
  bool SkPdfFileTrailerDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFileTrailerDictionary** data) const ;
  bool isEncryptionCommonDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfEncryptionCommonDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfEncryptionCommonDictionary** data) const ;
  bool SkPdfEncryptionCommonDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfEncryptionCommonDictionary** data) const ;
  bool isStandardSecurityHandlerDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfStandardSecurityHandlerDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfStandardSecurityHandlerDictionary** data) const ;
  bool SkPdfStandardSecurityHandlerDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfStandardSecurityHandlerDictionary** data) const ;
  bool isCatalogDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCatalogDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCatalogDictionary** data) const ;
  bool SkPdfCatalogDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCatalogDictionary** data) const ;
  bool isPageTreeNodeDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPageTreeNodeDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPageTreeNodeDictionary** data) const ;
  bool SkPdfPageTreeNodeDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPageTreeNodeDictionary** data) const ;
  bool isPageObjectDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPageObjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPageObjectDictionary** data) const ;
  bool SkPdfPageObjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPageObjectDictionary** data) const ;
  bool isNameDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfNameDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfNameDictionary** data) const ;
  bool SkPdfNameDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfNameDictionary** data) const ;
  bool isResourceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfResourceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfResourceDictionary** data) const ;
  bool SkPdfResourceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfResourceDictionary** data) const ;
  bool isNameTreeNodeDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfNameTreeNodeDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfNameTreeNodeDictionary** data) const ;
  bool SkPdfNameTreeNodeDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfNameTreeNodeDictionary** data) const ;
  bool isNumberTreeNodeDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfNumberTreeNodeDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfNumberTreeNodeDictionary** data) const ;
  bool SkPdfNumberTreeNodeDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfNumberTreeNodeDictionary** data) const ;
  bool isFunctionCommonDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFunctionCommonDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFunctionCommonDictionary** data) const ;
  bool SkPdfFunctionCommonDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFunctionCommonDictionary** data) const ;
  bool isType0FunctionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType0FunctionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType0FunctionDictionary** data) const ;
  bool SkPdfType0FunctionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType0FunctionDictionary** data) const ;
  bool isType2FunctionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType2FunctionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType2FunctionDictionary** data) const ;
  bool SkPdfType2FunctionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType2FunctionDictionary** data) const ;
  bool isType3FunctionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType3FunctionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType3FunctionDictionary** data) const ;
  bool SkPdfType3FunctionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType3FunctionDictionary** data) const ;
  bool isFileSpecificationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFileSpecificationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFileSpecificationDictionary** data) const ;
  bool SkPdfFileSpecificationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFileSpecificationDictionary** data) const ;
  bool isEmbeddedFileStreamDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfEmbeddedFileStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfEmbeddedFileStreamDictionary** data) const ;
  bool SkPdfEmbeddedFileStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfEmbeddedFileStreamDictionary** data) const ;
  bool isEmbeddedFileParameterDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfEmbeddedFileParameterDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfEmbeddedFileParameterDictionary** data) const ;
  bool SkPdfEmbeddedFileParameterDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfEmbeddedFileParameterDictionary** data) const ;
  bool isMacOsFileInformationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMacOsFileInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMacOsFileInformationDictionary** data) const ;
  bool SkPdfMacOsFileInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMacOsFileInformationDictionary** data) const ;
  bool isGraphicsStateDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfGraphicsStateDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfGraphicsStateDictionary** data) const ;
  bool SkPdfGraphicsStateDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfGraphicsStateDictionary** data) const ;
  bool isCalgrayColorSpaceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCalgrayColorSpaceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCalgrayColorSpaceDictionary** data) const ;
  bool SkPdfCalgrayColorSpaceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCalgrayColorSpaceDictionary** data) const ;
  bool isCalrgbColorSpaceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCalrgbColorSpaceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCalrgbColorSpaceDictionary** data) const ;
  bool SkPdfCalrgbColorSpaceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCalrgbColorSpaceDictionary** data) const ;
  bool isLabColorSpaceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfLabColorSpaceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfLabColorSpaceDictionary** data) const ;
  bool SkPdfLabColorSpaceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfLabColorSpaceDictionary** data) const ;
  bool isIccProfileStreamDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfIccProfileStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfIccProfileStreamDictionary** data) const ;
  bool SkPdfIccProfileStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfIccProfileStreamDictionary** data) const ;
  bool isDeviceNColorSpaceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfDeviceNColorSpaceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfDeviceNColorSpaceDictionary** data) const ;
  bool SkPdfDeviceNColorSpaceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfDeviceNColorSpaceDictionary** data) const ;
  bool isType1PatternDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType1PatternDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType1PatternDictionary** data) const ;
  bool SkPdfType1PatternDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType1PatternDictionary** data) const ;
  bool isType2PatternDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType2PatternDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType2PatternDictionary** data) const ;
  bool SkPdfType2PatternDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType2PatternDictionary** data) const ;
  bool isShadingDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfShadingDictionary** data) const ;
  bool SkPdfShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfShadingDictionary** data) const ;
  bool isType1ShadingDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType1ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType1ShadingDictionary** data) const ;
  bool SkPdfType1ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType1ShadingDictionary** data) const ;
  bool isType2ShadingDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType2ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType2ShadingDictionary** data) const ;
  bool SkPdfType2ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType2ShadingDictionary** data) const ;
  bool isType3ShadingDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType3ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType3ShadingDictionary** data) const ;
  bool SkPdfType3ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType3ShadingDictionary** data) const ;
  bool isType4ShadingDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType4ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType4ShadingDictionary** data) const ;
  bool SkPdfType4ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType4ShadingDictionary** data) const ;
  bool isType5ShadingDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType5ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType5ShadingDictionary** data) const ;
  bool SkPdfType5ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType5ShadingDictionary** data) const ;
  bool isType6ShadingDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType6ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType6ShadingDictionary** data) const ;
  bool SkPdfType6ShadingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType6ShadingDictionary** data) const ;
  bool isImageDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfImageDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfImageDictionary** data) const ;
  bool SkPdfImageDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfImageDictionary** data) const ;
  bool isAlternateImageDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfAlternateImageDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfAlternateImageDictionary** data) const ;
  bool SkPdfAlternateImageDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfAlternateImageDictionary** data) const ;
  bool isType1FormDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType1FormDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType1FormDictionary** data) const ;
  bool SkPdfType1FormDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType1FormDictionary** data) const ;
  bool isGroupAttributesDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfGroupAttributesDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfGroupAttributesDictionary** data) const ;
  bool SkPdfGroupAttributesDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfGroupAttributesDictionary** data) const ;
  bool isReferenceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfReferenceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfReferenceDictionary** data) const ;
  bool SkPdfReferenceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfReferenceDictionary** data) const ;
  bool isPSXobjectDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPSXobjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPSXobjectDictionary** data) const ;
  bool SkPdfPSXobjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPSXobjectDictionary** data) const ;
  bool isType1FontDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType1FontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType1FontDictionary** data) const ;
  bool SkPdfType1FontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType1FontDictionary** data) const ;
  bool isType3FontDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType3FontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType3FontDictionary** data) const ;
  bool SkPdfType3FontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType3FontDictionary** data) const ;
  bool isEncodingDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfEncodingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfEncodingDictionary** data) const ;
  bool SkPdfEncodingDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfEncodingDictionary** data) const ;
  bool isCIDSystemInfoDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCIDSystemInfoDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCIDSystemInfoDictionary** data) const ;
  bool SkPdfCIDSystemInfoDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCIDSystemInfoDictionary** data) const ;
  bool isCIDFontDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCIDFontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCIDFontDictionary** data) const ;
  bool SkPdfCIDFontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCIDFontDictionary** data) const ;
  bool isCMapDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCMapDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCMapDictionary** data) const ;
  bool SkPdfCMapDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCMapDictionary** data) const ;
  bool isType0FontDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType0FontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType0FontDictionary** data) const ;
  bool SkPdfType0FontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType0FontDictionary** data) const ;
  bool isFontDescriptorDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFontDescriptorDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFontDescriptorDictionary** data) const ;
  bool SkPdfFontDescriptorDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFontDescriptorDictionary** data) const ;
  bool isCIDFontDescriptorDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCIDFontDescriptorDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCIDFontDescriptorDictionary** data) const ;
  bool SkPdfCIDFontDescriptorDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCIDFontDescriptorDictionary** data) const ;
  bool isEmbeddedFontStreamDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfEmbeddedFontStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfEmbeddedFontStreamDictionary** data) const ;
  bool SkPdfEmbeddedFontStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfEmbeddedFontStreamDictionary** data) const ;
  bool isType1HalftoneDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType1HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType1HalftoneDictionary** data) const ;
  bool SkPdfType1HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType1HalftoneDictionary** data) const ;
  bool isType6HalftoneDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType6HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType6HalftoneDictionary** data) const ;
  bool SkPdfType6HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType6HalftoneDictionary** data) const ;
  bool isType10HalftoneDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType10HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType10HalftoneDictionary** data) const ;
  bool SkPdfType10HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType10HalftoneDictionary** data) const ;
  bool isType16HalftoneDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType16HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType16HalftoneDictionary** data) const ;
  bool SkPdfType16HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType16HalftoneDictionary** data) const ;
  bool isType5HalftoneDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfType5HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfType5HalftoneDictionary** data) const ;
  bool SkPdfType5HalftoneDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfType5HalftoneDictionary** data) const ;
  bool isSoftMaskDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSoftMaskDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSoftMaskDictionary** data) const ;
  bool SkPdfSoftMaskDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSoftMaskDictionary** data) const ;
  bool isSoftMaskImageDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSoftMaskImageDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSoftMaskImageDictionary** data) const ;
  bool SkPdfSoftMaskImageDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSoftMaskImageDictionary** data) const ;
  bool isTransparencyGroupDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfTransparencyGroupDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfTransparencyGroupDictionary** data) const ;
  bool SkPdfTransparencyGroupDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfTransparencyGroupDictionary** data) const ;
  bool isViewerPreferencesDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfViewerPreferencesDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfViewerPreferencesDictionary** data) const ;
  bool SkPdfViewerPreferencesDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfViewerPreferencesDictionary** data) const ;
  bool isOutlineDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfOutlineDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfOutlineDictionary** data) const ;
  bool SkPdfOutlineDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfOutlineDictionary** data) const ;
  bool isOutlineItemDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfOutlineItemDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfOutlineItemDictionary** data) const ;
  bool SkPdfOutlineItemDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfOutlineItemDictionary** data) const ;
  bool isPageLabelDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPageLabelDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPageLabelDictionary** data) const ;
  bool SkPdfPageLabelDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPageLabelDictionary** data) const ;
  bool isThreadDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfThreadDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfThreadDictionary** data) const ;
  bool SkPdfThreadDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfThreadDictionary** data) const ;
  bool isBeadDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfBeadDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfBeadDictionary** data) const ;
  bool SkPdfBeadDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfBeadDictionary** data) const ;
  bool isTransitionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfTransitionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfTransitionDictionary** data) const ;
  bool SkPdfTransitionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfTransitionDictionary** data) const ;
  bool isAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfAnnotationDictionary** data) const ;
  bool SkPdfAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfAnnotationDictionary** data) const ;
  bool isBorderStyleDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfBorderStyleDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfBorderStyleDictionary** data) const ;
  bool SkPdfBorderStyleDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfBorderStyleDictionary** data) const ;
  bool isAppearanceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfAppearanceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfAppearanceDictionary** data) const ;
  bool SkPdfAppearanceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfAppearanceDictionary** data) const ;
  bool isTextAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfTextAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfTextAnnotationDictionary** data) const ;
  bool SkPdfTextAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfTextAnnotationDictionary** data) const ;
  bool isALinkAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfALinkAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfALinkAnnotationDictionary** data) const ;
  bool SkPdfALinkAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfALinkAnnotationDictionary** data) const ;
  bool isFreeTextAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFreeTextAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFreeTextAnnotationDictionary** data) const ;
  bool SkPdfFreeTextAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFreeTextAnnotationDictionary** data) const ;
  bool isLineAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfLineAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfLineAnnotationDictionary** data) const ;
  bool SkPdfLineAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfLineAnnotationDictionary** data) const ;
  bool isSquareOrCircleAnnotation(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSquareOrCircleAnnotationFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSquareOrCircleAnnotation** data) const ;
  bool SkPdfSquareOrCircleAnnotationFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSquareOrCircleAnnotation** data) const ;
  bool isMarkupAnnotationsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMarkupAnnotationsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMarkupAnnotationsDictionary** data) const ;
  bool SkPdfMarkupAnnotationsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMarkupAnnotationsDictionary** data) const ;
  bool isRubberStampAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfRubberStampAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfRubberStampAnnotationDictionary** data) const ;
  bool SkPdfRubberStampAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfRubberStampAnnotationDictionary** data) const ;
  bool isInkAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfInkAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfInkAnnotationDictionary** data) const ;
  bool SkPdfInkAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfInkAnnotationDictionary** data) const ;
  bool isPopUpAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPopUpAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPopUpAnnotationDictionary** data) const ;
  bool SkPdfPopUpAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPopUpAnnotationDictionary** data) const ;
  bool isFileAttachmentAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFileAttachmentAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFileAttachmentAnnotationDictionary** data) const ;
  bool SkPdfFileAttachmentAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFileAttachmentAnnotationDictionary** data) const ;
  bool isSoundAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSoundAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSoundAnnotationDictionary** data) const ;
  bool SkPdfSoundAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSoundAnnotationDictionary** data) const ;
  bool isMovieAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMovieAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMovieAnnotationDictionary** data) const ;
  bool SkPdfMovieAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMovieAnnotationDictionary** data) const ;
  bool isWidgetAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfWidgetAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfWidgetAnnotationDictionary** data) const ;
  bool SkPdfWidgetAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfWidgetAnnotationDictionary** data) const ;
  bool isActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfActionDictionary** data) const ;
  bool SkPdfActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfActionDictionary** data) const ;
  bool isAnnotationActionsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfAnnotationActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfAnnotationActionsDictionary** data) const ;
  bool SkPdfAnnotationActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfAnnotationActionsDictionary** data) const ;
  bool isPageObjectActionsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPageObjectActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPageObjectActionsDictionary** data) const ;
  bool SkPdfPageObjectActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPageObjectActionsDictionary** data) const ;
  bool isFormFieldActionsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFormFieldActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFormFieldActionsDictionary** data) const ;
  bool SkPdfFormFieldActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFormFieldActionsDictionary** data) const ;
  bool isDocumentCatalogActionsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfDocumentCatalogActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfDocumentCatalogActionsDictionary** data) const ;
  bool SkPdfDocumentCatalogActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfDocumentCatalogActionsDictionary** data) const ;
  bool isGoToActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfGoToActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfGoToActionDictionary** data) const ;
  bool SkPdfGoToActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfGoToActionDictionary** data) const ;
  bool isRemoteGoToActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfRemoteGoToActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfRemoteGoToActionDictionary** data) const ;
  bool SkPdfRemoteGoToActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfRemoteGoToActionDictionary** data) const ;
  bool isLaunchActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfLaunchActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfLaunchActionDictionary** data) const ;
  bool SkPdfLaunchActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfLaunchActionDictionary** data) const ;
  bool isWindowsLaunchActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfWindowsLaunchActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfWindowsLaunchActionDictionary** data) const ;
  bool SkPdfWindowsLaunchActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfWindowsLaunchActionDictionary** data) const ;
  bool isThreadActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfThreadActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfThreadActionDictionary** data) const ;
  bool SkPdfThreadActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfThreadActionDictionary** data) const ;
  bool isURIActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfURIActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfURIActionDictionary** data) const ;
  bool SkPdfURIActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfURIActionDictionary** data) const ;
  bool isURIDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfURIDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfURIDictionary** data) const ;
  bool SkPdfURIDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfURIDictionary** data) const ;
  bool isSoundActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSoundActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSoundActionDictionary** data) const ;
  bool SkPdfSoundActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSoundActionDictionary** data) const ;
  bool isMovieActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMovieActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMovieActionDictionary** data) const ;
  bool SkPdfMovieActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMovieActionDictionary** data) const ;
  bool isHideActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfHideActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfHideActionDictionary** data) const ;
  bool SkPdfHideActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfHideActionDictionary** data) const ;
  bool isNamedActionsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfNamedActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfNamedActionsDictionary** data) const ;
  bool SkPdfNamedActionsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfNamedActionsDictionary** data) const ;
  bool isInteractiveFormDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfInteractiveFormDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfInteractiveFormDictionary** data) const ;
  bool SkPdfInteractiveFormDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfInteractiveFormDictionary** data) const ;
  bool isFieldDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFieldDictionary** data) const ;
  bool SkPdfFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFieldDictionary** data) const ;
  bool isVariableTextFieldDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfVariableTextFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfVariableTextFieldDictionary** data) const ;
  bool SkPdfVariableTextFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfVariableTextFieldDictionary** data) const ;
  bool isAppearanceCharacteristicsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfAppearanceCharacteristicsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfAppearanceCharacteristicsDictionary** data) const ;
  bool SkPdfAppearanceCharacteristicsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfAppearanceCharacteristicsDictionary** data) const ;
  bool isCheckboxFieldDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfCheckboxFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfCheckboxFieldDictionary** data) const ;
  bool SkPdfCheckboxFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfCheckboxFieldDictionary** data) const ;
  bool isRadioButtonFieldDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfRadioButtonFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfRadioButtonFieldDictionary** data) const ;
  bool SkPdfRadioButtonFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfRadioButtonFieldDictionary** data) const ;
  bool isTextFieldDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfTextFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfTextFieldDictionary** data) const ;
  bool SkPdfTextFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfTextFieldDictionary** data) const ;
  bool isChoiceFieldDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfChoiceFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfChoiceFieldDictionary** data) const ;
  bool SkPdfChoiceFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfChoiceFieldDictionary** data) const ;
  bool isSignatureDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSignatureDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSignatureDictionary** data) const ;
  bool SkPdfSignatureDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSignatureDictionary** data) const ;
  bool isSubmitFormActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSubmitFormActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSubmitFormActionDictionary** data) const ;
  bool SkPdfSubmitFormActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSubmitFormActionDictionary** data) const ;
  bool isResetFormActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfResetFormActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfResetFormActionDictionary** data) const ;
  bool SkPdfResetFormActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfResetFormActionDictionary** data) const ;
  bool isImportDataActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfImportDataActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfImportDataActionDictionary** data) const ;
  bool SkPdfImportDataActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfImportDataActionDictionary** data) const ;
  bool isJavascriptActionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfJavascriptActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfJavascriptActionDictionary** data) const ;
  bool SkPdfJavascriptActionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfJavascriptActionDictionary** data) const ;
  bool isFDFTrailerDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFDFTrailerDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFDFTrailerDictionary** data) const ;
  bool SkPdfFDFTrailerDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFDFTrailerDictionary** data) const ;
  bool isFDFCatalogDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFDFCatalogDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFDFCatalogDictionary** data) const ;
  bool SkPdfFDFCatalogDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFDFCatalogDictionary** data) const ;
  bool isFDFDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFDFDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFDFDictionary** data) const ;
  bool SkPdfFDFDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFDFDictionary** data) const ;
  bool isEncryptedEmbeddedFileStreamDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfEncryptedEmbeddedFileStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfEncryptedEmbeddedFileStreamDictionary** data) const ;
  bool SkPdfEncryptedEmbeddedFileStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfEncryptedEmbeddedFileStreamDictionary** data) const ;
  bool isJavascriptDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfJavascriptDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfJavascriptDictionary** data) const ;
  bool SkPdfJavascriptDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfJavascriptDictionary** data) const ;
  bool isFDFFieldDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFDFFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFDFFieldDictionary** data) const ;
  bool SkPdfFDFFieldDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFDFFieldDictionary** data) const ;
  bool isIconFitDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfIconFitDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfIconFitDictionary** data) const ;
  bool SkPdfIconFitDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfIconFitDictionary** data) const ;
  bool isFDFPageDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFDFPageDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFDFPageDictionary** data) const ;
  bool SkPdfFDFPageDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFDFPageDictionary** data) const ;
  bool isFDFTemplateDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFDFTemplateDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFDFTemplateDictionary** data) const ;
  bool SkPdfFDFTemplateDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFDFTemplateDictionary** data) const ;
  bool isFDFNamedPageReferenceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFDFNamedPageReferenceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFDFNamedPageReferenceDictionary** data) const ;
  bool SkPdfFDFNamedPageReferenceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFDFNamedPageReferenceDictionary** data) const ;
  bool isFDFFileAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfFDFFileAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfFDFFileAnnotationDictionary** data) const ;
  bool SkPdfFDFFileAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfFDFFileAnnotationDictionary** data) const ;
  bool isSoundObjectDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSoundObjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSoundObjectDictionary** data) const ;
  bool SkPdfSoundObjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSoundObjectDictionary** data) const ;
  bool isMovieDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMovieDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMovieDictionary** data) const ;
  bool SkPdfMovieDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMovieDictionary** data) const ;
  bool isMovieActivationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMovieActivationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMovieActivationDictionary** data) const ;
  bool SkPdfMovieActivationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMovieActivationDictionary** data) const ;
  bool isDocumentInformationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfDocumentInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfDocumentInformationDictionary** data) const ;
  bool SkPdfDocumentInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfDocumentInformationDictionary** data) const ;
  bool isMetadataStreamDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMetadataStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMetadataStreamDictionary** data) const ;
  bool SkPdfMetadataStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMetadataStreamDictionary** data) const ;
  bool isComponentsWithMetadataDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfComponentsWithMetadataDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfComponentsWithMetadataDictionary** data) const ;
  bool SkPdfComponentsWithMetadataDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfComponentsWithMetadataDictionary** data) const ;
  bool isPagePieceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPagePieceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPagePieceDictionary** data) const ;
  bool SkPdfPagePieceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPagePieceDictionary** data) const ;
  bool isApplicationDataDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfApplicationDataDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfApplicationDataDictionary** data) const ;
  bool SkPdfApplicationDataDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfApplicationDataDictionary** data) const ;
  bool isStructureTreeRootDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfStructureTreeRootDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfStructureTreeRootDictionary** data) const ;
  bool SkPdfStructureTreeRootDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfStructureTreeRootDictionary** data) const ;
  bool isStructureElementDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfStructureElementDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfStructureElementDictionary** data) const ;
  bool SkPdfStructureElementDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfStructureElementDictionary** data) const ;
  bool isMarkedContentReferenceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMarkedContentReferenceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMarkedContentReferenceDictionary** data) const ;
  bool SkPdfMarkedContentReferenceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMarkedContentReferenceDictionary** data) const ;
  bool isObjectReferenceDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfObjectReferenceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfObjectReferenceDictionary** data) const ;
  bool SkPdfObjectReferenceDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfObjectReferenceDictionary** data) const ;
  bool isStructureElementAccessDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfStructureElementAccessDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfStructureElementAccessDictionary** data) const ;
  bool SkPdfStructureElementAccessDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfStructureElementAccessDictionary** data) const ;
  bool isAttributeObjectDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfAttributeObjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfAttributeObjectDictionary** data) const ;
  bool SkPdfAttributeObjectDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfAttributeObjectDictionary** data) const ;
  bool isMarkInformationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMarkInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMarkInformationDictionary** data) const ;
  bool SkPdfMarkInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMarkInformationDictionary** data) const ;
  bool isArtifactsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfArtifactsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfArtifactsDictionary** data) const ;
  bool SkPdfArtifactsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfArtifactsDictionary** data) const ;
  bool isStandardStructureDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfStandardStructureDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfStandardStructureDictionary** data) const ;
  bool SkPdfStandardStructureDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfStandardStructureDictionary** data) const ;
  bool isBlockLevelStructureElementsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfBlockLevelStructureElementsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfBlockLevelStructureElementsDictionary** data) const ;
  bool SkPdfBlockLevelStructureElementsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfBlockLevelStructureElementsDictionary** data) const ;
  bool isInlineLevelStructureElementsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfInlineLevelStructureElementsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfInlineLevelStructureElementsDictionary** data) const ;
  bool SkPdfInlineLevelStructureElementsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfInlineLevelStructureElementsDictionary** data) const ;
  bool isListAttributeDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfListAttributeDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfListAttributeDictionary** data) const ;
  bool SkPdfListAttributeDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfListAttributeDictionary** data) const ;
  bool isTableAttributesDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfTableAttributesDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfTableAttributesDictionary** data) const ;
  bool SkPdfTableAttributesDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfTableAttributesDictionary** data) const ;
  bool isWebCaptureInformationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfWebCaptureInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfWebCaptureInformationDictionary** data) const ;
  bool SkPdfWebCaptureInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfWebCaptureInformationDictionary** data) const ;
  bool isWebCaptureDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfWebCaptureDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfWebCaptureDictionary** data) const ;
  bool SkPdfWebCaptureDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfWebCaptureDictionary** data) const ;
  bool isWebCapturePageSetDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfWebCapturePageSetDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfWebCapturePageSetDictionary** data) const ;
  bool SkPdfWebCapturePageSetDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfWebCapturePageSetDictionary** data) const ;
  bool isWebCaptureImageSetDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfWebCaptureImageSetDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfWebCaptureImageSetDictionary** data) const ;
  bool SkPdfWebCaptureImageSetDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfWebCaptureImageSetDictionary** data) const ;
  bool isSourceInformationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSourceInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSourceInformationDictionary** data) const ;
  bool SkPdfSourceInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSourceInformationDictionary** data) const ;
  bool isURLAliasDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfURLAliasDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfURLAliasDictionary** data) const ;
  bool SkPdfURLAliasDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfURLAliasDictionary** data) const ;
  bool isWebCaptureCommandDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfWebCaptureCommandDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfWebCaptureCommandDictionary** data) const ;
  bool SkPdfWebCaptureCommandDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfWebCaptureCommandDictionary** data) const ;
  bool isWebCaptureCommandSettingsDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfWebCaptureCommandSettingsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfWebCaptureCommandSettingsDictionary** data) const ;
  bool SkPdfWebCaptureCommandSettingsDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfWebCaptureCommandSettingsDictionary** data) const ;
  bool isBoxColorInformationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfBoxColorInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfBoxColorInformationDictionary** data) const ;
  bool SkPdfBoxColorInformationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfBoxColorInformationDictionary** data) const ;
  bool isBoxStyleDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfBoxStyleDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfBoxStyleDictionary** data) const ;
  bool SkPdfBoxStyleDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfBoxStyleDictionary** data) const ;
  bool isPrinterMarkAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPrinterMarkAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPrinterMarkAnnotationDictionary** data) const ;
  bool SkPdfPrinterMarkAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPrinterMarkAnnotationDictionary** data) const ;
  bool isPrinterMarkFormDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPrinterMarkFormDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPrinterMarkFormDictionary** data) const ;
  bool SkPdfPrinterMarkFormDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPrinterMarkFormDictionary** data) const ;
  bool isSeparationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfSeparationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfSeparationDictionary** data) const ;
  bool SkPdfSeparationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfSeparationDictionary** data) const ;
  bool isPDF_XOutputIntentDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfPDF_XOutputIntentDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfPDF_XOutputIntentDictionary** data) const ;
  bool SkPdfPDF_XOutputIntentDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfPDF_XOutputIntentDictionary** data) const ;
  bool isTrapNetworkAnnotationDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfTrapNetworkAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfTrapNetworkAnnotationDictionary** data) const ;
  bool SkPdfTrapNetworkAnnotationDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfTrapNetworkAnnotationDictionary** data) const ;
  bool isTrapNetworkAppearanceStreamDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfTrapNetworkAppearanceStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfTrapNetworkAppearanceStreamDictionary** data) const ;
  bool SkPdfTrapNetworkAppearanceStreamDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfTrapNetworkAppearanceStreamDictionary** data) const ;
  bool isOpiVersionDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfOpiVersionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfOpiVersionDictionary** data) const ;
  bool SkPdfOpiVersionDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfOpiVersionDictionary** data) const ;
  bool isMultiMasterFontDictionary(const SkPdfNativeObject* nativeObj) const ;
  bool SkPdfMultiMasterFontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, SkPdfMultiMasterFontDictionary** data) const ;
  bool SkPdfMultiMasterFontDictionaryFromDictionary(const SkPdfNativeObject* dict, const char* key, const char* abr, SkPdfMultiMasterFontDictionary** data) const ;
};

#endif  // SkPdfMapper_DEFINED
