// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Defines all command-line switches for media/webrtc.

#ifndef MEDIA_WEBRTC_WEBRTC_SWITCHES_H_
#define MEDIA_WEBRTC_WEBRTC_SWITCHES_H_

#include "base/component_export.h"
#include "base/feature_list.h"

namespace switches {

COMPONENT_EXPORT(MEDIA_WEBRTC) extern const char kAecRefinedAdaptiveFilter[];
COMPONENT_EXPORT(MEDIA_WEBRTC) extern const char kAgcStartupMinVolume[];

}  // namespace switches

namespace features {

COMPONENT_EXPORT(MEDIA_WEBRTC)
extern const base::Feature kWebRtcAecBoundedErlSetup;
COMPONENT_EXPORT(MEDIA_WEBRTC)
extern const base::Feature kWebRtcAecClockDriftSetup;
COMPONENT_EXPORT(MEDIA_WEBRTC)
extern const base::Feature kWebRtcAecNoiseTransparency;
COMPONENT_EXPORT(MEDIA_WEBRTC)
extern const base::Feature kWebRtcApmInAudioService;

}  // namespace features

#endif  // MEDIA_WEBRTC_WEBRTC_SWITCHES_H_
