// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is auto-generated from
// gpu/command_buffer/build_gles2_cmd_buffer.py
// It's formatted by clang-format using chromium coding style:
//    clang-format -i -style=chromium filename
// DO NOT EDIT!

#ifndef GPU_COMMAND_BUFFER_COMMON_GLES2_CMD_IDS_AUTOGEN_H_
#define GPU_COMMAND_BUFFER_COMMON_GLES2_CMD_IDS_AUTOGEN_H_

#define GLES2_COMMAND_LIST(OP)                                       \
  OP(ActiveTexture)                                        /* 256 */ \
  OP(AttachShader)                                         /* 257 */ \
  OP(BindAttribLocationBucket)                             /* 258 */ \
  OP(BindBuffer)                                           /* 259 */ \
  OP(BindBufferBase)                                       /* 260 */ \
  OP(BindBufferRange)                                      /* 261 */ \
  OP(BindFramebuffer)                                      /* 262 */ \
  OP(BindRenderbuffer)                                     /* 263 */ \
  OP(BindSampler)                                          /* 264 */ \
  OP(BindTexture)                                          /* 265 */ \
  OP(BindTransformFeedback)                                /* 266 */ \
  OP(BlendColor)                                           /* 267 */ \
  OP(BlendEquation)                                        /* 268 */ \
  OP(BlendEquationSeparate)                                /* 269 */ \
  OP(BlendFunc)                                            /* 270 */ \
  OP(BlendFuncSeparate)                                    /* 271 */ \
  OP(BufferData)                                           /* 272 */ \
  OP(BufferSubData)                                        /* 273 */ \
  OP(CheckFramebufferStatus)                               /* 274 */ \
  OP(Clear)                                                /* 275 */ \
  OP(ClearBufferfi)                                        /* 276 */ \
  OP(ClearBufferfvImmediate)                               /* 277 */ \
  OP(ClearBufferivImmediate)                               /* 278 */ \
  OP(ClearBufferuivImmediate)                              /* 279 */ \
  OP(ClearColor)                                           /* 280 */ \
  OP(ClearDepthf)                                          /* 281 */ \
  OP(ClearStencil)                                         /* 282 */ \
  OP(ClientWaitSync)                                       /* 283 */ \
  OP(ColorMask)                                            /* 284 */ \
  OP(CompileShader)                                        /* 285 */ \
  OP(CompressedTexImage2DBucket)                           /* 286 */ \
  OP(CompressedTexImage2D)                                 /* 287 */ \
  OP(CompressedTexSubImage2DBucket)                        /* 288 */ \
  OP(CompressedTexSubImage2D)                              /* 289 */ \
  OP(CompressedTexImage3DBucket)                           /* 290 */ \
  OP(CompressedTexImage3D)                                 /* 291 */ \
  OP(CompressedTexSubImage3DBucket)                        /* 292 */ \
  OP(CompressedTexSubImage3D)                              /* 293 */ \
  OP(CopyBufferSubData)                                    /* 294 */ \
  OP(CopyTexImage2D)                                       /* 295 */ \
  OP(CopyTexSubImage2D)                                    /* 296 */ \
  OP(CopyTexSubImage3D)                                    /* 297 */ \
  OP(CreateProgram)                                        /* 298 */ \
  OP(CreateShader)                                         /* 299 */ \
  OP(CullFace)                                             /* 300 */ \
  OP(DeleteBuffersImmediate)                               /* 301 */ \
  OP(DeleteFramebuffersImmediate)                          /* 302 */ \
  OP(DeleteProgram)                                        /* 303 */ \
  OP(DeleteRenderbuffersImmediate)                         /* 304 */ \
  OP(DeleteSamplersImmediate)                              /* 305 */ \
  OP(DeleteSync)                                           /* 306 */ \
  OP(DeleteShader)                                         /* 307 */ \
  OP(DeleteTexturesImmediate)                              /* 308 */ \
  OP(DeleteTransformFeedbacksImmediate)                    /* 309 */ \
  OP(DepthFunc)                                            /* 310 */ \
  OP(DepthMask)                                            /* 311 */ \
  OP(DepthRangef)                                          /* 312 */ \
  OP(DetachShader)                                         /* 313 */ \
  OP(Disable)                                              /* 314 */ \
  OP(DisableVertexAttribArray)                             /* 315 */ \
  OP(DrawArrays)                                           /* 316 */ \
  OP(DrawElements)                                         /* 317 */ \
  OP(Enable)                                               /* 318 */ \
  OP(EnableVertexAttribArray)                              /* 319 */ \
  OP(FenceSync)                                            /* 320 */ \
  OP(Finish)                                               /* 321 */ \
  OP(Flush)                                                /* 322 */ \
  OP(FramebufferRenderbuffer)                              /* 323 */ \
  OP(FramebufferTexture2D)                                 /* 324 */ \
  OP(FramebufferTextureLayer)                              /* 325 */ \
  OP(FrontFace)                                            /* 326 */ \
  OP(GenBuffersImmediate)                                  /* 327 */ \
  OP(GenerateMipmap)                                       /* 328 */ \
  OP(GenFramebuffersImmediate)                             /* 329 */ \
  OP(GenRenderbuffersImmediate)                            /* 330 */ \
  OP(GenSamplersImmediate)                                 /* 331 */ \
  OP(GenTexturesImmediate)                                 /* 332 */ \
  OP(GenTransformFeedbacksImmediate)                       /* 333 */ \
  OP(GetActiveAttrib)                                      /* 334 */ \
  OP(GetActiveUniform)                                     /* 335 */ \
  OP(GetActiveUniformBlockiv)                              /* 336 */ \
  OP(GetActiveUniformBlockName)                            /* 337 */ \
  OP(GetActiveUniformsiv)                                  /* 338 */ \
  OP(GetAttachedShaders)                                   /* 339 */ \
  OP(GetAttribLocation)                                    /* 340 */ \
  OP(GetBooleanv)                                          /* 341 */ \
  OP(GetBufferParameteri64v)                               /* 342 */ \
  OP(GetBufferParameteriv)                                 /* 343 */ \
  OP(GetError)                                             /* 344 */ \
  OP(GetFloatv)                                            /* 345 */ \
  OP(GetFragDataLocation)                                  /* 346 */ \
  OP(GetFramebufferAttachmentParameteriv)                  /* 347 */ \
  OP(GetInteger64v)                                        /* 348 */ \
  OP(GetIntegeri_v)                                        /* 349 */ \
  OP(GetInteger64i_v)                                      /* 350 */ \
  OP(GetIntegerv)                                          /* 351 */ \
  OP(GetInternalformativ)                                  /* 352 */ \
  OP(GetProgramiv)                                         /* 353 */ \
  OP(GetProgramInfoLog)                                    /* 354 */ \
  OP(GetRenderbufferParameteriv)                           /* 355 */ \
  OP(GetSamplerParameterfv)                                /* 356 */ \
  OP(GetSamplerParameteriv)                                /* 357 */ \
  OP(GetShaderiv)                                          /* 358 */ \
  OP(GetShaderInfoLog)                                     /* 359 */ \
  OP(GetShaderPrecisionFormat)                             /* 360 */ \
  OP(GetShaderSource)                                      /* 361 */ \
  OP(GetString)                                            /* 362 */ \
  OP(GetSynciv)                                            /* 363 */ \
  OP(GetTexParameterfv)                                    /* 364 */ \
  OP(GetTexParameteriv)                                    /* 365 */ \
  OP(GetTransformFeedbackVarying)                          /* 366 */ \
  OP(GetUniformBlockIndex)                                 /* 367 */ \
  OP(GetUniformfv)                                         /* 368 */ \
  OP(GetUniformiv)                                         /* 369 */ \
  OP(GetUniformuiv)                                        /* 370 */ \
  OP(GetUniformIndices)                                    /* 371 */ \
  OP(GetUniformLocation)                                   /* 372 */ \
  OP(GetVertexAttribfv)                                    /* 373 */ \
  OP(GetVertexAttribiv)                                    /* 374 */ \
  OP(GetVertexAttribIiv)                                   /* 375 */ \
  OP(GetVertexAttribIuiv)                                  /* 376 */ \
  OP(GetVertexAttribPointerv)                              /* 377 */ \
  OP(Hint)                                                 /* 378 */ \
  OP(InvalidateFramebufferImmediate)                       /* 379 */ \
  OP(InvalidateSubFramebufferImmediate)                    /* 380 */ \
  OP(IsBuffer)                                             /* 381 */ \
  OP(IsEnabled)                                            /* 382 */ \
  OP(IsFramebuffer)                                        /* 383 */ \
  OP(IsProgram)                                            /* 384 */ \
  OP(IsRenderbuffer)                                       /* 385 */ \
  OP(IsSampler)                                            /* 386 */ \
  OP(IsShader)                                             /* 387 */ \
  OP(IsSync)                                               /* 388 */ \
  OP(IsTexture)                                            /* 389 */ \
  OP(IsTransformFeedback)                                  /* 390 */ \
  OP(LineWidth)                                            /* 391 */ \
  OP(LinkProgram)                                          /* 392 */ \
  OP(PauseTransformFeedback)                               /* 393 */ \
  OP(PixelStorei)                                          /* 394 */ \
  OP(PolygonOffset)                                        /* 395 */ \
  OP(ReadBuffer)                                           /* 396 */ \
  OP(ReadPixels)                                           /* 397 */ \
  OP(ReleaseShaderCompiler)                                /* 398 */ \
  OP(RenderbufferStorage)                                  /* 399 */ \
  OP(ResumeTransformFeedback)                              /* 400 */ \
  OP(SampleCoverage)                                       /* 401 */ \
  OP(SamplerParameterf)                                    /* 402 */ \
  OP(SamplerParameterfvImmediate)                          /* 403 */ \
  OP(SamplerParameteri)                                    /* 404 */ \
  OP(SamplerParameterivImmediate)                          /* 405 */ \
  OP(Scissor)                                              /* 406 */ \
  OP(ShaderBinary)                                         /* 407 */ \
  OP(ShaderSourceBucket)                                   /* 408 */ \
  OP(MultiDrawBeginCHROMIUM)                               /* 409 */ \
  OP(MultiDrawEndCHROMIUM)                                 /* 410 */ \
  OP(MultiDrawArraysCHROMIUM)                              /* 411 */ \
  OP(MultiDrawArraysInstancedCHROMIUM)                     /* 412 */ \
  OP(MultiDrawElementsCHROMIUM)                            /* 413 */ \
  OP(MultiDrawElementsInstancedCHROMIUM)                   /* 414 */ \
  OP(StencilFunc)                                          /* 415 */ \
  OP(StencilFuncSeparate)                                  /* 416 */ \
  OP(StencilMask)                                          /* 417 */ \
  OP(StencilMaskSeparate)                                  /* 418 */ \
  OP(StencilOp)                                            /* 419 */ \
  OP(StencilOpSeparate)                                    /* 420 */ \
  OP(TexImage2D)                                           /* 421 */ \
  OP(TexImage3D)                                           /* 422 */ \
  OP(TexParameterf)                                        /* 423 */ \
  OP(TexParameterfvImmediate)                              /* 424 */ \
  OP(TexParameteri)                                        /* 425 */ \
  OP(TexParameterivImmediate)                              /* 426 */ \
  OP(TexStorage3D)                                         /* 427 */ \
  OP(TexSubImage2D)                                        /* 428 */ \
  OP(TexSubImage3D)                                        /* 429 */ \
  OP(TransformFeedbackVaryingsBucket)                      /* 430 */ \
  OP(Uniform1f)                                            /* 431 */ \
  OP(Uniform1fvImmediate)                                  /* 432 */ \
  OP(Uniform1i)                                            /* 433 */ \
  OP(Uniform1ivImmediate)                                  /* 434 */ \
  OP(Uniform1ui)                                           /* 435 */ \
  OP(Uniform1uivImmediate)                                 /* 436 */ \
  OP(Uniform2f)                                            /* 437 */ \
  OP(Uniform2fvImmediate)                                  /* 438 */ \
  OP(Uniform2i)                                            /* 439 */ \
  OP(Uniform2ivImmediate)                                  /* 440 */ \
  OP(Uniform2ui)                                           /* 441 */ \
  OP(Uniform2uivImmediate)                                 /* 442 */ \
  OP(Uniform3f)                                            /* 443 */ \
  OP(Uniform3fvImmediate)                                  /* 444 */ \
  OP(Uniform3i)                                            /* 445 */ \
  OP(Uniform3ivImmediate)                                  /* 446 */ \
  OP(Uniform3ui)                                           /* 447 */ \
  OP(Uniform3uivImmediate)                                 /* 448 */ \
  OP(Uniform4f)                                            /* 449 */ \
  OP(Uniform4fvImmediate)                                  /* 450 */ \
  OP(Uniform4i)                                            /* 451 */ \
  OP(Uniform4ivImmediate)                                  /* 452 */ \
  OP(Uniform4ui)                                           /* 453 */ \
  OP(Uniform4uivImmediate)                                 /* 454 */ \
  OP(UniformBlockBinding)                                  /* 455 */ \
  OP(UniformMatrix2fvImmediate)                            /* 456 */ \
  OP(UniformMatrix2x3fvImmediate)                          /* 457 */ \
  OP(UniformMatrix2x4fvImmediate)                          /* 458 */ \
  OP(UniformMatrix3fvImmediate)                            /* 459 */ \
  OP(UniformMatrix3x2fvImmediate)                          /* 460 */ \
  OP(UniformMatrix3x4fvImmediate)                          /* 461 */ \
  OP(UniformMatrix4fvImmediate)                            /* 462 */ \
  OP(UniformMatrix4x2fvImmediate)                          /* 463 */ \
  OP(UniformMatrix4x3fvImmediate)                          /* 464 */ \
  OP(UseProgram)                                           /* 465 */ \
  OP(ValidateProgram)                                      /* 466 */ \
  OP(VertexAttrib1f)                                       /* 467 */ \
  OP(VertexAttrib1fvImmediate)                             /* 468 */ \
  OP(VertexAttrib2f)                                       /* 469 */ \
  OP(VertexAttrib2fvImmediate)                             /* 470 */ \
  OP(VertexAttrib3f)                                       /* 471 */ \
  OP(VertexAttrib3fvImmediate)                             /* 472 */ \
  OP(VertexAttrib4f)                                       /* 473 */ \
  OP(VertexAttrib4fvImmediate)                             /* 474 */ \
  OP(VertexAttribI4i)                                      /* 475 */ \
  OP(VertexAttribI4ivImmediate)                            /* 476 */ \
  OP(VertexAttribI4ui)                                     /* 477 */ \
  OP(VertexAttribI4uivImmediate)                           /* 478 */ \
  OP(VertexAttribIPointer)                                 /* 479 */ \
  OP(VertexAttribPointer)                                  /* 480 */ \
  OP(Viewport)                                             /* 481 */ \
  OP(WaitSync)                                             /* 482 */ \
  OP(BlitFramebufferCHROMIUM)                              /* 483 */ \
  OP(RenderbufferStorageMultisampleCHROMIUM)               /* 484 */ \
  OP(RenderbufferStorageMultisampleEXT)                    /* 485 */ \
  OP(FramebufferTexture2DMultisampleEXT)                   /* 486 */ \
  OP(TexStorage2DEXT)                                      /* 487 */ \
  OP(GenQueriesEXTImmediate)                               /* 488 */ \
  OP(DeleteQueriesEXTImmediate)                            /* 489 */ \
  OP(QueryCounterEXT)                                      /* 490 */ \
  OP(BeginQueryEXT)                                        /* 491 */ \
  OP(BeginTransformFeedback)                               /* 492 */ \
  OP(EndQueryEXT)                                          /* 493 */ \
  OP(EndTransformFeedback)                                 /* 494 */ \
  OP(SetDisjointValueSyncCHROMIUM)                         /* 495 */ \
  OP(InsertEventMarkerEXT)                                 /* 496 */ \
  OP(PushGroupMarkerEXT)                                   /* 497 */ \
  OP(PopGroupMarkerEXT)                                    /* 498 */ \
  OP(GenVertexArraysOESImmediate)                          /* 499 */ \
  OP(DeleteVertexArraysOESImmediate)                       /* 500 */ \
  OP(IsVertexArrayOES)                                     /* 501 */ \
  OP(BindVertexArrayOES)                                   /* 502 */ \
  OP(FramebufferParameteri)                                /* 503 */ \
  OP(BindImageTexture)                                     /* 504 */ \
  OP(DispatchCompute)                                      /* 505 */ \
  OP(MemoryBarrierEXT)                                     /* 506 */ \
  OP(MemoryBarrierByRegion)                                /* 507 */ \
  OP(SwapBuffers)                                          /* 508 */ \
  OP(GetMaxValueInBufferCHROMIUM)                          /* 509 */ \
  OP(EnableFeatureCHROMIUM)                                /* 510 */ \
  OP(MapBufferRange)                                       /* 511 */ \
  OP(UnmapBuffer)                                          /* 512 */ \
  OP(FlushMappedBufferRange)                               /* 513 */ \
  OP(ResizeCHROMIUM)                                       /* 514 */ \
  OP(GetRequestableExtensionsCHROMIUM)                     /* 515 */ \
  OP(RequestExtensionCHROMIUM)                             /* 516 */ \
  OP(GetProgramInfoCHROMIUM)                               /* 517 */ \
  OP(GetUniformBlocksCHROMIUM)                             /* 518 */ \
  OP(GetTransformFeedbackVaryingsCHROMIUM)                 /* 519 */ \
  OP(GetUniformsES3CHROMIUM)                               /* 520 */ \
  OP(DescheduleUntilFinishedCHROMIUM)                      /* 521 */ \
  OP(GetTranslatedShaderSourceANGLE)                       /* 522 */ \
  OP(PostSubBufferCHROMIUM)                                /* 523 */ \
  OP(CopyTextureCHROMIUM)                                  /* 524 */ \
  OP(CopySubTextureCHROMIUM)                               /* 525 */ \
  OP(DrawArraysInstancedANGLE)                             /* 526 */ \
  OP(DrawElementsInstancedANGLE)                           /* 527 */ \
  OP(VertexAttribDivisorANGLE)                             /* 528 */ \
  OP(ProduceTextureDirectCHROMIUMImmediate)                /* 529 */ \
  OP(CreateAndConsumeTextureINTERNALImmediate)             /* 530 */ \
  OP(BindUniformLocationCHROMIUMBucket)                    /* 531 */ \
  OP(BindTexImage2DCHROMIUM)                               /* 532 */ \
  OP(BindTexImage2DWithInternalformatCHROMIUM)             /* 533 */ \
  OP(ReleaseTexImage2DCHROMIUM)                            /* 534 */ \
  OP(TraceBeginCHROMIUM)                                   /* 535 */ \
  OP(TraceEndCHROMIUM)                                     /* 536 */ \
  OP(DiscardFramebufferEXTImmediate)                       /* 537 */ \
  OP(LoseContextCHROMIUM)                                  /* 538 */ \
  OP(InsertFenceSyncCHROMIUM)                              /* 539 */ \
  OP(UnpremultiplyAndDitherCopyCHROMIUM)                   /* 540 */ \
  OP(DrawBuffersEXTImmediate)                              /* 541 */ \
  OP(DiscardBackbufferCHROMIUM)                            /* 542 */ \
  OP(ScheduleOverlayPlaneCHROMIUM)                         /* 543 */ \
  OP(ScheduleCALayerSharedStateCHROMIUM)                   /* 544 */ \
  OP(ScheduleCALayerCHROMIUM)                              /* 545 */ \
  OP(ScheduleCALayerInUseQueryCHROMIUMImmediate)           /* 546 */ \
  OP(CommitOverlayPlanesCHROMIUM)                          /* 547 */ \
  OP(FlushDriverCachesCHROMIUM)                            /* 548 */ \
  OP(ScheduleDCLayerCHROMIUM)                              /* 549 */ \
  OP(SetActiveURLCHROMIUM)                                 /* 550 */ \
  OP(MatrixLoadfCHROMIUMImmediate)                         /* 551 */ \
  OP(MatrixLoadIdentityCHROMIUM)                           /* 552 */ \
  OP(GenPathsCHROMIUM)                                     /* 553 */ \
  OP(DeletePathsCHROMIUM)                                  /* 554 */ \
  OP(IsPathCHROMIUM)                                       /* 555 */ \
  OP(PathCommandsCHROMIUM)                                 /* 556 */ \
  OP(PathParameterfCHROMIUM)                               /* 557 */ \
  OP(PathParameteriCHROMIUM)                               /* 558 */ \
  OP(PathStencilFuncCHROMIUM)                              /* 559 */ \
  OP(StencilFillPathCHROMIUM)                              /* 560 */ \
  OP(StencilStrokePathCHROMIUM)                            /* 561 */ \
  OP(CoverFillPathCHROMIUM)                                /* 562 */ \
  OP(CoverStrokePathCHROMIUM)                              /* 563 */ \
  OP(StencilThenCoverFillPathCHROMIUM)                     /* 564 */ \
  OP(StencilThenCoverStrokePathCHROMIUM)                   /* 565 */ \
  OP(StencilFillPathInstancedCHROMIUM)                     /* 566 */ \
  OP(StencilStrokePathInstancedCHROMIUM)                   /* 567 */ \
  OP(CoverFillPathInstancedCHROMIUM)                       /* 568 */ \
  OP(CoverStrokePathInstancedCHROMIUM)                     /* 569 */ \
  OP(StencilThenCoverFillPathInstancedCHROMIUM)            /* 570 */ \
  OP(StencilThenCoverStrokePathInstancedCHROMIUM)          /* 571 */ \
  OP(BindFragmentInputLocationCHROMIUMBucket)              /* 572 */ \
  OP(ProgramPathFragmentInputGenCHROMIUM)                  /* 573 */ \
  OP(CoverageModulationCHROMIUM)                           /* 574 */ \
  OP(BlendBarrierKHR)                                      /* 575 */ \
  OP(ApplyScreenSpaceAntialiasingCHROMIUM)                 /* 576 */ \
  OP(BindFragDataLocationIndexedEXTBucket)                 /* 577 */ \
  OP(BindFragDataLocationEXTBucket)                        /* 578 */ \
  OP(GetFragDataIndexEXT)                                  /* 579 */ \
  OP(UniformMatrix4fvStreamTextureMatrixCHROMIUMImmediate) /* 580 */ \
  OP(OverlayPromotionHintCHROMIUM)                         /* 581 */ \
  OP(SwapBuffersWithBoundsCHROMIUMImmediate)               /* 582 */ \
  OP(SetDrawRectangleCHROMIUM)                             /* 583 */ \
  OP(SetEnableDCLayersCHROMIUM)                            /* 584 */ \
  OP(InitializeDiscardableTextureCHROMIUM)                 /* 585 */ \
  OP(UnlockDiscardableTextureCHROMIUM)                     /* 586 */ \
  OP(LockDiscardableTextureCHROMIUM)                       /* 587 */ \
  OP(TexStorage2DImageCHROMIUM)                            /* 588 */ \
  OP(SetColorSpaceMetadataCHROMIUM)                        /* 589 */ \
  OP(WindowRectanglesEXTImmediate)                         /* 590 */ \
  OP(CreateGpuFenceINTERNAL)                               /* 591 */ \
  OP(WaitGpuFenceCHROMIUM)                                 /* 592 */ \
  OP(DestroyGpuFenceCHROMIUM)                              /* 593 */ \
  OP(SetReadbackBufferShadowAllocationINTERNAL)            /* 594 */ \
  OP(FramebufferTextureMultiviewLayeredANGLE)              /* 595 */ \
  OP(MaxShaderCompilerThreadsKHR)                          /* 596 */ \
  OP(CreateAndTexStorage2DSharedImageINTERNALImmediate)    /* 597 */ \
  OP(BeginSharedImageAccessDirectCHROMIUM)                 /* 598 */ \
  OP(EndSharedImageAccessDirectCHROMIUM)                   /* 599 */

enum CommandId {
  kOneBeforeStartPoint =
      cmd::kLastCommonId,  // All GLES2 commands start after this.
#define GLES2_CMD_OP(name) k##name,
  GLES2_COMMAND_LIST(GLES2_CMD_OP)
#undef GLES2_CMD_OP
      kNumCommands,
  kFirstGLES2Command = kOneBeforeStartPoint + 1
};

#endif  // GPU_COMMAND_BUFFER_COMMON_GLES2_CMD_IDS_AUTOGEN_H_
