.\" dpkg manual page - dpkg-deb(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011-2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-shlibdeps 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
dpkg\-shlibdeps \- erstelle Substvar\-Abhängigkeiten für Laufzeitbibliotheken
.
.SH ÜBERSICHT
\fBdpkg\-shlibdeps\fP [\fIOption\fP …] [\fB\-e\fP]\fIProgramm\fP [\fIOption\fP …]
.
.SH BESCHREIBUNG
\fBdpkg\-shlibdeps\fP berechnet Abhängigkeiten von Laufzeitbibliotheken für
Programme, deren Name als Argument übergeben werden. Die Abhängigkeiten
werden zu der Datei der Ersetzungsvariablen \fBdebian/substvars\fP als
Variablennamen \fBshlibs:\fP\fIAbhängigkeitsfeld\fP hinzugefügt, wobei
\fIAbhängigkeitsfeld\fP der Feldname einer Abhängigkeit ist. Alle anderen
Variablen, die mit \fBshlibs:\fP beginnen, werden aus der Datei entfernt.
.P
\fBdpkg\-shlibdeps\fP hat zwei mögliche Informationsquellen zur Erstellung der
Abhängigkeitsinformationen. Entweder \fISymbol\fP\- oder
\fIShlibs\fP\-Dateien. \fBdpkg\-shlibdeps\fP findet für jedes Programm, das es
analysiert, die Bibliotheken heraus, gegen die es gelinkt ist. Bei jeder
Bibliothek schaut es entweder in die \fISymbol\fP\- oder in in \fIShlibs\fP\-Datei
(falls erstere nicht existiert odr falls debian/shlibs.local die relevanten
Abhängigkeiten enthält). Beide Dateien sollten von dem Bibliothekspaket
bereitgestellt werden und sollten daher als
%ADMINDIR%/info/\fIPaket\fP.\fISymbol\fP oder %ADMINDIR%/info/\fIPaket\fP.\fIShlibs\fP
verfügbar sein. Der Paketname wird in zwei Schritten identifiziert: zuerst
wird die Bibliotheksdatei auf dem System gefunden (durch Prüfung der
gleichen Verzeichnisse wie bei \fBld.so\fP), dann wird \fBdpkg \-S
\fP\fIBibliotheksdatei\fP verwendet, um das Paket, das die Bibliothek
bereitstellt, zu ermitteln.
.SS Symboldateien
Symboldateien enthalten feiner\-granulare Abhängigkeitsinformationen, indem
sie die Minimalabhängigkeit für jedes von der Bibliothek exportierte Symbol
beschreiben. Das Skript versucht, eine Symboldatei die zu dem
Bibliothekspaket gehört, an den folgenden Orten zuzuordnen (der erste
Treffer wird verwendet):
.IP debian/*/DEBIAN/symbols
Informationen über Laufzeitbibliotheken, die vom aktuellen Bauprozess
erstellt werden, der auch \fBdpkg\-shlibdeps\fP aufruft. Sie werden von
\fBdpkg\-gensymbols\fP(1) erstellt. Sie werden nur verwendet, falls die
Bibliothek im Bau\-Baum des Pakets gefunden wird. Die Symboldatei im Bau\-Baum
hat Vorrang gegenüber Symboldateien aus anderen Binärpaketen.
.IP %PKGCONFDIR%/symbols/\fIPaket\fP.symbols.\fIArchitektur\fP
.IP %PKGCONFDIR%/symbols/\fIPaket\fP.symbols
Systemabhängige Überschreibung der Abhängigkeitsinformationen von
Laufzeitbibliotheken. \fIArchitektur\fP ist die Architektur des aktuellen
Systems (ermittelt durch \fBdpkg\-architecture \-qDEB_HOST_ARCH\fP).
.IP "Ausgabe von „\fBdpkg\-query \-\-control\-path\fP \fIPaket\fP symbols“"
Vom Paket bereitgestellte Abhängigkeitsinformationen für
Laufzeitbibliotheken. Falls nicht durch \fB\-\-admindir\fP überschrieben,
befinden sich solche Dateien unter %ADMINDIR%.
.P
Während des Durchsuchens aller vom Programm verwendeten Symbole erinnert
sich \fBdpkg\-shlibdeps\fP an die größte Minimalversion, die von jeder
Bibliothek benötigt wird. Am Ende des Prozesses ist es in der Lage, die
minimale Abhängigkeit für jede eingesetzte Bibliothek zu schreiben
(vorausgesetzt, die Informationen in den \fISymbol\fP\-Dateien sind korrekt).
.P
Als Sicherheitsmaßnahme kann eine Symbols\-Datei ein Meta\-Informationsfeld
\fBBuild\-Depends\-Package\fP enthalten. \fBdpkg\-shlibdeps\fP ermittelt dann die
minimale Version, die von dem korrespondierenden Paket im Feld
\fBBuild\-Depends\fP benötigt wird, und verwendet diese Version, falls sie höher
ist als die minimale Version, die beim Durchsuchen der Symbole ermittelt
wurde.
.SS Shlibs\-Dateien
Shlibs\-Dateien ordnen Bibliotheken direkt Abhängigkeiten zu (ohne auf die
Symbole zu schauen). Daher ist dies oft stärker als benötigt, aber dafür
sicher und leicht zu handhaben.
.P
Die Abhängigkeiten für eine Bibliothek wird an verschiedenen Stellen
nachgeschlagen. Die erste Datei, die Informationen für die betrachtete
Bibliothek bereitstellt, wird verwendet:
.IP debian/shlibs.local
Paket\-beschränkte Überschreibung der Abhängigkeitsinformationen von
Laufzeitbibliotheken.
.IP %PKGCONFDIR%/shlibs.override
Systemabhängige Überschreibung der Abhängigkeitsinformationen von
Laufzeitbibliotheken.
.IP debian/*/DEBIAN/shlibs
Informationen über Laufzeitbibliotheken, die vom aktuellen Bauprozess
erstellt werden, der auch \fBdpkg\-shlibdeps\fP aufruft. Sie werden nur
verwendet, falls die Bibliothek im Bau\-Verzeichnis eines Pakets gefunden
wird. Die Shlibs\-Datei in diesem Bau\-Verzeichnis hat gegenüber
Shlibs\-Dateien von anderen Binärpaketen Vorrang.
.IP "Ausgabe von „\fBdpkg\-query \-\-control\-path\fP \fIPaket\fP shlibs“"
Vom Paket bereitgestellte Abhängigkeitsinformationen für
Laufzeitbibliotheken. Falls nicht durch \fB\-\-admindir\fP überschrieben,
befinden sich solche Dateien unter %ADMINDIR%.
.IP %PKGCONFDIR%/shlibs.default
Systemabhängige Vorgaben für Abhängigkeitsinformationen von
Laufzeitbibliotheken.
.P
Die entnommenen Abhängigkeiten werden direkt verwendet (es sei den, sie
werden als Dubletten herausgefiltert oder sie sind schwächer als eine andere
Abhängigkeit).
.SH OPTIONEN
\fBdpkg\-shlibdeps\fP interpretiert nicht\-Options\-Argumente als Namen von
ausführbaren Programmen, als ob diese mit \fB\-e\fP\fIProgramm\fP übergeben worden
wären.
.TP 
\fB\-e\fP\fIProgramm\fP
Abhängigkeiten aufnehmen, die für von \fIProgramm\fP benötigte
Laufzeitbibliotheken angemessen sind. Diese Option kann mehrfach angegeben
werden.
.TP 
\fB\-l\fP\fIVerzeichnis\fP
Stellt \fIVerzeichnis\fP der Liste der zu durchsuchenden privaten
Laufzeitbibliotheken voran (seit Dpkg 1.17.0). Diese Option kann mehrfach
angegeben werden.

Hinweis: Verwenden Sie diese Variable, statt \fBLD_LIBRARY_PATH\fP zu setzten,
da diese Umgebungsvariable verwandt wird, um den Laufzeit\-Linker zu steuern
und ihr Missbrauch zum Setzen von Pfaden zu Laufzeitbibliotheken zur Bauzeit
kann beispielsweise beim Cross\-Übersetzen problematisch werden.
.TP 
\fB\-d\fP\fIAbhängigkeitsfeld\fP
Füge Abhängigkeiten hinzu, die zum Abhängigkeitsfeld \fIAbhängigkeitsfeld\fP
der Steuerdatei hinzugefügt werden sollen. (Die Abhängigkeiten für dieses
Feld werden in die Variable \fBshlibs:\fP\fIAbhängigkeitsfeld\fP geschrieben.)

Die Option \fB\-d\fP\fIAbhängigkeitsfeld\fP betrifft alle Programme, die danach
angegeben werden, bis zum nächsten \fB\-d\fP\fIAbhängigkeitsfeld\fP. Der
Standardwert für \fIAbhängigkeitsfeld\fP ist \fBDepends\fP.

Falls der gleiche Abhängigkeitseintrag (oder ein Satz von Alternativen) mehr
als einmal in den erkannten Abhängigkeitsfeldnamen \fBPre\-Depends\fP,
\fBDepends\fP, \fBRecommends\fP, \fBEnhances\fP oder \fBSuggests\fP auftaucht, wird
\fBdpkg\-shlibdeps\fP die Abhängigkeit von allen Feldern außer dem, das die
wichtigsten Abhängigkeiten repräsentiert, entfernen.
.TP 
\fB\-p\fP\fIVariablennamepräfix\fP
Beginn die Ersetzungsvariablen mit \fIVariablennamepräfix\fP\fB:\fP statt mit
\fBshlibs:\fP. Entsprechend werden alle Ersetzungsvariablen, die mit
\fIVariablennamepräfix\fP\fB:\fP (statt mit \fBshlibs:\fP) beginnen, aus den
Ersetzungsvariablen entfernt.
.TP 
\fB\-O\fP[\fIDateiname\fP]
Gebe die Ersetzungsvariableneinstellung in die Standardausgabe (oder nach
\fIDateiname\fP, falls angegeben, seit Dpkg 1.17.2) aus, statt sie zu der
Ersetzungsvariablendatei (standardmäßig (\fBdebian/substvars\fP) hinzuzufügen.
.TP 
\fB\-t\fP\fITyp\fP
Bevorzuge Abhängigkeitsinformationen für Laufzeitbibliotheken, die für ein
vorgegebenes Paket markiert sind. Falls keine Markierungsinformation
verfügbar ist, fällt dies auf unmarkierte Informationen zurück. Der
Standard\-Pakettyp ist \fBdeb\fP. Abhängigkeitsinformationen für
Laufzeitbibliotheken werden für einen vorgegebenen Typ markiert, indem vor
sie der Namen des Typs, ein Doppelpunkt und ein Leerraumzeichen gesetzt
wird.
.TP 
\fB\-L\fP\fIlokale_shlibs\-Datei\fP
Lese die Hinwegsetz\-Abhängigkeiten von Laufzeitbibliotheken aus
\fIlokale_shlibs\-Datei\fP statt aus \fBdebian/shlibs.local\fP.
.TP 
\fB\-T\fP\fIErsetzungsdatei\fP
Schreibe Ersetzungsvariablen in \fISubstvars\-Datei\fP; standardmäßig
\fBdebian/substvars\fP.
.TP 
\fB\-v\fP
Aktiviere ausführlichen Modus (seit Dpkg 1.14.8). Eine Vielzahl von
Nachrichten wird angezeigt, um zu erklären, was \fBdpkg\-shlibdeps\fP
durchführt.
.TP 
\fB\-x\fP\fIPaket\fP
Schließe das Paket von den generierten Abhängigkeiten aus (seit Dpkg
1.14.8). Dies ist für Pakete nützlich, die ELF\-Programmdateien (Programme
oder Bibliothekserweiterungen) bereitstellen, die eine Bibliothek im
gleichen Paket verwenden, um selbst\-Abhängigkeiten zu vermeiden. Diese
Option kann mehrfach verwendet werden, um mehrere Pakete auszuschließen.
.TP 
\fB\-S\fP\fIPaketbauverzeichnis\fP
Schaue beim Versuch, eine Bibliothek zu finden, zuerst in
\fIPaketbauverzeichnis\fP (seit Dpkg 1.14.15). Dies ist nützlich, wenn das
Quellpaket mehrere Spielarten der gleichen Bibliothek baut und Sie
sicherstellen wollen, dass Sie die Abhängigkeit aus einem bestimmten
Binärpaket erhalten. Sie können diese Option mehrfach verwenden:
Verzeichnisse werden in der gleichen Reihenfolge vor Verzeichnissen anderer
Binärpakete probiert.
.TP 
\fB\-I\fP\fIPaketbauverzeichnis\fP
Ignoriert \fIPaketbauverzeichnis\fP bei Schauen nach Shlibs, Symbolen und
gemeinsam benutzten Bibliotheken (seit Dpkg 1.18.5). Sie können diese Option
mehrfach verwenden.
.TP 
\fB\-\-ignore\-missing\-info\fP
Falls keine Abhängigkeitsinformationen für die Laufzeitbibliothek gefunden
werden kann, erfolgt kein Fehlschlag (seit Dpkg 1.14.8). Von der Verwendung
dieser Option wird abgearten, da alle Bibliotheken
Abhängigkeitsinformationen bereitstellen sollten (entweder über
shlibs\-Dateien oder über symbols\-Dateien), selbst falls diese noch nicht von
anderen Paketen verwendet werden.
.TP 
\fB\-\-warnings=\fP\fIWert\fP
\fIWert\fP ist ein Bitfeld, das den Satz an Warnungen definiert, die von
\fBdpkg\-shlibdeps\fP ausgegeben werden können (seit Dpkg 1.14.17). Bit 0
(Wert=1) aktiviert die Warnung „Symbol \fISym\fP, verwendet von \fIProgramm\fP, in
keiner der Bibliotheken gefunden.“, Bit 1 (Wert=2) aktiviert die Warnung
„Das Paket könnte eine nutzlose Abhängigkeit vermeiden“ und Bit 2 (Wert=4)
aktiviert die Warnung „\fIProgramm\fP sollte nicht gegen \fIBibliothek\fP gelinkt
werden“. Standardmäßig ist \fIWert\fP 3: die ersten zwei Warnungen sind
standardmäßig aktiv, die letzte nicht. Setzten Sie \fIWert\fP auf 7, falls Sie
möchten, dass alle Warnungen aktiv sein sollen.
.TP 
\fB\-\-admindir=\fP\fIVerz\fP
Ändert den Ablageort der \fBdpkg\fP\-Datenbank (seit Dpkg 1.14.0). Der
Standardort ist \fI%ADMINDIR%\fP.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Zeige den Bedienungshinweis und beende.
.TP 
\fB\-\-version\fP
Gebe die Version aus und beende sich.
.
.SH DIAGNOSE
.SS Warnungen
Da \fBdpkg\-shlibdeps\fP den Symbolsatz, der von jedem Programm des erstellten
Pakets verwendet wird, analysiert, ist es in mehreren Fällen in der Lage,
Warnungen auszugeben. Sie informieren Sie über Dinge, die im Paket
verbessert werden können. Meistens betreffen diese Verbesserungen direkt die
Quellen der Originalautoren. In der Reihenfolge abnehmender Wichtigkeit
folgen hier die relevanten Warnungen, die auftauchen könnten:
.TP 
\fBSymbol\fP \fI Symbol\fP\fB, verwendet von \fP\fIProgramm\fP\fB, in keiner der Bibliotheken gefunden.\fP
Das angegebene Symbol wurde nicht in den Bibliotheken gefunden, gegen die
das Programm gelinkt wurde. \fIProgramm\fP ist höchstwahrscheinlich eine
Bibliothek und muss mit zusätzlichen Bibliotheken während des Bau\-Prozesses
gelinkt werden (Option \fB\-l\fP\fIBibliothek\fP des Linkers).
.TP 
\fIProgramm\fP\fB enthält eine nicht\-auflösbare Referenz auf Symbol \fP\fISym\fP\fB: wahrscheinlich eine Erweiterung\fP.
Das angegebene Symbol wurde nicht in den Bibliotheken gefunden, die mit
diesem Programm verlinkt sind. Das \fIProgamm\fP ist höchstwahrscheinlich eine
Erweiterung und das Symbol wird von dem Programm bereitgestellt, das diese
Erweiterung lädt. Theoretisch verfügt eine Erweiterung nicht über einen
SONAMEn, allerdings ist dies bei diesem Programm der Fall und daher konnte
es nicht eindeutig als Erweiterung erkannt werden. Die Tatsache, dass dieses
Programm in einem nicht\-öffentlichen Verzeichnis gespeichert wird ist
allerdings ein starkes Anzeichen dafür, dass es keine normale gemeinsam
benutzte Bibliothek ist. Falls dieses Programm tatsächlich eine Erweiterung
ist, ignorieren Sie die Warnung. Allerdings besteht immer die Möglichkeit,
dass es eine echte Bibliothek ist und dass Programme, die damit verlinken,
einen RPATH verwenden, so dass der dynamische Lader sie findet. In diesem
Fall ist die Bibliothek beschädigt und muss repariert werden.
.TP 
\fBDas Paket könnte eine nutzlose Abhängigkeit vermeiden, falls \fP\fIProgramm\fP\fB nicht gegen \fP\fIBibliothek\fP\fB gelinkt wäre (es verwendet keines der Symbole der Bibliothek).\fP
Keines der \fIProgramme\fP die gegen \fIBibliothek\fP gelinkt sind verwendet eines
der von der Bibliothek bereitgestellten Symbole. Indem Sie die Programme
korrigierten, vermieden Sie die Abhängigkeit, die mit dieser Bibliothek
verbunden ist (es sei denn, die Abhängigkeit wird auch durch eine andere
Bibliothek generiert, die diese Bibliothek wirklich verwendet).
.TP 
\fBDas Paket könnte eine nutzlose Abhängigkeit vermeiden, falls \fP\fIProgramme\fP\fB nicht gegen \fP\fIBibliothek\fP\fB gelinkt wären (sie verwenden keines der Symbole der Bibliothek).\fP
Exakt das gleiche wie die obige Warnung, aber für mehrere Programme.
.TP 
\fIProgramm\fP\fB sollte nicht gegen \fP\fIBibliothek\fP\fB gelinkt werden (es verwendet keines der Bibliotheks\-Symbole).\fP
Das \fIProgramm\fP ist gegen eine Bibliothek gelinkt, die es nicht
benötigt. Das ist kein Problem, aber bei der Ladezeit können kleine
Leistungsverbesserungen erreicht werden, indem diese Bibliothek nicht in das
Programm gelinkt wird. Diese Warnung überprüft die gleichen Informationen
wie die vorhergehende, allerdings für jedes Programm statt global für alle
überprüften Programme.
.SS Fehler
\fBdpkg\-shlibdeps\fP wird fehlschlagen, falls es eine vom Programm verwendete
öffentliche Bibliothek nicht finden kann oder falls diese Bibliothek keine
zugeordneten Abhängigkeitsinformationen hat (entweder eine Shlibs\- oder
Symbols\-Datei). Eine öffentliche Bibliothek hat einen SONAME und ist
versioniert (libirgendwas.so.\fIX\fP). Eine private Bibliothek (wie z.B. ein
Erweiterung) sollte keinen SONAME haben und braucht nicht versioniert zu
sein.
.TP 
\fBkonnte Bibliothek \fP\fISONAME\-der\-Bibliothek\fP\fB benötigt von \fP\fIProgramm\fP\fB nicht finden (ihr RPATH ist „\fP\fIrpath\fP\fB“).\fP
Das \fIProgramm\fP verwendet eine Bibliothek mit Namen
\fISONAME\-der\-Bibliothek\fP, aber \fBdpkg\-shlibdeps\fP konnte diese Bibliothek
nicht finden. \fBdpkg\-shlibdeps\fP erstellt folgendermaßen eine Liste der zu
prüfenden Verzeichnisse: im RPATH des Programms aufgeführte Verzeichnisse,
durch die Option \fB\-l\fP hinzugefügte Verzeichnisse, in der Umgebungsvariable
\fBLD_LIBRARY_PATH\fP aufgeführte Verzeichnisse, Cross\-Multiarch\-Verzeichnisse
(z.B. /lib/arm64\-linux\-gnu, /usr/lib/arm64\-linux\-gnu), standardmäßige
öffentliche Verzeichnisse (/lib, /usr/lib), in /etc/ld.so.conf aufgeführte
Verzeichnisse und veraltete Multilib\-Verzeichnisse (/lib32, /usr/lib32,
/lib64, /usr/lib64). Dann prüft es diese Verzeichnisse im Bau\-Baum des
analysierten Pakets, in den mit der Befehlszeilenoption \fB\-S\fP angegebenen
Paketbauverzeichnissen, in anderen Paketbau\-Bäumen, die eine DEBIAN/shlibs\-
oder DEBIAN/symbols\-Datei enthalten und schließlich im
Wurzelverzeichnis. Falls die Bibliothek nicht in einem dieser Verzeichnisse
gefunden wird, erhalten Sie diesen Fehler.

Falls sich die nicht gefundene Bibliothek in einem privaten Verzeichnis des
gleichen Pakets befindet, müssen Sie das Verzeichnis mit \fB\-l\fP
hinzufügen. Falls sie sich in einem anderen gerade zu bauenden Paket
befindet, müssen Sie sicherstellen, dass die „shlibs/symbols“\-Datei dieses
Pakets bereits angelegt ist und dass \fB\-l\fP das geeignete Verzeichnis
enthält, falls die Bibliothek zudem in einem privaten Verzeichnis liegt.
.TP 
\fBKeine Abhängigkeitsinformationen für \fP\fIBibliotheksdatei\fP\fB (verwendet von \fP\fIProgramm\fP\fB) gefunden.\fP
Die von \fIProgramm\fP benötigte Bibliothek wurde von \fBdpkg\-shlibdeps\fP in
\fIBibliotheksdatei\fP gefunden, allerdings konnte \fBdpkg\-shlibdeps\fP keine
Abhängigkeitsinformationen für diese Bibliothek ermitteln. Um die
Abhängigkeit herauszufinden, hat es versucht, die Bibliothek mittels \fBdpkg
\-S \fP\fIBibliotheksdatei\fP auf ein Debian\-Paket abzubilden. Dann überprüfte es
die zugehörigen Shlibs\- und Symboldateien in %ADMINDIR%/info/ und die
verschiedenen Paketbaubäume (debian/*/DEBIAN/).

Dieser Fehlschlag kann durch defekte oder fehlende Shlibs\- oder
Symboldateien im Paket der Bibliothek ausgelöst werden. Er könnte auch
auftreten, falls die Bibliothek im gleichen Quellpaket gebaut wird und die
Shlibs\-Datei noch nicht angelegt wurde (wobei Sie in diesem Fall
debian/rules korrigieren müssen, damit die Shlibs\-Datei erstellt wird bevor
\fBdpkg\-shlibdeps\fP aufgerufen wird). Defekte RPATH können auch dazu führen,
dass die Bibliothek unter nicht\-kanonischen Namen gefunden wird
(beispielsweise /usr/lib/openoffice.org/../lib/libssl.so.0.9.8 statt
/usr/lib/libssl.so.0.9.8), so dass dann diese keinem Paket zugeordnet ist;
\fBdpkg\-shlibdeps\fP versucht dies zu umgehen, indem es auf einen kanonischen
Namen (mittels \fBrealpath\fP(3)) zurückfällt, allerdings könnte dies manchmal
nicht funktionieren. Es ist immer am besten, den RPATH zu bereinigen, um
Probleme zu vermeiden.

Viele weitere Informationen darüber, wo nach Abhängigkeitsinformationen
gesucht wird, können durch einen Aufruf von \fBdpkg\-shlibdeps\fP im
detaillierten Modus (\fB\-v\fP) erhalten werden. Dies kann nützlich sein, falls
Sie nicht verstehen, warum es Ihnen diesen Fehler meldet.
.SH "SIEHE AUCH"
\fBdeb\-shlibs\fP(5), \fBdeb\-symbols\fP(5), \fBdpkg\-gensymbols\fP(1).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2017,2019 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
