.\" dpkg manual page - deb-src-control(5)
.\"
.\" Copyright © 2010 Oxan van Leeuwen <oxan@oxanvanleeuwen.nl>
.\" Copyright © 2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb\-src\-control 5 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
deb\-src\-control \- Debian source packages' master control file format
.
.SH SYNOPSIS
debian/control
.
.SH DESCRIPTION
Each Debian source package contains the master «control» file,
which contains at least 2 paragraphs, separated by a blank line.
The first paragraph lists
all information about the source package in general, while each following
paragraph describes exactly one binary package. Each paragraph consists of at
least one field. A field starts with a fieldname, such as
.B Package
or
.B Section
(case insensitive), followed by a colon, the body of the field and a newline.
Multi-line fields are also allowed, but each supplementary line, without a
fieldname, should start with at least one space. The content of the multi-line
fields is generally joined to a single line by the tools (except in the case of
the
.B Description
field, see below). To insert empty lines into a multi-line
field, insert a dot after the space.
Lines starting with a ‘\fB#\fP’ are treated as comments.
.
.SH SOURCE FIELDS
.TP
.BR Source: " \fIsource-package-name\fP (required)"
The value of this field is the name of the source package, and should
match the name of the source package in the debian/changelog file. A package
name must consist only of lower case letters (a-z), digits (0-9), plus (+) and
minus (-) signs, and periods (.). Package names must be at least two characters
long and must start with an alphanumeric character.

.TP
.BR Maintainer: " \fIfullname-email\fP (recommended)"
Should be in the format «Joe Bloggs <jbloggs@foo.com>», and references the
person who currently maintains the package, as opposed to the author of the
software or the original packager.

.TP
.BI Uploaders: " fullname-email"
Lists all the names and email addresses of co-maintainers of the package, in
the same format as the \fBMaintainer\fP field.
Multiple co-maintainers should be separated by a comma.

.TP
.BI Standards\-Version: " version-string"
This documents the most recent version of the distribution policy standards
this package complies with.

.TP
.BI Homepage: " url"
The upstream project home page URL.

.TP
.BI Bugs: " url"
The \fIurl\fP of the bug tracking system for this package. The current
used format is \fIbts-type\fP\fB://\fP\fIbts-address\fP, like
\fBdebbugs://bugs.debian.org\fP. This field is usually not needed.

.TP
.BI Vcs\-Arch: " url"
.TQ
.BI Vcs\-Bzr: " url"
.TQ
.BI Vcs\-Cvs: " url"
.TQ
.BI Vcs\-Darcs: " url"
.TQ
.BI Vcs\-Git: " url"
.TQ
.BI Vcs\-Hg: " url"
.TQ
.BI Vcs\-Mtn: " url"
.TQ
.BI Vcs\-Svn: " url"
The \fIurl\fP of the Version Control System repository used to maintain this
package. Currently supported are \fBArch\fP, \fBBzr\fP (Bazaar), \fBCvs\fP,
\fBDarcs\fP, \fBGit\fP, \fBHg\fP (Mercurial), \fBMtn\fP (Monotone) and
\fBSvn\fP (Subversion). Usually this field points to the latest version
of the package, such as the main branch or the trunk.

.TP
.BI Vcs\-Browser: " url"
The \fIurl\fP of a webinterface to browse the Version Control System
repository.

.TP
.BI Origin: " name"
The name of the distribution this package is originating from. This field is
usually not needed.

.TP
.BI Section: " section"
This is a general field that gives the package a category based on the
software that it installs.
Some common sections are \fButils\fP, \fBnet\fP, \fBmail\fP, \fBtext\fP,
\fBx11\fP, etc.

.TP
.BI Priority: " priority"
Sets the importance of this package in relation to the system as a whole.
Common priorities are \fBrequired\fP, \fBstandard\fP, \fBoptional\fP,
\fBextra\fP, etc.

The
.B Section
and
.B Priority
fields usually have a defined set of accepted values based on the specific
distribution policy.

.TP
.BI Build\-Depends: " package-list"
A list of packages that need to be installed and configured to be able
to build from source package.
These dependencies need to be satisfied when building binary architecture
dependent or independent packages and source packages.
Including a dependency in this field does not have the exact same effect as
including it in both \fBBuild\-Depends\-Arch\fP and \fBBuild\-Depends\-Indep\fP,
because the dependency also needs to be satisfied when building the source
package.
.
.TP
.BI Build\-Depends\-Arch: " package-list"
Same as \fBBuild\-Depends\fP, but they are only needed when building the
architecture dependent packages. The \fBBuild\-Depends\fP are also
installed in this case. This field is supported since dpkg 1.16.4; in
order to build with older dpkg versions, \fBBuild\-Depends\fP
should be used instead.

.TP
.BI Build\-Depends\-Indep: " package-list"
Same as \fBBuild\-Depends\fP, but they are only needed when building the
architecture independent packages. The \fBBuild\-Depends\fP are also
installed in this case.

.TP
.BI Build\-Conflicts: " package-list"
A list of packages that should not be installed when the package is
built, for example because they interfere with the build system used.
Including a dependency in this list has the same effect as including
it in both \fBBuild\-Conflicts\-Arch\fP and
\fBBuild\-Conflicts\-Indep\fP, with the additional effect of being
used for source-only builds.

.TP
.BI Build\-Conflicts\-Arch: " package-list"
Same as \fBBuild\-Conflicts\fP, but only when building the architecture
dependent packages. This field is supported since dpkg 1.16.4; in
order to build with older dpkg versions, \fBBuild\-Conflicts\fP should
be used instead.

.TP
.BI Build\-Conflicts\-Indep: " package-list"
Same as \fBBuild\-Conflicts\fP, but only when building the architecture
independent packages.

.PP
The syntax of the
.BR Build\-Depends ,
.B Build\-Depends\-Arch
and
.B Build\-Depends\-Indep
fields is a list of groups of alternative packages.
Each group is a list of packages separated by vertical bar (or “pipe”)
symbols, ‘\fB|\fP’.
The groups are separated by commas.
Commas are to be read as “AND”, and pipes as “OR”, with pipes
binding more tightly.
Each package name is optionally followed by an architecture qualifier
appended after a colon ‘\fB:\fP’,
optionally followed by a version number specification in parentheses, an
architecture specification in square brackets, and a restriction formula
consisting of one or more lists of profile names in angle brackets.

The syntax of the
.BR Build\-Conflicts ,
.B Build\-Conflicts\-Arch
and
.B Build\-Conflicts\-Indep
fields is a list of comma-separated package names, where the comma is read
as an “AND”.
Specifying alternative packages using a “pipe” is not supported.
Each package name is optionally followed by a version number specification in
parentheses, an architecture specification in square brackets, and a
restriction formula consisting of one or more lists of profile names in
angle brackets.

An architecture qualifier name can be a real Debian architecture name
(since dpkg 1.16.5), \fBany\fP (since dpkg 1.16.2) or \fBnative\fP
(since dpkg 1.16.5).
If omitted, the default for \fBBuild\-Depends\fP fields is the current host
architecture, the default for \fBBuild\-Conflicts\fP fields is \fBany\fP.
A real Debian architecture name will match exactly that architecture for
that package name, \fBany\fP will match any architecture for that package
name if the package is marked with \fBMulti\-Arch: allowed\fP, and
\fBnative\fP will match the current build architecture if the package
is not marked with \fBMulti\-Arch: foreign\fP.

A version number may start with a ‘\fB>>\fP’, in which case any
later version will match, and may specify or omit the Debian packaging
revision (separated by a hyphen).
Accepted version relationships are ‘\fB>>\fP’ for greater than,
‘\fB<<\fP’ for less than, ‘\fB>=\fP’ for greater than or
equal to, ‘\fB<=\fP’ for less than or equal to, and ‘\fB=\fP’
for equal to.

An architecture specification consists of one or more architecture names,
separated by whitespace. Exclamation marks may be prepended to each of the
names, meaning “NOT”.

A restriction formula consists of one or more restriction lists, separated
by whitespace. Each restriction list is enclosed in angle brackets. Items
in the restriction list are build profile names, separated by whitespace
and can be prefixed with an exclamation mark, meaning “NOT”.
A restriction formula represents a disjunctive normal form expression.

Note that dependencies on packages in the
.B build\-essential
set can be omitted and that declaring build conflicts against them is
impossible. A list of these packages is in the build\-essential package.


.SH BINARY FIELDS

.LP
Note that the
.BR Priority ", " Section
and
.B Homepage
fields can also be in a binary paragraph to override the global value from the
source package.

.TP
.BR Package: " \fIbinary-package-name\fP (required)"
This field is used to name the binary package name. The same restrictions as
to a source package name apply.

.TP
.BR Architecture: " \fIarch\fP|\fBall\fP|\fBany\fP (required)"
The architecture specifies on which type of hardware this package runs. For
packages that run on all architectures, use the
.B any
value. For packages that are architecture independent, such as shell and Perl
scripts or documentation, use the
.B all
value. To restrict the packages to a certain set of architectures, specify the
architecture names, separated by a space. It's also possible to put
architecture wildcards in that list (see
.BR dpkg\-architecture (1)
for more information about them).

.TP
.BR Build\-Profiles: " \fIrestriction-formula\fP"
This field specifies the conditions for which this binary package does or
does not build.
To express that condition, the same restriction formula syntax from the
\fBBuild\-Depends\fP field is used.

If a binary package paragraph does not contain this field, then it implicitly
means that it builds with all build profiles (including none at all).

In other words, if a binary package paragraph is annotated with a non-empty
\fBBuild\-Profiles\fP field, then this binary package is generated if and
only if the condition expressed by the conjunctive normal form expression
evaluates to true.

.TP
.BR Package\-Type: " \fBdeb\fP|\fBudeb\fP"
This field defines the type of the package.
\fBudeb\fP is for size-constrained packages used by the debian installer.
\fBdeb\fP is the default value, it is assumed if the field is absent.
More types might be added in the future.

.TP
.BI Subarchitecture: " value"
.TQ
.BI Kernel\-Version: " value"
.TQ
.BI Installer\-Menu\-Item: " value"
These fields are used by the debian\-installer and are usually not needed.
See /usr/share/doc/debian\-installer/devel/modules.txt from the
.B debian\-installer
package for more details about them.

.TP
.BR Essential: " \fByes\fP|\fBno\fP"
.TQ
.BR Build\-Essential: " \fByes\fP|\fBno\fP"
.TQ
.BR Multi\-Arch: " \fBsame\fP|\fBforeign\fP|\fBallowed\fP|\fBno\fP"
.TQ
.BI Tag: " tag-list"
.TQ
.BR Description: " \fIshort-description\fP (recommended)"
These fields are described in the
.BR deb\-control (5)
manual page, as they are copied literally to the control file of the binary
package.

.TP
.BI Depends: " package-list"
.TQ
.BI Pre\-Depends: " package-list"
.TQ
.BI Recommends: " package-list"
.TQ
.BI Suggests: " package-list"
.TQ
.BI Breaks: " package-list"
.TQ
.BI Enhances: " package-list"
.TQ
.BI Replaces: " package-list"
.TQ
.BI Conflicts: " package-list"
.TQ
.BI Provides: " package-list"
.TQ
.BI Built\-Using: " package-list"
These fields declare relationships between packages. They are discussed in
the
.BR deb\-control (5)
manpage.

.SH USER-DEFINED FIELDS
It is allowed to add additional user-defined fields to the control file. The
tools will ignore these fields. If you want the fields to be copied over to
the output files, such as the binary packages, you need to use a custom naming
scheme: the fields should start with an \fBX\fP, followed by zero or more of
the letters \fBBCS\fP and a hyphen.

.TP
.B B
The field will appear in the control file in the binary package, see
\fBdeb\-control\fP(5).
.TP
.B S
The field will appear in the source package control file, see \fBdsc\fP(5).
.TP
.B C
The field will appear in the upload control (.changes) file, see
\fBdeb\-changes\fP(5).

.P
Note that the \fBX\fP[\fBBCS\fP]\fB\-\fP prefixes are stripped when the
fields are copied over to the output files. A field \fBXC\-Approved\-By\fP
will appear as \fBApproved\-By\fP in the changes file and will not appear
in the binary or source package control files.

Take into account that these user-defined fields will be using the global
namespace, which might at some point in the future collide with officially
recognized fields. To avoid such potential situation you can prefix those
fields with \fBPrivate\-\fP, such as \fBXB\-Private\-New\-Field\fP.

.SH EXAMPLE
.\" .RS
.nf
# Comment
Source: dpkg
Section: admin
Priority: required
Maintainer: Dpkg Developers <debian\-dpkg@lists.debian.org>
# this field is copied to the binary and source packages
XBS\-Upstream\-Release\-Status: stable
Homepage: https://wiki.debian.org/Teams/Dpkg
Vcs\-Browser: https://git.dpkg.org/cgit/dpkg/dpkg.git
Vcs\-Git: https://git.dpkg.org/git/dpkg/dpkg.git
Standards\-Version: 3.7.3
Build\-Depends: pkg\-config, debhelper (>= 4.1.81),
 libselinux1\-dev (>= 1.28\-4) [!linux\-any]

Package: dpkg\-dev
Section: utils
Priority: optional
Architecture: all
# this is a custom field in the binary package
XB\-Mentoring\-Contact: Raphael Hertzog <hertzog@debian.org>
Depends: dpkg (>= 1.14.6), perl5, perl\-modules, cpio (>= 2.4.2\-2),
 bzip2, lzma, patch (>= 2.2\-1), make, binutils, libtimedate\-perl
Recommends: gcc | c\-compiler, build\-essential
Suggests: gnupg, debian\-keyring
Conflicts: dpkg\-cross (<< 2.0.0), devscripts (<< 2.10.26)
Replaces: manpages\-pl (<= 20051117\-1)
Description: Debian package development tools
 This package provides the development tools (including dpkg\-source)
 required to unpack, build and upload Debian source packages.
 .
 Most Debian source packages will require additional tools to build;
 for example, most packages need make and the C compiler gcc.
.fi
.\" .RE


.SH SEE ALSO
.BR deb\-control (5),
.BR deb\-version (5),
.BR dpkg\-source (1)
