/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.graphics.PointF;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.ScrollView;
import android.widget.SlidingDrawer;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.ToggleButton;
import com.robotium.solo.ActivityUtils;
import com.robotium.solo.Asserter;
import com.robotium.solo.By;
import com.robotium.solo.Checker;
import com.robotium.solo.Clicker;
import com.robotium.solo.Condition;
import com.robotium.solo.DialogUtils;
import com.robotium.solo.Getter;
import com.robotium.solo.Illustration;
import com.robotium.solo.Illustrator;
import com.robotium.solo.Presser;
import com.robotium.solo.Rotator;
import com.robotium.solo.ScreenshotTaker;
import com.robotium.solo.Scroller;
import com.robotium.solo.Searcher;
import com.robotium.solo.Sender;
import com.robotium.solo.Setter;
import com.robotium.solo.Sleeper;
import com.robotium.solo.Swiper;
import com.robotium.solo.SystemUtils;
import com.robotium.solo.Tapper;
import com.robotium.solo.TextEnterer;
import com.robotium.solo.Timeout;
import com.robotium.solo.ViewFetcher;
import com.robotium.solo.Waiter;
import com.robotium.solo.WebElement;
import com.robotium.solo.WebUtils;
import com.robotium.solo.Zoomer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solo {
    protected final Asserter asserter;
    protected final ViewFetcher viewFetcher;
    protected final Checker checker;
    protected final Clicker clicker;
    protected final Presser presser;
    protected final Searcher searcher;
    protected final ActivityUtils activityUtils;
    protected final DialogUtils dialogUtils;
    protected final TextEnterer textEnterer;
    protected final Rotator rotator;
    protected final Scroller scroller;
    protected final Sleeper sleeper;
    protected final Swiper swiper;
    protected final Tapper tapper;
    protected final Illustrator illustrator;
    protected final Waiter waiter;
    protected final Setter setter;
    protected final Getter getter;
    protected final WebUtils webUtils;
    protected final Sender sender;
    protected final ScreenshotTaker screenshotTaker;
    protected final Instrumentation instrumentation;
    protected final Zoomer zoomer;
    protected final SystemUtils systemUtils;
    protected String webUrl = null;
    private final Config config;
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int RIGHT = 22;
    public static final int LEFT = 21;
    public static final int UP = 19;
    public static final int DOWN = 20;
    public static final int ENTER = 66;
    public static final int MENU = 82;
    public static final int DELETE = 67;
    public static final int CLOSED = 0;
    public static final int OPENED = 1;

    public Solo(Instrumentation instrumentation, Activity activity) {
        this(new Config(), instrumentation, activity);
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("Solo(" + instrumentation + ", " + activity + ")"));
        }
    }

    public Solo(Instrumentation instrumentation, Config config) {
        this(config, instrumentation, null);
        if (config.commandLogging) {
            Log.d((String)config.commandLoggingTag, (String)("Solo(" + instrumentation + ", " + config + ")"));
        }
    }

    public Solo(Instrumentation instrumentation, Config config, Activity activity) {
        this(config, instrumentation, activity);
        if (config.commandLogging) {
            Log.d((String)config.commandLoggingTag, (String)("Solo(" + instrumentation + ", " + config + ", " + activity + ")"));
        }
    }

    private Solo(Config config, Instrumentation instrumentation, Activity activity) {
        if (config.commandLogging) {
            Log.d((String)config.commandLoggingTag, (String)("Solo(" + config + ", " + instrumentation + ", " + activity + ")"));
        }
        this.config = config == null ? new Config() : config;
        this.instrumentation = instrumentation;
        this.sleeper = new Sleeper();
        this.sender = new Sender(instrumentation, this.sleeper);
        this.activityUtils = new ActivityUtils(config, instrumentation, activity, this.sleeper);
        this.viewFetcher = new ViewFetcher(instrumentation, this.sleeper);
        this.screenshotTaker = new ScreenshotTaker(config, instrumentation, this.activityUtils, this.viewFetcher, this.sleeper);
        this.dialogUtils = new DialogUtils(instrumentation, this.activityUtils, this.viewFetcher, this.sleeper);
        this.webUtils = new WebUtils(config, instrumentation, this.viewFetcher, this.sleeper);
        this.scroller = new Scroller(config, instrumentation, this.viewFetcher, this.sleeper);
        this.searcher = new Searcher(this.viewFetcher, this.webUtils, this.scroller, this.sleeper);
        this.waiter = new Waiter(instrumentation, this.activityUtils, this.viewFetcher, this.searcher, this.scroller, this.sleeper);
        this.getter = new Getter(instrumentation, this.activityUtils, this.waiter);
        this.clicker = new Clicker(this.activityUtils, this.viewFetcher, this.sender, instrumentation, this.sleeper, this.waiter, this.webUtils, this.dialogUtils);
        this.setter = new Setter(this.activityUtils, this.getter, this.clicker, this.waiter);
        this.asserter = new Asserter(this.activityUtils, this.waiter);
        this.checker = new Checker(this.viewFetcher, this.waiter);
        this.zoomer = new Zoomer(instrumentation);
        this.swiper = new Swiper(instrumentation);
        this.tapper = new Tapper(instrumentation);
        this.illustrator = new Illustrator(instrumentation);
        this.rotator = new Rotator(instrumentation);
        this.presser = new Presser(this.viewFetcher, this.clicker, instrumentation, this.sleeper, this.waiter, this.dialogUtils);
        this.textEnterer = new TextEnterer(instrumentation, this.clicker, this.dialogUtils);
        this.systemUtils = new SystemUtils(instrumentation);
        this.initialize();
    }

    public Solo(Instrumentation instrumentation) {
        this(new Config(), instrumentation, null);
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("Solo(" + instrumentation + ")"));
        }
    }

    public Instrumentation.ActivityMonitor getActivityMonitor() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"getActivityMonitor()");
        }
        return this.activityUtils.getActivityMonitor();
    }

    public Config getConfig() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"getConfig()");
        }
        return this.config;
    }

    public ArrayList<View> getViews() {
        try {
            if (this.config.commandLogging) {
                Log.d((String)this.config.commandLoggingTag, (String)"getViews()");
            }
            return this.viewFetcher.getViews(null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<View> getViews(View parent) {
        try {
            if (this.config.commandLogging) {
                Log.d((String)this.config.commandLoggingTag, (String)"getViews()");
            }
            return this.viewFetcher.getViews(parent, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public View getTopParent(View view) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getTopParent(" + view + ")"));
        }
        View topParent = this.viewFetcher.getTopParent(view);
        return topParent;
    }

    public boolean waitForText(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForText(\"" + text + "\")"));
        }
        return this.waiter.waitForText(text) != null;
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForText(\"" + text + "\", " + minimumNumberOfMatches + ", " + timeout + ")"));
        }
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout) != null;
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout, boolean scroll) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForText(\"" + text + "\", " + minimumNumberOfMatches + ", " + timeout + ", " + scroll + ")"));
        }
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout, scroll) != null;
    }

    public boolean waitForText(String text, int minimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForText(\"" + text + "\", " + minimumNumberOfMatches + ", " + timeout + ", " + scroll + ", " + onlyVisible + ")"));
        }
        return this.waiter.waitForText(text, minimumNumberOfMatches, timeout, scroll, onlyVisible, true) != null;
    }

    public boolean waitForView(int id) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + id + ")"));
        }
        return this.waitForView(id, 0, Timeout.getLargeTimeout(), true);
    }

    public boolean waitForView(int id, int minimumNumberOfMatches, int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + id + ", " + minimumNumberOfMatches + ", " + timeout + ")"));
        }
        return this.waitForView(id, minimumNumberOfMatches, timeout, true);
    }

    public boolean waitForView(int id, int minimumNumberOfMatches, int timeout, boolean scroll) {
        int index;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + id + ", " + minimumNumberOfMatches + ", " + timeout + ", " + scroll + ")"));
        }
        if ((index = minimumNumberOfMatches - 1) < 1) {
            index = 0;
        }
        return this.waiter.waitForView(id, index, timeout, scroll) != null;
    }

    public boolean waitForView(Object tag) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + tag + ")"));
        }
        return this.waitForView(tag, 0, Timeout.getLargeTimeout(), true);
    }

    public boolean waitForView(Object tag, int minimumNumberOfMatches, int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + tag + ", " + minimumNumberOfMatches + ", " + timeout + ")"));
        }
        return this.waitForView(tag, minimumNumberOfMatches, timeout, true);
    }

    public boolean waitForView(Object tag, int minimumNumberOfMatches, int timeout, boolean scroll) {
        int index;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + tag + ", " + minimumNumberOfMatches + ", " + timeout + ", " + scroll + ")"));
        }
        if ((index = minimumNumberOfMatches - 1) < 1) {
            index = 0;
        }
        return this.waiter.waitForView(tag, index, timeout, scroll) != null;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + viewClass + ")"));
        }
        return this.waiter.waitForView(viewClass, 0, Timeout.getLargeTimeout(), true);
    }

    public <T extends View> boolean waitForView(View view) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + view + ")"));
        }
        return this.waiter.waitForView(view);
    }

    public <T extends View> boolean waitForView(View view, int timeout, boolean scroll) {
        View viewToWaitFor;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + view + ", " + timeout + ", " + scroll + ")"));
        }
        boolean checkIsShown = false;
        if (!scroll) {
            checkIsShown = true;
        }
        return (viewToWaitFor = this.waiter.waitForView(view, timeout, scroll, checkIsShown)) != null;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int minimumNumberOfMatches, int timeout) {
        int index;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + viewClass + ", " + minimumNumberOfMatches + ", " + timeout + ")"));
        }
        if ((index = minimumNumberOfMatches - 1) < 1) {
            index = 0;
        }
        return this.waiter.waitForView(viewClass, index, timeout, true);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int minimumNumberOfMatches, int timeout, boolean scroll) {
        int index;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForView(" + viewClass + ", " + minimumNumberOfMatches + ", " + timeout + ", " + scroll + ")"));
        }
        if ((index = minimumNumberOfMatches - 1) < 1) {
            index = 0;
        }
        return this.waiter.waitForView(viewClass, index, timeout, scroll);
    }

    public boolean waitForWebElement(By by) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForWebElement(" + by + ")"));
        }
        return this.waiter.waitForWebElement(by, 0, Timeout.getLargeTimeout(), true) != null;
    }

    public boolean waitForWebElement(By by, int timeout, boolean scroll) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForWebElement(" + by + ", " + timeout + ", " + scroll + ")"));
        }
        return this.waiter.waitForWebElement(by, 0, timeout, scroll) != null;
    }

    public boolean waitForWebElement(By by, int minimumNumberOfMatches, int timeout, boolean scroll) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForWebElement(" + by + ", " + minimumNumberOfMatches + "," + timeout + ", " + scroll + ")"));
        }
        return this.waiter.waitForWebElement(by, minimumNumberOfMatches, timeout, scroll) != null;
    }

    public boolean waitForCondition(Condition condition, int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForCondition(" + condition + "," + timeout + ")"));
        }
        return this.waiter.waitForCondition(condition, timeout);
    }

    public boolean searchEditText(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchEditText(\"" + text + "\")"));
        }
        return this.searcher.searchWithTimeoutFor(EditText.class, text, 1, true, false);
    }

    public boolean searchButton(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchButton(\"" + text + "\")"));
        }
        return this.searcher.searchWithTimeoutFor(Button.class, text, 0, true, false);
    }

    public boolean searchButton(String text, boolean onlyVisible) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchButton(\"" + text + "\", " + onlyVisible + ")"));
        }
        return this.searcher.searchWithTimeoutFor(Button.class, text, 0, true, onlyVisible);
    }

    public boolean searchToggleButton(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchToggleButton(\"" + text + "\")"));
        }
        return this.searcher.searchWithTimeoutFor(ToggleButton.class, text, 0, true, false);
    }

    public boolean searchButton(String text, int minimumNumberOfMatches) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchButton(\"" + text + "\", " + minimumNumberOfMatches + ")"));
        }
        return this.searcher.searchWithTimeoutFor(Button.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchButton(String text, int minimumNumberOfMatches, boolean onlyVisible) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchButton(\"" + text + "\", " + minimumNumberOfMatches + ", " + onlyVisible + ")"));
        }
        return this.searcher.searchWithTimeoutFor(Button.class, text, minimumNumberOfMatches, true, onlyVisible);
    }

    public boolean searchToggleButton(String text, int minimumNumberOfMatches) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchToggleButton(\"" + text + "\", " + minimumNumberOfMatches + ")"));
        }
        return this.searcher.searchWithTimeoutFor(ToggleButton.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchText(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchText(\"" + text + "\")"));
        }
        return this.searcher.searchWithTimeoutFor(TextView.class, text, 0, true, false);
    }

    public boolean searchText(String text, boolean onlyVisible) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchText(\"" + text + "\", " + onlyVisible + ")"));
        }
        return this.searcher.searchWithTimeoutFor(TextView.class, text, 0, true, onlyVisible);
    }

    public boolean searchText(String text, int minimumNumberOfMatches) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchText(\"" + text + "\", " + minimumNumberOfMatches + ")"));
        }
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, true, false);
    }

    public boolean searchText(String text, int minimumNumberOfMatches, boolean scroll) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchText(\"" + text + "\", " + minimumNumberOfMatches + ", " + scroll + ")"));
        }
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, scroll, false);
    }

    public boolean searchText(String text, int minimumNumberOfMatches, boolean scroll, boolean onlyVisible) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("searchText(\"" + text + "\", " + minimumNumberOfMatches + ", " + scroll + ", " + onlyVisible + ")"));
        }
        return this.searcher.searchWithTimeoutFor(TextView.class, text, minimumNumberOfMatches, scroll, onlyVisible);
    }

    public void setActivityOrientation(int orientation) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setActivityOrientation(" + orientation + ")"));
        }
        this.activityUtils.setActivityOrientation(orientation);
    }

    public Activity getCurrentActivity() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"getCurrentActivity()");
        }
        return this.activityUtils.getCurrentActivity(false);
    }

    public void assertCurrentActivity(String message, String name) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("assertCurrentActivity(\"" + message + "\", \"" + name + "\")"));
        }
        this.asserter.assertCurrentActivity(message, name);
    }

    public void assertCurrentActivity(String message, Class activityClass) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("assertCurrentActivity(" + message + ", " + activityClass + ")"));
        }
        this.asserter.assertCurrentActivity(message, activityClass);
    }

    public void assertCurrentActivity(String message, String name, boolean isNewInstance) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("assertCurrentActivity(" + message + ", " + name + ", " + isNewInstance + ")"));
        }
        this.asserter.assertCurrentActivity(message, name, isNewInstance);
    }

    public void assertCurrentActivity(String message, Class activityClass, boolean isNewInstance) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("assertCurrentActivity(\"" + message + "\", " + activityClass + ", " + isNewInstance + ")"));
        }
        this.asserter.assertCurrentActivity(message, activityClass, isNewInstance);
    }

    public void assertMemoryNotLow() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"assertMemoryNotLow()");
        }
        this.asserter.assertMemoryNotLow();
    }

    public boolean waitForDialogToOpen() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"waitForDialogToOpen()");
        }
        return this.dialogUtils.waitForDialogToOpen(Timeout.getLargeTimeout(), true);
    }

    public boolean waitForDialogToClose() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"waitForDialogToClose()");
        }
        return this.dialogUtils.waitForDialogToClose(Timeout.getLargeTimeout());
    }

    public boolean waitForDialogToOpen(long timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForDialogToOpen(" + timeout + ")"));
        }
        return this.dialogUtils.waitForDialogToOpen(timeout, true);
    }

    public boolean waitForDialogToClose(long timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForDialogToClose(" + timeout + ")"));
        }
        return this.dialogUtils.waitForDialogToClose(timeout);
    }

    public void goBack() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"goBack()");
        }
        this.hideSoftKeyboard();
        this.sender.goBack();
    }

    public void clickOnScreen(float x, float y) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnScreen(" + x + ", " + y + ")"));
        }
        this.sleeper.sleep();
        this.clicker.clickOnScreen(x, y, null);
    }

    public void clickOnScreen(float x, float y, int numberOfClicks) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnScreen(" + x + ", " + y + ", " + numberOfClicks + ")"));
        }
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("clickOnScreen(float x, float y, int numberOfClicks) requires API level >= 14");
        }
        this.tapper.generateTapGesture(numberOfClicks, new PointF(x, y));
    }

    public void clickLongOnScreen(float x, float y) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnScreen(" + x + ", " + y + ")"));
        }
        this.clicker.clickLongOnScreen(x, y, 0, null);
    }

    public void clickLongOnScreen(float x, float y, int time) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnScreen(" + x + ", " + y + ", " + time + ")"));
        }
        this.clicker.clickLongOnScreen(x, y, time, null);
    }

    public void clickOnButton(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnButton(\"" + text + "\")"));
        }
        this.clicker.clickOn(Button.class, text);
    }

    public void clickOnImageButton(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnImageButton(" + index + ")"));
        }
        this.clicker.clickOn(ImageButton.class, index);
    }

    public void clickOnToggleButton(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnToggleButton(\"" + text + "\")"));
        }
        this.clicker.clickOn(ToggleButton.class, text);
    }

    public void clickOnMenuItem(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnMenuItem(\"" + text + "\")"));
        }
        this.clicker.clickOnMenuItem(text);
    }

    public void clickOnMenuItem(String text, boolean subMenu) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnMenuItem(\"" + text + "\", " + subMenu + ")"));
        }
        this.clicker.clickOnMenuItem(text, subMenu);
    }

    public void clickOnWebElement(WebElement webElement) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnWebElement(" + webElement + ")"));
        }
        if (webElement == null) {
            Assert.fail((String)"WebElement is null and can therefore not be clicked!");
        }
        this.clicker.clickOnScreen(webElement.getLocationX(), webElement.getLocationY(), null);
    }

    public void clickOnWebElement(By by) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnWebElement(" + by + ")"));
        }
        this.clickOnWebElement(by, 0, true);
    }

    public void clickOnWebElement(By by, int match) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnWebElement(" + by + ", " + match + ")"));
        }
        this.clickOnWebElement(by, match, true);
    }

    public void clickOnWebElement(By by, int match, boolean scroll) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnWebElement(" + by + ", " + match + ", " + scroll + ")"));
        }
        this.clicker.clickOnWebElement(by, match, scroll, this.config.useJavaScriptToClickWebElements);
    }

    public void pressMenuItem(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("pressMenuItem(" + index + ")"));
        }
        this.presser.pressMenuItem(index);
    }

    public void pressMenuItem(int index, int itemsPerRow) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("pressMenuItem(" + index + ", " + itemsPerRow + ")"));
        }
        this.presser.pressMenuItem(index, itemsPerRow);
    }

    public void pressSoftKeyboardNextButton() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"pressSoftKeyboardNextButton()");
        }
        this.presser.pressSoftKeyboard(5);
    }

    public void pressSoftKeyboardSearchButton() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"pressSoftKeyboardSearchButton()");
        }
        this.presser.pressSoftKeyboard(3);
    }

    public void pressSoftKeyboardGoButton() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"pressSoftKeyboardGoButton()");
        }
        this.presser.pressSoftKeyboard(2);
    }

    public void pressSoftKeyboardDoneButton() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"pressSoftKeyboardDoneButton()");
        }
        this.presser.pressSoftKeyboard(6);
    }

    public void pressSpinnerItem(int spinnerIndex, int itemIndex) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("pressSpinnerItem(" + spinnerIndex + ", " + itemIndex + ")"));
        }
        this.presser.pressSpinnerItem(spinnerIndex, itemIndex);
    }

    public void clickOnView(View view) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnView(" + view + ")"));
        }
        view = this.waiter.waitForView(view, Timeout.getSmallTimeout());
        this.clicker.clickOnScreen(view);
    }

    public void clickOnView(View view, boolean immediately) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnView(" + view + ", " + immediately + ")"));
        }
        if (immediately) {
            this.clicker.clickOnScreen(view);
        } else {
            view = this.waiter.waitForView(view, Timeout.getSmallTimeout());
            this.clicker.clickOnScreen(view);
        }
    }

    public void clickLongOnView(View view) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnView(" + view + ")"));
        }
        view = this.waiter.waitForView(view, Timeout.getSmallTimeout());
        this.clicker.clickOnScreen(view, true, 0);
    }

    public void clickLongOnView(View view, int time) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnView(" + view + ", " + time + ")"));
        }
        this.clicker.clickOnScreen(view, true, time);
    }

    public void clickOnText(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnText(\"" + text + "\")"));
        }
        this.clicker.clickOnText(text, false, 1, true, 0);
    }

    public void clickOnText(String text, int match) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnText(\"" + text + "\", " + match + ")"));
        }
        this.clicker.clickOnText(text, false, match, true, 0);
    }

    public void clickOnText(String text, int match, boolean scroll) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnText(\"" + text + "\", " + match + ", " + scroll + ")"));
        }
        this.clicker.clickOnText(text, false, match, scroll, 0);
    }

    public void clickLongOnText(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnText(\"" + text + "\")"));
        }
        this.clicker.clickOnText(text, true, 1, true, 0);
    }

    public void clickLongOnText(String text, int match) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnText(\"" + text + "\", " + match + ")"));
        }
        this.clicker.clickOnText(text, true, match, true, 0);
    }

    public void clickLongOnText(String text, int match, boolean scroll) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnText(\"" + text + "\", " + match + ", " + scroll + ")"));
        }
        this.clicker.clickOnText(text, true, match, scroll, 0);
    }

    public void clickLongOnText(String text, int match, int time) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnText(\"" + text + "\", " + match + ", " + time + ")"));
        }
        this.clicker.clickOnText(text, true, match, true, time);
    }

    public void clickLongOnTextAndPress(String text, int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongOnTextAndPress(\"" + text + "\", " + index + ")"));
        }
        this.clicker.clickLongOnTextAndPress(text, index);
    }

    public void clickOnButton(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnButton(" + index + ")"));
        }
        this.clicker.clickOn(Button.class, index);
    }

    public void clickOnRadioButton(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnRadioButton(" + index + ")"));
        }
        this.clicker.clickOn(RadioButton.class, index);
    }

    public void clickOnCheckBox(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnCheckBox(" + index + ")"));
        }
        this.clicker.clickOn(CheckBox.class, index);
    }

    public void clickOnEditText(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnEditText(" + index + ")"));
        }
        this.clicker.clickOn(EditText.class, index);
    }

    public ArrayList<TextView> clickInList(int line) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickInList(" + line + ")"));
        }
        return this.clicker.clickInList(line);
    }

    public ArrayList<TextView> clickInList(int line, int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickInList(" + line + ", " + index + ")"));
        }
        return this.clicker.clickInList(line, index, false, 0);
    }

    public ArrayList<TextView> clickLongInList(int line) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongInList(" + line + ")"));
        }
        return this.clicker.clickInList(line, 0, true, 0);
    }

    public ArrayList<TextView> clickLongInList(int line, int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongInList(" + line + ", " + index + ")"));
        }
        return this.clicker.clickInList(line, index, true, 0);
    }

    public ArrayList<TextView> clickLongInList(int line, int index, int time) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongInList(" + line + ", " + index + ", " + time + ")"));
        }
        return this.clicker.clickInList(line, index, true, time);
    }

    public ArrayList<TextView> clickInRecyclerView(int itemIndex) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickInRecyclerView(" + itemIndex + ")"));
        }
        return this.clicker.clickInRecyclerView(itemIndex);
    }

    public ArrayList<TextView> clickInRecyclerView(int itemIndex, int recyclerViewIndex) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickInRecyclerView(" + itemIndex + ", " + recyclerViewIndex + ")"));
        }
        return this.clicker.clickInRecyclerView(itemIndex, recyclerViewIndex, false, 0);
    }

    public ArrayList<TextView> clickLongInRecycleView(int itemIndex) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongInRecycleView(" + itemIndex + ")"));
        }
        return this.clicker.clickInRecyclerView(itemIndex, 0, true, 0);
    }

    public ArrayList<TextView> clickLongInRecycleView(int itemIndex, int recyclerViewIndex) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongInRecycleView(" + itemIndex + ", " + recyclerViewIndex + ")"));
        }
        return this.clicker.clickInRecyclerView(itemIndex, recyclerViewIndex, true, 0);
    }

    public ArrayList<TextView> clickLongInRecycleView(int itemIndex, int recyclerViewIndex, int time) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickLongInRecycleView(" + itemIndex + ", " + recyclerViewIndex + ", " + time + ")"));
        }
        return this.clicker.clickInRecyclerView(itemIndex, recyclerViewIndex, true, time);
    }

    public void clickOnActionBarItem(int id) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnActionBarItem(" + id + ")"));
        }
        this.clicker.clickOnActionBarItem(id);
    }

    public void clickOnActionBarHomeButton() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"clickOnActionBarHomeButton()");
        }
        this.instrumentation.runOnMainSync(new Runnable(){

            public void run() {
                Solo.this.clicker.clickOnActionBarHomeButton();
            }
        });
    }

    public Illustration.Builder createIllustrationBuilder() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"createIllustrationBuilder()");
        }
        return new Illustration.Builder();
    }

    public void illustrate(Illustration illustration) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("illustrate(" + illustration + ")"));
        }
        this.illustrator.illustrate(illustration);
    }

    public void drag(float fromX, float toX, float fromY, float toY, int stepCount) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("drag(" + fromX + ", " + toX + ", " + fromY + ", " + toY + ")"));
        }
        this.dialogUtils.hideSoftKeyboard(null, false, true);
        this.scroller.drag(fromX, toX, fromY, toY, stepCount);
    }

    public boolean scrollDown() {
        View recyclerView;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"scrollDown()");
        }
        if ((recyclerView = this.viewFetcher.getRecyclerView(true, 0)) != null) {
            this.waiter.waitForViews(true, AbsListView.class, ScrollView.class, WebView.class, recyclerView.getClass());
        } else {
            this.waiter.waitForViews(true, AbsListView.class, ScrollView.class, WebView.class);
        }
        return this.scroller.scroll(0);
    }

    public void scrollToBottom() {
        View recyclerView;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"scrollToBottom()");
        }
        if ((recyclerView = this.viewFetcher.getRecyclerView(true, 0)) != null) {
            this.waiter.waitForViews(true, AbsListView.class, ScrollView.class, WebView.class, recyclerView.getClass());
        } else {
            this.waiter.waitForViews(true, AbsListView.class, ScrollView.class, WebView.class);
        }
        this.scroller.scroll(0, true);
    }

    public boolean scrollUp() {
        View recyclerView;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"scrollUp()");
        }
        if ((recyclerView = this.viewFetcher.getRecyclerView(true, 0)) != null) {
            this.waiter.waitForViews(true, AbsListView.class, ScrollView.class, WebView.class, recyclerView.getClass());
        } else {
            this.waiter.waitForViews(true, AbsListView.class, ScrollView.class, WebView.class);
        }
        return this.scroller.scroll(1);
    }

    public void scrollToTop() {
        View recyclerView;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"scrollToTop()");
        }
        if ((recyclerView = this.viewFetcher.getRecyclerView(true, 0)) != null) {
            this.waiter.waitForViews(true, AbsListView.class, ScrollView.class, WebView.class, recyclerView.getClass());
        } else {
            this.waiter.waitForViews(true, AbsListView.class, ScrollView.class, WebView.class);
        }
        this.scroller.scroll(1, true);
    }

    public boolean scrollDownList(AbsListView list) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollDownList(" + list + ")"));
        }
        return this.scroller.scrollList(list, 0, false);
    }

    public boolean scrollListToBottom(AbsListView list) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollListToBottom(" + list + ")"));
        }
        return this.scroller.scrollList(list, 0, true);
    }

    public boolean scrollUpList(AbsListView list) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollUpList(" + list + ")"));
        }
        return this.scroller.scrollList(list, 1, false);
    }

    public boolean scrollListToTop(AbsListView list) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollListToTop(" + list + ")"));
        }
        return this.scroller.scrollList(list, 1, true);
    }

    public boolean scrollDownList(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollDownList(" + index + ")"));
        }
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 0, false);
    }

    public boolean scrollListToBottom(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollListToBottom(" + index + ")"));
        }
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 0, true);
    }

    public boolean scrollUpList(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollUpList(" + index + ")"));
        }
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 1, false);
    }

    public boolean scrollListToTop(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollListToTop(" + index + ")"));
        }
        return this.scroller.scrollList((AbsListView)this.waiter.waitForAndGetView(index, ListView.class), 1, true);
    }

    public void scrollListToLine(AbsListView absListView, int line) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollListToLine(" + absListView + ", " + line + ")"));
        }
        this.scroller.scrollListToLine(absListView, line);
    }

    public void scrollListToLine(int index, int line) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollListToLine(" + index + ", " + line + ")"));
        }
        this.scroller.scrollListToLine(this.waiter.waitForAndGetView(index, AbsListView.class), line);
    }

    public boolean scrollDownRecyclerView(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollDownRecyclerView(" + index + ")"));
        }
        if (!this.config.shouldScroll) {
            return true;
        }
        ViewGroup recyclerView = this.viewFetcher.getRecyclerView(index, Timeout.getSmallTimeout());
        return this.scroller.scrollView((View)recyclerView, 0);
    }

    public boolean scrollRecyclerViewToBottom(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollRecyclerViewToBottom(" + index + ")"));
        }
        if (!this.config.shouldScroll) {
            return true;
        }
        ViewGroup recyclerView = this.viewFetcher.getRecyclerView(index, Timeout.getSmallTimeout());
        this.scroller.scrollViewAllTheWay((View)recyclerView, 0);
        return false;
    }

    public boolean scrollUpRecyclerView(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollUpRecyclerView(" + index + ")"));
        }
        if (!this.config.shouldScroll) {
            return true;
        }
        ViewGroup recyclerView = this.viewFetcher.getRecyclerView(index, Timeout.getSmallTimeout());
        return this.scroller.scrollView((View)recyclerView, 1);
    }

    public boolean scrollRecyclerViewToTop(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollRecyclerViewToTop(" + index + ")"));
        }
        if (!this.config.shouldScroll) {
            return false;
        }
        ViewGroup recyclerView = this.viewFetcher.getRecyclerView(index, Timeout.getSmallTimeout());
        this.scroller.scrollViewAllTheWay((View)recyclerView, 1);
        return false;
    }

    public void scrollToSide(int side, float scrollPosition, int stepCount) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollToSide(" + side + ", " + scrollPosition + ", " + stepCount + ")"));
        }
        switch (side) {
            case 22: {
                this.scroller.scrollToSide(Scroller.Side.RIGHT, scrollPosition, stepCount);
                break;
            }
            case 21: {
                this.scroller.scrollToSide(Scroller.Side.LEFT, scrollPosition, stepCount);
            }
        }
    }

    public void scrollToSide(int side, float scrollPosition) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollToSide(" + scrollPosition + ")"));
        }
        this.scrollToSide(side, scrollPosition, 20);
    }

    public void scrollToSide(int side) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollToSide(" + side + ")"));
        }
        this.scrollToSide(side, 0.75f);
    }

    public void scrollViewToSide(View view, int side, float scrollPosition, int stepCount) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollViewToSide(" + view + ", " + side + ", " + scrollPosition + ", " + stepCount + ")"));
        }
        this.waitForView(view);
        this.sleeper.sleep();
        switch (side) {
            case 22: {
                this.scroller.scrollViewToSide(view, Scroller.Side.RIGHT, scrollPosition, stepCount);
                break;
            }
            case 21: {
                this.scroller.scrollViewToSide(view, Scroller.Side.LEFT, scrollPosition, stepCount);
            }
        }
    }

    public void scrollViewToSide(View view, int side, float scrollPosition) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollViewToSide(" + view + ", " + side + ", " + scrollPosition + ")"));
        }
        this.scrollViewToSide(view, side, scrollPosition, 20);
    }

    public void scrollViewToSide(View view, int side) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("scrollViewToSide(" + view + ", " + side + ")"));
        }
        this.scrollViewToSide(view, side, 0.7f);
    }

    public void pinchToZoom(PointF startPoint1, PointF startPoint2, PointF endPoint1, PointF endPoint2) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("pinchToZoom(" + startPoint1 + ", " + startPoint2 + ", " + endPoint1 + ", " + endPoint2 + ")"));
        }
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("pinchToZoom() requires API level >= 14");
        }
        this.zoomer.generateZoomGesture(startPoint1, startPoint2, endPoint1, endPoint2);
    }

    public void swipe(PointF startPoint1, PointF startPoint2, PointF endPoint1, PointF endPoint2) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("swipe(" + startPoint1 + ", " + startPoint2 + ", " + endPoint1 + ", " + endPoint2 + ")"));
        }
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("swipe() requires API level >= 14");
        }
        this.swiper.generateSwipeGesture(startPoint1, startPoint2, endPoint1, endPoint2);
    }

    public void rotateLarge(PointF center1, PointF center2) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("rotateLarge(" + center1 + ", " + center2 + ")"));
        }
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("rotateLarge(PointF center1, PointF center2) requires API level >= 14");
        }
        this.rotator.generateRotateGesture(0, center1, center2);
    }

    public void rotateSmall(PointF center1, PointF center2) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("rotateSmall(" + center1 + ", " + center2 + ")"));
        }
        if (Build.VERSION.SDK_INT < 14) {
            throw new RuntimeException("rotateSmall(PointF center1, PointF center2) requires API level >= 14");
        }
        this.rotator.generateRotateGesture(1, center1, center2);
    }

    public void setMobileData(Boolean turnedOn) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setMobileData(" + turnedOn + ")"));
        }
        this.systemUtils.setMobileData(turnedOn);
    }

    public void setWiFiData(Boolean turnedOn) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setWiFiData(" + turnedOn + ")"));
        }
        this.systemUtils.setWiFiData(turnedOn);
    }

    public void setDatePicker(int index, int year, int monthOfYear, int dayOfMonth) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setDatePicker(" + index + ", " + year + ", " + monthOfYear + ", " + dayOfMonth + ")"));
        }
        this.setDatePicker(this.waiter.waitForAndGetView(index, DatePicker.class), year, monthOfYear, dayOfMonth);
    }

    public void setDatePicker(DatePicker datePicker, int year, int monthOfYear, int dayOfMonth) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setDatePicker(" + datePicker + ", " + year + ", " + monthOfYear + ", " + dayOfMonth + ")"));
        }
        datePicker = (DatePicker)this.waiter.waitForView((View)datePicker, Timeout.getSmallTimeout());
        this.setter.setDatePicker(datePicker, year, monthOfYear, dayOfMonth);
    }

    public void setTimePicker(int index, int hour, int minute) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setTimePicker(" + index + ", " + hour + ", " + minute + ")"));
        }
        this.setTimePicker(this.waiter.waitForAndGetView(index, TimePicker.class), hour, minute);
    }

    public void setTimePicker(TimePicker timePicker, int hour, int minute) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setTimePicker(" + timePicker + ", " + hour + ", " + minute + ")"));
        }
        timePicker = (TimePicker)this.waiter.waitForView((View)timePicker, Timeout.getSmallTimeout());
        this.setter.setTimePicker(timePicker, hour, minute);
    }

    public void setProgressBar(int index, int progress) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setProgressBar(" + index + ", " + progress + ")"));
        }
        this.setProgressBar(this.waiter.waitForAndGetView(index, ProgressBar.class), progress);
    }

    public void setProgressBar(ProgressBar progressBar, int progress) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setProgressBar(" + progressBar + ", " + progress + ")"));
        }
        progressBar = (ProgressBar)this.waiter.waitForView((View)progressBar, Timeout.getSmallTimeout());
        this.setter.setProgressBar(progressBar, progress);
    }

    public void setNavigationDrawer(int status) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setNavigationDrawer(" + status + ")"));
        }
        this.setter.setNavigationDrawer(status);
    }

    public void setSlidingDrawer(int index, int status) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setSlidingDrawer(" + index + ", " + status + ")"));
        }
        this.setSlidingDrawer(this.waiter.waitForAndGetView(index, SlidingDrawer.class), status);
    }

    public void setSlidingDrawer(SlidingDrawer slidingDrawer, int status) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("setSlidingDrawer(" + slidingDrawer + ", " + status + ")"));
        }
        slidingDrawer = (SlidingDrawer)this.waiter.waitForView((View)slidingDrawer, Timeout.getSmallTimeout());
        this.setter.setSlidingDrawer(slidingDrawer, status);
    }

    public void enterText(int index, String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("enterText(" + index + ", \"" + text + "\")"));
        }
        this.textEnterer.setEditText(this.waiter.waitForAndGetView(index, EditText.class), text);
    }

    public void enterText(EditText editText, String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("enterText(" + editText + ", \"" + text + "\")"));
        }
        editText = (EditText)this.waiter.waitForView((View)editText, Timeout.getSmallTimeout());
        this.textEnterer.setEditText(editText, text);
    }

    public void enterTextInWebElement(By by, String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("enterTextInWebElement(" + by + ", \"" + text + "\")"));
        }
        if (this.waiter.waitForWebElement(by, 0, Timeout.getSmallTimeout(), false) == null) {
            Assert.fail((String)("WebElement with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' is not found!"));
        }
        this.webUtils.enterTextIntoWebElement(by, text);
    }

    public void typeText(int index, String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("typeText(" + index + ", \"" + text + "\")"));
        }
        this.textEnterer.typeText(this.waiter.waitForAndGetView(index, EditText.class), text);
    }

    public void typeText(EditText editText, String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("typeText(" + editText + ", \"" + text + "\")"));
        }
        editText = (EditText)this.waiter.waitForView((View)editText, Timeout.getSmallTimeout());
        this.textEnterer.typeText(editText, text);
    }

    public void typeTextInWebElement(By by, String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("typeTextInWebElement(" + by + ", \"" + text + "\")"));
        }
        this.typeTextInWebElement(by, text, 0);
    }

    public void typeTextInWebElement(By by, String text, int match) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("typeTextInWebElement(" + by + ", \"" + text + "\", " + match + ")"));
        }
        this.clicker.clickOnWebElement(by, match, true, false);
        this.dialogUtils.hideSoftKeyboard(null, true, true);
        this.instrumentation.sendStringSync(text);
    }

    public void typeTextInWebElement(WebElement webElement, String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("typeTextInWebElement(" + webElement + ", \"" + text + "\")"));
        }
        this.clickOnWebElement(webElement);
        this.dialogUtils.hideSoftKeyboard(null, true, true);
        this.instrumentation.sendStringSync(text);
    }

    public void clearEditText(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clearEditText(" + index + ")"));
        }
        this.textEnterer.setEditText(this.waiter.waitForAndGetView(index, EditText.class), "");
    }

    public void clearEditText(EditText editText) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clearEditText(" + editText + ")"));
        }
        editText = (EditText)this.waiter.waitForView((View)editText, Timeout.getSmallTimeout());
        this.textEnterer.setEditText(editText, "");
    }

    public void clearTextInWebElement(By by) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clearTextInWebElement(" + by + ")"));
        }
        this.webUtils.enterTextIntoWebElement(by, "");
    }

    public void clickOnImage(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("clickOnImage(" + index + ")"));
        }
        this.clicker.clickOn(ImageView.class, index);
    }

    public EditText getEditText(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getEditText(" + index + ")"));
        }
        return this.getter.getView(EditText.class, index);
    }

    public Button getButton(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getButton(" + index + ")"));
        }
        return this.getter.getView(Button.class, index);
    }

    public TextView getText(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getText(" + index + ")"));
        }
        return this.getter.getView(TextView.class, index);
    }

    public ImageView getImage(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getImage(" + index + ")"));
        }
        return this.getter.getView(ImageView.class, index);
    }

    public ImageButton getImageButton(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getImageButton(" + index + ")"));
        }
        return this.getter.getView(ImageButton.class, index);
    }

    public TextView getText(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getText(\"" + text + "\")"));
        }
        return this.getter.getView(TextView.class, text, false);
    }

    public TextView getText(String text, boolean onlyVisible) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getText(\"" + text + "\", " + onlyVisible + ")"));
        }
        return this.getter.getView(TextView.class, text, onlyVisible);
    }

    public Button getButton(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getButton(\"" + text + "\")"));
        }
        return this.getter.getView(Button.class, text, false);
    }

    public Button getButton(String text, boolean onlyVisible) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getButton(\"" + text + "\", " + onlyVisible + ")"));
        }
        return this.getter.getView(Button.class, text, onlyVisible);
    }

    public EditText getEditText(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getEditText(\"" + text + "\")"));
        }
        return this.getter.getView(EditText.class, text, false);
    }

    public EditText getEditText(String text, boolean onlyVisible) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getEditText(\"" + text + "\", " + onlyVisible + ")"));
        }
        return this.getter.getView(EditText.class, text, onlyVisible);
    }

    public View getView(int id) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getView(" + id + ")"));
        }
        return this.getView(id, 0);
    }

    public View getView(int id, int index) {
        View viewToReturn;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getView(" + id + ", " + index + ")"));
        }
        if ((viewToReturn = this.getter.getView(id, index)) == null) {
            String resourceName = "";
            try {
                resourceName = this.instrumentation.getTargetContext().getResources().getResourceEntryName(id);
            }
            catch (Exception e) {
                Log.d((String)this.config.commandLoggingTag, (String)("unable to get resource entry name for (" + id + ")"));
            }
            int match = index + 1;
            if (match > 1) {
                Assert.fail((String)(match + " Views with id: '" + id + "', resource name: '" + resourceName + "' are not found!"));
            } else {
                Assert.fail((String)("View with id: '" + id + "', resource name: '" + resourceName + "' is not found!"));
            }
        }
        return viewToReturn;
    }

    public View getView(Object tag) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getView(" + tag + ")"));
        }
        return this.getView(tag, 0);
    }

    public View getView(Object tag, int index) {
        View viewToReturn;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getView(" + tag + ", " + index + ")"));
        }
        if ((viewToReturn = this.getter.getView(tag, index)) == null) {
            int match = index + 1;
            if (match > 1) {
                Assert.fail((String)(match + " Views with id: '" + tag + "' are not found!"));
            } else {
                Assert.fail((String)("View with id: '" + tag + "' is not found!"));
            }
        }
        return viewToReturn;
    }

    public View getView(String id) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getView(\"" + id + "\")"));
        }
        return this.getView(id, 0);
    }

    public View getView(String id, int index) {
        View viewToReturn;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getView(\"" + id + "\", " + index + ")"));
        }
        if ((viewToReturn = this.getter.getView(id, index)) == null) {
            int match = index + 1;
            if (match > 1) {
                Assert.fail((String)(match + " Views with id: '" + id + "' are not found!"));
            } else {
                Assert.fail((String)("View with id: '" + id + "' is not found!"));
            }
        }
        return viewToReturn;
    }

    public <T extends View> T getView(Class<T> viewClass, int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getView(" + viewClass + ", " + index + ")"));
        }
        return this.waiter.waitForAndGetView(index, viewClass);
    }

    public WebElement getWebElement(By by, int index) {
        int match;
        WebElement webElement;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getWebElement(" + by + ", " + index + ")"));
        }
        if ((webElement = this.waiter.waitForWebElement(by, match = index + 1, Timeout.getSmallTimeout(), true)) == null) {
            if (match > 1) {
                Assert.fail((String)(match + " WebElements with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' are not found!"));
            } else {
                Assert.fail((String)("WebElement with " + this.webUtils.splitNameByUpperCase(by.getClass().getSimpleName()) + ": '" + by.getValue() + "' is not found!"));
            }
        }
        return webElement;
    }

    public String getWebUrl() {
        WebView webView;
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"getWebUrl()");
        }
        if ((webView = this.waiter.waitForAndGetView(0, WebView.class)) == null) {
            Assert.fail((String)"WebView is not found!");
        }
        this.instrumentation.runOnMainSync(new Runnable(){

            public void run() {
                Solo.this.webUrl = webView.getUrl();
            }
        });
        return this.webUrl;
    }

    public ArrayList<View> getCurrentViews() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"getCurrentViews()");
        }
        return this.viewFetcher.getViews(null, true);
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getCurrentViews(" + classToFilterBy + ")"));
        }
        return this.viewFetcher.getCurrentViews(classToFilterBy, true);
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy, boolean includeSubclasses) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getCurrentViews(" + classToFilterBy + ", " + includeSubclasses + ")"));
        }
        return this.viewFetcher.getCurrentViews(classToFilterBy, includeSubclasses);
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy, View parent) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getCurrentViews(" + classToFilterBy + ", " + parent + ")"));
        }
        return this.viewFetcher.getCurrentViews(classToFilterBy, true, parent);
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy, boolean includeSubclasses, View parent) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getCurrentViews(" + classToFilterBy + ", " + includeSubclasses + ", " + parent + ")"));
        }
        return this.viewFetcher.getCurrentViews(classToFilterBy, includeSubclasses, parent);
    }

    public ArrayList<WebElement> getWebElements() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"getWebElements()");
        }
        return this.webUtils.getWebElements(false);
    }

    public ArrayList<WebElement> getWebElements(By by) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getWebElements(" + by + ")"));
        }
        return this.webUtils.getWebElements(by, false);
    }

    public ArrayList<WebElement> getCurrentWebElements() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"getCurrentWebElements()");
        }
        return this.webUtils.getWebElements(true);
    }

    public ArrayList<WebElement> getCurrentWebElements(By by) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getCurrentWebElements(" + by + ")"));
        }
        return this.webUtils.getWebElements(by, true);
    }

    public boolean isRadioButtonChecked(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isRadioButtonChecked(" + index + ")"));
        }
        return this.checker.isButtonChecked(RadioButton.class, index);
    }

    public boolean isRadioButtonChecked(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isRadioButtonChecked(\"" + text + "\")"));
        }
        return this.checker.isButtonChecked(RadioButton.class, text);
    }

    public boolean isCheckBoxChecked(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isCheckBoxChecked(" + index + ")"));
        }
        return this.checker.isButtonChecked(CheckBox.class, index);
    }

    public boolean isToggleButtonChecked(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isToggleButtonChecked(\"" + text + "\")"));
        }
        return this.checker.isButtonChecked(ToggleButton.class, text);
    }

    public boolean isToggleButtonChecked(int index) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isToggleButtonChecked(" + index + ")"));
        }
        return this.checker.isButtonChecked(ToggleButton.class, index);
    }

    public boolean isCheckBoxChecked(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isCheckBoxChecked(\"" + text + "\")"));
        }
        return this.checker.isButtonChecked(CheckBox.class, text);
    }

    public boolean isTextChecked(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isTextChecked(\"" + text + "\")"));
        }
        this.waiter.waitForViews(false, CheckedTextView.class, CompoundButton.class);
        if (this.viewFetcher.getCurrentViews(CheckedTextView.class, true).size() > 0 && this.checker.isCheckedTextChecked(text)) {
            return true;
        }
        return this.viewFetcher.getCurrentViews(CompoundButton.class, true).size() > 0 && this.checker.isButtonChecked(CompoundButton.class, text);
    }

    public boolean isSpinnerTextSelected(String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isSpinnerTextSelected(\"" + text + "\")"));
        }
        return this.checker.isSpinnerTextSelected(text);
    }

    public boolean isSpinnerTextSelected(int index, String text) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("isSpinnerTextSelected(" + index + ",\"" + text + "\")"));
        }
        return this.checker.isSpinnerTextSelected(index, text);
    }

    public void hideSoftKeyboard() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"hideSoftKeyboard()");
        }
        this.dialogUtils.hideSoftKeyboard(null, true, false);
    }

    public void unlockScreen() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"unlockScreen()");
        }
        final Activity activity = this.activityUtils.getCurrentActivity(false);
        this.instrumentation.runOnMainSync(new Runnable(){

            public void run() {
                if (activity != null) {
                    activity.getWindow().addFlags(0x400000);
                }
            }
        });
    }

    public void sendKey(int key) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("sendKey(" + key + ")"));
        }
        this.sender.sendKeyCode(key);
    }

    public void goBackToActivity(String name) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("goBackToActivity(\"" + name + "\")"));
        }
        this.activityUtils.goBackToActivity(name);
    }

    public boolean waitForActivity(String name) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForActivity(\"" + name + "\")"));
        }
        return this.waiter.waitForActivity(name, Timeout.getLargeTimeout());
    }

    public boolean waitForActivity(String name, int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForActivity(\"" + name + "\", " + timeout + ")"));
        }
        return this.waiter.waitForActivity(name, timeout);
    }

    public boolean waitForActivity(Class<? extends Activity> activityClass) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForActivity(" + activityClass + ")"));
        }
        return this.waiter.waitForActivity(activityClass, Timeout.getLargeTimeout());
    }

    public boolean waitForActivity(Class<? extends Activity> activityClass, int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForActivity(" + activityClass + ", " + timeout + ")"));
        }
        return this.waiter.waitForActivity(activityClass, timeout);
    }

    public boolean waitForEmptyActivityStack(int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForEmptyActivityStack(" + timeout + ")"));
        }
        return this.waiter.waitForCondition(new Condition(){

            public boolean isSatisfied() {
                return Solo.this.activityUtils.isActivityStackEmpty();
            }
        }, timeout);
    }

    public boolean waitForFragmentByTag(String tag) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForFragmentByTag(\"" + tag + "\")"));
        }
        return this.waiter.waitForFragment(tag, 0, Timeout.getLargeTimeout());
    }

    public boolean waitForFragmentByTag(String tag, int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForFragmentByTag(\"" + tag + "\", " + timeout + ")"));
        }
        return this.waiter.waitForFragment(tag, 0, timeout);
    }

    public boolean waitForFragmentById(int id) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForFragmentById(" + id + ")"));
        }
        return this.waiter.waitForFragment(null, id, Timeout.getLargeTimeout());
    }

    public boolean waitForFragmentById(int id, int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForFragmentById(" + id + ", " + timeout + ")"));
        }
        return this.waiter.waitForFragment(null, id, timeout);
    }

    public boolean waitForLogMessage(String logMessage) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForLogMessage(\"" + logMessage + "\")"));
        }
        return this.waiter.waitForLogMessage(logMessage, Timeout.getLargeTimeout());
    }

    public boolean waitForLogMessage(String logMessage, int timeout) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("waitForLogMessage(\"" + logMessage + "\", " + timeout + ")"));
        }
        return this.waiter.waitForLogMessage(logMessage, timeout);
    }

    public void clearLog() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"clearLog()");
        }
        this.waiter.clearLog();
    }

    public String getString(int id) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getString(" + id + ")"));
        }
        return this.getter.getString(id);
    }

    public String getString(String id) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("getString(\"" + id + "\")"));
        }
        return this.getter.getString(id);
    }

    public void sleep(int time) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("sleep(" + time + ")"));
        }
        this.sleeper.sleep(time);
    }

    public void finalize() throws Throwable {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"finalize()");
        }
        this.activityUtils.finalize();
    }

    public void finishOpenedActivities() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"finishOpenedActivities()");
        }
        this.activityUtils.finishOpenedActivities();
    }

    public void takeScreenshot() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"takeScreenshot()");
        }
        this.takeScreenshot(null);
    }

    public void takeScreenshot(String name) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("takeScreenshot(\"" + name + "\")"));
        }
        this.takeScreenshot(name, 100);
    }

    public void takeScreenshot(String name, int quality) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("takeScreenshot(\"" + name + "\", " + quality + ")"));
        }
        this.screenshotTaker.takeScreenshot(name, quality);
    }

    public void startScreenshotSequence(String name) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("startScreenshotSequence(\"" + name + "\")"));
        }
        this.startScreenshotSequence(name, 80, 400, 100);
    }

    public void startScreenshotSequence(String name, int quality, int frameDelay, int maxFrames) {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)("startScreenshotSequence(\"" + name + "\", " + quality + ", " + frameDelay + ", " + maxFrames + ")"));
        }
        this.screenshotTaker.startScreenshotSequence(name, quality, frameDelay, maxFrames);
    }

    public void stopScreenshotSequence() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"stopScreenshotSequence()");
        }
        this.screenshotTaker.stopScreenshotSequence();
    }

    private void initialize() {
        if (this.config.commandLogging) {
            Log.d((String)this.config.commandLoggingTag, (String)"initialize()");
        }
        Timeout.setLargeTimeout(Solo.initializeTimeout("solo_large_timeout", this.config.timeout_large));
        Timeout.setSmallTimeout(Solo.initializeTimeout("solo_small_timeout", this.config.timeout_small));
    }

    private static int initializeTimeout(String property, int defaultValue) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getDeclaredMethod("get", String.class);
            String value = (String)method.invoke(null, property);
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static class Config {
        public int timeout_small = 10000;
        public int timeout_large = 20000;
        public String screenshotSavePath = Environment.getExternalStorageDirectory() + "/Robotium-Screenshots/";
        public ScreenshotFileType screenshotFileType = ScreenshotFileType.JPEG;
        public boolean shouldScroll = true;
        public boolean useJavaScriptToClickWebElements = false;
        public boolean trackActivities = true;
        public String webFrame = "document";
        public boolean commandLogging = false;
        public String commandLoggingTag = "Robotium";

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ScreenshotFileType {
            JPEG,
            PNG;

        }
    }
}

