// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/runtimeconfig/v1beta1/runtimeconfig.proto

package runtimeconfig // import "google.golang.org/genproto/googleapis/cloud/runtimeconfig/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request for the `ListConfigs()` method.
type ListConfigsRequest struct {
	// The [project ID](https://support.google.com/cloud/answer/6158840?hl=en&ref_topic=6158848)
	// for this request, in the format `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListConfigsRequest) Reset()         { *m = ListConfigsRequest{} }
func (m *ListConfigsRequest) String() string { return proto.CompactTextString(m) }
func (*ListConfigsRequest) ProtoMessage()    {}
func (*ListConfigsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{0}
}
func (m *ListConfigsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListConfigsRequest.Unmarshal(m, b)
}
func (m *ListConfigsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListConfigsRequest.Marshal(b, m, deterministic)
}
func (dst *ListConfigsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListConfigsRequest.Merge(dst, src)
}
func (m *ListConfigsRequest) XXX_Size() int {
	return xxx_messageInfo_ListConfigsRequest.Size(m)
}
func (m *ListConfigsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListConfigsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListConfigsRequest proto.InternalMessageInfo

func (m *ListConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// `ListConfigs()` returns the following response. The order of returned
// objects is arbitrary; that is, it is not ordered in any particular way.
type ListConfigsResponse struct {
	// A list of the configurations in the project. The order of returned
	// objects is arbitrary; that is, it is not ordered in any particular way.
	Configs []*RuntimeConfig `protobuf:"bytes,1,rep,name=configs,proto3" json:"configs,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListConfigsResponse) Reset()         { *m = ListConfigsResponse{} }
func (m *ListConfigsResponse) String() string { return proto.CompactTextString(m) }
func (*ListConfigsResponse) ProtoMessage()    {}
func (*ListConfigsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{1}
}
func (m *ListConfigsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListConfigsResponse.Unmarshal(m, b)
}
func (m *ListConfigsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListConfigsResponse.Marshal(b, m, deterministic)
}
func (dst *ListConfigsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListConfigsResponse.Merge(dst, src)
}
func (m *ListConfigsResponse) XXX_Size() int {
	return xxx_messageInfo_ListConfigsResponse.Size(m)
}
func (m *ListConfigsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListConfigsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListConfigsResponse proto.InternalMessageInfo

func (m *ListConfigsResponse) GetConfigs() []*RuntimeConfig {
	if m != nil {
		return m.Configs
	}
	return nil
}

func (m *ListConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Gets a RuntimeConfig resource.
type GetConfigRequest struct {
	// The name of the RuntimeConfig resource to retrieve, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetConfigRequest) Reset()         { *m = GetConfigRequest{} }
func (m *GetConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetConfigRequest) ProtoMessage()    {}
func (*GetConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{2}
}
func (m *GetConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetConfigRequest.Unmarshal(m, b)
}
func (m *GetConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetConfigRequest.Marshal(b, m, deterministic)
}
func (dst *GetConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetConfigRequest.Merge(dst, src)
}
func (m *GetConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetConfigRequest.Size(m)
}
func (m *GetConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetConfigRequest proto.InternalMessageInfo

func (m *GetConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Creates a RuntimeConfig resource.
type CreateConfigRequest struct {
	// The [project ID](https://support.google.com/cloud/answer/6158840?hl=en&ref_topic=6158848)
	// for this request, in the format `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The RuntimeConfig to create.
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId            string   `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateConfigRequest) Reset()         { *m = CreateConfigRequest{} }
func (m *CreateConfigRequest) String() string { return proto.CompactTextString(m) }
func (*CreateConfigRequest) ProtoMessage()    {}
func (*CreateConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{3}
}
func (m *CreateConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateConfigRequest.Unmarshal(m, b)
}
func (m *CreateConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateConfigRequest.Marshal(b, m, deterministic)
}
func (dst *CreateConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateConfigRequest.Merge(dst, src)
}
func (m *CreateConfigRequest) XXX_Size() int {
	return xxx_messageInfo_CreateConfigRequest.Size(m)
}
func (m *CreateConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateConfigRequest proto.InternalMessageInfo

func (m *CreateConfigRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateConfigRequest) GetConfig() *RuntimeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *CreateConfigRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Request message for `UpdateConfig()` method.
type UpdateConfigRequest struct {
	// The name of the RuntimeConfig resource to update, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The config resource to update.
	Config               *RuntimeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *UpdateConfigRequest) Reset()         { *m = UpdateConfigRequest{} }
func (m *UpdateConfigRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateConfigRequest) ProtoMessage()    {}
func (*UpdateConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{4}
}
func (m *UpdateConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateConfigRequest.Unmarshal(m, b)
}
func (m *UpdateConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateConfigRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateConfigRequest.Merge(dst, src)
}
func (m *UpdateConfigRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateConfigRequest.Size(m)
}
func (m *UpdateConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateConfigRequest proto.InternalMessageInfo

func (m *UpdateConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateConfigRequest) GetConfig() *RuntimeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

// Request for the `DeleteConfig()` method.
type DeleteConfigRequest struct {
	// The RuntimeConfig resource to delete, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteConfigRequest) Reset()         { *m = DeleteConfigRequest{} }
func (m *DeleteConfigRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteConfigRequest) ProtoMessage()    {}
func (*DeleteConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{5}
}
func (m *DeleteConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteConfigRequest.Unmarshal(m, b)
}
func (m *DeleteConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteConfigRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteConfigRequest.Merge(dst, src)
}
func (m *DeleteConfigRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteConfigRequest.Size(m)
}
func (m *DeleteConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteConfigRequest proto.InternalMessageInfo

func (m *DeleteConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `ListVariables()` method.
type ListVariablesRequest struct {
	// The path to the RuntimeConfig resource for which you want to list variables.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filters variables by matching the specified filter. For example:
	//
	// `projects/example-project/config/[CONFIG_NAME]/variables/example-variable`.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The flag indicates whether the user wants to return values of variables.
	// If true, then only those variables that user has IAM GetVariable permission
	// will be returned along with their values.
	ReturnValues         bool     `protobuf:"varint,5,opt,name=return_values,json=returnValues,proto3" json:"return_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVariablesRequest) Reset()         { *m = ListVariablesRequest{} }
func (m *ListVariablesRequest) String() string { return proto.CompactTextString(m) }
func (*ListVariablesRequest) ProtoMessage()    {}
func (*ListVariablesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{6}
}
func (m *ListVariablesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVariablesRequest.Unmarshal(m, b)
}
func (m *ListVariablesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVariablesRequest.Marshal(b, m, deterministic)
}
func (dst *ListVariablesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVariablesRequest.Merge(dst, src)
}
func (m *ListVariablesRequest) XXX_Size() int {
	return xxx_messageInfo_ListVariablesRequest.Size(m)
}
func (m *ListVariablesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVariablesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListVariablesRequest proto.InternalMessageInfo

func (m *ListVariablesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListVariablesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListVariablesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListVariablesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListVariablesRequest) GetReturnValues() bool {
	if m != nil {
		return m.ReturnValues
	}
	return false
}

// Response for the `ListVariables()` method.
type ListVariablesResponse struct {
	// A list of variables and their values. The order of returned variable
	// objects is arbitrary.
	Variables []*Variable `protobuf:"bytes,1,rep,name=variables,proto3" json:"variables,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVariablesResponse) Reset()         { *m = ListVariablesResponse{} }
func (m *ListVariablesResponse) String() string { return proto.CompactTextString(m) }
func (*ListVariablesResponse) ProtoMessage()    {}
func (*ListVariablesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{7}
}
func (m *ListVariablesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVariablesResponse.Unmarshal(m, b)
}
func (m *ListVariablesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVariablesResponse.Marshal(b, m, deterministic)
}
func (dst *ListVariablesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVariablesResponse.Merge(dst, src)
}
func (m *ListVariablesResponse) XXX_Size() int {
	return xxx_messageInfo_ListVariablesResponse.Size(m)
}
func (m *ListVariablesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVariablesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListVariablesResponse proto.InternalMessageInfo

func (m *ListVariablesResponse) GetVariables() []*Variable {
	if m != nil {
		return m.Variables
	}
	return nil
}

func (m *ListVariablesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `WatchVariable()` method.
type WatchVariableRequest struct {
	// The name of the variable to watch, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If specified, checks the current timestamp of the variable and if the
	// current timestamp is newer than `newerThan` timestamp, the method returns
	// immediately.
	//
	// If not specified or the variable has an older timestamp, the watcher waits
	// for a the value to change before returning.
	NewerThan            *timestamp.Timestamp `protobuf:"bytes,4,opt,name=newer_than,json=newerThan,proto3" json:"newer_than,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *WatchVariableRequest) Reset()         { *m = WatchVariableRequest{} }
func (m *WatchVariableRequest) String() string { return proto.CompactTextString(m) }
func (*WatchVariableRequest) ProtoMessage()    {}
func (*WatchVariableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{8}
}
func (m *WatchVariableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WatchVariableRequest.Unmarshal(m, b)
}
func (m *WatchVariableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WatchVariableRequest.Marshal(b, m, deterministic)
}
func (dst *WatchVariableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchVariableRequest.Merge(dst, src)
}
func (m *WatchVariableRequest) XXX_Size() int {
	return xxx_messageInfo_WatchVariableRequest.Size(m)
}
func (m *WatchVariableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchVariableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WatchVariableRequest proto.InternalMessageInfo

func (m *WatchVariableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WatchVariableRequest) GetNewerThan() *timestamp.Timestamp {
	if m != nil {
		return m.NewerThan
	}
	return nil
}

// Request for the `GetVariable()` method.
type GetVariableRequest struct {
	// The name of the variable to return, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIBLE_NAME]`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetVariableRequest) Reset()         { *m = GetVariableRequest{} }
func (m *GetVariableRequest) String() string { return proto.CompactTextString(m) }
func (*GetVariableRequest) ProtoMessage()    {}
func (*GetVariableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{9}
}
func (m *GetVariableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetVariableRequest.Unmarshal(m, b)
}
func (m *GetVariableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetVariableRequest.Marshal(b, m, deterministic)
}
func (dst *GetVariableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetVariableRequest.Merge(dst, src)
}
func (m *GetVariableRequest) XXX_Size() int {
	return xxx_messageInfo_GetVariableRequest.Size(m)
}
func (m *GetVariableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetVariableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetVariableRequest proto.InternalMessageInfo

func (m *GetVariableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `CreateVariable()` method.
type CreateVariableRequest struct {
	// The path to the RutimeConfig resource that this variable should belong to.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The variable to create.
	Variable *Variable `protobuf:"bytes,2,opt,name=variable,proto3" json:"variable,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId            string   `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateVariableRequest) Reset()         { *m = CreateVariableRequest{} }
func (m *CreateVariableRequest) String() string { return proto.CompactTextString(m) }
func (*CreateVariableRequest) ProtoMessage()    {}
func (*CreateVariableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{10}
}
func (m *CreateVariableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateVariableRequest.Unmarshal(m, b)
}
func (m *CreateVariableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateVariableRequest.Marshal(b, m, deterministic)
}
func (dst *CreateVariableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateVariableRequest.Merge(dst, src)
}
func (m *CreateVariableRequest) XXX_Size() int {
	return xxx_messageInfo_CreateVariableRequest.Size(m)
}
func (m *CreateVariableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateVariableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateVariableRequest proto.InternalMessageInfo

func (m *CreateVariableRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateVariableRequest) GetVariable() *Variable {
	if m != nil {
		return m.Variable
	}
	return nil
}

func (m *CreateVariableRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Request for the `UpdateVariable()` method.
type UpdateVariableRequest struct {
	// The name of the variable to update, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The variable to update.
	Variable             *Variable `protobuf:"bytes,2,opt,name=variable,proto3" json:"variable,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateVariableRequest) Reset()         { *m = UpdateVariableRequest{} }
func (m *UpdateVariableRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateVariableRequest) ProtoMessage()    {}
func (*UpdateVariableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{11}
}
func (m *UpdateVariableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateVariableRequest.Unmarshal(m, b)
}
func (m *UpdateVariableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateVariableRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateVariableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateVariableRequest.Merge(dst, src)
}
func (m *UpdateVariableRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateVariableRequest.Size(m)
}
func (m *UpdateVariableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateVariableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateVariableRequest proto.InternalMessageInfo

func (m *UpdateVariableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateVariableRequest) GetVariable() *Variable {
	if m != nil {
		return m.Variable
	}
	return nil
}

// Request for the `DeleteVariable()` method.
type DeleteVariableRequest struct {
	// The name of the variable to delete, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` to recursively delete multiple variables with the same
	// prefix.
	Recursive            bool     `protobuf:"varint,2,opt,name=recursive,proto3" json:"recursive,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteVariableRequest) Reset()         { *m = DeleteVariableRequest{} }
func (m *DeleteVariableRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteVariableRequest) ProtoMessage()    {}
func (*DeleteVariableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{12}
}
func (m *DeleteVariableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteVariableRequest.Unmarshal(m, b)
}
func (m *DeleteVariableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteVariableRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteVariableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteVariableRequest.Merge(dst, src)
}
func (m *DeleteVariableRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteVariableRequest.Size(m)
}
func (m *DeleteVariableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteVariableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteVariableRequest proto.InternalMessageInfo

func (m *DeleteVariableRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteVariableRequest) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

// Request for the `ListWaiters()` method.
type ListWaitersRequest struct {
	// The path to the configuration for which you want to get a list of waiters.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListWaitersRequest) Reset()         { *m = ListWaitersRequest{} }
func (m *ListWaitersRequest) String() string { return proto.CompactTextString(m) }
func (*ListWaitersRequest) ProtoMessage()    {}
func (*ListWaitersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{13}
}
func (m *ListWaitersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListWaitersRequest.Unmarshal(m, b)
}
func (m *ListWaitersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListWaitersRequest.Marshal(b, m, deterministic)
}
func (dst *ListWaitersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWaitersRequest.Merge(dst, src)
}
func (m *ListWaitersRequest) XXX_Size() int {
	return xxx_messageInfo_ListWaitersRequest.Size(m)
}
func (m *ListWaitersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWaitersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListWaitersRequest proto.InternalMessageInfo

func (m *ListWaitersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListWaitersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListWaitersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the `ListWaiters()` method.
// Order of returned waiter objects is arbitrary.
type ListWaitersResponse struct {
	// Found waiters in the project.
	Waiters []*Waiter `protobuf:"bytes,1,rep,name=waiters,proto3" json:"waiters,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListWaitersResponse) Reset()         { *m = ListWaitersResponse{} }
func (m *ListWaitersResponse) String() string { return proto.CompactTextString(m) }
func (*ListWaitersResponse) ProtoMessage()    {}
func (*ListWaitersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{14}
}
func (m *ListWaitersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListWaitersResponse.Unmarshal(m, b)
}
func (m *ListWaitersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListWaitersResponse.Marshal(b, m, deterministic)
}
func (dst *ListWaitersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListWaitersResponse.Merge(dst, src)
}
func (m *ListWaitersResponse) XXX_Size() int {
	return xxx_messageInfo_ListWaitersResponse.Size(m)
}
func (m *ListWaitersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListWaitersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListWaitersResponse proto.InternalMessageInfo

func (m *ListWaitersResponse) GetWaiters() []*Waiter {
	if m != nil {
		return m.Waiters
	}
	return nil
}

func (m *ListWaitersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the `GetWaiter()` method.
type GetWaiterRequest struct {
	// The fully-qualified name of the Waiter resource object to retrieve, in the
	// format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetWaiterRequest) Reset()         { *m = GetWaiterRequest{} }
func (m *GetWaiterRequest) String() string { return proto.CompactTextString(m) }
func (*GetWaiterRequest) ProtoMessage()    {}
func (*GetWaiterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{15}
}
func (m *GetWaiterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetWaiterRequest.Unmarshal(m, b)
}
func (m *GetWaiterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetWaiterRequest.Marshal(b, m, deterministic)
}
func (dst *GetWaiterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWaiterRequest.Merge(dst, src)
}
func (m *GetWaiterRequest) XXX_Size() int {
	return xxx_messageInfo_GetWaiterRequest.Size(m)
}
func (m *GetWaiterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWaiterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetWaiterRequest proto.InternalMessageInfo

func (m *GetWaiterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for `CreateWaiter()` method.
type CreateWaiterRequest struct {
	// The path to the configuration that will own the waiter.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The Waiter resource to create.
	Waiter *Waiter `protobuf:"bytes,2,opt,name=waiter,proto3" json:"waiter,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId            string   `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateWaiterRequest) Reset()         { *m = CreateWaiterRequest{} }
func (m *CreateWaiterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateWaiterRequest) ProtoMessage()    {}
func (*CreateWaiterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{16}
}
func (m *CreateWaiterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateWaiterRequest.Unmarshal(m, b)
}
func (m *CreateWaiterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateWaiterRequest.Marshal(b, m, deterministic)
}
func (dst *CreateWaiterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateWaiterRequest.Merge(dst, src)
}
func (m *CreateWaiterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateWaiterRequest.Size(m)
}
func (m *CreateWaiterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateWaiterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateWaiterRequest proto.InternalMessageInfo

func (m *CreateWaiterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateWaiterRequest) GetWaiter() *Waiter {
	if m != nil {
		return m.Waiter
	}
	return nil
}

func (m *CreateWaiterRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// Request for the `DeleteWaiter()` method.
type DeleteWaiterRequest struct {
	// The Waiter resource to delete, in the format:
	//
	//  `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteWaiterRequest) Reset()         { *m = DeleteWaiterRequest{} }
func (m *DeleteWaiterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteWaiterRequest) ProtoMessage()    {}
func (*DeleteWaiterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_runtimeconfig_6039f7e1dafadd9a, []int{17}
}
func (m *DeleteWaiterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteWaiterRequest.Unmarshal(m, b)
}
func (m *DeleteWaiterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteWaiterRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteWaiterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteWaiterRequest.Merge(dst, src)
}
func (m *DeleteWaiterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteWaiterRequest.Size(m)
}
func (m *DeleteWaiterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteWaiterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteWaiterRequest proto.InternalMessageInfo

func (m *DeleteWaiterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*ListConfigsRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListConfigsRequest")
	proto.RegisterType((*ListConfigsResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListConfigsResponse")
	proto.RegisterType((*GetConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetConfigRequest")
	proto.RegisterType((*CreateConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateConfigRequest")
	proto.RegisterType((*UpdateConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.UpdateConfigRequest")
	proto.RegisterType((*DeleteConfigRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteConfigRequest")
	proto.RegisterType((*ListVariablesRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListVariablesRequest")
	proto.RegisterType((*ListVariablesResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListVariablesResponse")
	proto.RegisterType((*WatchVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.WatchVariableRequest")
	proto.RegisterType((*GetVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetVariableRequest")
	proto.RegisterType((*CreateVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateVariableRequest")
	proto.RegisterType((*UpdateVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.UpdateVariableRequest")
	proto.RegisterType((*DeleteVariableRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteVariableRequest")
	proto.RegisterType((*ListWaitersRequest)(nil), "google.cloud.runtimeconfig.v1beta1.ListWaitersRequest")
	proto.RegisterType((*ListWaitersResponse)(nil), "google.cloud.runtimeconfig.v1beta1.ListWaitersResponse")
	proto.RegisterType((*GetWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.GetWaiterRequest")
	proto.RegisterType((*CreateWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.CreateWaiterRequest")
	proto.RegisterType((*DeleteWaiterRequest)(nil), "google.cloud.runtimeconfig.v1beta1.DeleteWaiterRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// RuntimeConfigManagerClient is the client API for RuntimeConfigManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RuntimeConfigManagerClient interface {
	// Lists all the RuntimeConfig resources within project.
	ListConfigs(ctx context.Context, in *ListConfigsRequest, opts ...grpc.CallOption) (*ListConfigsResponse, error)
	// Gets information about a RuntimeConfig resource.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Creates a new RuntimeConfig resource. The configuration name must be
	// unique within project.
	CreateConfig(ctx context.Context, in *CreateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Updates a RuntimeConfig resource. The configuration must exist beforehand.
	UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Deletes a RuntimeConfig resource.
	DeleteConfig(ctx context.Context, in *DeleteConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists variables within given a configuration, matching any provided filters.
	// This only lists variable names, not the values, unless `return_values` is
	// true, in which case only variables that user has IAM permission to
	// GetVariable will be returned.
	ListVariables(ctx context.Context, in *ListVariablesRequest, opts ...grpc.CallOption) (*ListVariablesResponse, error)
	// Gets information about a single variable.
	GetVariable(ctx context.Context, in *GetVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Watches a specific variable and waits for a change in the variable's value.
	// When there is a change, this method returns the new value or times out.
	//
	// If a variable is deleted while being watched, the `variableState` state is
	// set to `DELETED` and the method returns the last known variable `value`.
	//
	// If you set the deadline for watching to a larger value than internal timeout
	// (60 seconds), the current variable value is returned and the `variableState`
	// will be `VARIABLE_STATE_UNSPECIFIED`.
	//
	// To learn more about creating a watcher, read the
	// [Watching a Variable for Changes](/deployment-manager/runtime-configurator/watching-a-variable)
	// documentation.
	WatchVariable(ctx context.Context, in *WatchVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Creates a variable within the given configuration. You cannot create
	// a variable with a name that is a prefix of an existing variable name, or a
	// name that has an existing variable name as a prefix.
	//
	// To learn more about creating a variable, read the
	// [Setting and Getting Data](/deployment-manager/runtime-configurator/set-and-get-variables)
	// documentation.
	CreateVariable(ctx context.Context, in *CreateVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Updates an existing variable with a new value.
	UpdateVariable(ctx context.Context, in *UpdateVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Deletes a variable or multiple variables.
	//
	// If you specify a variable name, then that variable is deleted. If you
	// specify a prefix and `recursive` is true, then all variables with that
	// prefix are deleted. You must set a `recursive` to true if you delete
	// variables by prefix.
	DeleteVariable(ctx context.Context, in *DeleteVariableRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// List waiters within the given configuration.
	ListWaiters(ctx context.Context, in *ListWaitersRequest, opts ...grpc.CallOption) (*ListWaitersResponse, error)
	// Gets information about a single waiter.
	GetWaiter(ctx context.Context, in *GetWaiterRequest, opts ...grpc.CallOption) (*Waiter, error)
	// Creates a Waiter resource. This operation returns a long-running Operation
	// resource which can be polled for completion. However, a waiter with the
	// given name will exist (and can be retrieved) prior to the operation
	// completing. If the operation fails, the failed Waiter resource will
	// still exist and must be deleted prior to subsequent creation attempts.
	CreateWaiter(ctx context.Context, in *CreateWaiterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes the waiter with the specified name.
	DeleteWaiter(ctx context.Context, in *DeleteWaiterRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type runtimeConfigManagerClient struct {
	cc *grpc.ClientConn
}

func NewRuntimeConfigManagerClient(cc *grpc.ClientConn) RuntimeConfigManagerClient {
	return &runtimeConfigManagerClient{cc}
}

func (c *runtimeConfigManagerClient) ListConfigs(ctx context.Context, in *ListConfigsRequest, opts ...grpc.CallOption) (*ListConfigsResponse, error) {
	out := new(ListConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateConfig(ctx context.Context, in *CreateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteConfig(ctx context.Context, in *DeleteConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) ListVariables(ctx context.Context, in *ListVariablesRequest, opts ...grpc.CallOption) (*ListVariablesResponse, error) {
	out := new(ListVariablesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListVariables", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetVariable(ctx context.Context, in *GetVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) WatchVariable(ctx context.Context, in *WatchVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/WatchVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateVariable(ctx context.Context, in *CreateVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) UpdateVariable(ctx context.Context, in *UpdateVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteVariable(ctx context.Context, in *DeleteVariableRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) ListWaiters(ctx context.Context, in *ListWaitersRequest, opts ...grpc.CallOption) (*ListWaitersResponse, error) {
	out := new(ListWaitersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListWaiters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetWaiter(ctx context.Context, in *GetWaiterRequest, opts ...grpc.CallOption) (*Waiter, error) {
	out := new(Waiter)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetWaiter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateWaiter(ctx context.Context, in *CreateWaiterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateWaiter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteWaiter(ctx context.Context, in *DeleteWaiterRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteWaiter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RuntimeConfigManagerServer is the server API for RuntimeConfigManager service.
type RuntimeConfigManagerServer interface {
	// Lists all the RuntimeConfig resources within project.
	ListConfigs(context.Context, *ListConfigsRequest) (*ListConfigsResponse, error)
	// Gets information about a RuntimeConfig resource.
	GetConfig(context.Context, *GetConfigRequest) (*RuntimeConfig, error)
	// Creates a new RuntimeConfig resource. The configuration name must be
	// unique within project.
	CreateConfig(context.Context, *CreateConfigRequest) (*RuntimeConfig, error)
	// Updates a RuntimeConfig resource. The configuration must exist beforehand.
	UpdateConfig(context.Context, *UpdateConfigRequest) (*RuntimeConfig, error)
	// Deletes a RuntimeConfig resource.
	DeleteConfig(context.Context, *DeleteConfigRequest) (*empty.Empty, error)
	// Lists variables within given a configuration, matching any provided filters.
	// This only lists variable names, not the values, unless `return_values` is
	// true, in which case only variables that user has IAM permission to
	// GetVariable will be returned.
	ListVariables(context.Context, *ListVariablesRequest) (*ListVariablesResponse, error)
	// Gets information about a single variable.
	GetVariable(context.Context, *GetVariableRequest) (*Variable, error)
	// Watches a specific variable and waits for a change in the variable's value.
	// When there is a change, this method returns the new value or times out.
	//
	// If a variable is deleted while being watched, the `variableState` state is
	// set to `DELETED` and the method returns the last known variable `value`.
	//
	// If you set the deadline for watching to a larger value than internal timeout
	// (60 seconds), the current variable value is returned and the `variableState`
	// will be `VARIABLE_STATE_UNSPECIFIED`.
	//
	// To learn more about creating a watcher, read the
	// [Watching a Variable for Changes](/deployment-manager/runtime-configurator/watching-a-variable)
	// documentation.
	WatchVariable(context.Context, *WatchVariableRequest) (*Variable, error)
	// Creates a variable within the given configuration. You cannot create
	// a variable with a name that is a prefix of an existing variable name, or a
	// name that has an existing variable name as a prefix.
	//
	// To learn more about creating a variable, read the
	// [Setting and Getting Data](/deployment-manager/runtime-configurator/set-and-get-variables)
	// documentation.
	CreateVariable(context.Context, *CreateVariableRequest) (*Variable, error)
	// Updates an existing variable with a new value.
	UpdateVariable(context.Context, *UpdateVariableRequest) (*Variable, error)
	// Deletes a variable or multiple variables.
	//
	// If you specify a variable name, then that variable is deleted. If you
	// specify a prefix and `recursive` is true, then all variables with that
	// prefix are deleted. You must set a `recursive` to true if you delete
	// variables by prefix.
	DeleteVariable(context.Context, *DeleteVariableRequest) (*empty.Empty, error)
	// List waiters within the given configuration.
	ListWaiters(context.Context, *ListWaitersRequest) (*ListWaitersResponse, error)
	// Gets information about a single waiter.
	GetWaiter(context.Context, *GetWaiterRequest) (*Waiter, error)
	// Creates a Waiter resource. This operation returns a long-running Operation
	// resource which can be polled for completion. However, a waiter with the
	// given name will exist (and can be retrieved) prior to the operation
	// completing. If the operation fails, the failed Waiter resource will
	// still exist and must be deleted prior to subsequent creation attempts.
	CreateWaiter(context.Context, *CreateWaiterRequest) (*longrunning.Operation, error)
	// Deletes the waiter with the specified name.
	DeleteWaiter(context.Context, *DeleteWaiterRequest) (*empty.Empty, error)
}

func RegisterRuntimeConfigManagerServer(s *grpc.Server, srv RuntimeConfigManagerServer) {
	s.RegisterService(&_RuntimeConfigManager_serviceDesc, srv)
}

func _RuntimeConfigManager_ListConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListConfigs(ctx, req.(*ListConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateConfig(ctx, req.(*CreateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_UpdateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).UpdateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).UpdateConfig(ctx, req.(*UpdateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteConfig(ctx, req.(*DeleteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_ListVariables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVariablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListVariables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListVariables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListVariables(ctx, req.(*ListVariablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetVariable(ctx, req.(*GetVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_WatchVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WatchVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).WatchVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/WatchVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).WatchVariable(ctx, req.(*WatchVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateVariable(ctx, req.(*CreateVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_UpdateVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).UpdateVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).UpdateVariable(ctx, req.(*UpdateVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteVariable(ctx, req.(*DeleteVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_ListWaiters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWaitersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListWaiters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListWaiters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListWaiters(ctx, req.(*ListWaitersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetWaiter(ctx, req.(*GetWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateWaiter(ctx, req.(*CreateWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteWaiter(ctx, req.(*DeleteWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RuntimeConfigManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager",
	HandlerType: (*RuntimeConfigManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConfigs",
			Handler:    _RuntimeConfigManager_ListConfigs_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _RuntimeConfigManager_GetConfig_Handler,
		},
		{
			MethodName: "CreateConfig",
			Handler:    _RuntimeConfigManager_CreateConfig_Handler,
		},
		{
			MethodName: "UpdateConfig",
			Handler:    _RuntimeConfigManager_UpdateConfig_Handler,
		},
		{
			MethodName: "DeleteConfig",
			Handler:    _RuntimeConfigManager_DeleteConfig_Handler,
		},
		{
			MethodName: "ListVariables",
			Handler:    _RuntimeConfigManager_ListVariables_Handler,
		},
		{
			MethodName: "GetVariable",
			Handler:    _RuntimeConfigManager_GetVariable_Handler,
		},
		{
			MethodName: "WatchVariable",
			Handler:    _RuntimeConfigManager_WatchVariable_Handler,
		},
		{
			MethodName: "CreateVariable",
			Handler:    _RuntimeConfigManager_CreateVariable_Handler,
		},
		{
			MethodName: "UpdateVariable",
			Handler:    _RuntimeConfigManager_UpdateVariable_Handler,
		},
		{
			MethodName: "DeleteVariable",
			Handler:    _RuntimeConfigManager_DeleteVariable_Handler,
		},
		{
			MethodName: "ListWaiters",
			Handler:    _RuntimeConfigManager_ListWaiters_Handler,
		},
		{
			MethodName: "GetWaiter",
			Handler:    _RuntimeConfigManager_GetWaiter_Handler,
		},
		{
			MethodName: "CreateWaiter",
			Handler:    _RuntimeConfigManager_CreateWaiter_Handler,
		},
		{
			MethodName: "DeleteWaiter",
			Handler:    _RuntimeConfigManager_DeleteWaiter_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/runtimeconfig/v1beta1/runtimeconfig.proto",
}

func init() {
	proto.RegisterFile("google/cloud/runtimeconfig/v1beta1/runtimeconfig.proto", fileDescriptor_runtimeconfig_6039f7e1dafadd9a)
}

var fileDescriptor_runtimeconfig_6039f7e1dafadd9a = []byte{
	// 1158 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x98, 0x4b, 0x6f, 0xdd, 0x44,
	0x14, 0xc7, 0x35, 0x49, 0x9b, 0xe6, 0x9e, 0x3c, 0x40, 0x93, 0x87, 0x22, 0xb7, 0x15, 0x91, 0x8b,
	0xa2, 0x70, 0x55, 0xd9, 0x4d, 0x5a, 0xa5, 0x49, 0xa0, 0x2c, 0x92, 0xa2, 0x10, 0x1e, 0x6a, 0x65,
	0x42, 0x2a, 0xa1, 0x48, 0xd1, 0xe4, 0x66, 0xe2, 0x18, 0x6e, 0xc6, 0xc6, 0x1e, 0x27, 0x50, 0x94,
	0x0d, 0xec, 0x40, 0x48, 0x48, 0x2c, 0xca, 0x8a, 0x05, 0x12, 0x20, 0x21, 0x84, 0x58, 0xb1, 0x41,
	0x74, 0xc7, 0x86, 0x2d, 0x12, 0x9f, 0x80, 0x0f, 0x82, 0x3c, 0x0f, 0x5f, 0xfb, 0xe6, 0x3e, 0xc6,
	0x21, 0xdd, 0x25, 0xe3, 0xf3, 0xf8, 0xcd, 0x99, 0x33, 0xf3, 0x3f, 0xba, 0xb0, 0xe4, 0x87, 0xa1,
	0xdf, 0xa4, 0x6e, 0xa3, 0x19, 0xa6, 0xfb, 0x6e, 0x9c, 0x32, 0x1e, 0x1c, 0xd1, 0x46, 0xc8, 0x0e,
	0x02, 0xdf, 0x3d, 0x5e, 0xd8, 0xa3, 0x9c, 0x2c, 0x94, 0x57, 0x9d, 0x28, 0x0e, 0x79, 0x88, 0x6d,
	0xe9, 0xe7, 0x08, 0x3f, 0xa7, 0x6c, 0xa1, 0xfc, 0xac, 0x6b, 0x2a, 0x36, 0x89, 0x02, 0x97, 0x30,
	0x16, 0x72, 0xc2, 0x83, 0x90, 0x25, 0x32, 0x82, 0xb5, 0x68, 0x92, 0x99, 0x26, 0x61, 0x1a, 0x37,
	0xa8, 0xf6, 0xb9, 0xa1, 0x7c, 0x9a, 0x21, 0xf3, 0xe3, 0x94, 0xb1, 0x80, 0xf9, 0x6e, 0x18, 0xd1,
	0xb8, 0x14, 0xf8, 0xaa, 0x32, 0x12, 0xff, 0xed, 0xa5, 0x07, 0x2e, 0x3d, 0x8a, 0xf8, 0xc7, 0xea,
	0xe3, 0x0b, 0xed, 0x1f, 0xb3, 0xac, 0x09, 0x27, 0x47, 0x91, 0x34, 0xb0, 0x0f, 0x01, 0xbf, 0x15,
	0x24, 0x7c, 0x5d, 0x80, 0x24, 0x1e, 0xfd, 0x30, 0xa5, 0x09, 0xc7, 0xd3, 0x30, 0x14, 0x91, 0x98,
	0x32, 0x3e, 0x83, 0x66, 0xd1, 0x7c, 0xcd, 0x53, 0xff, 0xe1, 0xab, 0x50, 0x8b, 0x88, 0x4f, 0x77,
	0x93, 0xe0, 0x31, 0x9d, 0x19, 0x98, 0x45, 0xf3, 0x97, 0xbd, 0xe1, 0x6c, 0xe1, 0x9d, 0xe0, 0x31,
	0xc5, 0xd7, 0x01, 0xc4, 0x47, 0x1e, 0x7e, 0x40, 0xd9, 0xcc, 0xa0, 0x70, 0x14, 0xe6, 0x5b, 0xd9,
	0x82, 0xfd, 0x39, 0x82, 0x89, 0x52, 0xaa, 0x24, 0x0a, 0x59, 0x42, 0xf1, 0x9b, 0x70, 0x45, 0x96,
	0x21, 0x99, 0x41, 0xb3, 0x83, 0xf3, 0x23, 0x8b, 0x0b, 0x4e, 0xff, 0x62, 0x3b, 0x9e, 0x5c, 0x95,
	0xc1, 0x3c, 0x1d, 0x01, 0xcf, 0xc1, 0x73, 0x8c, 0x7e, 0xc4, 0x77, 0x0b, 0x20, 0x03, 0x02, 0x64,
	0x2c, 0x5b, 0x7e, 0x98, 0xc3, 0xcc, 0xc1, 0xf3, 0x1b, 0x54, 0xa1, 0xe8, 0x4d, 0x63, 0xb8, 0xc4,
	0xc8, 0x11, 0x55, 0x0e, 0xe2, 0x6f, 0xfb, 0x09, 0x82, 0x89, 0xf5, 0x98, 0x12, 0x4e, 0xcb, 0xb6,
	0xdd, 0x0a, 0xb4, 0x09, 0x43, 0x12, 0x45, 0x44, 0x39, 0xd7, 0x5e, 0x54, 0x80, 0xac, 0x9c, 0xb1,
	0xcc, 0xb6, 0x1b, 0xec, 0xeb, 0x72, 0xaa, 0x95, 0xcd, 0x7d, 0x9b, 0xc3, 0xc4, 0xbb, 0xd1, 0xfe,
	0x19, 0x30, 0xbd, 0x09, 0xd4, 0xda, 0xc4, 0x05, 0x42, 0xd9, 0x2f, 0xc1, 0xc4, 0x7d, 0xda, 0xa4,
	0x06, 0x59, 0xed, 0x1f, 0x11, 0x4c, 0x66, 0xe7, 0xbd, 0x4d, 0xe2, 0x80, 0xec, 0x35, 0x69, 0xdf,
	0xe6, 0x9a, 0x86, 0xa1, 0x83, 0xa0, 0xc9, 0x69, 0xac, 0x4e, 0x40, 0xfd, 0x57, 0x6e, 0xba, 0xc1,
	0x9e, 0x4d, 0x77, 0xa9, 0xad, 0xe9, 0xf0, 0x0d, 0x18, 0x8b, 0x29, 0x4f, 0x63, 0xb6, 0x7b, 0x4c,
	0x9a, 0x29, 0x4d, 0x66, 0x2e, 0xcf, 0xa2, 0xf9, 0x61, 0x6f, 0x54, 0x2e, 0x6e, 0x8b, 0x35, 0xfb,
	0x0b, 0x04, 0x53, 0x6d, 0xa4, 0xaa, 0x37, 0xdf, 0x80, 0xda, 0xb1, 0x5e, 0x54, 0xdd, 0x79, 0xd3,
	0xa4, 0x78, 0x3a, 0x92, 0xd7, 0x72, 0x37, 0x6e, 0x4d, 0x0a, 0x93, 0x8f, 0x08, 0x6f, 0x1c, 0xe6,
	0x31, 0x7a, 0x9c, 0xec, 0x0a, 0x00, 0xa3, 0x27, 0x34, 0xde, 0xe5, 0x87, 0x44, 0xee, 0x7e, 0x64,
	0xd1, 0xd2, 0x80, 0xfa, 0xce, 0x3b, 0x5b, 0xfa, 0xce, 0x7b, 0x35, 0x61, 0xbd, 0x75, 0x48, 0x98,
	0x3d, 0x0f, 0x78, 0x83, 0x72, 0x83, 0x24, 0xf6, 0x37, 0x08, 0xa6, 0xe4, 0x1d, 0x68, 0xb7, 0xee,
	0x76, 0x92, 0xaf, 0xc3, 0xb0, 0xde, 0xb7, 0x6a, 0xb9, 0x6a, 0x55, 0xcb, 0xbd, 0xfb, 0x5d, 0x82,
	0x14, 0xa6, 0xe4, 0x25, 0x30, 0x29, 0xd6, 0x85, 0x51, 0xd9, 0x9b, 0x30, 0x25, 0x6f, 0x81, 0x49,
	0xda, 0x6b, 0x50, 0x8b, 0x69, 0x23, 0x8d, 0x93, 0xe0, 0x58, 0xe6, 0x1d, 0xf6, 0x5a, 0x0b, 0xfa,
	0xfd, 0x7d, 0x44, 0x02, 0x4e, 0xe3, 0x67, 0xfa, 0xfe, 0x7e, 0xa6, 0xde, 0xdf, 0x3c, 0x95, 0xea,
	0xf1, 0xfb, 0x70, 0xe5, 0x44, 0x2e, 0xa9, 0x0e, 0xaf, 0x9b, 0x54, 0x45, 0x46, 0xf1, 0xb4, 0x6b,
	0xc5, 0x87, 0x57, 0x79, 0xf7, 0x68, 0xba, 0xaf, 0xf2, 0x87, 0xb7, 0x6c, 0xdb, 0xad, 0x32, 0x6b,
	0x30, 0x24, 0x51, 0xd4, 0xd1, 0x56, 0xd9, 0x84, 0xf2, 0xec, 0xd7, 0x6c, 0xf9, 0xdb, 0xd7, 0x97,
	0x7e, 0xf1, 0x9f, 0x49, 0x98, 0x2c, 0x3d, 0xa0, 0x6f, 0x13, 0x46, 0x7c, 0x1a, 0xe3, 0x9f, 0x11,
	0x8c, 0x14, 0x44, 0x10, 0x2f, 0x99, 0x60, 0x9e, 0x15, 0x68, 0xeb, 0x6e, 0x65, 0x3f, 0x79, 0xda,
	0xf6, 0xcd, 0x4f, 0xff, 0xfe, 0xf7, 0xeb, 0x81, 0x39, 0xfc, 0x62, 0x3e, 0x74, 0x7c, 0x22, 0x2b,
	0x78, 0x2f, 0x8a, 0xc3, 0xf7, 0x69, 0x83, 0x27, 0x6e, 0xfd, 0xd4, 0xd5, 0x72, 0xfa, 0x1d, 0x82,
	0x5a, 0xae, 0x93, 0xf8, 0x8e, 0x49, 0xd2, 0x76, 0x59, 0xb5, 0xaa, 0xab, 0x4d, 0x27, 0xc8, 0xac,
	0xac, 0x05, 0x44, 0x4d, 0xe8, 0xd6, 0x4f, 0xf1, 0xaf, 0x08, 0x46, 0x8b, 0x1a, 0x8d, 0x8d, 0x8a,
	0xd3, 0x41, 0xd5, 0xcf, 0x83, 0x7a, 0x47, 0xa0, 0x3a, 0xb6, 0x51, 0x3d, 0x57, 0xb5, 0xb6, 0x67,
	0xc8, 0x45, 0xf5, 0x36, 0x43, 0xee, 0xa0, 0xf7, 0xff, 0x03, 0xd9, 0x32, 0xaa, 0x6e, 0x8e, 0xfc,
	0x25, 0x82, 0xd1, 0xa2, 0xf4, 0x9b, 0x21, 0x77, 0x18, 0x16, 0xac, 0xe9, 0x33, 0x02, 0xf5, 0x5a,
	0x36, 0xb1, 0xea, 0x53, 0xaf, 0x9b, 0x9d, 0xfa, 0x53, 0x04, 0x63, 0x25, 0xd1, 0xc6, 0xcb, 0xa6,
	0x77, 0xa2, 0x7d, 0x22, 0xb1, 0x56, 0xce, 0xe1, 0xa9, 0xee, 0xd3, 0xb2, 0x80, 0x5e, 0xc4, 0xb7,
	0x7a, 0x9c, 0x7f, 0x01, 0xdb, 0x6d, 0xcd, 0x03, 0xbf, 0x20, 0x18, 0x29, 0x28, 0xb0, 0xd9, 0x53,
	0x70, 0x56, 0xb2, 0xad, 0x4a, 0x22, 0x66, 0xaf, 0x08, 0xde, 0xdb, 0x78, 0xc1, 0xa0, 0xc8, 0x2d,
	0x58, 0xb7, 0x5e, 0x3f, 0xc5, 0xbf, 0x23, 0x18, 0x2b, 0x4d, 0x26, 0x66, 0x15, 0xef, 0x34, 0xcc,
	0x54, 0x84, 0x5e, 0x13, 0xd0, 0xaf, 0xd8, 0x77, 0x2b, 0x43, 0xaf, 0x9e, 0x64, 0xd9, 0x57, 0x51,
	0x1d, 0xff, 0x81, 0x60, 0xbc, 0x3c, 0xc5, 0xe0, 0x15, 0xf3, 0x77, 0xe2, 0x62, 0xf8, 0x2b, 0x37,
	0xc9, 0x6a, 0x6b, 0x12, 0x7a, 0x8a, 0x60, 0xbc, 0x3c, 0xeb, 0x98, 0xf1, 0x77, 0x9c, 0x8f, 0x2a,
	0xf2, 0xaf, 0x0b, 0xfe, 0x7b, 0x56, 0xf5, 0xa6, 0x29, 0x6c, 0xe0, 0x5b, 0x04, 0xe3, 0xe5, 0xa9,
	0xc9, 0x6c, 0x03, 0x1d, 0x27, 0xad, 0xae, 0x8f, 0x88, 0xea, 0xef, 0xfa, 0x39, 0xfa, 0xfb, 0x37,
	0xa5, 0xcd, 0x6a, 0x40, 0x32, 0xd7, 0xe6, 0xf2, 0xf0, 0x66, 0xae, 0xcd, 0x6d, 0x93, 0x98, 0xbd,
	0x24, 0xd8, 0x6f, 0x61, 0xc7, 0xb0, 0x4d, 0xf4, 0xec, 0xf5, 0xbd, 0x54, 0x69, 0x19, 0xce, 0x58,
	0xa5, 0x4b, 0x53, 0x8c, 0x55, 0x61, 0x5e, 0xea, 0xc4, 0xd9, 0xbd, 0xc6, 0x0a, 0x32, 0x7b, 0xb2,
	0x7f, 0xc8, 0x85, 0x5a, 0xa1, 0x56, 0x10, 0xea, 0x32, 0xed, 0x75, 0xed, 0x58, 0xf8, 0x65, 0xc4,
	0x79, 0xa0, 0x7f, 0x19, 0xb1, 0x5f, 0x15, 0x80, 0xcb, 0x76, 0xc5, 0x42, 0xae, 0xea, 0x41, 0xf0,
	0x49, 0xae, 0x75, 0x55, 0x40, 0x3b, 0x0c, 0x87, 0x5d, 0xdb, 0x54, 0x95, 0xb0, 0x5e, 0xb1, 0x84,
	0x6b, 0x7f, 0x22, 0x98, 0x6b, 0x84, 0x47, 0x06, 0x38, 0x0f, 0xd1, 0x7b, 0x0f, 0x94, 0x95, 0x1f,
	0x36, 0x09, 0xf3, 0x9d, 0x30, 0xf6, 0x5d, 0x9f, 0x32, 0x41, 0xe2, 0xca, 0x4f, 0x24, 0x0a, 0x92,
	0x5e, 0xbf, 0x48, 0xbd, 0x5c, 0x5a, 0xfd, 0x69, 0xc0, 0xde, 0x90, 0x11, 0xd7, 0x45, 0xde, 0xd2,
	0x58, 0xe1, 0x6c, 0x2f, 0xac, 0x65, 0x2e, 0x7f, 0x69, 0xa3, 0x1d, 0x61, 0xb4, 0x53, 0x32, 0xda,
	0xd9, 0x96, 0x71, 0xf7, 0x86, 0x04, 0xc5, 0xed, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x9f, 0x36,
	0x17, 0x5a, 0x90, 0x13, 0x00, 0x00,
}
