/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef FB2TOKEN_H_INCLUDED
#define FB2TOKEN_H_INCLUDED

#include "EBOOKToken.h"

#include <boost/static_assert.hpp>

namespace libebook
{

#define FB2_NO_NAMESPACE(ns) (0 == ns)

namespace FB2Token
{

enum
{
  INVALID_TOKEN = 0,
  FIRST_TOKEN = EBOOKToken<FB2Parser>::FIRST_TOKEN,

  // namespaces
  NS_FICTIONBOOK,
  NS_XLINK,
  NS_XML,
  NS_XMLNS,

  // elements
  a,
  annotation,
  author,
  binary,
  body,
  book_name,
  book_title,
  cite,
  city,
  code,
  coverpage,
  custom_info,
  date,
  description,
  document_info,
  email,
  emphasis,
  empty_line,
  epigraph,
  FictionBook,
  first_name,
  genre,
  history,
  home_page,
  id,
  image,
  isbn,
  keywords,
  lang,
  last_name,
  middle_name,
  nickname,
  output,
  output_document,
  p,
  part,
  poem,
  program_used,
  publisher,
  publish_info,
  section,
  sequence,
  src_lang,
  src_ocr,
  src_title_info,
  src_url,
  stanza,
  strikethrough,
  strong,
  style,
  stylesheet,
  sub,
  subtitle,
  sup,
  table,
  td,
  text_author,
  th,
  title,
  title_info,
  tr,
  translator,
  v,
  version,
  year,

  // attributes
  align,
  alt,
  colspan,
  content_type,
  create,
  currency,
  href,
  include,
  include_all,
  info_type,
  match,
  mode,
  name,
  number,
  price,
  rowspan,
  type,
  value,

  // attribute values
  note,
  simple,

  LAST_TOKEN
};

BOOST_STATIC_ASSERT(EBOOKToken<FB2Parser>::LAST_TOKEN >= LAST_TOKEN);

}

struct FB2TokenData
{
  const char *name;
  int id;
};

const FB2TokenData *getFB2Token(const char *str, const unsigned length);
const FB2TokenData *getFB2Token(const char *str);
const FB2TokenData *getFB2Token(const unsigned char *str);

int getFB2TokenID(const FB2TokenData &token);
int getFB2TokenID(const FB2TokenData *token);
int getFB2TokenID(const char *str, const unsigned length);
int getFB2TokenID(const char *str);
int getFB2TokenID(const unsigned char *str);

const char *getFB2TokenName(const FB2TokenData &token);
const char *getFB2TokenName(const FB2TokenData *token);
const char *getFB2TokenName(const char *str, const unsigned length);
const char *getFB2TokenName(const char *str);
const char *getFB2TokenName(const unsigned char *str);

}

#endif // FB2TOKEN_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
