/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/LoggingLevelCollectionXml.h"

#include "Doc/CafCoreTypesDoc/CLoggingLevelCollectionDoc.h"
#include "Doc/ProviderRequestDoc/CProviderRequestConfigDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderRequestConfigXml.h"

using namespace Caf;

void ProviderRequestConfigXml::add(
	const SmartPtrCProviderRequestConfigDoc providerRequestConfigDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderRequestConfigXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerRequestConfigDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string responseFormatTypeVal = providerRequestConfigDoc->getResponseFormatType();
		CAF_CM_VALIDATE_STRING(responseFormatTypeVal);
		thisXml->addAttribute("responseFormatType", responseFormatTypeVal);

		const SmartPtrCLoggingLevelCollectionDoc loggingLevelCollectionVal =
			providerRequestConfigDoc->getLoggingLevelCollection();
		if (! loggingLevelCollectionVal.IsNull()) {
			const SmartPtrCXmlElement loggingLevelCollectionXml =
				thisXml->createAndAddElement("loggingLevelCollection");
			LoggingLevelCollectionXml::add(loggingLevelCollectionVal, loggingLevelCollectionXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderRequestConfigDoc ProviderRequestConfigXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderRequestConfigXml", "parse");

	SmartPtrCProviderRequestConfigDoc providerRequestConfigDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string responseFormatTypeStrVal =
			thisXml->findRequiredAttribute("responseFormatType");
		const std::string responseFormatTypeVal = responseFormatTypeStrVal;

		const SmartPtrCXmlElement loggingLevelCollectionXml =
			thisXml->findOptionalChild("loggingLevelCollection");

		SmartPtrCLoggingLevelCollectionDoc loggingLevelCollectionVal;
		if (! loggingLevelCollectionXml.IsNull()) {
			loggingLevelCollectionVal = LoggingLevelCollectionXml::parse(loggingLevelCollectionXml);
		}

		providerRequestConfigDoc.CreateInstance();
		providerRequestConfigDoc->initialize(
			responseFormatTypeVal,
			loggingLevelCollectionVal);
	}
	CAF_CM_EXIT;

	return providerRequestConfigDoc;
}

