//@ skip

function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual);
}

/*
wasm/control-flow.wasm is generated by pack-asmjs <https://github.com/WebAssembly/polyfill-prototype-1> from the following script:

function asmModule(global, env, buffer) {
    "use asm";

    function ifTrue() {
        var x = 0;
        x = 5;
        if ((x | 0) > 0)
            return 1;
        return 0;
    }

    function ifFalse() {
        var x = 0;
        if ((x | 0) > 0)
            return 1;
        return 0;
    }

    function ifElseTrue() {
        var x = 0;
        x = 5;
        if ((x | 0) > 0)
            return 1;
        else
            return 2;
        return 0;
    }

    function ifElseFalse() {
        var x = 0;
        if ((x | 0) > 0)
            return 1;
        else
            return 2;
        return 0;
    }

    function ifInIf() {
        var x = 0, y = 0;
        x = 1;
        if ((x | 0) == 0) {
            if ((y | 0) == 0)
                return 1;
            else
                return 2;
        } else {
            if ((y | 0) == 0)
                return 3;
            else
                return 4;
        }
        return 0;
    }

    function whileLoop() {
        var x = 0, i = 0;
        while ((i | 0) < 5) {
            x = (x + 1) | 0;
            i = (i + 1) | 0;
        }
        return x | 0;
    }

    function whileBreak() {
        var x = 0, i = 0;
        while (1) {
            if ((i | 0) == 2)
                break;
            x = (x + 1) | 0;
            i = (i + 1) | 0;
        }
        return x | 0;
    }

    function whileContinue() {
        var x = 0, i = 0;
        while ((i | 0) < 5) {
            if ((i | 0) == 2) {
                i = 3;
                continue;
            }
            x = (x + 1) | 0;
            i = (i + 1) | 0;
        }
        return x | 0;
    }

    function whileInWhile() {
        var x = 0, i = 0, j = 0;
        while ((i | 0) < 5) {
            j = 0;
            while ((j | 0) < 2) {
                x = (x + 1) | 0;
                j = (j + 1) | 0;
            }
            i = (i + 1) | 0;
        }
        return x | 0;
    }

    function doLoop() {
        var x = 0, i = 0;
        do {
            x = (x + 1) | 0;
            i = (i + 1) | 0;
        } while ((i | 0) < 0);
        return x | 0;
    }

    function doBreak() {
        var x = 0, i = 0;
        do {
            if ((i | 0) == 2)
                break;
            x = (x + 1) | 0;
            i = (i + 1) | 0;
        } while (1);
        return x | 0;
    }

    function doContinue() {
        var x = 0, i = 0;
        do {
            if ((i | 0) == 2) {
                i = 3;
                continue;
            }
            x = (x + 1) | 0;
            i = (i + 1) | 0;
        } while ((i | 0) < 5);
        return x | 0;
    }

    function labelBreak() {
        var x = 0;
        label: do {
            x = 1;
            break label;
            x = 2;
        } while (0);
        return x | 0;
    }

    function labelContinue() {
        var x = 0;
        label: do {
            if ((x | 0) == 1)
                break label;
            x = 1;
            continue label;
            x = 2;
        } while (0);
        return x | 0;
    }

    function labelInLabelBreakInner() {
        var x = 0;
        outer: do {
            x = 1;
            inner: do {
                x = 2;
                break inner;
                x = 3;
            } while (0);
            x = 4;
        } while (0);
        return x | 0;
    }

    function labelInLabelBreakOuter() {
        var x = 0;
        outer: do {
            x = 1;
            inner: do {
                x = 2;
                break outer;
                x = 3;
            } while (0);
            x = 4;
        } while (0);
        return x | 0;
    }

    function whileInWhileBreakOuter() {
        var x = 0, i = 0, j = 0;
        label:
        while ((i | 0) < 5) {
            j = 0;
            while ((j | 0) < 2) {
                x = (x + 1) | 0;
                if ((x | 0) == 8)
                    break label;
                j = (j + 1) | 0;
            }
            i = (i + 1) | 0;
        }
        return x | 0;
    }

    function switchCase(x) {
        x = x | 0;
        var y = 0;
        switch (x | 0) {
        case 0:
            y = 1;
            break;
        case 1:
            y = 2;
            break;
        case 2:
            y = 3;
            break;
        }
        return y | 0;
    }

    function switchFallThrough(x) {
        x = x | 0;
        var y = 0;
        switch (x | 0) {
        case 3:
            y = (y + 1000) | 0;
        case 2:
            y = (y + 100) | 0;
        case 1:
            y = (y + 10) | 0;
        default:
            y = (y + 1) | 0;
        }
        return y | 0;
    }

    function conditionalTrue() {
        var x = 0;
        x = 5;
        return (((x | 0) > 0) ? 1 : 2) | 0;
    }

    function conditionalFalse() {
        var x = 0;
        return ((x | 0) > 0) ? 1.0 : 2.0;
    }

    function conditionalFalse2() {
        var x = 0, y = 0;
        return (((x | 0) > 0) ? (y = (y + 1) | 0) : (y = (y + 2) | 0)) | 0;
    }

    return {
        ifTrue: ifTrue,
        ifFalse: ifFalse,
        ifElseTrue: ifElseTrue,
        ifElseFalse: ifElseFalse,
        ifInIf: ifInIf,

        whileLoop: whileLoop,
        whileBreak: whileBreak,
        whileContinue: whileContinue,
        whileInWhile: whileInWhile,

        doLoop: doLoop,
        doBreak: doBreak,
        doContinue: doContinue,

        labelBreak: labelBreak,
        labelContinue: labelContinue,
        labelInLabelBreakInner: labelInLabelBreakInner,
        labelInLabelBreakOuter: labelInLabelBreakOuter,
        whileInWhileBreakOuter: whileInWhileBreakOuter,

        switchCase: switchCase,
        switchFallThrough: switchFallThrough,

        conditionalTrue: conditionalTrue,
        conditionalFalse: conditionalFalse,
        conditionalFalse2: conditionalFalse2,
    };
}
*/

var module = loadWebAssembly("wasm/control-flow.wasm");

shouldBe(module.ifTrue(), 1);
shouldBe(module.ifFalse(), 0);
shouldBe(module.ifElseTrue(), 1);
shouldBe(module.ifElseFalse(), 2);
shouldBe(module.ifInIf(), 3);

shouldBe(module.whileLoop(), 5);
shouldBe(module.whileBreak(), 2);
shouldBe(module.whileContinue(), 4);
shouldBe(module.whileInWhile(), 10);

shouldBe(module.doLoop(), 1);
shouldBe(module.doBreak(), 2);
shouldBe(module.doContinue(), 4);

shouldBe(module.labelBreak(), 1);
shouldBe(module.labelContinue(), 1);
shouldBe(module.labelInLabelBreakInner(), 4);
shouldBe(module.labelInLabelBreakOuter(), 2);
shouldBe(module.whileInWhileBreakOuter(), 8);

shouldBe(module.switchCase(0), 1);
shouldBe(module.switchCase(1), 2);
shouldBe(module.switchCase(2), 3);
shouldBe(module.switchCase(3), 0);
shouldBe(module.switchFallThrough(0), 1);
shouldBe(module.switchFallThrough(1), 11);
shouldBe(module.switchFallThrough(2), 111);
shouldBe(module.switchFallThrough(3), 1111);
shouldBe(module.switchFallThrough(4), 1);

shouldBe(module.conditionalTrue(), 1);
shouldBe(module.conditionalFalse(), 2);
shouldBe(module.conditionalFalse2(), 2);
