/*
 * Copyright (c) 2016, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <debug.h>
#include <mmio.h>
#include <plat_sip_calls.h>
#include <rockchip_sip_svc.h>
#include <runtime_svc.h>

uintptr_t rockchip_plat_sip_handler(uint32_t smc_fid,
				   u_register_t x1,
				   u_register_t x2,
				   u_register_t x3,
				   u_register_t x4,
				   void *cookie,
				   void *handle,
				   u_register_t flags)
{
	ERROR("%s: unhandled SMC (0x%x)\n", __func__, smc_fid);
	SMC_RET1(handle, SMC_UNK);
}
