/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.elementvalues;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.elementvalues.ElementValue;
import org.gjt.jclasslib.structures.elementvalues.ElementValuePair;

public class AnnotationElementValue
extends ElementValue {
    public static final String ENTRY_NAME = "Annotation";
    private static final int INITIAL_LENGTH = 4;
    private int typeIndex;
    private ElementValuePair[] elementValuePairEntries;

    public AnnotationElementValue() {
        super(64);
    }

    public String getEntryName() {
        return ENTRY_NAME;
    }

    public ElementValuePair[] getElementValuePairEntries() {
        return this.elementValuePairEntries;
    }

    public void setElementValuePairEntries(ElementValuePair[] elementValuePairArray) {
        this.elementValuePairEntries = elementValuePairArray;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public void setTypeIndex(int n) {
        this.typeIndex = n;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        this.typeIndex = dataInput.readUnsignedShort();
        int n = dataInput.readUnsignedShort();
        this.elementValuePairEntries = new ElementValuePair[n];
        for (int i = 0; i < n; ++i) {
            this.elementValuePairEntries[i] = ElementValuePair.create(dataInput, this.classFile);
        }
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.typeIndex);
        int n = this.getLength(this.elementValuePairEntries);
        dataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.elementValuePairEntries[i].write(dataOutput);
        }
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected int getSpecificLength() {
        int n = 4;
        for (int i = 0; i < this.elementValuePairEntries.length; ++i) {
            n += this.elementValuePairEntries[i].getLength();
        }
        return n;
    }

    protected void debug(String string) {
        super.debug(string + "Annotation with " + this.getLength(this.elementValuePairEntries) + " value pair elements");
    }
}

