//crossfire world creation program
//makes square world full of grass
//created by Chad Opperman
//note that using this program leaves a file called "filename.txt" behind which
//can safely be deleted
#include <cmath>
#include <iostream>
#include <fstream>
using namespace std;

int main(void)
{
auto ifstream input;
auto ofstream output;
auto int lfile = 100;
auto int rfile = 100;
auto int lnorth = 99;
auto int rnorth = 100;
auto int least = 100;
auto int reast = 101;
auto int lsouth = 101;
auto int rsouth = 100;
auto int lwest = 100;
auto int rwest = 99;
auto char temp[50];
auto int size;

cout << "Enter a world size (ex. 15 creates 15x15 of 50x50 pieces of wilderness)";
cin >> size;
size = abs(size);
size += 99;

//loop start
while(lfile <= size)
{

//this chunk of code updates the filename of the next file to be created
output.open("filename.txt");
output << "wilderness_" << lfile << "_" << rfile << "\n";
output.close();
input.open("filename.txt");
input.getline(temp, 50);
input.close();

//creates a file to have following text written to it
output.open(temp, ios_base::out|ios_base::trunc|ios_base::binary);

output << "arch map\n";
output << "name Wilderness\n";
output << "difficulty 1\n";
output << "region Wilderness\n";
output << "width 50\n";
output << "height 50\n";
output << "msg\n";
output << "Created using Chad Opperman's world generator\n";
output << "endmsg\n";
output << "outdoor 1\n";

output << "tile_path_1 " << "wilderness_" << lnorth << "_" << rnorth << "\n";
output << "tile_path_2 " << "wilderness_" << least << "_" << reast << "\n";
output << "tile_path_3 " << "wilderness_" << lsouth << "_" << rsouth << "\n";
output << "tile_path_4 " << "wilderness_" << lwest << "_" << rwest << "\n";
output << "end\n";

auto int x = 0;
auto int y = 0;
while((x < 50) && (y < 50))
	{

	output << "arch grassdark\n";
	if(x > 0)
		{
		output << "x " << x << "\n";

		}

	if(y > 0)
		{
		output << "y " << y << "\n";

		}

	output << "end\n";
	++y;
	if(y == 50)
		{
		y = 0;
		x += 1;
		}

	}

output.close();

//adjust coords
rfile += 1;
if(rfile > size)
	{
	lfile += 1;
	rfile = 100;

	}

lnorth = (lfile - 1); 
rnorth = rfile;
least = lfile;
reast = (rfile + 1);
lsouth = (lfile + 1);
rsouth = rfile;
lwest = lfile;
rwest = (rfile - 1);
//end of coord adjust

}//loop end

return 0;
}