CREATE TABLE IF NOT EXISTS `dc_blog` (
  `blog_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `blog_uid` varchar(32) COLLATE utf8_bin NOT NULL,
  `blog_creadt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `blog_upddt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `blog_url` varchar(255) COLLATE utf8_bin NOT NULL,
  `blog_name` varchar(255) COLLATE utf8_bin NOT NULL,
  `blog_desc` longtext COLLATE utf8_bin,
  `blog_status` smallint(6) NOT NULL DEFAULT '1',
  PRIMARY KEY (`blog_id`),
  KEY `dc_idx_blog_blog_upddt` (`blog_upddt`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_category` (
  `cat_id` bigint(20) NOT NULL,
  `blog_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `cat_title` varchar(255) COLLATE utf8_bin NOT NULL,
  `cat_url` varchar(255) COLLATE utf8_bin NOT NULL,
  `cat_desc` longtext COLLATE utf8_bin,
  `cat_position` int(11) DEFAULT '0',
  `cat_lft` int(11) DEFAULT NULL,
  `cat_rgt` int(11) DEFAULT NULL,
  PRIMARY KEY (`cat_id`),
  UNIQUE KEY `dc_uk_cat_url` (`cat_url`,`blog_id`),
  KEY `dc_idx_category_blog_id` (`blog_id`) USING BTREE,
  KEY `dc_idx_category_cat_lft_blog_id` (`blog_id`,`cat_lft`) USING BTREE,
  KEY `dc_idx_category_cat_rgt_blog_id` (`blog_id`,`cat_rgt`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_comment` (
  `comment_id` bigint(20) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `comment_dt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `comment_tz` varchar(128) COLLATE utf8_bin NOT NULL DEFAULT 'UTC',
  `comment_upddt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `comment_author` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `comment_email` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `comment_site` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `comment_content` longtext COLLATE utf8_bin,
  `comment_words` longtext COLLATE utf8_bin,
  `comment_ip` varchar(39) COLLATE utf8_bin DEFAULT NULL,
  `comment_status` smallint(6) DEFAULT '0',
  `comment_spam_status` varchar(128) COLLATE utf8_bin DEFAULT '0',
  `comment_spam_filter` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `comment_trackback` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `dc_idx_comment_post_id` (`post_id`) USING BTREE,
  KEY `dc_idx_comment_post_id_dt_status` (`post_id`,`comment_dt`,`comment_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_link` (
  `link_id` bigint(20) NOT NULL,
  `blog_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `link_href` varchar(255) COLLATE utf8_bin NOT NULL,
  `link_title` varchar(255) COLLATE utf8_bin NOT NULL,
  `link_desc` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `link_lang` varchar(5) COLLATE utf8_bin DEFAULT NULL,
  `link_xfn` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `link_position` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  KEY `dc_idx_link_blog_id` (`blog_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_log` (
  `log_id` bigint(20) NOT NULL,
  `user_id` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `blog_id` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `log_table` varchar(255) COLLATE utf8_bin NOT NULL,
  `log_dt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `log_ip` varchar(39) COLLATE utf8_bin NOT NULL,
  `log_msg` longtext COLLATE utf8_bin,
  PRIMARY KEY (`log_id`),
  KEY `dc_idx_log_user_id` (`user_id`) USING BTREE,
  KEY `dc_fk_log_blog` (`blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_media` (
  `media_id` bigint(20) NOT NULL,
  `user_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `media_path` varchar(255) COLLATE utf8_bin NOT NULL,
  `media_title` varchar(255) COLLATE utf8_bin NOT NULL,
  `media_file` varchar(255) COLLATE utf8_bin NOT NULL,
  `media_dir` varchar(255) COLLATE utf8_bin NOT NULL DEFAULT '.',
  `media_meta` longtext COLLATE utf8_bin,
  `media_dt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `media_creadt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `media_upddt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `media_private` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`media_id`),
  KEY `dc_idx_media_user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_meta` (
  `meta_id` varchar(255) COLLATE utf8_bin NOT NULL,
  `meta_type` varchar(64) COLLATE utf8_bin NOT NULL,
  `post_id` bigint(20) NOT NULL,
  PRIMARY KEY (`meta_id`,`meta_type`,`post_id`),
  KEY `dc_idx_meta_post_id` (`post_id`) USING BTREE,
  KEY `dc_idx_meta_meta_type` (`meta_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_permissions` (
  `user_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `blog_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `permissions` longtext COLLATE utf8_bin,
  PRIMARY KEY (`user_id`,`blog_id`),
  KEY `dc_idx_permissions_blog_id` (`blog_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_ping` (
  `post_id` bigint(20) NOT NULL,
  `ping_url` varchar(255) COLLATE utf8_bin NOT NULL,
  `ping_dt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`post_id`,`ping_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_post` (
  `post_id` bigint(20) NOT NULL,
  `blog_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `user_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `cat_id` bigint(20) DEFAULT NULL,
  `post_dt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `post_tz` varchar(128) COLLATE utf8_bin NOT NULL DEFAULT 'UTC',
  `post_creadt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `post_upddt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `post_password` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `post_type` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT 'post',
  `post_format` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT 'xhtml',
  `post_url` varchar(255) COLLATE utf8_bin NOT NULL,
  `post_lang` varchar(5) COLLATE utf8_bin DEFAULT NULL,
  `post_title` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `post_excerpt` longtext COLLATE utf8_bin,
  `post_excerpt_xhtml` longtext COLLATE utf8_bin,
  `post_content` longtext COLLATE utf8_bin,
  `post_content_xhtml` longtext COLLATE utf8_bin NOT NULL,
  `post_notes` longtext COLLATE utf8_bin,
  `post_meta` longtext COLLATE utf8_bin,
  `post_words` longtext COLLATE utf8_bin,
  `post_status` smallint(6) NOT NULL DEFAULT '0',
  `post_selected` smallint(6) NOT NULL DEFAULT '0',
  `post_position` int(11) NOT NULL DEFAULT '0',
  `post_open_comment` smallint(6) NOT NULL DEFAULT '0',
  `post_open_tb` smallint(6) NOT NULL DEFAULT '0',
  `nb_comment` int(11) NOT NULL DEFAULT '0',
  `nb_trackback` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  UNIQUE KEY `dc_uk_post_url` (`post_url`,`post_type`,`blog_id`),
  KEY `dc_idx_post_cat_id` (`cat_id`) USING BTREE,
  KEY `dc_idx_post_user_id` (`user_id`) USING BTREE,
  KEY `dc_idx_post_blog_id` (`blog_id`) USING BTREE,
  KEY `dc_idx_post_post_dt` (`post_dt`) USING BTREE,
  KEY `dc_idx_post_post_dt_post_id` (`post_dt`,`post_id`) USING BTREE,
  KEY `dc_idx_blog_post_post_dt_post_id` (`blog_id`,`post_dt`,`post_id`) USING BTREE,
  KEY `dc_idx_blog_post_post_status` (`blog_id`,`post_status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_post_media` (
  `media_id` bigint(20) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `link_type` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT 'attachment',
  PRIMARY KEY (`media_id`,`post_id`,`link_type`),
  KEY `dc_idx_post_media_post_id` (`post_id`) USING BTREE,
  KEY `dc_idx_post_media_media_id` (`media_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_pref` (
  `pref_id` varchar(255) COLLATE utf8_bin NOT NULL,
  `user_id` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `pref_ws` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT 'system',
  `pref_value` longtext COLLATE utf8_bin,
  `pref_type` varchar(8) COLLATE utf8_bin NOT NULL DEFAULT 'string',
  `pref_label` longtext COLLATE utf8_bin,
  UNIQUE KEY `dc_uk_pref` (`pref_ws`,`pref_id`,`user_id`),
  KEY `dc_idx_pref_user_id` (`user_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_session` (
  `ses_id` varchar(40) COLLATE utf8_bin NOT NULL,
  `ses_time` int(11) NOT NULL DEFAULT '0',
  `ses_start` int(11) NOT NULL DEFAULT '0',
  `ses_value` longtext COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`ses_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_setting` (
  `setting_id` varchar(255) COLLATE utf8_bin NOT NULL,
  `blog_id` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `setting_ns` varchar(32) COLLATE utf8_bin NOT NULL DEFAULT 'system',
  `setting_value` longtext COLLATE utf8_bin,
  `setting_type` varchar(8) COLLATE utf8_bin NOT NULL DEFAULT 'string',
  `setting_label` longtext COLLATE utf8_bin,
  UNIQUE KEY `dc_uk_setting` (`setting_ns`,`setting_id`,`blog_id`),
  KEY `dc_idx_setting_blog_id` (`blog_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_spamrule` (
  `rule_id` bigint(20) NOT NULL,
  `blog_id` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `rule_type` varchar(16) COLLATE utf8_bin NOT NULL DEFAULT 'word',
  `rule_content` varchar(128) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`rule_id`),
  KEY `dc_idx_spamrule_blog_id` (`blog_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_user` (
  `user_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `user_super` smallint(6) DEFAULT NULL,
  `user_status` smallint(6) NOT NULL DEFAULT '1',
  `user_pwd` varchar(40) COLLATE utf8_bin NOT NULL,
  `user_change_pwd` smallint(6) NOT NULL DEFAULT '0',
  `user_recover_key` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `user_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `user_firstname` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `user_displayname` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `user_email` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `user_url` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `user_desc` longtext COLLATE utf8_bin,
  `user_default_blog` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `user_options` longtext COLLATE utf8_bin,
  `user_lang` varchar(5) COLLATE utf8_bin DEFAULT NULL,
  `user_tz` varchar(128) COLLATE utf8_bin NOT NULL DEFAULT 'UTC',
  `user_post_status` smallint(6) NOT NULL DEFAULT '-2',
  `user_creadt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `user_upddt` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  PRIMARY KEY (`user_id`),
  KEY `dc_idx_user_user_default_blog` (`user_default_blog`) USING BTREE,
  KEY `dc_idx_user_user_super` (`user_super`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `dc_version` (
  `module` varchar(64) COLLATE utf8_bin NOT NULL,
  `version` varchar(32) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


ALTER TABLE `dc_category`
  ADD CONSTRAINT `dc_fk_category_blog` FOREIGN KEY (`blog_id`) REFERENCES `dc_blog` (`blog_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_comment`
  ADD CONSTRAINT `dc_fk_comment_post` FOREIGN KEY (`post_id`) REFERENCES `dc_post` (`post_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_link`
  ADD CONSTRAINT `dc_fk_link_blog` FOREIGN KEY (`blog_id`) REFERENCES `dc_blog` (`blog_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_log`
  ADD CONSTRAINT `dc_fk_log_blog` FOREIGN KEY (`blog_id`) REFERENCES `dc_blog` (`blog_id`) ON DELETE SET NULL ON UPDATE CASCADE;

ALTER TABLE `dc_media`
  ADD CONSTRAINT `dc_fk_media_user` FOREIGN KEY (`user_id`) REFERENCES `dc_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_meta`
  ADD CONSTRAINT `dc_fk_meta_post` FOREIGN KEY (`post_id`) REFERENCES `dc_post` (`post_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_permissions`
  ADD CONSTRAINT `dc_fk_permissions_user` FOREIGN KEY (`user_id`) REFERENCES `dc_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `dc_fk_permissions_blog` FOREIGN KEY (`blog_id`) REFERENCES `dc_blog` (`blog_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_ping`
  ADD CONSTRAINT `dc_fk_ping_post` FOREIGN KEY (`post_id`) REFERENCES `dc_post` (`post_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_post`
  ADD CONSTRAINT `dc_fk_post_blog` FOREIGN KEY (`blog_id`) REFERENCES `dc_blog` (`blog_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `dc_fk_post_category` FOREIGN KEY (`cat_id`) REFERENCES `dc_category` (`cat_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `dc_fk_post_user` FOREIGN KEY (`user_id`) REFERENCES `dc_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_post_media`
  ADD CONSTRAINT `dc_fk_media_post` FOREIGN KEY (`post_id`) REFERENCES `dc_post` (`post_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `dc_fk_media` FOREIGN KEY (`media_id`) REFERENCES `dc_media` (`media_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_pref`
  ADD CONSTRAINT `dc_fk_pref_user` FOREIGN KEY (`user_id`) REFERENCES `dc_user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_setting`
  ADD CONSTRAINT `dc_fk_setting_blog` FOREIGN KEY (`blog_id`) REFERENCES `dc_blog` (`blog_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_spamrule`
  ADD CONSTRAINT `dc_fk_spamrule_blog` FOREIGN KEY (`blog_id`) REFERENCES `dc_blog` (`blog_id`) ON DELETE CASCADE ON UPDATE CASCADE;

ALTER TABLE `dc_user`
  ADD CONSTRAINT `dc_fk_user_default_blog` FOREIGN KEY (`user_default_blog`) REFERENCES `dc_blog` (`blog_id`) ON DELETE SET NULL ON UPDATE CASCADE;
