/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "chip_st_lsm303dlhc_gui.h"
#ifdef HAVE_GTK
#include "chip_st_lsm303dlhc_gui_gtk.h"
#endif

void *
chip_st_lsm303dlhc_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_gnd,
	struct sig_std_logic *port_vdd,
	struct sig_std_logic *port_vdd_io,
	struct sig_std_logic *port_scl,
	struct sig_std_logic *port_sda,
	struct sig_std_logic *port_int1,
	struct sig_std_logic *port_int2,
	struct sig_std_logic *port_c1,
	struct sig_std_logic *port_drdy,
	struct sig_std_logic *port_setp,
	struct sig_std_logic *port_setc,
	struct sig_std_logic *port_R1,
	struct sig_std_logic *port_R2,
	struct sig_std_logic *port_R3,
	struct sig_integer *port_acc_x,
	struct sig_integer *port_acc_y,
	struct sig_integer *port_acc_z,
	struct sig_integer *port_mag_x,
	struct sig_integer *port_mag_y,
	struct sig_integer *port_mag_z
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return chip_st_lsm303dlhc_gui_gtk_create(page, name, port_manage,
				port_gnd, port_vdd, port_vdd_io, port_scl,
				port_sda, port_int1, port_int2, port_c1,
				port_drdy, port_setp, port_setc, port_R1,
				port_R2, port_R3,
				port_acc_x, port_acc_y, port_acc_z,
				port_mag_x, port_mag_y, port_mag_z);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
chip_st_lsm303dlhc_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chip_st_lsm303dlhc_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
chip_st_lsm303dlhc_gui_suspend(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chip_st_lsm303dlhc_gui_gtk_suspend(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
chip_st_lsm303dlhc_gui_resume(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chip_st_lsm303dlhc_gui_gtk_resume(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}
