/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "button_down_gui.h"

#ifdef HAVE_GTK
#include "button_down_gui_gtk.h"
#endif

#define COMP_(x)	button_down_ ## x

void *
COMP_(gui_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_mech_push_button,
	struct sig_std_logic *port_push_button
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return COMP_(gui_gtk_create)(page, name,
				port_manage,
				port_mech_push_button,
				port_push_button);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
COMP_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_suspend)(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_suspend)(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_resume)(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_resume)(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
