/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "lcd_s401m16kr_gui.h"

#ifdef HAVE_GTK
#include "lcd_s401m16kr_gui_gtk.h"
#endif

void *
lcd_s401m16kr_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_com0,
	struct sig_std_logic *port_com1,
	struct sig_std_logic *port_com2,
	struct sig_std_logic *port_com3,
	struct sig_std_logic *port_D1_E1_G1_F1,
	struct sig_std_logic *port_DP1_C1_B1_A1,
	struct sig_std_logic *port_D2_E2_G2_F2,
	struct sig_std_logic *port_DP2_C2_B2_A2,
	struct sig_std_logic *port_D3_E3_G3_F3,
	struct sig_std_logic *port_DP3_C3_B3_A3,
	struct sig_std_logic *port_D4_E4_G4_F4,
	struct sig_std_logic *port_COL_C4_B4_A4,
	struct sig_opt_rgb *port_D1,
	struct sig_opt_rgb *port_E1,
	struct sig_opt_rgb *port_G1,
	struct sig_opt_rgb *port_F1,
	struct sig_opt_rgb *port_DP1,
	struct sig_opt_rgb *port_C1,
	struct sig_opt_rgb *port_B1,
	struct sig_opt_rgb *port_A1,
	struct sig_opt_rgb *port_D2,
	struct sig_opt_rgb *port_E2,
	struct sig_opt_rgb *port_G2,
	struct sig_opt_rgb *port_F2,
	struct sig_opt_rgb *port_DP2,
	struct sig_opt_rgb *port_C2,
	struct sig_opt_rgb *port_B2,
	struct sig_opt_rgb *port_A2,
	struct sig_opt_rgb *port_D3,
	struct sig_opt_rgb *port_E3,
	struct sig_opt_rgb *port_G3,
	struct sig_opt_rgb *port_F3,
	struct sig_opt_rgb *port_DP3,
	struct sig_opt_rgb *port_C3,
	struct sig_opt_rgb *port_B3,
	struct sig_opt_rgb *port_A3,
	struct sig_opt_rgb *port_D4,
	struct sig_opt_rgb *port_E4,
	struct sig_opt_rgb *port_G4,
	struct sig_opt_rgb *port_F4,
	struct sig_opt_rgb *port_COL,
	struct sig_opt_rgb *port_C4,
	struct sig_opt_rgb *port_B4,
	struct sig_opt_rgb *port_A4
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return lcd_s401m16kr_gui_gtk_create(page, name,
				port_manage,
				port_com0, port_com1, port_com2, port_com3,
				port_D1_E1_G1_F1, port_DP1_C1_B1_A1,
				port_D2_E2_G2_F2, port_DP2_C2_B2_A2,
				port_D3_E3_G3_F3, port_DP3_C3_B3_A3,
				port_D4_E4_G4_F4, port_COL_C4_B4_A4,
				port_D1, port_E1, port_G1, port_F1,
				port_DP1, port_C1, port_B1, port_A1,
				port_D2, port_E2, port_G2, port_F2,
				port_DP2, port_C2, port_B2, port_A2,
				port_D3, port_E3, port_G3, port_F3,
				port_DP3, port_C3, port_B3, port_A3,
				port_D4, port_E4, port_G4, port_F4,
				port_COL, port_C4, port_B4, port_A4);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
lcd_s401m16kr_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		lcd_s401m16kr_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
lcd_s401m16kr_gui_suspend(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		lcd_s401m16kr_gui_gtk_suspend(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
lcd_s401m16kr_gui_resume(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		lcd_s401m16kr_gui_gtk_resume(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
