--
-- Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.ALL;
use expect.procedures.ALL;
library ieee;
use ieee.std_logic_1164.ALL;

entity pci_soundcard is 
	port (
		ext_pci : inout pci_conn;
		ext_speaker : inout sound
	);
end entity pci_soundcard;

architecture pci_soundcard_impl of pci_soundcard is
	signal int_ton_0 : std_logic;
	signal int_ton_1 : std_logic;
	signal int_ton_2 : std_logic;
	signal int_ton_3 : std_logic;
	signal int_ton_4 : std_logic;
	signal int_ton_5 : std_logic;
	signal int_ton_6 : std_logic;
	signal int_ton_7 : std_logic;
	signal int_ton_8 : std_logic;
	signal int_ton_9 : std_logic;
	signal int_ton_10 : std_logic;
	signal int_ton_11 : std_logic;
	signal int_ton_12 : std_logic;
	signal int_ton_13 : std_logic;
	signal int_ton_14 : std_logic;
	signal int_ton_15 : std_logic;
	signal int_rc_time_0 : std_logic;
	signal int_rc_time_1 : std_logic;
	signal int_rc_time_2 : std_logic;
	signal int_rc_time_3 : std_logic;
	signal int_volume_0 : std_logic;
	signal int_volume_1 : std_logic;
	signal int_volume_2 : std_logic;
	signal int_volume_3 : std_logic;
	signal int_ton_out : std_logic;
	signal int_sound : sound;
	signal int_sound_audio : sound;
	signal int_clk : std_logic;
	signal int_rst_n : std_logic;


begin
	pci_interface : misc_pci_control
		port map (
			pci => ext_pci,
			reg_out_xx0_0 => int_ton_0,
			reg_out_xx0_1 => int_ton_1,
			reg_out_xx0_2 => int_ton_2,
			reg_out_xx0_3 => int_ton_3,
			reg_out_xx0_4 => int_ton_4,
			reg_out_xx0_5 => int_ton_5,
			reg_out_xx0_6 => int_ton_6,
			reg_out_xx0_7 => int_ton_7,
			reg_out_xx1_0 => int_ton_8,
			reg_out_xx1_1 => int_ton_9,
			reg_out_xx1_2 => int_ton_10,
			reg_out_xx1_3 => int_ton_11,
			reg_out_xx1_4 => int_ton_12,
			reg_out_xx1_5 => int_ton_13,
			reg_out_xx1_6 => int_ton_14,
			reg_out_xx1_7 => int_ton_15
		);

	sound_gen : chip_gen_sound
		port map (
			ton_in_0 => int_ton_0,
			ton_in_1 => int_ton_1,
			ton_in_2 => int_ton_2,
			ton_in_3 => int_ton_3,
			ton_in_4 => int_ton_4,
			ton_in_5 => int_ton_5,
			ton_in_6 => int_ton_6,
			ton_in_7 => int_ton_7,
			ton_in_8 => int_ton_8,
			ton_in_9 => int_ton_9,
			ton_in_10 => int_ton_10,
			ton_in_11 => int_ton_11,
			ton_in_12 => int_ton_12,
			ton_in_13 => int_ton_13,
			ton_in_14 => int_ton_14,
			ton_in_15 => int_ton_15,
			pci_clock => int_clk,
			rstn => int_rst_n,
			rc_time_0 => int_rc_time_0,
			rc_time_1 => int_rc_time_1,
			rc_time_2 => int_rc_time_2,
			rc_time_3 => int_rc_time_3,
			volume_0 => int_volume_0,
			volume_1 => int_volume_1,
			volume_2 => int_volume_2,
			volume_3 => int_volume_3,
			ton_out => int_ton_out
		);

	amplifier : misc_analog_rcsound
		port map (
			ton_in => int_ton_out,
			rc_in_0 => int_rc_time_0,
			rc_in_1 => int_rc_time_1,
			rc_in_2 => int_rc_time_2,
			rc_in_3 => int_rc_time_3,
			vol_in_0 => int_volume_0,
			vol_in_1 => int_volume_1,
			vol_in_2 => int_volume_2,
			vol_in_3 => int_volume_3,
			snd_out => int_sound
		);

	speaker : loudspeaker
		port map (
			sound_in => int_sound,
			audio_sound => int_sound_audio
		);
end;

	
