/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import thredds.filesystem.CacheDirectory;
import thredds.filesystem.CacheFile;
import thredds.filesystem.CacheManager;
import thredds.filesystem.MFileCached;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerCachingOld {
    private CacheManager cacheManager;
    private Map<String, MCollection> map = new HashMap<String, MCollection>();

    public ControllerCachingOld(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void addCollection(MCollection mc) {
        this.map.put(mc.getName(), mc);
    }

    public Iterator<MFile> getInventory(String collectionName) {
        MCollection mc = this.map.get(collectionName);
        if (mc == null) {
            return null;
        }
        return this.getInventory(mc);
    }

    public Iterator<MFile> getInventory(MCollection mc) {
        CacheDirectory cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if ((cd = this.cacheManager.get(path, true)) == null) {
            return null;
        }
        return new FilteredIterator(mc, cd);
    }

    public void close() {
        this.cacheManager.close();
        this.cacheManager = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MFileIterator
    implements Iterator<MFile> {
        CacheDirectory cd;
        CacheFile[] files;
        int count = 0;

        MFileIterator(CacheDirectory cd) {
            this.cd = cd;
            this.files = cd.getChildren();
        }

        @Override
        public boolean hasNext() {
            return this.count < this.files.length;
        }

        @Override
        public MFile next() {
            CacheFile cfile = this.files[this.count++];
            return new MFileCached(this.cd.getPath(), cfile);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteredIterator
    implements Iterator<MFile> {
        private Iterator<MFile> orgIter;
        private MCollection mc;
        private MFile next;

        FilteredIterator(MCollection mc, CacheDirectory cd) {
            this.orgIter = new MFileIterator(cd);
            this.mc = mc;
        }

        @Override
        public boolean hasNext() {
            this.next = this.nextFilteredDataPoint();
            return this.next != null;
        }

        @Override
        public MFile next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private MFile nextFilteredDataPoint() {
            if (this.orgIter == null) {
                return null;
            }
            if (!this.orgIter.hasNext()) {
                return null;
            }
            MFile pdata = this.orgIter.next();
            while (!this.mc.accept(pdata)) {
                if (!this.orgIter.hasNext()) {
                    return null;
                }
                pdata = this.orgIter.next();
            }
            return pdata;
        }
    }
}

