/*
  objectdynamicpropertymodel.h

  This file is part of GammaRay, the Qt application inspection and
  manipulation tool.

  Copyright (C) 2010-2014 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com
  Author: Volker Krause <volker.krause@kdab.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GAMMARAY_OBJECTDYNAMICPROPERTYMODEL_H
#define GAMMARAY_OBJECTDYNAMICPROPERTYMODEL_H

#include "objectpropertymodel.h"

namespace GammaRay {

class ObjectDynamicPropertyModel : public ObjectPropertyModel
{
  Q_OBJECT
  public:
    explicit ObjectDynamicPropertyModel(QObject *parent = 0);

    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    bool setData(const QModelIndex &index, const QVariant &value, int role = Qt::EditRole);
    Qt::ItemFlags flags(const QModelIndex &index) const;
    int rowCount(const QModelIndex &parent = QModelIndex()) const;

    bool eventFilter(QObject *receiver, QEvent *event);

protected:
    void monitorObject(QObject *obj);
    void unmonitorObject(QObject *obj);

private slots:
    void updatePropertyCount();

private:
    int m_propertyCount;
};

}

#endif // GAMMARAY_OBJECTDYNAMICPROPERTYMODEL_H
