#
# @file geisview/defaults.py
# @brief Default values for geisview.
#
# Copyright (C) 2011 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 3 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import os
import gettext


root_dir = os.path.dirname(__file__)
if os.path.exists(os.path.join(root_dir, "Makefile.am")):
    # running in source directory
    data_dir = root_dir
    locale_dir = os.path.join(data_dir, "locale")
    ui_dir = data_dir
else:
    # running from installed
    data_dir = os.path.join("/usr/local/share/geisview")
    locale_dir = os.path.join(data_dir, "locale")
    ui_dir = data_dir


i18n_domain = "geisview"
gettext.bindtextdomain(i18n_domain, locale_dir)
gettext.textdomain(i18n_domain)
from gettext import gettext as _

version = "1.0"
appname = _("GEIS Viewer")
appname_short = _("geisview")
copyright = 'Copyright 2011 Canonical, Ltd.'
description = _("A GEIS data viewer.\n\nGEIS Viewer is a part of "
                "the Canonical gesture recognition stack.")
authors = ["Stephen M. Webb  <stephen.webb@canonical.com"]

LICENSE = _("%s is free software; you can redistribute it and/or modify " 
       "it under the terms of version 3 of the GNU General Public License "
       "as published by the Free Software Foundation.\n\n").replace("%s", appname),
_("%s is distributed in the hope that it will be useful, "
       "but WITHOUT ANY WARRANTY; without even the implied warranty of "
       "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
       "GNU General Public License for more details.\n\n").replace("%s", appname),
_("You should have received a copy of the GNU General Public License "
  "along with this program.  If not, see <http://www.gnu.org/licenses/>.")


