#!/bin/sh

if [ ! -x /usr/bin/unzip ]; then
	echo "You need the unzip package, to run this script."
	exit 1
fi

URL="https://geolite.maxmind.com/download/geoip/database/GeoLite2-Country-CSV.zip"

OLDDIR=$(pwd)
TMPDIR=$(mktemp -d)
DATE=$(date +'%Y%m%d')

cd ${TMPDIR}

wget ${URL} -O GeoLite2-Country-CSV.zip

unzip GeoLite2-Country-CSV.zip

mkdir ${TMPDIR}/geoip-database-${DATE}

mv GeoLite2-Country-CSV_*/* ${TMPDIR}/geoip-database-${DATE}/

tar -cJf geoip-database_${DATE}.orig.tar.xz geoip-database-${DATE}
mv geoip-database_${DATE}.orig.tar.xz ${OLDDIR}/../geoip-database_${DATE}.orig.tar.xz

cd ${OLDDIR}
rm -rf ${TMPDIR}

echo "Saved tarball: ${OLDDIR}/../geoip-database_${DATE}.orig.tar.xz"

exit 0
