/* gitg-remote.c generated by valac 0.34.0.108-f56ac, the Vala compiler
 * generated from gitg-remote.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgit2-glib/ggit.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define GITG_TYPE_REMOTE_STATE (gitg_remote_state_get_type ())

#define GITG_TYPE_CREDENTIALS_PROVIDER (gitg_credentials_provider_get_type ())
#define GITG_CREDENTIALS_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_CREDENTIALS_PROVIDER, GitgCredentialsProvider))
#define GITG_IS_CREDENTIALS_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_CREDENTIALS_PROVIDER))
#define GITG_CREDENTIALS_PROVIDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_CREDENTIALS_PROVIDER, GitgCredentialsProviderIface))

typedef struct _GitgCredentialsProvider GitgCredentialsProvider;
typedef struct _GitgCredentialsProviderIface GitgCredentialsProviderIface;

#define GITG_TYPE_REMOTE (gitg_remote_get_type ())
#define GITG_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_REMOTE, GitgRemote))
#define GITG_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_REMOTE, GitgRemoteClass))
#define GITG_IS_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_REMOTE))
#define GITG_IS_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_REMOTE))
#define GITG_REMOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_REMOTE, GitgRemoteClass))

typedef struct _GitgRemote GitgRemote;
typedef struct _GitgRemoteClass GitgRemoteClass;
typedef struct _GitgRemotePrivate GitgRemotePrivate;

#define GITG_REMOTE_TYPE_CALLBACKS (gitg_remote_callbacks_get_type ())
#define GITG_REMOTE_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacks))
#define GITG_REMOTE_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacksClass))
#define GITG_REMOTE_IS_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_REMOTE_TYPE_CALLBACKS))
#define GITG_REMOTE_IS_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_REMOTE_TYPE_CALLBACKS))
#define GITG_REMOTE_CALLBACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacksClass))

typedef struct _GitgRemoteCallbacks GitgRemoteCallbacks;
typedef struct _GitgRemoteCallbacksClass GitgRemoteCallbacksClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgRemoteConnectData GitgRemoteConnectData;
typedef struct _GitgRemoteDisconnectData GitgRemoteDisconnectData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block17Data Block17Data;
#define __vala_GgitFetchOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitFetchOptions_free (var), NULL)))
typedef struct _GitgRemoteDownloadInternData GitgRemoteDownloadInternData;
typedef struct _GitgRemoteDownloadData GitgRemoteDownloadData;
typedef struct _GitgRemoteFetchData GitgRemoteFetchData;
typedef struct _GitgRemoteCallbacksPrivate GitgRemoteCallbacksPrivate;
enum  {
	GITG_REMOTE_TIP_UPDATED_SIGNAL,
	GITG_REMOTE_LAST_SIGNAL
};
static guint gitg_remote_signals[GITG_REMOTE_LAST_SIGNAL] = {0};

typedef enum  {
	GITG_REMOTE_STATE_DISCONNECTED,
	GITG_REMOTE_STATE_CONNECTING,
	GITG_REMOTE_STATE_CONNECTED,
	GITG_REMOTE_STATE_TRANSFERRING
} GitgRemoteState;

typedef enum  {
	GITG_REMOTE_ERROR_ALREADY_CONNECTED,
	GITG_REMOTE_ERROR_ALREADY_CONNECTING,
	GITG_REMOTE_ERROR_ALREADY_DISCONNECTED,
	GITG_REMOTE_ERROR_STILL_CONNECTING
} GitgRemoteError;
#define GITG_REMOTE_ERROR gitg_remote_error_quark ()
struct _GitgCredentialsProviderIface {
	GTypeInterface parent_iface;
	GgitCred* (*credentials) (GitgCredentialsProvider* self, const gchar* url, const gchar* username_from_url, GgitCredtype allowed_types, GError** error);
};

struct _GitgRemote {
	GgitRemote parent_instance;
	GitgRemotePrivate * priv;
};

struct _GitgRemoteClass {
	GgitRemoteClass parent_class;
};

struct _GitgRemotePrivate {
	GitgRemoteState d_state;
	gchar** d_fetch_specs;
	gint d_fetch_specs_length1;
	gint _d_fetch_specs_size_;
	gchar** d_push_specs;
	gint d_push_specs_length1;
	gint _d_push_specs_size_;
	guint d_reset_transfer_progress_timeout;
	gdouble d_transfer_progress;
	GitgRemoteCallbacks* d_callbacks;
	GitgCredentialsProvider* _credentials_provider;
};

struct _Block16Data {
	int _ref_count_;
	GitgRemote* self;
	GgitDirection direction;
	gpointer _async_data_;
};

typedef void (*GitgRemoteCallbacksTransferProgress) (GgitTransferProgress* stats, void* user_data);
typedef void (*GitgAsyncThreadFunc) (void* user_data, GError** error);
struct _GitgRemoteConnectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	GgitDirection direction;
	GgitRemoteCallbacks* callbacks;
	Block16Data* _data16_;
	GgitDirection _tmp0_;
	gboolean _tmp1_;
	GitgRemoteState _tmp2_;
	GitgRemoteState _tmp3_;
	GError* _tmp4_;
	GitgRemoteState _tmp5_;
	GitgRemoteState _tmp6_;
	GError* _tmp7_;
	GgitRemoteCallbacks* _tmp8_;
	GitgRemoteCallbacks* _tmp9_;
	GError* e;
	gboolean _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _GitgRemoteDisconnectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	gboolean _tmp0_;
	GitgRemoteState _tmp1_;
	GitgRemoteState _tmp2_;
	GError* _tmp3_;
	GError* e;
	GError* _tmp4_;
	GError* _tmp5_;
	GError * _inner_error_;
};

struct _Block17Data {
	int _ref_count_;
	GitgRemote* self;
	gchar* message;
	gpointer _async_data_;
};

struct _GitgRemoteDownloadInternData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	gchar* message;
	GgitRemoteCallbacks* callbacks;
	Block17Data* _data17_;
	const gchar* _tmp0_;
	gboolean dis;
	gboolean _tmp1_;
	GgitRemoteCallbacks* _tmp2_;
	GError* e;
	gboolean _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_;
};

struct _GitgRemoteDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	GgitRemoteCallbacks* callbacks;
	GgitRemoteCallbacks* _tmp0_;
	GError * _inner_error_;
};

struct _GitgRemoteFetchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GitgRemote* self;
	gchar* message;
	GgitRemoteCallbacks* callbacks;
	gchar* msg;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* name;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	GgitRemoteCallbacks* _tmp13_;
	GError * _inner_error_;
};

struct _GitgRemoteCallbacks {
	GgitRemoteCallbacks parent_instance;
	GitgRemoteCallbacksPrivate * priv;
};

struct _GitgRemoteCallbacksClass {
	GgitRemoteCallbacksClass parent_class;
};

struct _GitgRemoteCallbacksPrivate {
	GitgRemote* d_remote;
	GgitRemoteCallbacks* d_proxy;
	GitgRemoteCallbacksTransferProgress d_transfer_progress;
	gpointer d_transfer_progress_target;
	GDestroyNotify d_transfer_progress_target_destroy_notify;
};


static gpointer gitg_remote_parent_class = NULL;
static gpointer gitg_remote_callbacks_parent_class = NULL;

GType gitg_remote_state_get_type (void) G_GNUC_CONST;
GQuark gitg_remote_error_quark (void);
GType gitg_credentials_provider_get_type (void) G_GNUC_CONST;
GgitCred* gitg_credentials_provider_credentials (GitgCredentialsProvider* self, const gchar* url, const gchar* username_from_url, GgitCredtype allowed_types, GError** error);
GType gitg_remote_get_type (void) G_GNUC_CONST;
static GType gitg_remote_callbacks_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GITG_REMOTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TYPE_REMOTE, GitgRemotePrivate))
enum  {
	GITG_REMOTE_DUMMY_PROPERTY,
	GITG_REMOTE_TRANSFER_PROGRESS,
	GITG_REMOTE_STATE,
	GITG_REMOTE_FETCH_SPECS,
	GITG_REMOTE_PUSH_SPECS,
	GITG_REMOTE_CREDENTIALS_PROVIDER
};
static void gitg_remote_real_dispose (GObject* base);
static void gitg_remote_do_reset_transfer_progress (GitgRemote* self);
static void gitg_remote_reset_transfer_progress (GitgRemote* self, gboolean with_delay);
static gboolean ___lambda66_ (GitgRemote* self);
static gboolean ____lambda66__gsource_func (gpointer self);
static void gitg_remote_update_transfer_progress (GitgRemote* self, GgitTransferProgress* stats);
static void gitg_remote_update_state (GitgRemote* self, gboolean force_disconnect);
void gitg_remote_disconnect (GitgRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_remote_disconnect_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static void ____lambda68_ (GitgRemote* self, GObject* obj, GAsyncResult* res);
static void _____lambda68__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gitg_remote_set_state (GitgRemote* self, GitgRemoteState value);
static void gitg_remote_connect_data_free (gpointer _data);
void gitg_remote_connect (GitgRemote* self, GgitDirection direction, GgitRemoteCallbacks* callbacks, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_remote_connect_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_remote_connect_co (GitgRemoteConnectData* _data_);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
GitgRemoteState gitg_remote_get_state (GitgRemote* self);
static void _gitg_remote_update_transfer_progress_gitg_remote_callbacks_transfer_progress (GgitTransferProgress* stats, gpointer self);
static GitgRemoteCallbacks* gitg_remote_callbacks_new (GitgRemote* remote, GgitRemoteCallbacks* proxy, GitgRemoteCallbacksTransferProgress transfer_progress, void* transfer_progress_target, GDestroyNotify transfer_progress_target_destroy_notify);
static GitgRemoteCallbacks* gitg_remote_callbacks_construct (GType object_type, GitgRemote* remote, GgitRemoteCallbacks* proxy, GitgRemoteCallbacksTransferProgress transfer_progress, void* transfer_progress_target, GDestroyNotify transfer_progress_target_destroy_notify);
void gitg_async_thread (GitgAsyncThreadFunc func, void* func_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_async_thread_finish (GAsyncResult* _res_, GError** error);
static void ____lambda69_ (Block16Data* _data16_, GError** error);
static void _____lambda69__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_remote_connect_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_remote_disconnect_data_free (gpointer _data);
static gboolean gitg_remote_disconnect_co (GitgRemoteDisconnectData* _data_);
static void ___lambda67_ (GitgRemote* self, GError** error);
static void ____lambda67__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_remote_disconnect_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_remote_download_intern_data_free (gpointer _data);
static void gitg_remote_download_intern (GitgRemote* self, const gchar* message, GgitRemoteCallbacks* callbacks, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gitg_remote_download_intern_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_remote_download_intern_co (GitgRemoteDownloadInternData* _data_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void gitg_remote_download_intern_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void ___lambda70_ (Block17Data* _data17_, GError** error);
static void _vala_GgitFetchOptions_free (GgitFetchOptions* self);
static void ____lambda70__gitg_async_thread_func (gpointer self, GError** error);
static void gitg_remote_download_data_free (gpointer _data);
void gitg_remote_download (GitgRemote* self, GgitRemoteCallbacks* callbacks, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_remote_download_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_remote_download_co (GitgRemoteDownloadData* _data_);
static void gitg_remote_download_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void gitg_remote_fetch_data_free (gpointer _data);
void gitg_remote_fetch (GitgRemote* self, const gchar* message, GgitRemoteCallbacks* callbacks, GAsyncReadyCallback _callback_, gpointer _user_data_);
void gitg_remote_fetch_finish (GitgRemote* self, GAsyncResult* _res_, GError** error);
static gboolean gitg_remote_fetch_co (GitgRemoteFetchData* _data_);
static void gitg_remote_fetch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GitgRemote* gitg_remote_new (void);
GitgRemote* gitg_remote_construct (GType object_type);
gdouble gitg_remote_get_transfer_progress (GitgRemote* self);
gchar** gitg_remote_get_fetch_specs (GitgRemote* self, int* result_length1);
static gchar** _vala_array_dup17 (gchar** self, int length);
void gitg_remote_set_fetch_specs (GitgRemote* self, gchar** value, int value_length1);
static gchar** _vala_array_dup18 (gchar** self, int length);
gchar** gitg_remote_get_push_specs (GitgRemote* self, int* result_length1);
static gchar** _vala_array_dup19 (gchar** self, int length);
void gitg_remote_set_push_specs (GitgRemote* self, gchar** value, int value_length1);
static gchar** _vala_array_dup20 (gchar** self, int length);
GitgCredentialsProvider* gitg_remote_get_credentials_provider (GitgRemote* self);
void gitg_remote_set_credentials_provider (GitgRemote* self, GitgCredentialsProvider* value);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
#define GITG_REMOTE_CALLBACKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacksPrivate))
enum  {
	GITG_REMOTE_CALLBACKS_DUMMY_PROPERTY
};
static void gitg_remote_callbacks_real_progress (GgitRemoteCallbacks* base, const gchar* message);
static void gitg_remote_callbacks_real_transfer_progress (GgitRemoteCallbacks* base, GgitTransferProgress* stats);
static void gitg_remote_callbacks_real_update_tips (GgitRemoteCallbacks* base, const gchar* refname, GgitOId* a, GgitOId* b);
static void gitg_remote_callbacks_real_completion (GgitRemoteCallbacks* base, GgitRemoteCompletionType type);
static GgitCred* gitg_remote_callbacks_real_credentials (GgitRemoteCallbacks* base, const gchar* url, const gchar* username_from_url, GgitCredtype allowed_types, GError** error);
static void gitg_remote_callbacks_finalize (GObject * obj);
static void gitg_remote_finalize (GObject * obj);
static void _vala_gitg_remote_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gitg_remote_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType gitg_remote_state_get_type (void) {
	static volatile gsize gitg_remote_state_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_remote_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GITG_REMOTE_STATE_DISCONNECTED, "GITG_REMOTE_STATE_DISCONNECTED", "disconnected"}, {GITG_REMOTE_STATE_CONNECTING, "GITG_REMOTE_STATE_CONNECTING", "connecting"}, {GITG_REMOTE_STATE_CONNECTED, "GITG_REMOTE_STATE_CONNECTED", "connected"}, {GITG_REMOTE_STATE_TRANSFERRING, "GITG_REMOTE_STATE_TRANSFERRING", "transferring"}, {0, NULL, NULL}};
		GType gitg_remote_state_type_id;
		gitg_remote_state_type_id = g_enum_register_static ("GitgRemoteState", values);
		g_once_init_leave (&gitg_remote_state_type_id__volatile, gitg_remote_state_type_id);
	}
	return gitg_remote_state_type_id__volatile;
}


GQuark gitg_remote_error_quark (void) {
	return g_quark_from_static_string ("gitg_remote_error-quark");
}


GgitCred* gitg_credentials_provider_credentials (GitgCredentialsProvider* self, const gchar* url, const gchar* username_from_url, GgitCredtype allowed_types, GError** error) {
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return GITG_CREDENTIALS_PROVIDER_GET_INTERFACE (self)->credentials (self, url, username_from_url, allowed_types, error);
#line 387 "gitg-remote.c"
}


static void gitg_credentials_provider_base_init (GitgCredentialsProviderIface * iface) {
#line 39 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	static gboolean initialized = FALSE;
#line 39 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (!initialized) {
#line 39 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		initialized = TRUE;
#line 398 "gitg-remote.c"
	}
}


GType gitg_credentials_provider_get_type (void) {
	static volatile gsize gitg_credentials_provider_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_credentials_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgCredentialsProviderIface), (GBaseInitFunc) gitg_credentials_provider_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gitg_credentials_provider_type_id;
		gitg_credentials_provider_type_id = g_type_register_static (G_TYPE_INTERFACE, "GitgCredentialsProvider", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gitg_credentials_provider_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gitg_credentials_provider_type_id__volatile, gitg_credentials_provider_type_id);
	}
	return gitg_credentials_provider_type_id__volatile;
}


static void gitg_remote_real_dispose (GObject* base) {
	GitgRemote * self;
	guint _tmp0_ = 0U;
#line 130 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemote*) base;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_reset_transfer_progress_timeout;
#line 132 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 425 "gitg-remote.c"
		guint _tmp1_ = 0U;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = self->priv->d_reset_transfer_progress_timeout;
#line 134 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_source_remove (_tmp1_);
#line 135 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->d_reset_transfer_progress_timeout = (guint) 0;
#line 433 "gitg-remote.c"
	}
#line 138 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (gitg_remote_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote));
#line 437 "gitg-remote.c"
}


static void gitg_remote_do_reset_transfer_progress (GitgRemote* self) {
#line 159 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_reset_transfer_progress_timeout = (guint) 0;
#line 162 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress = 0.0;
#line 163 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_notify ((GObject*) self, "transfer-progress");
#line 450 "gitg-remote.c"
}


static gboolean ___lambda66_ (GitgRemote* self) {
	gboolean result = FALSE;
#line 176 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_do_reset_transfer_progress (self);
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = FALSE;
#line 177 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 462 "gitg-remote.c"
}


static gboolean ____lambda66__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda66_ ((GitgRemote*) self);
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 471 "gitg-remote.c"
}


static void gitg_remote_reset_transfer_progress (GitgRemote* self, gboolean with_delay) {
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_ = FALSE;
#line 166 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 168 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_transfer_progress;
#line 168 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ == ((gdouble) 0)) {
#line 170 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 486 "gitg-remote.c"
	}
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = with_delay;
#line 173 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp1_) {
#line 492 "gitg-remote.c"
		guint _tmp2_ = 0U;
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda66__gsource_func, g_object_ref (self), g_object_unref);
#line 175 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->d_reset_transfer_progress_timeout = _tmp2_;
#line 498 "gitg-remote.c"
	} else {
		guint _tmp3_ = 0U;
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp3_ = self->priv->d_reset_transfer_progress_timeout;
#line 180 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_tmp3_ == ((guint) 0)) {
#line 182 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_remote_do_reset_transfer_progress (self);
#line 507 "gitg-remote.c"
		}
	}
}


static void gitg_remote_update_transfer_progress (GitgRemote* self, GgitTransferProgress* stats) {
	guint total = 0U;
	GgitTransferProgress* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint received = 0U;
	GgitTransferProgress* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint indexed = 0U;
	GgitTransferProgress* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	gboolean _tmp10_ = FALSE;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
#line 186 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (stats != NULL);
#line 188 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = stats;
#line 188 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = ggit_transfer_progress_get_total_objects (_tmp0_);
#line 188 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	total = _tmp1_;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = stats;
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = ggit_transfer_progress_get_received_objects (_tmp2_);
#line 189 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	received = _tmp3_;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = stats;
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp5_ = ggit_transfer_progress_get_indexed_objects (_tmp4_);
#line 190 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	indexed = _tmp5_;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp6_ = received;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp7_ = indexed;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp8_ = total;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp9_ = total;
#line 192 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress = ((gdouble) (_tmp6_ + _tmp7_)) / ((gdouble) (_tmp8_ + _tmp9_));
#line 193 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_notify ((GObject*) self, "transfer-progress");
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp11_ = received;
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp12_ = total;
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp11_ == _tmp12_) {
#line 570 "gitg-remote.c"
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp13_ = indexed;
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp14_ = total;
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp10_ = _tmp13_ == _tmp14_;
#line 579 "gitg-remote.c"
	} else {
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp10_ = FALSE;
#line 583 "gitg-remote.c"
	}
#line 195 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp10_) {
#line 197 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_reset_transfer_progress (self, TRUE);
#line 589 "gitg-remote.c"
	}
}


static void ____lambda68_ (GitgRemote* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 207 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (res != NULL);
#line 598 "gitg-remote.c"
	{
		GAsyncResult* _tmp0_ = NULL;
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = res;
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_disconnect_finish (self, _tmp0_, &_inner_error_);
#line 210 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 607 "gitg-remote.c"
			goto __catch56_g_error;
		}
	}
	goto __finally56;
	__catch56_g_error:
	{
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_clear_error (&_inner_error_);
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_inner_error_ = NULL;
#line 618 "gitg-remote.c"
	}
	__finally56:
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_clear_error (&_inner_error_);
#line 208 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 629 "gitg-remote.c"
	}
}


static void _____lambda68__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 207 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	____lambda68_ ((GitgRemote*) self, source_object, res);
#line 207 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_unref (self);
#line 639 "gitg-remote.c"
}


static void gitg_remote_update_state (GitgRemote* self, gboolean force_disconnect) {
	gboolean _tmp0_ = FALSE;
#line 201 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = ggit_remote_get_connected ((GgitRemote*) self);
#line 203 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_) {
#line 651 "gitg-remote.c"
		gboolean _tmp1_ = FALSE;
#line 205 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = force_disconnect;
#line 205 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_tmp1_) {
#line 207 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_remote_disconnect (self, _____lambda68__gasync_ready_callback, g_object_ref (self));
#line 659 "gitg-remote.c"
		} else {
#line 216 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_remote_set_state (self, GITG_REMOTE_STATE_CONNECTED);
#line 663 "gitg-remote.c"
		}
	} else {
#line 221 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_set_state (self, GITG_REMOTE_STATE_DISCONNECTED);
#line 668 "gitg-remote.c"
	}
}


static void gitg_remote_connect_data_free (gpointer _data) {
	GitgRemoteConnectData* _data_;
	_data_ = _data;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->callbacks);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteConnectData, _data_);
#line 682 "gitg-remote.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return self ? g_object_ref (self) : NULL;
#line 689 "gitg-remote.c"
}


void gitg_remote_connect (GitgRemote* self, GgitDirection direction, GgitRemoteCallbacks* callbacks, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteConnectData* _data_;
	GitgRemote* _tmp0_ = NULL;
	GgitDirection _tmp1_ = 0;
	GgitRemoteCallbacks* _tmp2_ = NULL;
	GgitRemoteCallbacks* _tmp3_ = NULL;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteConnectData);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_connect);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_connect_data_free);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = direction;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->direction = _tmp1_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = callbacks;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->callbacks);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->callbacks = _tmp3_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_connect_co (_data_);
#line 723 "gitg-remote.c"
}


void gitg_remote_connect_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteConnectData* _data_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 733 "gitg-remote.c"
	}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 737 "gitg-remote.c"
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return _data16_;
#line 746 "gitg-remote.c"
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 755 "gitg-remote.c"
		GitgRemote* self;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self = _data16_->self;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (self);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_slice_free (Block16Data, _data16_);
#line 763 "gitg-remote.c"
	}
}


static void _gitg_remote_update_transfer_progress_gitg_remote_callbacks_transfer_progress (GgitTransferProgress* stats, gpointer self) {
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_update_transfer_progress ((GitgRemote*) self, stats);
#line 771 "gitg-remote.c"
}


static void ____lambda69_ (Block16Data* _data16_, GError** error) {
	GitgRemote* self;
	GgitDirection _tmp0_ = 0;
	GitgRemoteCallbacks* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = _data16_->self;
#line 254 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _data16_->direction;
#line 254 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = self->priv->d_callbacks;
#line 254 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	ggit_remote_connect (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), _tmp0_, (GgitRemoteCallbacks*) _tmp1_, NULL, &_inner_error_);
#line 254 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 254 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_propagate_error (error, _inner_error_);
#line 254 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 794 "gitg-remote.c"
	}
}


static void _____lambda69__gitg_async_thread_func (gpointer self, GError** error) {
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	____lambda69_ (self, error);
#line 802 "gitg-remote.c"
}


static void gitg_remote_connect_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteConnectData* _data_;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_connect_co (_data_);
#line 816 "gitg-remote.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 272 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return self ? g_error_copy (self) : NULL;
#line 823 "gitg-remote.c"
}


static gboolean gitg_remote_connect_co (GitgRemoteConnectData* _data_) {
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 832 "gitg-remote.c"
		goto _state_0;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 836 "gitg-remote.c"
		goto _state_1;
		default:
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 841 "gitg-remote.c"
	}
	_state_0:
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data16_ = g_slice_new0 (Block16Data);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data16_->_ref_count_ = 1;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data16_->self = g_object_ref (_data_->self);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = 0;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = _data_->direction;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data16_->direction = _data_->_tmp0_;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data16_->_async_data_ = _data_;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = FALSE;
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = ggit_remote_get_connected ((GgitRemote*) _data_->self);
#line 227 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_data_->_tmp1_) {
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = 0;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = gitg_remote_get_state (_data_->self);
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = 0;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = _data_->_tmp2_;
#line 229 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_tmp3_ != GITG_REMOTE_STATE_CONNECTED) {
#line 231 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_CONNECTED);
#line 876 "gitg-remote.c"
		}
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = NULL;
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_CONNECTED, "already connected");
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = _data_->_tmp4_;
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		block16_data_unref (_data_->_data16_);
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_data16_ = NULL;
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 896 "gitg-remote.c"
		} else {
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 900 "gitg-remote.c"
		}
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 234 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 906 "gitg-remote.c"
	} else {
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = 0;
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = gitg_remote_get_state (_data_->self);
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp6_ = 0;
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 236 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_tmp6_ == GITG_REMOTE_STATE_CONNECTING) {
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp7_ = NULL;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp7_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_CONNECTING, "already connecting");
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_inner_error_ = _data_->_tmp7_;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_error_free (_data_->_inner_error_);
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			block16_data_unref (_data_->_data16_);
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_data16_ = NULL;
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			if (_data_->_state_ == 0) {
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 936 "gitg-remote.c"
			} else {
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 940 "gitg-remote.c"
			}
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_object_unref (_data_->_async_result);
#line 238 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			return FALSE;
#line 946 "gitg-remote.c"
		} else {
#line 242 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_remote_reset_transfer_progress (_data_->self, FALSE);
#line 950 "gitg-remote.c"
		}
	}
#line 245 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_CONNECTING);
#line 247 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	while (TRUE) {
#line 957 "gitg-remote.c"
		{
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp8_ = NULL;
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp8_ = _data_->callbacks;
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp9_ = NULL;
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp9_ = gitg_remote_callbacks_new (_data_->self, _data_->_tmp8_, _gitg_remote_update_transfer_progress_gitg_remote_callbacks_transfer_progress, g_object_ref (_data_->self), g_object_unref);
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_object_unref0 (_data_->self->priv->d_callbacks);
#line 251 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->self->priv->d_callbacks = _data_->_tmp9_;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_state_ = 1;
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_async_thread (_____lambda69__gitg_async_thread_func, _data_->_data16_, gitg_remote_connect_ready, _data_);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			return FALSE;
#line 977 "gitg-remote.c"
			_state_1:
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 253 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 983 "gitg-remote.c"
				goto __catch57_g_error;
			}
		}
		goto __finally57;
		__catch57_g_error:
		{
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->e = _data_->_inner_error_;
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_inner_error_ = NULL;
#line 259 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_object_unref0 (_data_->self->priv->d_callbacks);
#line 259 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->self->priv->d_callbacks = NULL;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp11_ = NULL;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp11_ = _data_->e;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp12_ = NULL;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp12_ = _data_->_tmp11_->message;
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			if (g_strcmp0 (_data_->_tmp12_, "Unexpected HTTP status code: 401") == 0) {
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp10_ = TRUE;
#line 1010 "gitg-remote.c"
			} else {
#line 265 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp13_ = NULL;
#line 265 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp13_ = _data_->e;
#line 265 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp14_ = NULL;
#line 265 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp14_ = _data_->_tmp13_->message;
#line 265 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp10_ = g_strcmp0 (_data_->_tmp14_, "error authenticating: Username/PublicKey combination invalid") == 0;
#line 1022 "gitg-remote.c"
			}
#line 264 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			if (_data_->_tmp10_) {
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_g_error_free0 (_data_->e);
#line 267 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				continue;
#line 1030 "gitg-remote.c"
			} else {
#line 271 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				gitg_remote_update_state (_data_->self, FALSE);
#line 272 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp15_ = NULL;
#line 272 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp15_ = _data_->e;
#line 272 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp16_ = NULL;
#line 272 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_tmp16_ = _g_error_copy0 (_data_->_tmp15_);
#line 272 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_data_->_inner_error_ = _data_->_tmp16_;
#line 272 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				_g_error_free0 (_data_->e);
#line 1046 "gitg-remote.c"
				goto __finally57;
			}
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_error_free0 (_data_->e);
#line 1051 "gitg-remote.c"
		}
		__finally57:
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_error_free (_data_->_inner_error_);
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			block16_data_unref (_data_->_data16_);
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_data16_ = NULL;
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			if (_data_->_state_ == 0) {
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1068 "gitg-remote.c"
			} else {
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1072 "gitg-remote.c"
			}
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_object_unref (_data_->_async_result);
#line 249 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			return FALSE;
#line 1078 "gitg-remote.c"
		}
#line 276 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 1082 "gitg-remote.c"
	}
#line 279 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_update_state (_data_->self, FALSE);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	block16_data_unref (_data_->_data16_);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data16_ = NULL;
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1094 "gitg-remote.c"
	} else {
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1098 "gitg-remote.c"
	}
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 225 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1104 "gitg-remote.c"
}


static void gitg_remote_disconnect_data_free (gpointer _data) {
	GitgRemoteDisconnectData* _data_;
	_data_ = _data;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteDisconnectData, _data_);
#line 1115 "gitg-remote.c"
}


void gitg_remote_disconnect (GitgRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteDisconnectData* _data_;
	GitgRemote* _tmp0_ = NULL;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteDisconnectData);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_disconnect);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_disconnect_data_free);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_disconnect_co (_data_);
#line 1134 "gitg-remote.c"
}


void gitg_remote_disconnect_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteDisconnectData* _data_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 1144 "gitg-remote.c"
	}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1148 "gitg-remote.c"
}


static void ___lambda67_ (GitgRemote* self, GError** error) {
#line 297 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	ggit_remote_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote));
#line 1155 "gitg-remote.c"
}


static void ____lambda67__gitg_async_thread_func (gpointer self, GError** error) {
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	___lambda67_ ((GitgRemote*) self, error);
#line 1162 "gitg-remote.c"
}


static void gitg_remote_disconnect_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteDisconnectData* _data_;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_disconnect_co (_data_);
#line 1176 "gitg-remote.c"
}


static gboolean gitg_remote_disconnect_co (GitgRemoteDisconnectData* _data_) {
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 1185 "gitg-remote.c"
		goto _state_0;
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 1189 "gitg-remote.c"
		goto _state_1;
		default:
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 1194 "gitg-remote.c"
	}
	_state_0:
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = FALSE;
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = ggit_remote_get_connected ((GgitRemote*) _data_->self);
#line 284 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (!_data_->_tmp0_) {
#line 286 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp1_ = 0;
#line 286 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp1_ = gitg_remote_get_state (_data_->self);
#line 286 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = 0;
#line 286 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 286 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_tmp2_ != GITG_REMOTE_STATE_DISCONNECTED) {
#line 288 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_DISCONNECTED);
#line 1215 "gitg-remote.c"
		}
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = NULL;
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = g_error_new_literal (GITG_REMOTE_ERROR, GITG_REMOTE_ERROR_ALREADY_DISCONNECTED, "already disconnected");
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = _data_->_tmp3_;
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1231 "gitg-remote.c"
		} else {
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1235 "gitg-remote.c"
		}
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 291 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1241 "gitg-remote.c"
	}
	{
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_state_ = 1;
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_async_thread (____lambda67__gitg_async_thread_func, _data_->self, gitg_remote_disconnect_ready, _data_);
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1250 "gitg-remote.c"
		_state_1:
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 296 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1256 "gitg-remote.c"
			goto __catch58_g_error;
		}
	}
	goto __finally58;
	__catch58_g_error:
	{
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->e = _data_->_inner_error_;
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = NULL;
#line 302 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_update_state (_data_->self, FALSE);
#line 303 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_reset_transfer_progress (_data_->self, TRUE);
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = NULL;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = _data_->e;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = NULL;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = _data_->_tmp5_;
#line 305 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_error_free0 (_data_->e);
#line 1283 "gitg-remote.c"
		goto __finally58;
	}
	__finally58:
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1297 "gitg-remote.c"
		} else {
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1301 "gitg-remote.c"
		}
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 294 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1307 "gitg-remote.c"
	}
#line 308 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_update_state (_data_->self, FALSE);
#line 309 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_reset_transfer_progress (_data_->self, TRUE);
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1317 "gitg-remote.c"
	} else {
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1321 "gitg-remote.c"
	}
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 282 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1327 "gitg-remote.c"
}


static void gitg_remote_download_intern_data_free (gpointer _data) {
	GitgRemoteDownloadInternData* _data_;
	_data_ = _data;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->callbacks);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteDownloadInternData, _data_);
#line 1340 "gitg-remote.c"
}


static void gitg_remote_download_intern (GitgRemote* self, const gchar* message, GgitRemoteCallbacks* callbacks, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteDownloadInternData* _data_;
	GitgRemote* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GgitRemoteCallbacks* _tmp3_ = NULL;
	GgitRemoteCallbacks* _tmp4_ = NULL;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteDownloadInternData);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_download_intern);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_download_intern_data_free);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = message;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->message);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->message = _tmp2_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = callbacks;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->callbacks);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->callbacks = _tmp4_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern_co (_data_);
#line 1379 "gitg-remote.c"
}


static void gitg_remote_download_intern_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteDownloadInternData* _data_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 1389 "gitg-remote.c"
	}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1393 "gitg-remote.c"
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return _data17_;
#line 1402 "gitg-remote.c"
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 1411 "gitg-remote.c"
		GitgRemote* self;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self = _data17_->self;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_free0 (_data17_->message);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (self);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_slice_free (Block17Data, _data17_);
#line 1421 "gitg-remote.c"
	}
}


static void gitg_remote_download_intern_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteDownloadInternData* _data_;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern_co (_data_);
#line 1436 "gitg-remote.c"
}


static void _vala_GgitFetchOptions_free (GgitFetchOptions* self) {
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_boxed_free (ggit_fetch_options_get_type (), self);
#line 1443 "gitg-remote.c"
}


static void ___lambda70_ (Block17Data* _data17_, GError** error) {
	GitgRemote* self;
	GgitFetchOptions* options = NULL;
	GgitFetchOptions* _tmp0_ = NULL;
	GgitFetchOptions* _tmp1_ = NULL;
	GitgRemoteCallbacks* _tmp2_ = NULL;
	GgitFetchOptions* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = _data17_->self;
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = ggit_fetch_options_new ();
#line 328 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	options = _tmp0_;
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = options;
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = self->priv->d_callbacks;
#line 329 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	ggit_fetch_options_set_remote_callbacks (_tmp1_, (GgitRemoteCallbacks*) _tmp2_);
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = options;
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	ggit_remote_download (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), NULL, _tmp3_, &_inner_error_);
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_propagate_error (error, _inner_error_);
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		__vala_GgitFetchOptions_free0 (options);
#line 331 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 1480 "gitg-remote.c"
	}
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = _data17_->message;
#line 333 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp4_ != NULL) {
#line 1486 "gitg-remote.c"
		GitgRemoteCallbacks* _tmp5_ = NULL;
		GgitFetchOptions* _tmp6_ = NULL;
		GgitRemoteDownloadTagsType _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp5_ = self->priv->d_callbacks;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp6_ = options;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp7_ = ggit_fetch_options_get_download_tags (_tmp6_);
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp8_ = _data17_->message;
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		ggit_remote_update_tips (G_TYPE_CHECK_INSTANCE_CAST (self, ggit_remote_get_type (), GgitRemote), (GgitRemoteCallbacks*) _tmp5_, TRUE, _tmp7_, _tmp8_, &_inner_error_);
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_propagate_error (error, _inner_error_);
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			__vala_GgitFetchOptions_free0 (options);
#line 335 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			return;
#line 1509 "gitg-remote.c"
		}
	}
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	__vala_GgitFetchOptions_free0 (options);
#line 1514 "gitg-remote.c"
}


static void ____lambda70__gitg_async_thread_func (gpointer self, GError** error) {
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	___lambda70_ (self, error);
#line 1521 "gitg-remote.c"
}


static gboolean gitg_remote_download_intern_co (GitgRemoteDownloadInternData* _data_) {
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 1530 "gitg-remote.c"
		goto _state_0;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 1534 "gitg-remote.c"
		goto _state_1;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 2:
#line 1538 "gitg-remote.c"
		goto _state_2;
		default:
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 1543 "gitg-remote.c"
	}
	_state_0:
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data17_ = g_slice_new0 (Block17Data);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data17_->_ref_count_ = 1;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data17_->self = g_object_ref (_data_->self);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = NULL;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = _data_->message;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->_data17_->message);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data17_->message = _data_->_tmp0_;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data17_->_async_data_ = _data_;
#line 314 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->dis = FALSE;
#line 316 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = FALSE;
#line 316 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = ggit_remote_get_connected ((GgitRemote*) _data_->self);
#line 316 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (!_data_->_tmp1_) {
#line 318 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->dis = TRUE;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = NULL;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp2_ = _data_->callbacks;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_state_ = 1;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_connect (_data_->self, GGIT_DIRECTION_FETCH, _data_->_tmp2_, gitg_remote_download_intern_ready, _data_);
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1582 "gitg-remote.c"
		_state_1:
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_connect_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_error_free (_data_->_inner_error_);
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			block17_data_unref (_data_->_data17_);
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_data17_ = NULL;
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			if (_data_->_state_ == 0) {
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1600 "gitg-remote.c"
			} else {
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 1604 "gitg-remote.c"
			}
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_object_unref (_data_->_async_result);
#line 319 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			return FALSE;
#line 1610 "gitg-remote.c"
		}
	}
#line 322 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_set_state (_data_->self, GITG_REMOTE_STATE_TRANSFERRING);
#line 323 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_reset_transfer_progress (_data_->self, FALSE);
#line 1617 "gitg-remote.c"
	{
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_state_ = 2;
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_async_thread (____lambda70__gitg_async_thread_func, _data_->_data17_, gitg_remote_download_intern_ready, _data_);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1625 "gitg-remote.c"
		_state_2:
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_async_thread_finish (_data_->_res_, &_data_->_inner_error_);
#line 327 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1631 "gitg-remote.c"
			goto __catch59_g_error;
		}
	}
	goto __finally59;
	__catch59_g_error:
	{
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->e = _data_->_inner_error_;
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = NULL;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = FALSE;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = _data_->dis;
#line 341 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_update_state (_data_->self, _data_->_tmp3_);
#line 342 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_reset_transfer_progress (_data_->self, TRUE);
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = NULL;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = _data_->e;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = NULL;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_inner_error_ = _data_->_tmp5_;
#line 343 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_error_free0 (_data_->e);
#line 1662 "gitg-remote.c"
		goto __finally59;
	}
	__finally59:
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		block17_data_unref (_data_->_data17_);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_data17_ = NULL;
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1680 "gitg-remote.c"
		} else {
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1684 "gitg-remote.c"
		}
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 325 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1690 "gitg-remote.c"
	}
#line 346 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp6_ = FALSE;
#line 346 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp6_ = _data_->dis;
#line 346 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_update_state (_data_->self, _data_->_tmp6_);
#line 347 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_reset_transfer_progress (_data_->self, TRUE);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	block17_data_unref (_data_->_data17_);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_data17_ = NULL;
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1708 "gitg-remote.c"
	} else {
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1712 "gitg-remote.c"
	}
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 312 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1718 "gitg-remote.c"
}


static void gitg_remote_download_data_free (gpointer _data) {
	GitgRemoteDownloadData* _data_;
	_data_ = _data;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->callbacks);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteDownloadData, _data_);
#line 1731 "gitg-remote.c"
}


void gitg_remote_download (GitgRemote* self, GgitRemoteCallbacks* callbacks, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteDownloadData* _data_;
	GitgRemote* _tmp0_ = NULL;
	GgitRemoteCallbacks* _tmp1_ = NULL;
	GgitRemoteCallbacks* _tmp2_ = NULL;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteDownloadData);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_download);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_download_data_free);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = callbacks;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->callbacks);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->callbacks = _tmp2_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_co (_data_);
#line 1760 "gitg-remote.c"
}


void gitg_remote_download_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteDownloadData* _data_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 1770 "gitg-remote.c"
	}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1774 "gitg-remote.c"
}


static void gitg_remote_download_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteDownloadData* _data_;
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_co (_data_);
#line 1788 "gitg-remote.c"
}


static gboolean gitg_remote_download_co (GitgRemoteDownloadData* _data_) {
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 1797 "gitg-remote.c"
		goto _state_0;
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 1801 "gitg-remote.c"
		goto _state_1;
		default:
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 1806 "gitg-remote.c"
	}
	_state_0:
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = NULL;
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = _data_->callbacks;
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_state_ = 1;
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern (_data_->self, NULL, _data_->_tmp0_, gitg_remote_download_ready, _data_);
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1819 "gitg-remote.c"
	_state_1:
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1833 "gitg-remote.c"
		} else {
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1837 "gitg-remote.c"
		}
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 352 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 1843 "gitg-remote.c"
	}
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1849 "gitg-remote.c"
	} else {
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1853 "gitg-remote.c"
	}
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 350 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 1859 "gitg-remote.c"
}


static void gitg_remote_fetch_data_free (gpointer _data) {
	GitgRemoteFetchData* _data_;
	_data_ = _data;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->message);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->callbacks);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_slice_free (GitgRemoteFetchData, _data_);
#line 1874 "gitg-remote.c"
}


void gitg_remote_fetch (GitgRemote* self, const gchar* message, GgitRemoteCallbacks* callbacks, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GitgRemoteFetchData* _data_;
	GitgRemote* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GgitRemoteCallbacks* _tmp3_ = NULL;
	GgitRemoteCallbacks* _tmp4_ = NULL;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_slice_new0 (GitgRemoteFetchData);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gitg_remote_fetch);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gitg_remote_fetch_data_free);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->self = _tmp0_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = message;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->message);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->message = _tmp2_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = callbacks;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (_data_->callbacks);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->callbacks = _tmp4_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_fetch_co (_data_);
#line 1913 "gitg-remote.c"
}


void gitg_remote_fetch_finish (GitgRemote* self, GAsyncResult* _res_, GError** error) {
	GitgRemoteFetchData* _data_;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return;
#line 1923 "gitg-remote.c"
	}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1927 "gitg-remote.c"
}


static void gitg_remote_fetch_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GitgRemoteFetchData* _data_;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_ = _user_data_;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_source_object_ = source_object;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_res_ = _res_;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_fetch_co (_data_);
#line 1941 "gitg-remote.c"
}


static gboolean gitg_remote_fetch_co (GitgRemoteFetchData* _data_) {
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	switch (_data_->_state_) {
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 0:
#line 1950 "gitg-remote.c"
		goto _state_0;
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case 1:
#line 1954 "gitg-remote.c"
		goto _state_1;
		default:
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_assert_not_reached ();
#line 1959 "gitg-remote.c"
	}
	_state_0:
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = NULL;
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp0_ = _data_->message;
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = NULL;
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
#line 357 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->msg = _data_->_tmp1_;
#line 359 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp2_ = NULL;
#line 359 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp2_ = _data_->msg;
#line 359 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_data_->_tmp2_ == NULL) {
#line 361 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = NULL;
#line 361 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp3_ = ggit_remote_get_name ((GgitRemote*) _data_->self);
#line 361 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = NULL;
#line 361 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 361 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->name = _data_->_tmp4_;
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = NULL;
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp5_ = _data_->name;
#line 363 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_tmp5_ == NULL) {
#line 365 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp6_ = NULL;
#line 365 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp6_ = ggit_remote_get_url ((GgitRemote*) _data_->self);
#line 365 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp7_ = NULL;
#line 365 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
#line 365 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_free0 (_data_->name);
#line 365 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->name = _data_->_tmp7_;
#line 2006 "gitg-remote.c"
		}
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp8_ = NULL;
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_data_->_tmp8_ = _data_->name;
#line 368 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_tmp8_ != NULL) {
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp9_ = NULL;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp9_ = _data_->name;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp10_ = NULL;
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp10_ = g_strconcat ("fetch: ", _data_->_tmp9_, NULL);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_free0 (_data_->msg);
#line 370 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->msg = _data_->_tmp10_;
#line 2026 "gitg-remote.c"
		} else {
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp11_ = NULL;
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->_tmp11_ = g_strdup ("");
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_free0 (_data_->msg);
#line 374 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_data_->msg = _data_->_tmp11_;
#line 2036 "gitg-remote.c"
		}
#line 359 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_free0 (_data_->name);
#line 2040 "gitg-remote.c"
	}
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp12_ = NULL;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp12_ = _data_->msg;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp13_ = NULL;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_tmp13_ = _data_->callbacks;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_data_->_state_ = 1;
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern (_data_->self, _data_->_tmp12_, _data_->_tmp13_, gitg_remote_fetch_ready, _data_);
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 2056 "gitg-remote.c"
	_state_1:
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_download_intern_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_error_free (_data_->_inner_error_);
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_free0 (_data_->msg);
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_data_->_state_ == 0) {
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2072 "gitg-remote.c"
		} else {
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2076 "gitg-remote.c"
		}
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_unref (_data_->_async_result);
#line 378 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return FALSE;
#line 2082 "gitg-remote.c"
	}
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_free0 (_data_->msg);
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_data_->_state_ == 0) {
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2090 "gitg-remote.c"
	} else {
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2094 "gitg-remote.c"
	}
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_unref (_data_->_async_result);
#line 355 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return FALSE;
#line 2100 "gitg-remote.c"
}


GitgRemote* gitg_remote_construct (GType object_type) {
	GitgRemote * self = NULL;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemote*) g_object_new (object_type, NULL);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return self;
#line 2110 "gitg-remote.c"
}


GitgRemote* gitg_remote_new (void) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return gitg_remote_construct (GITG_TYPE_REMOTE);
#line 2117 "gitg-remote.c"
}


gdouble gitg_remote_get_transfer_progress (GitgRemote* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_transfer_progress;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = _tmp0_;
#line 143 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 2132 "gitg-remote.c"
}


GitgRemoteState gitg_remote_get_state (GitgRemote* self) {
	GitgRemoteState result;
	GitgRemoteState _tmp0_ = 0;
#line 148 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 148 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_state;
#line 148 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = _tmp0_;
#line 148 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 2147 "gitg-remote.c"
}


static void gitg_remote_set_state (GitgRemote* self, GitgRemoteState value) {
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (gitg_remote_get_state (self) != value) {
#line 2156 "gitg-remote.c"
		GitgRemoteState _tmp0_ = 0;
		GitgRemoteState _tmp1_ = 0;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = self->priv->d_state;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = value;
#line 151 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (_tmp0_ != _tmp1_) {
#line 2165 "gitg-remote.c"
			GitgRemoteState _tmp2_ = 0;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_tmp2_ = value;
#line 153 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			self->priv->d_state = _tmp2_;
#line 154 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_object_notify ((GObject*) self, "state");
#line 2173 "gitg-remote.c"
		}
#line 149 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_notify ((GObject *) self, "state");
#line 2177 "gitg-remote.c"
	}
}


static gchar** _vala_array_dup17 (gchar** self, int length) {
	gchar** result;
	int i;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = g_new0 (gchar*, length + 1);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	for (i = 0; i < length; i++) {
#line 2189 "gitg-remote.c"
		gchar* _tmp0_ = NULL;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = g_strdup (self[i]);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result[i] = _tmp0_;
#line 2195 "gitg-remote.c"
	}
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 2199 "gitg-remote.c"
}


gchar** gitg_remote_get_fetch_specs (GitgRemote* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GError * _inner_error_ = NULL;
#line 383 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 385 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_fetch_specs;
#line 385 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0__length1 = self->priv->d_fetch_specs_length1;
#line 385 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ != NULL) {
#line 2216 "gitg-remote.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = self->priv->d_fetch_specs;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1__length1 = self->priv->d_fetch_specs_length1;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup17 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp2__length1 = _tmp1__length1;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp3_ = _tmp2_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp3__length1 = _tmp2__length1;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (result_length1) {
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			*result_length1 = _tmp3__length1;
#line 2239 "gitg-remote.c"
		}
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result = _tmp3_;
#line 387 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return result;
#line 2245 "gitg-remote.c"
	}
	{
		gchar** _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint _tmp4__length1 = 0;
		gint __tmp4__size_ = 0;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp6_ = _tmp5_ = ggit_remote_get_fetch_specs ((GgitRemote*) self, &_inner_error_);
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4_ = _tmp6_;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4__length1 = _vala_array_length (_tmp5_);
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		__tmp4__size_ = _tmp4__length1;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2267 "gitg-remote.c"
			goto __catch60_g_error;
		}
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp7_ = _tmp4_;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp7__length1 = _tmp4__length1;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4_ = NULL;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4__length1 = 0;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp8_ = _tmp7_;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp8__length1 = _tmp7__length1;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (result_length1) {
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			*result_length1 = _tmp8__length1;
#line 2286 "gitg-remote.c"
		}
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result = _tmp8_;
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 392 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return result;
#line 2294 "gitg-remote.c"
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError* e = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		e = _inner_error_;
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_inner_error_ = NULL;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp9_ = NULL;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp9__length1 = 0;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (result_length1) {
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			*result_length1 = _tmp9__length1;
#line 2314 "gitg-remote.c"
		}
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result = _tmp9_;
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_error_free0 (e);
#line 396 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return result;
#line 2322 "gitg-remote.c"
	}
	__finally60:
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_clear_error (&_inner_error_);
#line 390 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return NULL;
#line 2331 "gitg-remote.c"
}


static gchar** _vala_array_dup18 (gchar** self, int length) {
	gchar** result;
	int i;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = g_new0 (gchar*, length + 1);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	for (i = 0; i < length; i++) {
#line 2342 "gitg-remote.c"
		gchar* _tmp0_ = NULL;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = g_strdup (self[i]);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result[i] = _tmp0_;
#line 2348 "gitg-remote.c"
	}
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 2352 "gitg-remote.c"
}


void gitg_remote_set_fetch_specs (GitgRemote* self, gchar** value, int value_length1) {
	int old_value_length;
#line 400 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 400 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (gitg_remote_get_fetch_specs (self, &old_value_length) != value) {
#line 2362 "gitg-remote.c"
		gchar** _tmp0_ = NULL;
		gint _tmp0__length1 = 0;
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = value;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0__length1 = value_length1;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup18 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1__length1 = _tmp0__length1;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->d_fetch_specs = (_vala_array_free (self->priv->d_fetch_specs, self->priv->d_fetch_specs_length1, (GDestroyNotify) g_free), NULL);
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->d_fetch_specs = _tmp1_;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->d_fetch_specs_length1 = _tmp1__length1;
#line 402 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->_d_fetch_specs_size_ = self->priv->d_fetch_specs_length1;
#line 400 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_notify ((GObject *) self, "fetch-specs");
#line 2385 "gitg-remote.c"
	}
}


static gchar** _vala_array_dup19 (gchar** self, int length) {
	gchar** result;
	int i;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = g_new0 (gchar*, length + 1);
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	for (i = 0; i < length; i++) {
#line 2397 "gitg-remote.c"
		gchar* _tmp0_ = NULL;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = g_strdup (self[i]);
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result[i] = _tmp0_;
#line 2403 "gitg-remote.c"
	}
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 2407 "gitg-remote.c"
}


gchar** gitg_remote_get_push_specs (GitgRemote* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GError * _inner_error_ = NULL;
#line 408 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_push_specs;
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0__length1 = self->priv->d_push_specs_length1;
#line 410 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ != NULL) {
#line 2424 "gitg-remote.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = self->priv->d_push_specs;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1__length1 = self->priv->d_push_specs_length1;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup19 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp2__length1 = _tmp1__length1;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp3_ = _tmp2_;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp3__length1 = _tmp2__length1;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (result_length1) {
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			*result_length1 = _tmp3__length1;
#line 2447 "gitg-remote.c"
		}
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result = _tmp3_;
#line 412 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return result;
#line 2453 "gitg-remote.c"
	}
	{
		gchar** _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint _tmp4__length1 = 0;
		gint __tmp4__size_ = 0;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp6_ = _tmp5_ = ggit_remote_get_push_specs ((GgitRemote*) self, &_inner_error_);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4_ = _tmp6_;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4__length1 = _vala_array_length (_tmp5_);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		__tmp4__size_ = _tmp4__length1;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2475 "gitg-remote.c"
			goto __catch61_g_error;
		}
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp7_ = _tmp4_;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp7__length1 = _tmp4__length1;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4_ = NULL;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4__length1 = 0;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp8_ = _tmp7_;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp8__length1 = _tmp7__length1;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (result_length1) {
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			*result_length1 = _tmp8__length1;
#line 2494 "gitg-remote.c"
		}
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result = _tmp8_;
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
#line 417 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return result;
#line 2502 "gitg-remote.c"
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* e = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		e = _inner_error_;
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_inner_error_ = NULL;
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp9_ = NULL;
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp9__length1 = 0;
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (result_length1) {
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			*result_length1 = _tmp9__length1;
#line 2522 "gitg-remote.c"
		}
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result = _tmp9_;
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_error_free0 (e);
#line 421 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		return result;
#line 2530 "gitg-remote.c"
	}
	__finally61:
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_clear_error (&_inner_error_);
#line 415 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return NULL;
#line 2539 "gitg-remote.c"
}


static gchar** _vala_array_dup20 (gchar** self, int length) {
	gchar** result;
	int i;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = g_new0 (gchar*, length + 1);
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	for (i = 0; i < length; i++) {
#line 2550 "gitg-remote.c"
		gchar* _tmp0_ = NULL;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = g_strdup (self[i]);
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		result[i] = _tmp0_;
#line 2556 "gitg-remote.c"
	}
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 2560 "gitg-remote.c"
}


void gitg_remote_set_push_specs (GitgRemote* self, gchar** value, int value_length1) {
	int old_value_length;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (gitg_remote_get_push_specs (self, &old_value_length) != value) {
#line 2570 "gitg-remote.c"
		gchar** _tmp0_ = NULL;
		gint _tmp0__length1 = 0;
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = value;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0__length1 = value_length1;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup20 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1__length1 = _tmp0__length1;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->d_push_specs = (_vala_array_free (self->priv->d_push_specs, self->priv->d_push_specs_length1, (GDestroyNotify) g_free), NULL);
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->d_push_specs = _tmp1_;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->d_push_specs_length1 = _tmp1__length1;
#line 427 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->_d_push_specs_size_ = self->priv->d_push_specs_length1;
#line 425 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_notify ((GObject *) self, "push-specs");
#line 2593 "gitg-remote.c"
	}
}


GitgCredentialsProvider* gitg_remote_get_credentials_provider (GitgRemote* self) {
	GitgCredentialsProvider* result;
	GitgCredentialsProvider* _tmp0_ = NULL;
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->_credentials_provider;
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = _tmp0_;
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 2609 "gitg-remote.c"
}


void gitg_remote_set_credentials_provider (GitgRemote* self, GitgCredentialsProvider* value) {
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (self != NULL);
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (gitg_remote_get_credentials_provider (self) != value) {
#line 2618 "gitg-remote.c"
		GitgCredentialsProvider* _tmp0_ = NULL;
		GitgCredentialsProvider* _tmp1_ = NULL;
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp0_ = value;
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (self->priv->_credentials_provider);
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		self->priv->_credentials_provider = _tmp1_;
#line 433 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_object_notify ((GObject *) self, "credentials-provider");
#line 2631 "gitg-remote.c"
	}
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (n_param_values == 4);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		data1 = closure->data;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		data2 = param_values->data[0].v_pointer;
#line 2651 "gitg-remote.c"
	} else {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		data1 = param_values->data[0].v_pointer;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		data2 = closure->data;
#line 2657 "gitg-remote.c"
	}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	callback = (GMarshalFunc_VOID__STRING_BOXED_BOXED) (marshal_data ? marshal_data : cc->callback);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_boxed (param_values + 3), data2);
#line 2663 "gitg-remote.c"
}


static GitgRemoteCallbacks* gitg_remote_callbacks_construct (GType object_type, GitgRemote* remote, GgitRemoteCallbacks* proxy, GitgRemoteCallbacksTransferProgress transfer_progress, void* transfer_progress_target, GDestroyNotify transfer_progress_target_destroy_notify) {
	GitgRemoteCallbacks * self = NULL;
	GitgRemote* _tmp0_ = NULL;
	GitgRemote* _tmp1_ = NULL;
	GgitRemoteCallbacks* _tmp2_ = NULL;
	GgitRemoteCallbacks* _tmp3_ = NULL;
	GitgRemoteCallbacksTransferProgress _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	GDestroyNotify _tmp4__target_destroy_notify = NULL;
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (remote != NULL, NULL);
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemoteCallbacks*) g_object_new (object_type, NULL);
#line 56 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = remote;
#line 56 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (self->priv->d_remote);
#line 56 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_remote = _tmp1_;
#line 57 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = proxy;
#line 57 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 57 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (self->priv->d_proxy);
#line 57 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_proxy = _tmp3_;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = transfer_progress;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4__target = transfer_progress_target;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4__target_destroy_notify = transfer_progress_target_destroy_notify;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	transfer_progress_target_destroy_notify = NULL;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	(self->priv->d_transfer_progress_target_destroy_notify == NULL) ? NULL : (self->priv->d_transfer_progress_target_destroy_notify (self->priv->d_transfer_progress_target), NULL);
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress = NULL;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress_target = NULL;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress_target_destroy_notify = NULL;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress = _tmp4_;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress_target = _tmp4__target;
#line 58 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress_target_destroy_notify = _tmp4__target_destroy_notify;
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	(transfer_progress_target_destroy_notify == NULL) ? NULL : (transfer_progress_target_destroy_notify (transfer_progress_target), NULL);
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	transfer_progress = NULL;
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	transfer_progress_target = NULL;
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	transfer_progress_target_destroy_notify = NULL;
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return self;
#line 2728 "gitg-remote.c"
}


static GitgRemoteCallbacks* gitg_remote_callbacks_new (GitgRemote* remote, GgitRemoteCallbacks* proxy, GitgRemoteCallbacksTransferProgress transfer_progress, void* transfer_progress_target, GDestroyNotify transfer_progress_target_destroy_notify) {
#line 54 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return gitg_remote_callbacks_construct (GITG_REMOTE_TYPE_CALLBACKS, remote, proxy, transfer_progress, transfer_progress_target, transfer_progress_target_destroy_notify);
#line 2735 "gitg-remote.c"
}


static void gitg_remote_callbacks_real_progress (GgitRemoteCallbacks* base, const gchar* message) {
	GitgRemoteCallbacks * self;
	GgitRemoteCallbacks* _tmp0_ = NULL;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemoteCallbacks*) base;
#line 61 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (message != NULL);
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_proxy;
#line 63 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ != NULL) {
#line 2750 "gitg-remote.c"
		GgitRemoteCallbacks* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = self->priv->d_proxy;
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp2_ = message;
#line 65 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_signal_emit_by_name (_tmp1_, "progress", _tmp2_);
#line 2759 "gitg-remote.c"
	}
}


static void gitg_remote_callbacks_real_transfer_progress (GgitRemoteCallbacks* base, GgitTransferProgress* stats) {
	GitgRemoteCallbacks * self;
	GitgRemoteCallbacksTransferProgress _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GgitRemoteCallbacks* _tmp3_ = NULL;
#line 69 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemoteCallbacks*) base;
#line 69 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (stats != NULL);
#line 71 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_transfer_progress;
#line 71 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0__target = self->priv->d_transfer_progress_target;
#line 71 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ != NULL) {
#line 2779 "gitg-remote.c"
		GitgRemoteCallbacksTransferProgress _tmp1_ = NULL;
		void* _tmp1__target = NULL;
		GgitTransferProgress* _tmp2_ = NULL;
#line 73 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = self->priv->d_transfer_progress;
#line 73 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1__target = self->priv->d_transfer_progress_target;
#line 73 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp2_ = stats;
#line 73 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ (_tmp2_, _tmp1__target);
#line 2791 "gitg-remote.c"
	}
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = self->priv->d_proxy;
#line 76 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp3_ != NULL) {
#line 2797 "gitg-remote.c"
		GgitRemoteCallbacks* _tmp4_ = NULL;
		GgitTransferProgress* _tmp5_ = NULL;
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp4_ = self->priv->d_proxy;
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp5_ = stats;
#line 78 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_signal_emit_by_name (_tmp4_, "transfer-progress", _tmp5_);
#line 2806 "gitg-remote.c"
	}
}


static void gitg_remote_callbacks_real_update_tips (GgitRemoteCallbacks* base, const gchar* refname, GgitOId* a, GgitOId* b) {
	GitgRemoteCallbacks * self;
	GitgRemote* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GgitOId* _tmp2_ = NULL;
	GgitOId* _tmp3_ = NULL;
	GgitRemoteCallbacks* _tmp4_ = NULL;
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemoteCallbacks*) base;
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (refname != NULL);
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (a != NULL);
#line 82 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_if_fail (b != NULL);
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_remote;
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = refname;
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = a;
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = b;
#line 84 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_signal_emit (_tmp0_, gitg_remote_signals[GITG_REMOTE_TIP_UPDATED_SIGNAL], 0, _tmp1_, _tmp2_, _tmp3_);
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = self->priv->d_proxy;
#line 86 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp4_ != NULL) {
#line 2840 "gitg-remote.c"
		GgitRemoteCallbacks* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GgitOId* _tmp7_ = NULL;
		GgitOId* _tmp8_ = NULL;
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp5_ = self->priv->d_proxy;
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp6_ = refname;
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp7_ = a;
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp8_ = b;
#line 88 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_signal_emit_by_name (_tmp5_, "update-tips", _tmp6_, _tmp7_, _tmp8_);
#line 2855 "gitg-remote.c"
	}
}


static void gitg_remote_callbacks_real_completion (GgitRemoteCallbacks* base, GgitRemoteCompletionType type) {
	GitgRemoteCallbacks * self;
	GgitRemoteCallbacks* _tmp0_ = NULL;
#line 92 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemoteCallbacks*) base;
#line 94 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_proxy;
#line 94 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp0_ != NULL) {
#line 2869 "gitg-remote.c"
		GgitRemoteCallbacks* _tmp1_ = NULL;
		GgitRemoteCompletionType _tmp2_ = 0;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp1_ = self->priv->d_proxy;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp2_ = type;
#line 96 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_signal_emit_by_name (_tmp1_, "completion", _tmp2_);
#line 2878 "gitg-remote.c"
	}
}


static GgitCred* gitg_remote_callbacks_real_credentials (GgitRemoteCallbacks* base, const gchar* url, const gchar* username_from_url, GgitCredtype allowed_types, GError** error) {
	GitgRemoteCallbacks * self;
	GgitCred* result = NULL;
	GgitCred* ret = NULL;
	GitgCredentialsProvider* provider = NULL;
	GitgRemote* _tmp0_ = NULL;
	GitgCredentialsProvider* _tmp1_ = NULL;
	GitgCredentialsProvider* _tmp2_ = NULL;
	GitgCredentialsProvider* _tmp3_ = NULL;
	GitgCredentialsProvider* _tmp4_ = NULL;
	gboolean _tmp12_ = FALSE;
	GgitCred* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = (GitgRemoteCallbacks*) base;
#line 100 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_return_val_if_fail (url != NULL, NULL);
#line 102 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	ret = NULL;
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp0_ = self->priv->d_remote;
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp1_ = gitg_remote_get_credentials_provider (_tmp0_);
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp2_ = _tmp1_;
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 104 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	provider = _tmp3_;
#line 106 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp4_ = provider;
#line 106 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp4_ != NULL) {
#line 2916 "gitg-remote.c"
		GgitCred* _tmp5_ = NULL;
		GitgCredentialsProvider* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GgitCredtype _tmp9_ = 0;
		GgitCred* _tmp10_ = NULL;
		GgitCred* _tmp11_ = NULL;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp6_ = provider;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp7_ = url;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp8_ = username_from_url;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp9_ = allowed_types;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp10_ = gitg_credentials_provider_credentials (_tmp6_, _tmp7_, _tmp8_, _tmp9_, &_inner_error_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp5_ = _tmp10_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_propagate_error (error, _inner_error_);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_object_unref0 (provider);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_object_unref0 (ret);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			return NULL;
#line 2946 "gitg-remote.c"
		}
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp11_ = _tmp5_;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp5_ = NULL;
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (ret);
#line 108 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		ret = _tmp11_;
#line 106 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (_tmp5_);
#line 2958 "gitg-remote.c"
	}
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_tmp13_ = ret;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp13_ == NULL) {
#line 2964 "gitg-remote.c"
		GgitRemoteCallbacks* _tmp14_ = NULL;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp14_ = self->priv->d_proxy;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp12_ = _tmp14_ != NULL;
#line 2970 "gitg-remote.c"
	} else {
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp12_ = FALSE;
#line 2974 "gitg-remote.c"
	}
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	if (_tmp12_) {
#line 2978 "gitg-remote.c"
		GgitCred* _tmp15_ = NULL;
		GgitRemoteCallbacks* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		GgitCredtype _tmp19_ = 0;
		GgitCred* _tmp20_ = NULL;
		GgitCred* _tmp21_ = NULL;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp16_ = self->priv->d_proxy;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp17_ = url;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp18_ = username_from_url;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp19_ = allowed_types;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp20_ = GGIT_REMOTE_CALLBACKS_GET_CLASS (_tmp16_)->credentials (_tmp16_, _tmp17_, _tmp18_, _tmp19_, &_inner_error_);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp15_ = _tmp20_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_propagate_error (error, _inner_error_);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_object_unref0 (provider);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			_g_object_unref0 (ret);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			return NULL;
#line 3008 "gitg-remote.c"
		}
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp21_ = _tmp15_;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_tmp15_ = NULL;
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (ret);
#line 113 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		ret = _tmp21_;
#line 111 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		_g_object_unref0 (_tmp15_);
#line 3020 "gitg-remote.c"
	}
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	result = ret;
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (provider);
#line 116 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	return result;
#line 3028 "gitg-remote.c"
}


static void gitg_remote_callbacks_class_init (GitgRemoteCallbacksClass * klass) {
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_callbacks_parent_class = g_type_class_peek_parent (klass);
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_type_class_add_private (klass, sizeof (GitgRemoteCallbacksPrivate));
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	((GgitRemoteCallbacksClass *) klass)->progress = gitg_remote_callbacks_real_progress;
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	((GgitRemoteCallbacksClass *) klass)->transfer_progress = gitg_remote_callbacks_real_transfer_progress;
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	((GgitRemoteCallbacksClass *) klass)->update_tips = gitg_remote_callbacks_real_update_tips;
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	((GgitRemoteCallbacksClass *) klass)->completion = gitg_remote_callbacks_real_completion;
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	((GgitRemoteCallbacksClass *) klass)->credentials = gitg_remote_callbacks_real_credentials;
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_remote_callbacks_finalize;
#line 3049 "gitg-remote.c"
}


static void gitg_remote_callbacks_instance_init (GitgRemoteCallbacks * self) {
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv = GITG_REMOTE_CALLBACKS_GET_PRIVATE (self);
#line 3056 "gitg-remote.c"
}


static void gitg_remote_callbacks_finalize (GObject * obj) {
	GitgRemoteCallbacks * self;
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_REMOTE_TYPE_CALLBACKS, GitgRemoteCallbacks);
#line 48 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (self->priv->d_remote);
#line 49 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (self->priv->d_proxy);
#line 52 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	(self->priv->d_transfer_progress_target_destroy_notify == NULL) ? NULL : (self->priv->d_transfer_progress_target_destroy_notify (self->priv->d_transfer_progress_target), NULL);
#line 52 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress = NULL;
#line 52 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress_target = NULL;
#line 52 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_transfer_progress_target_destroy_notify = NULL;
#line 46 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (gitg_remote_callbacks_parent_class)->finalize (obj);
#line 3078 "gitg-remote.c"
}


static GType gitg_remote_callbacks_get_type (void) {
	static volatile gsize gitg_remote_callbacks_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_remote_callbacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRemoteCallbacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remote_callbacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemoteCallbacks), 0, (GInstanceInitFunc) gitg_remote_callbacks_instance_init, NULL };
		GType gitg_remote_callbacks_type_id;
		gitg_remote_callbacks_type_id = g_type_register_static (ggit_remote_callbacks_get_type (), "GitgRemoteCallbacks", &g_define_type_info, 0);
		g_once_init_leave (&gitg_remote_callbacks_type_id__volatile, gitg_remote_callbacks_type_id);
	}
	return gitg_remote_callbacks_type_id__volatile;
}


static void gitg_remote_class_init (GitgRemoteClass * klass) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_parent_class = g_type_class_peek_parent (klass);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_type_class_add_private (klass, sizeof (GitgRemotePrivate));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	((GObjectClass *) klass)->dispose = gitg_remote_real_dispose;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_remote_get_property;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_remote_set_property;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_remote_finalize;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_TRANSFER_PROGRESS, g_param_spec_double ("transfer-progress", "transfer-progress", "transfer-progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_STATE, g_param_spec_enum ("state", "state", "state", GITG_TYPE_REMOTE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_FETCH_SPECS, g_param_spec_boxed ("fetch-specs", "fetch-specs", "fetch-specs", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_PUSH_SPECS, g_param_spec_boxed ("push-specs", "push-specs", "push-specs", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_REMOTE_CREDENTIALS_PROVIDER, g_param_spec_object ("credentials-provider", "credentials-provider", "credentials-provider", GITG_TYPE_CREDENTIALS_PROVIDER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	gitg_remote_signals[GITG_REMOTE_TIP_UPDATED_SIGNAL] = g_signal_new ("tip_updated", GITG_TYPE_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED, G_TYPE_NONE, 3, G_TYPE_STRING, ggit_oid_get_type (), ggit_oid_get_type ());
#line 3119 "gitg-remote.c"
}


static void gitg_remote_instance_init (GitgRemote * self) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv = GITG_REMOTE_GET_PRIVATE (self);
#line 3126 "gitg-remote.c"
}


static void gitg_remote_finalize (GObject * obj) {
	GitgRemote * self;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_REMOTE, GitgRemote);
#line 121 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_fetch_specs = (_vala_array_free (self->priv->d_fetch_specs, self->priv->d_fetch_specs_length1, (GDestroyNotify) g_free), NULL);
#line 122 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	self->priv->d_push_specs = (_vala_array_free (self->priv->d_push_specs, self->priv->d_push_specs_length1, (GDestroyNotify) g_free), NULL);
#line 126 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (self->priv->d_callbacks);
#line 431 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	_g_object_unref0 (self->priv->_credentials_provider);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	G_OBJECT_CLASS (gitg_remote_parent_class)->finalize (obj);
#line 3144 "gitg-remote.c"
}


GType gitg_remote_get_type (void) {
	static volatile gsize gitg_remote_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_remote_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgRemoteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_remote_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgRemote), 0, (GInstanceInitFunc) gitg_remote_instance_init, NULL };
		GType gitg_remote_type_id;
		gitg_remote_type_id = g_type_register_static (ggit_remote_get_type (), "GitgRemote", &g_define_type_info, 0);
		g_once_init_leave (&gitg_remote_type_id__volatile, gitg_remote_type_id);
	}
	return gitg_remote_type_id__volatile;
}


static void _vala_gitg_remote_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GitgRemote * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOTE, GitgRemote);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	switch (property_id) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_TRANSFER_PROGRESS:
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_value_set_double (value, gitg_remote_get_transfer_progress (self));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_STATE:
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_value_set_enum (value, gitg_remote_get_state (self));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_FETCH_SPECS:
#line 3179 "gitg-remote.c"
		{
			int length;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_value_take_boxed (value, gitg_remote_get_fetch_specs (self, &length));
#line 3184 "gitg-remote.c"
		}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_PUSH_SPECS:
#line 3190 "gitg-remote.c"
		{
			int length;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			g_value_take_boxed (value, gitg_remote_get_push_specs (self, &length));
#line 3195 "gitg-remote.c"
		}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_CREDENTIALS_PROVIDER:
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		g_value_set_object (value, gitg_remote_get_credentials_provider (self));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 3205 "gitg-remote.c"
		default:
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 3211 "gitg-remote.c"
	}
}


static void _vala_gitg_remote_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GitgRemote * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_REMOTE, GitgRemote);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
	switch (property_id) {
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_STATE:
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_set_state (self, g_value_get_enum (value));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_FETCH_SPECS:
#line 3229 "gitg-remote.c"
		{
			gpointer boxed;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			boxed = g_value_get_boxed (value);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_remote_set_fetch_specs (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
#line 3236 "gitg-remote.c"
		}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_PUSH_SPECS:
#line 3242 "gitg-remote.c"
		{
			gpointer boxed;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			boxed = g_value_get_boxed (value);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
			gitg_remote_set_push_specs (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
#line 3249 "gitg-remote.c"
		}
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		case GITG_REMOTE_CREDENTIALS_PROVIDER:
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		gitg_remote_set_credentials_provider (self, g_value_get_object (value));
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 3259 "gitg-remote.c"
		default:
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 44 "/home/jesse/dev/gitg/libgitg/gitg-remote.vala"
		break;
#line 3265 "gitg-remote.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



