/* Channel.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from Channel.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
typedef struct _DVBChannelPrivate DVBChannelPrivate;

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _DVBChannel {
	GObject parent_instance;
	DVBChannelPrivate * priv;
};

struct _DVBChannelClass {
	GObjectClass parent_class;
	gboolean (*is_valid) (DVBChannel* self);
	gboolean (*on_same_transport_stream) (DVBChannel* self, DVBChannel* channel);
	gboolean (*equals) (DVBChannel* self, DVBChannel* channel);
	void (*setup_dvb_source) (DVBChannel* self, GstElement* source);
	gchar* (*to_string) (DVBChannel* self);
};

struct _DVBChannelPrivate {
	guint _GroupId;
	gchar* _Name;
	guint _TransportStreamId;
	gchar* _Network;
	guint* _LogicalChannelNumber;
	guint _VideoPID;
	GeeList* _AudioPIDs;
	guint _Frequency;
	gboolean _Scrambled;
	DVBSchedule* schedule;
	guint sid;
	gboolean has_schedule;
};


static gpointer dvb_channel_parent_class = NULL;

GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_schedule_get_type (void) G_GNUC_CONST;
#define DVB_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL, DVBChannelPrivate))
enum  {
	DVB_CHANNEL_DUMMY_PROPERTY,
	DVB_CHANNEL_SID,
	DVB_CHANNEL_GROUP_ID,
	DVB_CHANNEL_NAME,
	DVB_CHANNEL_TRANSPORT_STREAM_ID,
	DVB_CHANNEL_NETWORK,
	DVB_CHANNEL_VIDEO_PID,
	DVB_CHANNEL_AUDIO_PI_DS,
	DVB_CHANNEL_FREQUENCY,
	DVB_CHANNEL_SCRAMBLED,
	DVB_CHANNEL_SCHEDULE,
	DVB_CHANNEL_URL
};
DVBChannel* dvb_channel_construct (GType object_type, guint group_id);
DVBChannel* dvb_channel_construct_without_schedule (GType object_type);
gchar* dvb_channel_get_audio_pids_string (DVBChannel* self);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
gboolean dvb_channel_is_radio (DVBChannel* self);
guint dvb_channel_get_VideoPID (DVBChannel* self);
gboolean dvb_channel_is_valid (DVBChannel* self);
static gboolean dvb_channel_real_is_valid (DVBChannel* self);
const gchar* dvb_channel_get_Name (DVBChannel* self);
guint dvb_channel_get_Frequency (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
static gboolean dvb_channel_real_on_same_transport_stream (DVBChannel* self, DVBChannel* channel);
gboolean dvb_channel_equals (DVBChannel* self, DVBChannel* channel);
static gboolean dvb_channel_real_equals (DVBChannel* self, DVBChannel* channel);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
static void dvb_channel_real_setup_dvb_source (DVBChannel* self, GstElement* source);
gchar* dvb_channel_to_string (DVBChannel* self);
static gchar* dvb_channel_real_to_string (DVBChannel* self);
void dvb_channel_set_Sid (DVBChannel* self, guint value);
DVBSchedule* dvb_schedule_new (DVBChannel* channel);
DVBSchedule* dvb_schedule_construct (GType object_type, DVBChannel* channel);
void dvb_schedule_restore (DVBSchedule* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_schedule_restore_finish (DVBSchedule* self, GAsyncResult* _res_);
guint dvb_channel_get_GroupId (DVBChannel* self);
static void dvb_channel_set_GroupId (DVBChannel* self, guint value);
void dvb_channel_set_Name (DVBChannel* self, const gchar* value);
guint dvb_channel_get_TransportStreamId (DVBChannel* self);
void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value);
const gchar* dvb_channel_get_Network (DVBChannel* self);
void dvb_channel_set_Network (DVBChannel* self, const gchar* value);
guint* dvb_channel_get_LogicalChannelNumber (DVBChannel* self);
void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value);
static guint* _uint_dup (guint* self);
void dvb_channel_set_VideoPID (DVBChannel* self, guint value);
void dvb_channel_set_AudioPIDs (DVBChannel* self, GeeList* value);
void dvb_channel_set_Frequency (DVBChannel* self, guint value);
gboolean dvb_channel_get_Scrambled (DVBChannel* self);
void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value);
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
gchar* dvb_channel_get_URL (DVBChannel* self);
gchar* dvb_rtsp_server_get_address (void);
gchar* dvb_utils_remove_nonalphanums (const gchar* text);
static GObject * dvb_channel_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_channel_finalize (GObject* obj);
static void _vala_dvb_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBChannel* dvb_channel_construct (GType object_type, guint group_id) {
	DVBChannel * self = NULL;
	guint _tmp0_;
	_tmp0_ = group_id;
	self = (DVBChannel*) g_object_new (object_type, "GroupId", _tmp0_, NULL);
	self->priv->has_schedule = TRUE;
	return self;
}


DVBChannel* dvb_channel_construct_without_schedule (GType object_type) {
	DVBChannel * self = NULL;
	self = (DVBChannel*) g_object_new (object_type, NULL);
	self->priv->has_schedule = FALSE;
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* dvb_channel_get_audio_pids_string (DVBChannel* self) {
	gchar* result = NULL;
	GString* _tmp0_;
	GString* apids;
	gint i;
	GString* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	apids = _tmp0_;
	i = 1;
	{
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		GeeList* _pid_list;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pid_size;
		gint _pid_index;
		_tmp1_ = self->priv->_AudioPIDs;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_pid_list = _tmp2_;
		_tmp3_ = _pid_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pid_size = _tmp5_;
		_pid_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			guint pid;
			gint _tmp12_;
			GeeList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp24_;
			_tmp6_ = _pid_index;
			_pid_index = _tmp6_ + 1;
			_tmp7_ = _pid_index;
			_tmp8_ = _pid_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _pid_list;
			_tmp10_ = _pid_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			pid = GPOINTER_TO_UINT (_tmp11_);
			_tmp12_ = i;
			_tmp13_ = self->priv->_AudioPIDs;
			_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp12_ == _tmp15_) {
				GString* _tmp16_;
				guint _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				_tmp16_ = apids;
				_tmp17_ = pid;
				_tmp18_ = g_strdup_printf ("%u", _tmp17_);
				_tmp19_ = _tmp18_;
				g_string_append (_tmp16_, _tmp19_);
				_g_free0 (_tmp19_);
			} else {
				GString* _tmp20_;
				guint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				_tmp20_ = apids;
				_tmp21_ = pid;
				_tmp22_ = g_strdup_printf ("%u,", _tmp21_);
				_tmp23_ = _tmp22_;
				g_string_append (_tmp20_, _tmp23_);
				_g_free0 (_tmp23_);
			}
			_tmp24_ = i;
			i = _tmp24_ + 1;
		}
		_g_object_unref0 (_pid_list);
	}
	_tmp25_ = apids;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (apids);
	return result;
}


gboolean dvb_channel_is_radio (DVBChannel* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_VideoPID;
	result = _tmp0_ == ((guint) 0);
	return result;
}


static gboolean dvb_channel_real_is_valid (DVBChannel* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp15_;
	_tmp3_ = self->priv->_Name;
	if (_tmp3_ != NULL) {
		guint _tmp4_;
		_tmp4_ = self->priv->_Frequency;
		_tmp2_ = _tmp4_ != ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		guint _tmp6_;
		guint _tmp7_;
		_tmp6_ = dvb_channel_get_Sid (self);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ != ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		gboolean _tmp9_ = FALSE;
		guint _tmp10_;
		gboolean _tmp14_;
		_tmp10_ = self->priv->_VideoPID;
		if (_tmp10_ != ((guint) 0)) {
			_tmp9_ = TRUE;
		} else {
			GeeList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp11_ = self->priv->_AudioPIDs;
			_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp9_ = _tmp13_ != 0;
		}
		_tmp14_ = _tmp9_;
		_tmp0_ = _tmp14_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp15_ = _tmp0_;
	result = _tmp15_;
	return result;
}


gboolean dvb_channel_is_valid (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_CHANNEL_GET_CLASS (self)->is_valid (self);
}


/**
         * @returns: TRUE if both channels are part of the same
         * transport stream (TS).
         *
         * Channels that are part of the same TS can be viewed/recorded
         * at the same time with a single device.
         */
static gboolean dvb_channel_real_on_same_transport_stream (DVBChannel* self, DVBChannel* channel) {
	gboolean result = FALSE;
	guint _tmp0_;
	DVBChannel* _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (channel != NULL, FALSE);
	_tmp0_ = self->priv->_Frequency;
	_tmp1_ = channel;
	_tmp2_ = _tmp1_->priv->_Frequency;
	result = _tmp0_ == _tmp2_;
	return result;
}


gboolean dvb_channel_on_same_transport_stream (DVBChannel* self, DVBChannel* channel) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_CHANNEL_GET_CLASS (self)->on_same_transport_stream (self, channel);
}


/**
         * @returns: TRUE of both channels are identical
         */
static gboolean dvb_channel_real_equals (DVBChannel* self, DVBChannel* channel) {
	gboolean result = FALSE;
	guint _tmp0_;
	DVBChannel* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (channel != NULL, FALSE);
	_tmp0_ = self->priv->sid;
	_tmp1_ = channel;
	_tmp2_ = dvb_channel_get_Sid (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp0_ == _tmp3_;
	return result;
}


gboolean dvb_channel_equals (DVBChannel* self, DVBChannel* channel) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_CHANNEL_GET_CLASS (self)->equals (self, channel);
}


/**
         * @source: Either dvbbasebin or dvbsrc
         *
         * Set properties of source so that the channel can be watched
         */
static void dvb_channel_real_setup_dvb_source (DVBChannel* self, GstElement* source) {
	g_critical ("Type `%s' does not implement abstract method `dvb_channel_setup_dvb_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source) {
	g_return_if_fail (self != NULL);
	DVB_CHANNEL_GET_CLASS (self)->setup_dvb_source (self, source);
}


static gchar* dvb_channel_real_to_string (DVBChannel* self) {
	g_critical ("Type `%s' does not implement abstract method `dvb_channel_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* dvb_channel_to_string (DVBChannel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_CHANNEL_GET_CLASS (self)->to_string (self);
}


guint dvb_channel_get_Sid (DVBChannel* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->sid;
	result = _tmp0_;
	return result;
}


void dvb_channel_set_Sid (DVBChannel* self, guint value) {
	guint _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->sid = _tmp0_;
	_tmp1_ = self->priv->has_schedule;
	if (_tmp1_) {
		DVBSchedule* _tmp2_;
		DVBSchedule* _tmp3_;
		_tmp2_ = dvb_schedule_new (self);
		_g_object_unref0 (self->priv->schedule);
		self->priv->schedule = _tmp2_;
		_tmp3_ = self->priv->schedule;
		dvb_schedule_restore (_tmp3_, NULL, NULL);
	}
	g_object_notify ((GObject *) self, "Sid");
}


guint dvb_channel_get_GroupId (DVBChannel* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_GroupId;
	result = _tmp0_;
	return result;
}


static void dvb_channel_set_GroupId (DVBChannel* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_GroupId = _tmp0_;
	g_object_notify ((GObject *) self, "GroupId");
}


const gchar* dvb_channel_get_Name (DVBChannel* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Name;
	result = _tmp0_;
	return result;
}


void dvb_channel_set_Name (DVBChannel* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_Name);
	self->priv->_Name = _tmp1_;
	g_object_notify ((GObject *) self, "Name");
}


guint dvb_channel_get_TransportStreamId (DVBChannel* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_TransportStreamId;
	result = _tmp0_;
	return result;
}


void dvb_channel_set_TransportStreamId (DVBChannel* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_TransportStreamId = _tmp0_;
	g_object_notify ((GObject *) self, "TransportStreamId");
}


const gchar* dvb_channel_get_Network (DVBChannel* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_Network;
	result = _tmp0_;
	return result;
}


void dvb_channel_set_Network (DVBChannel* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_Network);
	self->priv->_Network = _tmp1_;
	g_object_notify ((GObject *) self, "Network");
}


guint* dvb_channel_get_LogicalChannelNumber (DVBChannel* self) {
	guint* result;
	guint* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_LogicalChannelNumber;
	result = _tmp0_;
	return result;
}


static guint* _uint_dup (guint* self) {
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}


static gpointer __uint_dup0 (gpointer self) {
	return self ? _uint_dup (self) : NULL;
}


void dvb_channel_set_LogicalChannelNumber (DVBChannel* self, guint* value) {
	guint* _tmp0_;
	guint* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __uint_dup0 (_tmp0_);
	_g_free0 (self->priv->_LogicalChannelNumber);
	self->priv->_LogicalChannelNumber = _tmp1_;
}


guint dvb_channel_get_VideoPID (DVBChannel* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_VideoPID;
	result = _tmp0_;
	return result;
}


void dvb_channel_set_VideoPID (DVBChannel* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_VideoPID = _tmp0_;
	g_object_notify ((GObject *) self, "VideoPID");
}


GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self) {
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_AudioPIDs;
	result = _tmp0_;
	return result;
}


void dvb_channel_set_AudioPIDs (DVBChannel* self, GeeList* value) {
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_AudioPIDs);
	self->priv->_AudioPIDs = _tmp1_;
	g_object_notify ((GObject *) self, "AudioPIDs");
}


guint dvb_channel_get_Frequency (DVBChannel* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Frequency;
	result = _tmp0_;
	return result;
}


void dvb_channel_set_Frequency (DVBChannel* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Frequency = _tmp0_;
	g_object_notify ((GObject *) self, "Frequency");
}


gboolean dvb_channel_get_Scrambled (DVBChannel* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_Scrambled;
	result = _tmp0_;
	return result;
}


void dvb_channel_set_Scrambled (DVBChannel* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Scrambled = _tmp0_;
	g_object_notify ((GObject *) self, "Scrambled");
}


DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self) {
	DVBSchedule* result;
	DVBSchedule* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->schedule;
	result = _tmp0_;
	return result;
}


gchar* dvb_channel_get_URL (DVBChannel* self) {
	gchar* result;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_rtsp_server_get_address ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_GroupId;
	_tmp3_ = dvb_channel_get_Sid (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_Name;
	_tmp6_ = dvb_utils_remove_nonalphanums (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("rtsp://%s:8554/%u/%u/%s", _tmp1_, _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp1_);
	result = _tmp9_;
	return result;
}


static GObject * dvb_channel_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBChannel * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	parent_class = G_OBJECT_CLASS (dvb_channel_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_CHANNEL (obj);
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	dvb_channel_set_AudioPIDs (self, (GeeList*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}


static void dvb_channel_class_init (DVBChannelClass * klass) {
	dvb_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelPrivate));
	DVB_CHANNEL_CLASS (klass)->is_valid = dvb_channel_real_is_valid;
	DVB_CHANNEL_CLASS (klass)->on_same_transport_stream = dvb_channel_real_on_same_transport_stream;
	DVB_CHANNEL_CLASS (klass)->equals = dvb_channel_real_equals;
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_channel_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_channel_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_channel_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SID, g_param_spec_uint ("Sid", "Sid", "Sid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_GROUP_ID, g_param_spec_uint ("GroupId", "GroupId", "GroupId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_TRANSPORT_STREAM_ID, g_param_spec_uint ("TransportStreamId", "TransportStreamId", "TransportStreamId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_NETWORK, g_param_spec_string ("Network", "Network", "Network", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_VIDEO_PID, g_param_spec_uint ("VideoPID", "VideoPID", "VideoPID", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_AUDIO_PI_DS, g_param_spec_object ("AudioPIDs", "AudioPIDs", "AudioPIDs", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_FREQUENCY, g_param_spec_uint ("Frequency", "Frequency", "Frequency", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SCRAMBLED, g_param_spec_boolean ("Scrambled", "Scrambled", "Scrambled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_SCHEDULE, g_param_spec_object ("Schedule", "Schedule", "Schedule", DVB_TYPE_SCHEDULE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_URL, g_param_spec_string ("URL", "URL", "URL", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void dvb_channel_instance_init (DVBChannel * self) {
	self->priv = DVB_CHANNEL_GET_PRIVATE (self);
}


static void dvb_channel_finalize (GObject* obj) {
	DVBChannel * self;
	self = DVB_CHANNEL (obj);
	_g_free0 (self->priv->_Name);
	_g_free0 (self->priv->_Network);
	_g_free0 (self->priv->_LogicalChannelNumber);
	_g_object_unref0 (self->priv->_AudioPIDs);
	_g_object_unref0 (self->priv->schedule);
	G_OBJECT_CLASS (dvb_channel_parent_class)->finalize (obj);
}


GType dvb_channel_get_type (void) {
	static volatile gsize dvb_channel_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannel), 0, (GInstanceInitFunc) dvb_channel_instance_init, NULL };
		GType dvb_channel_type_id;
		dvb_channel_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&dvb_channel_type_id__volatile, dvb_channel_type_id);
	}
	return dvb_channel_type_id__volatile;
}


static void _vala_dvb_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannel * self;
	self = DVB_CHANNEL (object);
	switch (property_id) {
		case DVB_CHANNEL_SID:
		g_value_set_uint (value, dvb_channel_get_Sid (self));
		break;
		case DVB_CHANNEL_GROUP_ID:
		g_value_set_uint (value, dvb_channel_get_GroupId (self));
		break;
		case DVB_CHANNEL_NAME:
		g_value_set_string (value, dvb_channel_get_Name (self));
		break;
		case DVB_CHANNEL_TRANSPORT_STREAM_ID:
		g_value_set_uint (value, dvb_channel_get_TransportStreamId (self));
		break;
		case DVB_CHANNEL_NETWORK:
		g_value_set_string (value, dvb_channel_get_Network (self));
		break;
		case DVB_CHANNEL_VIDEO_PID:
		g_value_set_uint (value, dvb_channel_get_VideoPID (self));
		break;
		case DVB_CHANNEL_AUDIO_PI_DS:
		g_value_set_object (value, dvb_channel_get_AudioPIDs (self));
		break;
		case DVB_CHANNEL_FREQUENCY:
		g_value_set_uint (value, dvb_channel_get_Frequency (self));
		break;
		case DVB_CHANNEL_SCRAMBLED:
		g_value_set_boolean (value, dvb_channel_get_Scrambled (self));
		break;
		case DVB_CHANNEL_SCHEDULE:
		g_value_set_object (value, dvb_channel_get_Schedule (self));
		break;
		case DVB_CHANNEL_URL:
		g_value_take_string (value, dvb_channel_get_URL (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannel * self;
	self = DVB_CHANNEL (object);
	switch (property_id) {
		case DVB_CHANNEL_SID:
		dvb_channel_set_Sid (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_GROUP_ID:
		dvb_channel_set_GroupId (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_NAME:
		dvb_channel_set_Name (self, g_value_get_string (value));
		break;
		case DVB_CHANNEL_TRANSPORT_STREAM_ID:
		dvb_channel_set_TransportStreamId (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_NETWORK:
		dvb_channel_set_Network (self, g_value_get_string (value));
		break;
		case DVB_CHANNEL_VIDEO_PID:
		dvb_channel_set_VideoPID (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_AUDIO_PI_DS:
		dvb_channel_set_AudioPIDs (self, g_value_get_object (value));
		break;
		case DVB_CHANNEL_FREQUENCY:
		dvb_channel_set_Frequency (self, g_value_get_uint (value));
		break;
		case DVB_CHANNEL_SCRAMBLED:
		dvb_channel_set_Scrambled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



