// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package directconnect_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/directconnect"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleDirectConnect_AllocateConnectionOnInterconnect() {
	svc := directconnect.New(session.New())

	params := &directconnect.AllocateConnectionOnInterconnectInput{
		Bandwidth:      aws.String("Bandwidth"),      // Required
		ConnectionName: aws.String("ConnectionName"), // Required
		InterconnectId: aws.String("InterconnectId"), // Required
		OwnerAccount:   aws.String("OwnerAccount"),   // Required
		Vlan:           aws.Int64(1),                 // Required
	}
	resp, err := svc.AllocateConnectionOnInterconnect(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_AllocatePrivateVirtualInterface() {
	svc := directconnect.New(session.New())

	params := &directconnect.AllocatePrivateVirtualInterfaceInput{
		ConnectionId: aws.String("ConnectionId"), // Required
		NewPrivateVirtualInterfaceAllocation: &directconnect.NewPrivateVirtualInterfaceAllocation{ // Required
			Asn:                  aws.Int64(1),                       // Required
			VirtualInterfaceName: aws.String("VirtualInterfaceName"), // Required
			Vlan:                 aws.Int64(1),                       // Required
			AmazonAddress:        aws.String("AmazonAddress"),
			AuthKey:              aws.String("BGPAuthKey"),
			CustomerAddress:      aws.String("CustomerAddress"),
		},
		OwnerAccount: aws.String("OwnerAccount"), // Required
	}
	resp, err := svc.AllocatePrivateVirtualInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_AllocatePublicVirtualInterface() {
	svc := directconnect.New(session.New())

	params := &directconnect.AllocatePublicVirtualInterfaceInput{
		ConnectionId: aws.String("ConnectionId"), // Required
		NewPublicVirtualInterfaceAllocation: &directconnect.NewPublicVirtualInterfaceAllocation{ // Required
			AmazonAddress:   aws.String("AmazonAddress"),   // Required
			Asn:             aws.Int64(1),                  // Required
			CustomerAddress: aws.String("CustomerAddress"), // Required
			RouteFilterPrefixes: []*directconnect.RouteFilterPrefix{ // Required
				{ // Required
					Cidr: aws.String("CIDR"),
				},
				// More values...
			},
			VirtualInterfaceName: aws.String("VirtualInterfaceName"), // Required
			Vlan:                 aws.Int64(1),                       // Required
			AuthKey:              aws.String("BGPAuthKey"),
		},
		OwnerAccount: aws.String("OwnerAccount"), // Required
	}
	resp, err := svc.AllocatePublicVirtualInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_ConfirmConnection() {
	svc := directconnect.New(session.New())

	params := &directconnect.ConfirmConnectionInput{
		ConnectionId: aws.String("ConnectionId"), // Required
	}
	resp, err := svc.ConfirmConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_ConfirmPrivateVirtualInterface() {
	svc := directconnect.New(session.New())

	params := &directconnect.ConfirmPrivateVirtualInterfaceInput{
		VirtualGatewayId:   aws.String("VirtualGatewayId"),   // Required
		VirtualInterfaceId: aws.String("VirtualInterfaceId"), // Required
	}
	resp, err := svc.ConfirmPrivateVirtualInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_ConfirmPublicVirtualInterface() {
	svc := directconnect.New(session.New())

	params := &directconnect.ConfirmPublicVirtualInterfaceInput{
		VirtualInterfaceId: aws.String("VirtualInterfaceId"), // Required
	}
	resp, err := svc.ConfirmPublicVirtualInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_CreateConnection() {
	svc := directconnect.New(session.New())

	params := &directconnect.CreateConnectionInput{
		Bandwidth:      aws.String("Bandwidth"),      // Required
		ConnectionName: aws.String("ConnectionName"), // Required
		Location:       aws.String("LocationCode"),   // Required
	}
	resp, err := svc.CreateConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_CreateInterconnect() {
	svc := directconnect.New(session.New())

	params := &directconnect.CreateInterconnectInput{
		Bandwidth:        aws.String("Bandwidth"),        // Required
		InterconnectName: aws.String("InterconnectName"), // Required
		Location:         aws.String("LocationCode"),     // Required
	}
	resp, err := svc.CreateInterconnect(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_CreatePrivateVirtualInterface() {
	svc := directconnect.New(session.New())

	params := &directconnect.CreatePrivateVirtualInterfaceInput{
		ConnectionId: aws.String("ConnectionId"), // Required
		NewPrivateVirtualInterface: &directconnect.NewPrivateVirtualInterface{ // Required
			Asn:                  aws.Int64(1),                       // Required
			VirtualGatewayId:     aws.String("VirtualGatewayId"),     // Required
			VirtualInterfaceName: aws.String("VirtualInterfaceName"), // Required
			Vlan:                 aws.Int64(1),                       // Required
			AmazonAddress:        aws.String("AmazonAddress"),
			AuthKey:              aws.String("BGPAuthKey"),
			CustomerAddress:      aws.String("CustomerAddress"),
		},
	}
	resp, err := svc.CreatePrivateVirtualInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_CreatePublicVirtualInterface() {
	svc := directconnect.New(session.New())

	params := &directconnect.CreatePublicVirtualInterfaceInput{
		ConnectionId: aws.String("ConnectionId"), // Required
		NewPublicVirtualInterface: &directconnect.NewPublicVirtualInterface{ // Required
			AmazonAddress:   aws.String("AmazonAddress"),   // Required
			Asn:             aws.Int64(1),                  // Required
			CustomerAddress: aws.String("CustomerAddress"), // Required
			RouteFilterPrefixes: []*directconnect.RouteFilterPrefix{ // Required
				{ // Required
					Cidr: aws.String("CIDR"),
				},
				// More values...
			},
			VirtualInterfaceName: aws.String("VirtualInterfaceName"), // Required
			Vlan:                 aws.Int64(1),                       // Required
			AuthKey:              aws.String("BGPAuthKey"),
		},
	}
	resp, err := svc.CreatePublicVirtualInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DeleteConnection() {
	svc := directconnect.New(session.New())

	params := &directconnect.DeleteConnectionInput{
		ConnectionId: aws.String("ConnectionId"), // Required
	}
	resp, err := svc.DeleteConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DeleteInterconnect() {
	svc := directconnect.New(session.New())

	params := &directconnect.DeleteInterconnectInput{
		InterconnectId: aws.String("InterconnectId"), // Required
	}
	resp, err := svc.DeleteInterconnect(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DeleteVirtualInterface() {
	svc := directconnect.New(session.New())

	params := &directconnect.DeleteVirtualInterfaceInput{
		VirtualInterfaceId: aws.String("VirtualInterfaceId"), // Required
	}
	resp, err := svc.DeleteVirtualInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DescribeConnections() {
	svc := directconnect.New(session.New())

	params := &directconnect.DescribeConnectionsInput{
		ConnectionId: aws.String("ConnectionId"),
	}
	resp, err := svc.DescribeConnections(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DescribeConnectionsOnInterconnect() {
	svc := directconnect.New(session.New())

	params := &directconnect.DescribeConnectionsOnInterconnectInput{
		InterconnectId: aws.String("InterconnectId"), // Required
	}
	resp, err := svc.DescribeConnectionsOnInterconnect(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DescribeInterconnects() {
	svc := directconnect.New(session.New())

	params := &directconnect.DescribeInterconnectsInput{
		InterconnectId: aws.String("InterconnectId"),
	}
	resp, err := svc.DescribeInterconnects(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DescribeLocations() {
	svc := directconnect.New(session.New())

	var params *directconnect.DescribeLocationsInput
	resp, err := svc.DescribeLocations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DescribeVirtualGateways() {
	svc := directconnect.New(session.New())

	var params *directconnect.DescribeVirtualGatewaysInput
	resp, err := svc.DescribeVirtualGateways(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleDirectConnect_DescribeVirtualInterfaces() {
	svc := directconnect.New(session.New())

	params := &directconnect.DescribeVirtualInterfacesInput{
		ConnectionId:       aws.String("ConnectionId"),
		VirtualInterfaceId: aws.String("VirtualInterfaceId"),
	}
	resp, err := svc.DescribeVirtualInterfaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
