// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/datatransfer/v1/transfer.proto

package datatransfer

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/struct"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/rpc/status"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Represents data transfer type.
type TransferType int32

const (
	// Invalid or Unknown transfer type placeholder.
	TransferType_TRANSFER_TYPE_UNSPECIFIED TransferType = 0
	// Batch data transfer.
	TransferType_BATCH TransferType = 1
	// Streaming data transfer. Streaming data source currently doesn't
	// support multiple transfer configs per project.
	TransferType_STREAMING TransferType = 2
)

var TransferType_name = map[int32]string{
	0: "TRANSFER_TYPE_UNSPECIFIED",
	1: "BATCH",
	2: "STREAMING",
}
var TransferType_value = map[string]int32{
	"TRANSFER_TYPE_UNSPECIFIED": 0,
	"BATCH":                     1,
	"STREAMING":                 2,
}

func (x TransferType) String() string {
	return proto.EnumName(TransferType_name, int32(x))
}
func (TransferType) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

// Represents data transfer run state.
type TransferState int32

const (
	// State placeholder.
	TransferState_TRANSFER_STATE_UNSPECIFIED TransferState = 0
	// Data transfer is inactive.
	TransferState_INACTIVE TransferState = 1
	// Data transfer is scheduled and is waiting to be picked up by
	// data transfer backend.
	TransferState_PENDING TransferState = 2
	// Data transfer is in progress.
	TransferState_RUNNING TransferState = 3
	// Data transfer completed successsfully.
	TransferState_SUCCEEDED TransferState = 4
	// Data transfer failed.
	TransferState_FAILED TransferState = 5
	// Data transfer is cancelled.
	TransferState_CANCELLED TransferState = 6
)

var TransferState_name = map[int32]string{
	0: "TRANSFER_STATE_UNSPECIFIED",
	1: "INACTIVE",
	2: "PENDING",
	3: "RUNNING",
	4: "SUCCEEDED",
	5: "FAILED",
	6: "CANCELLED",
}
var TransferState_value = map[string]int32{
	"TRANSFER_STATE_UNSPECIFIED": 0,
	"INACTIVE":                   1,
	"PENDING":                    2,
	"RUNNING":                    3,
	"SUCCEEDED":                  4,
	"FAILED":                     5,
	"CANCELLED":                  6,
}

func (x TransferState) String() string {
	return proto.EnumName(TransferState_name, int32(x))
}
func (TransferState) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

// Represents data transfer user facing message severity.
type TransferMessage_MessageSeverity int32

const (
	// No severity specified.
	TransferMessage_MESSAGE_SEVERITY_UNSPECIFIED TransferMessage_MessageSeverity = 0
	// Informational message.
	TransferMessage_INFO TransferMessage_MessageSeverity = 1
	// Warning message.
	TransferMessage_WARNING TransferMessage_MessageSeverity = 2
	// Error message.
	TransferMessage_ERROR TransferMessage_MessageSeverity = 3
)

var TransferMessage_MessageSeverity_name = map[int32]string{
	0: "MESSAGE_SEVERITY_UNSPECIFIED",
	1: "INFO",
	2: "WARNING",
	3: "ERROR",
}
var TransferMessage_MessageSeverity_value = map[string]int32{
	"MESSAGE_SEVERITY_UNSPECIFIED": 0,
	"INFO":    1,
	"WARNING": 2,
	"ERROR":   3,
}

func (x TransferMessage_MessageSeverity) String() string {
	return proto.EnumName(TransferMessage_MessageSeverity_name, int32(x))
}
func (TransferMessage_MessageSeverity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor1, []int{2, 0}
}

// Represents a data transfer configuration. A transfer configuration
// contains all metadata needed to perform a data transfer. For example,
// `destination_dataset_id` specifies where data should be stored.
// When a new transfer configuration is created, the specified
// `destination_dataset_id` is created when needed and shared with the
// appropriate data source service account.
type TransferConfig struct {
	// The resource name of the transfer config.
	// Transfer config names have the form
	// `projects/{project_id}/transferConfigs/{config_id}`.
	// Where `config_id` is usually a uuid, even though it is not
	// guaranteed or required. The name is ignored when creating a transfer
	// config.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The BigQuery target dataset id.
	DestinationDatasetId string `protobuf:"bytes,2,opt,name=destination_dataset_id,json=destinationDatasetId" json:"destination_dataset_id,omitempty"`
	// User specified display name for the data transfer.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
	// Data source id. Cannot be changed once data transfer is created.
	DataSourceId string `protobuf:"bytes,5,opt,name=data_source_id,json=dataSourceId" json:"data_source_id,omitempty"`
	// Data transfer specific parameters.
	Params *google_protobuf1.Struct `protobuf:"bytes,9,opt,name=params" json:"params,omitempty"`
	// Data transfer schedule.
	// If the data source does not support a custom schedule, this should be
	// empty. If it is empty, the default value for the data source will be
	// used.
	// The specified times are in UTC.
	// Examples of valid format:
	// `1st,3rd monday of month 15:30`,
	// `every wed,fri of jan,jun 13:15`, and
	// `first sunday of quarter 00:00`.
	// See more explanation about the format here:
	// https://cloud.google.com/appengine/docs/flexible/python/scheduling-jobs-with-cron-yaml#the_schedule_format
	// NOTE: the granularity should be at least 8 hours, or less frequent.
	Schedule string `protobuf:"bytes,7,opt,name=schedule" json:"schedule,omitempty"`
	// The number of days to look back to automatically refresh the data.
	// For example, if `data_refresh_window_days = 10`, then every day
	// BigQuery reingests data for [today-10, today-1], rather than ingesting data
	// for just [today-1].
	// Only valid if the data source supports the feature. Set the value to  0
	// to use the default value.
	DataRefreshWindowDays int32 `protobuf:"varint,12,opt,name=data_refresh_window_days,json=dataRefreshWindowDays" json:"data_refresh_window_days,omitempty"`
	// Is this config disabled. When set to true, no runs are scheduled
	// for a given transfer.
	Disabled bool `protobuf:"varint,13,opt,name=disabled" json:"disabled,omitempty"`
	// Output only. Data transfer modification time. Ignored by server on input.
	UpdateTime *google_protobuf2.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
	// Output only. Next time when data transfer will run.
	NextRunTime *google_protobuf2.Timestamp `protobuf:"bytes,8,opt,name=next_run_time,json=nextRunTime" json:"next_run_time,omitempty"`
	// Output only. State of the most recently updated transfer run.
	State TransferState `protobuf:"varint,10,opt,name=state,enum=google.cloud.bigquery.datatransfer.v1.TransferState" json:"state,omitempty"`
	// Output only. Unique ID of the user on whose behalf transfer is done.
	// Applicable only to data sources that do not support service accounts.
	// When set to 0, the data source service account credentials are used.
	UserId int64 `protobuf:"varint,11,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// Output only. Region in which BigQuery dataset is located.
	DatasetRegion string `protobuf:"bytes,14,opt,name=dataset_region,json=datasetRegion" json:"dataset_region,omitempty"`
}

func (m *TransferConfig) Reset()                    { *m = TransferConfig{} }
func (m *TransferConfig) String() string            { return proto.CompactTextString(m) }
func (*TransferConfig) ProtoMessage()               {}
func (*TransferConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *TransferConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TransferConfig) GetDestinationDatasetId() string {
	if m != nil {
		return m.DestinationDatasetId
	}
	return ""
}

func (m *TransferConfig) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *TransferConfig) GetDataSourceId() string {
	if m != nil {
		return m.DataSourceId
	}
	return ""
}

func (m *TransferConfig) GetParams() *google_protobuf1.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *TransferConfig) GetSchedule() string {
	if m != nil {
		return m.Schedule
	}
	return ""
}

func (m *TransferConfig) GetDataRefreshWindowDays() int32 {
	if m != nil {
		return m.DataRefreshWindowDays
	}
	return 0
}

func (m *TransferConfig) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *TransferConfig) GetUpdateTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *TransferConfig) GetNextRunTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.NextRunTime
	}
	return nil
}

func (m *TransferConfig) GetState() TransferState {
	if m != nil {
		return m.State
	}
	return TransferState_TRANSFER_STATE_UNSPECIFIED
}

func (m *TransferConfig) GetUserId() int64 {
	if m != nil {
		return m.UserId
	}
	return 0
}

func (m *TransferConfig) GetDatasetRegion() string {
	if m != nil {
		return m.DatasetRegion
	}
	return ""
}

// Represents a data transfer run.
// Next id: 23
type TransferRun struct {
	// The resource name of the transfer run.
	// Transfer run names have the form
	// `projects/{project_id}/locations/{location}/transferConfigs/{config_id}/runs/{run_id}`.
	// The name is ignored when creating a transfer run.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The BigQuery target dataset id.
	DestinationDatasetId string `protobuf:"bytes,2,opt,name=destination_dataset_id,json=destinationDatasetId" json:"destination_dataset_id,omitempty"`
	// Minimum time after which a transfer run can be started.
	ScheduleTime *google_protobuf2.Timestamp `protobuf:"bytes,3,opt,name=schedule_time,json=scheduleTime" json:"schedule_time,omitempty"`
	// Data transfer specific parameters.
	Params *google_protobuf1.Struct `protobuf:"bytes,9,opt,name=params" json:"params,omitempty"`
	// For batch transfer runs, specifies the date and time that
	// data should be ingested.
	RunTime *google_protobuf2.Timestamp `protobuf:"bytes,10,opt,name=run_time,json=runTime" json:"run_time,omitempty"`
	// Output only. Time when transfer run was started.
	// Parameter ignored by server for input requests.
	StartTime *google_protobuf2.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Output only. Time when transfer run ended.
	// Parameter ignored by server for input requests.
	EndTime *google_protobuf2.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Output only. Last time the data transfer run state was updated.
	UpdateTime *google_protobuf2.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
	// Output only. Data source id.
	DataSourceId string `protobuf:"bytes,7,opt,name=data_source_id,json=dataSourceId" json:"data_source_id,omitempty"`
	// Data transfer run state. Ignored for input requests.
	State TransferState `protobuf:"varint,8,opt,name=state,enum=google.cloud.bigquery.datatransfer.v1.TransferState" json:"state,omitempty"`
	// Output only. Unique ID of the user on whose behalf transfer is done.
	// Applicable only to data sources that do not support service accounts.
	// When set to 0, the data source service account credentials are used.
	// May be negative.
	UserId int64 `protobuf:"varint,11,opt,name=user_id,json=userId" json:"user_id,omitempty"`
	// Output only. Describes the schedule of this transfer run if it was
	// created as part of a regular schedule. For batch transfer runs that are
	// scheduled manually, this is empty.
	// NOTE: the system might choose to delay the schedule depending on the
	// current load, so `schedule_time` doesn't always matches this.
	Schedule string `protobuf:"bytes,12,opt,name=schedule" json:"schedule,omitempty"`
}

func (m *TransferRun) Reset()                    { *m = TransferRun{} }
func (m *TransferRun) String() string            { return proto.CompactTextString(m) }
func (*TransferRun) ProtoMessage()               {}
func (*TransferRun) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *TransferRun) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TransferRun) GetDestinationDatasetId() string {
	if m != nil {
		return m.DestinationDatasetId
	}
	return ""
}

func (m *TransferRun) GetScheduleTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.ScheduleTime
	}
	return nil
}

func (m *TransferRun) GetParams() *google_protobuf1.Struct {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *TransferRun) GetRunTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.RunTime
	}
	return nil
}

func (m *TransferRun) GetStartTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TransferRun) GetEndTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *TransferRun) GetUpdateTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *TransferRun) GetDataSourceId() string {
	if m != nil {
		return m.DataSourceId
	}
	return ""
}

func (m *TransferRun) GetState() TransferState {
	if m != nil {
		return m.State
	}
	return TransferState_TRANSFER_STATE_UNSPECIFIED
}

func (m *TransferRun) GetUserId() int64 {
	if m != nil {
		return m.UserId
	}
	return 0
}

func (m *TransferRun) GetSchedule() string {
	if m != nil {
		return m.Schedule
	}
	return ""
}

// Represents a user facing message for a particular data transfer run.
type TransferMessage struct {
	// Time when message was logged.
	MessageTime *google_protobuf2.Timestamp `protobuf:"bytes,1,opt,name=message_time,json=messageTime" json:"message_time,omitempty"`
	// Message severity.
	Severity TransferMessage_MessageSeverity `protobuf:"varint,2,opt,name=severity,enum=google.cloud.bigquery.datatransfer.v1.TransferMessage_MessageSeverity" json:"severity,omitempty"`
	// Message text.
	MessageText string `protobuf:"bytes,3,opt,name=message_text,json=messageText" json:"message_text,omitempty"`
}

func (m *TransferMessage) Reset()                    { *m = TransferMessage{} }
func (m *TransferMessage) String() string            { return proto.CompactTextString(m) }
func (*TransferMessage) ProtoMessage()               {}
func (*TransferMessage) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *TransferMessage) GetMessageTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.MessageTime
	}
	return nil
}

func (m *TransferMessage) GetSeverity() TransferMessage_MessageSeverity {
	if m != nil {
		return m.Severity
	}
	return TransferMessage_MESSAGE_SEVERITY_UNSPECIFIED
}

func (m *TransferMessage) GetMessageText() string {
	if m != nil {
		return m.MessageText
	}
	return ""
}

func init() {
	proto.RegisterType((*TransferConfig)(nil), "google.cloud.bigquery.datatransfer.v1.TransferConfig")
	proto.RegisterType((*TransferRun)(nil), "google.cloud.bigquery.datatransfer.v1.TransferRun")
	proto.RegisterType((*TransferMessage)(nil), "google.cloud.bigquery.datatransfer.v1.TransferMessage")
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.TransferType", TransferType_name, TransferType_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.TransferState", TransferState_name, TransferState_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.TransferMessage_MessageSeverity", TransferMessage_MessageSeverity_name, TransferMessage_MessageSeverity_value)
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/datatransfer/v1/transfer.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 910 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0xdf, 0x6e, 0xe3, 0xc4,
	0x17, 0xfe, 0xb9, 0xf9, 0x7f, 0xf2, 0x67, 0xa3, 0xd1, 0x0f, 0x6a, 0xaa, 0x05, 0x42, 0x45, 0xa5,
	0xb0, 0x17, 0xb6, 0x5a, 0xba, 0x42, 0x68, 0x05, 0x28, 0x71, 0x9c, 0x60, 0xb4, 0xf5, 0x66, 0xc7,
	0x6e, 0x57, 0x8b, 0x2a, 0x59, 0x93, 0x78, 0xea, 0xb5, 0x94, 0xd8, 0xc1, 0x33, 0xee, 0x36, 0x97,
	0xbc, 0x0a, 0x97, 0x5c, 0xf0, 0x20, 0x5c, 0x70, 0xc9, 0x2b, 0xf0, 0x1a, 0x68, 0xc6, 0x76, 0x94,
	0xcd, 0x22, 0xa5, 0x95, 0xe0, 0x2a, 0x9e, 0x73, 0xbe, 0xef, 0x9b, 0x6f, 0xce, 0x39, 0x33, 0x81,
	0xf3, 0x20, 0x8e, 0x83, 0x05, 0xd5, 0xe7, 0x8b, 0x38, 0xf5, 0xf5, 0x59, 0x18, 0xfc, 0x94, 0xd2,
	0x64, 0xad, 0xfb, 0x84, 0x13, 0x9e, 0x90, 0x88, 0xdd, 0xd0, 0x44, 0xbf, 0x3d, 0xd5, 0x8b, 0x6f,
	0x6d, 0x95, 0xc4, 0x3c, 0x46, 0x27, 0x19, 0x4b, 0x93, 0x2c, 0xad, 0x60, 0x69, 0xdb, 0x2c, 0xed,
	0xf6, 0xf4, 0xe8, 0x71, 0x2e, 0x4e, 0x56, 0xa1, 0x4e, 0xa2, 0x28, 0xe6, 0x84, 0x87, 0x71, 0xc4,
	0x32, 0x91, 0x4d, 0x56, 0xae, 0x66, 0xe9, 0x8d, 0xce, 0x78, 0x92, 0xce, 0x79, 0x9e, 0xfd, 0x74,
	0x37, 0xcb, 0xc3, 0x25, 0x65, 0x9c, 0x2c, 0x57, 0x39, 0xe0, 0x30, 0x07, 0x24, 0xab, 0xb9, 0xce,
	0x38, 0xe1, 0x69, 0xae, 0x7b, 0xfc, 0x47, 0x19, 0x3a, 0x6e, 0xee, 0xc2, 0x88, 0xa3, 0x9b, 0x30,
	0x40, 0x08, 0xca, 0x11, 0x59, 0x52, 0x55, 0xe9, 0x29, 0xfd, 0x06, 0x96, 0xdf, 0xe8, 0x1c, 0x3e,
	0xf4, 0x29, 0xe3, 0x61, 0x24, 0x4d, 0x79, 0xc2, 0x3b, 0xa3, 0xdc, 0x0b, 0x7d, 0xf5, 0x40, 0xa2,
	0xfe, 0xbf, 0x95, 0x1d, 0x65, 0x49, 0xcb, 0x47, 0x9f, 0x41, 0xcb, 0x0f, 0xd9, 0x6a, 0x41, 0xd6,
	0x9e, 0x54, 0x2c, 0x49, 0x6c, 0x33, 0x8f, 0xd9, 0x42, 0xf8, 0x73, 0xe8, 0x08, 0x31, 0x8f, 0xc5,
	0x69, 0x32, 0xa7, 0x42, 0xb0, 0x22, 0x41, 0x2d, 0x11, 0x75, 0x64, 0xd0, 0xf2, 0x91, 0x0e, 0xd5,
	0x15, 0x49, 0xc8, 0x92, 0xa9, 0x8d, 0x9e, 0xd2, 0x6f, 0x9e, 0x1d, 0x6a, 0x79, 0x4d, 0x8b, 0x03,
	0x6b, 0x8e, 0x2c, 0x07, 0xce, 0x61, 0xe8, 0x08, 0xea, 0x6c, 0xfe, 0x86, 0xfa, 0xe9, 0x82, 0xaa,
	0x35, 0x29, 0xb8, 0x59, 0xa3, 0xaf, 0x40, 0x95, 0x5b, 0x26, 0xf4, 0x26, 0xa1, 0xec, 0x8d, 0xf7,
	0x36, 0x8c, 0xfc, 0xf8, 0xad, 0xe7, 0x93, 0x35, 0x53, 0x5b, 0x3d, 0xa5, 0x5f, 0xc1, 0x1f, 0x88,
	0x3c, 0xce, 0xd2, 0xaf, 0x64, 0x76, 0x44, 0xd6, 0x52, 0xd4, 0x0f, 0x19, 0x99, 0x2d, 0xa8, 0xaf,
	0xb6, 0x7b, 0x4a, 0xbf, 0x8e, 0x37, 0x6b, 0xf4, 0x0c, 0x9a, 0xe9, 0xca, 0x27, 0x9c, 0x7a, 0xa2,
	0xf4, 0x6a, 0x59, 0xda, 0x3c, 0x7a, 0xcf, 0xa6, 0x5b, 0xf4, 0x05, 0x43, 0x06, 0x17, 0x01, 0xf4,
	0x2d, 0xb4, 0x23, 0x7a, 0xc7, 0xbd, 0x24, 0x8d, 0x32, 0x7a, 0x7d, 0x2f, 0xbd, 0x29, 0x08, 0x38,
	0x8d, 0x24, 0xff, 0x07, 0xa8, 0x88, 0xa6, 0x52, 0x15, 0x7a, 0x4a, 0xbf, 0x73, 0x76, 0xae, 0xdd,
	0x6b, 0xe2, 0xb4, 0xa2, 0xef, 0x8e, 0xe0, 0xe2, 0x4c, 0x02, 0x1d, 0x42, 0x2d, 0x65, 0x34, 0x11,
	0x9d, 0x68, 0xf6, 0x94, 0x7e, 0x09, 0x57, 0xc5, 0xd2, 0xf2, 0xd1, 0x49, 0xd6, 0x29, 0xd1, 0xf6,
	0x84, 0x06, 0x61, 0x1c, 0xa9, 0x1d, 0x59, 0xd8, 0x76, 0x1e, 0xc5, 0x32, 0x78, 0xfc, 0x67, 0x19,
	0x9a, 0x85, 0x30, 0x4e, 0xa3, 0x7f, 0x71, 0x9a, 0xbe, 0x83, 0x76, 0xd1, 0xc3, 0xac, 0x4a, 0xa5,
	0xbd, 0x55, 0x6a, 0x15, 0x04, 0x59, 0xa6, 0x07, 0x4f, 0xd1, 0x53, 0xa8, 0x6f, 0x5a, 0x02, 0x7b,
	0x37, 0xab, 0x25, 0x79, 0x3b, 0xbe, 0x06, 0x60, 0x9c, 0x24, 0xfc, 0xbe, 0xa3, 0xd0, 0x90, 0x68,
	0x49, 0x7d, 0x0a, 0x75, 0x1a, 0xf9, 0x19, 0xb1, 0xb2, 0x7f, 0x47, 0x1a, 0xf9, 0x92, 0xb6, 0x33,
	0x7d, 0xd5, 0x07, 0x4d, 0xdf, 0xfb, 0x57, 0xb0, 0xf6, 0x0f, 0x57, 0x70, 0x33, 0x63, 0xf5, 0xff,
	0x70, 0xc6, 0xb6, 0xaf, 0x6d, 0xeb, 0xdd, 0x6b, 0x7b, 0xfc, 0xdb, 0x01, 0x3c, 0x2a, 0xd4, 0x2e,
	0x28, 0x63, 0x24, 0xa0, 0xe8, 0x1b, 0x68, 0x2d, 0xb3, 0xcf, 0xec, 0xe0, 0xca, 0xfe, 0x7b, 0x93,
	0xe3, 0xe5, 0xc9, 0x67, 0x50, 0x67, 0xf4, 0x96, 0x26, 0x21, 0x5f, 0xcb, 0xc9, 0xeb, 0x9c, 0x8d,
	0x1f, 0x78, 0xac, 0xdc, 0x88, 0x96, 0xff, 0x3a, 0xb9, 0x1a, 0xde, 0xe8, 0x8a, 0x37, 0x70, 0x63,
	0x91, 0xde, 0xf1, 0xe2, 0x0d, 0x2c, 0x6c, 0xd0, 0x3b, 0x7e, 0x7c, 0x09, 0x8f, 0x76, 0xf8, 0xa8,
	0x07, 0x8f, 0x2f, 0x4c, 0xc7, 0x19, 0x4c, 0x4c, 0xcf, 0x31, 0xaf, 0x4c, 0x6c, 0xb9, 0xaf, 0xbd,
	0x4b, 0xdb, 0x99, 0x9a, 0x86, 0x35, 0xb6, 0xcc, 0x51, 0xf7, 0x7f, 0xa8, 0x0e, 0x65, 0xcb, 0x1e,
	0xbf, 0xe8, 0x2a, 0xa8, 0x09, 0xb5, 0x57, 0x03, 0x6c, 0x5b, 0xf6, 0xa4, 0x7b, 0x80, 0x1a, 0x50,
	0x31, 0x31, 0x7e, 0x81, 0xbb, 0xa5, 0x27, 0x13, 0x68, 0x15, 0x36, 0xdd, 0xf5, 0x8a, 0xa2, 0x8f,
	0xe1, 0x23, 0x17, 0x0f, 0x6c, 0x67, 0x6c, 0x62, 0xcf, 0x7d, 0x3d, 0x35, 0x77, 0x04, 0x1b, 0x50,
	0x19, 0x0e, 0x5c, 0xe3, 0xfb, 0xae, 0x82, 0xda, 0xd0, 0x70, 0x5c, 0x6c, 0x0e, 0x2e, 0xa4, 0xe6,
	0x93, 0x9f, 0x15, 0x68, 0xbf, 0xd3, 0x47, 0xf4, 0x09, 0x1c, 0x6d, 0xa4, 0x1c, 0x77, 0xe0, 0xee,
	0x6a, 0xb5, 0xa0, 0x6e, 0xd9, 0x03, 0xc3, 0xb5, 0xae, 0xcc, 0xcc, 0xe0, 0xd4, 0xb4, 0x47, 0x99,
	0xc1, 0x26, 0xd4, 0xf0, 0xa5, 0x2d, 0xdd, 0x96, 0xe4, 0x46, 0x97, 0x86, 0x61, 0x9a, 0x23, 0x73,
	0xd4, 0x2d, 0x23, 0x80, 0xea, 0x78, 0x60, 0x3d, 0x37, 0x47, 0xdd, 0x8a, 0x48, 0x19, 0x03, 0xdb,
	0x30, 0x9f, 0x8b, 0x65, 0x75, 0xf8, 0x97, 0x02, 0x5f, 0xcc, 0xe3, 0xe5, 0xfd, 0xda, 0x33, 0xdc,
	0xd8, 0x9d, 0x8a, 0x09, 0x98, 0x2a, 0x3f, 0xbe, 0xcc, 0x79, 0x41, 0xbc, 0x20, 0x51, 0xa0, 0xc5,
	0x49, 0xa0, 0x07, 0x34, 0x92, 0xf3, 0xa1, 0x67, 0x29, 0xb2, 0x0a, 0xd9, 0x9e, 0x3f, 0xf6, 0x67,
	0xdb, 0xeb, 0x5f, 0x0e, 0x2a, 0x13, 0x63, 0x38, 0x72, 0x7f, 0x3d, 0x38, 0x99, 0x64, 0xda, 0x86,
	0xf4, 0x34, 0x0c, 0x83, 0x97, 0xd2, 0x93, 0x78, 0xb8, 0x0a, 0x1b, 0xda, 0xd5, 0xe9, 0xef, 0x05,
	0xee, 0x5a, 0xe2, 0xae, 0x0b, 0xdc, 0xf5, 0x36, 0xee, 0xfa, 0xea, 0x74, 0x56, 0x95, 0xae, 0xbe,
	0xfc, 0x3b, 0x00, 0x00, 0xff, 0xff, 0xf0, 0xc4, 0x0e, 0x43, 0x6d, 0x08, 0x00, 0x00,
}
